package Google::Ads::AdWords::v201502::CriterionPolicyError;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201502' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201502::PolicyViolationError);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %fieldPath_of :ATTR(:get<fieldPath>);
my %trigger_of :ATTR(:get<trigger>);
my %errorString_of :ATTR(:get<errorString>);
my %ApiError__Type_of :ATTR(:get<ApiError__Type>);
my %key_of :ATTR(:get<key>);
my %externalPolicyName_of :ATTR(:get<externalPolicyName>);
my %externalPolicyUrl_of :ATTR(:get<externalPolicyUrl>);
my %externalPolicyDescription_of :ATTR(:get<externalPolicyDescription>);
my %isExemptable_of :ATTR(:get<isExemptable>);
my %violatingParts_of :ATTR(:get<violatingParts>);

__PACKAGE__->_factory(
    [ qw(        fieldPath
        trigger
        errorString
        ApiError__Type
        key
        externalPolicyName
        externalPolicyUrl
        externalPolicyDescription
        isExemptable
        violatingParts

    ) ],
    {
        'fieldPath' => \%fieldPath_of,
        'trigger' => \%trigger_of,
        'errorString' => \%errorString_of,
        'ApiError__Type' => \%ApiError__Type_of,
        'key' => \%key_of,
        'externalPolicyName' => \%externalPolicyName_of,
        'externalPolicyUrl' => \%externalPolicyUrl_of,
        'externalPolicyDescription' => \%externalPolicyDescription_of,
        'isExemptable' => \%isExemptable_of,
        'violatingParts' => \%violatingParts_of,
    },
    {
        'fieldPath' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'trigger' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'errorString' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'ApiError__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'key' => 'Google::Ads::AdWords::v201502::PolicyViolationKey',
        'externalPolicyName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'externalPolicyUrl' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'externalPolicyDescription' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'isExemptable' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'violatingParts' => 'Google::Ads::AdWords::v201502::PolicyViolationError::Part',
    },
    {

        'fieldPath' => 'fieldPath',
        'trigger' => 'trigger',
        'errorString' => 'errorString',
        'ApiError__Type' => 'ApiError.Type',
        'key' => 'key',
        'externalPolicyName' => 'externalPolicyName',
        'externalPolicyUrl' => 'externalPolicyUrl',
        'externalPolicyDescription' => 'externalPolicyDescription',
        'isExemptable' => 'isExemptable',
        'violatingParts' => 'violatingParts',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201502::CriterionPolicyError

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CriterionPolicyError from the namespace https://adwords.google.com/api/adwords/cm/v201502.

Contains the policy violations for a single BiddableAdGroupCriterion. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over



=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

