package main;

require v5.14.0;

use Cwd;
use Config;
use File::Spec;

sub sa_t_init {
  my $tname = shift;
  map {
    my $pathdir = $_;
    my $canonpathdir = Cwd::realpath($pathdir) if (File::Spec->file_name_is_absolute($pathdir) and (-d $pathdir));
    ((defined $canonpathdir))?($canonpathdir):()
  }
    $ENV{'PERL5LIB'} ? split($Config{path_sep}, $ENV{'PERL5LIB'}) : @INC;

  (-f "t/test_dir") && chdir("t");        # run from ..
  -f "test_dir"  or die "FATAL: not in test directory?\n";

  mkdir ("log", 0755);
  -d "log" or die "FATAL: failed to create log dir\n";
  chmod (0755, "log"); # set in case log already exists with wrong permissions

  return;
  
}

1;
