#!perl -T
use 5.006;
use strict;
use warnings;
use Test::More;

my @blah = (
    {
        test        => q{hostname Hostname},
        p_proc      => [ { type => 'hostname', config => 'Hostname' } ],
        desc        => q{Standard Hostname}
    },
    {
        test        => q{domain-name domain.local},
        p_proc      => [ { type => 'domain_name', config => 'domain.local' } ],
        desc        => q{Standard Domain Name}
    },
    {
        test        => q{name 192.0.2.1 Named_Host},
        p_proc      => [ { type => 'name_alias', config => { alias => 'Named_Host', ip => '192.0.2.1' } } ],
        desc        => q{Name Alias}
    },
    {
        test        => q{route inside 192.0.2.0 255.255.255.128 192.0.2.129 1},
        p_proc      => [ { type => 'route', config => { 
                                        interface => 'inside',
                                        destination => '192.0.2.0/255.255.255.128', 
                                        next_hop => '192.0.2.129',
                                        metric => '1'
                                    } } ],
        desc        => q{Name Alias}
    },
);



my @all_tests = (
    @blah,
);

# + 1 is for the use_ok()
plan tests => 1 + @all_tests; 

use_ok( 'Device::Network::ConfigParser::Cisco::ASA', qw{get_parser parse_config post_process} ) || print "Bail out!\n";

my $parser = get_parser();

# Run all tests
for my $test (@all_tests) {
    my $parsed = parse_config($parser, $test->{test});
    my $post_processed = post_process($parsed);

    is_deeply( $post_processed, $test->{p_proc}, $test->{desc} );
}
    


