#!/usr/bin/perl

use strict;
use warnings;

use Device::BusPirate;

my $pirate = Device::BusPirate->new;
my $chip = $pirate->mount_chip( "MPL3115A2" )->get;

$chip->power(1)->get;

$SIG{INT} = $SIG{TERM} = sub { exit 1; };

END {
   $chip and $chip->power(0)->get;
   $pirate and $pirate->stop;
}

$chip->check_id->get;

$chip->change_config(
   OS   => 16,
)->get;

while(1) {
   $chip->oneshot->get;

   printf "Pressure: %.2f Pa   Temperature: %.3f C\n",
      $chip->read_pressure->get, $chip->read_temperature->get;

   sleep 10;
}
