package Sah::Schema::Int;

our $DATE = '2016-03-08'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
use warnings;

our %SCHEMAS = (
    pos_int => [int => {
        name      => 'pos_int',
        summary   => 'Positive integer',
        min       => 0,
    }],

    neg_int => [int => {
        name      => 'neg_int',
        summary   => 'Positive integer',
        max       => 0,
    }],

    nat_num => [int => {
        name        => 'nat_num',
        summary     => 'Natural number',
        description => <<_,

Natural numbers are whole numbers starting from 1, used for counting ('there are
6 coins on the table') and ordering ('this is the 3rd largest city in the
country').

_
        min         => 1,
    }],

    int8 => [int => {
        summary => '8-bit signed integer',
        min     => -2**7,
        max     => +2**7-1,
    }],
    uint8 => [int => {
        summary => '8-bit unsigned integer',
        min     => +0,
        max     => +2**8-1,
    }],

    int16 => [int => {
        summary => '16-bit signed integer',
        min     => -2**15,
        max     => +2**15-1,
    }],
    uint16 => [int => {
        summary => '16-bit unsigned integer',
        min     => +0,
        max     => +2**16-1,
    }],

    int32 => [int => {
        summary => '32-bit signed integer',
        min     => -2**31,
        max     => +2**31-1,
    }],
    uint32 => [int => {
        summary => '32-bit unsigned integer',
        min     => 0,
        max     => 2**32-1,
    }],

    int64 => [int => {
        summary => '64-bit signed integer',
        min     => -2**63,
        max     => +2**63-1,
    }],
    uint64 => [int => {
        summary => '64-bit unsigned integer',
        min     => 0,
        max     => 2**64-1,
    }],

    int128 => [int => {
        summary => '32-bit signed integer',
        min     => -2**127,
        max     => +2**127-1,
    }],
    uint128 => [int => {
        summary => '128-bit unsigned integer',
        min     => 0,
        max     => 2**128-1,
    }],
);

1;
# ABSTRACT: Sah schemas for various integers

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::Schema::Int - Sah schemas for various integers

=head1 VERSION

This document describes version 0.02 of Sah::Schema::Int (from Perl distribution Sah-Schema-Int), released on 2016-03-08.

=head1 SAH SCHEMAS

=over

=item * int128

32-bit signed integer.

=item * int16

16-bit signed integer.

=item * int32

32-bit signed integer.

=item * int64

64-bit signed integer.

=item * int8

8-bit signed integer.

=item * nat_num

Natural number.

Natural numbers are whole numbers starting from 1, used for counting ('there are
6 coins on the table') and ordering ('this is the 3rd largest city in the
country').


=item * neg_int

Positive integer.

=item * pos_int

Positive integer.

=item * uint128

128-bit unsigned integer.

=item * uint16

16-bit unsigned integer.

=item * uint32

32-bit unsigned integer.

=item * uint64

64-bit unsigned integer.

=item * uint8

8-bit unsigned integer.

=back

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schema-Int>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schema-Int>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schema-Int>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Sah> - specification

L<Data::Sah>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
