package Object::Dumb;

our $DATE = '2015-02-21'; # DATE
our $VERSION = '0.01'; # VERSION

sub new { my $o = ""; bless \$o, shift }
sub AUTOLOAD { 0 }

1;
# ABSTRACT: A dumb object that does nothing when you call any of its methods

__END__

=pod

=encoding UTF-8

=head1 NAME

Object::Dumb - A dumb object that does nothing when you call any of its methods

=head1 VERSION

This document describes version 0.01 of Object::Dumb (from Perl distribution Object-Dumb), released on 2015-02-21.

=head1 SYNOPSIS

 use Object::Dumb;

 my $obj = Object::Dumb->new;
 $obj->foo;          # -> 0
 $obj->bar(1, 2, 3); # -> 0

=head1 DESCRIPTION

=for Pod::Coverage ^(.+)$

=head1 SEE ALSO

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Object-Dumb>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Object-Dumb>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Object-Dumb>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
