package Bencher::Scenario::TreeObject::Startup;

our $DATE = '2016-03-30'; # DATE
our $VERSION = '0.01'; # VERSION

use Bencher::ScenarioUtil::TreeObject;

my $classes = \%Bencher::ScenarioUtil::TreeObject::classes;

our $scenario = {
    summary => 'Benchmark startup of various tree classes',
    module_startup => 1,
    participants => [
        map {
            #my $spec = $classes->{$_};
            +{ module=>$_ };
        } keys %$classes,
    ],
};

1;
# ABSTRACT: Benchmark startup of various tree classes

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::TreeObject::Startup - Benchmark startup of various tree classes

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::TreeObject::Startup (from Perl distribution Bencher-Scenarios-TreeObject), released on 2016-03-30.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m TreeObject::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Tree::Object::Hash::ChildrenAsList> 0.05

L<Tree::Object::Array> 0.05

L<Tree::Object::Hash> 0.05

L<Tree::ObjectXS::Array> 0.02

L<Tree::Object::Array::Glob> 0.05

L<Tree::ObjectXS::Hash> 0.02

=head1 BENCHMARK PARTICIPANTS

=over

=item * Tree::Object::Hash::ChildrenAsList (perl_code)

L<Tree::Object::Hash::ChildrenAsList>



=item * Tree::Object::Array (perl_code)

L<Tree::Object::Array>



=item * Tree::Object::Hash (perl_code)

L<Tree::Object::Hash>



=item * Tree::ObjectXS::Array (perl_code)

L<Tree::ObjectXS::Array>



=item * Tree::Object::Array::Glob (perl_code)

L<Tree::Object::Array::Glob>



=item * Tree::ObjectXS::Hash (perl_code)

L<Tree::ObjectXS::Hash>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2557M CPU @ 1.70GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17 >>, OS kernel: I<< Linux version 3.13.0-32-generic >>.

Benchmark with default options (C<< bencher -m TreeObject::Startup >>):

 +------------------------------------+-----------+------------------------+------------+---------+---------+
 | participant                        | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +------------------------------------+-----------+------------------------+------------+---------+---------+
 | Tree::ObjectXS::Hash               | 4e+01     | 30                     | 1          | 0.00094 | 20      |
 | Tree::Object::Array::Glob          | 4e+01     | 30                     | 1          | 0.0017  | 20      |
 | Tree::ObjectXS::Array              | 4e+01     | 30                     | 1          | 0.00048 | 20      |
 | Tree::Object::Array                | 4e+01     | 30                     | 1          | 0.0008  | 20      |
 | Tree::Object::Hash::ChildrenAsList | 3e+01     | 20                     | 2          | 0.0008  | 20      |
 | Tree::Object::Hash                 | 2e+01     | 10                     | 2          | 0.00029 | 20      |
 | perl -e1 (baseline)                | 1e+01     | 0                      | 3          | 0.00033 | 20      |
 +------------------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-TreeObject>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-TreeObject>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-TreeObject>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
