package Bencher::Scenario::DataSah::normalize_schema;

our $DATE = '2016-05-20'; # DATE
our $VERSION = '0.06'; # VERSION

# TODO: benchmark normalize_clset

our $scenario = {
    summary => 'Benchmark normalizing Sah schema',
    participants => [
        {
            fcall_template => 'Data::Sah::Normalize::normalize_schema(<schema>)'
        },
    ],
    datasets => [

        {
            name    => 'str',
            summary => '',
            args    => {
                schema => 'str',
            },
        },

        {
            name => 'str_wildcard',
            args => {
                schema => 'str*',
            },
        },

        {
            name => 'array1',
            args => {
                schema => ['str'],
            },
        },

        {
            name => 'array3',
            args => {
                schema => ['str', len=>1],
            },
        },

        {
            name => 'array5',
            args => {
                schema => ['str', min_len=>8, max_len=>16],
            },
        },

    ],
};

1;
# ABSTRACT: Benchmark normalizing Sah schema

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSah::normalize_schema - Benchmark normalizing Sah schema

=head1 VERSION

This document describes version 0.06 of Bencher::Scenario::DataSah::normalize_schema (from Perl distribution Bencher-Scenarios-DataSah), released on 2016-05-20.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSah::normalize_schema

To run module startup overhead benchmark:

 % bencher --module-startup -m DataSah::normalize_schema

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Data::Sah::Normalize> 0.04

=head1 BENCHMARK PARTICIPANTS

=over

=item * Data::Sah::Normalize::normalize_schema (perl_code)

Function call template:

 Data::Sah::Normalize::normalize_schema(<schema>)



=back

=head1 BENCHMARK DATASETS

=over

=item * str

=item * str_wildcard

=item * array1

=item * array3

=item * array5

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DataSah::normalize_schema >>):

 +--------------+-----------+-----------+------------+---------+---------+
 | dataset      | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +--------------+-----------+-----------+------------+---------+---------+
 | array5       | 6.8e+04   | 15        | 1          | 2.7e-08 | 20      |
 | array3       | 92032     | 10.866    | 1.3515     | 1.1e-11 | 24      |
 | array1       | 1.8e+05   | 5.6       | 2.6        | 6.7e-09 | 20      |
 | str_wildcard | 3.1e+05   | 3.2       | 4.6        | 6.7e-09 | 20      |
 | str          | 4.5e+05   | 2.2       | 6.6        | 3.3e-09 | 20      |
 +--------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m DataSah::normalize_schema --module-startup >>):

 +----------------------+-----------+------------------------+------------+---------+---------+
 | participant          | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +----------------------+-----------+------------------------+------------+---------+---------+
 | Data::Sah::Normalize | 9.1       | 4.1                    | 1          | 4.2e-05 | 21      |
 | perl -e1 (baseline)  | 5         | 0                      | 1.8        | 2.5e-05 | 20      |
 +----------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
