package Bencher::Scenario::DataSah::Startup;

our $DATE = '2016-05-20'; # DATE
our $VERSION = '0.06'; # VERSION

our $scenario = {
    summary => 'Benchmark startup overhead of loading Data::Sah and generating validators',
    participants => [
        { name => 'perl'               , perl_cmdline => ["-e1"] },
        { name => 'load_dsah'          , perl_cmdline => ["-MData::Sah", "-e", 1] },
        { name => 'load_dsah+get_plc'  , perl_cmdline => ["-MData::Sah", "-e", '$sah = Data::Sah->new; $plc = $sah->get_compiler("perl")'] },
        { name => 'genval_bool_int'    , perl_cmdline => ["-MData::Sah=gen_validator", "-e", 'gen_validator("int")'] },
        { name => 'genval_str_int'     , perl_cmdline => ["-MData::Sah=gen_validator", "-e", 'gen_validator("int",{return_type=>"str"})'] },
        { name => 'genval_str_date'    , perl_cmdline => ["-MData::Sah=gen_validator", "-e", 'gen_validator("date",{return_type=>"str"})'] },
        { name => 'genval_str_5typical', perl_cmdline => ["-MData::Sah=gen_validator", "-e", 'for ("int", "str*", [int=>min=>1, max=>10], [str, min_len=>4], [any=>of=>["str",["array",of=>"str"]]]) { gen_validator("int",{return_type=>"str"}) }'] },
    ],
};

1;
# ABSTRACT: Benchmark startup overhead of loading Data::Sah and generating validators

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSah::Startup - Benchmark startup overhead of loading Data::Sah and generating validators

=head1 VERSION

This document describes version 0.06 of Bencher::Scenario::DataSah::Startup (from Perl distribution Bencher-Scenarios-DataSah), released on 2016-05-20.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSah::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * perl (command)



=item * load_dsah (command)



=item * load_dsah+get_plc (command)



=item * genval_bool_int (command)



=item * genval_str_int (command)



=item * genval_str_date (command)



=item * genval_str_5typical (command)



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DataSah::Startup >>):

 +---------------------+-----------+-----------+------------+---------+---------+
 | participant         | rate (/s) | time (ms) | vs_slowest | errors  | samples |
 +---------------------+-----------+-----------+------------+---------+---------+
 | genval_str_5typical | 16        | 63        | 1          | 0.00015 | 20      |
 | genval_str_date     | 16        | 61        | 1          | 0.00018 | 20      |
 | genval_str_int      | 17        | 60        | 1.1        | 0.00026 | 20      |
 | genval_bool_int     | 17        | 59        | 1.1        | 0.00017 | 20      |
 | load_dsah+get_plc   | 3e+01     | 3e+01     | 2          | 0.00034 | 21      |
 | load_dsah           | 84        | 12        | 5.3        | 5.6e-05 | 22      |
 | perl                | 2.3e+02   | 4.3       | 15         | 2.4e-05 | 20      |
 +---------------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
