package Bencher::Scenario::DataSah::gen_coercer;

our $DATE = '2016-05-16'; # DATE
our $VERSION = '0.05'; # VERSION

require Data::Sah::Coerce;

my $return_types = ['bool', 'str', 'full'];

our $scenario = {
    summary => 'Benchmark coercion',
    participants => [
        {
            name => 'gen_coercer',
            code_template => 'Data::Sah::Coerce::gen_coercer(type => <type>, coerce_to => <coerce_to>)',
        },
    ],
    datasets => [
        {
            name => 'date (coerce to int(epoch))',
            args => {
                type => 'date',
                coerce_to => 'int(epoch)',
            },
        },
        {
            name => 'date (coerce to DateTime)',
            args => {
                type => 'date',
                coerce_to => 'DateTime',
            },
        },
        {
            name => 'date (coerce to Time::Moment)',
            args => {
                type => 'date',
                coerce_to => 'Time::Moment',
            },
        },
    ],
};

1;
# ABSTRACT: Benchmark coercion

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSah::gen_coercer - Benchmark coercion

=head1 VERSION

This document describes version 0.05 of Bencher::Scenario::DataSah::gen_coercer (from Perl distribution Bencher-Scenarios-DataSah), released on 2016-05-16.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSah::gen_coercer

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * gen_coercer (perl_code)

Code template:

 Data::Sah::Coerce::gen_coercer(type => <type>, coerce_to => <coerce_to>)



=back

=head1 BENCHMARK DATASETS

=over

=item * date (coerce to int(epoch))

=item * date (coerce to DateTime)

=item * date (coerce to Time::Moment)

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DataSah::gen_coercer >>):

 +-------------------------------+-----------+-----------+------------+---------+---------+
 | dataset                       | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +-------------------------------+-----------+-----------+------------+---------+---------+
 | date (coerce to DateTime)     | 7.1e+03   | 1.4e+02   | 1          | 2.1e-07 | 20      |
 | date (coerce to Time::Moment) | 8.3e+03   | 1.2e+02   | 1.2        | 2.1e-07 | 20      |
 | date (coerce to int(epoch))   | 8.8e+03   | 1.1e+02   | 1.2        | 2.7e-07 | 20      |
 +-------------------------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
