package Bencher::Scenario::DataSah::Validate;

our $DATE = '2016-05-16'; # DATE
our $VERSION = '0.05'; # VERSION

require Data::Sah;
require DateTime;
require Time::Moment;

my $return_types = ['bool', 'str', 'full'];

our $scenario = {
    summary => 'Benchmark validation',
    participants => [
        {
            name => 'gen_validator',
            code_template => 'state $v = Data::Sah::gen_validator(<schema>, {return_type => <return_type>}); $v->(<data>)',
        },
    ],
    datasets => [
        {
            name => 'int',
            args => {
                schema => 'int',
                'data@' => [undef, 1, "a"],
                'return_type@' => $return_types,
            },
        },
        {
            name => 'str+2clause',
            args => {
                schema => ['str', min_len=>1, max_len=>5],
                'data@' => [undef, "abc", ""],
                'return_type@' => $return_types,
            },
        },
        {
            name => 'date (coerce to int(epoch))',
            args => {
                schema => ['date'],
                'data@' => [undef, "abc", 1463371843, "2016-05-16", DateTime->now,
                            #Time::Moment->now, # disabled for now, error
                        ],
                'return_type@' => $return_types,
            },
        },
        # XXX: date (coerce to DateTime)
        # XXX: date (coerce to Time::Moment)
    ],
};

1;
# ABSTRACT: Benchmark validation

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSah::Validate - Benchmark validation

=head1 VERSION

This document describes version 0.05 of Bencher::Scenario::DataSah::Validate (from Perl distribution Bencher-Scenarios-DataSah), released on 2016-05-16.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSah::Validate

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * gen_validator (perl_code)

Code template:

 state $v = Data::Sah::gen_validator(<schema>, {return_type => <return_type>}); $v->(<data>)



=back

=head1 BENCHMARK DATASETS

=over

=item * int

=item * str+2clause

=item * date (coerce to int(epoch))

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DataSah::Validate >>):

 [
    200,
    "OK",
    [
       {
          "arg_data" : 1463373869,
          "arg_return_type" : "full",
          "dataset" : "date (coerce to int(epoch))",
          "errors" : "2.7e-08",
          "rate" : "4.1e+04",
          "samples" : 20,
          "time" : "24",
          "vs_slowest" : "1"
       },
       {
          "arg_data" : 1463373869,
          "arg_return_type" : "str",
          "dataset" : "date (coerce to int(epoch))",
          "errors" : "3.3e-08",
          "rate" : "4.2e+04",
          "samples" : 21,
          "time" : "24",
          "vs_slowest" : "1"
       },
       {
          "arg_data" : 1463373869,
          "arg_return_type" : "bool",
          "dataset" : "date (coerce to int(epoch))",
          "errors" : "3.3e-08",
          "rate" : "4.3e+04",
          "samples" : 20,
          "time" : "23",
          "vs_slowest" : "1"
       },
       {
          "arg_data" : "2016-05-16",
          "arg_return_type" : "full",
          "dataset" : "date (coerce to int(epoch))",
          "errors" : "1.3e-07",
          "rate" : "8e+04",
          "samples" : 23,
          "time" : "1e+01",
          "vs_slowest" : "2"
       },
       {
          "arg_data" : "2016-05-16",
          "arg_return_type" : "bool",
          "dataset" : "date (coerce to int(epoch))",
          "errors" : "5.2e-08",
          "rate" : "8.8e+04",
          "samples" : 36,
          "time" : "11",
          "vs_slowest" : "2.1"
       },
       {
          "arg_data" : "2016-05-16",
          "arg_return_type" : "str",
          "dataset" : "date (coerce to int(epoch))",
          "errors" : "2.7e-08",
          "rate" : "9.3e+04",
          "samples" : 20,
          "time" : "11",
          "vs_slowest" : "2.3"
       },
       {
          "arg_data" : null,
          "arg_return_type" : "full",
          "dataset" : "date (coerce to int(epoch))",
          "errors" : "1.3e-08",
          "rate" : "1e+05",
          "samples" : 20,
          "time" : "9.8",
          "vs_slowest" : "2.5"
       },
       {
          "arg_data" : null,
          "arg_return_type" : "str",
          "dataset" : "date (coerce to int(epoch))",
          "errors" : "2.9e-09",
          "rate" : "1.06e+05",
          "samples" : 26,
          "time" : "9.43",
          "vs_slowest" : "2.59"
       },
       {
          "arg_data" : null,
          "arg_return_type" : "bool",
          "dataset" : "date (coerce to int(epoch))",
          "errors" : "3.3e-09",
          "rate" : "1.09e+05",
          "samples" : 20,
          "time" : "9.17",
          "vs_slowest" : "2.66"
       },
       {
          "arg_data" : "abc",
          "arg_return_type" : "full",
          "dataset" : "date (coerce to int(epoch))",
          "errors" : "3.8e-10",
          "rate" : "8.22e+05",
          "samples" : 24,
          "time" : "1.22",
          "vs_slowest" : "20.1"
       },
       {
          "arg_data" : "a",
          "arg_return_type" : "full",
          "dataset" : "int",
          "errors" : "3.3e-10",
          "rate" : "1.03e+06",
          "samples" : 32,
          "time" : "0.97",
          "vs_slowest" : "25.1"
       },
       {
          "arg_data" : 1463371843,
          "arg_return_type" : "full",
          "dataset" : "date (coerce to int(epoch))",
          "errors" : "1.7e-09",
          "rate" : "1.1e+06",
          "samples" : 20,
          "time" : "0.94",
          "vs_slowest" : "26"
       },
       {
          "arg_data" : "",
          "arg_return_type" : "full",
          "dataset" : "str+2clause",
          "errors" : "0",
          "rate" : "1.06348e+06",
          "samples" : 20,
          "time" : "0.940313",
          "vs_slowest" : "25.9428"
       },
       {
          "arg_data" : 1463371843,
          "arg_return_type" : "str",
          "dataset" : "date (coerce to int(epoch))",
          "errors" : "0",
          "rate" : "1.37105e+06",
          "samples" : 20,
          "time" : "0.72937",
          "vs_slowest" : "33.4458"
       },
       {
          "arg_data" : "abc",
          "arg_return_type" : "full",
          "dataset" : "str+2clause",
          "errors" : "8.3e-10",
          "rate" : "1.6e+06",
          "samples" : 20,
          "time" : "0.64",
          "vs_slowest" : "38"
       },
       {
          "arg_data" : 1,
          "arg_return_type" : "full",
          "dataset" : "int",
          "errors" : "0",
          "rate" : "1.57288e+06",
          "samples" : 20,
          "time" : "0.635775",
          "vs_slowest" : "38.3695"
       },
       {
          "arg_data" : "abc",
          "arg_return_type" : "str",
          "dataset" : "date (coerce to int(epoch))",
          "errors" : "0",
          "rate" : "1.61708e+06",
          "samples" : 20,
          "time" : "0.6184",
          "vs_slowest" : "39.4476"
       },
       {
          "arg_data" : 1463371843,
          "arg_return_type" : "bool",
          "dataset" : "date (coerce to int(epoch))",
          "errors" : "6.2e-10",
          "rate" : "1.7e+06",
          "samples" : 20,
          "time" : "0.59",
          "vs_slowest" : "41"
       },
       {
          "arg_data" : null,
          "arg_return_type" : "full",
          "dataset" : "int",
          "errors" : "0",
          "rate" : "2.05275e+06",
          "samples" : 20,
          "time" : "0.487152",
          "vs_slowest" : "50.0755"
       },
       {
          "arg_data" : null,
          "arg_return_type" : "full",
          "dataset" : "str+2clause",
          "errors" : "0",
          "rate" : "2.05403e+06",
          "samples" : 20,
          "time" : "0.486848",
          "vs_slowest" : "50.1067"
       },
       {
          "arg_data" : "a",
          "arg_return_type" : "str",
          "dataset" : "int",
          "errors" : "0",
          "rate" : "2.31134e+06",
          "samples" : 20,
          "time" : "0.43265",
          "vs_slowest" : "56.3836"
       },
       {
          "arg_data" : "abc",
          "arg_return_type" : "bool",
          "dataset" : "date (coerce to int(epoch))",
          "errors" : "0",
          "rate" : "2.35147e+06",
          "samples" : 20,
          "time" : "0.425265",
          "vs_slowest" : "57.3627"
       },
       {
          "arg_data" : "",
          "arg_return_type" : "str",
          "dataset" : "str+2clause",
          "errors" : "5.8e-10",
          "rate" : "2.5e+06",
          "samples" : 23,
          "time" : "0.41",
          "vs_slowest" : "60"
       },
       {
          "arg_data" : "abc",
          "arg_return_type" : "str",
          "dataset" : "str+2clause",
          "errors" : "0",
          "rate" : "2.64699e+06",
          "samples" : 20,
          "time" : "0.377788",
          "vs_slowest" : "64.5716"
       },
       {
          "arg_data" : 1,
          "arg_return_type" : "str",
          "dataset" : "int",
          "errors" : "0",
          "rate" : "2.78189e+06",
          "samples" : 20,
          "time" : "0.359467",
          "vs_slowest" : "67.8626"
       },
       {
          "arg_data" : null,
          "arg_return_type" : "str",
          "dataset" : "int",
          "errors" : "1e-10",
          "rate" : "3.45e+06",
          "samples" : 20,
          "time" : "0.29",
          "vs_slowest" : "84.2"
       },
       {
          "arg_data" : null,
          "arg_return_type" : "str",
          "dataset" : "str+2clause",
          "errors" : "3.9e-10",
          "rate" : "3.5e+06",
          "samples" : 23,
          "time" : "0.28",
          "vs_slowest" : "86"
       },
       {
          "arg_data" : "a",
          "arg_return_type" : "bool",
          "dataset" : "int",
          "errors" : "3e-10",
          "rate" : "4.5e+06",
          "samples" : 21,
          "time" : "0.22",
          "vs_slowest" : "1.1e+02"
       },
       {
          "arg_data" : 1,
          "arg_return_type" : "bool",
          "dataset" : "int",
          "errors" : "0",
          "rate" : "4.5943e+06",
          "samples" : 23,
          "time" : "0.217661",
          "vs_slowest" : "112.075"
       },
       {
          "arg_data" : "abc",
          "arg_return_type" : "bool",
          "dataset" : "str+2clause",
          "errors" : "0",
          "rate" : "4.72026e+06",
          "samples" : 20,
          "time" : "0.211853",
          "vs_slowest" : "115.148"
       },
       {
          "arg_data" : "",
          "arg_return_type" : "bool",
          "dataset" : "str+2clause",
          "errors" : "1.1e-11",
          "rate" : "5.095e+06",
          "samples" : 20,
          "time" : "0.1963",
          "vs_slowest" : "124.3"
       },
       {
          "arg_data" : null,
          "arg_return_type" : "bool",
          "dataset" : "int",
          "errors" : "2.5e-10",
          "rate" : "6.6e+06",
          "samples" : 31,
          "time" : "0.15",
          "vs_slowest" : "1.6e+02"
       },
       {
          "arg_data" : null,
          "arg_return_type" : "bool",
          "dataset" : "str+2clause",
          "errors" : "4.2e-10",
          "rate" : "6.9e+06",
          "samples" : 20,
          "time" : "0.14",
          "vs_slowest" : "1.7e+02"
       }
    ],
    {
       "func.bencher_args" : {
          "action" : "bench",
          "note" : "Run by Pod::Weaver::Plugin::Bencher::Scenario",
          "scenario_module" : "DataSah::Validate"
       },
       "func.bencher_version" : null,
       "func.cpu_info" : [
          {
             "L2_cache" : {
                "max_cache_size" : "8192 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "pdpe1gb",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "fma",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "movbe",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "f16c",
                "rdrand",
                "lahf_lm",
                "abm",
                "ida",
                "arat",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid",
                "fsgsbase",
                "tsc_adjust",
                "bmi1",
                "hle",
                "avx2",
                "smep",
                "bmi2",
                "erms",
                "invpcid",
                "rtm"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "60",
             "name" : "Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 8,
             "processor_id" : "0",
             "speed" : "3888.218",
             "stepping" : "3"
          },
          {
             "L2_cache" : {
                "max_cache_size" : "8192 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "pdpe1gb",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "fma",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "movbe",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "f16c",
                "rdrand",
                "lahf_lm",
                "abm",
                "ida",
                "arat",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid",
                "fsgsbase",
                "tsc_adjust",
                "bmi1",
                "hle",
                "avx2",
                "smep",
                "bmi2",
                "erms",
                "invpcid",
                "rtm"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "60",
             "name" : "Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 8,
             "processor_id" : "1",
             "speed" : "3749.164",
             "stepping" : "3"
          },
          {
             "L2_cache" : {
                "max_cache_size" : "8192 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "pdpe1gb",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "fma",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "movbe",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "f16c",
                "rdrand",
                "lahf_lm",
                "abm",
                "ida",
                "arat",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid",
                "fsgsbase",
                "tsc_adjust",
                "bmi1",
                "hle",
                "avx2",
                "smep",
                "bmi2",
                "erms",
                "invpcid",
                "rtm"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "60",
             "name" : "Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 8,
             "processor_id" : "2",
             "speed" : "3846.648",
             "stepping" : "3"
          },
          {
             "L2_cache" : {
                "max_cache_size" : "8192 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "pdpe1gb",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "fma",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "movbe",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "f16c",
                "rdrand",
                "lahf_lm",
                "abm",
                "ida",
                "arat",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid",
                "fsgsbase",
                "tsc_adjust",
                "bmi1",
                "hle",
                "avx2",
                "smep",
                "bmi2",
                "erms",
                "invpcid",
                "rtm"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "60",
             "name" : "Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 8,
             "processor_id" : "3",
             "speed" : "3795.117",
             "stepping" : "3"
          },
          {
             "L2_cache" : {
                "max_cache_size" : "8192 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "pdpe1gb",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "fma",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "movbe",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "f16c",
                "rdrand",
                "lahf_lm",
                "abm",
                "ida",
                "arat",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid",
                "fsgsbase",
                "tsc_adjust",
                "bmi1",
                "hle",
                "avx2",
                "smep",
                "bmi2",
                "erms",
                "invpcid",
                "rtm"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "60",
             "name" : "Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 8,
             "processor_id" : "4",
             "speed" : "3894.859",
             "stepping" : "3"
          },
          {
             "L2_cache" : {
                "max_cache_size" : "8192 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "pdpe1gb",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "fma",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "movbe",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "f16c",
                "rdrand",
                "lahf_lm",
                "abm",
                "ida",
                "arat",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid",
                "fsgsbase",
                "tsc_adjust",
                "bmi1",
                "hle",
                "avx2",
                "smep",
                "bmi2",
                "erms",
                "invpcid",
                "rtm"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "60",
             "name" : "Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 8,
             "processor_id" : "5",
             "speed" : "3858.734",
             "stepping" : "3"
          },
          {
             "L2_cache" : {
                "max_cache_size" : "8192 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "pdpe1gb",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "fma",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "movbe",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "f16c",
                "rdrand",
                "lahf_lm",
                "abm",
                "ida",
                "arat",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid",
                "fsgsbase",
                "tsc_adjust",
                "bmi1",
                "hle",
                "avx2",
                "smep",
                "bmi2",
                "erms",
                "invpcid",
                "rtm"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "60",
             "name" : "Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 8,
             "processor_id" : "6",
             "speed" : "3737.609",
             "stepping" : "3"
          },
          {
             "L2_cache" : {
                "max_cache_size" : "8192 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "pdpe1gb",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "fma",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "movbe",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "f16c",
                "rdrand",
                "lahf_lm",
                "abm",
                "ida",
                "arat",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid",
                "fsgsbase",
                "tsc_adjust",
                "bmi1",
                "hle",
                "avx2",
                "smep",
                "bmi2",
                "erms",
                "invpcid",
                "rtm"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "60",
             "name" : "Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 8,
             "processor_id" : "7",
             "speed" : "3899.773",
             "stepping" : "3"
          }
       ],
       "func.elapsed_time" : 1.04438090324402,
       "func.module_startup" : null,
       "func.module_versions" : {
          "Bencher::Scenario::DataSah::Validate" : null,
          "Benchmark::Dumb" : "0.10",
          "Devel::Platform::Info" : "0.15",
          "Sys::Info" : "0.78",
          "Sys::Load" : "0.2",
          "perl" : "v5.22.2"
       },
       "func.note" : "Run by Pod::Weaver::Plugin::Bencher::Scenario",
       "func.platform_info" : {
          "archname" : "x86_64",
          "codename" : "jessie",
          "is32bit" : 0,
          "is64bit" : 1,
          "kernel" : "linux-3.16.0-4-amd64",
          "kname" : "Linux",
          "kvers" : "3.16.0-4-amd64",
          "osflag" : "linux",
          "oslabel" : "Debian",
          "osname" : "GNU/Linux",
          "osvers" : "8.0",
          "source" : {
             "cat /etc/.issue" : "",
             "cat /etc/issue" : "Debian GNU/Linux 8 \\n \\l",
             "lsb_release -a" : "Distributor ID:\tDebian\nDescription:\tDebian GNU/Linux 8.0 (jessie)\nRelease:\t8.0\nCodename:\tjessie",
             "uname -a" : "Linux builder-sw 3.16.0-4-amd64 #1 SMP Debian 3.16.7-ckt7-1 (2015-03-01) x86_64 GNU/Linux",
             "uname -m" : "x86_64",
             "uname -o" : "GNU/Linux",
             "uname -r" : "3.16.0-4-amd64",
             "uname -s" : "Linux"
          }
       },
       "func.precision" : 0,
       "func.scenario_module" : "Bencher::Scenario::DataSah::Validate",
       "func.sysload_after" : [
          0.51,
          0.23,
          0.23
       ],
       "func.sysload_before" : [
          0.51,
          0.23,
          0.23
       ],
       "func.time_end" : 1463373875.48236,
       "func.time_start" : 1463373874.43798,
       "table.field_units" : [
          null,
          null,
          null,
          null,
          null,
          "/s",
          "μs"
       ],
       "table.fields" : [
          "participant",
          "dataset",
          "arg_data",
          "arg_return_type",
          "perl",
          "rate",
          "time",
          "vs_slowest",
          "errors",
          "samples"
       ]
    }
 ]

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
