package Bencher::Scenario::DataSah::Coerce;

our $DATE = '2016-05-16'; # DATE
our $VERSION = '0.05'; # VERSION

require Data::Sah::Coerce;
require DateTime;
require Time::Moment;

my $return_types = ['bool', 'str', 'full'];

our $scenario = {
    summary => 'Benchmark coercion',
    participants => [
        {
            name => 'gen_coercer',
            code_template => 'state $c = Data::Sah::Coerce::gen_coercer(type => <type>, coerce_to => <coerce_to>); $c->(<data>)',
        },
    ],
    datasets => [
        {
            name => 'date (coerce to int(epoch))',
            args => {
                type => 'date',
                coerce_to => 'int(epoch)',
                'data@' => [undef, "abc", 123, [], 1463373166, "2016-05-16"],
            },
        },
        # XXX date (coerce to DateTime)
        # XXX date (coerce to Time::Moment)
    ],
};

1;
# ABSTRACT: Benchmark coercion

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSah::Coerce - Benchmark coercion

=head1 VERSION

This document describes version 0.05 of Bencher::Scenario::DataSah::Coerce (from Perl distribution Bencher-Scenarios-DataSah), released on 2016-05-16.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSah::Coerce

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * gen_coercer (perl_code)

Code template:

 state $c = Data::Sah::Coerce::gen_coercer(type => <type>, coerce_to => <coerce_to>); $c->(<data>)



=back

=head1 BENCHMARK DATASETS

=over

=item * date (coerce to int(epoch))

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DataSah::Coerce >>):

 [
    200,
    "OK",
    [
       {
          "arg_data" : "2016-05-16",
          "errors" : "1.3e-08",
          "rate" : "1e+05",
          "samples" : 20,
          "time" : "9.9",
          "vs_slowest" : "1"
       },
       {
          "arg_data" : null,
          "errors" : "3.3e-09",
          "rate" : "1.13e+05",
          "samples" : 20,
          "time" : "8.85",
          "vs_slowest" : "1.11"
       },
       {
          "arg_data" : [],
          "errors" : "0",
          "rate" : "3.18468e+06",
          "samples" : 20,
          "time" : "0.314004",
          "vs_slowest" : "31.3804"
       },
       {
          "arg_data" : 1463373166,
          "errors" : "0",
          "rate" : "3.20473e+06",
          "samples" : 20,
          "time" : "0.312039",
          "vs_slowest" : "31.5779"
       },
       {
          "arg_data" : "abc",
          "errors" : "0",
          "rate" : "3.73845e+06",
          "samples" : 21,
          "time" : "0.267491",
          "vs_slowest" : "36.837"
       },
       {
          "arg_data" : 123,
          "errors" : "0",
          "rate" : "3.91631e+06",
          "samples" : 20,
          "time" : "0.255342",
          "vs_slowest" : "38.5895"
       }
    ],
    {
       "func.bencher_args" : {
          "action" : "bench",
          "note" : "Run by Pod::Weaver::Plugin::Bencher::Scenario",
          "scenario_module" : "DataSah::Coerce"
       },
       "func.bencher_version" : null,
       "func.cpu_info" : [
          {
             "L2_cache" : {
                "max_cache_size" : "8192 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "pdpe1gb",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "fma",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "movbe",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "f16c",
                "rdrand",
                "lahf_lm",
                "abm",
                "ida",
                "arat",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid",
                "fsgsbase",
                "tsc_adjust",
                "bmi1",
                "hle",
                "avx2",
                "smep",
                "bmi2",
                "erms",
                "invpcid",
                "rtm"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "60",
             "name" : "Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 8,
             "processor_id" : "0",
             "speed" : "3812.914",
             "stepping" : "3"
          },
          {
             "L2_cache" : {
                "max_cache_size" : "8192 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "pdpe1gb",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "fma",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "movbe",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "f16c",
                "rdrand",
                "lahf_lm",
                "abm",
                "ida",
                "arat",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid",
                "fsgsbase",
                "tsc_adjust",
                "bmi1",
                "hle",
                "avx2",
                "smep",
                "bmi2",
                "erms",
                "invpcid",
                "rtm"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "60",
             "name" : "Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 8,
             "processor_id" : "1",
             "speed" : "3857.539",
             "stepping" : "3"
          },
          {
             "L2_cache" : {
                "max_cache_size" : "8192 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "pdpe1gb",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "fma",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "movbe",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "f16c",
                "rdrand",
                "lahf_lm",
                "abm",
                "ida",
                "arat",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid",
                "fsgsbase",
                "tsc_adjust",
                "bmi1",
                "hle",
                "avx2",
                "smep",
                "bmi2",
                "erms",
                "invpcid",
                "rtm"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "60",
             "name" : "Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 8,
             "processor_id" : "2",
             "speed" : "3880.250",
             "stepping" : "3"
          },
          {
             "L2_cache" : {
                "max_cache_size" : "8192 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "pdpe1gb",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "fma",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "movbe",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "f16c",
                "rdrand",
                "lahf_lm",
                "abm",
                "ida",
                "arat",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid",
                "fsgsbase",
                "tsc_adjust",
                "bmi1",
                "hle",
                "avx2",
                "smep",
                "bmi2",
                "erms",
                "invpcid",
                "rtm"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "60",
             "name" : "Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 8,
             "processor_id" : "3",
             "speed" : "3797.773",
             "stepping" : "3"
          },
          {
             "L2_cache" : {
                "max_cache_size" : "8192 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "pdpe1gb",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "fma",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "movbe",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "f16c",
                "rdrand",
                "lahf_lm",
                "abm",
                "ida",
                "arat",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid",
                "fsgsbase",
                "tsc_adjust",
                "bmi1",
                "hle",
                "avx2",
                "smep",
                "bmi2",
                "erms",
                "invpcid",
                "rtm"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "60",
             "name" : "Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 8,
             "processor_id" : "4",
             "speed" : "3887.953",
             "stepping" : "3"
          },
          {
             "L2_cache" : {
                "max_cache_size" : "8192 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "pdpe1gb",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "fma",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "movbe",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "f16c",
                "rdrand",
                "lahf_lm",
                "abm",
                "ida",
                "arat",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid",
                "fsgsbase",
                "tsc_adjust",
                "bmi1",
                "hle",
                "avx2",
                "smep",
                "bmi2",
                "erms",
                "invpcid",
                "rtm"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "60",
             "name" : "Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 8,
             "processor_id" : "5",
             "speed" : "3899.773",
             "stepping" : "3"
          },
          {
             "L2_cache" : {
                "max_cache_size" : "8192 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "pdpe1gb",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "fma",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "movbe",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "f16c",
                "rdrand",
                "lahf_lm",
                "abm",
                "ida",
                "arat",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid",
                "fsgsbase",
                "tsc_adjust",
                "bmi1",
                "hle",
                "avx2",
                "smep",
                "bmi2",
                "erms",
                "invpcid",
                "rtm"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "60",
             "name" : "Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 8,
             "processor_id" : "6",
             "speed" : "3775.328",
             "stepping" : "3"
          },
          {
             "L2_cache" : {
                "max_cache_size" : "8192 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "pdpe1gb",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "fma",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "movbe",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "f16c",
                "rdrand",
                "lahf_lm",
                "abm",
                "ida",
                "arat",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid",
                "fsgsbase",
                "tsc_adjust",
                "bmi1",
                "hle",
                "avx2",
                "smep",
                "bmi2",
                "erms",
                "invpcid",
                "rtm"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "60",
             "name" : "Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 8,
             "processor_id" : "7",
             "speed" : "3899.773",
             "stepping" : "3"
          }
       ],
       "func.elapsed_time" : 0.166378021240234,
       "func.module_startup" : null,
       "func.module_versions" : {
          "Bencher::Scenario::DataSah::Coerce" : null,
          "Benchmark::Dumb" : "0.10",
          "Devel::Platform::Info" : "0.15",
          "Sys::Info" : "0.78",
          "Sys::Load" : "0.2",
          "perl" : "v5.22.2"
       },
       "func.note" : "Run by Pod::Weaver::Plugin::Bencher::Scenario",
       "func.platform_info" : {
          "archname" : "x86_64",
          "codename" : "jessie",
          "is32bit" : 0,
          "is64bit" : 1,
          "kernel" : "linux-3.16.0-4-amd64",
          "kname" : "Linux",
          "kvers" : "3.16.0-4-amd64",
          "osflag" : "linux",
          "oslabel" : "Debian",
          "osname" : "GNU/Linux",
          "osvers" : "8.0",
          "source" : {
             "cat /etc/.issue" : "",
             "cat /etc/issue" : "Debian GNU/Linux 8 \\n \\l",
             "lsb_release -a" : "Distributor ID:\tDebian\nDescription:\tDebian GNU/Linux 8.0 (jessie)\nRelease:\t8.0\nCodename:\tjessie",
             "uname -a" : "Linux builder-sw 3.16.0-4-amd64 #1 SMP Debian 3.16.7-ckt7-1 (2015-03-01) x86_64 GNU/Linux",
             "uname -m" : "x86_64",
             "uname -o" : "GNU/Linux",
             "uname -r" : "3.16.0-4-amd64",
             "uname -s" : "Linux"
          }
       },
       "func.precision" : 0,
       "func.scenario_module" : "Bencher::Scenario::DataSah::Coerce",
       "func.sysload_after" : [
          0.38,
          0.2,
          0.22
       ],
       "func.sysload_before" : [
          0.38,
          0.2,
          0.22
       ],
       "func.time_end" : 1463373869.64282,
       "func.time_start" : 1463373869.47644,
       "table.field_units" : [
          null,
          null,
          null,
          null,
          "/s",
          "μs"
       ],
       "table.fields" : [
          "participant",
          "dataset",
          "arg_data",
          "perl",
          "rate",
          "time",
          "vs_slowest",
          "errors",
          "samples"
       ]
    }
 ]

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
