package Bencher::Scenario::Data::Sah::Startup;

our $DATE = '2015-12-23'; # DATE
our $VERSION = '0.02'; # VERSION

use FindBin '$Bin';

# XXX replace $^X with perl path provided by bencher

our $scenario = {
    summary => 'Benchmark startup overhead of loading Data::Sah and generating validators',
    participants => [
        { name => 'perl',              cmdline => [$^X, "-I$Bin/..lib", "-e1"] },
        { name => 'load_dsah',         cmdline => [$^X, "-I$Bin/..lib", "-MData::Sah", "-e", 1] },
        { name => 'load_dsah+get_plc', cmdline => [$^X, "-I$Bin/..lib", "-MData::Sah", "-e", '$sah = Data::Sah->new; $plc = $sah->get_compiler("perl")'] },
        { name => 'gen_bool_val_int',  cmdline => [$^X, "-I$Bin/..lib", "-MData::Sah=gen_validator", "-e", 'gen_validator("int")'] },
        { name => 'gen_str_val_int',   cmdline => [$^X, "-I$Bin/..lib", "-MData::Sah=gen_validator", "-e", 'gen_validator("int",{return_type=>"str"})'] },
        { name => 'gen_str_vals',      cmdline => [$^X, "-I$Bin/..lib", "-MData::Sah=gen_validator", "-e", 'for ("int", "str*", [int=>min=>1, max=>10], [str, min_len=>4], [any=>of=>["str",["array",of=>"str"]]]) { gen_validator("int",{return_type=>"str"}) }'] },
    ],
};

1;
# ABSTRACT: Benchmark startup overhead of loading Data::Sah and generating validators

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Data::Sah::Startup

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::Data::Sah::Startup (from Perl distribution Bencher-Scenarios-DataSah), released on 2015-12-23.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
