package Bencher::Scenario::PermuteNamedModules;

our $DATE = '2016-06-26'; # DATE
our $VERSION = '0.03'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark various modules doing permutation of multiple-valued key-value pairs',
    participants => [
        {
            module => "PERLANCAR::Permute::Named",
            code => sub {
                my @res = PERLANCAR::Permute::Named::permute_named(@_);
            },
        },
        {
            module => "Permute::Named",
            code => sub {
                my @res = Permute::Named::permute_named(@_);
            },
        },
        {
            module => "Permute::Named::Iter",
            code => sub {
                my $iter = Permute::Named::Iter::permute_named_iter(@_);
                my @res;
                while (my $h = $iter->()) { push @res, $h }
            },
        },
    ],
    datasets => [
        {argv=>[a=>[1,2], b=>[1,2,3]], name=>'small (2x3=6)'},
        {argv=>[a=>[1,2], b=>[1..50]], name=>'long (2x50=100)'},
        {argv=>[a=>[1,2], a=>[1,2], c=>[1,2], d=>[1,2], e=>[1,2], f=>[1,2], g=>[1,2], h=>[1,2], i=>[1,2], j=>[1,2]], name=>'wide (2**10=1k)'},
        {argv=>[a=>[1..10], b=>[1..10], c=>[1..10], d=>[1..2], e=>[1..2], f=>[1..3]], name=>'large (10x10x10x2x2x3=12ki)'},
    ],
};

1;
# ABSTRACT: Benchmark various modules doing permutation of multiple-valued key-value pairs

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PermuteNamedModules - Benchmark various modules doing permutation of multiple-valued key-value pairs

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::PermuteNamedModules (from Perl distribution Bencher-Scenario-PermuteNamedModules), released on 2016-06-26.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PermuteNamedModules

To run module startup overhead benchmark:

 % bencher --module-startup -m PermuteNamedModules

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<PERLANCAR::Permute::Named> 0.02

L<Permute::Named> 1.100980

L<Permute::Named::Iter> 0.02

=head1 BENCHMARK PARTICIPANTS

=over

=item * PERLANCAR::Permute::Named (perl_code)

L<PERLANCAR::Permute::Named>



=item * Permute::Named (perl_code)

L<Permute::Named>



=item * Permute::Named::Iter (perl_code)

L<Permute::Named::Iter>



=back

=head1 BENCHMARK DATASETS

=over

=item * small (2x3=6)

=item * long (2x50=100)

=item * wide (2**10=1k)

=item * large (10x10x10x2x2x3=12ki)

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PermuteNamedModules >>):

 +---------------------------+-----------------------------+-----------+-----------+------------+---------+---------+
 | participant               | dataset                     | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +---------------------------+-----------------------------+-----------+-----------+------------+---------+---------+
 | Permute::Named            | large (10x10x10x2x2x3=12ki) |      12   |   80      |       1    | 8.1e-05 |      20 |
 | PERLANCAR::Permute::Named | large (10x10x10x2x2x3=12ki) |      39   |   25      |       3.1  | 4.3e-05 |      22 |
 | Permute::Named::Iter      | large (10x10x10x2x2x3=12ki) |      43   |   23      |       3.4  | 5.5e-05 |      20 |
 | Permute::Named            | wide (2**10=1k)             |      97.8 |   10.2    |       7.84 | 4.1e-06 |      20 |
 | PERLANCAR::Permute::Named | wide (2**10=1k)             |     290   |    3.5    |      23    | 1.2e-05 |      20 |
 | Permute::Named::Iter      | wide (2**10=1k)             |     324   |    3.09   |      25.9  | 9.1e-07 |      20 |
 | Permute::Named            | long (2x50=100)             |    3630   |    0.275  |     291    | 1.6e-07 |      20 |
 | PERLANCAR::Permute::Named | long (2x50=100)             |    7100   |    0.14   |     570    | 2.1e-07 |      20 |
 | Permute::Named::Iter      | long (2x50=100)             |    9500   |    0.11   |     760    | 1.6e-07 |      20 |
 | PERLANCAR::Permute::Named | small (2x3=6)               |   22000   |    0.045  |    1800    | 1.1e-07 |      24 |
 | Permute::Named            | small (2x3=6)               |   29000   |    0.034  |    2300    | 5.3e-08 |      20 |
 | Permute::Named::Iter      | small (2x3=6)               |   95000   |    0.0105 |    7610    |   3e-09 |      24 |
 +---------------------------+-----------------------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m PermuteNamedModules --module-startup >>):

 +---------------------------+-----------+------------------------+------------+---------+---------+
 | participant               | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------------+-----------+------------------------+------------+---------+---------+
 | Permute::Named            |      13   |                    7.9 |        1   | 5.7e-05 |      20 |
 | Permute::Named::Iter      |       7.6 |                    2.5 |        1.7 | 2.5e-05 |      20 |
 | PERLANCAR::Permute::Named |       7.6 |                    2.5 |        1.7 | 2.5e-05 |      20 |
 | perl -e1 (baseline)       |       5.1 |                    0   |        2.6 | 1.2e-05 |      20 |
 +---------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-PermuteNamedModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-PermuteNamedModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-PermuteNamedModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
