package Bencher::Scenario::ModulePathMore;

our $DATE = '2016-08-07'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark Module::Path::More vs Module::Path',
    participants => [
        {
            name => 'MP',
            fcall_template => 'Module::Path::module_path(<module>)',
        },
        {
            name => 'MPM',
            fcall_template => 'Module::Path::More::module_path(module => <module>)',
        },
        {
            name => 'MPM(abs=1)',
            fcall_template => 'Module::Path::More::module_path(module => <module>, abs=>1)',
        },
    ],
    datasets => [
        {args=>{module=>'strict'}},
        {args=>{module=>'Foo::Bar'}},
    ],
};

1;
# ABSTRACT: Benchmark Module::Path::More vs Module::Path

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ModulePathMore - Benchmark Module::Path::More vs Module::Path

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::ModulePathMore (from Perl distribution Bencher-Scenario-ModulePathMore), released on 2016-08-07.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ModulePathMore

To run module startup overhead benchmark:

 % bencher --module-startup -m ModulePathMore

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Module::Path> 0.19

L<Module::Path::More> 0.31

=head1 BENCHMARK PARTICIPANTS

=over

=item * MP (perl_code)

Function call template:

 Module::Path::module_path(<module>)



=item * MPM (perl_code)

Function call template:

 Module::Path::More::module_path(module => <module>)



=item * MPM(abs=1) (perl_code)

Function call template:

 Module::Path::More::module_path(module => <module>, abs=>1)



=back

=head1 BENCHMARK DATASETS

=over

=item * strict

=item * Foo::Bar

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m ModulePathMore >>):

 #table1#
 +-------------+----------+-----------+-----------+------------+---------+---------+
 | participant | dataset  | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-------------+----------+-----------+-----------+------------+---------+---------+
 | MP          | Foo::Bar |   23700   |   42.1    |    1       | 1.3e-08 |      20 |
 | MP          | strict   |   24700   |   40.5    |    1.04    | 1.1e-08 |      32 |
 | MPM(abs=1)  | strict   |   46969.5 |   21.2904 |    1.97806 |   0     |      24 |
 | MPM(abs=1)  | Foo::Bar |   62518.3 |   15.9953 |    2.63288 |   0     |      22 |
 | MPM         | Foo::Bar |   63000   |   15.9    |    2.65    | 6.4e-09 |      22 |
 | MPM         | strict   |   67404.8 |   14.8357 |    2.83867 |   0     |      20 |
 +-------------+----------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m ModulePathMore --module-startup >>):

 #table2#
 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Module::Path        |       7.6 |                    5.2 |        1   | 2.3e-05 |      20 |
 | Module::Path::More  |       4.6 |                    2.2 |        1.7 | 1.3e-05 |      20 |
 | perl -e1 (baseline) |       2.4 |                    0   |        3.2 | 3.1e-06 |      20 |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-ModulePathMore>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-ModulePathMore>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-ModulePathMore>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
