package App::BPOMUtils::Table::MicrobeInput;

use 5.010001;
use strict 'subs', 'vars';
use utf8;
use warnings;
use Log::ger;

use Exporter 'import';
use Perinci::Sub::Gen::AccessTable qw(gen_read_table_func);

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-02-13'; # DATE
our $DIST = 'App-BPOMUtils-Table'; # DIST
our $VERSION = '0.016'; # VERSION

our @EXPORT_OK = qw(
                       bpom_list_microbe_inputs
               );

our %SPEC;

# BEGIN FRAGMENT id=meta-idn_bpom_cemaran_mikroba_pangan varname=meta_idn_bpom_cemaran_mikroba_pangan
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_cemaran_mikroba_pangan/meta.yaml
# src-revision: 2bd9f0c167f50a1f0fd3f05080ddb342a177227b (Tue Nov 1 10:47:47 2022 +0700)
# generate-date: Fri Jan 20 09:03:12 2023 UTC
# generated-by: update-fragments-in-perl-module
our $meta_idn_bpom_cemaran_mikroba_pangan = {
  "fields" => {
    category => {
      "filterable_regex" => "Yes",
      "pos" => 1,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Category",
      "summary.alt.lang.id" => "Kategori",
      "unique" => "Yes",
    },
    characteristic => {
      "filterable_regex" => "Yes",
      "pos" => 2,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Characteristic",
      "summary.alt.lang.id" => "Karakteristik",
      "unique" => "Yes",
    },
    id => {
      "filterable_regex" => "Yes",
      "pos" => 0,
      "schema" => "uint*",
      "sortable" => "Yes",
      "summary" => "ID",
      "summary.alt.lang.id" => "ID",
      "unique" => "Yes",
    },
    lower_limit => {
      "filterable_regex" => "Yes",
      "pos" => 4,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Lower limit",
      "summary.alt.lang.id" => "Batas bawah",
      "unique" => "Yes",
    },
    upper_limit => {
      "filterable_regex" => "Yes",
      "pos" => 3,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Upper limit",
      "summary.alt.lang.id" => "Batas atas",
      "unique" => "Yes",
    },
  },
  "pk" => "id",
  "summary" => "Microbe specification in BPOM processed food division",
  "summary.alt.lang.id_ID" => "Cemaran mikroba di BPOM pangan olahan",
};
# END FRAGMENT id=meta-idn_bpom_cemaran_mikroba_pangan

# BEGIN FRAGMENT id=data-idn_bpom_cemaran_mikroba_pangan varname=data_idn_bpom_cemaran_mikroba_pangan
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_cemaran_mikroba_pangan/data.csv
# src-revision: 2bd9f0c167f50a1f0fd3f05080ddb342a177227b (Tue Nov 1 10:47:47 2022 +0700)
# generate-date: Fri Jan 20 09:03:12 2023 UTC
# generated-by: update-fragments-in-perl-module
our $data_idn_bpom_cemaran_mikroba_pangan = [
  [
    1,
    "",
    "Escherichia coli (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2,
    "",
    "Escherichia coli (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    3,
    "",
    "Escherichia coli (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4,
    "",
    "Escherichia coli (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5,
    "",
    "Escherichia coli (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [6, "", "Salmonella (/25 g)"],
  [7, "", "Jumlah Sampel - Salmonella", "\x{2265}"],
  [8, "", "Salmonella (/25 g)"],
  [9, "", "Jumlah Sampel - Salmonella", "\x{2265}"],
  [
    10,
    "",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    11,
    "",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    12,
    "",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [13, "", "Salmonella (/25 g)"],
  [14, "", "Jumlah Sampel - Salmonella"],
  [15, "", "Salmonella (/25 g)"],
  [16, "", "Jumlah Sampel - Salmonella"],
  [17, "", "Salmonella (/25 g)"],
  [18, "", "Jumlah Sampel - Salmonella"],
  [19, "", "Salmonella (/25 g)"],
  [20, "", "Jumlah Sampel - Salmonella"],
  [21, "", "Salmonella (/25 g)"],
  [22, "", "Jumlah Sampel - Salmonella"],
  [
    23,
    "Cumi-Cumi / Kerang / Ikan / ... Beku dengan Penambahan Bahan Lain (09020130)",
    "Salmonella (/25 g)",
  ],
  [
    24,
    "Cumi-Cumi / Kerang / Ikan / ... Beku dengan Penambahan Bahan Lain (09020130)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    25,
    "Cumi-Cumi / Kerang / Ikan / ... Beku dengan Penambahan Bahan Lain (09020130)",
    "Vibrio parahaemolyticus (APM/g)",
  ],
  [
    26,
    "Cumi-Cumi / Kerang / Ikan / ... Beku dengan Penambahan Bahan Lain (09020130)",
    "Vibrio parahaemolyticus (APM/g)",
  ],
  [
    27,
    "Cumi-Cumi / Kerang / Ikan / ... Beku dengan Penambahan Bahan Lain (09020130)",
    "Vibrio parahaemolyticus (APM/g)",
  ],
  [
    28,
    "Cumi-Cumi / Kerang / Ikan / ... Beku dengan Penambahan Bahan Lain (09020130)",
    "Vibrio parahaemolyticus (APM/g)",
  ],
  [
    29,
    "Cumi-Cumi / Kerang / Ikan / ... Beku dengan Penambahan Bahan Lain (09020130)",
    "Vibrio parahaemolyticus (APM/g)",
  ],
  [
    30,
    "(Saus Teremulsi) untuk Saus Mayo (12060107)",
    "Salmonella (/25 g)",
  ],
  [
    31,
    "(Saus Teremulsi) untuk Saus Mayo (12060107)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    32,
    "Abon Daging (08020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    33,
    "Abon Daging (08020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    34,
    "Abon Daging (08020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    35,
    "Abon Daging (08020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    36,
    "Abon Daging (08020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    37,
    "Abon Daging (08020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    38,
    "Abon Daging (08020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    39,
    "Abon Daging (08020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    40,
    "Abon Daging (08020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    41,
    "Abon Daging (08020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    42,
    "Abon Daging (08020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    43,
    "Abon Daging (08020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    44,
    "Abon Daging (08020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    45,
    "Abon Daging (08020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    46,
    "Abon Daging (08020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [47, "Abon Daging (08020213)", "Salmonella (/25 g)"],
  [48, "Abon Daging (08020213)", "Salmonella (/25 g)"],
  [49, "Abon Daging (08020213)", "Salmonella (/25 g)"],
  [50, "Abon Daging (08020213)", "Jumlah Sampel - Salmonella"],
  [51, "Abon Daging (08020213)", "Jumlah Sampel - Salmonella"],
  [52, "Abon Daging (08020213)", "Jumlah Sampel - Salmonella"],
  [
    53,
    "Abon Daging (08020213)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    54,
    "Abon Daging (08020213)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    55,
    "Abon Daging (08020213)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    56,
    "Abon Daging (08020213)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    57,
    "Abon Daging (08020213)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    58,
    "Abon Daging (08020213)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    59,
    "Abon Daging (08020213)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    60,
    "Abon Daging (08020213)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    61,
    "Abon Daging (08020213)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    62,
    "Abon Daging (08020213)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    63,
    "Abon Daging (08020213)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    64,
    "Abon Daging (08020213)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    65,
    "Abon Daging (08020213)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    66,
    "Abon Daging (08020213)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    67,
    "Abon Daging (08020213)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    68,
    "Abon Ikan (0902040304)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    69,
    "Abon Ikan (0902040304)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    70,
    "Abon Ikan (0902040304)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    71,
    "Abon Ikan (0902040304)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    72,
    "Abon Ikan (0902040304)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    73,
    "Abon Udang (0902040307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    74,
    "Abon Udang (0902040307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    75,
    "Abon Udang (0902040307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    76,
    "Abon Udang (0902040307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    77,
    "Abon Udang (0902040307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [78, "Acar (Sweet Pickle) (0402020322)", "Salmonella (/25ml)"],
  [
    79,
    "Acar (Sweet Pickle) (0402020322)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [80, "Acar Bawang Putih (0402020306)", "Salmonella (/25 g)"],
  [
    81,
    "Acar Bawang Putih (0402020306)",
    "Jumlah Sampel - Salmonella",
  ],
  [82, "Acar Cabe (0402020308)", "Salmonella (/25 g)"],
  [83, "Acar Cabe (0402020308)", "Jumlah Sampel - Salmonella"],
  [84, "Acar Jahe (0402020307)", "Salmonella (/25 g)"],
  [85, "Acar Jahe (0402020307)", "Jumlah Sampel - Salmonella"],
  [86, "Acar Jamur (0402020304)", "Salmonella (/25 g)"],
  [87, "Acar Jamur (0402020304)", "Jumlah Sampel - Salmonella"],
  [88, "Acar Lobak (0402020309)", "Salmonella (/25 g)"],
  [89, "Acar Lobak (0402020309)", "Jumlah Sampel - Salmonella"],
  [90, "Acar Sayur (0402020320)", "Salmonella (/25 g)"],
  [91, "Acar Sayur (0402020320)", "Jumlah Sampel - Salmonella"],
  [92, "Acar Timun Mentah (0402020305)", "Salmonella (/25 g)"],
  [
    93,
    "Acar Timun Mentah (0402020305)",
    "Jumlah Sampel - Salmonella",
  ],
  [94, "Adas Bubuk (12020105)", "Salmonella (/25 g)"],
  [95, "Adas Bubuk (12020105)", "Jumlah Sampel - Salmonella"],
  [
    96,
    "Adas Bubuk (12020105)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    97,
    "Adas Bubuk (12020105)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    98,
    "Adas Bubuk (12020105)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    99,
    "Adas Bubuk (12020105)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    100,
    "Adas Bubuk (12020105)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    101,
    "Adas Bubuk (12020105)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    102,
    "Adas Bubuk (12020105)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    103,
    "Adas Bubuk (12020105)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    104,
    "Adas Bubuk (12020105)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    105,
    "Adas Bubuk (12020105)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    106,
    "Adas, Adas Pedas, Fennel, Jinten Manis (12020104)",
    "Salmonella (/25 g)",
  ],
  [
    107,
    "Adas, Adas Pedas, Fennel, Jinten Manis (12020104)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    108,
    "Adas, Adas Pedas, Fennel, Jinten Manis (12020104)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    109,
    "Adas, Adas Pedas, Fennel, Jinten Manis (12020104)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    110,
    "Adas, Adas Pedas, Fennel, Jinten Manis (12020104)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    111,
    "Adas, Adas Pedas, Fennel, Jinten Manis (12020104)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    112,
    "Adas, Adas Pedas, Fennel, Jinten Manis (12020104)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    113,
    "Adas, Adas Pedas, Fennel, Jinten Manis (12020104)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    114,
    "Adas, Adas Pedas, Fennel, Jinten Manis (12020104)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    115,
    "Adas, Adas Pedas, Fennel, Jinten Manis (12020104)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    116,
    "Adas, Adas Pedas, Fennel, Jinten Manis (12020104)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    117,
    "Adas, Adas Pedas, Fennel, Jinten Manis (12020104)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [118, "Adonan Shortened Bread (07010406)", "Salmonella (/25 g)"],
  [
    119,
    "Adonan Shortened Bread (07010406)",
    "Jumlah Sampel - Salmonells",
    "",
    "\x{2265}5",
  ],
  [
    120,
    "Air Mineral Alami (1401010105)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    121,
    "Air Mineral Alami (1401010105)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    122,
    "Air Mineral Alami (1401010105)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    123,
    "Air Mineral Alami (1401010105)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    124,
    "Air Mineral Alami (1401010105)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    125,
    "Air Mineral Alami (1401010105)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [126, "Air Mineral Alami (1401010105)", "Enterococci (/250 ml)"],
  [127, "Air Mineral Alami (1401010105)", "Enterococci (/250 ml)"],
  [128, "Air Mineral Alami (1401010105)", "Enterococci (/250 ml)"],
  [129, "Air Mineral Alami (1401010105)", "Enterococci (/250 ml)"],
  [130, "Air Mineral Alami (1401010105)", "Enterococci (/250 ml)"],
  [131, "Air Mineral Alami (1401010105)", "Enterococci (/250 ml)"],
  [
    132,
    "Air Mineral Alami (1401010105)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    133,
    "Air Mineral Alami (1401010105)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    134,
    "Air Mineral Alami (1401010105)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    135,
    "Air Mineral Alami (1401010105)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    136,
    "Air Mineral Alami (1401010105)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    137,
    "Air Mineral Alami (1401010105)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    138,
    "Air Mineral Alami (1401010105)",
    "Jumlah Sampel - Bakteri anaerob pereduksi sulfit pembentuk spora",
  ],
  [
    139,
    "Air Mineral Alami (1401010105)",
    "Jumlah Sampel - Enteococci",
  ],
  [
    140,
    "Air Mineral Alami (1401010105)",
    "Jumlah Sampel - Pseudomonas aeruginosa",
  ],
  [
    141,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    142,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    143,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    144,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    145,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    146,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    147,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Enterococci (/250 ml)",
  ],
  [
    148,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Enterococci (/250 ml)",
  ],
  [
    149,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Enterococci (/250 ml)",
  ],
  [
    150,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Enterococci (/250 ml)",
  ],
  [
    151,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Enterococci (/250 ml)",
  ],
  [
    152,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Enterococci (/250 ml)",
  ],
  [
    153,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    154,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    155,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    156,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    157,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    158,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    159,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Jumlah Sampel - Bakteri anaerob pereduksi sulfit pembentuk spora",
  ],
  [
    160,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Jumlah Sampel - Enteococci",
  ],
  [
    161,
    "Air Mineral Alami Dikarbonasi (Carbonated Natural Mineral Water) (1401010104)",
    "Jumlah Sampel - Pseudomonas aeruginosa",
  ],
  [
    162,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    163,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    164,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    165,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    166,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    167,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    168,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Enterococci (/250 ml)",
  ],
  [
    169,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Enterococci (/250 ml)",
  ],
  [
    170,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Enterococci (/250 ml)",
  ],
  [
    171,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Enterococci (/250 ml)",
  ],
  [
    172,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Enterococci (/250 ml)",
  ],
  [
    173,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Enterococci (/250 ml)",
  ],
  [
    174,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    175,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    176,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    177,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    178,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    179,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    180,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Jumlah Sampel - Bakteri anaerob pereduksi sulfit pembentuk spora",
  ],
  [
    181,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Jumlah Sampel - Enteococci",
  ],
  [
    182,
    "Air Mineral Alami Terkarbonasi Secara Alami (Naturally Carbonated Natural Mineral Water) (1401010101)",
    "Jumlah Sampel - Pseudomonas aeruginosa",
  ],
  [
    183,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    184,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    185,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    186,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    187,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    188,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Bakteri anaerob pereduksi sulfit pembentuk spora (/50 ml)",
  ],
  [
    189,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Enterococci (/250 ml)",
  ],
  [
    190,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Enterococci (/250 ml)",
  ],
  [
    191,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Enterococci (/250 ml)",
  ],
  [
    192,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Enterococci (/250 ml)",
  ],
  [
    193,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Enterococci (/250 ml)",
  ],
  [
    194,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Enterococci (/250 ml)",
  ],
  [
    195,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    196,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    197,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    198,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    199,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    200,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    201,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Jumlah Sampel - Bakteri anaerob pereduksi sulfit pembentuk spora",
  ],
  [
    202,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Jumlah Sampel - Enteococci",
  ],
  [
    203,
    "Air Mineral Alami yang Didekarbonasi Penuh atau Sebagian (1401010102)",
    "Jumlah Sampel - Pseudomonas aeruginosa",
  ],
  [
    204,
    "Akar Chicory (12020198)",
    "Jumlah Sampel - Salmonella - Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [205, ""],
  [
    206,
    "Akar Chicory (12020198)",
    "Jumlah Sampel - Salmonella - Semua Herba Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [207, "Akar Chicory (12020198)", "Jumlah Sampel - Salmonella"],
  [208, "Akar Chicory (12020198)", "Salmonella (/25 g)"],
  [209, "Akar Chicory (12020198)", "Salmonella (/25 g)"],
  [210, "Akar Chicory (12020198)", "Salmonella (/25 g)"],
  [211, "Akar Chicory (12020198)", "Salmonella (/25 g)"],
  [212, "Akar Chicory (12020198)", "Salmonella (/25 g)"],
  [
    213,
    "Akar Chicory (12020198)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    214,
    "Akar Chicory (12020198)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    215,
    "Akar Chicory (12020198)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    216,
    "Akar Chicory (12020198)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    217,
    "Akar Chicory (12020198)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    218,
    "Akar Chicory (12020198)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    219,
    "Akar Chicory (12020198)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    220,
    "Akar Chicory (12020198)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    221,
    "Akar Chicory (12020198)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    222,
    "Akar Chicory (12020198)",
    "Bacillus cereus (koloni/g) - Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    223,
    "Akar Chicory (12020198)",
    "Bacillus cereus (koloni/g) - Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    224,
    "Akar Chicory (12020198)",
    "Bacillus cereus (koloni/g) - Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    225,
    "Akar Chicory (12020198)",
    "Bacillus cereus (koloni/g) - Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    226,
    "Akar Chicory (12020198)",
    "Bacillus cereus (koloni/g) - Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    227,
    "Akar Chicory (12020198)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    228,
    "Akar Chicory (12020198)",
    "Salmonella (/25 g) - Semua Herba Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [
    229,
    "Akar Chicory (12020198)",
    "Salmonella (/25 g) - Semua Herba Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [
    230,
    "Akar Chicory (12020198)",
    "Salmonella (/25 g) - Semua Herba Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [
    231,
    "Akar Chicory (12020198)",
    "Salmonella (/25 g) - Semua Herba Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [
    232,
    "Akar Chicory (12020198)",
    "Salmonella (/25 g) - Semua Herba Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [
    233,
    "Akar Chicory (12020198)",
    "Salmonella (/25 g) - Semua Herba Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [234, ""],
  [
    235,
    "Akar Chicory (12020198)",
    "Salmonella (/25 g) - Semua Herba Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [236, ""],
  [
    237,
    "Akar Chicory (12020198)",
    "Salmonella (/25 g) - Semua Herba Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [238, ""],
  [
    239,
    "Akar Chicory (12020198)",
    "Salmonella (/25 g) - Semua Herba Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [240, ""],
  [
    241,
    "Akar Chicory (12020198)",
    "Salmonella (/25 g) - Semua Herba Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [242, ""],
  [
    243,
    "Akar Chicory (12020198)",
    "Salmonella (/25 g) - Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [
    244,
    "Akar Chicory (12020198)",
    "Salmonella (/25 g) - Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [
    245,
    "Akar Chicory (12020198)",
    "Salmonella (/25 g) - Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [
    246,
    "Akar Chicory (12020198)",
    "Salmonella (/25 g) - Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [
    247,
    "Akar Chicory (12020198)",
    "Salmonella (/25 g) - Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [
    248,
    "Akar Chicory (12020198)",
    "Clostridium pefringens (koloni/g) - Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    249,
    "Akar Chicory (12020198)",
    "Clostridium pefringens (koloni/g) - Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    250,
    "Akar Chicory (12020198)",
    "Clostridium pefringens (koloni/g) - Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    251,
    "Akar Chicory (12020198)",
    "Clostridium pefringens (koloni/g) - Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    252,
    "Akar Chicory (12020198)",
    "Clostridium pefringens (koloni/g) - Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [253, "Allspice (12020109)", "Salmonella (/25 g)"],
  [254, "Allspice (12020109)", "Jumlah Sampel - Salmonella"],
  [
    255,
    "Allspice (12020109)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    256,
    "Allspice (12020109)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    257,
    "Allspice (12020109)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    258,
    "Allspice (12020109)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    259,
    "Allspice (12020109)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    260,
    "Allspice (12020109)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    261,
    "Allspice (12020109)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    262,
    "Allspice (12020109)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    263,
    "Allspice (12020109)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    264,
    "Allspice (12020109)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    265,
    "Amparan Tatak Pisang (060715)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    266,
    "Amparan Tatak Pisang (060715)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    267,
    "Amparan Tatak Pisang (060715)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    268,
    "Amparan Tatak Pisang (060715)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    269,
    "Amparan Tatak Pisang (060715)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [270, "Amparan Tatak Pisang (060715)", "Salmonella (/25 g)"],
  [
    271,
    "Amparan Tatak Pisang (060715)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    272,
    "Amparan Tatak Pisang (060715)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    273,
    "Amparan Tatak Pisang (060715)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    274,
    "Amparan Tatak Pisang (060715)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    275,
    "Amparan Tatak Pisang (060715)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    276,
    "Amparan Tatak Pisang (060715)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    277,
    "Analog keju (010605)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    278,
    "Analog keju (010605)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    279,
    "Analog keju (010605)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    280,
    "Analog keju (010605)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    281,
    "Analog keju (010605)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [282, "Andaliman (12020173)", "Salmonella (/25 g)"],
  [283, "Andaliman (12020173)", "Jumlah Sampel - Salmonella"],
  [
    284,
    "Andaliman (12020173)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    285,
    "Andaliman (12020173)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    286,
    "Andaliman (12020173)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    287,
    "Andaliman (12020173)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    288,
    "Andaliman (12020173)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    289,
    "Andaliman (12020173)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    290,
    "Andaliman (12020173)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    291,
    "Andaliman (12020173)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    292,
    "Andaliman (12020173)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    293,
    "Andaliman (12020173)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [294, "Apem (07010503)", "Salmonella (/25 g)"],
  [295, "Apem (07010503)", "Jumlah Sampel - Salmonella"],
  [296, "Asam Glugur (12020106)", "Salmonella (/25 g)"],
  [297, "Asam Glugur (12020106)", "Jumlah Sampel - Salmonella"],
  [
    298,
    "Asam Glugur (12020106)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    299,
    "Asam Glugur (12020106)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    300,
    "Asam Glugur (12020106)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    301,
    "Asam Glugur (12020106)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    302,
    "Asam Glugur (12020106)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    303,
    "Asam Glugur (12020106)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    304,
    "Asam Glugur (12020106)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    305,
    "Asam Glugur (12020106)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    306,
    "Asam Glugur (12020106)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    307,
    "Asam Glugur (12020106)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [308, "Asam Jawa (12020107)", "Salmonella (/25 g)"],
  [309, "Asam Jawa (12020107)", "Jumlah Sampel - Salmonella"],
  [
    310,
    "Asam Jawa (12020107)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    311,
    "Asam Jawa (12020107)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    312,
    "Asam Jawa (12020107)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    313,
    "Asam Jawa (12020107)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    314,
    "Asam Jawa (12020107)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    315,
    "Asam Jawa (12020107)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    316,
    "Asam Jawa (12020107)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    317,
    "Asam Jawa (12020107)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    318,
    "Asam Jawa (12020107)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    319,
    "Asam Jawa (12020107)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [320, "Asam Kandis (12020108)", "Salmonella (/25 g)"],
  [321, "Asam Kandis (12020108)", "Jumlah Sampel - Salmonella"],
  [
    322,
    "Asam Kandis (12020108)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    323,
    "Asam Kandis (12020108)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    324,
    "Asam Kandis (12020108)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    325,
    "Asam Kandis (12020108)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    326,
    "Asam Kandis (12020108)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    327,
    "Asam Kandis (12020108)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    328,
    "Asam Kandis (12020108)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    329,
    "Asam Kandis (12020108)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    330,
    "Asam Kandis (12020108)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    331,
    "Asam Kandis (12020108)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [332, "Asam Sunti (12020199)", "Salmonella (/25 g)"],
  [333, "Asam Sunti (12020199)", "Jumlah Sampel - Salmonella"],
  [
    334,
    "Asam Sunti (12020199)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    335,
    "Asam Sunti (12020199)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    336,
    "Asam Sunti (12020199)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    337,
    "Asam Sunti (12020199)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    338,
    "Asam Sunti (12020199)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    339,
    "Asam Sunti (12020199)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    340,
    "Asam Sunti (12020199)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    341,
    "Asam Sunti (12020199)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    342,
    "Asam Sunti (12020199)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    343,
    "Asam Sunti (12020199)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [344, "Asinan Buah (0401020302)", "Jumlah Sampel - Salmonella"],
  [345, "Asinan Buah (0401020302)", "Salmonella (/25 g)"],
  [346, "Asinan Jahe (0402020323)", "Salmonella (/25ml)"],
  [
    347,
    "Asinan Jahe (0402020323)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [348, "Aspic Ikan (09030103)", "Salmonella (/25 g)"],
  [349, "Aspic Ikan (09030103)", "Jumlah Sampel - Salmonella"],
  [
    350,
    "Ayam Cordon Bleu (Chicken Cordon Bleu) (08020308)",
    "Salmonella (/25 g)",
  ],
  [
    351,
    "Ayam Cordon Bleu (Chicken Cordon Bleu) (08020308)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    352,
    "Ayam Cordon Bleu (Chicken Cordon Bleu) (08020308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    353,
    "Ayam Cordon Bleu (Chicken Cordon Bleu) (08020308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    354,
    "Ayam Cordon Bleu (Chicken Cordon Bleu) (08020308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    355,
    "Ayam Cordon Bleu (Chicken Cordon Bleu) (08020308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    356,
    "Ayam Cordon Bleu (Chicken Cordon Bleu) (08020308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    357,
    "Ayam Cordon Bleu (Chicken Cordon Bleu) (08020308)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    358,
    "Ayam Cordon Bleu (Chicken Cordon Bleu) (08020308)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    359,
    "Ayam Goreng (Fried Chicken) (08020303)",
    "Salmonella (/25 g)",
  ],
  [
    360,
    "Ayam Goreng (Fried Chicken) (08020303)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    361,
    "Ayam Goreng (Fried Chicken) (08020303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    362,
    "Ayam Goreng (Fried Chicken) (08020303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    363,
    "Ayam Goreng (Fried Chicken) (08020303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    364,
    "Ayam Goreng (Fried Chicken) (08020303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    365,
    "Ayam Goreng (Fried Chicken) (08020303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    366,
    "Ayam Goreng (Fried Chicken) (08020303)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    367,
    "Ayam Goreng (Fried Chicken) (08020303)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    368,
    "Ayam Karage (Chicken karage) (08020309)",
    "Salmonella (/25 g)",
  ],
  [
    369,
    "Ayam Karage (Chicken karage) (08020309)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    370,
    "Ayam Karage (Chicken karage) (08020309)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    371,
    "Ayam Karage (Chicken karage) (08020309)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    372,
    "Ayam Karage (Chicken karage) (08020309)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    373,
    "Ayam Karage (Chicken karage) (08020309)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    374,
    "Ayam Karage (Chicken karage) (08020309)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    375,
    "Ayam Karage (Chicken karage) (08020309)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    376,
    "Ayam Karage (Chicken karage) (08020309)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    377,
    "Ayam Katsu (Chicken Katsu) (08020301)",
    "Salmonella (/25 g)",
  ],
  [
    378,
    "Ayam Katsu (Chicken Katsu) (08020301)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    379,
    "Ayam Katsu (Chicken Katsu) (08020301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    380,
    "Ayam Katsu (Chicken Katsu) (08020301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    381,
    "Ayam Katsu (Chicken Katsu) (08020301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    382,
    "Ayam Katsu (Chicken Katsu) (08020301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    383,
    "Ayam Katsu (Chicken Katsu) (08020301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    384,
    "Ayam Katsu (Chicken Katsu) (08020301)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    385,
    "Ayam Katsu (Chicken Katsu) (08020301)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    386,
    "Bacon (0802010101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    387,
    "Bacon (0802010101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    388,
    "Bacon (0802010101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    389,
    "Bacon (0802010101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    390,
    "Bacon (0802010101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [391, "Bacon (0802010101)", "Salmonella (/25 g)"],
  [392, "Bacon (0802010101)", "Jumlah Sampel - Salmonella"],
  [
    393,
    "Bacon Sapi (0802010102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    394,
    "Bacon Sapi (0802010102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    395,
    "Bacon Sapi (0802010102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    396,
    "Bacon Sapi (0802010102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    397,
    "Bacon Sapi (0802010102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [398, "Bacon Sapi (0802010102)", "Salmonella (/25 g)"],
  [399, "Bacon Sapi (0802010102)", "Jumlah Sampel - Salmonella"],
  [400, "Bagel (07010302)", "Salmonella (/25 g)"],
  [401, "Bagel (07010302)", "Jumlah Sampel - Salmonella"],
  [
    402,
    "Bahu Sapi Curing Matang (08020205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    403,
    "Bahu Sapi Curing Matang (08020205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    404,
    "Bahu Sapi Curing Matang (08020205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    405,
    "Bahu Sapi Curing Matang (08020205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    406,
    "Bahu Sapi Curing Matang (08020205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    407,
    "Bahu Sapi Curing Matang (08020205)",
    "Salmonella (/25 g)",
  ],
  [
    408,
    "Bahu Sapi Curing Matang (08020205)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    409,
    "Bahu Sapi Curing Matang (08020205)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    410,
    "Bahu Sapi Curing Matang (08020205)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    411,
    "Bahu Sapi Curing Matang (08020205)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    412,
    "Bahu Sapi Curing Matang (08020205)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    413,
    "Bahu Sapi Curing Matang (08020205)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [414, "Bakpao/Pao (07010502)", "Salmonella (/25 g)"],
  [415, "Bakpao/Pao (07010502)", "Jumlah Sampel - Salmonella"],
  [416, "Bakpia (07020210)", "Salmonella (/25 g)"],
  [417, "Bakpia (07020210)", "Jumlah Sampel - Salmonella"],
  [
    418,
    "Bakpia (07020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    419,
    "Bakpia (07020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    420,
    "Bakpia (07020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    421,
    "Bakpia (07020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    422,
    "Bakpia (07020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [423, "Bakso Campur dan Batagor (1675)", "Salmonella (/25 g)"],
  [
    424,
    "Bakso Campur dan Batagor (1675)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    425,
    "Bakso Campur dan Batagor (1675)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    426,
    "Bakso Campur dan Batagor (1675)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    427,
    "Bakso Campur dan Batagor (1675)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    428,
    "Bakso Campur dan Batagor (1675)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    429,
    "Bakso Campur dan Batagor (1675)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    430,
    "Bakso Campur dan Batagor (1675)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    431,
    "Bakso Campur dan Batagor (1675)",
    "Jumlah Sampel - Listeria monocytogenes",
    "",
    "\x{2265}5",
  ],
  [432, "Bakso Daging (08030244)", "Salmonella (koloni/25 g)"],
  [433, "Bakso Daging (08030244)", "Jumlah Sampel - Salmonella"],
  [
    434,
    "Bakso Daging (08030244)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    435,
    "Bakso Daging (08030244)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    436,
    "Bakso Daging (08030244)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    437,
    "Bakso Daging (08030244)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    438,
    "Bakso Daging (08030244)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    439,
    "Bakso Daging Kombinasi (08030230)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    440,
    "Bakso Daging Kombinasi (08030230)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    441,
    "Bakso Daging Kombinasi (08030230)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    442,
    "Bakso Daging Kombinasi (08030230)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    443,
    "Bakso Daging Kombinasi (08030230)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    444,
    "Bakso Daging Kombinasi (08030230)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    445,
    "Bakso Daging Kombinasi (08030230)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    446,
    "Bakso Daging Kombinasi (08030230)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    447,
    "Bakso Daging Kombinasi (08030230)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    448,
    "Bakso Daging Kombinasi (08030230)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    449,
    "Bakso Daging Kombinasi (08030230)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    450,
    "Bakso Daging Kombinasi (08030230)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    451,
    "Bakso Daging Kombinasi (08030230)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    452,
    "Bakso Daging Kombinasi (08030230)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    453,
    "Bakso Daging Kombinasi (08030230)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    454,
    "Bakso Daging Kombinasi (08030230)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    455,
    "Bakso Daging Kombinasi (08030230)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    456,
    "Bakso Daging Kombinasi (08030230)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    457,
    "Bakso Daging Kombinasi (08030230)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    458,
    "Bakso Daging Kombinasi (08030230)",
    "Jumlah Sampel - Salmonella",
  ],
  [459, "Bakso Goreng (08030318)", "Salmonella (koloni/25 ml)"],
  [460, "Bakso Goreng (08030318)", "Salmonella (koloni/25 ml)"],
  [461, "Bakso Goreng (08030318)", "Jumlah Sampel - Salmonella"],
  [462, "Bakso Goreng (08030318)", "Jumlah Sampel - Salmonella"],
  [
    463,
    "Bakso Goreng (08030318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    464,
    "Bakso Goreng (08030318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    465,
    "Bakso Goreng (08030318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    466,
    "Bakso Goreng (08030318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    467,
    "Bakso Goreng (08030318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    468,
    "Bakso Goreng (08030318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    469,
    "Bakso Goreng (08030318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    470,
    "Bakso Goreng (08030318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    471,
    "Bakso Goreng (08030318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    472,
    "Bakso Goreng (08030318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    473,
    "Bakso Goreng (08030318)",
    "Listeria monocytogenes (/25 g)",
  ],
  [
    474,
    "Bakso Goreng (08030318)",
    "Listeria monocytogenes (/25 g)",
  ],
  [
    475,
    "Bakso Goreng (08030318)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    476,
    "Bakso Goreng (08030318)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    477,
    "Bakso Goreng Kombinasi (08030319)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    478,
    "Bakso Goreng Kombinasi (08030319)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    479,
    "Bakso Goreng Kombinasi (08030319)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    480,
    "Bakso Goreng Kombinasi (08030319)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    481,
    "Bakso Goreng Kombinasi (08030319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    482,
    "Bakso Goreng Kombinasi (08030319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    483,
    "Bakso Goreng Kombinasi (08030319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    484,
    "Bakso Goreng Kombinasi (08030319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    485,
    "Bakso Goreng Kombinasi (08030319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    486,
    "Bakso Goreng Kombinasi (08030319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    487,
    "Bakso Goreng Kombinasi (08030319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    488,
    "Bakso Goreng Kombinasi (08030319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    489,
    "Bakso Goreng Kombinasi (08030319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    490,
    "Bakso Goreng Kombinasi (08030319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    491,
    "Bakso Goreng Kombinasi (08030319)",
    "Listeria monocytogenes (/25 g)",
  ],
  [
    492,
    "Bakso Goreng Kombinasi (08030319)",
    "Listeria monocytogenes (/25 g)",
  ],
  [
    493,
    "Bakso Goreng Kombinasi (08030319)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    494,
    "Bakso Goreng Kombinasi (08030319)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    495,
    "Bakso Ikan (0902040107)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    496,
    "Bakso Ikan (0902040107)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    497,
    "Bakso Ikan (0902040107)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    498,
    "Bakso Ikan (0902040107)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    499,
    "Bakso Ikan (0902040107)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [500, "Bakso Ikan Beku (09020133)", "Salmonella (/25 g)"],
  [
    501,
    "Bakso Ikan Beku (09020133)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    502,
    "Bakso Ikan Kering (0902040108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    503,
    "Bakso Ikan Kering (0902040108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    504,
    "Bakso Ikan Kering (0902040108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    505,
    "Bakso Ikan Kering (0902040108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    506,
    "Bakso Ikan Kering (0902040108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    507,
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering) (0902040310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    508,
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering) (0902040310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    509,
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering) (0902040310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    510,
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering) (0902040310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    511,
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering) (0902040310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    512,
    "Bakso Udang / Bakso Cumi (0902040205)",
    "Salmonella (/25 g)",
  ],
  [
    513,
    "Bakso Udang / Bakso Cumi (0902040205)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    514,
    "Bakso Udang / Bakso Cumi (0902040205)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    515,
    "Bakso Udang / Bakso Cumi (0902040205)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    516,
    "Bakso Udang / Bakso Cumi (0902040205)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    517,
    "Bakso Udang / Bakso Cumi (0902040205)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    518,
    "Bakso Udang / Bakso Cumi (0902040205)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    519,
    "Bakso Udang / Bakso Cumi (0902040205)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    520,
    "Bakso Udang / Bakso Cumi (0902040205)",
    "Jumlah Sampel -Listeria monocytogenes",
  ],
  [
    521,
    "Bakwan Ikan (Rebus Atau Kukus) (0902040124)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    522,
    "Bakwan Ikan (Rebus Atau Kukus) (0902040124)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    523,
    "Bakwan Ikan (Rebus Atau Kukus) (0902040124)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    524,
    "Bakwan Ikan (Rebus Atau Kukus) (0902040124)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    525,
    "Bakwan Ikan (Rebus Atau Kukus) (0902040124)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    526,
    "Bandeng Isi (0902040125)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    527,
    "Bandeng Isi (0902040125)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    528,
    "Bandeng Isi (0902040125)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    529,
    "Bandeng Isi (0902040125)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    530,
    "Bandeng Isi (0902040125)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    531,
    "Bandeng Presto (0902040105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    532,
    "Bandeng Presto (0902040105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    533,
    "Bandeng Presto (0902040105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    534,
    "Bandeng Presto (0902040105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    535,
    "Bandeng Presto (0902040105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [536, "Baozi atau Bao (07010506)", "Salmonella (/25 g)"],
  [537, "Baozi atau Bao (07010506)", "Jumlah Sampel - Salmonella"],
  [538, "Bars Buah (0401020815)", "Jumlah Sampel - Salmonella"],
  [539, "Bars Buah (0401020815)", "Salmonella (/25 g)"],
  [
    540,
    "Basil Kering, Ruku-Ruku, Kemangi Hutan (12020111)",
    "Salmonella (/25 g)",
  ],
  [
    541,
    "Basil Kering, Ruku-Ruku, Kemangi Hutan (12020111)",
    "Jumlah Sampel - Salmonella",
  ],
  [542, "Basilla (12020112)", "Salmonella (/25 g)"],
  [543, "Basilla (12020112)", "Jumlah Sampel - Salmonella"],
  [544, "Bawang Batak/Lokio (12020116)", "Salmonella (/25 g)"],
  [
    545,
    "Bawang Batak/Lokio (12020116)",
    "Jumlah Sampel - Salmonella",
  ],
  [546, "Bawang Daun (12020117)", "Salmonella (/25 g)"],
  [547, "Bawang Daun (12020117)", "Jumlah Sampel - Salmonella"],
  [548, "Bawang Goreng (12020195)", "Salmonella (/25 g)"],
  [549, "Bawang Goreng (12020195)", "Jumlah Sampel - Salmonella"],
  [
    550,
    "Bawang Goreng (12020195)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    551,
    "Bawang Goreng (12020195)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    552,
    "Bawang Goreng (12020195)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    553,
    "Bawang Goreng (12020195)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    554,
    "Bawang Goreng (12020195)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    555,
    "Bawang Goreng (12020195)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    556,
    "Bawang Goreng (12020195)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    557,
    "Bawang Goreng (12020195)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    558,
    "Bawang Goreng (12020195)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    559,
    "Bawang Goreng (12020195)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [560, "Bawang Hitam (12020211)", "Salmonella (/25 g)-kering"],
  [
    561,
    "Bawang Hitam (12020211)",
    "Jumlah Sampel - Salmonella-bumbu kering",
  ],
  [
    562,
    "Bawang Hitam (12020211)",
    "Bacillus cereus (koloni/g)-bumbu kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    563,
    "Bawang Hitam (12020211)",
    "Bacillus cereus (koloni/g)-bumbu kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    564,
    "Bawang Hitam (12020211)",
    "Bacillus cereus (koloni/g)-bumbu kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    565,
    "Bawang Hitam (12020211)",
    "Bacillus cereus (koloni/g)-bumbu kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    566,
    "Bawang Hitam (12020211)",
    "Bacillus cereus (koloni/g)-bumbu kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    567,
    "Bawang Hitam (12020211)",
    "Clostridium pefringens (koloni/g)-bumbu kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    568,
    "Bawang Hitam (12020211)",
    "Clostridium pefringens (koloni/g)-bumbu kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    569,
    "Bawang Hitam (12020211)",
    "Clostridium pefringens (koloni/g)-bumbu kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    570,
    "Bawang Hitam (12020211)",
    "Clostridium pefringens (koloni/g)-bumbu kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    571,
    "Bawang Hitam (12020211)",
    "Clostridium pefringens (koloni/g)-bumbu kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [572, "Bawang Hitam (12020211)", "Salmonella (/25 g)-basah"],
  [
    573,
    "Bawang Hitam (12020211)",
    "Jumlah Sampel - Salmonella-bumbu basah",
  ],
  [
    574,
    "Bawang Hitam (12020211)",
    "Clostridium pefringens (koloni/g)-basah",
    "\x{2265}1000",
  ],
  [
    575,
    "Bawang Hitam (12020211)",
    "Clostridium pefringens (koloni/g)-basah",
    "\x{2265}1000",
  ],
  [
    576,
    "Bawang Hitam (12020211)",
    "Clostridium pefringens (koloni/g)-basah",
    "\x{2265}1000",
  ],
  [
    577,
    "Bawang Hitam (12020211)",
    "Clostridium pefringens (koloni/g)-basah",
    "\x{2265}1000",
  ],
  [
    578,
    "Bawang Hitam (12020211)",
    "Clostridium pefringens (koloni/g)-basah",
    "\x{2265}1000",
  ],
  [579, "Bawang Merah (Shallot) (12020115)", "Salmonella (/25 g)"],
  [
    580,
    "Bawang Merah (Shallot) (12020115)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    581,
    "Bawang Merah (Shallot) (12020115)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    582,
    "Bawang Merah (Shallot) (12020115)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    583,
    "Bawang Merah (Shallot) (12020115)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    584,
    "Bawang Merah (Shallot) (12020115)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    585,
    "Bawang Merah (Shallot) (12020115)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    586,
    "Bawang Merah (Shallot) (12020115)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    587,
    "Bawang Merah (Shallot) (12020115)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    588,
    "Bawang Merah (Shallot) (12020115)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    589,
    "Bawang Merah (Shallot) (12020115)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    590,
    "Bawang Merah (Shallot) (12020115)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [591, "Bawang Putih (12020114)", "Salmonella (/25 g)"],
  [592, "Bawang Putih (12020114)", "Jumlah Sampel - Salmonella"],
  [
    593,
    "Bawang Putih (12020114)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    594,
    "Bawang Putih (12020114)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    595,
    "Bawang Putih (12020114)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    596,
    "Bawang Putih (12020114)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    597,
    "Bawang Putih (12020114)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    598,
    "Bawang Putih (12020114)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    599,
    "Bawang Putih (12020114)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    600,
    "Bawang Putih (12020114)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    601,
    "Bawang Putih (12020114)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    602,
    "Bawang Putih (12020114)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [603, "Bay Leaves (12020113)", "Salmonella (/25 g)"],
  [604, "Bay Leaves (12020113)", "Jumlah Sampel - Salmonella"],
  [605, "Bayam Beku (0402020106)", "Salmonella (/25 g)"],
  [606, "Bayam Beku (0402020106)", "Jumlah Sampel - Salmonella"],
  [
    607,
    "Bayam Beku (0402020106)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    608,
    "Bayam Beku (0402020106)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    609,
    "Bayam Beku (0402020106)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    610,
    "Bayam Beku (0402020106)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    611,
    "Bayam Beku (0402020106)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [612, "Bekasam/Bekasang (09020520)", "Salmonella (/25 g)"],
  [
    613,
    "Bekasam/Bekasang (09020520)",
    "Jumlah Sampel - Salmonella",
  ],
  [614, "Belut Kering (09020507)", "Salmonella (/25 g)"],
  [615, "Belut Kering (09020507)", "Jumlah Sampel - Salmonella"],
  [616, "Bergamot (120201A1)", "Salmonella (/25 g)"],
  [617, "Bergamot (120201A1)", "Jumlah Sampel - Salmonella"],
  [618, "Bihun (06040301)", "Salmonella (/25 g)"],
  [619, "Bihun (06040301)", "Jumlah Sampel - Salmonella"],
  [620, "Bihun Instan (06040305)", "Salmonella (/25 g)"],
  [621, "Bihun Instan (06040305)", "Jumlah Sampel - Salmonella"],
  [622, "Bihun Lainnya (06040317)", "Salmonella (/25 g)"],
  [623, "Bihun Lainnya (06040317)", "Jumlah Sampel - Salmonella"],
  [
    624,
    "Biji cokelat yang disangrai atau roasting (05010121)",
    "Salmonella (/25 g)",
  ],
  [
    625,
    "Biji cokelat yang disangrai atau roasting (05010121)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    626,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender (12020128)",
    "Salmonella (/25 g)",
  ],
  [
    627,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender (12020128)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    628,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender (12020128)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    629,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender (12020128)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    630,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender (12020128)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    631,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender (12020128)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    632,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender (12020128)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    633,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender (12020128)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    634,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender (12020128)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    635,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender (12020128)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    636,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender (12020128)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    637,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender (12020128)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [638, "Biji Jagung Beku (0402020109)", "Salmonella (/25 g)"],
  [
    639,
    "Biji Jagung Beku (0402020109)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    640,
    "Biji Jagung Beku (0402020109)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    641,
    "Biji Jagung Beku (0402020109)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    642,
    "Biji Jagung Beku (0402020109)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    643,
    "Biji Jagung Beku (0402020109)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    644,
    "Biji Jagung Beku (0402020109)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [645, "Biji Kapulaga (12020149)", "Salmonella (/25 g)"],
  [646, "Biji Kapulaga (12020149)", "Jumlah Sampel - Salmonella"],
  [
    647,
    "Biji Kapulaga (12020149)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    648,
    "Biji Kapulaga (12020149)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    649,
    "Biji Kapulaga (12020149)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    650,
    "Biji Kapulaga (12020149)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    651,
    "Biji Kapulaga (12020149)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    652,
    "Biji Kapulaga (12020149)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    653,
    "Biji Kapulaga (12020149)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    654,
    "Biji Kapulaga (12020149)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    655,
    "Biji Kapulaga (12020149)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    656,
    "Biji Kapulaga (12020149)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    657,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Salmonella (/25 g)",
  ],
  [
    658,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    659,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    660,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    661,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    662,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    663,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    664,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    665,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    666,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    667,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    668,
    "Biji Kapulaga (Cardamom) Amomum (12020152)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    669,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk (12020120)",
    "Salmonella (/25 g)",
  ],
  [
    670,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk (12020120)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    671,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk (12020120)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    672,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk (12020120)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    673,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk (12020120)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    674,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk (12020120)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    675,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk (12020120)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    676,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk (12020120)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    677,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk (12020120)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    678,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk (12020120)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    679,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk (12020120)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    680,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk (12020120)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [681, "Biji Sawi/Biji Mustard (12020119)", "Salmonella (/25 g)"],
  [
    682,
    "Biji Sawi/Biji Mustard (12020119)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    683,
    "Biji Sawi/Biji Mustard (12020119)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    684,
    "Biji Sawi/Biji Mustard (12020119)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    685,
    "Biji Sawi/Biji Mustard (12020119)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    686,
    "Biji Sawi/Biji Mustard (12020119)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    687,
    "Biji Sawi/Biji Mustard (12020119)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    688,
    "Biji Sawi/Biji Mustard (12020119)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    689,
    "Biji Sawi/Biji Mustard (12020119)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    690,
    "Biji Sawi/Biji Mustard (12020119)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    691,
    "Biji Sawi/Biji Mustard (12020119)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    692,
    "Biji Sawi/Biji Mustard (12020119)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [693, "Biji Seledri (12020118)", "Salmonella (/25 g)"],
  [694, "Biji Seledri (12020118)", "Jumlah Sampel - Salmonella"],
  [
    695,
    "Biji Seledri (12020118)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    696,
    "Biji Seledri (12020118)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    697,
    "Biji Seledri (12020118)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    698,
    "Biji Seledri (12020118)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    699,
    "Biji Seledri (12020118)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    700,
    "Biji Seledri (12020118)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    701,
    "Biji Seledri (12020118)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    702,
    "Biji Seledri (12020118)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    703,
    "Biji Seledri (12020118)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    704,
    "Biji Seledri (12020118)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [705, "Bika Ambon (07020118)", "Salmonella (/25 g)"],
  [706, "Bika Ambon (07020118)", "Jumlah Sampel - Salmonella"],
  [
    707,
    "Bika Ambon (07020118)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    708,
    "Bika Ambon (07020118)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    709,
    "Bika Ambon (07020118)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    710,
    "Bika Ambon (07020118)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    711,
    "Bika Ambon (07020118)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [712, "Biskuit (07010301)", "Salmonella (/25 g)"],
  [713, "Biskuit (07010301)", "Jumlah Sampel - Salmonella"],
  [714, "Biskuit (07020139)", "Salmonella (/25 g)"],
  [715, "Biskuit (07020139)", "Jumlah Sampel - Salmonella"],
  [
    716,
    "Biskuit (07020139)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    717,
    "Biskuit (07020139)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    718,
    "Biskuit (07020139)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    719,
    "Biskuit (07020139)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    720,
    "Biskuit (07020139)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    721,
    "Biskuit (Manis) atau Kukis Atau Sweet Crackers (07020107)",
    "Salmonella (/25 g)",
  ],
  [
    722,
    "Biskuit (Manis) atau Kukis Atau Sweet Crackers (07020107)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    723,
    "Biskuit (Manis) atau Kukis Atau Sweet Crackers (07020107)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    724,
    "Biskuit (Manis) atau Kukis Atau Sweet Crackers (07020107)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    725,
    "Biskuit (Manis) atau Kukis Atau Sweet Crackers (07020107)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    726,
    "Biskuit (Manis) atau Kukis Atau Sweet Crackers (07020107)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    727,
    "Biskuit (Manis) atau Kukis Atau Sweet Crackers (07020107)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [728, "Biskuit Bar Sereal Isi (07020130)", "Salmonella (/25 g)"],
  [
    729,
    "Biskuit Bar Sereal Isi (07020130)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    730,
    "Biskuit Bar Sereal Isi (07020130)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    731,
    "Biskuit Bar Sereal Isi (07020130)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    732,
    "Biskuit Bar Sereal Isi (07020130)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    733,
    "Biskuit Bar Sereal Isi (07020130)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    734,
    "Biskuit Bar Sereal Isi (07020130)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [735, "Biskuit Colek (07020127)", "Salmonella (/25 g)"],
  [736, "Biskuit Colek (07020127)", "Jumlah Sampel - Salmonella"],
  [
    737,
    "Biskuit Colek (07020127)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    738,
    "Biskuit Colek (07020127)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    739,
    "Biskuit Colek (07020127)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    740,
    "Biskuit Colek (07020127)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    741,
    "Biskuit Colek (07020127)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    742,
    "Biskuit Lapis/Biskuit Sandwich (07020128)",
    "Salmonella (/25 g)",
  ],
  [
    743,
    "Biskuit Lapis/Biskuit Sandwich (07020128)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    744,
    "Biskuit Lapis/Biskuit Sandwich (07020128)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    745,
    "Biskuit Lapis/Biskuit Sandwich (07020128)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    746,
    "Biskuit Lapis/Biskuit Sandwich (07020128)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    747,
    "Biskuit Lapis/Biskuit Sandwich (07020128)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    748,
    "Biskuit Lapis/Biskuit Sandwich (07020128)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [749, "Biskuit Marie (07020108)", "Salmonella (/25 g)"],
  [750, "Biskuit Marie (07020108)", "Jumlah Sampel - Salmonella"],
  [
    751,
    "Biskuit Marie (07020108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    752,
    "Biskuit Marie (07020108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    753,
    "Biskuit Marie (07020108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    754,
    "Biskuit Marie (07020108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    755,
    "Biskuit Marie (07020108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    756,
    "Biskuit Marie Salut / Biskuit Salut (07020109)",
    "Salmonella (/25 g)",
  ],
  [
    757,
    "Biskuit Marie Salut / Biskuit Salut (07020109)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    758,
    "Biskuit Marie Salut / Biskuit Salut (07020109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    759,
    "Biskuit Marie Salut / Biskuit Salut (07020109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    760,
    "Biskuit Marie Salut / Biskuit Salut (07020109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    761,
    "Biskuit Marie Salut / Biskuit Salut (07020109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    762,
    "Biskuit Marie Salut / Biskuit Salut (07020109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [763, "Biskuit non terigu (07020132)", "Salmonella (/25 g)"],
  [
    764,
    "Biskuit non terigu (07020132)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    765,
    "Biskuit non terigu (07020132)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    766,
    "Biskuit non terigu (07020132)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    767,
    "Biskuit non terigu (07020132)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    768,
    "Biskuit non terigu (07020132)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    769,
    "Biskuit non terigu (07020132)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [770, "Bolu Emprit (07020215)", "Salmonella (/25 g)"],
  [
    771,
    "Bolu Emprit (07020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [772, "Bolu Kukus (07010504)", "Salmonella (/25 g)"],
  [773, "Bolu Kukus (07010504)", "Salmonella (/25 g)"],
  [774, "Bolu Kukus (07010504)", "Jumlah Sampel - Salmonella"],
  [775, "Bolu Kukus (07010504)", "Jumlah Sampel - Salmonella"],
  [776, "Bolu Kukus (07020138)", "Salmonella (/25 g)"],
  [777, "Bolu Kukus (07020138)", "Jumlah Sampel - Salmonella"],
  [
    778,
    "Bolu Kukus (07020138)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    779,
    "Bolu Kukus (07020138)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    780,
    "Bolu Kukus (07020138)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    781,
    "Bolu Kukus (07020138)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    782,
    "Bolu Kukus (07020138)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    783,
    "Bonbon Cokelat/Permen Isi Cokelat (05010403)",
    "Salmonella (/25 g)",
  ],
  [
    784,
    "Bonbon Cokelat/Permen Isi Cokelat (05010403)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    785,
    "Brawn and Head Cheese (08030203)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    786,
    "Brawn and Head Cheese (08030203)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    787,
    "Brawn and Head Cheese (08030203)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    788,
    "Brawn and Head Cheese (08030203)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    789,
    "Brawn and Head Cheese (08030203)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    790,
    "Brawn and Head Cheese (08030203)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    791,
    "Brawn and Head Cheese (08030203)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    792,
    "Brawn and Head Cheese (08030203)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    793,
    "Brawn and Head Cheese (08030203)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    794,
    "Brawn and Head Cheese (08030203)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [795, "Brawn and Head Cheese (08030203)", "Salmonella (/25 g)"],
  [796, "Brawn and Head Cheese (08030203)", "Salmonella (/25 g)"],
  [797, "Brawn and Head Cheese (08030203)", "Jumlah - Salmonella"],
  [798, "Brawn and Head Cheese (08030203)", "Jumlah - Salmonella"],
  [799, "Bread Stick (0701010114)", "Salmonella (/25 g)"],
  [800, "Bread Stick (0701010114)", "Jumlah Sampel - Salmonella"],
  [
    801,
    "Brem (060509)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    802,
    "Brem (060509)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    803,
    "Brem (060509)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    804,
    "Brem (060509)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    805,
    "Brem (060509)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [806, "Brem (060509)", "Salmonella (/25 g)"],
  [807, "Brem (060509)", "Jumlah Sampel - Salmonella"],
  [
    808,
    "Brem (060509)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    809,
    "Brem (060509)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    810,
    "Brem (060509)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    811,
    "Brem (060509)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    812,
    "Brem (060509)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [813, "Brokoli Beku (0402020104)", "Salmonella (/25 g)"],
  [814, "Brokoli Beku (0402020104)", "Jumlah Sampel - Salmonella"],
  [
    815,
    "Brokoli Beku (0402020104)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    816,
    "Brokoli Beku (0402020104)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    817,
    "Brokoli Beku (0402020104)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    818,
    "Brokoli Beku (0402020104)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    819,
    "Brokoli Beku (0402020104)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [820, "Brownies (07020131)", "Salmonella (/25 g)"],
  [821, "Brownies (07020131)", "Jumlah Sampel - Salmonella"],
  [
    822,
    "Brownies (07020131)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    823,
    "Brownies (07020131)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    824,
    "Brownies (07020131)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    825,
    "Brownies (07020131)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    826,
    "Brownies (07020131)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [827, "Brussel Sprout Beku (0402020105)", "Salmonella (/25 g)"],
  [
    828,
    "Brussel Sprout Beku (0402020105)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    829,
    "Brussel Sprout Beku (0402020105)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    830,
    "Brussel Sprout Beku (0402020105)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    831,
    "Brussel Sprout Beku (0402020105)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    832,
    "Brussel Sprout Beku (0402020105)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    833,
    "Brussel Sprout Beku (0402020105)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [834, "Buah Asin (0401020301)", "Jumlah Sampel - Salmonella"],
  [835, "Buah Asin (0401020301)", "Salmonella (/25 g)"],
  [836, "Buah Beku (0401020101)", "Jumlah Sampel - Salmonella"],
  [837, "Buah Beku (0401020101)", "Salmonella (negatif/25 g)"],
  [
    838,
    "Buah beku dalam gula kering (0401020102)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    839,
    "Buah beku dalam gula kering (0401020102)",
    "Salmonella (negatif/25 g)",
  ],
  [
    840,
    "Buah beku dalam sirup (0401020103)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    841,
    "Buah beku dalam sirup (0401020103)",
    "Salmonella (negatif/25 g)",
  ],
  [
    842,
    "Buah dalam Kemasan (0401020404)",
    "Jumlah Sampel - Salmonella",
  ],
  [843, "Buah dalam Kemasan (0401020404)", "Salmonella (/25 g)"],
  [844, "Buah Goreng Beku (0401020104)", "Salmonella (/25 g)"],
  [
    845,
    "Buah Goreng Beku (0401020104)",
    "Jumlah Sampel - Salmonella",
  ],
  [846, "Bubuk Buttermilk (01050111)", "Salmonella (/25 g)"],
  [
    847,
    "Bubuk Buttermilk (01050111)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    848,
    "Bubuk Buttermilk (01050111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    849,
    "Bubuk Buttermilk (01050111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    850,
    "Bubuk Buttermilk (01050111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    851,
    "Bubuk Buttermilk (01050111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    852,
    "Bubuk Buttermilk (01050111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    853,
    "Bubuk Buttermilk (01050204)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    854,
    "Bubuk Buttermilk (01050204)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    855,
    "Bubuk Buttermilk (01050204)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    856,
    "Bubuk Buttermilk (01050204)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    857,
    "Bubuk Buttermilk (01050204)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [858, "Bubuk Buttermilk (01050204)", "Salmonella (/25 ml)"],
  [
    859,
    "Bubuk Buttermilk (01050204)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    860,
    "Bubuk Kakao dengan Lemak Sedang (Medium Fat Cocoa) (05010103)",
    "Salmonella (/25 g)",
  ],
  [
    861,
    "Bubuk Kakao dengan Lemak Sedang (Medium Fat Cocoa) (05010103)",
    "Salmonella (/25 g)",
  ],
  [
    862,
    "Bubuk Kakao dengan Lemak Sedang (Medium Fat Cocoa) (05010103)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    863,
    "Bubuk Kakao dengan Lemak Sedang (Medium Fat Cocoa) (05010103)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    864,
    "Bubuk Kakao Rendah Lemak (Lowfat Cocoa) (05010104)",
    "Salmonella (/25 g)",
  ],
  [
    865,
    "Bubuk Kakao Rendah Lemak (Lowfat Cocoa) (05010104)",
    "Salmonella (/25 g)",
  ],
  [
    866,
    "Bubuk Kakao Rendah Lemak (Lowfat Cocoa) (05010104)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    867,
    "Bubuk Kakao Rendah Lemak (Lowfat Cocoa) (05010104)",
    "Jumlah Sampel - Salmonella",
  ],
  [868, "Bubuk Kari (12020204)", "Salmonella (/25 g)"],
  [869, "Bubuk Kari (12020204)", "Jumlah Sampel - Salmonella"],
  [
    870,
    "Bubuk Kari (12020204)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    871,
    "Bubuk Kari (12020204)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    872,
    "Bubuk Kari (12020204)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    873,
    "Bubuk Kari (12020204)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    874,
    "Bubuk Kari (12020204)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    875,
    "Bubuk Kari (12020204)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    876,
    "Bubuk Kari (12020204)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    877,
    "Bubuk Kari (12020204)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    878,
    "Bubuk Kari (12020204)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    879,
    "Bubuk Kari (12020204)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    880,
    "Bubuk Minuman Cokelat (Drinking Chocolate) (05010115)",
    "Salmonella (/25 g)",
  ],
  [
    881,
    "Bubuk Minuman Cokelat (Drinking Chocolate) (05010115)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    882,
    "Bubuk Minuman Kakao (Drinking Cocoa Mixes) (05010114)",
    "Salmonella (/25 g)",
  ],
  [
    883,
    "Bubuk Minuman Kakao (Drinking Cocoa Mixes) (05010114)",
    "Jumlah Sampel - Salmonella",
  ],
  [884, "Bubuk Ngohyang (12020203)", "Salmonella (/25 g)"],
  [885, "Bubuk Ngohyang (12020203)", "Jumlah Sampel - Salmonella"],
  [
    886,
    "Bubuk Ngohyang (12020203)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    887,
    "Bubuk Ngohyang (12020203)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    888,
    "Bubuk Ngohyang (12020203)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    889,
    "Bubuk Ngohyang (12020203)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    890,
    "Bubuk Ngohyang (12020203)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    891,
    "Bubuk Ngohyang (12020203)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    892,
    "Bubuk Ngohyang (12020203)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    893,
    "Bubuk Ngohyang (12020203)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    894,
    "Bubuk Ngohyang (12020203)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    895,
    "Bubuk Ngohyang (12020203)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    896,
    "Bubuk Puding Rasa/Berperisa (0401020918)",
    "Salmonella (/25ml)",
  ],
  [
    897,
    "Bubuk Puding Rasa/Berperisa (0401020918)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [898, "Bubuk Whey (01080201)", "Salmonella (/25 g)"],
  [899, "Bubuk Whey (01080201)", "Jumlah Sampel - Salmonella"],
  [
    900,
    "Bubuk Whey (01080201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    901,
    "Bubuk Whey (01080201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    902,
    "Bubuk Whey (01080201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    903,
    "Bubuk Whey (01080201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    904,
    "Bubuk Whey (01080201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [905, "Bubuk Whey Permeate (01080203)", "Salmonella (/25 g)"],
  [
    906,
    "Bubuk Whey Permeate (01080203)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    907,
    "Bubuk Whey Permeate (01080203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    908,
    "Bubuk Whey Permeate (01080203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    909,
    "Bubuk Whey Permeate (01080203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    910,
    "Bubuk Whey Permeate (01080203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    911,
    "Bubuk Whey Permeate (01080203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    912,
    "Bubuk Whey yang Telah Didemineralisasi (01080202)",
    "Salmonella (/25 g)",
  ],
  [
    913,
    "Bubuk Whey yang Telah Didemineralisasi (01080202)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    914,
    "Bubuk Whey yang Telah Didemineralisasi (01080202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    915,
    "Bubuk Whey yang Telah Didemineralisasi (01080202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    916,
    "Bubuk Whey yang Telah Didemineralisasi (01080202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    917,
    "Bubuk Whey yang Telah Didemineralisasi (01080202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    918,
    "Bubuk Whey yang Telah Didemineralisasi (01080202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    919,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Salmonella (/25 g)- siap pakai kering",
  ],
  [
    920,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Jumlah Sampel - Salmonella-siap pakai kering",
    "\x{2265}",
  ],
  [
    921,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Bacillus cereus (koloni/g) - siap pakai kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    922,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Bacillus cereus (koloni/g) - siap pakai kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    923,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Bacillus cereus (koloni/g) - siap pakai kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    924,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Bacillus cereus (koloni/g) - siap pakai kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    925,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Bacillus cereus (koloni/g) - siap pakai kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    926,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Clostridium pefringens (koloni/g) - siap pakai kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    927,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Clostridium pefringens (koloni/g) - siap pakai kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    928,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Clostridium pefringens (koloni/g) - siap pakai kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    929,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Clostridium pefringens (koloni/g) - siap pakai kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    930,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Clostridium pefringens (koloni/g) - siap pakai kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    931,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Salmonella (/25 g)- siap pakai basah",
  ],
  [
    932,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju (12020221)",
    "Jumlah Sampel - Salmonella-siap pakai basah",
    "\x{2265}",
  ],
  [
    933,
    "Bubur (Pulp) Horseadish (0402020604)",
    "Salmonella (/25 g)",
  ],
  [
    934,
    "Bubur (Pulp) Horseadish (0402020604)",
    "Jumlah Sampel - Salmonella",
  ],
  [935, "Bubur (Pulp) Kentang (0402020603)", "Salmonella (/25 g)"],
  [
    936,
    "Bubur (Pulp) Kentang (0402020603)",
    "Jumlah Sampel - Salmonella",
  ],
  [937, "Bubur (Pulp) Sayur (0402020616)", "Salmonella (/25 g)"],
  [
    938,
    "Bubur (Pulp) Sayur (0402020616)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [939, "Bubur (Pulp) Tomat (0402020602)", "Salmonella (/25 g)"],
  [
    940,
    "Bubur (Pulp) Tomat (0402020602)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    941,
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kemasan (0402020614)",
    "Salmonella (/25 g)",
  ],
  [
    942,
    "Bubur (Pulp), Saus, dan Pasta Sayur, Kacang, dan Biji-Bijian dalam Kemasan (0402020614)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    943,
    "Bubur Buah (Fruit Pulp) (0401020801)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    944,
    "Bubur Buah (Fruit Pulp) (0401020801)",
    "Salmonella (/25 g)",
  ],
  [945, "Bubur Cabe (12020123)", "Salmonella (/25 g)"],
  [946, "Bubur Cabe (12020123)", "Jumlah Sampel - Salmonella"],
  [
    947,
    "Bubur Cabe (12020123)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    948,
    "Bubur Cabe (12020123)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    949,
    "Bubur Cabe (12020123)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    950,
    "Bubur Cabe (12020123)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    951,
    "Bubur Cabe (12020123)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    952,
    "Bubur Cabe (12020123)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    953,
    "Bubur Cabe (12020123)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    954,
    "Bubur Cabe (12020123)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    955,
    "Bubur Cabe (12020123)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    956,
    "Bubur Cabe (12020123)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [957, "Bubur Jahe (12020139)", "Salmonella (/25 g)"],
  [958, "Bubur Jahe (12020139)", "Jumlah Sampel - Salmonella"],
  [
    959,
    "Bubur Jahe (12020139)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    960,
    "Bubur Jahe (12020139)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    961,
    "Bubur Jahe (12020139)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    962,
    "Bubur Jahe (12020139)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    963,
    "Bubur Jahe (12020139)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    964,
    "Bubur Jahe (12020139)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    965,
    "Bubur Jahe (12020139)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    966,
    "Bubur Jahe (12020139)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    967,
    "Bubur Jahe (12020139)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    968,
    "Bubur Jahe (12020139)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    969,
    "Bubur Siap Saji Dalam Kemasan (06040315)",
    "Salmonella (/25 g)",
  ],
  [
    970,
    "Bubur Siap Saji Dalam Kemasan (06040315)",
    "Jumlah Sampel - Salmonella",
  ],
  [971, "Bulgur (060301)", "Salmonella (/25 g)"],
  [972, "Bulgur (060301)", "Jumlah Sampel - Salmonella"],
  [
    973,
    "Bulgur (060301)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    974,
    "Bulgur (060301)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    975,
    "Bulgur (060301)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    976,
    "Bulgur (060301)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    977,
    "Bulgur (060301)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [978, "Bumbu (12020201)", "Salmonella (/25 g)-bumbu kering"],
  [
    979,
    "Bumbu (12020201)",
    "Jumlah Sampel - Salmonella-bumbu kering",
  ],
  [
    980,
    "Bumbu (12020201)",
    "Bacillus cereus (koloni/g)-bumbu kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    981,
    "Bumbu (12020201)",
    "Bacillus cereus (koloni/g)-bumbu kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    982,
    "Bumbu (12020201)",
    "Bacillus cereus (koloni/g)-bumbu kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    983,
    "Bumbu (12020201)",
    "Bacillus cereus (koloni/g)-bumbu kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    984,
    "Bumbu (12020201)",
    "Bacillus cereus (koloni/g)-bumbu kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    985,
    "Bumbu (12020201)",
    "Clostridium pefringens (koloni/g)-bumbu kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    986,
    "Bumbu (12020201)",
    "Clostridium pefringens (koloni/g)-bumbu kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    987,
    "Bumbu (12020201)",
    "Clostridium pefringens (koloni/g)-bumbu kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    988,
    "Bumbu (12020201)",
    "Clostridium pefringens (koloni/g)-bumbu kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    989,
    "Bumbu (12020201)",
    "Clostridium pefringens (koloni/g)-bumbu kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [990, "Bumbu (12020201)", "Salmonella (/25 g)-bumbu basah"],
  [
    991,
    "Bumbu (12020201)",
    "Jumlah Sampel - Salmonella-bumbu basah",
  ],
  [
    992,
    "Bumbu (12020201)",
    "Clostridium pefringens (koloni/g)-bumbu basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    993,
    "Bumbu (12020201)",
    "Clostridium pefringens (koloni/g)-bumbu basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    994,
    "Bumbu (12020201)",
    "Clostridium pefringens (koloni/g)-bumbu basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    995,
    "Bumbu (12020201)",
    "Clostridium pefringens (koloni/g)-bumbu basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    996,
    "Bumbu (12020201)",
    "Clostridium pefringens (koloni/g)-bumbu basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [997, "Bumbu Ekstrak Cumi (12020216)", "Salmonella (/25 g)"],
  [
    998,
    "Bumbu Ekstrak Cumi (12020216)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    999,
    "Bumbu Ekstrak Cumi (12020216)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1000,
    "Bumbu Ekstrak Cumi (12020216)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1001,
    "Bumbu Ekstrak Cumi (12020216)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1002,
    "Bumbu Ekstrak Cumi (12020216)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1003,
    "Bumbu Ekstrak Cumi (12020216)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1004,
    "Bumbu Ekstrak Cumi (12020216)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1005,
    "Bumbu Ekstrak Cumi (12020216)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1006,
    "Bumbu Ekstrak Cumi (12020216)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1007,
    "Bumbu Ekstrak Cumi (12020216)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1008,
    "Bumbu Ekstrak Cumi (12020216)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1009,
    "Bumbu Ekstrak Daging Ayam (12050207)",
    "Salmonella (/25 g)",
  ],
  [
    1010,
    "Bumbu Ekstrak Daging Ayam (12050207)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1011,
    "Bumbu Ekstrak Daging Ayam (12050207)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1012,
    "Bumbu Ekstrak Daging Ayam (12050207)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1013,
    "Bumbu Ekstrak Daging Ayam (12050207)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1014,
    "Bumbu Ekstrak Daging Ayam (12050207)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1015,
    "Bumbu Ekstrak Daging Ayam (12050207)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1016,
    "Bumbu Ekstrak Daging Sapi (12050205)",
    "Salmonella (/25 g)",
  ],
  [
    1017,
    "Bumbu Ekstrak Daging Sapi (12050205)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1018,
    "Bumbu Ekstrak Daging Sapi (12050205)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1019,
    "Bumbu Ekstrak Daging Sapi (12050205)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1020,
    "Bumbu Ekstrak Daging Sapi (12050205)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1021,
    "Bumbu Ekstrak Daging Sapi (12050205)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1022,
    "Bumbu Ekstrak Daging Sapi (12050205)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1023,
    "Bumbu Ekstrak Udang (12020215)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1024,
    "Bumbu Ekstrak Udang (12020215)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1025,
    "Bumbu Ekstrak Udang (12020215)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1026,
    "Bumbu Ekstrak Udang (12020215)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1027,
    "Bumbu Ekstrak Udang (12020215)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1028,
    "Bumbu Ekstrak Udang (12020215)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1029,
    "Bumbu Ekstrak Udang (12020215)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1030,
    "Bumbu Ekstrak Udang (12020215)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1031,
    "Bumbu Ekstrak Udang (12020215)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1032,
    "Bumbu Ekstrak Udang (12020215)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [1033, "Bumbu Ekstrak Udang (12020215)", "Salmonella (/25 g)"],
  [
    1034,
    "Bumbu Ekstrak Udang (12020215)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [1035, "Bumbu Kacang (12060227)", "Salmonella (/25 g)"],
  [1036, "Bumbu Kacang (12060227)", "Jumlah Sampel - Salmonella"],
  [
    1037,
    "Bumbu Mi Instan (12020208)",
    "Salmonella (/25 g)-kering",
  ],
  [
    1038,
    "Bumbu Mi Instan (12020208)",
    "Jumlah Sampel - Salmonella-kering",
  ],
  [
    1039,
    "Bumbu Mi Instan (12020208)",
    "Bacillus cereus (koloni/g)-kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1040,
    "Bumbu Mi Instan (12020208)",
    "Bacillus cereus (koloni/g)-kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1041,
    "Bumbu Mi Instan (12020208)",
    "Bacillus cereus (koloni/g)-kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1042,
    "Bumbu Mi Instan (12020208)",
    "Bacillus cereus (koloni/g)-kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1043,
    "Bumbu Mi Instan (12020208)",
    "Bacillus cereus (koloni/g)-kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1044,
    "Bumbu Mi Instan (12020208)",
    "Clostridium pefringens (koloni/g)-kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1045,
    "Bumbu Mi Instan (12020208)",
    "Clostridium pefringens (koloni/g)-kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1046,
    "Bumbu Mi Instan (12020208)",
    "Clostridium pefringens (koloni/g)-kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1047,
    "Bumbu Mi Instan (12020208)",
    "Clostridium pefringens (koloni/g)-kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1048,
    "Bumbu Mi Instan (12020208)",
    "Clostridium pefringens (koloni/g)-kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [1049, "Bumbu Mi Instan (12020208)", "Salmonella (/25 g)-basah"],
  [
    1050,
    "Bumbu Mi Instan (12020208)",
    "Jumlah Sampel - Salmonella-basah",
  ],
  [
    1051,
    "Bumbu Mi Instan (12020208)",
    "Clostridium pefringens (koloni/g)-basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1052,
    "Bumbu Mi Instan (12020208)",
    "Clostridium pefringens (koloni/g)-basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1053,
    "Bumbu Mi Instan (12020208)",
    "Clostridium pefringens (koloni/g)-basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1054,
    "Bumbu Mi Instan (12020208)",
    "Clostridium pefringens (koloni/g)-basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1055,
    "Bumbu Mi Instan (12020208)",
    "Clostridium pefringens (koloni/g)-basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1056,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12020217)",
    "Salmonella (/25 g)",
  ],
  [
    1057,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12020217)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    1058,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12020217)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1059,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12020217)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1060,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12020217)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1061,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12020217)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1062,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12020217)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1063,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12050209)",
    "Salmonella (/25 g)",
  ],
  [
    1064,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12050209)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1065,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12050209)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1066,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12050209)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1067,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12050209)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1068,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12050209)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1069,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam) (12050209)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [1070, "Bumbu Rasa Ayam (12020220)", "Salmonella (/25 g)"],
  [
    1071,
    "Bumbu Rasa Ayam (12020220)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    1072,
    "Bumbu Rasa Ayam (12020220)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1073,
    "Bumbu Rasa Ayam (12020220)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1074,
    "Bumbu Rasa Ayam (12020220)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1075,
    "Bumbu Rasa Ayam (12020220)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1076,
    "Bumbu Rasa Ayam (12020220)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1077,
    "Bumbu Rasa Ayam (12020220)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1078,
    "Bumbu Rasa Ayam (12020220)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1079,
    "Bumbu Rasa Ayam (12020220)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1080,
    "Bumbu Rasa Ayam (12020220)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1081,
    "Bumbu Rasa Ayam (12020220)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [1082, "Bumbu Rasa Ayam (12050208)", "Salmonella (/25 g)"],
  [
    1083,
    "Bumbu Rasa Ayam (12050208)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1084,
    "Bumbu Rasa Ayam (12050208)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1085,
    "Bumbu Rasa Ayam (12050208)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1086,
    "Bumbu Rasa Ayam (12050208)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1087,
    "Bumbu Rasa Ayam (12050208)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1088,
    "Bumbu Rasa Ayam (12050208)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [1089, "Bumbu Rasa Ikan (12020218)", "Salmonella (/25 g)"],
  [
    1090,
    "Bumbu Rasa Ikan (12020218)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    1091,
    "Bumbu Rasa Ikan (12020218)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1092,
    "Bumbu Rasa Ikan (12020218)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1093,
    "Bumbu Rasa Ikan (12020218)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1094,
    "Bumbu Rasa Ikan (12020218)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1095,
    "Bumbu Rasa Ikan (12020218)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1096,
    "Bumbu Rasa Ikan (12020218)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1097,
    "Bumbu Rasa Ikan (12020218)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1098,
    "Bumbu Rasa Ikan (12020218)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1099,
    "Bumbu Rasa Ikan (12020218)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1100,
    "Bumbu Rasa Ikan (12020218)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [1101, "Bumbu Rasa Ikan (12050215)", "Salmonella (/25 g)"],
  [
    1102,
    "Bumbu Rasa Ikan (12050215)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1103,
    "Bumbu Rasa Ikan (12050215)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1104,
    "Bumbu Rasa Ikan (12050215)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1105,
    "Bumbu Rasa Ikan (12050215)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1106,
    "Bumbu Rasa Ikan (12050215)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1107,
    "Bumbu Rasa Ikan (12050215)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1108,
    "Bumbu Rasa Sapi (12020213)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1109,
    "Bumbu Rasa Sapi (12020213)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1110,
    "Bumbu Rasa Sapi (12020213)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1111,
    "Bumbu Rasa Sapi (12020213)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1112,
    "Bumbu Rasa Sapi (12020213)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [1113, "Bumbu Rasa Sapi (12020213)", "Salmonella (/25 g)"],
  [
    1114,
    "Bumbu Rasa Sapi (12020213)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [1115, "Bumbu Rasa Sapi (12050206)", "Salmonella (/25 g)"],
  [
    1116,
    "Bumbu Rasa Sapi (12050206)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1117,
    "Bumbu Rasa Sapi (12050206)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1118,
    "Bumbu Rasa Sapi (12050206)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1119,
    "Bumbu Rasa Sapi (12050206)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1120,
    "Bumbu Rasa Sapi (12050206)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1121,
    "Bumbu Rasa Sapi (12050206)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [1122, "Bumbu Rasa Udang (12020219)", "Salmonella (/25 g)"],
  [
    1123,
    "Bumbu Rasa Udang (12020219)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    1124,
    "Bumbu Rasa Udang (12020219)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1125,
    "Bumbu Rasa Udang (12020219)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1126,
    "Bumbu Rasa Udang (12020219)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1127,
    "Bumbu Rasa Udang (12020219)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1128,
    "Bumbu Rasa Udang (12020219)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1129,
    "Bumbu Rasa Udang (12020219)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1130,
    "Bumbu Rasa Udang (12020219)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1131,
    "Bumbu Rasa Udang (12020219)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1132,
    "Bumbu Rasa Udang (12020219)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1133,
    "Bumbu Rasa Udang (12020219)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [1134, "Bumbu Rasa Udang (12050216)", "Salmonella (/25 g)"],
  [
    1135,
    "Bumbu Rasa Udang (12050216)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1136,
    "Bumbu Rasa Udang (12050216)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1137,
    "Bumbu Rasa Udang (12050216)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1138,
    "Bumbu Rasa Udang (12050216)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1139,
    "Bumbu Rasa Udang (12050216)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1140,
    "Bumbu Rasa Udang (12050216)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1141,
    "Bumbu Siap Pakai (12020205)",
    "Salmonella (/25 g)-siap pakai kering",
  ],
  [
    1142,
    "Bumbu Siap Pakai (12020205)",
    "Jumlah Sampel - Salmonella-siap pakai kering",
  ],
  [
    1143,
    "Bumbu Siap Pakai (12020205)",
    "Bacillus cereus (koloni/g)-siap pakai kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1144,
    "Bumbu Siap Pakai (12020205)",
    "Bacillus cereus (koloni/g)-siap pakai kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1145,
    "Bumbu Siap Pakai (12020205)",
    "Bacillus cereus (koloni/g)-siap pakai kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1146,
    "Bumbu Siap Pakai (12020205)",
    "Bacillus cereus (koloni/g)-siap pakai kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1147,
    "Bumbu Siap Pakai (12020205)",
    "Bacillus cereus (koloni/g)-siap pakai kering",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1148,
    "Bumbu Siap Pakai (12020205)",
    "Clostridium pefringens (koloni/g)-siap pakai kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1149,
    "Bumbu Siap Pakai (12020205)",
    "Clostridium pefringens (koloni/g)-siap pakai kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1150,
    "Bumbu Siap Pakai (12020205)",
    "Clostridium pefringens (koloni/g)-siap pakai kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1151,
    "Bumbu Siap Pakai (12020205)",
    "Clostridium pefringens (koloni/g)-siap pakai kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1152,
    "Bumbu Siap Pakai (12020205)",
    "Clostridium pefringens (koloni/g)-siap pakai kering",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1153,
    "Bumbu Siap Pakai (12020205)",
    "Salmonella (/25 g)-siap pakai basah",
  ],
  [
    1154,
    "Bumbu Siap Pakai (12020205)",
    "Jumlah Sampel - Salmonella-siap pakai basah",
  ],
  [
    1155,
    "Bumbu Siap Pakai (12020205)",
    "Clostridium pefringens (koloni/g)-siap pakai basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1156,
    "Bumbu Siap Pakai (12020205)",
    "Clostridium pefringens (koloni/g)-siap pakai basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1157,
    "Bumbu Siap Pakai (12020205)",
    "Clostridium pefringens (koloni/g)-siap pakai basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1158,
    "Bumbu Siap Pakai (12020205)",
    "Clostridium pefringens (koloni/g)-siap pakai basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1159,
    "Bumbu Siap Pakai (12020205)",
    "Clostridium pefringens (koloni/g)-siap pakai basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [1160, "Bun Kukus (07010505)", "Salmonella (/25 g)"],
  [1161, "Bun Kukus (07010505)", "Jumlah Sampel - Salmonella"],
  [1162, "Buncis Beku (0402020102)", "Salmonella (/25 g)"],
  [1163, "Buncis Beku (0402020102)", "Jumlah Sampel - Salmonella"],
  [
    1164,
    "Buncis Beku (0402020102)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    1165,
    "Buncis Beku (0402020102)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    1166,
    "Buncis Beku (0402020102)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    1167,
    "Buncis Beku (0402020102)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    1168,
    "Buncis Beku (0402020102)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [1169, "Burger Daging (08030320)", "Salmonella (koloni/25 ml)"],
  [1170, "Burger Daging (08030320)", "Jumlah Sampel - Salmonella"],
  [
    1171,
    "Burger Daging (08030320)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1172,
    "Burger Daging (08030320)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1173,
    "Burger Daging (08030320)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1174,
    "Burger Daging (08030320)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1175,
    "Burger Daging (08030320)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1176,
    "Burger Daging (08030320)",
    "Listeria monocytogenes (/25 g)",
  ],
  [
    1177,
    "Burger Daging (08030320)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    1178,
    "Burger Ikan (0902040130)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1179,
    "Burger Ikan (0902040130)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1180,
    "Burger Ikan (0902040130)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1181,
    "Burger Ikan (0902040130)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1182,
    "Burger Ikan (0902040130)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [1183, "Buttermilk (Plain) (0101010201)", "Salmonella (/25 ml)"],
  [
    1184,
    "Buttermilk (Plain) (0101010201)",
    "Jumlah Sampel - Salmonella",
  ],
  [1185, "Butterscotch (05020204)", "Salmonella (Kembang"],
  [1186, "Gula/Permen"],
  [1187, "Lunak (bukan jeli)"],
  [1188, ") (/25 g)"],
  [1189, "Butterscotch (05020204)", "Jumlah Sampel - Salmonella"],
  [1190, "Butterscotch (05020204)", "Jumlah Sampel - Salmonella"],
  [
    1191,
    "Butterscotch (05020204)",
    "Salmonella (Kembang Gula/Permen Lunak (jeli)) (/25 g)",
  ],
  [1192, "Cabe Bubuk (12020124)", "Salmonella (/25 g)"],
  [1193, "Cabe Bubuk (12020124)", "Jumlah Sampel - Salmonella"],
  [
    1194,
    "Cabe Bubuk (12020124)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1195,
    "Cabe Bubuk (12020124)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1196,
    "Cabe Bubuk (12020124)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1197,
    "Cabe Bubuk (12020124)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1198,
    "Cabe Bubuk (12020124)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1199,
    "Cabe Bubuk (12020124)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1200,
    "Cabe Bubuk (12020124)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1201,
    "Cabe Bubuk (12020124)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1202,
    "Cabe Bubuk (12020124)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1203,
    "Cabe Bubuk (12020124)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [1204, "Cabe Jawa (12020121)", "Salmonella (/25 g)"],
  [1205, "Cabe Jawa (12020121)", "Jumlah Sampel - Salmonella"],
  [
    1206,
    "Cabe Jawa (12020121)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1207,
    "Cabe Jawa (12020121)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1208,
    "Cabe Jawa (12020121)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1209,
    "Cabe Jawa (12020121)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1210,
    "Cabe Jawa (12020121)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1211,
    "Cabe Jawa (12020121)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1212,
    "Cabe Jawa (12020121)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1213,
    "Cabe Jawa (12020121)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1214,
    "Cabe Jawa (12020121)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1215,
    "Cabe Jawa (12020121)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [1216, "Cakue (07020123)", "Salmonella (/25 g)"],
  [1217, "Cakue (07020123)", "Jumlah Sampel - Salmonella"],
  [
    1218,
    "Cakue (07020123)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1219,
    "Cakue (07020123)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1220,
    "Cakue (07020123)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1221,
    "Cakue (07020123)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1222,
    "Cakue (07020123)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1223,
    "Campuran kakao-gula (cocoa-sugar mixtures) (05010117)",
    "Salmonella (/25 g)",
  ],
  [
    1224,
    "Campuran kakao-gula (cocoa-sugar mixtures) (05010117)",
    "Salmonella (/25 g)",
  ],
  [
    1225,
    "Campuran kakao-gula (cocoa-sugar mixtures) (05010117)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1226,
    "Campuran kakao-gula (cocoa-sugar mixtures) (05010117)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1227,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1228,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1229,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Salmonella (negatif/25 g)",
  ],
  [
    1230,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Salmonella (negatif/25 g)",
  ],
  [
    1231,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1232,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1233,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1234,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1235,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1236,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1237,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1238,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1239,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1240,
    "Campuran Margarin dan Mentega (Blends of butter and margarine) (02020206)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1241,
    "Campuran Margarin Meja dan Mentega (02020208)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1242,
    "Campuran Margarin Meja dan Mentega (02020208)",
    "Salmonella (/25 g)",
  ],
  [
    1243,
    "Campuran Margarin Meja dan Mentega (02020208)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1244,
    "Campuran Margarin Meja dan Mentega (02020208)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1245,
    "Campuran Margarin Meja dan Mentega (02020208)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1246,
    "Campuran Margarin Meja dan Mentega (02020208)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1247,
    "Campuran Margarin Meja dan Mentega (02020208)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1248,
    "Campuran Susu dan Krim Bubuk (Plain) (01050110)",
    "Salmonella (/25 g)",
  ],
  [
    1249,
    "Campuran Susu dan Krim Bubuk (Plain) (01050110)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    1250,
    "Campuran Susu dan Krim Bubuk (Plain) (01050110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1251,
    "Campuran Susu dan Krim Bubuk (Plain) (01050110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1252,
    "Campuran Susu dan Krim Bubuk (Plain) (01050110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1253,
    "Campuran Susu dan Krim Bubuk (Plain) (01050110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1254,
    "Campuran Susu dan Krim Bubuk (Plain) (01050110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1255,
    "Campuran Susu dan Krim Bubuk (Plain) (01050201)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1256,
    "Campuran Susu dan Krim Bubuk (Plain) (01050201)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1257,
    "Campuran Susu dan Krim Bubuk (Plain) (01050201)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1258,
    "Campuran Susu dan Krim Bubuk (Plain) (01050201)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1259,
    "Campuran Susu dan Krim Bubuk (Plain) (01050201)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1260,
    "Campuran Susu dan Krim Bubuk (Plain) (01050201)",
    "Salmonella (/25 ml)",
  ],
  [
    1261,
    "Campuran Susu dan Krim Bubuk (Plain) (01050201)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1262,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01010414)",
    "Staphylococcus aureus (koloni/g)",
  ],
  [
    1263,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01010414)",
    "Staphylococcus aureus (koloni/g)",
  ],
  [
    1264,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01010414)",
    "Staphylococcus aureus (koloni/g)",
  ],
  [
    1265,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01010414)",
    "Staphylococcus aureus (koloni/g)",
  ],
  [
    1266,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01010414)",
    "Staphylococcus aureus (koloni/g)",
  ],
  [
    1267,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01010414)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    1268,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01010414)",
    "Salmonella (/25 g)",
  ],
  [
    1269,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01050202)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1270,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01050202)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1271,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01050202)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1272,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01050202)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1273,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01050202)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1274,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01050202)",
    "Salmonella (/25 ml)",
  ],
  [
    1275,
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa (01050202)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1276,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Salmonella (/25 g)",
  ],
  [
    1277,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Salmonella (/25 g)",
  ],
  [
    1278,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1279,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1280,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1281,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1282,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1283,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1284,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1285,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1286,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1287,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1288,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1289,
    "Campuran Untuk Saus, Gravies, dan Dressing (120603)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [1290, "Carabikang (07020122)", "Salmonella (/25 g)"],
  [1291, "Carabikang (07020122)", "Jumlah Sampel - Salmonella"],
  [
    1292,
    "Carabikang (07020122)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1293,
    "Carabikang (07020122)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1294,
    "Carabikang (07020122)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1295,
    "Carabikang (07020122)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1296,
    "Carabikang (07020122)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [1297, "Carob Coatings (05010504)", "Salmonella (/25 g)"],
  [
    1298,
    "Carob Coatings (05010504)",
    "Jumlah Sampel - Salmonella",
  ],
  [1299, "Cengkeh (12020126)", "Salmonella (/25 g)"],
  [1300, "Cengkeh (12020126)", "Jumlah Sampel - Salmonella"],
  [
    1301,
    "Cengkeh (12020126)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1302,
    "Cengkeh (12020126)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1303,
    "Cengkeh (12020126)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1304,
    "Cengkeh (12020126)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1305,
    "Cengkeh (12020126)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1306,
    "Cengkeh (12020126)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1307,
    "Cengkeh (12020126)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1308,
    "Cengkeh (12020126)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1309,
    "Cengkeh (12020126)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1310,
    "Cengkeh (12020126)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [1311, "Cengkeh Bubuk (12020127)", "Salmonella (/25 g)"],
  [1312, "Cengkeh Bubuk (12020127)", "Jumlah Sampel - Salmonella"],
  [
    1313,
    "Cengkeh Bubuk (12020127)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1314,
    "Cengkeh Bubuk (12020127)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1315,
    "Cengkeh Bubuk (12020127)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1316,
    "Cengkeh Bubuk (12020127)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1317,
    "Cengkeh Bubuk (12020127)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    1318,
    "Cengkeh Bubuk (12020127)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1319,
    "Cengkeh Bubuk (12020127)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1320,
    "Cengkeh Bubuk (12020127)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1321,
    "Cengkeh Bubuk (12020127)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1322,
    "Cengkeh Bubuk (12020127)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [1323, "Chicken Strip Beku (08020307)", "Salmonella (/25 g)"],
  [
    1324,
    "Chicken Strip Beku (08020307)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1325,
    "Chicken Strip Beku (08020307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1326,
    "Chicken Strip Beku (08020307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1327,
    "Chicken Strip Beku (08020307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1328,
    "Chicken Strip Beku (08020307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1329,
    "Chicken Strip Beku (08020307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1330,
    "Chicken Strip Beku (08020307)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    1331,
    "Chicken Strip Beku (08020307)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    1332,
    "Chorizos (0803010302)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1333,
    "Chorizos (0803010302)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1334,
    "Chorizos (0803010302)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1335,
    "Chorizos (0803010302)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1336,
    "Chorizos (0803010302)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [1337, "Chorizos (0803010302)", "Salmonella (/25 g)"],
  [1338, "Chorizos (0803010302)", "Jumlah Sampel - Salmonella"],
  [
    1339,
    "Chutney Mangga (Mango Chutney) (0401020601)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1340,
    "Chutney Mangga (Mango Chutney) (0401020601)",
    "Salmonella (/25 g)",
  ],
  [1341, "Cincau Hijau (0401020905)", "Salmonella (/25 g)"],
  [
    1342,
    "Cincau Hijau (0401020905)",
    "Jumlah Sampel - Salmonella",
  ],
  [1343, "Cincau Hitam (0401020906)", "Salmonella (/25 g)"],
  [
    1344,
    "Cincau Hitam (0401020906)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1345,
    "Cireng Seafood (0902040306)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1346,
    "Cireng Seafood (0902040306)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1347,
    "Cireng Seafood (0902040306)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1348,
    "Cireng Seafood (0902040306)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1349,
    "Cireng Seafood (0902040306)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1350,
    "Coating Dari Lembaga Gandum Bebas Lemak (Deffated Wheat Germ",
  ],
  [1351, "Coating) (05010505)", "Salmonella (/25 g)"],
  [
    1352,
    "Coating Dari Lembaga Gandum Bebas Lemak (Deffated Wheat Germ",
  ],
  [1353, "Coating) (05010505)", "Jumlah Sampel - Salmonella"],
  [
    1354,
    "Cocoa Butter Equivalent (05010501)",
    "Salmonella (/25 g)",
  ],
  [
    1355,
    "Cocoa Butter Equivalent (05010501)",
    "Jumlah Sampel - Salmonella",
  ],
  [1356, "Cokelat Aerasi (05010420)", "Salmonella (/25 g)"],
  [
    1357,
    "Cokelat Aerasi (05010420)",
    "Jumlah Sampel - Salmonella",
  ],
  [1358, "Cokelat Bubuk (05010119)", "Salmonella (/25 g)"],
  [1359, "Cokelat Bubuk (05010119)", "Jumlah Sampel - Salmonella"],
  [
    1360,
    "Cokelat Compound Butir/Cokelat Paduan Butir (05010506)",
    "Salmonella (/25 g)",
  ],
  [
    1361,
    "Cokelat Compound Butir/Cokelat Paduan Butir (05010506)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1362,
    "Cokelat Hitam (dark chocolate, semisweet chocolate, bittersweet chocolate) / Cokelat Hitam Isi ... (05010423)",
    "Salmonella (/25 g)",
  ],
  [
    1363,
    "Cokelat Hitam (dark chocolate, semisweet chocolate, bittersweet chocolate) / Cokelat Hitam Isi ... (05010423)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1364,
    "Cokelat Hitam Kovertur (Dark Chocolate Couverture) / Cokelat Hitam Kovertur Isi ... (05010425)",
    "Salmonella (/25 g)",
  ],
  [
    1365,
    "Cokelat Hitam Kovertur (Dark Chocolate Couverture) / Cokelat Hitam Kovertur Isi ... (05010425)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1366,
    "Cokelat Hitam Manis (Sweet Chocolate) / Cokelat Hitam Manis Isi ... (05010424)",
    "Salmonella (/25 g)",
  ],
  [
    1367,
    "Cokelat Hitam Manis (Sweet Chocolate) / Cokelat Hitam Manis Isi ... (05010424)",
    "Jumlah Sampel - Salmonella",
  ],
  [1368, "Cokelat Imitasi (05010510)", "Salmonella (/25 g)"],
  [
    1369,
    "Cokelat Imitasi (05010510)",
    "Jumlah Sampel - Salmonella",
  ],
  [1370, "Cokelat Instan (05010112)", "Salmonella (/25 g)"],
  [
    1371,
    "Cokelat Instan (05010112)",
    "Jumlah Sampel - Salmonella",
  ],
  [1372, "Cokelat Komposit (05010422)", "Salmonella (/25 g)"],
  [
    1373,
    "Cokelat Komposit (05010422)",
    "Jumlah Sampel - Salmonella",
  ],
  [1374, "Cokelat Laminasi (05010421)", "Salmonella (/25 g)"],
  [
    1375,
    "Cokelat Laminasi (05010421)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1376,
    "Cokelat Paduan / Cokelat Compound Hitam (dark compound chocolate) / Cokelat Compound Hitam Isi ... (05010511)",
    "Salmonella (/25 g)",
  ],
  [
    1377,
    "Cokelat Paduan / Cokelat Compound Hitam (dark compound chocolate) / Cokelat Compound Hitam Isi ... (05010511)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1378,
    "Cokelat Paduan / Cokelat Compound Hitam Manis (Sweet Dark Compound Chocolate) / Cokelat Compound Hitam Manis Isi ... (05010512)",
    "Salmonella (/25 g)",
  ],
  [
    1379,
    "Cokelat Paduan / Cokelat Compound Hitam Manis (Sweet Dark Compound Chocolate) / Cokelat Compound Hitam Manis Isi ... (05010512)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1380,
    "Cokelat Paduan / Cokelat Compound Putih (White Compound Chocolate) / Cokelat Compound Putih Isi ... (05010515)",
    "Salmonella (/25 g)",
  ],
  [
    1381,
    "Cokelat Paduan / Cokelat Compound Putih (White Compound Chocolate) / Cokelat Compound Putih Isi ... (05010515)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1382,
    "Cokelat Paduan / Cokelat Compound Putih Manis (Sweet White Compound Chocolate) / Cokelat Compound Putih Manis Isi ... (05010516)",
    "Salmonella (/25 g)",
  ],
  [
    1383,
    "Cokelat Paduan / Cokelat Compound Putih Manis (Sweet White Compound Chocolate) / Cokelat Compound Putih Manis Isi ... (05010516)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1384,
    "Cokelat Paduan / Cokelat Compound Susu (Milk Compound Chocolate) / Cokelat Compound Susu Isi ... (05010513)",
    "Salmonella (/25 g)",
  ],
  [
    1385,
    "Cokelat Paduan / Cokelat Compound Susu (Milk Compound Chocolate) / Cokelat Compound Susu Isi ... (05010513)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1386,
    "Cokelat Paduan / Cokelat Compound Susu Manis (Sweet Milk Compound Chocolate) / Cokelat Compound Susu Manis Isi ... (05010514)",
    "Salmonella (/25 g)",
  ],
  [
    1387,
    "Cokelat Paduan / Cokelat Compound Susu Manis (Sweet Milk Compound Chocolate) / Cokelat Compound Susu Manis Isi ... (05010514)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1388,
    "Cokelat Paduan/Cokelat Compound Hitam Pahit (bitter dark compound chocolate) / Cokelat Compound Hitam Pahit Isi ... (05010508)",
    "Salmonella (/25 g)",
  ],
  [
    1389,
    "Cokelat Paduan/Cokelat Compound Hitam Pahit (bitter dark compound chocolate) / Cokelat Compound Hitam Pahit Isi ... (05010508)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1390,
    "Cokelat Pasta (berbasis air) (05010305)",
    "Salmonella (/25 g)",
  ],
  [
    1391,
    "Cokelat Pasta (berbasis air) (05010305)",
    "Salmonella (/25 g)",
  ],
  [
    1392,
    "Cokelat Pasta (berbasis air) (05010305)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1393,
    "Cokelat Pasta (berbasis air) (05010305)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1394,
    "Cokelat Pasta (berbasis minyak) (05010304)",
    "Salmonella (/25 g)",
  ],
  [
    1395,
    "Cokelat Pasta (berbasis minyak) (05010304)",
    "Salmonella (/25 g)",
  ],
  [
    1396,
    "Cokelat Pasta (berbasis minyak) (05010304)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1397,
    "Cokelat Pasta (berbasis minyak) (05010304)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1398,
    "Cokelat Pelapis (Couverture chocolate) (05010415)",
    "Salmonella (/25 g)",
  ],
  [
    1399,
    "Cokelat Pelapis (Couverture chocolate) (05010415)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1400,
    "Cokelat Putih (white chocolate) / Cokelat Putih Isi ... (05010429)",
    "Salmonella (/25 g)",
  ],
  [
    1401,
    "Cokelat Putih (white chocolate) / Cokelat Putih Isi ... (05010429)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1402,
    "Cokelat Putih Kovertur (White Chocolate Couverture) / Cokelat Putih Kovertur Isi ... (05010427)",
    "Salmonella (/25 g)",
  ],
  [
    1403,
    "Cokelat Putih Kovertur (White Chocolate Couverture) / Cokelat Putih Kovertur Isi ... (05010427)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1404,
    "Cokelat Susu (milk chocolate) / Cokelat Susu Isi ... (05010430)",
    "Salmonella (/25 g)",
  ],
  [
    1405,
    "Cokelat Susu (milk chocolate) / Cokelat Susu Isi ... (05010430)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1406,
    "Cokelat Susu Kovertur (Milk Chocolate Couverture) / Cokelat Susu Kovertur Isi ... (05010426)",
    "Salmonella (/25 g)",
  ],
  [
    1407,
    "Cokelat Susu Kovertur (Milk Chocolate Couverture) / Cokelat Susu Kovertur Isi ... (05010426)",
    "Jumlah Sampel - Salmonella",
  ],
  [1408, "Cone untuk Es Krim (07020213)", "Salmonella (/25 g)"],
  [
    1409,
    "Cone untuk Es Krim (07020213)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1410,
    "Cone untuk Es Krim (07020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1411,
    "Cone untuk Es Krim (07020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1412,
    "Cone untuk Es Krim (07020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1413,
    "Cone untuk Es Krim (07020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1414,
    "Cone untuk Es Krim (07020213)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [1415, "Crepes (07020142)", "Salmonella (/25g)"],
  [
    1416,
    "Crepes (07020142)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    1417,
    "Crepes (07020142)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "<100",
  ],
  [
    1418,
    "Crepes (07020142)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "<100",
  ],
  [
    1419,
    "Crepes (07020142)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "<100",
  ],
  [
    1420,
    "Crepes (07020142)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "<100",
  ],
  [
    1421,
    "Crepes (07020142)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "<100",
  ],
  [1422, "Crouton (07010401)", "Salmonella (/25 g)"],
  [1423, "Crouton (07010401)", "Jumlah Sampel - Salmonella"],
  [
    1424,
    "Cumi dan Sotong Kering (09020534)",
    "Salmonella (/25 g)",
  ],
  [
    1425,
    "Cumi dan Sotong Kering (09020534)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    1426,
    "Cumi-Cumi / Kerang / Ikan / ... Beku (09020121)",
    "Salmonella (/25 g)",
  ],
  [
    1427,
    "Cumi-Cumi / Kerang / Ikan / ... Beku (09020121)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1428,
    "Cumi-Cumi / Kerang / Ikan / ... Beku (09020121)",
    "Vibrio parahaemolyticus (APM/g) - Selain Ikan",
    "",
    "<3",
  ],
  [
    1429,
    "Cumi-Cumi / Kerang / Ikan / ... Beku (09020121)",
    "Vibrio parahaemolyticus (APM/g) - Selain Ikan",
    "",
    "<3",
  ],
  [
    1430,
    "Cumi-Cumi / Kerang / Ikan / ... Beku (09020121)",
    "Vibrio parahaemolyticus (APM/g) - Selain Ikan",
    "",
    "<3",
  ],
  [
    1431,
    "Cumi-Cumi / Kerang / Ikan / ... Beku (09020121)",
    "Vibrio parahaemolyticus (APM/g) - Selain Ikan",
    "",
    "<3",
  ],
  [
    1432,
    "Cumi-Cumi / Kerang / Ikan / ... Beku (09020121)",
    "Vibrio parahaemolyticus (APM/g) - Selain Ikan",
    "",
    "<3",
  ],
  [1433, "Cumi-cumi Dalam Kemasan (090416)", "Salmonella (/25 g)"],
  [
    1434,
    "Cumi-cumi Dalam Kemasan (090416)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    1435,
    "Cumi-cumi Dalam Kemasan (090416)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    1436,
    "Cumi-cumi Dalam Kemasan (090416)",
    "Jumlah Sampel - Listeria monocytogenes",
    "\x{2265}",
  ],
  [1437, "Cumi-Cumi Kering/Juhi (09020509)", "Salmonella (/25 g)"],
  [
    1438,
    "Cumi-Cumi Kering/Juhi (09020509)",
    "Jumlah Sampel - Salmonella",
  ],
  [1439, "Custard (100402)", "Salmonella (/25 g)"],
  [1440, "Custard (100402)", "Jumlah Sampel - Salmonella"],
  [
    1441,
    "Custard (100402)",
    "Jumlah Sampel -Listeria monocytogenes",
  ],
  [
    1442,
    "Custard (100402)",
    "Listeria monocytogenes (koloni/25 g) - Khusus Produk Beku",
  ],
  [1443, "Custard Beku (100403)", "Salmonella (/25 g)"],
  [1444, "Custard Beku (100403)", "Jumlah Sampel - Salmonella"],
  [
    1445,
    "Custard Beku (100403)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    1446,
    "Custard Beku (100403)",
    "Jumlah Sampel -Listeria monocytogenes",
  ],
  [1447, "Dadih (0101010202)", "Salmonella (/25 ml)"],
  [1448, "Dadih (0101010202)", "Jumlah Sampel - Salmonella"],
  [1449, "Dadih (0102A0)", "Salmonella (/25 g)"],
  [
    1450,
    "Dadih (0102A0)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [1451, "Daging Asap (0802010108)", "Salmonella (/25 g)"],
  [1452, "Daging Asap (0802010108)", "Salmonella (/25 g)"],
  [1453, "Daging Asap (0802010108)", "Salmonella (/25 g)"],
  [1454, "Daging Asap (0802010108)", "Jumlah - Salmonella"],
  [
    1455,
    "Daging Asap (0802010108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1456,
    "Daging Asap (0802010108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1457,
    "Daging Asap (0802010108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1458,
    "Daging Asap (0802010108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1459,
    "Daging Asap (0802010108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1460,
    "Daging Asap (0802010108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1461,
    "Daging Asap (0802010108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1462,
    "Daging Asap (0802010108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1463,
    "Daging Asap (0802010108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1464,
    "Daging Asap (0802010108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1465,
    "Daging Ayam yang Dimarinasi (0802010112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1466,
    "Daging Ayam yang Dimarinasi (0802010112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1467,
    "Daging Ayam yang Dimarinasi (0802010112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1468,
    "Daging Ayam yang Dimarinasi (0802010112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1469,
    "Daging Ayam yang Dimarinasi (0802010112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1470,
    "Daging Ayam yang Dimarinasi (0802010112)",
    "Salmonella (/25 g)",
  ],
  [
    1471,
    "Daging Ayam yang Dimarinasi (0802010112)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1472,
    "Daging Cangkuk (0802010303)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1473,
    "Daging Cangkuk (0802010303)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1474,
    "Daging Cangkuk (0802010303)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1475,
    "Daging Cangkuk (0802010303)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1476,
    "Daging Cangkuk (0802010303)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [1477, "Daging Cangkuk (0802010303)", "Salmonella (/25 g)"],
  [1478, "Daging Cangkuk (0802010303)", "Jumlah - Salmonella"],
  [
    1479,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1480,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1481,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1482,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1483,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1484,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1485,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1486,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1487,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1488,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1489,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1490,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1491,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1492,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1493,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1494,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    1495,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    1496,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1497,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1498,
    "Daging Cincang Olahan Berbumbu (08030233)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1499,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1500,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1501,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1502,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1503,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1504,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1505,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1506,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1507,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1508,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1509,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1510,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1511,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1512,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1513,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1514,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    1515,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    1516,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1517,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1518,
    "Daging Halus Olahan Berbumbu (08030240)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1519,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    1520,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    1521,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1522,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1523,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1524,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1525,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1526,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1527,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1528,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1529,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1530,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1531,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1532,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1533,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Listeria monocytogenes (/25 g)",
  ],
  [
    1534,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Listeria monocytogenes (/25 g)",
  ],
  [
    1535,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    1536,
    "Daging Halus Olahan Berbumbu (Beku) (08030325)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    1537,
    "Daging Kepiting Rebus Beku (0902040202)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    1538,
    "Daging Kepiting Rebus Beku (0902040202)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    1539,
    "Daging Kepiting Rebus Beku (0902040202)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    1540,
    "Daging Kepiting Rebus Beku (0902040202)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    1541,
    "Daging Kepiting Rebus Beku (0902040202)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    1542,
    "Daging Kepiting Rebus Beku (0902040202)",
    "Salmonella (/25 g)",
  ],
  [
    1543,
    "Daging Kepiting Rebus Beku (0902040202)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1544,
    "Daging Kerang Abalon Kering (09020513)",
    "Salmonella (/25 g)",
  ],
  [
    1545,
    "Daging Kerang Abalon Kering (09020513)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1546,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1547,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1548,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1549,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1550,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1551,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1552,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1553,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1554,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1555,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1556,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1557,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1558,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1559,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1560,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1561,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Salmonella (/25 g)",
  ],
  [
    1562,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Salmonella (/25 g)",
  ],
  [
    1563,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Salmonella (/25 g)",
  ],
  [
    1564,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1565,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1566,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1567,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1568,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1569,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1570,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1571,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1572,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1573,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1574,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1575,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1576,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1577,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1578,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1579,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1580,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1581,
    "Daging Kuah Dalam Kemasan (08020210)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1582,
    "Daging Luncheon Matang (08030207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1583,
    "Daging Luncheon Matang (08030207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1584,
    "Daging Luncheon Matang (08030207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1585,
    "Daging Luncheon Matang (08030207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1586,
    "Daging Luncheon Matang (08030207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1587,
    "Daging Luncheon Matang (08030207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1588,
    "Daging Luncheon Matang (08030207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1589,
    "Daging Luncheon Matang (08030207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1590,
    "Daging Luncheon Matang (08030207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1591,
    "Daging Luncheon Matang (08030207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1592,
    "Daging Luncheon Matang (08030207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1593,
    "Daging Luncheon Matang (08030207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1594,
    "Daging Luncheon Matang (08030207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1595,
    "Daging Luncheon Matang (08030207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1596,
    "Daging Luncheon Matang (08030207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1597,
    "Daging Luncheon Matang (08030207)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1598,
    "Daging Luncheon Matang (08030207)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1599,
    "Daging Luncheon Matang (08030207)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1600,
    "Daging Luncheon Matang (08030207)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    1601,
    "Daging Luncheon Matang (08030207)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    1602,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1603,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1604,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1605,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1606,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1607,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1608,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1609,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1610,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1611,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1612,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "<250",
  ],
  [
    1613,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "<250",
  ],
  [
    1614,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "<250",
  ],
  [
    1615,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "<250",
  ],
  [
    1616,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "<250",
  ],
  [
    1617,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1618,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1619,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1620,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1621,
    "Daging Marinasi (0802010111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1622,
    "Daging Marinasi (0802010111)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1623,
    "Daging Marinasi (0802010111)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1624,
    "Daging Marinasi (0802010111)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1625,
    "Daging Marinasi (0802010111)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1626,
    "Daging Marinasi (0802010111)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    1627,
    "Daging Marinasi (Beku) (08020310)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1628,
    "Daging Marinasi (Beku) (08020310)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1629,
    "Daging Marinasi (Beku) (08020310)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1630,
    "Daging Marinasi (Beku) (08020310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1631,
    "Daging Marinasi (Beku) (08020310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1632,
    "Daging Marinasi (Beku) (08020310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1633,
    "Daging Marinasi (Beku) (08020310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1634,
    "Daging Marinasi (Beku) (08020310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1635,
    "Daging Marinasi (Beku) (08020310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1636,
    "Daging Marinasi (Beku) (08020310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1637,
    "Daging Marinasi (Beku) (08020310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1638,
    "Daging Marinasi (Beku) (08020310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1639,
    "Daging Marinasi (Beku) (08020310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1640,
    "Daging Marinasi (Beku) (08020310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1641,
    "Daging Marinasi (Beku) (08020310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1642,
    "Daging Marinasi (Beku) (08020310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1643,
    "Daging Marinasi (Beku) (08020310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1644,
    "Daging Marinasi (Beku) (08020310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1645,
    "Daging Marinasi (Beku) (08020310)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    1646,
    "Daging Marinasi (Beku) (08020310)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    1647,
    "Daging Marinasi (Beku) (08020310)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    1648,
    "Daging Marinasi (Beku) (08020310)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    1649,
    "Daging Marinasi (Beku) (08020310)",
    "Listeria monocytogenes (/25 g)",
  ],
  [
    1650,
    "Daging Olahan Berbumbu (08020225)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1651,
    "Daging Olahan Berbumbu (08020225)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1652,
    "Daging Olahan Berbumbu (08020225)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1653,
    "Daging Olahan Berbumbu (08020225)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1654,
    "Daging Olahan Berbumbu (08020225)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1655,
    "Daging Olahan Berbumbu (08020225)",
    "Salmonella (/25 g)",
  ],
  [
    1656,
    "Daging Olahan Berbumbu (08020225)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1657,
    "Daging Olahan Berbumbu (08020225)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1658,
    "Daging Olahan Berbumbu (08020225)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1659,
    "Daging Olahan Berbumbu (08020225)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1660,
    "Daging Olahan Berbumbu (08020225)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1661,
    "Daging Olahan Berbumbu (08020225)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1662,
    "Daging Olahan Berbumbu Beku (08020313)",
    "Salmonella (/25 g)",
  ],
  [
    1663,
    "Daging Olahan Berbumbu Beku (08020313)",
    "Jumlah - Salmonella",
  ],
  [
    1664,
    "Daging Olahan Berbumbu Beku (08020313)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1665,
    "Daging Olahan Berbumbu Beku (08020313)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1666,
    "Daging Olahan Berbumbu Beku (08020313)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1667,
    "Daging Olahan Berbumbu Beku (08020313)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1668,
    "Daging Olahan Berbumbu Beku (08020313)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1669,
    "Daging Olahan Berbumbu Beku (08020313)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    1670,
    "Daging Olahan Berbumbu Beku (08020313)",
    "Jumlah - Listeria monocytogenes",
  ],
  [
    1671,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1672,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1673,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1674,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1675,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1676,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1677,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1678,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1679,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1680,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1681,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Salmonella (/25 g)",
  ],
  [
    1682,
    "Daging Olahan Berbumbu Siap Makan (Rendang Daging, Semur Daging, dll) (08020228)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    1683,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1684,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1685,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1686,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1687,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1688,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Salmonella (/25 g)",
  ],
  [
    1689,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1690,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1691,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1692,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1693,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1694,
    "Daging Paha Babi Kuring Matang (08020201)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1695,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1696,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1697,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1698,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1699,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1700,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1701,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1702,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1703,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1704,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1705,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Salmonella (/25 g)",
  ],
  [
    1706,
    "Daging Paha Babi Kuring Mentah (0802010205)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1707,
    "Daging Rajungan Dalam Kaleng (090405)",
    "Salmonella (/25 g)",
  ],
  [
    1708,
    "Daging Rajungan Dalam Kaleng (090405)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    1709,
    "Daging Rajungan Dalam Kaleng (090405)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    1710,
    "Daging Rajungan Dalam Kaleng (090405)",
    "Jumlah Sampel -Listeria monocytogenes",
    "\x{2265}",
  ],
  [
    1711,
    "Daging Rajungan Rebus Dingin (0902040201)",
    "Salmonella (/25 g)",
  ],
  [
    1712,
    "Daging Rajungan Rebus Dingin (0902040201)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1713,
    "Daging Rajungan Rebus Dingin (0902040201)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    1714,
    "Daging Rajungan Rebus Dingin (0902040201)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    1715,
    "Daging Rajungan Rebus Dingin (0902040201)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    1716,
    "Daging Rajungan Rebus Dingin (0902040201)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    1717,
    "Daging Rajungan Rebus Dingin (0902040201)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    1718,
    "Daging Rajungan Rebus Dingin (0902040201)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    1719,
    "Daging Rajungan Rebus Dingin (0902040201)",
    "Jumlah Sampel -Listeria monocytogenes",
  ],
  [
    1720,
    "Daging Sapi yang Difermentasi Dalam Wadah Keramik (Potted Beef) (0802010301)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1721,
    "Daging Sapi yang Difermentasi Dalam Wadah Keramik (Potted Beef) (0802010301)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1722,
    "Daging Sapi yang Difermentasi Dalam Wadah Keramik (Potted Beef) (0802010301)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1723,
    "Daging Sapi yang Difermentasi Dalam Wadah Keramik (Potted Beef) (0802010301)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1724,
    "Daging Sapi yang Difermentasi Dalam Wadah Keramik (Potted Beef) (0802010301)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1725,
    "Daging Sapi yang Difermentasi Dalam Wadah Keramik (Potted Beef) (0802010301)",
    "Salmonella (/25 g)",
  ],
  [
    1726,
    "Daging Sapi yang Difermentasi Dalam Wadah Keramik (Potted Beef) (0802010301)",
    "Jumlah - Salmonella",
  ],
  [
    1727,
    "Daging Sapi yang Dimarinasi (0802010105)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1728,
    "Daging Sapi yang Dimarinasi (0802010105)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1729,
    "Daging Sapi yang Dimarinasi (0802010105)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1730,
    "Daging Sapi yang Dimarinasi (0802010105)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1731,
    "Daging Sapi yang Dimarinasi (0802010105)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1732,
    "Daging Sapi yang Dimarinasi (0802010105)",
    "Salmonella (/25 g)",
  ],
  [
    1733,
    "Daging Sapi yang Dimarinasi (0802010105)",
    "Jumlah - Salmonella",
  ],
  [
    1734,
    "Daging Sei (0802010110)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1735,
    "Daging Sei (0802010110)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1736,
    "Daging Sei (0802010110)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1737,
    "Daging Sei (0802010110)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [
    1738,
    "Daging Sei (0802010110)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}250",
  ],
  [1739, "Daging Sei (0802010110)", "Salmonella (/25 g)"],
  [1740, "Daging Sei (0802010110)", "Jumlah - Salmonella"],
  [
    1741,
    "Dango (060502)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1742,
    "Dango (060502)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1743,
    "Dango (060502)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1744,
    "Dango (060502)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1745,
    "Dango (060502)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [1746, "Dango (060502)", "Salmonella (/25 g)"],
  [1747, "Dango (060502)", "Jumlah Sampel - Salmonella"],
  [
    1748,
    "Dango (060502)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1749,
    "Dango (060502)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1750,
    "Dango (060502)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1751,
    "Dango (060502)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1752,
    "Dango (060502)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [1753, "Dashi (12020207)", "Salmonella (/25 g)"],
  [1754, "Dashi (12020207)", "Jumlah Sampel - Salmonella"],
  [
    1755,
    "Dashi (12020207)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1756,
    "Dashi (12020207)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1757,
    "Dashi (12020207)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1758,
    "Dashi (12020207)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1759,
    "Dashi (12020207)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1760,
    "Daun Jeruk Purut (Kaffir lime) (12020196)",
    "Salmonella (/25 g)",
  ],
  [
    1761,
    "Daun Jeruk Purut (Kaffir lime) (12020196)",
    "Jumlah Sampel - Salmonella",
  ],
  [1762, "Daun Ketumbar (12020162)", "Salmonella (/25 g)"],
  [1763, "Daun Ketumbar (12020162)", "Jumlah Sampel - Salmonella"],
  [1764, "Daun Pandan (12020197)", "Salmonella (/25 g)"],
  [1765, "Daun Pandan (12020197)", "Jumlah Sampel - Salmonella"],
  [1766, "Daun Peterseli (120201A2)", "Salmonella (/25 g)"],
  [
    1767,
    "Daun Peterseli (120201A2)",
    "Jumlah Sampel - Salmonella",
  ],
  [1768, "Daun Salam (12020130)", "Salmonella (/25 g)"],
  [1769, "Daun Salam (12020130)", "Jumlah Sampel - Salmonella"],
  [1770, "Daun Seledri (12020131)", "Salmonella (/25 g)"],
  [1771, "Daun Seledri (12020131)", "Jumlah Sampel - Salmonella"],
  [1772, "Daun Sembung (120201A3)", "Salmonella (/25 g)"],
  [1773, "Daun Sembung (120201A3)", "Jumlah Sampel - Salmonella"],
  [1774, "Daun Suji (120201A4)", "Salmonella (/25 g)"],
  [1775, "Daun Suji (120201A4)", "Jumlah Sampel - Salmonella"],
  [
    1776,
    "Debu Kakao (Cocoa Dust) (05010105)",
    "Salmonella (/25 g)",
  ],
  [
    1777,
    "Debu Kakao (Cocoa Dust) (05010105)",
    "Salmonella (/25 g)",
  ],
  [
    1778,
    "Debu Kakao (Cocoa Dust) (05010105)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1779,
    "Debu Kakao (Cocoa Dust) (05010105)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1780,
    "Degermed Maize (Corn) Grits (060311)",
    "Salmonella (/25 g)",
  ],
  [
    1781,
    "Degermed Maize (Corn) Grits (060311)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1782,
    "Degermed Maize (Corn) Grits (060311)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1783,
    "Degermed Maize (Corn) Grits (060311)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1784,
    "Degermed Maize (Corn) Grits (060311)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1785,
    "Degermed Maize (Corn) Grits (060311)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1786,
    "Degermed Maize (Corn) Grits (060311)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1787,
    "Degermed Maize (Corn) Meal (060307)",
    "Salmonella (/25 g)",
  ],
  [
    1788,
    "Degermed Maize (Corn) Meal (060307)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1789,
    "Degermed Maize (Corn) Meal (060307)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1790,
    "Degermed Maize (Corn) Meal (060307)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1791,
    "Degermed Maize (Corn) Meal (060307)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1792,
    "Degermed Maize (Corn) Meal (060307)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1793,
    "Degermed Maize (Corn) Meal (060307)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1794,
    "Dekorasi (Misalnya Untuk Bakery) dan Topping (Non-Buah) (050407)",
    "Salmonella (/25 g)",
  ],
  [1795, "Dekstrin (06020206)", "Salmonella (/25 g)"],
  [1796, "Dekstrin (06020206)", "Jumlah Sampel - Salmonella"],
  [
    1797,
    "Dekstrin (06020206)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1798,
    "Dekstrin (06020206)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1799,
    "Dekstrin (06020206)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1800,
    "Dekstrin (06020206)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1801,
    "Dekstrin (06020206)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1802,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1803,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1804,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1805,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1806,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1807,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1808,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1809,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1810,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1811,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1812,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Salmonella (/25 g)",
  ],
  [
    1813,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Salmonella (/25 g)",
  ],
  [
    1814,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Jumlah - Salmonella",
  ],
  [
    1815,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Jumlah - Salmonella",
  ],
  [
    1816,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1817,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1818,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1819,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1820,
    "Dendeng Daging (dengan perlakuan panas) (08030242)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1821,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1822,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1823,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1824,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1825,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1826,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1827,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1828,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1829,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1830,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1831,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1832,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1833,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1834,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1835,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1836,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Salmonella (/25 g)",
  ],
  [
    1837,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Salmonella (/25 g)",
  ],
  [
    1838,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Salmonella (/25 g)",
  ],
  [
    1839,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Jumlah - Salmonella",
  ],
  [
    1840,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1841,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1842,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1843,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1844,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1845,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1846,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1847,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1848,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1849,
    "Dendeng Daging (tanpa perlakuan panas) (0802010207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [1850, "Dendeng Ikan (09020528)", "Salmonella (/25 g)"],
  [
    1851,
    "Dendeng Ikan (09020528)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [1852, "Dill Weed (12020129)", "Salmonella (/25 g)"],
  [1853, "Dill Weed (12020129)", "Jumlah Sampel - Salmonella"],
  [
    1854,
    "Dimsum Ikan (0902040126)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1855,
    "Dimsum Ikan (0902040126)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1856,
    "Dimsum Ikan (0902040126)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1857,
    "Dimsum Ikan (0902040126)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1858,
    "Dimsum Ikan (0902040126)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [1859, "Dimsum Udang (0902040213)", "Salmonella (/25 g)"],
  [
    1860,
    "Dimsum Udang (0902040213)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    1861,
    "Dimsum Udang (0902040213)",
    "Listeria monocytogenes (/25 g)",
  ],
  [
    1862,
    "Dimsum Udang (0902040213)",
    "Jumlah Sampel -Listeria monocytogenes",
    "\x{2265}",
  ],
  [
    1863,
    "Dimsum Udang (0902040213)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    1864,
    "Dimsum Udang (0902040213)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    1865,
    "Dimsum Udang (0902040213)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    1866,
    "Dimsum Udang (0902040213)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    1867,
    "Dimsum Udang (0902040213)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    1868,
    "Dodol atau Lempok Buah (0401021208)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1869,
    "Dodol atau Lempok Buah (0401021208)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1870,
    "Dodol atau Lempok Buah (0401021208)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1871,
    "Dodol atau Lempok Buah (0401021208)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1872,
    "Dodol atau Lempok Buah (0401021208)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    1873,
    "Dodol atau Lempok Buah (0401021208)",
    "Salmonella (/25 g)",
  ],
  [
    1874,
    "Dodol atau Lempok Buah (0401021208)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1875,
    "Dodol Rumput Laut/Dodol berbahan dasar sayur atau kacang-kacangan lainnya (0402020810)",
    "Salmonella (/25 g)",
  ],
  [
    1876,
    "Dodol Rumput Laut/Dodol berbahan dasar sayur atau kacang-kacangan lainnya (0402020810)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    1877,
    "Dodol Rumput Laut/Dodol berbahan dasar sayur atau kacang-kacangan lainnya (0402020810)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1878,
    "Dodol Rumput Laut/Dodol berbahan dasar sayur atau kacang-kacangan lainnya (0402020810)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1879,
    "Dodol Rumput Laut/Dodol berbahan dasar sayur atau kacang-kacangan lainnya (0402020810)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1880,
    "Dodol Rumput Laut/Dodol berbahan dasar sayur atau kacang-kacangan lainnya (0402020810)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1881,
    "Dodol Rumput Laut/Dodol berbahan dasar sayur atau kacang-kacangan lainnya (0402020810)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1882,
    "Dodol/Jenang/Gelamai (060701)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1883,
    "Dodol/Jenang/Gelamai (060701)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1884,
    "Dodol/Jenang/Gelamai (060701)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1885,
    "Dodol/Jenang/Gelamai (060701)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1886,
    "Dodol/Jenang/Gelamai (060701)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1887,
    "Dodol/Jenang/Gelamai (060701)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1888,
    "Dodol/Jenang/Gelamai (060701)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1889,
    "Dodol/Jenang/Gelamai (060701)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1890,
    "Dodol/Jenang/Gelamai (060701)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1891,
    "Dodol/Jenang/Gelamai (060701)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [1892, "Dodol/Jenang/Gelamai (060701)", "Salmonella (/25 g)"],
  [1893, "Dodol/Jenang/Gelamai (060701)", "Salmonella (/25 g)"],
  [
    1894,
    "Dodol/Jenang/Gelamai (060701)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1895,
    "Dodol/Jenang/Gelamai (060701)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1896,
    "Dodol/Jenang/Gelamai (060701)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1897,
    "Dodol/Jenang/Gelamai (060701)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1898,
    "Dodol/Jenang/Gelamai (060701)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1899,
    "Dodol/Jenang/Gelamai (060701)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1900,
    "Dodol/Jenang/Gelamai (060701)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1901,
    "Dodol/Jenang/Gelamai (060701)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1902,
    "Dodol/Jenang/Gelamai (060701)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1903,
    "Dodol/Jenang/Gelamai (060701)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1904,
    "Dodol/Jenang/Gelamai (060701)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1905,
    "Dodol/Jenang/Gelamai (060701)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [1906, "Donat (07020205)", "Salmonella (/25 g)"],
  [1907, "Donat (07020205)", "Jumlah Sampel - Salmonella"],
  [
    1908,
    "Donat (07020205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1909,
    "Donat (07020205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1910,
    "Donat (07020205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1911,
    "Donat (07020205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1912,
    "Donat (07020205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [1913, "Dou chi (06080601)", "Salmonella (/25 g)"],
  [1914, "Dou chi (06080601)", "Jumlah Sampel - Salmonella"],
  [1915, "Ebi Bubuk (09020529)", "Salmonella (/25 g)"],
  [
    1916,
    "Ebi Bubuk (09020529)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [1917, "Ebi Katsu (08030316)", "Salmonella (koloni/25 ml)"],
  [1918, "Ebi Katsu (08030316)", "Jumlah Sampel - Salmonella"],
  [
    1919,
    "Ebi Katsu (08030316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1920,
    "Ebi Katsu (08030316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1921,
    "Ebi Katsu (08030316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1922,
    "Ebi Katsu (08030316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1923,
    "Ebi Katsu (08030316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [1924, "Ebi Katsu (08030316)", "Listeria monocytogenes (/25 g)"],
  [
    1925,
    "Ebi Katsu (08030316)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [1926, "Egg Roll (07020126)", "Salmonella (/25 g)"],
  [1927, "Egg Roll (07020126)", "Jumlah Sampel - Salmonella"],
  [
    1928,
    "Egg Roll (07020126)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1929,
    "Egg Roll (07020126)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1930,
    "Egg Roll (07020126)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1931,
    "Egg Roll (07020126)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1932,
    "Egg Roll (07020126)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    1933,
    "Ekado/ Moneybag (08030324)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    1934,
    "Ekado/ Moneybag (08030324)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1935,
    "Ekado/ Moneybag (08030324)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1936,
    "Ekado/ Moneybag (08030324)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1937,
    "Ekado/ Moneybag (08030324)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1938,
    "Ekado/ Moneybag (08030324)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1939,
    "Ekado/ Moneybag (08030324)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    1940,
    "Ekado/ Moneybag (08030324)",
    "Listeria monocytogenes (/25 g)",
  ],
  [
    1941,
    "Ekado/ Moneybag (08030324)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    1942,
    "Eko Tukir (060730)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1943,
    "Eko Tukir (060730)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1944,
    "Eko Tukir (060730)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1945,
    "Eko Tukir (060730)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    1946,
    "Eko Tukir (060730)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [1947, "Eko Tukir (060730)", "Salmonella (/25 g)"],
  [1948, "Eko Tukir (060730)", "Jumlah Sampel - Salmonella"],
  [
    1949,
    "Eko Tukir (060730)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1950,
    "Eko Tukir (060730)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1951,
    "Eko Tukir (060730)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1952,
    "Eko Tukir (060730)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    1953,
    "Eko Tukir (060730)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [1954, "Ekstrak Aloe (0402020605)", "Salmonella (/25 g)"],
  [
    1955,
    "Ekstrak Aloe (0402020605)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1956,
    "Empek-Empek Palembang (0902040113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1957,
    "Empek-Empek Palembang (0902040113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1958,
    "Empek-Empek Palembang (0902040113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1959,
    "Empek-Empek Palembang (0902040113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    1960,
    "Empek-Empek Palembang (0902040113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [1961, "Emping Melinjo Goreng (150130)", "Salmonella (/25 g)"],
  [
    1962,
    "Emping Melinjo Goreng (150130)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1963,
    "Emping Melinjo Goreng (150130)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1964,
    "Emping Melinjo Goreng (150130)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1965,
    "Emping Melinjo Goreng (150130)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1966,
    "Emping Melinjo Goreng (150130)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1967,
    "Emping Melinjo Goreng (150130)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    1968,
    "Emulsi Lemak Tipe Emulsi Minyak dalam Air, termasuk Produk Campuran Emulsi Lemak dengan atau Berperisa (0203)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1969,
    "Emulsi Lemak Tipe Emulsi Minyak dalam Air, termasuk Produk Campuran Emulsi Lemak dengan atau Berperisa (0203)",
    "Salmonella (/25 g)",
  ],
  [
    1970,
    "Emulsi Lemak Tipe Emulsi Minyak dalam Air, termasuk Produk Campuran Emulsi Lemak dengan atau Berperisa (0203)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1971,
    "Emulsi Lemak Tipe Emulsi Minyak dalam Air, termasuk Produk Campuran Emulsi Lemak dengan atau Berperisa (0203)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1972,
    "Emulsi Lemak Tipe Emulsi Minyak dalam Air, termasuk Produk Campuran Emulsi Lemak dengan atau Berperisa (0203)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1973,
    "Emulsi Lemak Tipe Emulsi Minyak dalam Air, termasuk Produk Campuran Emulsi Lemak dengan atau Berperisa (0203)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1974,
    "Emulsi Lemak Tipe Emulsi Minyak dalam Air, termasuk Produk Campuran Emulsi Lemak dengan atau Berperisa (0203)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1975,
    "Enting-Enting Kacang Gepuk (05020304)",
    "Salmonella (/25 g)",
  ],
  [
    1976,
    "Enting-Enting Kacang Gepuk (05020304)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1977,
    "Es Batu Untuk Konsumsi (0316)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [1978, "Es Batu Untuk Konsumsi (0316)", "Salmonella (/25 ml)"],
  [
    1979,
    "Es Buah (Fruit Ice) (0302)",
    "Jumlah Sampel - Salmonella",
  ],
  [1980, "Es Buah (Fruit Ice) (0302)", "Salmonella (/25 ml)"],
  [
    1981,
    "Es Jepit atau Es Serut atau Es Gusruk/Gosrok (0304)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    1982,
    "Es Jepit atau Es Serut atau Es Gusruk/Gosrok (0304)",
    "Salmonella (/25 ml)",
  ],
  [1983, "Es Krim (010701)", "Salmonella (/25 g)"],
  [1984, "Es Krim (010701)", "Jumlah Sampel - Salmonella"],
  [
    1985,
    "Es Krim (010701)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1986,
    "Es Krim (010701)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1987,
    "Es Krim (010701)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1988,
    "Es Krim (010701)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1989,
    "Es Krim (010701)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1990,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1991,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1992,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1993,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1994,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1995,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1996,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1997,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1998,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    1999,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2000,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2001,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2002,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2003,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2004,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2005,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2006,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2007,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2008,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2009,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2010,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2011,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2012,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2013,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2014,
    "Es Krim Modifikasi (010719)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2015,
    "Es Krim Susu (Dairy Ice Cream) (010720)",
    "Salmonella (/25 g)",
  ],
  [
    2016,
    "Es Krim Susu (Dairy Ice Cream) (010720)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    2017,
    "Es Krim Susu (Dairy Ice Cream) (010720)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2018,
    "Es Krim Susu (Dairy Ice Cream) (010720)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2019,
    "Es Krim Susu (Dairy Ice Cream) (010720)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2020,
    "Es Krim Susu (Dairy Ice Cream) (010720)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2021,
    "Es Krim Susu (Dairy Ice Cream) (010720)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [2022, "Es Kue (0308)", "Jumlah Sampel - Salmonella"],
  [2023, "Es Kue (0308)", "Salmonella (/25 ml)"],
  [2024, "Es Lilin (0307)", "Jumlah Sampel - Salmonella"],
  [2025, "Es Lilin (0307)", "Salmonella (/25 ml)"],
  [2026, "Es Lilin Goyang (0306)", "Jumlah Sampel - Salmonella"],
  [2027, "Es Lilin Goyang (0306)", "Salmonella (/25 ml)"],
  [2028, "Es Loli (0314)", "Jumlah Sampel - Salmonella"],
  [2029, "Es Loli (0314)", "Salmonella (/25 ml)"],
  [2030, "Es Mambo (0303)", "Jumlah Sampel - Salmonella"],
  [2031, "Es Mambo (0303)", "Salmonella (/25 ml)"],
  [2032, "Es Mengandung Susu (0320)", "Salmonella (/25ml)"],
  [
    2033,
    "Es Mengandung Susu (0320)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [2034, "Es Pelangi (0312)", "Jumlah Sampel - Salmonella"],
  [2035, "Es Pelangi (0312)", "Salmonella (/25 ml)"],
  [2036, "Es Puter (0305)", "Jumlah Sampel - Salmonella"],
  [2037, "Es Puter (0305)", "Salmonella (/25 ml)"],
  [
    2038,
    "Es Stik (Ice Stick) atau Es Loli (0311)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2039,
    "Es Stik (Ice Stick) atau Es Loli (0311)",
    "Salmonella (/25 ml)",
  ],
  [2040, "Es Susu (010703)", "Salmonella (/25 g)"],
  [2041, "Es Susu (010703)", "Jumlah Sampel - Salmonella"],
  [2042, "Es Tebak (0313)", "Jumlah Sampel - Salmonella"],
  [2043, "Es Tebak (0313)", "Salmonella (/25 ml)"],
  [
    2044,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk (12020134)",
    "Salmonella (/25 g)",
  ],
  [
    2045,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk (12020134)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2046,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk (12020134)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2047,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk (12020134)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2048,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk (12020134)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2049,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk (12020134)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2050,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk (12020134)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2051,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk (12020134)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2052,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk (12020134)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2053,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk (12020134)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2054,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk (12020134)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2055,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk (12020134)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2056,
    "Fenugreek, Kelabat, Kelabet, Klabat (12020133)",
    "Salmonella (/25 g)",
  ],
  [
    2057,
    "Fenugreek, Kelabat, Kelabet, Klabat (12020133)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2058,
    "Fenugreek, Kelabat, Kelabet, Klabat (12020133)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2059,
    "Fenugreek, Kelabat, Kelabet, Klabat (12020133)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2060,
    "Fenugreek, Kelabat, Kelabet, Klabat (12020133)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2061,
    "Fenugreek, Kelabat, Kelabet, Klabat (12020133)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2062,
    "Fenugreek, Kelabat, Kelabet, Klabat (12020133)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2063,
    "Fenugreek, Kelabat, Kelabet, Klabat (12020133)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2064,
    "Fenugreek, Kelabat, Kelabet, Klabat (12020133)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2065,
    "Fenugreek, Kelabat, Kelabet, Klabat (12020133)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2066,
    "Fenugreek, Kelabat, Kelabet, Klabat (12020133)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2067,
    "Fenugreek, Kelabat, Kelabet, Klabat (12020133)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2068,
    "Fermentasi Buah (termasuk sari buah fermentasi) (0401021004)",
    "Salmonella (/25 g)",
  ],
  [
    2069,
    "Fermentasi Buah (termasuk sari buah fermentasi) (0401021004)",
    "Jumlah Sampel - Salmonella",
  ],
  [2070, "Fish Kasu-zuke (09030202)", "Salmonella (/25 g)"],
  [
    2071,
    "Fish Kasu-zuke (09030202)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2072,
    "Fish Kasu-zuke (09030202)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    2073,
    "Fish Kasu-zuke (09030202)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [2074, "Fish Koji-zuke (09030201)", "Salmonella (/25 g)"],
  [
    2075,
    "Fish Koji-zuke (09030201)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2076,
    "Fish Koji-zuke (09030201)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    2077,
    "Fish Koji-zuke (09030201)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [2078, "Fish Miso-zuke (09030203)", "Salmonella (/25 g)"],
  [
    2079,
    "Fish Miso-zuke (09030203)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2080,
    "Fish Miso-zuke (09030203)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    2081,
    "Fish Miso-zuke (09030203)",
    "Jumlah Sampel -Listeria monocytogenes",
  ],
  [2082, "Fish Shoyu-zuke (09030204)", "Salmonella (/25 g)"],
  [
    2083,
    "Fish Shoyu-zuke (09030204)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2084,
    "Fish Shoyu-zuke (09030204)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    2085,
    "Fish Shoyu-zuke (09030204)",
    "Jumlah Sampel -Listeria monocytogenes",
  ],
  [2086, "Fish Su-zuke (09030205)", "Salmonella (/25 g)"],
  [2087, "Fish Su-zuke (09030205)", "Jumlah Sampel - Salmonella"],
  [
    2088,
    "Fish Su-zuke (09030205)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    2089,
    "Fish Su-zuke (09030205)",
    "Jumlah Sampel -Listeria monocytogenes",
  ],
  [2090, "Fish Tsukudani (09030104)", "Salmonella (/25 g)"],
  [
    2091,
    "Fish Tsukudani (09030104)",
    "Jumlah Sampel - Salmonella",
  ],
  [2092, "Foie Gras and Pates (08020227)", "Salmonella (/25 g)"],
  [2093, "Foie Gras and Pates (08020227)", "Salmonella (/25 g)"],
  [2094, "Foie Gras and Pates (08020227)", "Jumlah - Salmonella"],
  [
    2095,
    "Foie Gras and Pates (08020227)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2096,
    "Foie Gras and Pates (08020227)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2097,
    "Foie Gras and Pates (08020227)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2098,
    "Foie Gras and Pates (08020227)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2099,
    "Foie Gras and Pates (08020227)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2100,
    "Foie Gras and Pates (08020227)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2101,
    "Foie Gras and Pates (08020227)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2102,
    "Foie Gras and Pates (08020227)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2103,
    "Foie Gras and Pates (08020227)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2104,
    "Foie Gras and Pates (08020227)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2105,
    "Foie Gras and Pates (08020227)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2106,
    "Foie Gras and Pates (08020227)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2107,
    "Foie Gras and Pates (08020227)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2108,
    "Foie Gras and Pates (08020227)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2109,
    "Foie Gras and Pates (08020227)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2110,
    "Formula Bayi Bubuk (13010101)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2111,
    "Formula Bayi Bubuk (13010101)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2112,
    "Formula Bayi Bubuk (13010101)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2113,
    "Formula Bayi Bubuk (13010101)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2114,
    "Formula Bayi Bubuk (13010101)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2115,
    "Formula Bayi Bubuk (13010101)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2116,
    "Formula Bayi Bubuk (13010101)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2117,
    "Formula Bayi Bubuk (13010101)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2118,
    "Formula Bayi Bubuk (13010101)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2119,
    "Formula Bayi Bubuk (13010101)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2120,
    "Formula Bayi Bubuk (13010101)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2121,
    "Formula Bayi Bubuk (13010101)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2122,
    "Formula Bayi Bubuk (13010101)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2123,
    "Formula Bayi Bubuk (13010101)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2124,
    "Formula Bayi Bubuk (13010101)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2125,
    "Formula Bayi Bubuk (13010101)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2126,
    "Formula Bayi Bubuk (13010101)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    2127,
    "Formula Bayi Bubuk (13010101)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2128,
    "Formula Bayi Bubuk (13010101)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2129,
    "Formula Bayi Cair (1308)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2130,
    "Formula Bayi Cair (1308)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2131,
    "Formula Bayi Cair (1308)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2132,
    "Formula Bayi Cair (1308)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2133,
    "Formula Bayi Cair (1308)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2134,
    "Formula Bayi Cair (1308)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2135,
    "Formula Bayi Cair (1308)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2136,
    "Formula Bayi Cair (1308)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2137,
    "Formula Bayi Cair (1308)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2138,
    "Formula Bayi Cair (1308)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2139,
    "Formula Bayi Cair (1308)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2140,
    "Formula Bayi Cair (1308)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2141,
    "Formula Bayi Cair (1308)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2142,
    "Formula Bayi Cair (1308)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2143,
    "Formula Bayi Cair (1308)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2144,
    "Formula Bayi Cair (1308)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2145,
    "Formula Bayi Cair (1308)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [2146, "Formula Bayi Cair (1308)", "Salmonella (koloni/25 g)"],
  [2147, "Formula Bayi Cair (1308)", "Jumlah Sampel - Salmonella"],
  [
    2148,
    "Formula Bayi Padat (1307)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2149,
    "Formula Bayi Padat (1307)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2150,
    "Formula Bayi Padat (1307)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2151,
    "Formula Bayi Padat (1307)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2152,
    "Formula Bayi Padat (1307)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2153,
    "Formula Bayi Padat (1307)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2154,
    "Formula Bayi Padat (1307)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2155,
    "Formula Bayi Padat (1307)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2156,
    "Formula Bayi Padat (1307)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2157,
    "Formula Bayi Padat (1307)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2158,
    "Formula Bayi Padat (1307)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2159,
    "Formula Bayi Padat (1307)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2160,
    "Formula Bayi Padat (1307)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2161,
    "Formula Bayi Padat (1307)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2162,
    "Formula Bayi Padat (1307)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2163,
    "Formula Bayi Padat (1307)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2164,
    "Formula Bayi Padat (1307)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [2165, "Formula Bayi Padat (1307)", "Salmonella (koloni/25 g)"],
  [
    2166,
    "Formula Bayi Padat (1307)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2167,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2168,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2169,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2170,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2171,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2172,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2173,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2174,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2175,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2176,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2177,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2178,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2179,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2180,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2181,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2182,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2183,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    2184,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2185,
    "Formula Kedelai untuk Bayi (Soy Protein Formulas) (130315)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2186,
    "Formula Lanjutan Bubuk (13010201)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2187,
    "Formula Lanjutan Bubuk (13010201)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2188,
    "Formula Lanjutan Bubuk (13010201)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2189,
    "Formula Lanjutan Bubuk (13010201)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2190,
    "Formula Lanjutan Bubuk (13010201)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2191,
    "Formula Lanjutan Bubuk (13010201)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2192,
    "Formula Lanjutan Bubuk (13010201)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2193,
    "Formula Lanjutan Bubuk (13010201)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2194,
    "Formula Lanjutan Bubuk (13010201)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2195,
    "Formula Lanjutan Bubuk (13010201)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2196,
    "Formula Lanjutan Bubuk (13010201)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2197,
    "Formula Lanjutan Bubuk (13010201)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2198,
    "Formula Lanjutan Bubuk (13010201)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2199,
    "Formula Lanjutan Bubuk (13010201)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2200,
    "Formula Lanjutan Bubuk (13010201)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2201,
    "Formula Lanjutan Bubuk (13010201)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2202,
    "Formula Lanjutan Bubuk (13010201)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2203,
    "Formula Lanjutan Padat (1309)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2204,
    "Formula Lanjutan Padat (1309)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2205,
    "Formula Lanjutan Padat (1309)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2206,
    "Formula Lanjutan Padat (1309)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2207,
    "Formula Lanjutan Padat (1309)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2208,
    "Formula Lanjutan Padat (1309)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2209,
    "Formula Lanjutan Padat (1309)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2210,
    "Formula Lanjutan Padat (1309)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2211,
    "Formula Lanjutan Padat (1309)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2212,
    "Formula Lanjutan Padat (1309)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2213,
    "Formula Lanjutan Padat (1309)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2214,
    "Formula Lanjutan Padat (1309)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2215,
    "Formula Lanjutan Padat (1309)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2216,
    "Formula Lanjutan Padat (1309)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2217,
    "Formula Lanjutan Padat (1309)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2218,
    "Formula Lanjutan Padat (1309)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2219,
    "Formula Lanjutan Padat (1309)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2220,
    "Formula Makanan Pelengkap (Formulated Supplementary Foods) (130504)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2221,
    "Formula Makanan Pelengkap (Formulated Supplementary Foods) (130504)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2222,
    "Formula Makanan Pelengkap (Formulated Supplementary Foods) (130504)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2223,
    "Formula Makanan Pelengkap (Formulated Supplementary Foods) (130504)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2224,
    "Formula Makanan Pelengkap (Formulated Supplementary Foods) (130504)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2225,
    "Formula Makanan Pelengkap (Formulated Supplementary Foods) (130504)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    2226,
    "Formula Makanan Pelengkap (Formulated Supplementary Foods) (130504)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    2227,
    "Formula Makanan Pelengkap (Formulated Supplementary Foods) (130504)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    2228,
    "Formula Makanan Pelengkap (Formulated Supplementary Foods) (130504)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    2229,
    "Formula Makanan Pelengkap (Formulated Supplementary Foods) (130504)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    2230,
    "Formula Makanan Pelengkap (Formulated Supplementary Foods) (130504)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2231,
    "Formula Makanan Pelengkap (Formulated Supplementary Foods) (130504)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2232,
    "Formula Makanan Pelengkap (Formulated Supplementary Foods) (130504)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2233,
    "Formula Makanan Pelengkap (Formulated Supplementary Foods) (130504)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2234,
    "Formula Makanan Pelengkap (Formulated Supplementary Foods) (130504)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2235,
    "Formula Makanan Pelengkap (Formulated Supplementary Foods) (130504)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2236,
    "Formula Makanan Pelengkap (Formulated Supplementary Foods) (130504)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2237,
    "Formula Makanan Pengganti (Formulated Meal Replacements) (130503)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2238,
    "Formula Makanan Pengganti (Formulated Meal Replacements) (130503)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2239,
    "Formula Makanan Pengganti (Formulated Meal Replacements) (130503)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2240,
    "Formula Makanan Pengganti (Formulated Meal Replacements) (130503)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2241,
    "Formula Makanan Pengganti (Formulated Meal Replacements) (130503)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2242,
    "Formula Makanan Pengganti (Formulated Meal Replacements) (130503)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    2243,
    "Formula Makanan Pengganti (Formulated Meal Replacements) (130503)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    2244,
    "Formula Makanan Pengganti (Formulated Meal Replacements) (130503)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    2245,
    "Formula Makanan Pengganti (Formulated Meal Replacements) (130503)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    2246,
    "Formula Makanan Pengganti (Formulated Meal Replacements) (130503)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    2247,
    "Formula Makanan Pengganti (Formulated Meal Replacements) (130503)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2248,
    "Formula Makanan Pengganti (Formulated Meal Replacements) (130503)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2249,
    "Formula Makanan Pengganti (Formulated Meal Replacements) (130503)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2250,
    "Formula Makanan Pengganti (Formulated Meal Replacements) (130503)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2251,
    "Formula Makanan Pengganti (Formulated Meal Replacements) (130503)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2252,
    "Formula Makanan Pengganti (Formulated Meal Replacements) (130503)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2253,
    "Formula Makanan Pengganti (Formulated Meal Replacements) (130503)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2254,
    "Formula Pertumbuhan Bubuk (13010401)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2255,
    "Formula Pertumbuhan Bubuk (13010401)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2256,
    "Formula Pertumbuhan Bubuk (13010401)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2257,
    "Formula Pertumbuhan Bubuk (13010401)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2258,
    "Formula Pertumbuhan Bubuk (13010401)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2259,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2260,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2261,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2262,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2263,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2264,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2265,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2266,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2267,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2268,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2269,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2270,
    "Formula Pertumbuhan Bubuk (13010401)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2271,
    "Formula Pertumbuhan Padat (1311)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2272,
    "Formula Pertumbuhan Padat (1311)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2273,
    "Formula Pertumbuhan Padat (1311)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2274,
    "Formula Pertumbuhan Padat (1311)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2275,
    "Formula Pertumbuhan Padat (1311)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2276,
    "Formula Pertumbuhan Padat (1311)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2277,
    "Formula Pertumbuhan Padat (1311)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2278,
    "Formula Pertumbuhan Padat (1311)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2279,
    "Formula Pertumbuhan Padat (1311)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2280,
    "Formula Pertumbuhan Padat (1311)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2281,
    "Formula Pertumbuhan Padat (1311)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2282,
    "Formula Pertumbuhan Padat (1311)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2283,
    "Formula Pertumbuhan Padat (1311)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2284,
    "Formula Pertumbuhan Padat (1311)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2285,
    "Formula Pertumbuhan Padat (1311)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2286,
    "Formula Pertumbuhan Padat (1311)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2287,
    "Formula Pertumbuhan Padat (1311)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2288,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2289,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2290,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2291,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2292,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2293,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2294,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2295,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2296,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2297,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2298,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2299,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2300,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2301,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2302,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2303,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2304,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    2305,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2306,
    "Formula Standar Berbasis Susu Sapi (Standard Milk-Based Formulas) (1301010103)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2307,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2308,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2309,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2310,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2311,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2312,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2313,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2314,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2315,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2316,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2317,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2318,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2319,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2320,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2321,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2322,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2323,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    2324,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2325,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2326,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2327,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2328,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2329,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2330,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2331,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2332,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2333,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2334,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2335,
    "Formula untuk Bayi Berat Badan Lahir Rendah (130317)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2336,
    "Formula untuk Bayi Prematur (13010301)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2337,
    "Formula untuk Bayi Prematur (13010301)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2338,
    "Formula untuk Bayi Prematur (13010301)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2339,
    "Formula untuk Bayi Prematur (13010301)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2340,
    "Formula untuk Bayi Prematur (13010301)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2341,
    "Formula untuk Bayi Prematur (13010301)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2342,
    "Formula untuk Bayi Prematur (13010301)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2343,
    "Formula untuk Bayi Prematur (13010301)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2344,
    "Formula untuk Bayi Prematur (13010301)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2345,
    "Formula untuk Bayi Prematur (13010301)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2346,
    "Formula untuk Bayi Prematur (13010301)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2347,
    "Formula untuk Bayi Prematur (13010301)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2348,
    "Formula untuk Bayi Prematur (13010301)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2349,
    "Formula untuk Bayi Prematur (13010301)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2350,
    "Formula untuk Bayi Prematur (13010301)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2351,
    "Formula untuk Bayi Prematur (13010301)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2352,
    "Formula untuk Bayi Prematur (13010301)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    2353,
    "Formula untuk Bayi Prematur (13010301)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2354,
    "Formula untuk Bayi Prematur (13010301)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2355,
    "Formula untuk Bayi Prematur (13010301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2356,
    "Formula untuk Bayi Prematur (13010301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2357,
    "Formula untuk Bayi Prematur (13010301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2358,
    "Formula untuk Bayi Prematur (13010301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2359,
    "Formula untuk Bayi Prematur (13010301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2360,
    "Formula untuk Bayi Prematur (13010301)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2361,
    "Formula untuk Bayi Prematur (13010301)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2362,
    "Formula untuk Bayi Prematur (13010301)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2363,
    "Formula untuk Bayi Prematur (13010301)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2364,
    "Formula untuk Bayi Prematur (13010301)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2365,
    "Formula untuk Bayi Prematur (130316)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2366,
    "Formula untuk Bayi Prematur (130316)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2367,
    "Formula untuk Bayi Prematur (130316)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2368,
    "Formula untuk Bayi Prematur (130316)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2369,
    "Formula untuk Bayi Prematur (130316)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2370,
    "Formula untuk Bayi Prematur (130316)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2371,
    "Formula untuk Bayi Prematur (130316)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2372,
    "Formula untuk Bayi Prematur (130316)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2373,
    "Formula untuk Bayi Prematur (130316)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2374,
    "Formula untuk Bayi Prematur (130316)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2375,
    "Formula untuk Bayi Prematur (130316)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2376,
    "Formula untuk Bayi Prematur (130316)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2377,
    "Formula untuk Bayi Prematur (130316)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2378,
    "Formula untuk Bayi Prematur (130316)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2379,
    "Formula untuk Bayi Prematur (130316)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2380,
    "Formula untuk Bayi Prematur (130316)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2381,
    "Formula untuk Bayi Prematur (130316)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    2382,
    "Formula untuk Bayi Prematur (130316)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2383,
    "Formula untuk Bayi Prematur (130316)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2384,
    "Formula untuk Bayi Prematur (130316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2385,
    "Formula untuk Bayi Prematur (130316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2386,
    "Formula untuk Bayi Prematur (130316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2387,
    "Formula untuk Bayi Prematur (130316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2388,
    "Formula untuk Bayi Prematur (130316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2389,
    "Formula untuk Bayi Prematur (130316)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2390,
    "Formula untuk Bayi Prematur (130316)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2391,
    "Formula untuk Bayi Prematur (130316)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2392,
    "Formula untuk Bayi Prematur (130316)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2393,
    "Formula untuk Bayi Prematur (130316)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2394,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2395,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2396,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2397,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2398,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2399,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2400,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2401,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2402,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2403,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2404,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2405,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2406,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2407,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2408,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2409,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2410,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    2411,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2412,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2413,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2414,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2415,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2416,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2417,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2418,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2419,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2420,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2421,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2422,
    "Formula Untuk Keperluan Medis Khusus bagi Bayi (130103)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2423,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2424,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2425,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2426,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2427,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2428,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2429,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2430,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2431,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2432,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2433,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2434,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2435,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2436,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2437,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2438,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2439,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    2440,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2441,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2442,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2443,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2444,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2445,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2446,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2447,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2448,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2449,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2450,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2451,
    "Formula Untuk Keperluan Medis Khusus Bayi Dengan Alergi Protein Susu Sapi Padat (1341)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2452,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2453,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2454,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2455,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2456,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2457,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2458,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2459,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2460,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2461,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2462,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2463,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2464,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2465,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2466,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2467,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2468,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    2469,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2470,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2471,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2472,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2473,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2474,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2475,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2476,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2477,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2478,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2479,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2480,
    "Formula Untuk Keperluan Medis Khusus Bayi Prematur Padat (1339)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2481,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2482,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2483,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2484,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2485,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2486,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2487,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2488,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2489,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2490,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2491,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2492,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2493,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2494,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2495,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2496,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2497,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    2498,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2499,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2500,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2501,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2502,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2503,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2504,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2505,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2506,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2507,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2508,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2509,
    "Formula Untuk Keperluan Medis Khusus Untuk Bayi Dengan Kejang Intraktabel (Epilepsi) Padat (1355)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2510,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2511,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2512,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2513,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2514,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2515,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2516,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2517,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2518,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2519,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2520,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2521,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2522,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2523,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2524,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2525,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2526,
    "Formula Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Anak Beresiko Gagal Tumbuh, Gizi Kurang, Atau Gizi Buruk Padat (1345)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2527,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2528,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2529,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2530,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2531,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2532,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2533,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2534,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2535,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2536,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2537,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2538,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2539,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2540,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2541,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2542,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2543,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    2544,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2545,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2546,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2547,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2548,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2549,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2550,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2551,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2552,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2553,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2554,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2555,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Cair (1350)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2556,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2557,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2558,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2559,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2560,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2561,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2562,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2563,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2564,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2565,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2566,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2567,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2568,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2569,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2570,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2571,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2572,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    2573,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2574,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2575,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2576,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2577,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2578,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2579,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2580,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2581,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2582,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2583,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2584,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Fenilketonuria Padat (1349)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2585,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2586,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2587,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2588,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2589,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2590,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2591,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2592,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2593,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2594,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2595,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2596,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2597,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2598,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2599,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2600,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2601,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    2602,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2603,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2604,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2605,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2606,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2607,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2608,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2609,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2610,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2611,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2612,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2613,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Cair (1348)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2614,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2615,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2616,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2617,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2618,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2619,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2620,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2621,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2622,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2623,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2624,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2625,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2626,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2627,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2628,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2629,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2630,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    2631,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2632,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2633,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2634,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2635,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2636,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2637,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2638,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2639,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2640,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2641,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2642,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Isovaleric Acedemia Padat (1347)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2643,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2644,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2645,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2646,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2647,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2648,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2649,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2650,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2651,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2652,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2653,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2654,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2655,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2656,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2657,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2658,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2659,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    2660,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2661,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2662,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2663,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2664,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2665,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2666,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2667,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2668,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2669,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2670,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2671,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1353)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2672,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2673,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2674,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2675,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2676,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2677,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2678,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2679,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2680,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2681,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2682,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2683,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2684,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2685,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2686,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2687,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2688,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    2689,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2690,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2691,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2692,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2693,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2694,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2695,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2696,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2697,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2698,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2699,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2700,
    "Formula Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1351)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [2701, "French Dressing (12060104)", "Salmonella (/25 g)"],
  [
    2702,
    "French Dressing (12060104)",
    "Jumlah Sampel - Salmonella",
  ],
  [2703, "Frosting (050402)", "Salmonella (/25 g)"],
  [2704, "Frosting (050402)", "Jumlah Sampel - Salmonella"],
  [2705, "Fudge (05020203)", "Salmonella (Kembang"],
  [2706, "Gula/Permen"],
  [2707, "Lunak (bukan jeli)"],
  [2708, ") (/25 g)"],
  [2709, "Fudge (05020203)", "Jumlah Sampel - Salmonella"],
  [2710, "Fudge (05020203)", "Jumlah Sampel - Salmonella"],
  [
    2711,
    "Fudge (05020203)",
    "Salmonella (Kembang Gula/Permen Lunak (jeli)) (/25 g)",
  ],
  [2712, "Fuli Bubuk (12020136)", "Salmonella (/25 g)"],
  [2713, "Fuli Bubuk (12020136)", "Jumlah Sampel - Salmonella"],
  [
    2714,
    "Fuli Bubuk (12020136)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2715,
    "Fuli Bubuk (12020136)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2716,
    "Fuli Bubuk (12020136)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2717,
    "Fuli Bubuk (12020136)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2718,
    "Fuli Bubuk (12020136)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2719,
    "Fuli Bubuk (12020136)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2720,
    "Fuli Bubuk (12020136)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2721,
    "Fuli Bubuk (12020136)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2722,
    "Fuli Bubuk (12020136)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2723,
    "Fuli Bubuk (12020136)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [2724, "Fuli Kering (12020135)", "Salmonella (/25 g)"],
  [2725, "Fuli Kering (12020135)", "Jumlah Sampel - Salmonella"],
  [
    2726,
    "Fuli Kering (12020135)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2727,
    "Fuli Kering (12020135)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2728,
    "Fuli Kering (12020135)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2729,
    "Fuli Kering (12020135)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2730,
    "Fuli Kering (12020135)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2731,
    "Fuli Kering (12020135)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2732,
    "Fuli Kering (12020135)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2733,
    "Fuli Kering (12020135)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2734,
    "Fuli Kering (12020135)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2735,
    "Fuli Kering (12020135)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [2736, "Furikake (12020206)", "Salmonella (/25 g)"],
  [2737, "Furikake (12020206)", "Jumlah Sampel - Salmonella"],
  [
    2738,
    "Furikake (12020206)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2739,
    "Furikake (12020206)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2740,
    "Furikake (12020206)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2741,
    "Furikake (12020206)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2742,
    "Furikake (12020206)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2743,
    "Furikake (12020206)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2744,
    "Furikake (12020206)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2745,
    "Furikake (12020206)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2746,
    "Furikake (12020206)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2747,
    "Furikake (12020206)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [2748, "Gari (060312)", "Salmonella (/25 g)"],
  [2749, "Gari (060312)", "Jumlah Sampel - Salmonella"],
  [
    2750,
    "Gari (060312)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    2751,
    "Gari (060312)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    2752,
    "Gari (060312)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    2753,
    "Gari (060312)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    2754,
    "Gari (060312)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    2755,
    "Geplak (0401021210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2756,
    "Geplak (0401021210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2757,
    "Geplak (0401021210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2758,
    "Geplak (0401021210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2759,
    "Geplak (0401021210)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [2760, "Geplak (0401021210)", "Salmonella (/25 g)"],
  [2761, "Geplak (0401021210)", "Jumlah Sampel - Salmonella"],
  [2762, "Getas (150307)", "Salmonella (/25 g)"],
  [2763, "Getas (150307)", "Jumlah Sampel - Salmonella"],
  [
    2764,
    "Getas (150307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2765,
    "Getas (150307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2766,
    "Getas (150307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2767,
    "Getas (150307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2768,
    "Getas (150307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [2769, "Getuk Singkong (0402020803)", "Salmonella (/25 g)"],
  [
    2770,
    "Getuk Singkong (0402020803)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2771,
    "Getuk Singkong (0402020803)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2772,
    "Getuk Singkong (0402020803)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2773,
    "Getuk Singkong (0402020803)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2774,
    "Getuk Singkong (0402020803)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2775,
    "Getuk Singkong (0402020803)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [2776, "Gochujang (0402020709)", "Salmonella (/25 g)"],
  [2777, "Gochujang (0402020709)", "Jumlah Sampel - Salmonella"],
  [2778, "Granola (060317)", "Salmonella (/25 g)"],
  [
    2779,
    "Granola (060317)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    2780,
    "Granola (060317)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    2781,
    "Granola (060317)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    2782,
    "Granola (060317)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    2783,
    "Granola (060317)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    2784,
    "Granola (060317)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [2785, "Gudeg (Yogya) (1602)", "Salmonella (koloni/25 g)"],
  [
    2786,
    "Gudeg (Yogya) (1602)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [2787, "Gudeg (Yogya) (1602)", "Listeria"],
  [2788, "monocytogenes (koloni/25 g)"],
  [2789, "Gudeg (Yogya) (1602)", "Jumlah Sampel - Listeria"],
  [2790, "monocytogenes", "", "\x{2265}5"],
  [2791, "Gudeg (Yogya) (1602)", "Staphylococcus"],
  [2792, "aureus (koloni/g)", "\x{2264}200", "\x{2264}100"],
  [2793, "Gudeg (Yogya) (1602)", "Staphylococcus"],
  [2794, "aureus (koloni/g)", "\x{2264}200", "\x{2264}100"],
  [2795, "Gudeg (Yogya) (1602)", "Staphylococcus"],
  [2796, "aureus (koloni/g)", "\x{2264}200", "\x{2264}100"],
  [2797, "Gudeg (Yogya) (1602)", "Staphylococcus"],
  [2798, "aureus (koloni/g)", "\x{2264}200", "\x{2264}100"],
  [2799, "Gudeg (Yogya) (1602)", "Staphylococcus"],
  [2800, "aureus (koloni/g)", "\x{2264}200", "\x{2264}100"],
  [
    2801,
    "Gula Kapas (Cotton Candy)/Arumanis (05020211)",
    "Salmonella (/25 g)",
  ],
  [
    2802,
    "Gula Kapas (Cotton Candy)/Arumanis (05020211)",
    "Jumlah Sampel - Salmonella",
  ],
  [2803, "Gulali (05020213)", "Salmonella (/25 g)"],
  [2804, "Gulali (05020213)", "Jumlah Sampel - Salmonella"],
  [2805, "Gyoza (08030304)", "Salmonella (/25 g)"],
  [
    2806,
    "Gyoza (08030304)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}5",
  ],
  [
    2807,
    "Gyoza (08030304)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2808,
    "Gyoza (08030304)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2809,
    "Gyoza (08030304)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2810,
    "Gyoza (08030304)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2811,
    "Gyoza (08030304)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [2812, "Gyoza (08030304)", "Listeria monocytogenes (/25 g)"],
  [
    2813,
    "Gyoza (08030304)",
    "Jumlah Sampel - Listeria monocytogenes",
    "\x{2265}",
  ],
  [2814, "Half and Half (01040102)", "Salmonella (/25 ml)"],
  [2815, "Half and Half (01040102)", "Jumlah Sampel - Salmonella"],
  [
    2816,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2817,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2818,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2819,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2820,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2821,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Salmonella (/25 g)",
  ],
  [
    2822,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2823,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2824,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2825,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2826,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2827,
    "Ham Sapi (Daging Paha Sapi Kuring) Matang (08020203)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    2828,
    "Hasil Olah Iles-iles Dalam Bentuk Jeli (0402020612)",
    "Salmonella (/25 g)",
  ],
  [
    2829,
    "Hasil Olah Iles-iles Dalam Bentuk Jeli (0402020612)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2830,
    "Hasil Olahan Sawit - Pengganti Santan (020303)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2831,
    "Hasil Olahan Sawit - Pengganti Santan (020303)",
    "Salmonella (/25 g)",
  ],
  [
    2832,
    "Hasil Olahan Sawit - Pengganti Santan (020303)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2833,
    "Hasil Olahan Sawit - Pengganti Santan (020303)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2834,
    "Hasil Olahan Sawit - Pengganti Santan (020303)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2835,
    "Hasil Olahan Sawit - Pengganti Santan (020303)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    2836,
    "Hasil Olahan Sawit - Pengganti Santan (020303)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [2837, "Herba (12020101)", "Salmonella (/25 g)"],
  [2838, "Herba (12020101)", "Jumlah Sampel - Salmonella"],
  [
    2839,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Salmonella (/25 g)-Semua Herba Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [2840, ""],
  [
    2841,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Jumlah Sampel-Salmonella-Semua Herba Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [
    2842,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Salmonella (/25 g)-Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [
    2843,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Jumlah Sampel - Salmonella-Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
  ],
  [
    2844,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Bacillus cereus (koloni/g)-Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2845,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Bacillus cereus (koloni/g)-Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2846,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Bacillus cereus (koloni/g)-Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2847,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Bacillus cereus (koloni/g)-Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2848,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Bacillus cereus (koloni/g)-Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2849,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Clostridium pefringens (koloni/g)-Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2850,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Clostridium pefringens (koloni/g)-Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2851,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Clostridium pefringens (koloni/g)-Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2852,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Clostridium pefringens (koloni/g)-Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2853,
    "Herba dan Rempah yang Diproses dengan Pemasakan, Fermentasi dan atau Penambahan Bahan Tambahan Pangan (120201B3)",
    "Clostridium pefringens (koloni/g)-Rempah Kering (Termasuk Bentuk Utuh dan Bubuk)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [2854, "Huajuan (07010507)", "Salmonella (/25 g)"],
  [2855, "Huajuan (07010507)", "Jumlah Sampel - Salmonella"],
  [
    2856,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2857,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2858,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2859,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2860,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    2861,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2862,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2863,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2864,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2865,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2866,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2867,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2868,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2869,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2870,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    2871,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    2872,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    2873,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Salmonella (koloni/25 g)",
  ],
  [
    2874,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2875,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2876,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2877,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2878,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2879,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    2880,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2881,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2882,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2883,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    2884,
    "Human Milk Fortifier (HMF) Padat (1343)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [2885, "Icing (050401)", "Salmonella (/25 g)"],
  [2886, "Icing (050401)", "Jumlah Sampel - Salmonella"],
  [2887, "Ikan Asap (09020501)", "Salmonella (/25 g)"],
  [2888, "Ikan Asap (09020501)", "Jumlah Sampel - Salmonella"],
  [2889, "Ikan Asin Jambal Roti (09020530)", "Salmonella (/25 g)"],
  [
    2890,
    "Ikan Asin Jambal Roti (09020530)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [2891, "Ikan Asin Kering (09020503)", "Salmonella (/25 g)"],
  [
    2892,
    "Ikan Asin Kering (09020503)",
    "Jumlah Sampel - Salmonella",
  ],
  [2893, "Ikan Dalam Kemasan (090418)", "Salmonella (/25 g)"],
  [
    2894,
    "Ikan Dalam Kemasan (090418)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    2895,
    "Ikan Dalam Kemasan (090418)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    2896,
    "Ikan Dalam Kemasan (090418)",
    "Jumlah Sampel - Listeria monocytogenes",
    "\x{2265}",
  ],
  [
    2897,
    "Ikan dan Produk Ikan Kukus atau Rebus (0902040101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2898,
    "Ikan dan Produk Ikan Kukus atau Rebus (0902040101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2899,
    "Ikan dan Produk Ikan Kukus atau Rebus (0902040101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2900,
    "Ikan dan Produk Ikan Kukus atau Rebus (0902040101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2901,
    "Ikan dan Produk Ikan Kukus atau Rebus (0902040101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [2902, "Ikan Kayu (09020502)", "Salmonella (/25 g)"],
  [2903, "Ikan Kayu (09020502)", "Jumlah Sampel - Salmonella"],
  [2904, "Ikan Kering (09020524)", "Salmonella (/25 g)"],
  [2905, "Ikan Kering (09020524)", "Jumlah Sampel - Salmonella"],
  [
    2906,
    "Ikan Panggang (0902040305)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2907,
    "Ikan Panggang (0902040305)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2908,
    "Ikan Panggang (0902040305)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2909,
    "Ikan Panggang (0902040305)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2910,
    "Ikan Panggang (0902040305)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [2911, "Ikan Peda (09020531)", "Salmonella (/25 g)"],
  [
    2912,
    "Ikan Peda (09020531)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    2913,
    "Ikan Pindang (0902040102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2914,
    "Ikan Pindang (0902040102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2915,
    "Ikan Pindang (0902040102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2916,
    "Ikan Pindang (0902040102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2917,
    "Ikan Pindang (0902040102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2918,
    "Ikan Pindang Air Garam (0902040103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2919,
    "Ikan Pindang Air Garam (0902040103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2920,
    "Ikan Pindang Air Garam (0902040103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2921,
    "Ikan Pindang Air Garam (0902040103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2922,
    "Ikan Pindang Air Garam (0902040103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2923,
    "Ikan Pindang Garam (0902040104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2924,
    "Ikan Pindang Garam (0902040104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2925,
    "Ikan Pindang Garam (0902040104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2926,
    "Ikan Pindang Garam (0902040104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2927,
    "Ikan Pindang Garam (0902040104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2928,
    "Ikan Renyah (0902040314)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2929,
    "Ikan Renyah (0902040314)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2930,
    "Ikan Renyah (0902040314)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2931,
    "Ikan Renyah (0902040314)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2932,
    "Ikan Renyah (0902040314)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [2933, "Ikan Teri Asin Kering (09020504)", "Salmonella (/25 g)"],
  [
    2934,
    "Ikan Teri Asin Kering (09020504)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2935,
    "Ikan Teri Nasi Setengah Kering (09020505)",
    "Salmonella (/25 g)",
  ],
  [
    2936,
    "Ikan Teri Nasi Setengah Kering (09020505)",
    "Jumlah Sampel - Salmonella",
  ],
  [2937, "Ikura (09030307)", "Salmonella (/25 g)"],
  [2938, "Ikura (09030307)", "Jumlah Sampel - Salmonella"],
  [
    2939,
    "Ikura (09030307)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    2940,
    "Ikura (09030307)",
    "Jumlah Sampel -Listeria monocytogenes",
  ],
  [
    2941,
    "Ikura (09030307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2942,
    "Ikura (09030307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2943,
    "Ikura (09030307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2944,
    "Ikura (09030307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2945,
    "Ikura (09030307)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    2946,
    "Jadah Manten (060721)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2947,
    "Jadah Manten (060721)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2948,
    "Jadah Manten (060721)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2949,
    "Jadah Manten (060721)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2950,
    "Jadah Manten (060721)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [2951, "Jadah Manten (060721)", "Salmonella (/25 g)"],
  [2952, "Jadah Manten (060721)", "Jumlah Sampel - Salmonella"],
  [
    2953,
    "Jadah Manten (060721)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    2954,
    "Jadah Manten (060721)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    2955,
    "Jadah Manten (060721)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    2956,
    "Jadah Manten (060721)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    2957,
    "Jadah Manten (060721)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [2958, "Jagung Berondong (150119)", "Salmonella (/25 g)"],
  [
    2959,
    "Jagung Berondong (150119)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2960,
    "Jagung Berondong (150119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2961,
    "Jagung Berondong (150119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2962,
    "Jagung Berondong (150119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2963,
    "Jagung Berondong (150119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2964,
    "Jagung Berondong (150119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2965,
    "Jagung Bertongkol Beku (0402020110)",
    "Salmonella (/25 g)",
  ],
  [
    2966,
    "Jagung Bertongkol Beku (0402020110)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    2967,
    "Jagung Bertongkol Beku (0402020110)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    2968,
    "Jagung Bertongkol Beku (0402020110)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    2969,
    "Jagung Bertongkol Beku (0402020110)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    2970,
    "Jagung Bertongkol Beku (0402020110)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    2971,
    "Jagung Bertongkol Beku (0402020110)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [2972, "Jagung Marning (150120)", "Salmonella (/25 g)"],
  [2973, "Jagung Marning (150120)", "Jumlah Sampel - Salmonella"],
  [
    2974,
    "Jagung Marning (150120)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2975,
    "Jagung Marning (150120)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2976,
    "Jagung Marning (150120)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2977,
    "Jagung Marning (150120)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    2978,
    "Jagung Marning (150120)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [2979, "Jahe Bubuk (12020140)", "Salmonella (/25 g)"],
  [2980, "Jahe Bubuk (12020140)", "Jumlah Sampel - Salmonella"],
  [
    2981,
    "Jahe Bubuk (12020140)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2982,
    "Jahe Bubuk (12020140)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2983,
    "Jahe Bubuk (12020140)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2984,
    "Jahe Bubuk (12020140)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2985,
    "Jahe Bubuk (12020140)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2986,
    "Jahe Bubuk (12020140)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2987,
    "Jahe Bubuk (12020140)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2988,
    "Jahe Bubuk (12020140)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2989,
    "Jahe Bubuk (12020140)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2990,
    "Jahe Bubuk (12020140)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [2991, "Jahe Kering (12020138)", "Salmonella (/25 g)"],
  [2992, "Jahe Kering (12020138)", "Jumlah Sampel - Salmonella"],
  [
    2993,
    "Jahe Kering (12020138)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2994,
    "Jahe Kering (12020138)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2995,
    "Jahe Kering (12020138)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2996,
    "Jahe Kering (12020138)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2997,
    "Jahe Kering (12020138)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    2998,
    "Jahe Kering (12020138)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    2999,
    "Jahe Kering (12020138)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3000,
    "Jahe Kering (12020138)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3001,
    "Jahe Kering (12020138)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3002,
    "Jahe Kering (12020138)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3003, "Jahe Kristalisasi (0402020609)", "Salmonella (/25 g)"],
  [
    3004,
    "Jahe Kristalisasi (0402020609)",
    "Jumlah Sampel - Salmonella",
  ],
  [3005, "Jahe Segar (12020137)", "Salmonella (/25 g)"],
  [3006, "Jahe Segar (12020137)", "Jumlah Sampel - Salmonella"],
  [
    3007,
    "Jahe Segar (12020137)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3008,
    "Jahe Segar (12020137)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3009,
    "Jahe Segar (12020137)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3010,
    "Jahe Segar (12020137)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3011,
    "Jahe Segar (12020137)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3012,
    "Jahe Segar (12020137)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3013,
    "Jahe Segar (12020137)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3014,
    "Jahe Segar (12020137)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3015,
    "Jahe Segar (12020137)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3016,
    "Jahe Segar (12020137)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3017, "Jamur Asin (0402020303)", "Salmonella (/25 g)"],
  [3018, "Jamur Asin (0402020303)", "Jumlah Sampel - Salmonella"],
  [3019, "Jamur Beku (0402020108)", "Salmonella (/25 g)"],
  [3020, "Jamur Beku (0402020108)", "Jumlah Sampel - Salmonella"],
  [
    3021,
    "Jamur Beku (0402020108)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    3022,
    "Jamur Beku (0402020108)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    3023,
    "Jamur Beku (0402020108)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    3024,
    "Jamur Beku (0402020108)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    3025,
    "Jamur Beku (0402020108)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    3026,
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain (0402020301)",
    "Salmonella (/25 g)",
  ],
  [
    3027,
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain (0402020301)",
    "Jumlah Sampel - Salmonella",
  ],
  [3028, "Jamur Fermentasi (0402020704)", "Salmonella (/25 g)"],
  [
    3029,
    "Jamur Fermentasi (0402020704)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3030,
    "Jantung Artichoke yang Diasinkan (0402020310)",
    "Salmonella (/25 g)",
  ],
  [
    3031,
    "Jantung Artichoke yang Diasinkan (0402020310)",
    "Jumlah Sampel - Salmonella",
  ],
  [3032, "Jintan Bubuk (12020142)", "Salmonella (/25 g)"],
  [3033, "Jintan Bubuk (12020142)", "Jumlah Sampel - Salmonella"],
  [
    3034,
    "Jintan Bubuk (12020142)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3035,
    "Jintan Bubuk (12020142)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3036,
    "Jintan Bubuk (12020142)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3037,
    "Jintan Bubuk (12020142)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3038,
    "Jintan Bubuk (12020142)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3039,
    "Jintan Bubuk (12020142)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3040,
    "Jintan Bubuk (12020142)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3041,
    "Jintan Bubuk (12020142)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3042,
    "Jintan Bubuk (12020142)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3043,
    "Jintan Bubuk (12020142)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3044, "Jintan Hitam (12020144)", "Salmonella (/25 g)"],
  [3045, "Jintan Hitam (12020144)", "Jumlah Sampel - Salmonella"],
  [
    3046,
    "Jintan Hitam (12020144)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3047,
    "Jintan Hitam (12020144)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3048,
    "Jintan Hitam (12020144)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3049,
    "Jintan Hitam (12020144)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3050,
    "Jintan Hitam (12020144)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3051,
    "Jintan Hitam (12020144)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3052,
    "Jintan Hitam (12020144)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3053,
    "Jintan Hitam (12020144)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3054,
    "Jintan Hitam (12020144)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3055,
    "Jintan Hitam (12020144)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3056, "Jintan Hitam Bubuk (12020145)", "Salmonella (/25 g)"],
  [
    3057,
    "Jintan Hitam Bubuk (12020145)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3058,
    "Jintan Hitam Bubuk (12020145)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3059,
    "Jintan Hitam Bubuk (12020145)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3060,
    "Jintan Hitam Bubuk (12020145)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3061,
    "Jintan Hitam Bubuk (12020145)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3062,
    "Jintan Hitam Bubuk (12020145)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3063,
    "Jintan Hitam Bubuk (12020145)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3064,
    "Jintan Hitam Bubuk (12020145)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3065,
    "Jintan Hitam Bubuk (12020145)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3066,
    "Jintan Hitam Bubuk (12020145)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3067,
    "Jintan Hitam Bubuk (12020145)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3068, "Jintan Manis (12020143)", "Salmonella (/25 g)"],
  [3069, "Jintan Manis (12020143)", "Jumlah Sampel - Salmonella"],
  [
    3070,
    "Jintan Manis (12020143)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3071,
    "Jintan Manis (12020143)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3072,
    "Jintan Manis (12020143)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3073,
    "Jintan Manis (12020143)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3074,
    "Jintan Manis (12020143)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3075,
    "Jintan Manis (12020143)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3076,
    "Jintan Manis (12020143)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3077,
    "Jintan Manis (12020143)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3078,
    "Jintan Manis (12020143)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3079,
    "Jintan Manis (12020143)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3080, "Jintan Putih Bubuk (12020147)", "Salmonella (/25 g)"],
  [
    3081,
    "Jintan Putih Bubuk (12020147)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3082,
    "Jintan Putih Bubuk (12020147)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3083,
    "Jintan Putih Bubuk (12020147)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3084,
    "Jintan Putih Bubuk (12020147)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3085,
    "Jintan Putih Bubuk (12020147)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3086,
    "Jintan Putih Bubuk (12020147)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3087,
    "Jintan Putih Bubuk (12020147)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3088,
    "Jintan Putih Bubuk (12020147)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3089,
    "Jintan Putih Bubuk (12020147)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3090,
    "Jintan Putih Bubuk (12020147)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3091,
    "Jintan Putih Bubuk (12020147)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3092, "Jintan Putih, Cumin (12020146)", "Salmonella (/25 g)"],
  [
    3093,
    "Jintan Putih, Cumin (12020146)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3094,
    "Jintan Putih, Cumin (12020146)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3095,
    "Jintan Putih, Cumin (12020146)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3096,
    "Jintan Putih, Cumin (12020146)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3097,
    "Jintan Putih, Cumin (12020146)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3098,
    "Jintan Putih, Cumin (12020146)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3099,
    "Jintan Putih, Cumin (12020146)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3100,
    "Jintan Putih, Cumin (12020146)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3101,
    "Jintan Putih, Cumin (12020146)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3102,
    "Jintan Putih, Cumin (12020146)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3103,
    "Jintan Putih, Cumin (12020146)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3104, "Jintan/Caraway (12020141)", "Salmonella (/25 g)"],
  [
    3105,
    "Jintan/Caraway (12020141)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3106,
    "Jintan/Caraway (12020141)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3107,
    "Jintan/Caraway (12020141)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3108,
    "Jintan/Caraway (12020141)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3109,
    "Jintan/Caraway (12020141)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3110,
    "Jintan/Caraway (12020141)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3111,
    "Jintan/Caraway (12020141)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3112,
    "Jintan/Caraway (12020141)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3113,
    "Jintan/Caraway (12020141)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3114,
    "Jintan/Caraway (12020141)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3115,
    "Jintan/Caraway (12020141)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3116, "Jipang Beras (150122 )", "Salmonella (/25 g)"],
  [3117, "Jipang Beras (150122 )", "Jumlah Sampel - Salmonella"],
  [
    3118,
    "Jipang Beras (150122 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3119,
    "Jipang Beras (150122 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3120,
    "Jipang Beras (150122 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3121,
    "Jipang Beras (150122 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3122,
    "Jipang Beras (150122 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3123,
    "Jipang Berbahan Dasar Kentang, Umbi, Serealia, Tepung atau Pati (150134)",
    "Salmonella (/25 g)",
  ],
  [
    3124,
    "Jipang Berbahan Dasar Kentang, Umbi, Serealia, Tepung atau Pati (150134)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3125,
    "Jipang Berbahan Dasar Kentang, Umbi, Serealia, Tepung atau Pati (150134)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3126,
    "Jipang Berbahan Dasar Kentang, Umbi, Serealia, Tepung atau Pati (150134)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3127,
    "Jipang Berbahan Dasar Kentang, Umbi, Serealia, Tepung atau Pati (150134)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3128,
    "Jipang Berbahan Dasar Kentang, Umbi, Serealia, Tepung atau Pati (150134)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3129,
    "Jipang Berbahan Dasar Kentang, Umbi, Serealia, Tepung atau Pati (150134)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [3130, "Jipang Jagung (150121)", "Salmonella (/25 g)"],
  [3131, "Jipang Jagung (150121)", "Jumlah Sampel - Salmonella"],
  [
    3132,
    "Jipang Jagung (150121)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3133,
    "Jipang Jagung (150121)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3134,
    "Jipang Jagung (150121)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3135,
    "Jipang Jagung (150121)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3136,
    "Jipang Jagung (150121)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [3137, "Jipang/Kipang Kacang (150210)", "Salmonella (/25 g)"],
  [
    3138,
    "Jipang/Kipang Kacang (150210)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3139,
    "Jongkong Kelapa Muda (060710)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3140,
    "Jongkong Kelapa Muda (060710)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3141,
    "Jongkong Kelapa Muda (060710)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3142,
    "Jongkong Kelapa Muda (060710)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3143,
    "Jongkong Kelapa Muda (060710)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3144, "Jongkong Kelapa Muda (060710)", "Salmonella (/25 g)"],
  [
    3145,
    "Jongkong Kelapa Muda (060710)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3146,
    "Jongkong Kelapa Muda (060710)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3147,
    "Jongkong Kelapa Muda (060710)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3148,
    "Jongkong Kelapa Muda (060710)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3149,
    "Jongkong Kelapa Muda (060710)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3150,
    "Jongkong Kelapa Muda (060710)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3151,
    "Juadah Kering/Mayang Papan (060713)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3152,
    "Juadah Kering/Mayang Papan (060713)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3153,
    "Juadah Kering/Mayang Papan (060713)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3154,
    "Juadah Kering/Mayang Papan (060713)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3155,
    "Juadah Kering/Mayang Papan (060713)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3156,
    "Juadah Kering/Mayang Papan (060713)",
    "Salmonella (/25 g)",
  ],
  [
    3157,
    "Juadah Kering/Mayang Papan (060713)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3158,
    "Juadah Kering/Mayang Papan (060713)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3159,
    "Juadah Kering/Mayang Papan (060713)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3160,
    "Juadah Kering/Mayang Papan (060713)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3161,
    "Juadah Kering/Mayang Papan (060713)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3162,
    "Juadah Kering/Mayang Papan (060713)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3163,
    "Junior Food Mi (130207)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3164,
    "Junior Food Mi (130207)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3165,
    "Junior Food Mi (130207)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3166,
    "Junior Food Mi (130207)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3167,
    "Junior Food Mi (130207)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3168,
    "Junior Food Mi (130207)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    3169,
    "Junior Food Mi (130207)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    3170,
    "Junior Food Mi (130207)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    3171,
    "Junior Food Mi (130207)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    3172,
    "Junior Food Mi (130207)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [3173, "Junior Food Mi (130207)", "Salmonella (koloni/25 g)"],
  [3174, "Junior Food Mi (130207)", "Jumlah Sampel - Salmonella"],
  [
    3175,
    "Junior Food Mi (130207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    3176,
    "Junior Food Mi (130207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    3177,
    "Junior Food Mi (130207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    3178,
    "Junior Food Mi (130207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    3179,
    "Junior Food Mi (130207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [3180, "Kacang Atom Lainnya (150216)", "Salmonella (/25 g)"],
  [
    3181,
    "Kacang Atom Lainnya (150216)",
    "Jumlah Sampel - Salmonella",
  ],
  [3182, "Kacang Atom/Sukro (150207 )", "Salmonella (/25 g)"],
  [
    3183,
    "Kacang Atom/Sukro (150207 )",
    "Jumlah Sampel - Salmonella",
  ],
  [3184, "Kacang Bali (150203)", "Salmonella (/25 g)"],
  [3185, "Kacang Bali (150203)", "Jumlah Sampel - Salmonella"],
  [
    3186,
    "Kacang Bawang / Kacang Tojin (150202)",
    "Salmonella (/25 g)",
  ],
  [
    3187,
    "Kacang Bawang / Kacang Tojin (150202)",
    "Jumlah Sampel - Salmonella",
  ],
  [3188, "Kacang Bersalut (150220)", "Salmonella (/25 g)"],
  [
    3189,
    "Kacang Bersalut (150220)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [3190, "Kacang Bogor (150213 )", "Salmonella (/25 g)"],
  [3191, "Kacang Bogor (150213 )", "Jumlah Sampel - Salmonella"],
  [
    3192,
    "Kacang Garing/Kacang Kulit (150201 )",
    "Salmonella (/25 g)",
  ],
  [
    3193,
    "Kacang Garing/Kacang Kulit (150201 )",
    "Jumlah Sampel - Salmonella",
  ],
  [3194, "Kacang Goreng (150221)", "Salmonella (/25 g)"],
  [
    3195,
    "Kacang Goreng (150221)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [3196, "Kacang Goreng Lainnya (150218)", "Salmonella (/25 g)"],
  [
    3197,
    "Kacang Goreng Lainnya (150218)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [3198, "Kacang Goyang (150209)", "Salmonella (/25 g)"],
  [3199, "Kacang Goyang (150209)", "Jumlah Sampel - Salmonella"],
  [3200, "Kacang Kapri (150211 )", "Salmonella (/25 g)"],
  [3201, "Kacang Kapri (150211 )", "Jumlah Sampel - Salmonella"],
  [3202, "Kacang Kapri Beku (0402020103)", "Salmonella (/25 g)"],
  [
    3203,
    "Kacang Kapri Beku (0402020103)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3204,
    "Kacang Kapri Beku (0402020103)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    3205,
    "Kacang Kapri Beku (0402020103)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    3206,
    "Kacang Kapri Beku (0402020103)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    3207,
    "Kacang Kapri Beku (0402020103)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    3208,
    "Kacang Kapri Beku (0402020103)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [3209, "Kacang Koro (150212 )", "Salmonella (/25 g)"],
  [3210, "Kacang Koro (150212 )", "Jumlah Sampel - Salmonella"],
  [3211, "Kacang Mede (150205)", "Salmonella (/25 g)"],
  [3212, "Kacang Mede (150205)", "Jumlah Sampel - Salmonella"],
  [3213, "Kacang Panggang (150204 )", "Salmonella (/25 g)"],
  [
    3214,
    "Kacang Panggang (150204 )",
    "Jumlah Sampel - Salmonella",
  ],
  [3215, "Kacang Panggang Lainnya (150219)", "Salmonella (/25 g)"],
  [
    3216,
    "Kacang Panggang Lainnya (150219)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [3217, "Kacang Pistacio (150214 )", "Salmonella (/25 g)"],
  [
    3218,
    "Kacang Pistacio (150214 )",
    "Jumlah Sampel - Salmonella",
  ],
  [3219, "Kacang Sangrai (150217)", "Salmonella (/25 g)"],
  [
    3220,
    "Kacang Sangrai (150217)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [3221, "Kacang Telur (150208 )", "Salmonella (/25 g)"],
  [3222, "Kacang Telur (150208 )", "Jumlah Sampel - Salmonella"],
  [3223, "Kakao Bubuk (05010101)", "Salmonella (/25 g)"],
  [3224, "Kakao Bubuk (05010101)", "Jumlah Sampel - Salmonella"],
  [
    3225,
    "Kakao Bubuk Sangat Halus (Cocoa Fineness) (05010106)",
    "Salmonella (/25 g)",
  ],
  [
    3226,
    "Kakao Bubuk Sangat Halus (Cocoa Fineness) (05010106)",
    "Salmonella (/25 g)",
  ],
  [
    3227,
    "Kakao Bubuk Sangat Halus (Cocoa Fineness) (05010106)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3228,
    "Kakao Bubuk Sangat Halus (Cocoa Fineness) (05010106)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3229,
    "Kakao Bubuk Untuk Sarapan (Breakfast Cocoa) (05010102)",
    "Salmonella (/25 g)",
  ],
  [
    3230,
    "Kakao Bubuk Untuk Sarapan (Breakfast Cocoa) (05010102)",
    "Salmonella (/25 g)",
  ],
  [
    3231,
    "Kakao Bubuk Untuk Sarapan (Breakfast Cocoa) (05010102)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3232,
    "Kakao Bubuk Untuk Sarapan (Breakfast Cocoa) (05010102)",
    "Jumlah Sampel - Salmonella",
  ],
  [3233, "Kakao Instan (05010118)", "Salmonella (/25 g)"],
  [3234, "Kakao Instan (05010118)", "Jumlah Sampel - Salmonella"],
  [
    3235,
    "Kakao Massa (Cocoa liquor) (05010120)",
    "Salmonella (/25 g)",
  ],
  [
    3236,
    "Kakao Massa (Cocoa liquor) (05010120)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3237,
    "Kamaboko (0902040106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3238,
    "Kamaboko (0902040106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3239,
    "Kamaboko (0902040106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3240,
    "Kamaboko (0902040106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3241,
    "Kamaboko (0902040106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [3242, "Kapulaga (12020148)", "Salmonella (/25 g)"],
  [3243, "Kapulaga (12020148)", "Jumlah Sampel - Salmonella"],
  [
    3244,
    "Kapulaga (12020148)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3245,
    "Kapulaga (12020148)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3246,
    "Kapulaga (12020148)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3247,
    "Kapulaga (12020148)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3248,
    "Kapulaga (12020148)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3249,
    "Kapulaga (12020148)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3250,
    "Kapulaga (12020148)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3251,
    "Kapulaga (12020148)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3252,
    "Kapulaga (12020148)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3253,
    "Kapulaga (12020148)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3254,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Salmonella (/25 g)",
  ],
  [
    3255,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3256,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3257,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3258,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3259,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3260,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3261,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3262,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3263,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3264,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3265,
    "Kapulaga (Cardamom) Amomum (12020151)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3266,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Salmonella (/25 g)",
  ],
  [
    3267,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3268,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3269,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3270,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3271,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3272,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3273,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3274,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3275,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3276,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3277,
    "Kapulaga (Cardamom) Amomum Bubuk (12020154)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3278, "Kapulaga Bubuk (12020153)", "Salmonella (/25 g)"],
  [
    3279,
    "Kapulaga Bubuk (12020153)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3280,
    "Kapulaga Bubuk (12020153)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3281,
    "Kapulaga Bubuk (12020153)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3282,
    "Kapulaga Bubuk (12020153)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3283,
    "Kapulaga Bubuk (12020153)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3284,
    "Kapulaga Bubuk (12020153)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3285,
    "Kapulaga Bubuk (12020153)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3286,
    "Kapulaga Bubuk (12020153)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3287,
    "Kapulaga Bubuk (12020153)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3288,
    "Kapulaga Bubuk (12020153)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3289,
    "Kapulaga Bubuk (12020153)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3290, "Kapulaga Lokal (12020150)", "Salmonella (/25 g)"],
  [
    3291,
    "Kapulaga Lokal (12020150)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3292,
    "Kapulaga Lokal (12020150)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3293,
    "Kapulaga Lokal (12020150)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3294,
    "Kapulaga Lokal (12020150)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3295,
    "Kapulaga Lokal (12020150)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3296,
    "Kapulaga Lokal (12020150)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3297,
    "Kapulaga Lokal (12020150)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3298,
    "Kapulaga Lokal (12020150)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3299,
    "Kapulaga Lokal (12020150)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3300,
    "Kapulaga Lokal (12020150)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3301,
    "Kapulaga Lokal (12020150)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3302, "Kastengel (07020135)", "Salmonella (/25 g)"],
  [3303, "Kastengel (07020135)", "Jumlah Sampel - Salmonella"],
  [
    3304,
    "Kastengel (07020135)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3305,
    "Kastengel (07020135)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3306,
    "Kastengel (07020135)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3307,
    "Kastengel (07020135)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3308,
    "Kastengel (07020135)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3309,
    "Katrisolo (060729)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3310,
    "Katrisolo (060729)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3311,
    "Katrisolo (060729)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3312,
    "Katrisolo (060729)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3313,
    "Katrisolo (060729)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3314, "Katrisolo (060729)", "Salmonella (/25 g)"],
  [3315, "Katrisolo (060729)", "Jumlah Sampel - Salmonella"],
  [
    3316,
    "Katrisolo (060729)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3317,
    "Katrisolo (060729)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3318,
    "Katrisolo (060729)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3319,
    "Katrisolo (060729)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3320,
    "Katrisolo (060729)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [3321, "Kayu Manis (12020155)", "Salmonella (/25 g)"],
  [3322, "Kayu Manis (12020155)", "Jumlah Sampel - Salmonella"],
  [
    3323,
    "Kayu Manis (12020155)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3324,
    "Kayu Manis (12020155)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3325,
    "Kayu Manis (12020155)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3326,
    "Kayu Manis (12020155)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3327,
    "Kayu Manis (12020155)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3328,
    "Kayu Manis (12020155)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3329,
    "Kayu Manis (12020155)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3330,
    "Kayu Manis (12020155)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3331,
    "Kayu Manis (12020155)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3332,
    "Kayu Manis (12020155)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3333, "Kayu Manis Bubuk (12020156)", "Salmonella (/25 g)"],
  [
    3334,
    "Kayu Manis Bubuk (12020156)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3335,
    "Kayu Manis Bubuk (12020156)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3336,
    "Kayu Manis Bubuk (12020156)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3337,
    "Kayu Manis Bubuk (12020156)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3338,
    "Kayu Manis Bubuk (12020156)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3339,
    "Kayu Manis Bubuk (12020156)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3340,
    "Kayu Manis Bubuk (12020156)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3341,
    "Kayu Manis Bubuk (12020156)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3342,
    "Kayu Manis Bubuk (12020156)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3343,
    "Kayu Manis Bubuk (12020156)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3344,
    "Kayu Manis Bubuk (12020156)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3345, "Kecap Ikan (12060401)", "Salmonella (/25 g)"],
  [3346, "Kecap Ikan (12060401)", "Salmonella (/25 g)"],
  [3347, "Kecap Ikan (12060401)", "Jumlah Sampel - Salmonella"],
  [3348, "Kecap Ikan (12060401)", "Jumlah Sampel - Salmonella"],
  [
    3349,
    "Kecap Inggeris, Saus Worchester (12060218)",
    "Salmonella (/25 g)",
  ],
  [
    3350,
    "Kecap Inggeris, Saus Worchester (12060218)",
    "Salmonella (/25 g)",
  ],
  [
    3351,
    "Kecap Inggeris, Saus Worchester (12060218)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3352,
    "Kecap Inggeris, Saus Worchester (12060218)",
    "Jumlah Sampel - Salmonella",
  ],
  [3353, "Kecimpring (150114)", "Salmonella (/25 g)"],
  [3354, "Kecimpring (150114)", "Jumlah Sampel - Salmonella"],
  [
    3355,
    "Kecimpring (150114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3356,
    "Kecimpring (150114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3357,
    "Kecimpring (150114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3358,
    "Kecimpring (150114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3359,
    "Kecimpring (150114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3360,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Salmonella (/25 g)",
  ],
  [
    3361,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3362,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3363,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3364,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3365,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3366,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3367,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3368,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3369,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3370,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3371,
    "Kecombrang/Sambuang/Kincong/Honje (12020176)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3372, "Keecho/Heecho (08030317)", "Salmonella (koloni/25 ml)"],
  [3373, "Keecho/Heecho (08030317)", "Jumlah Sampel - Salmonella"],
  [
    3374,
    "Keecho/Heecho (08030317)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    3375,
    "Keecho/Heecho (08030317)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    3376,
    "Keecho/Heecho (08030317)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    3377,
    "Keecho/Heecho (08030317)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    3378,
    "Keecho/Heecho (08030317)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    3379,
    "Keecho/Heecho (08030317)",
    "Listeria monocytogenes (/25 g)",
  ],
  [
    3380,
    "Keecho/Heecho (08030317)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [3381, "Kefir (010201A9)", "Salmonella (/25 ml)"],
  [3382, "Kefir (010201A9)", "Jumlah Sampel - Salmonella"],
  [
    3383,
    "Kefir (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010207)",
    "Salmonella (negatif/25 g)",
  ],
  [
    3384,
    "Kefir (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010207)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    3385,
    "Kefir (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010107)",
    "Salmonella (/25 g)",
  ],
  [
    3386,
    "Kefir (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010107)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [3387, "Keik (Cake) (07020102)", "Salmonella (/25 g)"],
  [3388, "Keik (Cake) (07020102)", "Jumlah Sampel - Salmonella"],
  [
    3389,
    "Keik (Cake) (07020102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3390,
    "Keik (Cake) (07020102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3391,
    "Keik (Cake) (07020102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3392,
    "Keik (Cake) (07020102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3393,
    "Keik (Cake) (07020102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3394,
    "Keik (Cake), Kukis (Cookies) dan Pai (Pie) (07020101)",
    "Salmonella (/25 g)",
  ],
  [
    3395,
    "Keik (Cake), Kukis (Cookies) dan Pai (Pie) (07020101)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3396,
    "Keik (Cake), Kukis (Cookies) dan Pai (Pie) (07020101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3397,
    "Keik (Cake), Kukis (Cookies) dan Pai (Pie) (07020101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3398,
    "Keik (Cake), Kukis (Cookies) dan Pai (Pie) (07020101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3399,
    "Keik (Cake), Kukis (Cookies) dan Pai (Pie) (07020101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3400,
    "Keik (Cake), Kukis (Cookies) dan Pai (Pie) (07020101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3401,
    "Keik Keju (Cheese Cake) (07020104)",
    "Salmonella (/25 g)",
  ],
  [
    3402,
    "Keik Keju (Cheese Cake) (07020104)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3403,
    "Keik Keju (Cheese Cake) (07020104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3404,
    "Keik Keju (Cheese Cake) (07020104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3405,
    "Keik Keju (Cheese Cake) (07020104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3406,
    "Keik Keju (Cheese Cake) (07020104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3407,
    "Keik Keju (Cheese Cake) (07020104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3408,
    "Keik Mentega (Butter Cake) (07020103)",
    "Salmonella (/25 g)",
  ],
  [
    3409,
    "Keik Mentega (Butter Cake) (07020103)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3410,
    "Keik Mentega (Butter Cake) (07020103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3411,
    "Keik Mentega (Butter Cake) (07020103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3412,
    "Keik Mentega (Butter Cake) (07020103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3413,
    "Keik Mentega (Butter Cake) (07020103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3414,
    "Keik Mentega (Butter Cake) (07020103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3415,
    "Keik Pound (Pound Cake Atau Quatre Quarts) (07020105)",
    "Salmonella (/25 g)",
  ],
  [
    3416,
    "Keik Pound (Pound Cake Atau Quatre Quarts) (07020105)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3417,
    "Keik Pound (Pound Cake Atau Quatre Quarts) (07020105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3418,
    "Keik Pound (Pound Cake Atau Quatre Quarts) (07020105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3419,
    "Keik Pound (Pound Cake Atau Quatre Quarts) (07020105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3420,
    "Keik Pound (Pound Cake Atau Quatre Quarts) (07020105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3421,
    "Keik Pound (Pound Cake Atau Quatre Quarts) (07020105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3422,
    "Keju Amerika (American Cheese) (0106040102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3423,
    "Keju Amerika (American Cheese) (0106040102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3424,
    "Keju Amerika (American Cheese) (0106040102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3425,
    "Keju Amerika (American Cheese) (0106040102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3426,
    "Keju Amerika (American Cheese) (0106040102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3427,
    "Keju Amerika (American Cheese) (0106040102)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3428,
    "Keju Amerika (American Cheese) (0106040102)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3429,
    "Keju Amerika (American Cheese) (0106040102)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3430,
    "Keju Amerika (American Cheese) (0106040102)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3431,
    "Keju Amerika (American Cheese) (0106040102)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3432,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3433,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3434,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3435,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3436,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3437,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3438,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3439,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3440,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3441,
    "Keju Bata (Brick Cheese) (0106020102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3442,
    "Keju Bath (0106020111)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3443,
    "Keju Bath (0106020111)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3444,
    "Keju Bath (0106020111)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3445,
    "Keju Bath (0106020111)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3446,
    "Keju Bath (0106020111)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3447,
    "Keju Bath (0106020111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3448,
    "Keju Bath (0106020111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3449,
    "Keju Bath (0106020111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3450,
    "Keju Bath (0106020111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3451,
    "Keju Bath (0106020111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3452,
    "Keju Bath (010602A5)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3453,
    "Keju Bath (010602A5)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3454,
    "Keju Bath (010602A5)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3455,
    "Keju Bath (010602A5)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3456,
    "Keju Bath (010602A5)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3457,
    "Keju Bath (010602A5)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3458,
    "Keju Bath (010602A5)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3459,
    "Keju Bath (010602A5)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3460,
    "Keju Bath (010602A5)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3461,
    "Keju Bath (010602A5)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3462,
    "Keju Biru (Blue cheese) (0106020101)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3463,
    "Keju Biru (Blue cheese) (0106020101)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3464,
    "Keju Biru (Blue cheese) (0106020101)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3465,
    "Keju Biru (Blue cheese) (0106020101)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3466,
    "Keju Biru (Blue cheese) (0106020101)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3467,
    "Keju Biru (Blue cheese) (0106020101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3468,
    "Keju Biru (Blue cheese) (0106020101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3469,
    "Keju Biru (Blue cheese) (0106020101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3470,
    "Keju Biru (Blue cheese) (0106020101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3471,
    "Keju Biru (Blue cheese) (0106020101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3472,
    "Keju Bocconcini (01060104)",
    "Listeria monocytogenes (koloni/g)",
  ],
  [
    3473,
    "Keju Bocconcini (01060104)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    3474,
    "Keju Bocconcini (01060104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3475,
    "Keju Bocconcini (01060104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3476,
    "Keju Bocconcini (01060104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3477,
    "Keju Bocconcini (01060104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3478,
    "Keju Bocconcini (01060104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3479, "Keju Bocconcini (01060104)", "Salmonella (/25 g)"],
  [
    3480,
    "Keju Bocconcini (01060104)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3481,
    "Keju Bondard (0106020112)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3482,
    "Keju Bondard (0106020112)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3483,
    "Keju Bondard (0106020112)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3484,
    "Keju Bondard (0106020112)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3485,
    "Keju Bondard (0106020112)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3486,
    "Keju Bondard (0106020112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3487,
    "Keju Bondard (0106020112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3488,
    "Keju Bondard (0106020112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3489,
    "Keju Bondard (0106020112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3490,
    "Keju Bondard (0106020112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3491,
    "Keju Bondard (010602A6)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3492,
    "Keju Bondard (010602A6)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3493,
    "Keju Bondard (010602A6)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3494,
    "Keju Bondard (010602A6)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3495,
    "Keju Bondard (010602A6)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3496,
    "Keju Bondard (010602A6)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3497,
    "Keju Bondard (010602A6)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3498,
    "Keju Bondard (010602A6)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3499,
    "Keju Bondard (010602A6)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3500,
    "Keju Bondard (010602A6)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3501,
    "Keju Bougon (0106020113)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3502,
    "Keju Bougon (0106020113)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3503,
    "Keju Bougon (0106020113)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3504,
    "Keju Bougon (0106020113)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3505,
    "Keju Bougon (0106020113)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3506,
    "Keju Bougon (0106020113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3507,
    "Keju Bougon (0106020113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3508,
    "Keju Bougon (0106020113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3509,
    "Keju Bougon (0106020113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3510,
    "Keju Bougon (0106020113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3511,
    "Keju Bougon (010602A7)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3512,
    "Keju Bougon (010602A7)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3513,
    "Keju Bougon (010602A7)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3514,
    "Keju Bougon (010602A7)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3515,
    "Keju Bougon (010602A7)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3516,
    "Keju Bougon (010602A7)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3517,
    "Keju Bougon (010602A7)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3518,
    "Keju Bougon (010602A7)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3519,
    "Keju Bougon (010602A7)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3520,
    "Keju Bougon (010602A7)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3521,
    "Keju Bouquet des moines (0106020114)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3522,
    "Keju Bouquet des moines (0106020114)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3523,
    "Keju Bouquet des moines (0106020114)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3524,
    "Keju Bouquet des moines (0106020114)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3525,
    "Keju Bouquet des moines (0106020114)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3526,
    "Keju Bouquet des moines (0106020114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3527,
    "Keju Bouquet des moines (0106020114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3528,
    "Keju Bouquet des moines (0106020114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3529,
    "Keju Bouquet des moines (0106020114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3530,
    "Keju Bouquet des moines (0106020114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3531,
    "Keju Bouquet des moines (010602A8)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3532,
    "Keju Bouquet des moines (010602A8)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3533,
    "Keju Bouquet des moines (010602A8)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3534,
    "Keju Bouquet des moines (010602A8)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3535,
    "Keju Bouquet des moines (010602A8)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3536,
    "Keju Bouquet des moines (010602A8)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3537,
    "Keju Bouquet des moines (010602A8)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3538,
    "Keju Bouquet des moines (010602A8)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3539,
    "Keju Bouquet des moines (010602A8)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3540,
    "Keju Bouquet des moines (010602A8)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3541,
    "Keju Boursault (010602A9)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3542,
    "Keju Boursault (010602A9)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3543,
    "Keju Boursault (010602A9)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3544,
    "Keju Boursault (010602A9)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3545,
    "Keju Boursault (010602A9)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3546,
    "Keju Boursault (010602A9)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3547,
    "Keju Boursault (010602A9)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3548,
    "Keju Boursault (010602A9)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3549,
    "Keju Boursault (010602A9)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3550,
    "Keju Boursault (010602A9)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3551,
    "Keju Brie (0106020105)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3552,
    "Keju Brie (0106020105)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3553,
    "Keju Brie (0106020105)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3554,
    "Keju Brie (0106020105)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3555,
    "Keju Brie (0106020105)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3556,
    "Keju Brie (0106020105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3557,
    "Keju Brie (0106020105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3558,
    "Keju Brie (0106020105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3559,
    "Keju Brie (0106020105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3560,
    "Keju Brie (0106020105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3561,
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju) (01060203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3562,
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju) (01060203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3563,
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju) (01060203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3564,
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju) (01060203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3565,
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju) (01060203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3566,
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju) (01060203)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3567,
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju) (01060203)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3568,
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju) (01060203)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3569,
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju) (01060203)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3570,
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju) (01060203)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3571,
    "Keju Camembert (0106020110)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3572,
    "Keju Camembert (0106020110)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3573,
    "Keju Camembert (0106020110)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3574,
    "Keju Camembert (0106020110)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3575,
    "Keju Camembert (0106020110)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3576,
    "Keju Camembert (0106020110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3577,
    "Keju Camembert (0106020110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3578,
    "Keju Camembert (0106020110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3579,
    "Keju Camembert (0106020110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3580,
    "Keju Camembert (0106020110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3581,
    "Keju Camembert (010602A4)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3582,
    "Keju Camembert (010602A4)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3583,
    "Keju Camembert (010602A4)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3584,
    "Keju Camembert (010602A4)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3585,
    "Keju Camembert (010602A4)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3586,
    "Keju Camembert (010602A4)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3587,
    "Keju Camembert (010602A4)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3588,
    "Keju Camembert (010602A4)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3589,
    "Keju Camembert (010602A4)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3590,
    "Keju Camembert (010602A4)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3591,
    "Keju Cheddar (0106020109)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3592,
    "Keju Cheddar (0106020109)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3593,
    "Keju Cheddar (0106020109)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3594,
    "Keju Cheddar (0106020109)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3595,
    "Keju Cheddar (0106020109)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3596,
    "Keju Cheddar (0106020109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3597,
    "Keju Cheddar (0106020109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3598,
    "Keju Cheddar (0106020109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3599,
    "Keju Cheddar (0106020109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3600,
    "Keju Cheddar (0106020109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3601,
    "Keju Cheddar (010602A1)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3602,
    "Keju Cheddar (010602A1)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3603,
    "Keju Cheddar (010602A1)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3604,
    "Keju Cheddar (010602A1)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3605,
    "Keju Cheddar (010602A1)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3606,
    "Keju Cheddar (010602A1)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3607,
    "Keju Cheddar (010602A1)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3608,
    "Keju Cheddar (010602A1)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3609,
    "Keju Cheddar (010602A1)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3610,
    "Keju Cheddar (010602A1)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3611,
    "Keju Cheddar Olahan (010604A1)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3612,
    "Keju Cheddar Olahan (010604A1)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3613,
    "Keju Cheddar Olahan (010604A1)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3614,
    "Keju Cheddar Olahan (010604A1)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3615,
    "Keju Cheddar Olahan (010604A1)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3616,
    "Keju Cheddar Olahan (010604A1)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3617,
    "Keju Cheddar Olahan (010604A1)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3618,
    "Keju Cheddar Olahan (010604A1)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3619,
    "Keju Cheddar Olahan (010604A1)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3620,
    "Keju Cheddar Olahan (010604A1)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3621,
    "Keju Cheddar Rendah Sodium (010602A2)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3622,
    "Keju Cheddar Rendah Sodium (010602A2)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3623,
    "Keju Cheddar Rendah Sodium (010602A2)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3624,
    "Keju Cheddar Rendah Sodium (010602A2)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3625,
    "Keju Cheddar Rendah Sodium (010602A2)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3626,
    "Keju Cheddar Rendah Sodium (010602A2)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3627,
    "Keju Cheddar Rendah Sodium (010602A2)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3628,
    "Keju Cheddar Rendah Sodium (010602A2)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3629,
    "Keju Cheddar Rendah Sodium (010602A2)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3630,
    "Keju Cheddar Rendah Sodium (010602A2)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3631,
    "Keju Chevre Log atau Keju Buchette (010602B0)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3632,
    "Keju Chevre Log atau Keju Buchette (010602B0)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3633,
    "Keju Chevre Log atau Keju Buchette (010602B0)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3634,
    "Keju Chevre Log atau Keju Buchette (010602B0)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3635,
    "Keju Chevre Log atau Keju Buchette (010602B0)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3636,
    "Keju Chevre Log atau Keju Buchette (010602B0)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3637,
    "Keju Chevre Log atau Keju Buchette (010602B0)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3638,
    "Keju Chevre Log atau Keju Buchette (010602B0)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3639,
    "Keju Chevre Log atau Keju Buchette (010602B0)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3640,
    "Keju Chevre Log atau Keju Buchette (010602B0)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3641,
    "Keju Club Luncheon (0106040101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3642,
    "Keju Club Luncheon (0106040101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3643,
    "Keju Club Luncheon (0106040101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3644,
    "Keju Club Luncheon (0106040101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3645,
    "Keju Club Luncheon (0106040101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3646,
    "Keju Club Luncheon (0106040101)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3647,
    "Keju Club Luncheon (0106040101)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3648,
    "Keju Club Luncheon (0106040101)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3649,
    "Keju Club Luncheon (0106040101)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3650,
    "Keju Club Luncheon (0106040101)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3651,
    "Keju Coach Farm (010602B1)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3652,
    "Keju Coach Farm (010602B1)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3653,
    "Keju Coach Farm (010602B1)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3654,
    "Keju Coach Farm (010602B1)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3655,
    "Keju Coach Farm (010602B1)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3656,
    "Keju Coach Farm (010602B1)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3657,
    "Keju Coach Farm (010602B1)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3658,
    "Keju Coach Farm (010602B1)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3659,
    "Keju Coach Farm (010602B1)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3660,
    "Keju Coach Farm (010602B1)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3661,
    "Keju Colby (010602B5)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3662,
    "Keju Colby (010602B5)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3663,
    "Keju Colby (010602B5)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3664,
    "Keju Colby (010602B5)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3665,
    "Keju Colby (010602B5)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3666,
    "Keju Colby (010602B5)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3667,
    "Keju Colby (010602B5)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3668,
    "Keju Colby (010602B5)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3669,
    "Keju Colby (010602B5)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3670,
    "Keju Colby (010602B5)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3671,
    "Keju Cold Pack (0106040103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3672,
    "Keju Cold Pack (0106040103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3673,
    "Keju Cold Pack (0106040103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3674,
    "Keju Cold Pack (0106040103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3675,
    "Keju Cold Pack (0106040103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3676,
    "Keju Cold Pack (0106040103)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3677,
    "Keju Cold Pack (0106040103)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3678,
    "Keju Cold Pack (0106040103)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3679,
    "Keju Cold Pack (0106040103)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3680,
    "Keju Cold Pack (0106040103)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3681,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Listeria monocytogenes (koloni/g)",
  ],
  [
    3682,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    3683,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3684,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3685,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3686,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3687,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3688,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Salmonella (/25 g)",
  ],
  [
    3689,
    "Keju Cottage (Cottage Cheese) (01060101)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3690,
    "Keju Edam (010602A3)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3691,
    "Keju Edam (010602A3)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3692,
    "Keju Edam (010602A3)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3693,
    "Keju Edam (010602A3)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3694,
    "Keju Edam (010602A3)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3695,
    "Keju Edam (010602A3)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3696,
    "Keju Edam (010602A3)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3697,
    "Keju Edam (010602A3)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3698,
    "Keju Edam (010602A3)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3699,
    "Keju Edam (010602A3)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3700,
    "Keju Gouda (0106020103)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3701,
    "Keju Gouda (0106020103)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3702,
    "Keju Gouda (0106020103)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3703,
    "Keju Gouda (0106020103)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3704,
    "Keju Gouda (0106020103)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3705,
    "Keju Gouda (0106020103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3706,
    "Keju Gouda (0106020103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3707,
    "Keju Gouda (0106020103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3708,
    "Keju Gouda (0106020103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3709,
    "Keju Gouda (0106020103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3710,
    "Keju Gubbeen (010602B4)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3711,
    "Keju Gubbeen (010602B4)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3712,
    "Keju Gubbeen (010602B4)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3713,
    "Keju Gubbeen (010602B4)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3714,
    "Keju Gubbeen (010602B4)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3715,
    "Keju Gubbeen (010602B4)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3716,
    "Keju Gubbeen (010602B4)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3717,
    "Keju Gubbeen (010602B4)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3718,
    "Keju Gubbeen (010602B4)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3719,
    "Keju Gubbeen (010602B4)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3720,
    "Keju Haloumy (010607)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3721,
    "Keju Haloumy (010607)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3722,
    "Keju Haloumy (010607)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3723,
    "Keju Haloumy (010607)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3724,
    "Keju Haloumy (010607)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3725,
    "Keju Havarti (0106020104)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3726,
    "Keju Havarti (0106020104)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3727,
    "Keju Havarti (0106020104)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3728,
    "Keju Havarti (0106020104)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3729,
    "Keju Havarti (0106020104)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3730,
    "Keju Havarti (0106020104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3731,
    "Keju Havarti (0106020104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3732,
    "Keju Havarti (0106020104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3733,
    "Keju Havarti (0106020104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3734,
    "Keju Havarti (0106020104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3735,
    "Keju Krim (Cream Cheese) (01060102)",
    "Listeria monocytogenes (koloni/g)",
  ],
  [
    3736,
    "Keju Krim (Cream Cheese) (01060102)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    3737,
    "Keju Krim (Cream Cheese) (01060102)",
    "Staphylococcus aureus (koloni/g) (Hanya untuk yang dibuat dari susu segar)",
    "\x{2264}10000",
    "<1000",
  ],
  [
    3738,
    "Keju Krim (Cream Cheese) (01060102)",
    "Staphylococcus aureus (koloni/g) (Hanya untuk yang dibuat dari susu segar)",
    "\x{2264}10000",
    "<1000",
  ],
  [
    3739,
    "Keju Krim (Cream Cheese) (01060102)",
    "Staphylococcus aureus (koloni/g) (Hanya untuk yang dibuat dari susu segar)",
    "\x{2264}10000",
    "<1000",
  ],
  [
    3740,
    "Keju Krim (Cream Cheese) (01060102)",
    "Staphylococcus aureus (koloni/g) (Hanya untuk yang dibuat dari susu segar)",
    "\x{2264}10000",
    "<1000",
  ],
  [
    3741,
    "Keju Krim (Cream Cheese) (01060102)",
    "Staphylococcus aureus (koloni/g) (Hanya untuk yang dibuat dari susu segar)",
    "\x{2264}10000",
    "<1000",
  ],
  [
    3742,
    "Keju Krim (Cream Cheese) (01060102)",
    "Salmonella (/25 g) (Hanya untuk yang dibuat dari susu segar)",
  ],
  [
    3743,
    "Keju Krim (Cream Cheese) (01060102)",
    "Jumlah Sampel - Salmonella (Hanya untuk yang dibuat dari susu segar)",
    "",
    "\x{2265}5",
  ],
  [
    3744,
    "Keju Mozzarella (01060103)",
    "Listeria monocytogenes (koloni/g)",
  ],
  [
    3745,
    "Keju Mozzarella (01060103)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    3746,
    "Keju Mozzarella (01060103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3747,
    "Keju Mozzarella (01060103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3748,
    "Keju Mozzarella (01060103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3749,
    "Keju Mozzarella (01060103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3750,
    "Keju Mozzarella (01060103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3751, "Keju Mozzarella (01060103)", "Salmonella (/25 g)"],
  [
    3752,
    "Keju Mozzarella (01060103)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3753,
    "Keju Neufchatel dan Sayuran Untuk Olesan (0106040201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3754,
    "Keju Neufchatel dan Sayuran Untuk Olesan (0106040201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3755,
    "Keju Neufchatel dan Sayuran Untuk Olesan (0106040201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3756,
    "Keju Neufchatel dan Sayuran Untuk Olesan (0106040201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3757,
    "Keju Neufchatel dan Sayuran Untuk Olesan (0106040201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3758,
    "Keju Neufchatel dan Sayuran Untuk Olesan (0106040201)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3759,
    "Keju Neufchatel dan Sayuran Untuk Olesan (0106040201)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3760,
    "Keju Neufchatel dan Sayuran Untuk Olesan (0106040201)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3761,
    "Keju Neufchatel dan Sayuran Untuk Olesan (0106040201)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3762,
    "Keju Neufchatel dan Sayuran Untuk Olesan (0106040201)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3763,
    "Keju Olahan (010604A0)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3764,
    "Keju Olahan (010604A0)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3765,
    "Keju Olahan (010604A0)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3766,
    "Keju Olahan (010604A0)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3767,
    "Keju Olahan (010604A0)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3768,
    "Keju Olahan (010604A0)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3769,
    "Keju Olahan (010604A0)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3770,
    "Keju Olahan (010604A0)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3771,
    "Keju Olahan (010604A0)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3772,
    "Keju Olahan (010604A0)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3773,
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging (0106040203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3774,
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging (0106040203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3775,
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging (0106040203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3776,
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging (0106040203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3777,
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging (0106040203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3778,
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging (0106040203)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3779,
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging (0106040203)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3780,
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging (0106040203)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3781,
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging (0106040203)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3782,
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging (0106040203)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3783,
    "Keju Olahan Plain (01060401)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3784,
    "Keju Olahan Plain (01060401)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3785,
    "Keju Olahan Plain (01060401)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3786,
    "Keju Olahan Plain (01060401)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3787,
    "Keju Olahan Plain (01060401)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3788,
    "Keju Olahan Plain (01060401)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3789,
    "Keju Olahan Plain (01060401)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3790,
    "Keju Olahan Plain (01060401)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3791,
    "Keju Olahan Plain (01060401)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3792,
    "Keju Olahan Plain (01060401)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3793,
    "Keju Olahan Plain (0106040104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3794,
    "Keju Olahan Plain (0106040104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3795,
    "Keju Olahan Plain (0106040104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3796,
    "Keju Olahan Plain (0106040104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3797,
    "Keju Olahan Plain (0106040104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3798,
    "Keju Olahan Plain (0106040104)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3799,
    "Keju Olahan Plain (0106040104)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3800,
    "Keju Olahan Plain (0106040104)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3801,
    "Keju Olahan Plain (0106040104)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3802,
    "Keju Olahan Plain (0106040104)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3803,
    "Keju Olivet Cendre (010602B2)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3804,
    "Keju Olivet Cendre (010602B2)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3805,
    "Keju Olivet Cendre (010602B2)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3806,
    "Keju Olivet Cendre (010602B2)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3807,
    "Keju Olivet Cendre (010602B2)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3808,
    "Keju Olivet Cendre (010602B2)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3809,
    "Keju Olivet Cendre (010602B2)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3810,
    "Keju Olivet Cendre (010602B2)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3811,
    "Keju Olivet Cendre (010602B2)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3812,
    "Keju Olivet Cendre (010602B2)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3813,
    "Keju Palet de Babligny (010602B3)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3814,
    "Keju Palet de Babligny (010602B3)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3815,
    "Keju Palet de Babligny (010602B3)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3816,
    "Keju Palet de Babligny (010602B3)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3817,
    "Keju Palet de Babligny (010602B3)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3818,
    "Keju Palet de Babligny (010602B3)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3819,
    "Keju Palet de Babligny (010602B3)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3820,
    "Keju Palet de Babligny (010602B3)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3821,
    "Keju Palet de Babligny (010602B3)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3822,
    "Keju Palet de Babligny (010602B3)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3823,
    "Keju Parmesan (0106020106)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3824,
    "Keju Parmesan (0106020106)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3825,
    "Keju Parmesan (0106020106)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3826,
    "Keju Parmesan (0106020106)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3827,
    "Keju Parmesan (0106020106)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3828,
    "Keju Parmesan (0106020106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3829,
    "Keju Parmesan (0106020106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3830,
    "Keju Parmesan (0106020106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3831,
    "Keju Parmesan (0106020106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3832,
    "Keju Parmesan (0106020106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3833,
    "Keju Pepper Jack (Keju Monterey Jack dan Potongan Lada) (0106040202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3834,
    "Keju Pepper Jack (Keju Monterey Jack dan Potongan Lada) (0106040202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3835,
    "Keju Pepper Jack (Keju Monterey Jack dan Potongan Lada) (0106040202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3836,
    "Keju Pepper Jack (Keju Monterey Jack dan Potongan Lada) (0106040202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3837,
    "Keju Pepper Jack (Keju Monterey Jack dan Potongan Lada) (0106040202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3838,
    "Keju Pepper Jack (Keju Monterey Jack dan Potongan Lada) (0106040202)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3839,
    "Keju Pepper Jack (Keju Monterey Jack dan Potongan Lada) (0106040202)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3840,
    "Keju Pepper Jack (Keju Monterey Jack dan Potongan Lada) (0106040202)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3841,
    "Keju Pepper Jack (Keju Monterey Jack dan Potongan Lada) (0106040202)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3842,
    "Keju Pepper Jack (Keju Monterey Jack dan Potongan Lada) (0106040202)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    3843,
    "Keju Peram (010602A0)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3844,
    "Keju Peram (010602A0)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3845,
    "Keju Peram (010602A0)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3846,
    "Keju Peram (010602A0)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3847,
    "Keju Peram (010602A0)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3848,
    "Keju Peram (010602A0)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3849,
    "Keju Peram (010602A0)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3850,
    "Keju Peram (010602A0)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3851,
    "Keju Peram (010602A0)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3852,
    "Keju Peram (010602A0)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3853,
    "Keju Peram Lainnya (0106020115)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3854,
    "Keju Peram Lainnya (0106020115)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3855,
    "Keju Peram Lainnya (0106020115)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3856,
    "Keju Peram Lainnya (0106020115)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3857,
    "Keju Peram Lainnya (0106020115)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3858,
    "Keju Peram Lainnya (0106020115)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3859,
    "Keju Peram Lainnya (0106020115)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3860,
    "Keju Peram Lainnya (0106020115)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3861,
    "Keju Peram Lainnya (0106020115)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3862,
    "Keju Peram Lainnya (0106020115)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3863,
    "Keju Protein Whey (Misal Keju Ricotta) (010606)",
    "Listeria monocytogenes (/25 g)",
  ],
  [
    3864,
    "Keju Protein Whey (Misal Keju Ricotta) (010606)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    3865,
    "Keju Protein Whey (Misal Keju Ricotta) (010606)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3866,
    "Keju Protein Whey (Misal Keju Ricotta) (010606)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3867,
    "Keju Protein Whey (Misal Keju Ricotta) (010606)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3868,
    "Keju Protein Whey (Misal Keju Ricotta) (010606)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3869,
    "Keju Protein Whey (Misal Keju Ricotta) (010606)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3870,
    "Keju Swiss (0106020107)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3871,
    "Keju Swiss (0106020107)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3872,
    "Keju Swiss (0106020107)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3873,
    "Keju Swiss (0106020107)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3874,
    "Keju Swiss (0106020107)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    3875,
    "Keju Swiss (0106020107)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3876,
    "Keju Swiss (0106020107)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3877,
    "Keju Swiss (0106020107)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3878,
    "Keju Swiss (0106020107)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3879,
    "Keju Swiss (0106020107)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3880,
    "Keju Tanpa Pemeraman (Keju Mentah) (01060105)",
    "Listeria monocytogenes (koloni/g)",
  ],
  [
    3881,
    "Keju Tanpa Pemeraman (Keju Mentah) (01060105)",
    "Jumlah Sampel - Listeria monocytogenes",
    "",
    "\x{2265}5",
  ],
  [
    3882,
    "Keju Tanpa Pemeraman (Keju Mentah) (01060105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3883,
    "Keju Tanpa Pemeraman (Keju Mentah) (01060105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3884,
    "Keju Tanpa Pemeraman (Keju Mentah) (01060105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3885,
    "Keju Tanpa Pemeraman (Keju Mentah) (01060105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3886,
    "Keju Tanpa Pemeraman (Keju Mentah) (01060105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3887,
    "Keju Tanpa Pemeraman (Keju Mentah) (01060105)",
    "Salmonella (/25 g)",
  ],
  [
    3888,
    "Keju Tanpa Pemeraman (Keju Mentah) (01060105)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [3889, "Keju Whey (010603)", "Listeria monocytogenes (/25 g)"],
  [
    3890,
    "Keju Whey (010603)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    3891,
    "Keju Whey (010603)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3892,
    "Keju Whey (010603)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3893,
    "Keju Whey (010603)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3894,
    "Keju Whey (010603)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3895,
    "Keju Whey (010603)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    3896,
    "Kekicak/Gegicak (060727)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3897,
    "Kekicak/Gegicak (060727)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3898,
    "Kekicak/Gegicak (060727)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3899,
    "Kekicak/Gegicak (060727)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3900,
    "Kekicak/Gegicak (060727)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3901, "Kekicak/Gegicak (060727)", "Salmonella (/25 g)"],
  [3902, "Kekicak/Gegicak (060727)", "Jumlah Sampel - Salmonella"],
  [
    3903,
    "Kekicak/Gegicak (060727)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3904,
    "Kekicak/Gegicak (060727)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3905,
    "Kekicak/Gegicak (060727)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3906,
    "Kekicak/Gegicak (060727)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3907,
    "Kekicak/Gegicak (060727)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3908,
    "Kelapa Parut Kering dengan Proses Pemanasan/ Oven (0401020205)",
    "Salmonella (/25 g)",
  ],
  [
    3909,
    "Kelapa Parut Kering dengan Proses Pemanasan/ Oven (0401020205)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3910,
    "Kembang Gula Isi Susu/Permen Isi Susu (05020104)",
    "Salmonella (/25 g)",
  ],
  [
    3911,
    "Kembang Gula Isi Susu/Permen Isi Susu (05020104)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3912,
    "Kembang Gula Jeli Agar dan Gelatin (05020210)",
    "Salmonella (/25 g)",
  ],
  [
    3913,
    "Kembang Gula Jeli Agar dan Gelatin (05020210)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3914,
    "Kembang Gula Jeli Pati (Starch Jelly) (05020209)",
    "Salmonella (/25 g)",
  ],
  [
    3915,
    "Kembang Gula Jeli Pati (Starch Jelly) (05020209)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3916,
    "Kembang Gula Karamel/Permen Karamel (05020202)",
    "Salmonella (Kembang",
  ],
  [3917, "Gula/Permen"],
  [3918, "Lunak (bukan jeli)"],
  [3919, ") (/25 g)"],
  [
    3920,
    "Kembang Gula Karamel/Permen Karamel (05020202)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3921,
    "Kembang Gula Karamel/Permen Karamel (05020202)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3922,
    "Kembang Gula Karamel/Permen Karamel (05020202)",
    "Salmonella (Kembang Gula/Permen Lunak (jeli)) (/25 g)",
  ],
  [
    3923,
    "Kembang Gula Karet/Permen Karet (050301)",
    "Salmonella (/25 g)",
  ],
  [
    3924,
    "Kembang Gula Karet/Permen Karet (050301)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3925,
    "Kembang Gula Keras/Permen Keras/Hard Candy/Boiled Sweet (05020101)",
    "Salmonella (/25 g)",
  ],
  [
    3926,
    "Kembang Gula Keras/Permen Keras/Hard Candy/Boiled Sweet (05020101)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3927,
    "Kembang Gula Lunak/Permen Lunak (05020201)",
    "Salmonella (Kembang",
  ],
  [3928, "Gula/Permen"],
  [3929, "Lunak (bukan jeli)"],
  [3930, ") (/25 g)"],
  [
    3931,
    "Kembang Gula Lunak/Permen Lunak (05020201)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3932,
    "Kembang Gula Lunak/Permen Lunak (05020201)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3933,
    "Kembang Gula Lunak/Permen Lunak (05020201)",
    "Salmonella (Kembang Gula/Permen Lunak (jeli)) (/25 g)",
  ],
  [3934, "Kembang Tahu (06080201)", "Salmonella (/25 g)"],
  [3935, "Kembang Tahu (06080201)", "Jumlah Sampel - Salmonella"],
  [
    3936,
    "Kembang Tahu (06080201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3937,
    "Kembang Tahu (06080201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3938,
    "Kembang Tahu (06080201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3939,
    "Kembang Tahu (06080201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3940,
    "Kembang Tahu (06080201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [3941, "Kemplang (150304 )", "Salmonella (/25 g)"],
  [3942, "Kemplang (150304 )", "Jumlah Sampel - Salmonella"],
  [
    3943,
    "Kemplang (150304 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3944,
    "Kemplang (150304 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3945,
    "Kemplang (150304 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3946,
    "Kemplang (150304 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3947,
    "Kemplang (150304 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [3948, "Kencur (12020159)", "Salmonella (/25 g)"],
  [3949, "Kencur (12020159)", "Jumlah Sampel - Salmonella"],
  [
    3950,
    "Kencur (12020159)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3951,
    "Kencur (12020159)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3952,
    "Kencur (12020159)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3953,
    "Kencur (12020159)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3954,
    "Kencur (12020159)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3955,
    "Kencur (12020159)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3956,
    "Kencur (12020159)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3957,
    "Kencur (12020159)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3958,
    "Kencur (12020159)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3959,
    "Kencur (12020159)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [3960, "Kencur Bubuk (12020160)", "Salmonella (/25 g)"],
  [3961, "Kencur Bubuk (12020160)", "Jumlah Sampel - Salmonella"],
  [
    3962,
    "Kencur Bubuk (12020160)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3963,
    "Kencur Bubuk (12020160)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3964,
    "Kencur Bubuk (12020160)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3965,
    "Kencur Bubuk (12020160)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3966,
    "Kencur Bubuk (12020160)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    3967,
    "Kencur Bubuk (12020160)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3968,
    "Kencur Bubuk (12020160)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3969,
    "Kencur Bubuk (12020160)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3970,
    "Kencur Bubuk (12020160)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3971,
    "Kencur Bubuk (12020160)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    3972,
    "Kentang Goreng Beku (Frozen French Fries) (0402020111)",
    "Salmonella (/25 g)",
  ],
  [
    3973,
    "Kentang Goreng Beku (Frozen French Fries) (0402020111)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3974,
    "Kentang Goreng Beku (Frozen French Fries) (0402020111)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    3975,
    "Kentang Goreng Beku (Frozen French Fries) (0402020111)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    3976,
    "Kentang Goreng Beku (Frozen French Fries) (0402020111)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    3977,
    "Kentang Goreng Beku (Frozen French Fries) (0402020111)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    3978,
    "Kentang Goreng Beku (Frozen French Fries) (0402020111)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    3979,
    "Keping Jagung (Corn Flake) (060302)",
    "Salmonella (/25 g)",
  ],
  [
    3980,
    "Keping Jagung (Corn Flake) (060302)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3981,
    "Keping Jagung (Corn Flake) (060302)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3982,
    "Keping Jagung (Corn Flake) (060302)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3983,
    "Keping Jagung (Corn Flake) (060302)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3984,
    "Keping Jagung (Corn Flake) (060302)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    3985,
    "Keping Jagung (Corn Flake) (060302)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [3986, "Keripik Bayam (0402020801)", "Salmonella (/25 g)"],
  [
    3987,
    "Keripik Bayam (0402020801)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    3988,
    "Keripik Bayam (0402020801)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3989,
    "Keripik Bayam (0402020801)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3990,
    "Keripik Bayam (0402020801)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3991,
    "Keripik Bayam (0402020801)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3992,
    "Keripik Bayam (0402020801)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    3993,
    "Keripik Belut (0902040316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3994,
    "Keripik Belut (0902040316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3995,
    "Keripik Belut (0902040316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3996,
    "Keripik Belut (0902040316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    3997,
    "Keripik Belut (0902040316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [3998, "Keripik Gadung (150102)", "Salmonella (/25 g)"],
  [3999, "Keripik Gadung (150102)", "Jumlah Sampel - Salmonella"],
  [
    4000,
    "Keripik Gadung (150102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4001,
    "Keripik Gadung (150102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4002,
    "Keripik Gadung (150102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4003,
    "Keripik Gadung (150102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4004,
    "Keripik Gadung (150102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4005,
    "Keripik Ikan (0902040315)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4006,
    "Keripik Ikan (0902040315)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4007,
    "Keripik Ikan (0902040315)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4008,
    "Keripik Ikan (0902040315)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4009,
    "Keripik Ikan (0902040315)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4010,
    "Keripik Jamur Kancing (0402020802)",
    "Salmonella (/25 g)",
  ],
  [
    4011,
    "Keripik Jamur Kancing (0402020802)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4012,
    "Keripik Jamur Kancing (0402020802)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4013,
    "Keripik Jamur Kancing (0402020802)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4014,
    "Keripik Jamur Kancing (0402020802)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4015,
    "Keripik Jamur Kancing (0402020802)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4016,
    "Keripik Jamur Kancing (0402020802)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4017, "Keripik Kentang (150101)", "Salmonella (/25 g)"],
  [4018, "Keripik Kentang (150101)", "Jumlah Sampel - Salmonella"],
  [
    4019,
    "Keripik Kentang (150101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4020,
    "Keripik Kentang (150101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4021,
    "Keripik Kentang (150101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4022,
    "Keripik Kentang (150101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4023,
    "Keripik Kentang (150101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4024,
    "Keripik Kulit Ikan Goreng (0902040303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4025,
    "Keripik Kulit Ikan Goreng (0902040303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4026,
    "Keripik Kulit Ikan Goreng (0902040303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4027,
    "Keripik Kulit Ikan Goreng (0902040303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4028,
    "Keripik Kulit Ikan Goreng (0902040303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [4029, "Keripik Lainnya (150131)", "Salmonella (/25 g)"],
  [4030, "Keripik Lainnya (150131)", "Jumlah Sampel - Salmonella"],
  [
    4031,
    "Keripik Lainnya (150131)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4032,
    "Keripik Lainnya (150131)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4033,
    "Keripik Lainnya (150131)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4034,
    "Keripik Lainnya (150131)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4035,
    "Keripik Lainnya (150131)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4036, "Keripik Oncom (150110)", "Salmonella (/25 g)"],
  [4037, "Keripik Oncom (150110)", "Jumlah Sampel - Salmonella"],
  [
    4038,
    "Keripik Oncom (150110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4039,
    "Keripik Oncom (150110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4040,
    "Keripik Oncom (150110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4041,
    "Keripik Oncom (150110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4042,
    "Keripik Oncom (150110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4043,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4044,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4045,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4046,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4047,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4048,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4049,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4050,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4051,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4052,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4053,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4054,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4055,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4056,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4057,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4058,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4059,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4060,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4061,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4062,
    "Keripik Paru (08020215)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [4063, "Keripik Paru (08020215)", "Salmonella (/25 g)"],
  [4064, "Keripik Paru (08020215)", "Salmonella (/25 g)"],
  [4065, "Keripik Paru (08020215)", "Salmonella (/25 g)"],
  [4066, "Keripik Paru (08020215)", "Salmonella (/25 g)"],
  [4067, "Keripik Paru (08020215)", "Jumlah Sampel - Salmonella"],
  [4068, "Keripik Paru (08020215)", "Jumlah Sampel - Salmonella"],
  [4069, "Keripik Paru (08020215)", "Jumlah Sampel - Salmonella"],
  [4070, "Keripik Paru (08020215)", "Jumlah Sampel - Salmonella"],
  [
    4071,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4072,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4073,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4074,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4075,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4076,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4077,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4078,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4079,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4080,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4081,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4082,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4083,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4084,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4085,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4086,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4087,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4088,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4089,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4090,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4091,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4092,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4093,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4094,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4095,
    "Keripik Paru (08020215)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [4096, "Keripik Sanjai (150106)", "Salmonella (/25 g)"],
  [4097, "Keripik Sanjai (150106)", "Jumlah Sampel - Salmonella"],
  [
    4098,
    "Keripik Sanjai (150106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4099,
    "Keripik Sanjai (150106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4100,
    "Keripik Sanjai (150106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4101,
    "Keripik Sanjai (150106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4102,
    "Keripik Sanjai (150106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4103, "Keripik Singkong (150104)", "Salmonella (/25 g)"],
  [
    4104,
    "Keripik Singkong (150104)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4105,
    "Keripik Singkong (150104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4106,
    "Keripik Singkong (150104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4107,
    "Keripik Singkong (150104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4108,
    "Keripik Singkong (150104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4109,
    "Keripik Singkong (150104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4110,
    "Keripik Tahu / Keripik Produk Tahu / Keripik Kembang Tahu (150111)",
    "Salmonella (/25 g)",
  ],
  [
    4111,
    "Keripik Tahu / Keripik Produk Tahu / Keripik Kembang Tahu (150111)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4112,
    "Keripik Tahu / Keripik Produk Tahu / Keripik Kembang Tahu (150111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4113,
    "Keripik Tahu / Keripik Produk Tahu / Keripik Kembang Tahu (150111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4114,
    "Keripik Tahu / Keripik Produk Tahu / Keripik Kembang Tahu (150111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4115,
    "Keripik Tahu / Keripik Produk Tahu / Keripik Kembang Tahu (150111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4116,
    "Keripik Tahu / Keripik Produk Tahu / Keripik Kembang Tahu (150111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4117, "Keripik Talas (150112)", "Salmonella (/25 g)"],
  [4118, "Keripik Talas (150112)", "Jumlah Sampel - Salmonella"],
  [
    4119,
    "Keripik Talas (150112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4120,
    "Keripik Talas (150112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4121,
    "Keripik Talas (150112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4122,
    "Keripik Talas (150112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4123,
    "Keripik Talas (150112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4124, "Keripik Tempe (150109)", "Salmonella (/25 g)"],
  [4125, "Keripik Tempe (150109)", "Jumlah Sampel - Salmonella"],
  [
    4126,
    "Keripik Tempe (150109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4127,
    "Keripik Tempe (150109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4128,
    "Keripik Tempe (150109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4129,
    "Keripik Tempe (150109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4130,
    "Keripik Tempe (150109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4131, "Keripik Ubi Jalar (150108)", "Salmonella (/25 g)"],
  [
    4132,
    "Keripik Ubi Jalar (150108)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4133,
    "Keripik Ubi Jalar (150108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4134,
    "Keripik Ubi Jalar (150108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4135,
    "Keripik Ubi Jalar (150108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4136,
    "Keripik Ubi Jalar (150108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4137,
    "Keripik Ubi Jalar (150108)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4138, "Kerupuk Beras (150123)", "Salmonella (/25 g)"],
  [4139, "Kerupuk Beras (150123)", "Jumlah Sampel - Salmonella"],
  [
    4140,
    "Kerupuk Beras (150123)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4141,
    "Kerupuk Beras (150123)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4142,
    "Kerupuk Beras (150123)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4143,
    "Kerupuk Beras (150123)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4144,
    "Kerupuk Beras (150123)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4145,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4146,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4147,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4148,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4149,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4150,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4151,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4152,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4153,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4154,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4155,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4156,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4157,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4158,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4159,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4160,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4161,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4162,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4163,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4164,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4165,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4166,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4167,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4168,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4169,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4170,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Salmonella (/25 g)",
  ],
  [
    4171,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Salmonella (/25 g)",
  ],
  [
    4172,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Salmonella (/25 g)",
  ],
  [
    4173,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Salmonella (/25 g)",
  ],
  [
    4174,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Salmonella (/25 g)",
  ],
  [
    4175,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4176,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4177,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4178,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4179,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4180,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4181,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4182,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4183,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4184,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4185,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4186,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4187,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4188,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4189,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4190,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4191,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4192,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4193,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4194,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4195,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4196,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4197,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4198,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4199,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4200,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4201,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4202,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4203,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4204,
    "Kerupuk Berbasis Daging, Daging Unggas dan Daging Hewan Buruan (08020216)",
    "Clostridium perfringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [4205, "Kerupuk Cumi (150303 )", "Salmonella (/25 g)"],
  [4206, "Kerupuk Cumi (150303 )", "Jumlah Sampel - Salmonella"],
  [
    4207,
    "Kerupuk Cumi (150303 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4208,
    "Kerupuk Cumi (150303 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4209,
    "Kerupuk Cumi (150303 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4210,
    "Kerupuk Cumi (150303 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4211,
    "Kerupuk Cumi (150303 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4212, "Kerupuk Ikan (09020506)", "Salmonella (/25 g)"],
  [4213, "Kerupuk Ikan (09020506)", "Jumlah Sampel - Salmonella"],
  [4214, "Kerupuk Ikan (150301)", "Salmonella (/25 g)"],
  [4215, "Kerupuk Ikan (150301)", "Jumlah Sampel - Salmonella"],
  [
    4216,
    "Kerupuk Ikan (150301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4217,
    "Kerupuk Ikan (150301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4218,
    "Kerupuk Ikan (150301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4219,
    "Kerupuk Ikan (150301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4220,
    "Kerupuk Ikan (150301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4221, "Kerupuk Intip (150126)", "Salmonella (/25 g)"],
  [4222, "Kerupuk Intip (150126)", "Jumlah Sampel - Salmonella"],
  [
    4223,
    "Kerupuk Intip (150126)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4224,
    "Kerupuk Intip (150126)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4225,
    "Kerupuk Intip (150126)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4226,
    "Kerupuk Intip (150126)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4227,
    "Kerupuk Intip (150126)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4228, "Kerupuk Jengkol (0402020808)", "Salmonella (/25 g)"],
  [
    4229,
    "Kerupuk Jengkol (0402020808)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4230,
    "Kerupuk Jengkol (0402020808)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4231,
    "Kerupuk Jengkol (0402020808)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4232,
    "Kerupuk Jengkol (0402020808)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4233,
    "Kerupuk Jengkol (0402020808)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4234,
    "Kerupuk Jengkol (0402020808)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4235, "Kerupuk Karak (150125)", "Salmonella (/25 g)"],
  [4236, "Kerupuk Karak (150125)", "Jumlah Sampel - Salmonella"],
  [
    4237,
    "Kerupuk Karak (150125)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4238,
    "Kerupuk Karak (150125)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4239,
    "Kerupuk Karak (150125)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4240,
    "Kerupuk Karak (150125)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4241,
    "Kerupuk Karak (150125)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4242,
    "Kerupuk Kulit Ikan Mentah (09020527)",
    "Salmonella (/25 g)",
  ],
  [
    4243,
    "Kerupuk Kulit Ikan Mentah (09020527)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [4244, "Kerupuk Lainnya (150132 )", "Salmonella (/25 g)"],
  [
    4245,
    "Kerupuk Lainnya (150132 )",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4246,
    "Kerupuk Lainnya (150132 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4247,
    "Kerupuk Lainnya (150132 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4248,
    "Kerupuk Lainnya (150132 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4249,
    "Kerupuk Lainnya (150132 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4250,
    "Kerupuk Lainnya (150132 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4251, "Kerupuk Mentah (06040324)", "Salmonella (/25 g)"],
  [
    4252,
    "Kerupuk Mentah (06040324)",
    "Jumlah Sampel - Salmonella",
  ],
  [4253, "Kerupuk Puli (150124)", "Salmonella (/25 g)"],
  [4254, "Kerupuk Puli (150124)", "Jumlah Sampel - Salmonella"],
  [
    4255,
    "Kerupuk Puli (150124)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4256,
    "Kerupuk Puli (150124)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4257,
    "Kerupuk Puli (150124)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4258,
    "Kerupuk Puli (150124)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4259,
    "Kerupuk Puli (150124)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4260, "Kerupuk Udang Matang (150302)", "Salmonella (/25 g)"],
  [
    4261,
    "Kerupuk Udang Matang (150302)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4262,
    "Kerupuk Udang Matang (150302)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4263,
    "Kerupuk Udang Matang (150302)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4264,
    "Kerupuk Udang Matang (150302)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4265,
    "Kerupuk Udang Matang (150302)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4266,
    "Kerupuk Udang Matang (150302)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4267, "Kerupuk Udang Mentah (09020510)", "Salmonella (/25 g)"],
  [
    4268,
    "Kerupuk Udang Mentah (09020510)",
    "Jumlah Sampel - Salmonella",
  ],
  [4269, "Ketumbar (12020161)", "Salmonella (/25 g)"],
  [4270, "Ketumbar (12020161)", "Jumlah Sampel - Salmonella"],
  [
    4271,
    "Ketumbar (12020161)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4272,
    "Ketumbar (12020161)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4273,
    "Ketumbar (12020161)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4274,
    "Ketumbar (12020161)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4275,
    "Ketumbar (12020161)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4276,
    "Ketumbar (12020161)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4277,
    "Ketumbar (12020161)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4278,
    "Ketumbar (12020161)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4279,
    "Ketumbar (12020161)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4280,
    "Ketumbar (12020161)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4281, "Ketumbar Bubuk (12020163)", "Salmonella (/25 g)"],
  [
    4282,
    "Ketumbar Bubuk (12020163)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4283,
    "Ketumbar Bubuk (12020163)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4284,
    "Ketumbar Bubuk (12020163)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4285,
    "Ketumbar Bubuk (12020163)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4286,
    "Ketumbar Bubuk (12020163)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4287,
    "Ketumbar Bubuk (12020163)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4288,
    "Ketumbar Bubuk (12020163)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4289,
    "Ketumbar Bubuk (12020163)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4290,
    "Ketumbar Bubuk (12020163)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4291,
    "Ketumbar Bubuk (12020163)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4292,
    "Ketumbar Bubuk (12020163)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4293,
    "Khoa (01030110)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4294,
    "Khoa (01030110)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4295,
    "Khoa (01030110)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4296,
    "Khoa (01030110)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4297,
    "Khoa (01030110)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [4298, "Kimchi (0402020708)", "Salmonella (/25 g)"],
  [4299, "Kimchi (0402020708)", "Jumlah Sampel - Salmonella"],
  [4300, "Kinako (06020123)", "Salmonella (/25 g)"],
  [4301, "Kinako (06020123)", "Jumlah Sampel - Salmonella"],
  [
    4302,
    "Kinako (06020123)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4303,
    "Kinako (06020123)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4304,
    "Kinako (06020123)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4305,
    "Kinako (06020123)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4306,
    "Kinako (06020123)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4307, "Kipang Kacang Mete (150206)", "Salmonella (/25 g)"],
  [
    4308,
    "Kipang Kacang Mete (150206)",
    "Jumlah Sampel - Salmonella",
  ],
  [4309, "Kitosan (Chitosan) (09020525)", "Salmonella (/25 g)"],
  [4310, "Kitosan (Chitosan) (09020525)", "Salmonella (/25 g)"],
  [4311, "Kitosan (Chitosan) (09020525)", "Salmonella (/25 g)"],
  [4312, "Kitosan (Chitosan) (09020525)", "Salmonella (/25 g)"],
  [
    4313,
    "Kitosan (Chitosan) (09020525)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4314,
    "Kitosan (Chitosan) (09020525)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4315,
    "Kitosan (Chitosan) (09020525)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4316,
    "Kitosan (Chitosan) (09020525)",
    "Jumlah Sampel - Salmonella",
  ],
  [4317, "Kluwek (12020165)", "Salmonella (/25 g)"],
  [4318, "Kluwek (12020165)", "Jumlah Sampel - Salmonella"],
  [
    4319,
    "Kluwek (12020165)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4320,
    "Kluwek (12020165)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4321,
    "Kluwek (12020165)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4322,
    "Kluwek (12020165)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4323,
    "Kluwek (12020165)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4324,
    "Kluwek (12020165)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4325,
    "Kluwek (12020165)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4326,
    "Kluwek (12020165)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4327,
    "Kluwek (12020165)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4328,
    "Kluwek (12020165)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4329,
    "Koktil Buah Dalam Kemasan (0401020403)",
    "Salmonella (/25 g)",
  ],
  [
    4330,
    "Koktil Buah Dalam Kemasan (0401020403)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    4331,
    "Kolang Kaling Dalam Kemasan (0401020402)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4332,
    "Kolang Kaling Dalam Kemasan (0401020402)",
    "Salmonella (/25 g)",
  ],
  [4333, "Kondimen (12020202)", "Salmonella (/25 g)-herba basah"],
  [
    4334,
    "Kondimen (12020202)",
    "Jumlah Sampel - Salmonella-herba basah",
  ],
  [
    4335,
    "Kondimen (12020202)",
    "Clostridium pefringens (koloni/g)-herba basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4336,
    "Kondimen (12020202)",
    "Clostridium pefringens (koloni/g)-herba basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4337,
    "Kondimen (12020202)",
    "Clostridium pefringens (koloni/g)-herba basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4338,
    "Kondimen (12020202)",
    "Clostridium pefringens (koloni/g)-herba basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4339,
    "Kondimen (12020202)",
    "Clostridium pefringens (koloni/g)-herba basah",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4340,
    "Konsentrat Lemonade Beku (1401040301)",
    "Salmonella (/25 g)",
  ],
  [
    4341,
    "Konsentrat Lemonade Beku (1401040301)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4342,
    "Konsentrat Sari Kedelai (06080104)",
    "Salmonella (/25 g)",
  ],
  [
    4343,
    "Konsentrat Sari Kedelai (06080104)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [4344, "Kopra (0401020204)", "Jumlah Sampel - Salmonella"],
  [4345, "Kopra (0401020204)", "Salmonella (/25 g)"],
  [4346, "Kornet Daging (Beku) (08030308)", "Salmonella (/25 g)"],
  [4347, "Kornet Daging (Beku) (08030308)", "Salmonella (/25 g)"],
  [4348, "Kornet Daging (Beku) (08030308)", "Salmonella (/25 g)"],
  [4349, "Kornet Daging (Beku) (08030308)", "Jumlah - Salmonella"],
  [4350, "Kornet Daging (Beku) (08030308)", "Jumlah - Salmonella"],
  [
    4351,
    "Kornet Daging (Beku) (08030308)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4352,
    "Kornet Daging (Beku) (08030308)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4353,
    "Kornet Daging (Beku) (08030308)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4354,
    "Kornet Daging (Beku) (08030308)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4355,
    "Kornet Daging (Beku) (08030308)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4356,
    "Kornet Daging (Beku) (08030308)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4357,
    "Kornet Daging (Beku) (08030308)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4358,
    "Kornet Daging (Beku) (08030308)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4359,
    "Kornet Daging (Beku) (08030308)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4360,
    "Kornet Daging (Beku) (08030308)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4361,
    "Kornet Daging (Beku) (08030308)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    4362,
    "Kornet Daging (Beku) (08030308)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    4363,
    "Kornet Daging (Beku) (08030308)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    4364,
    "Kornet Daging (Beku) (08030308)",
    "Jumlah - Listeria monocytogenes",
  ],
  [
    4365,
    "Kornet Daging (Beku) (08030308)",
    "Jumlah - Listeria monocytogenes",
  ],
  [
    4366,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Salmonella (/25 g)",
  ],
  [
    4367,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Salmonella (/25 g)",
  ],
  [
    4368,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Salmonella (/25 g)",
  ],
  [
    4369,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Jumlah - Salmonella",
  ],
  [
    4370,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Jumlah - Salmonella",
  ],
  [
    4371,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4372,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4373,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4374,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4375,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4376,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4377,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4378,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4379,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4380,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4381,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    4382,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    4383,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    4384,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Jumlah - Listeria monocytogenes",
  ],
  [
    4385,
    "Kornet Daging Kombinasi (Beku) (08030309)",
    "Jumlah - Listeria monocytogenes",
  ],
  [
    4386,
    "Kornet Daging Kombinasi non sterilisasi (0803010112)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4387,
    "Kornet Daging Kombinasi non sterilisasi (0803010112)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4388,
    "Kornet Daging Kombinasi non sterilisasi (0803010112)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4389,
    "Kornet Daging Kombinasi non sterilisasi (0803010112)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4390,
    "Kornet Daging Kombinasi non sterilisasi (0803010112)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4391,
    "Kornet Daging Kombinasi non sterilisasi (0803010112)",
    "Salmonella (/25 g)",
  ],
  [
    4392,
    "Kornet Daging Kombinasi non sterilisasi (0803010112)",
    "Salmonella (/25 g)",
  ],
  [
    4393,
    "Kornet Daging Kombinasi non sterilisasi (0803010112)",
    "Jumlah - Salmonella",
  ],
  [
    4394,
    "Kornet Daging non sterilisasi (0803010111)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4395,
    "Kornet Daging non sterilisasi (0803010111)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4396,
    "Kornet Daging non sterilisasi (0803010111)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4397,
    "Kornet Daging non sterilisasi (0803010111)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4398,
    "Kornet Daging non sterilisasi (0803010111)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4399,
    "Kornet Daging non sterilisasi (0803010111)",
    "Salmonella (/25 g)",
  ],
  [
    4400,
    "Kornet Daging non sterilisasi (0803010111)",
    "Salmonella (/25 g)",
  ],
  [
    4401,
    "Kornet Daging non sterilisasi (0803010111)",
    "Jumlah - Salmonella",
  ],
  [4402, "Kornet Ikan (090411)", "Salmonella (/25 g)"],
  [4403, "Kornet Ikan (090411)", "Jumlah Sampel - Salmonella"],
  [
    4404,
    "Kornet Ikan (090411)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    4405,
    "Kornet Ikan (090411)",
    "Jumlah Sampel -Listeria monocytogenes",
  ],
  [
    4406,
    "Kornet Unggas (Beku) (08030310)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    4407,
    "Kornet Unggas (Beku) (08030310)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4408,
    "Kornet Unggas (Beku) (08030310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4409,
    "Kornet Unggas (Beku) (08030310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4410,
    "Kornet Unggas (Beku) (08030310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4411,
    "Kornet Unggas (Beku) (08030310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4412,
    "Kornet Unggas (Beku) (08030310)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4413,
    "Kornet Unggas (Beku) (08030310)",
    "Listeria monocytogenes (/25 g)",
  ],
  [
    4414,
    "Kornet Unggas (Beku) (08030310)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    4415,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    4416,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4417,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4418,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4419,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4420,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4421,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4422,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Listeria monocytogenes (/25 g)",
  ],
  [
    4423,
    "Kornet Unggas Kombinasi (Beku) (08030311)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    4424,
    "Kornet Unggas Kombinasi non sterilisasi (0803010114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4425,
    "Kornet Unggas Kombinasi non sterilisasi (0803010114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4426,
    "Kornet Unggas Kombinasi non sterilisasi (0803010114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4427,
    "Kornet Unggas Kombinasi non sterilisasi (0803010114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4428,
    "Kornet Unggas Kombinasi non sterilisasi (0803010114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4429,
    "Kornet Unggas Kombinasi non sterilisasi (0803010114)",
    "Salmonella (/25 g)",
  ],
  [
    4430,
    "Kornet Unggas Kombinasi non sterilisasi (0803010114)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4431,
    "Kornet Unggas non sterilisasi (0803010113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4432,
    "Kornet Unggas non sterilisasi (0803010113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4433,
    "Kornet Unggas non sterilisasi (0803010113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4434,
    "Kornet Unggas non sterilisasi (0803010113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4435,
    "Kornet Unggas non sterilisasi (0803010113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4436,
    "Kornet Unggas non sterilisasi (0803010113)",
    "Salmonella (/25 g)",
  ],
  [
    4437,
    "Kornet Unggas non sterilisasi (0803010113)",
    "Jumlah Sampel - Salmonella",
  ],
  [4438, "Krekers (07010201)", "Salmonella (/25 g)"],
  [4439, "Krekers (07010201)", "Jumlah Sampel - Salmonella"],
  [
    4440,
    "Krekers (07010201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4441,
    "Krekers (07010201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4442,
    "Krekers (07010201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4443,
    "Krekers (07010201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4444,
    "Krekers (07010201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4445, "Krekers Beras (Senbei) (150103)", "Salmonella (/25 g)"],
  [
    4446,
    "Krekers Beras (Senbei) (150103)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4447,
    "Krekers Beras (Senbei) (150103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4448,
    "Krekers Beras (Senbei) (150103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4449,
    "Krekers Beras (Senbei) (150103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4450,
    "Krekers Beras (Senbei) (150103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4451,
    "Krekers Beras (Senbei) (150103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4452,
    "Krekers Gurih (Savoury Cracker), Snack Cracker (07010207)",
    "Salmonella (/25 g)",
  ],
  [
    4453,
    "Krekers Gurih (Savoury Cracker), Snack Cracker (07010207)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4454,
    "Krekers Gurih (Savoury Cracker), Snack Cracker (07010207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4455,
    "Krekers Gurih (Savoury Cracker), Snack Cracker (07010207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4456,
    "Krekers Gurih (Savoury Cracker), Snack Cracker (07010207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4457,
    "Krekers Gurih (Savoury Cracker), Snack Cracker (07010207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4458,
    "Krekers Gurih (Savoury Cracker), Snack Cracker (07010207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4459, "Krekers Krim (07010202)", "Salmonella (/25 g)"],
  [4460, "Krekers Krim (07010202)", "Jumlah Sampel - Salmonella"],
  [
    4461,
    "Krekers Krim (07010202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4462,
    "Krekers Krim (07010202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4463,
    "Krekers Krim (07010202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4464,
    "Krekers Krim (07010202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4465,
    "Krekers Krim (07010202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4466, "Krekers Rasa (150135)", "Salmonella (/25 g)"],
  [
    4467,
    "Krekers Rasa (150135)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    4468,
    "Krekers Rasa (150135)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4469,
    "Krekers Rasa (150135)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4470,
    "Krekers Rasa (150135)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4471,
    "Krekers Rasa (150135)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4472,
    "Krekers Rasa (150135)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [4473, "Krekers Sandwich (07010203)", "Salmonella (/25 g)"],
  [
    4474,
    "Krekers Sandwich (07010203)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4475,
    "Krekers Sandwich (07010203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4476,
    "Krekers Sandwich (07010203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4477,
    "Krekers Sandwich (07010203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4478,
    "Krekers Sandwich (07010203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4479,
    "Krekers Sandwich (07010203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4480, "Krekers Sandwich (150136)", "Salmonella (/25 g)"],
  [
    4481,
    "Krekers Sandwich (150136)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    4482,
    "Krekers Sandwich (150136)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4483,
    "Krekers Sandwich (150136)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4484,
    "Krekers Sandwich (150136)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4485,
    "Krekers Sandwich (150136)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    4486,
    "Krekers Sandwich (150136)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [4487, "Krekers Soda (07010206)", "Salmonella (/25 g)"],
  [4488, "Krekers Soda (07010206)", "Jumlah Sampel - Salmonella"],
  [
    4489,
    "Krekers Soda (07010206)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4490,
    "Krekers Soda (07010206)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4491,
    "Krekers Soda (07010206)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4492,
    "Krekers Soda (07010206)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4493,
    "Krekers Soda (07010206)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [4494, "Krim (0104AA)", "Salmonella (/25 ml)"],
  [4495, "Krim (0104AA)", "Jumlah Sampel - Salmonella"],
  [
    4496,
    "Krim \x{201C}Whipping\x{201D} (Whipping Cream) Rendah Lemak (01040203)",
    "Salmonella (/25 ml)",
  ],
  [
    4497,
    "Krim \x{201C}Whipping\x{201D} (Whipping Cream) Rendah Lemak (01040203)",
    "Jumlah Sampel - Salmonella",
  ],
  [4498, "Krim Asam (01040301)", "Salmonella (/25 ml)"],
  [4499, "Krim Asam (01040301)", "Jumlah Sampel - Salmonella"],
  [
    4500,
    "Krim Bubuk (01050105)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4501,
    "Krim Bubuk (01050105)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4502,
    "Krim Bubuk (01050105)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4503,
    "Krim Bubuk (01050105)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4504,
    "Krim Bubuk (01050105)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [4505, "Krim Bubuk (01050105)", "Salmonella (/25 ml)"],
  [4506, "Krim Bubuk (01050105)", "Jumlah Sampel - Salmonella"],
  [
    4507,
    "Krim Kental Manis (01030108)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4508,
    "Krim Kental Manis (01030108)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4509,
    "Krim Kental Manis (01030108)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4510,
    "Krim Kental Manis (01030108)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4511,
    "Krim Kental Manis (01030108)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4512,
    "Krim Nabati (01040401)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4513,
    "Krim Nabati (01040401)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4514,
    "Krim Nabati (01040401)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4515,
    "Krim Nabati (01040401)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4516,
    "Krim Nabati (01040401)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [4517, "Krim Nabati (01040401)", "Salmonella (/25 ml)"],
  [4518, "Krim Nabati (01040401)", "Jumlah Sampel - Salmonella"],
  [4519, "Krim Nabati Bubuk (01040402)", "Salmonella (/25 g)"],
  [
    4520,
    "Krim Nabati Bubuk (01040402)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    4521,
    "Krim Nabati Bubuk (01040402)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4522,
    "Krim Nabati Bubuk (01040402)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4523,
    "Krim Nabati Bubuk (01040402)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4524,
    "Krim Nabati Bubuk (01040402)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4525,
    "Krim Nabati Bubuk (01040402)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4526,
    "Krim Pasteurisasi (Plain) (01040101)",
    "Salmonella (/25 ml)",
  ],
  [
    4527,
    "Krim Pasteurisasi (Plain) (01040101)",
    "Jumlah Sampel - Salmonella",
  ],
  [4528, "Krim Rendah Lemak (01040202)", "Salmonella (/25 ml)"],
  [
    4529,
    "Krim Rendah Lemak (01040202)",
    "Jumlah Sampel - Salmonella",
  ],
  [4530, "Krim yang Diasamkan (01040302)", "Salmonella (/25 ml)"],
  [
    4531,
    "Krim yang Diasamkan (01040302)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4532,
    "Krim yang Digumpalkan dengan Enzim (01040303)",
    "Salmonella (/25 g)",
  ],
  [
    4533,
    "Krim yang Digumpalkan dengan Enzim (01040303)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    4534,
    "Krimer Kental Manis (01030109)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4535,
    "Krimer Kental Manis (01030109)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4536,
    "Krimer Kental Manis (01030109)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4537,
    "Krimer Kental Manis (01030109)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4538,
    "Krimer Kental Manis (01030109)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4539,
    "Krimer Kental Manis (01030204)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4540,
    "Krimer Kental Manis (01030204)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4541,
    "Krimer Kental Manis (01030204)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4542,
    "Krimer Kental Manis (01030204)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4543,
    "Krimer Kental Manis (01030204)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4544,
    "Krimer Minuman (01030201)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4545,
    "Krimer Minuman (01030201)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4546,
    "Krimer Minuman (01030201)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4547,
    "Krimer Minuman (01030201)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    4548,
    "Krimer Minuman (01030201)",
    "Staphylococcus aureus (koloni/ml)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [4549, "Krimer Minuman (01030201)", "Salmonella (/25 ml)"],
  [
    4550,
    "Krimer Minuman (01030201)",
    "Jumlah Sampel - Salmonella",
  ],
  [4551, "Krokant/Brittles (05020212)", "Salmonella (Kembang"],
  [4552, "Gula/Permen"],
  [4553, "Lunak (bukan jeli)"],
  [4554, ") (/25 g)"],
  [
    4555,
    "Krokant/Brittles (05020212)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4556,
    "Krokant/Brittles (05020212)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4557,
    "Krokant/Brittles (05020212)",
    "Salmonella (Kembang Gula/Permen Lunak (jeli)) (/25 g)",
  ],
  [4558, "Kucai/Chives (12020125)", "Salmonella (/25 g)"],
  [4559, "Kucai/Chives (12020125)", "Jumlah Sampel - Salmonella"],
  [4560, "Kue Ape (07020125)", "Salmonella (/25 g)"],
  [4561, "Kue Ape (07020125)", "Jumlah Sampel - Salmonella"],
  [
    4562,
    "Kue Ape (07020125)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4563,
    "Kue Ape (07020125)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4564,
    "Kue Ape (07020125)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4565,
    "Kue Ape (07020125)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4566,
    "Kue Ape (07020125)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4567,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4568,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4569,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4570,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4571,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4572,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Salmonella (/25 g)",
  ],
  [
    4573,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4574,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4575,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4576,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4577,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4578,
    "Kue Berbahan Dasar Beras Lainnya (060733)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4579,
    "Kue Berbahan Dasar Terigu (07020129)",
    "Salmonella (/25 g)",
  ],
  [
    4580,
    "Kue Berbahan Dasar Terigu (07020129)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4581,
    "Kue Berbahan Dasar Terigu (07020129)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4582,
    "Kue Berbahan Dasar Terigu (07020129)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4583,
    "Kue Berbahan Dasar Terigu (07020129)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4584,
    "Kue Berbahan Dasar Terigu (07020129)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4585,
    "Kue Berbahan Dasar Terigu (07020129)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [4586, "Kue Cucur (07020121)", "Salmonella (/25 g)"],
  [4587, "Kue Cucur (07020121)", "Jumlah Sampel - Salmonella"],
  [
    4588,
    "Kue Cucur (07020121)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4589,
    "Kue Cucur (07020121)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4590,
    "Kue Cucur (07020121)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4591,
    "Kue Cucur (07020121)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4592,
    "Kue Cucur (07020121)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4593,
    "Kue Cumi/Sotong/Udang Kukus (0902040212)",
    "Salmonella (/25 g)",
  ],
  [
    4594,
    "Kue Cumi/Sotong/Udang Kukus (0902040212)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    4595,
    "Kue Cumi/Sotong/Udang Kukus (0902040212)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    4596,
    "Kue Cumi/Sotong/Udang Kukus (0902040212)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    4597,
    "Kue Cumi/Sotong/Udang Kukus (0902040212)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    4598,
    "Kue Cumi/Sotong/Udang Kukus (0902040212)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    4599,
    "Kue Cumi/Sotong/Udang Kukus (0902040212)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    4600,
    "Kue Cumi/Sotong/Udang Kukus (0902040212)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    4601,
    "Kue Cumi/Sotong/Udang Kukus (0902040212)",
    "Jumlah Sampel - Listeria monocytogenes",
    "\x{2265}",
  ],
  [
    4602,
    "Kue Ikan Kukus (Steamed Fish Cake) (0902040110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4603,
    "Kue Ikan Kukus (Steamed Fish Cake) (0902040110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4604,
    "Kue Ikan Kukus (Steamed Fish Cake) (0902040110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4605,
    "Kue Ikan Kukus (Steamed Fish Cake) (0902040110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4606,
    "Kue Ikan Kukus (Steamed Fish Cake) (0902040110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4607,
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang) (0902040311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4608,
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang) (0902040311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4609,
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang) (0902040311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4610,
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang) (0902040311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4611,
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang) (0902040311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4612,
    "Kue Ku (060723)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4613,
    "Kue Ku (060723)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4614,
    "Kue Ku (060723)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4615,
    "Kue Ku (060723)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4616,
    "Kue Ku (060723)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4617, "Kue Ku (060723)", "Salmonella (/25 g)"],
  [4618, "Kue Ku (060723)", "Jumlah Sampel - Salmonella"],
  [
    4619,
    "Kue Ku (060723)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4620,
    "Kue Ku (060723)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4621,
    "Kue Ku (060723)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4622,
    "Kue Ku (060723)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4623,
    "Kue Ku (060723)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4624,
    "Kue Lapis Beras (060712)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4625,
    "Kue Lapis Beras (060712)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4626,
    "Kue Lapis Beras (060712)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4627,
    "Kue Lapis Beras (060712)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4628,
    "Kue Lapis Beras (060712)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4629, "Kue Lapis Beras (060712)", "Salmonella (/25 g)"],
  [4630, "Kue Lapis Beras (060712)", "Jumlah Sampel - Salmonella"],
  [
    4631,
    "Kue Lapis Beras (060712)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4632,
    "Kue Lapis Beras (060712)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4633,
    "Kue Lapis Beras (060712)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4634,
    "Kue Lapis Beras (060712)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4635,
    "Kue Lapis Beras (060712)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4636,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4637,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4638,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4639,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4640,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4641,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Salmonella (/25 g)",
  ],
  [
    4642,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4643,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4644,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4645,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4646,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4647,
    "Kue Mangkok (dari Tepung Beras) (060709)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4648,
    "Kue Mayang (060708)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4649,
    "Kue Mayang (060708)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4650,
    "Kue Mayang (060708)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4651,
    "Kue Mayang (060708)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4652,
    "Kue Mayang (060708)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4653, "Kue Mayang (060708)", "Salmonella (/25 g)"],
  [4654, "Kue Mayang (060708)", "Jumlah Sampel - Salmonella"],
  [
    4655,
    "Kue Mayang (060708)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4656,
    "Kue Mayang (060708)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4657,
    "Kue Mayang (060708)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4658,
    "Kue Mayang (060708)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4659,
    "Kue Mayang (060708)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4660,
    "Kue Mochi (060703)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4661,
    "Kue Mochi (060703)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4662,
    "Kue Mochi (060703)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4663,
    "Kue Mochi (060703)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4664,
    "Kue Mochi (060703)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4665, "Kue Mochi (060703)", "Salmonella (/25 g)"],
  [4666, "Kue Mochi (060703)", "Jumlah Sampel - Salmonella"],
  [
    4667,
    "Kue Mochi (060703)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4668,
    "Kue Mochi (060703)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4669,
    "Kue Mochi (060703)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4670,
    "Kue Mochi (060703)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4671,
    "Kue Mochi (060703)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4672,
    "Kue Putu (060707)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4673,
    "Kue Putu (060707)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4674,
    "Kue Putu (060707)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4675,
    "Kue Putu (060707)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4676,
    "Kue Putu (060707)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4677, "Kue Putu (060707)", "Salmonella (/25 g)"],
  [4678, "Kue Putu (060707)", "Jumlah Sampel - Salmonella"],
  [
    4679,
    "Kue Putu (060707)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4680,
    "Kue Putu (060707)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4681,
    "Kue Putu (060707)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4682,
    "Kue Putu (060707)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4683,
    "Kue Putu (060707)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4684,
    "Kue Teuck/Tteok (060704)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4685,
    "Kue Teuck/Tteok (060704)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4686,
    "Kue Teuck/Tteok (060704)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4687,
    "Kue Teuck/Tteok (060704)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4688,
    "Kue Teuck/Tteok (060704)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4689, "Kue Teuck/Tteok (060704)", "Salmonella (/25 g)"],
  [4690, "Kue Teuck/Tteok (060704)", "Jumlah Sampel - Salmonella"],
  [
    4691,
    "Kue Teuck/Tteok (060704)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4692,
    "Kue Teuck/Tteok (060704)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4693,
    "Kue Teuck/Tteok (060704)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4694,
    "Kue Teuck/Tteok (060704)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4695,
    "Kue Teuck/Tteok (060704)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [4696, "Kuetiaw Instan (06040306)", "Salmonella (/25 g)"],
  [
    4697,
    "Kuetiaw Instan (06040306)",
    "Jumlah Sampel - Salmonella",
  ],
  [4698, "Kuetiaw Kering (06040201)", "Salmonella (/25 g)"],
  [
    4699,
    "Kuetiaw Kering (06040201)",
    "Jumlah Sampel - Salmonella",
  ],
  [4700, "Kuetiaw Lainnya (06040220)", "Salmonella (/25 g)"],
  [
    4701,
    "Kuetiaw Lainnya (06040220)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [4702, "Kukis (07020115)", "Salmonella (/25 g)"],
  [4703, "Kukis (07020115)", "Jumlah Sampel - Salmonella"],
  [
    4704,
    "Kukis (07020115)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4705,
    "Kukis (07020115)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4706,
    "Kukis (07020115)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4707,
    "Kukis (07020115)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4708,
    "Kukis (07020115)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [4709, "Kukis Gula (07020116)", "Salmonella (/25 g)"],
  [4710, "Kukis Gula (07020116)", "Jumlah Sampel - Salmonella"],
  [
    4711,
    "Kukis Gula (07020116)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4712,
    "Kukis Gula (07020116)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4713,
    "Kukis Gula (07020116)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4714,
    "Kukis Gula (07020116)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4715,
    "Kukis Gula (07020116)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4716,
    "Kukis Lunak (Soft Cookies) (07020133)",
    "Salmonella (/25 g)",
  ],
  [
    4717,
    "Kukis Lunak (Soft Cookies) (07020133)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4718,
    "Kukis Lunak (Soft Cookies) (07020133)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4719,
    "Kukis Lunak (Soft Cookies) (07020133)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4720,
    "Kukis Lunak (Soft Cookies) (07020133)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4721,
    "Kukis Lunak (Soft Cookies) (07020133)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4722,
    "Kukis Lunak (Soft Cookies) (07020133)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [4723, "Kukis Oatmeal (07020117)", "Salmonella (/25 g)"],
  [4724, "Kukis Oatmeal (07020117)", "Jumlah Sampel - Salmonella"],
  [
    4725,
    "Kukis Oatmeal (07020117)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4726,
    "Kukis Oatmeal (07020117)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4727,
    "Kukis Oatmeal (07020117)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4728,
    "Kukis Oatmeal (07020117)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4729,
    "Kukis Oatmeal (07020117)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [4730, "Kulit Ayam Goreng (08020311)", "Salmonella (/25 g)"],
  [
    4731,
    "Kulit Ayam Goreng (08020311)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4732,
    "Kulit Ayam Goreng (08020311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4733,
    "Kulit Ayam Goreng (08020311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4734,
    "Kulit Ayam Goreng (08020311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4735,
    "Kulit Ayam Goreng (08020311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4736,
    "Kulit Ayam Goreng (08020311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    4737,
    "Kulit Ayam Goreng (08020311)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    4738,
    "Kulit Ayam Goreng (08020311)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    4739,
    "Kulit Keju Peram (01060202)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    4740,
    "Kulit Keju Peram (01060202)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    4741,
    "Kulit Keju Peram (01060202)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    4742,
    "Kulit Keju Peram (01060202)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    4743,
    "Kulit Keju Peram (01060202)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    4744,
    "Kulit Keju Peram (01060202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4745,
    "Kulit Keju Peram (01060202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4746,
    "Kulit Keju Peram (01060202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4747,
    "Kulit Keju Peram (01060202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4748,
    "Kulit Keju Peram (01060202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    4749,
    "Kulit Pangsit/Risol/Lumpia (06040102)",
    "Salmonella (/25 g)",
  ],
  [
    4750,
    "Kulit Pangsit/Risol/Lumpia (06040102)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4751,
    "Kulit Pangsit/Risol/Lumpia (06040102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4752,
    "Kulit Pangsit/Risol/Lumpia (06040102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4753,
    "Kulit Pangsit/Risol/Lumpia (06040102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4754,
    "Kulit Pangsit/Risol/Lumpia (06040102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    4755,
    "Kulit Pangsit/Risol/Lumpia (06040102)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [4756, "Kumys (010201B0)", "Salmonella (/25 ml)"],
  [4757, "Kumys (010201B0)", "Jumlah Sampel - Salmonella"],
  [
    4758,
    "Kumys (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010208)",
    "Salmonella (negatif/25 g)",
  ],
  [
    4759,
    "Kumys (Plain) (Dengan Pemanasan Setelah Difermentasi) (0102010208)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    4760,
    "Kumys (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010108)",
    "Salmonella (/25 g)",
  ],
  [
    4761,
    "Kumys (Plain) (Tanpa Pemanasan Setelah Difermentasi) (0102010108)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [4762, "Kuning Telur Beku (10020203)", "Salmonella (/25 g)"],
  [
    4763,
    "Kuning Telur Beku (10020203)",
    "Jumlah Sampel - Salmonella",
  ],
  [4764, "Kunyit (12020166)", "Salmonella (/25 g)"],
  [4765, "Kunyit (12020166)", "Jumlah Sampel - Salmonella"],
  [
    4766,
    "Kunyit (12020166)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4767,
    "Kunyit (12020166)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4768,
    "Kunyit (12020166)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4769,
    "Kunyit (12020166)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4770,
    "Kunyit (12020166)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4771,
    "Kunyit (12020166)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4772,
    "Kunyit (12020166)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4773,
    "Kunyit (12020166)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4774,
    "Kunyit (12020166)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4775,
    "Kunyit (12020166)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4776, "Kunyit Bubuk (12020167)", "Salmonella (/25 g)"],
  [4777, "Kunyit Bubuk (12020167)", "Jumlah Sampel - Salmonella"],
  [
    4778,
    "Kunyit Bubuk (12020167)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4779,
    "Kunyit Bubuk (12020167)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4780,
    "Kunyit Bubuk (12020167)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4781,
    "Kunyit Bubuk (12020167)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4782,
    "Kunyit Bubuk (12020167)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4783,
    "Kunyit Bubuk (12020167)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4784,
    "Kunyit Bubuk (12020167)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4785,
    "Kunyit Bubuk (12020167)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4786,
    "Kunyit Bubuk (12020167)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4787,
    "Kunyit Bubuk (12020167)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4788, "Lada Bubuk Campuran (12020172)", "Salmonella (/25 g)"],
  [
    4789,
    "Lada Bubuk Campuran (12020172)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4790,
    "Lada Bubuk Campuran (12020172)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4791,
    "Lada Bubuk Campuran (12020172)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4792,
    "Lada Bubuk Campuran (12020172)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4793,
    "Lada Bubuk Campuran (12020172)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4794,
    "Lada Bubuk Campuran (12020172)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4795,
    "Lada Bubuk Campuran (12020172)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4796,
    "Lada Bubuk Campuran (12020172)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4797,
    "Lada Bubuk Campuran (12020172)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4798,
    "Lada Bubuk Campuran (12020172)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4799,
    "Lada Bubuk Campuran (12020172)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4800, "Lada Hitam (12020168)", "Salmonella (/25 g)"],
  [4801, "Lada Hitam (12020168)", "Jumlah Sampel - Salmonella"],
  [
    4802,
    "Lada Hitam (12020168)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4803,
    "Lada Hitam (12020168)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4804,
    "Lada Hitam (12020168)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4805,
    "Lada Hitam (12020168)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4806,
    "Lada Hitam (12020168)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4807,
    "Lada Hitam (12020168)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4808,
    "Lada Hitam (12020168)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4809,
    "Lada Hitam (12020168)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4810,
    "Lada Hitam (12020168)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4811,
    "Lada Hitam (12020168)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4812, "Lada Hitam Bubuk (12020169)", "Salmonella (/25 g)"],
  [
    4813,
    "Lada Hitam Bubuk (12020169)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4814,
    "Lada Hitam Bubuk (12020169)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4815,
    "Lada Hitam Bubuk (12020169)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4816,
    "Lada Hitam Bubuk (12020169)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4817,
    "Lada Hitam Bubuk (12020169)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4818,
    "Lada Hitam Bubuk (12020169)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4819,
    "Lada Hitam Bubuk (12020169)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4820,
    "Lada Hitam Bubuk (12020169)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4821,
    "Lada Hitam Bubuk (12020169)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4822,
    "Lada Hitam Bubuk (12020169)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4823,
    "Lada Hitam Bubuk (12020169)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4824, "Lada Putih (12020170)", "Salmonella (/25 g)"],
  [4825, "Lada Putih (12020170)", "Jumlah Sampel - Salmonella"],
  [
    4826,
    "Lada Putih (12020170)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4827,
    "Lada Putih (12020170)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4828,
    "Lada Putih (12020170)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4829,
    "Lada Putih (12020170)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4830,
    "Lada Putih (12020170)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4831,
    "Lada Putih (12020170)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4832,
    "Lada Putih (12020170)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4833,
    "Lada Putih (12020170)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4834,
    "Lada Putih (12020170)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4835,
    "Lada Putih (12020170)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4836, "Lada Putih Bubuk (12020171)", "Salmonella (/25 g)"],
  [
    4837,
    "Lada Putih Bubuk (12020171)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4838,
    "Lada Putih Bubuk (12020171)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4839,
    "Lada Putih Bubuk (12020171)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4840,
    "Lada Putih Bubuk (12020171)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4841,
    "Lada Putih Bubuk (12020171)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4842,
    "Lada Putih Bubuk (12020171)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4843,
    "Lada Putih Bubuk (12020171)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4844,
    "Lada Putih Bubuk (12020171)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4845,
    "Lada Putih Bubuk (12020171)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4846,
    "Lada Putih Bubuk (12020171)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4847,
    "Lada Putih Bubuk (12020171)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4848,
    "Lalampa (060728)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4849,
    "Lalampa (060728)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4850,
    "Lalampa (060728)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4851,
    "Lalampa (060728)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4852,
    "Lalampa (060728)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4853, "Lalampa (060728)", "Salmonella (/25 g)"],
  [4854, "Lalampa (060728)", "Jumlah Sampel - Salmonella"],
  [
    4855,
    "Lalampa (060728)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4856,
    "Lalampa (060728)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4857,
    "Lalampa (060728)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4858,
    "Lalampa (060728)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4859,
    "Lalampa (060728)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4860,
    "Lamang (060732)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4861,
    "Lamang (060732)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4862,
    "Lamang (060732)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4863,
    "Lamang (060732)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4864,
    "Lamang (060732)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4865, "Lamang (060732)", "Salmonella (/25 g)"],
  [4866, "Lamang (060732)", "Jumlah Sampel - Salmonella"],
  [
    4867,
    "Lamang (060732)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4868,
    "Lamang (060732)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4869,
    "Lamang (060732)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4870,
    "Lamang (060732)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4871,
    "Lamang (060732)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4872,
    "Lampu-Lampu (060716)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4873,
    "Lampu-Lampu (060716)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4874,
    "Lampu-Lampu (060716)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4875,
    "Lampu-Lampu (060716)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4876,
    "Lampu-Lampu (060716)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4877, "Lampu-Lampu (060716)", "Salmonella (/25 g)"],
  [4878, "Lampu-Lampu (060716)", "Jumlah Sampel - Salmonella"],
  [
    4879,
    "Lampu-Lampu (060716)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4880,
    "Lampu-Lampu (060716)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4881,
    "Lampu-Lampu (060716)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4882,
    "Lampu-Lampu (060716)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4883,
    "Lampu-Lampu (060716)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4884,
    "Lapek Bugis (060731)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4885,
    "Lapek Bugis (060731)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4886,
    "Lapek Bugis (060731)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4887,
    "Lapek Bugis (060731)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4888,
    "Lapek Bugis (060731)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4889, "Lapek Bugis (060731)", "Salmonella (/25 g)"],
  [4890, "Lapek Bugis (060731)", "Jumlah Sampel - Salmonella"],
  [
    4891,
    "Lapek Bugis (060731)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4892,
    "Lapek Bugis (060731)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4893,
    "Lapek Bugis (060731)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4894,
    "Lapek Bugis (060731)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4895,
    "Lapek Bugis (060731)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [4896, "Lassi (Plain) (01010205)", "Salmonella (/25 ml)"],
  [4897, "Lassi (Plain) (01010205)", "Jumlah Sampel - Salmonella"],
  [
    4898,
    "Legomoro (060735)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4899,
    "Legomoro (060735)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4900,
    "Legomoro (060735)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4901,
    "Legomoro (060735)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4902,
    "Legomoro (060735)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4903, "Legomoro (060735)", "Salmonella (/25 g)"],
  [
    4904,
    "Legomoro (060735)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    4905,
    "Legomoro (060735)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4906,
    "Legomoro (060735)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4907,
    "Legomoro (060735)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4908,
    "Legomoro (060735)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4909,
    "Legomoro (060735)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4910,
    "Legondo (060724)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4911,
    "Legondo (060724)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4912,
    "Legondo (060724)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4913,
    "Legondo (060724)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4914,
    "Legondo (060724)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4915, "Legondo (060724)", "Salmonella (/25 g)"],
  [4916, "Legondo (060724)", "Jumlah Sampel - Salmonella"],
  [
    4917,
    "Legondo (060724)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4918,
    "Legondo (060724)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4919,
    "Legondo (060724)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4920,
    "Legondo (060724)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4921,
    "Legondo (060724)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4922,
    "Lemak Kakao (Cocoa Butter) (05010116)",
    "Salmonella (/25 g)",
  ],
  [
    4923,
    "Lemak Kakao (Cocoa Butter) (05010116)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4924,
    "Lemak Kakao untuk Confectionery (05010405)",
    "Salmonella (/25 g)",
  ],
  [
    4925,
    "Lemak Kakao untuk Confectionery (05010405)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4926,
    "Lemak Oles Loyang (Pan Release) (02020202)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4927,
    "Lemak Oles Loyang (Pan Release) (02020202)",
    "Salmonella (/25 g)",
  ],
  [
    4928,
    "Lemak Oles Loyang (Pan Release) (02020202)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    4929,
    "Lemak Oles Loyang (Pan Release) (02020202)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    4930,
    "Lemak Oles Loyang (Pan Release) (02020202)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    4931,
    "Lemak Oles Loyang (Pan Release) (02020202)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    4932,
    "Lemak Oles Loyang (Pan Release) (02020202)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    4933,
    "Lemper Ayam (060719)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4934,
    "Lemper Ayam (060719)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4935,
    "Lemper Ayam (060719)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4936,
    "Lemper Ayam (060719)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4937,
    "Lemper Ayam (060719)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4938, "Lemper Ayam (060719)", "Salmonella (/25 g)"],
  [4939, "Lemper Ayam (060719)", "Jumlah Sampel - Salmonella"],
  [
    4940,
    "Lemper Ayam (060719)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4941,
    "Lemper Ayam (060719)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4942,
    "Lemper Ayam (060719)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4943,
    "Lemper Ayam (060719)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4944,
    "Lemper Ayam (060719)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [4945, "Lempuyang (120201A5)", "Salmonella (/25 g)"],
  [4946, "Lempuyang (120201A5)", "Jumlah Sampel - Salmonella"],
  [
    4947,
    "Lempuyang (120201A5)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4948,
    "Lempuyang (120201A5)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4949,
    "Lempuyang (120201A5)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4950,
    "Lempuyang (120201A5)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4951,
    "Lempuyang (120201A5)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4952,
    "Lempuyang (120201A5)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4953,
    "Lempuyang (120201A5)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4954,
    "Lempuyang (120201A5)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4955,
    "Lempuyang (120201A5)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4956,
    "Lempuyang (120201A5)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4957, "Lengkuas/Laos (12020174)", "Salmonella (/25 g)"],
  [4958, "Lengkuas/Laos (12020174)", "Jumlah Sampel - Salmonella"],
  [
    4959,
    "Lengkuas/Laos (12020174)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4960,
    "Lengkuas/Laos (12020174)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4961,
    "Lengkuas/Laos (12020174)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4962,
    "Lengkuas/Laos (12020174)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4963,
    "Lengkuas/Laos (12020174)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4964,
    "Lengkuas/Laos (12020174)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4965,
    "Lengkuas/Laos (12020174)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4966,
    "Lengkuas/Laos (12020174)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4967,
    "Lengkuas/Laos (12020174)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4968,
    "Lengkuas/Laos (12020174)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4969, "Lengkuas/Laos Bubuk (12020175)", "Salmonella (/25 g)"],
  [
    4970,
    "Lengkuas/Laos Bubuk (12020175)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    4971,
    "Lengkuas/Laos Bubuk (12020175)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4972,
    "Lengkuas/Laos Bubuk (12020175)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4973,
    "Lengkuas/Laos Bubuk (12020175)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4974,
    "Lengkuas/Laos Bubuk (12020175)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4975,
    "Lengkuas/Laos Bubuk (12020175)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    4976,
    "Lengkuas/Laos Bubuk (12020175)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4977,
    "Lengkuas/Laos Bubuk (12020175)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4978,
    "Lengkuas/Laos Bubuk (12020175)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4979,
    "Lengkuas/Laos Bubuk (12020175)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4980,
    "Lengkuas/Laos Bubuk (12020175)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4981,
    "Lepet Ketan (060722)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4982,
    "Lepet Ketan (060722)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4983,
    "Lepet Ketan (060722)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4984,
    "Lepet Ketan (060722)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4985,
    "Lepet Ketan (060722)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4986,
    "Lepet Ketan (060722)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4987,
    "Lepet Ketan (060722)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4988,
    "Lepet Ketan (060722)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4989,
    "Lepet Ketan (060722)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    4990,
    "Lepet Ketan (060722)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [4991, "Lepet Ketan (060722)", "Salmonella (/25 g)"],
  [4992, "Lepet Ketan (060722)", "Salmonella (/25 g)"],
  [4993, "Lepet Ketan (060722)", "Jumlah Sampel - Salmonella"],
  [4994, "Lepet Ketan (060722)", "Jumlah Sampel - Salmonella"],
  [
    4995,
    "Lepet Ketan (060722)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4996,
    "Lepet Ketan (060722)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4997,
    "Lepet Ketan (060722)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4998,
    "Lepet Ketan (060722)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    4999,
    "Lepet Ketan (060722)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5000,
    "Lepet Ketan (060722)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5001,
    "Lepet Ketan (060722)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5002,
    "Lepet Ketan (060722)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5003,
    "Lepet Ketan (060722)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5004,
    "Lepet Ketan (060722)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [5005, "Licorice (05020205)", "Salmonella (Kembang"],
  [5006, "Gula/Permen"],
  [5007, "Lunak (bukan jeli)"],
  [5008, ") (/25 g)"],
  [5009, "Licorice (05020205)", "Jumlah Sampel - Salmonella"],
  [5010, "Licorice (05020205)", "Jumlah Sampel - Salmonella"],
  [
    5011,
    "Licorice (05020205)",
    "Salmonella (Kembang Gula/Permen Lunak (jeli)) (/25 g)",
  ],
  [
    5012,
    "Lobster Rebus Beku (0902040203)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    5013,
    "Lobster Rebus Beku (0902040203)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    5014,
    "Lobster Rebus Beku (0902040203)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    5015,
    "Lobster Rebus Beku (0902040203)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    5016,
    "Lobster Rebus Beku (0902040203)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [5017, "Lobster Rebus Beku (0902040203)", "Salmonella (/25 g)"],
  [
    5018,
    "Lobster Rebus Beku (0902040203)",
    "Jumlah Sampel - Salmonella",
  ],
  [5019, "Lumpia Daging (08030314)", "Salmonella (/25 g)"],
  [5020, "Lumpia Daging (08030314)", "Salmonella (/25 g)"],
  [5021, "Lumpia Daging (08030314)", "Jumlah - Salmonella"],
  [5022, "Lumpia Daging (08030314)", "Jumlah - Salmonella"],
  [
    5023,
    "Lumpia Daging (08030314)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5024,
    "Lumpia Daging (08030314)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5025,
    "Lumpia Daging (08030314)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5026,
    "Lumpia Daging (08030314)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5027,
    "Lumpia Daging (08030314)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5028,
    "Lumpia Daging (08030314)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5029,
    "Lumpia Daging (08030314)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5030,
    "Lumpia Daging (08030314)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5031,
    "Lumpia Daging (08030314)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5032,
    "Lumpia Daging (08030314)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5033,
    "Lumpia Daging (08030314)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    5034,
    "Lumpia Daging (08030314)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    5035,
    "Lumpia Daging (08030314)",
    "Jumlah - Listeria monocytogenes",
  ],
  [
    5036,
    "Lumpia Daging (08030314)",
    "Jumlah - Listeria monocytogenes",
  ],
  [5037, "Maida (06020125)", "Salmonella (/25 g)"],
  [5038, "Maida (06020125)", "Jumlah Sampel - Salmonella"],
  [
    5039,
    "Maida (06020125)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5040,
    "Maida (06020125)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5041,
    "Maida (06020125)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5042,
    "Maida (06020125)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5043,
    "Maida (06020125)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5044,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5045,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5046,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5047,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5048,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5049,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5050,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5051,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5052,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5053,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5054,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5055,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5056,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5057,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5058,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5059,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5060,
    "Makanan Diet Diabetes Berbasis Susu (Padat) (130318)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5061,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5062,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5063,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5064,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5065,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5066,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5067,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5068,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5069,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5070,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5071,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5072,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5073,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5074,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5075,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5076,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5077,
    "Makanan Diet Diabetes Bubuk Instan (130324)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5078,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5079,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5080,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5081,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5082,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5083,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5084,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5085,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5086,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5087,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5088,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5089,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5090,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5091,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5092,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5093,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5094,
    "Makanan Diet Diabetes Siap Masak (Padat) (130320)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5095,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5096,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5097,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5098,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5099,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5100,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5101,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5102,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5103,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5104,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5105,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5106,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5107,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5108,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5109,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5110,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5111,
    "Makanan Diet Diabetes Siap Santap (Padat) (130322)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5112,
    "Makanan Diet Kurang Laktosa (130303)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5113,
    "Makanan Diet Kurang Laktosa (130303)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5114,
    "Makanan Diet Kurang Laktosa (130303)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5115,
    "Makanan Diet Kurang Laktosa (130303)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5116,
    "Makanan Diet Kurang Laktosa (130303)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5117,
    "Makanan Diet Kurang Laktosa (130303)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5118,
    "Makanan Diet Kurang Laktosa (130303)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5119,
    "Makanan Diet Kurang Laktosa (130303)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5120,
    "Makanan Diet Kurang Laktosa (130303)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5121,
    "Makanan Diet Kurang Laktosa (130303)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5122,
    "Makanan Diet Kurang Laktosa (130303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5123,
    "Makanan Diet Kurang Laktosa (130303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5124,
    "Makanan Diet Kurang Laktosa (130303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5125,
    "Makanan Diet Kurang Laktosa (130303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5126,
    "Makanan Diet Kurang Laktosa (130303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5127,
    "Makanan Diet Kurang Laktosa (130303)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5128,
    "Makanan Diet Kurang Laktosa (130303)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5129,
    "Makanan Diet Rendah Laktosa (130304)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5130,
    "Makanan Diet Rendah Laktosa (130304)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5131,
    "Makanan Diet Rendah Laktosa (130304)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5132,
    "Makanan Diet Rendah Laktosa (130304)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5133,
    "Makanan Diet Rendah Laktosa (130304)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5134,
    "Makanan Diet Rendah Laktosa (130304)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5135,
    "Makanan Diet Rendah Laktosa (130304)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5136,
    "Makanan Diet Rendah Laktosa (130304)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5137,
    "Makanan Diet Rendah Laktosa (130304)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5138,
    "Makanan Diet Rendah Laktosa (130304)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5139,
    "Makanan Diet Rendah Laktosa (130304)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5140,
    "Makanan Diet Rendah Laktosa (130304)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5141,
    "Makanan Diet Rendah Laktosa (130304)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5142,
    "Makanan Diet Rendah Laktosa (130304)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5143,
    "Makanan Diet Rendah Laktosa (130304)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5144,
    "Makanan Diet Rendah Laktosa (130304)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5145,
    "Makanan Diet Rendah Laktosa (130304)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5146,
    "Makanan Diet Rendah Natrium (130311)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5147,
    "Makanan Diet Rendah Natrium (130311)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5148,
    "Makanan Diet Rendah Natrium (130311)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5149,
    "Makanan Diet Rendah Natrium (130311)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5150,
    "Makanan Diet Rendah Natrium (130311)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5151,
    "Makanan Diet Rendah Natrium (130311)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5152,
    "Makanan Diet Rendah Natrium (130311)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5153,
    "Makanan Diet Rendah Natrium (130311)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5154,
    "Makanan Diet Rendah Natrium (130311)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5155,
    "Makanan Diet Rendah Natrium (130311)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5156,
    "Makanan Diet Rendah Natrium (130311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5157,
    "Makanan Diet Rendah Natrium (130311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5158,
    "Makanan Diet Rendah Natrium (130311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5159,
    "Makanan Diet Rendah Natrium (130311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5160,
    "Makanan Diet Rendah Natrium (130311)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5161,
    "Makanan Diet Rendah Natrium (130311)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5162,
    "Makanan Diet Rendah Natrium (130311)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5163,
    "Makanan Diet Sangat Rendah Natrium (130313)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5164,
    "Makanan Diet Sangat Rendah Natrium (130313)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5165,
    "Makanan Diet Sangat Rendah Natrium (130313)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5166,
    "Makanan Diet Sangat Rendah Natrium (130313)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5167,
    "Makanan Diet Sangat Rendah Natrium (130313)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5168,
    "Makanan Diet Sangat Rendah Natrium (130313)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5169,
    "Makanan Diet Sangat Rendah Natrium (130313)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5170,
    "Makanan Diet Sangat Rendah Natrium (130313)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5171,
    "Makanan Diet Sangat Rendah Natrium (130313)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5172,
    "Makanan Diet Sangat Rendah Natrium (130313)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5173,
    "Makanan Diet Sangat Rendah Natrium (130313)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5174,
    "Makanan Diet Sangat Rendah Natrium (130313)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5175,
    "Makanan Diet Sangat Rendah Natrium (130313)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5176,
    "Makanan Diet Sangat Rendah Natrium (130313)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5177,
    "Makanan Diet Sangat Rendah Natrium (130313)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5178,
    "Makanan Diet Sangat Rendah Natrium (130313)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5179,
    "Makanan Diet Sangat Rendah Natrium (130313)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5180,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5181,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5182,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5183,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5184,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5185,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5186,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5187,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5188,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5189,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5190,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5191,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5192,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5193,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5194,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5195,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5196,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Sebagian Makan Padat (1304010101)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5197,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5198,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5199,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5200,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5201,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5202,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5203,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5204,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5205,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5206,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5207,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5208,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5209,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5210,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5211,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5212,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5213,
    "Makanan Formula Sebagai Makanan Diet Kontrol Berat Badan - Pengganti Seluruh Makan Padat (1304010201)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5214,
    "Makanan Hipoalergenik (130301)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5215,
    "Makanan Hipoalergenik (130301)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5216,
    "Makanan Hipoalergenik (130301)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5217,
    "Makanan Hipoalergenik (130301)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5218,
    "Makanan Hipoalergenik (130301)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5219,
    "Makanan Hipoalergenik (130301)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5220,
    "Makanan Hipoalergenik (130301)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5221,
    "Makanan Hipoalergenik (130301)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5222,
    "Makanan Hipoalergenik (130301)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5223,
    "Makanan Hipoalergenik (130301)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5224,
    "Makanan Hipoalergenik (130301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5225,
    "Makanan Hipoalergenik (130301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5226,
    "Makanan Hipoalergenik (130301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5227,
    "Makanan Hipoalergenik (130301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5228,
    "Makanan Hipoalergenik (130301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5229,
    "Makanan Hipoalergenik (130301)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5230,
    "Makanan Hipoalergenik (130301)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5231,
    "Makanan Pendamping ASI (MP-ASI) Biskuit (130205)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5232,
    "Makanan Pendamping ASI (MP-ASI) Biskuit (130205)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5233,
    "Makanan Pendamping ASI (MP-ASI) Biskuit (130205)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5234,
    "Makanan Pendamping ASI (MP-ASI) Biskuit (130205)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5235,
    "Makanan Pendamping ASI (MP-ASI) Biskuit (130205)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5236,
    "Makanan Pendamping ASI (MP-ASI) Biskuit (130205)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5237,
    "Makanan Pendamping ASI (MP-ASI) Biskuit (130205)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5238,
    "Makanan Pendamping ASI (MP-ASI) Biskuit (130205)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5239,
    "Makanan Pendamping ASI (MP-ASI) Biskuit (130205)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5240,
    "Makanan Pendamping ASI (MP-ASI) Biskuit (130205)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5241,
    "Makanan Pendamping ASI (MP-ASI) Biskuit (130205)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5242,
    "Makanan Pendamping ASI (MP-ASI) Biskuit (130205)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5243,
    "Makanan Pendamping ASI (MP-ASI) Biskuit (130205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5244,
    "Makanan Pendamping ASI (MP-ASI) Biskuit (130205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5245,
    "Makanan Pendamping ASI (MP-ASI) Biskuit (130205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5246,
    "Makanan Pendamping ASI (MP-ASI) Biskuit (130205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5247,
    "Makanan Pendamping ASI (MP-ASI) Biskuit (130205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5248,
    "Makanan Pendamping ASI (MP-ASI) Bubuk Instan (130202)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5249,
    "Makanan Pendamping ASI (MP-ASI) Bubuk Instan (130202)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5250,
    "Makanan Pendamping ASI (MP-ASI) Bubuk Instan (130202)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5251,
    "Makanan Pendamping ASI (MP-ASI) Bubuk Instan (130202)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5252,
    "Makanan Pendamping ASI (MP-ASI) Bubuk Instan (130202)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5253,
    "Makanan Pendamping ASI (MP-ASI) Bubuk Instan (130202)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5254,
    "Makanan Pendamping ASI (MP-ASI) Bubuk Instan (130202)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5255,
    "Makanan Pendamping ASI (MP-ASI) Bubuk Instan (130202)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5256,
    "Makanan Pendamping ASI (MP-ASI) Bubuk Instan (130202)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5257,
    "Makanan Pendamping ASI (MP-ASI) Bubuk Instan (130202)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5258,
    "Makanan Pendamping ASI (MP-ASI) Bubuk Instan (130202)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5259,
    "Makanan Pendamping ASI (MP-ASI) Bubuk Instan (130202)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5260,
    "Makanan Pendamping ASI (MP-ASI) Bubuk Instan (130202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5261,
    "Makanan Pendamping ASI (MP-ASI) Bubuk Instan (130202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5262,
    "Makanan Pendamping ASI (MP-ASI) Bubuk Instan (130202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5263,
    "Makanan Pendamping ASI (MP-ASI) Bubuk Instan (130202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5264,
    "Makanan Pendamping ASI (MP-ASI) Bubuk Instan (130202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5265,
    "Makanan Pendamping ASI (MP-ASI) Siap Masak (130204)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5266,
    "Makanan Pendamping ASI (MP-ASI) Siap Masak (130204)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5267,
    "Makanan Pendamping ASI (MP-ASI) Siap Masak (130204)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5268,
    "Makanan Pendamping ASI (MP-ASI) Siap Masak (130204)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5269,
    "Makanan Pendamping ASI (MP-ASI) Siap Masak (130204)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5270,
    "Makanan Pendamping ASI (MP-ASI) Siap Masak (130204)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5271,
    "Makanan Pendamping ASI (MP-ASI) Siap Masak (130204)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5272,
    "Makanan Pendamping ASI (MP-ASI) Siap Masak (130204)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5273,
    "Makanan Pendamping ASI (MP-ASI) Siap Masak (130204)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5274,
    "Makanan Pendamping ASI (MP-ASI) Siap Masak (130204)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5275,
    "Makanan Pendamping ASI (MP-ASI) Siap Masak (130204)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5276,
    "Makanan Pendamping ASI (MP-ASI) Siap Masak (130204)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5277,
    "Makanan Pendamping ASI (MP-ASI) Siap Masak (130204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5278,
    "Makanan Pendamping ASI (MP-ASI) Siap Masak (130204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5279,
    "Makanan Pendamping ASI (MP-ASI) Siap Masak (130204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5280,
    "Makanan Pendamping ASI (MP-ASI) Siap Masak (130204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5281,
    "Makanan Pendamping ASI (MP-ASI) Siap Masak (130204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5282,
    "Makanan Pendamping ASI (MP-ASI) Siap Santap (130203)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5283,
    "Makanan Pendamping ASI (MP-ASI) Siap Santap (130203)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5284,
    "Makanan Pendamping ASI (MP-ASI) Siap Santap (130203)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5285,
    "Makanan Pendamping ASI (MP-ASI) Siap Santap (130203)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5286,
    "Makanan Pendamping ASI (MP-ASI) Siap Santap (130203)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5287,
    "Makanan Pendamping ASI (MP-ASI) Siap Santap (130203)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5288,
    "Makanan Pendamping ASI (MP-ASI) Siap Santap (130203)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5289,
    "Makanan Pendamping ASI (MP-ASI) Siap Santap (130203)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5290,
    "Makanan Pendamping ASI (MP-ASI) Siap Santap (130203)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5291,
    "Makanan Pendamping ASI (MP-ASI) Siap Santap (130203)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5292,
    "Makanan Pendamping ASI (MP-ASI) Siap Santap (130203)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5293,
    "Makanan Pendamping ASI (MP-ASI) Siap Santap (130203)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5294,
    "Makanan Pendamping ASI (MP-ASI) Siap Santap (130203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5295,
    "Makanan Pendamping ASI (MP-ASI) Siap Santap (130203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5296,
    "Makanan Pendamping ASI (MP-ASI) Siap Santap (130203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5297,
    "Makanan Pendamping ASI (MP-ASI) Siap Santap (130203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5298,
    "Makanan Pendamping ASI (MP-ASI) Siap Santap (130203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5299,
    "Makanan Ringan Berbahan Dasar Kacang (150215)",
    "Salmonella (/25 g)",
  ],
  [
    5300,
    "Makanan Ringan Berbahan Dasar Kacang (150215)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5301,
    "Makanan Ringan Berbasis Ikan, dll (150308)",
    "Salmonella (/25 g)",
  ],
  [
    5302,
    "Makanan Ringan Berbasis Ikan, dll (150308)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5303,
    "Makanan Ringan Berbasis Ikan, dll (150308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5304,
    "Makanan Ringan Berbasis Ikan, dll (150308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5305,
    "Makanan Ringan Berbasis Ikan, dll (150308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5306,
    "Makanan Ringan Berbasis Ikan, dll (150308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5307,
    "Makanan Ringan Berbasis Ikan, dll (150308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5308,
    "Makanan Ringan Berbentuk Batang/Bar (150140)",
    "Salmonella (/25 g)",
  ],
  [
    5309,
    "Makanan Ringan Berbentuk Batang/Bar (150140)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    5310,
    "Makanan Ringan Berbentuk Batang/Bar (150140)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5311,
    "Makanan Ringan Berbentuk Batang/Bar (150140)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5312,
    "Makanan Ringan Berbentuk Batang/Bar (150140)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5313,
    "Makanan Ringan Berbentuk Batang/Bar (150140)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5314,
    "Makanan Ringan Berbentuk Batang/Bar (150140)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5315,
    "Makanan Ringan Ekstrudat (150129 )",
    "Salmonella (/25 g)",
  ],
  [
    5316,
    "Makanan Ringan Ekstrudat (150129 )",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5317,
    "Makanan Ringan Ekstrudat (150129 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5318,
    "Makanan Ringan Ekstrudat (150129 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5319,
    "Makanan Ringan Ekstrudat (150129 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5320,
    "Makanan Ringan Ekstrudat (150129 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5321,
    "Makanan Ringan Ekstrudat (150129 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [5322, "Makanan Ringan Lain (150133)", "Salmonella (/25 g)"],
  [
    5323,
    "Makanan Ringan Lain (150133)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5324,
    "Makanan Ringan Lain (150133)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5325,
    "Makanan Ringan Lain (150133)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5326,
    "Makanan Ringan Lain (150133)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5327,
    "Makanan Ringan Lain (150133)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5328,
    "Makanan Ringan Lain (150133)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [5329, "Makanan Ringan Simulasi (150113)", "Salmonella (/25 g)"],
  [
    5330,
    "Makanan Ringan Simulasi (150113)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5331,
    "Makanan Ringan Simulasi (150113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5332,
    "Makanan Ringan Simulasi (150113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5333,
    "Makanan Ringan Simulasi (150113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5334,
    "Makanan Ringan Simulasi (150113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5335,
    "Makanan Ringan Simulasi (150113)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5336,
    "Makanan Siap Saji Berbasis Kentang (Terkemas) (1678)",
    "Salmonella (/25 g)",
  ],
  [
    5337,
    "Makanan Siap Saji Berbasis Kentang (Terkemas) (1678)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    5338,
    "Makanan Siap Saji Berbasis Kentang (Terkemas) (1678)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5339,
    "Makanan Siap Saji Berbasis Kentang (Terkemas) (1678)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5340,
    "Makanan Siap Saji Berbasis Kentang (Terkemas) (1678)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5341,
    "Makanan Siap Saji Berbasis Kentang (Terkemas) (1678)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5342,
    "Makanan Siap Saji Berbasis Kentang (Terkemas) (1678)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5343,
    "Makanan Siap Saji Berbasis Kentang (Terkemas) (1678)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    5344,
    "Makanan Siap Saji Berbasis Kentang (Terkemas) (1678)",
    "Jumlah Sampel - Listeria monocytogenes",
    "",
    "\x{2265}5",
  ],
  [
    5345,
    "Makanan Siap Saji Berbasis Kuah (Terkemas) (1682)",
    "Salmonella (/25 g)",
  ],
  [
    5346,
    "Makanan Siap Saji Berbasis Kuah (Terkemas) (1682)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    5347,
    "Makanan Siap Saji Berbasis Kuah (Terkemas) (1682)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5348,
    "Makanan Siap Saji Berbasis Kuah (Terkemas) (1682)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5349,
    "Makanan Siap Saji Berbasis Kuah (Terkemas) (1682)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5350,
    "Makanan Siap Saji Berbasis Kuah (Terkemas) (1682)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5351,
    "Makanan Siap Saji Berbasis Kuah (Terkemas) (1682)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5352,
    "Makanan Siap Saji Berbasis Kuah (Terkemas) (1682)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    5353,
    "Makanan Siap Saji Berbasis Kuah (Terkemas) (1682)",
    "Jumlah Sampel - Listeria monocytogenes",
    "",
    "\x{2265}5",
  ],
  [
    5354,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas) (1677)",
    "Salmonella (/25 g)",
  ],
  [
    5355,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas) (1677)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    5356,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas) (1677)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5357,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas) (1677)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5358,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas) (1677)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5359,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas) (1677)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5360,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas) (1677)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5361,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas) (1677)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    5362,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas) (1677)",
    "Jumlah Sampel - Listeria monocytogenes",
    "",
    "\x{2265}5",
  ],
  [
    5363,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Salmonella (/25 g)",
  ],
  [
    5364,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    5365,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5366,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5367,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5368,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5369,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5370,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Jumlah Sampel - Listeria monocytogenes",
    "",
    "\x{2265}5",
  ],
  [
    5371,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    5372,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    5373,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    5374,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    5375,
    "Makanan Siap Saji Berbasis Nasi (Terkemas) (1676)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    5376,
    "Makanan Siap Saji Berbasis Pasta (Terkemas) (1679)",
    "Salmonella (/25 g)",
  ],
  [
    5377,
    "Makanan Siap Saji Berbasis Pasta (Terkemas) (1679)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    5378,
    "Makanan Siap Saji Berbasis Pasta (Terkemas) (1679)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5379,
    "Makanan Siap Saji Berbasis Pasta (Terkemas) (1679)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5380,
    "Makanan Siap Saji Berbasis Pasta (Terkemas) (1679)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5381,
    "Makanan Siap Saji Berbasis Pasta (Terkemas) (1679)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5382,
    "Makanan Siap Saji Berbasis Pasta (Terkemas) (1679)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5383,
    "Makanan Siap Saji Berbasis Pasta (Terkemas) (1679)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    5384,
    "Makanan Siap Saji Berbasis Pasta (Terkemas) (1679)",
    "Jumlah Sampel - Listeria monocytogenes",
    "",
    "\x{2265}5",
  ],
  [
    5385,
    "Makanan Siap Saji Berbasis Roti (Terkemas) (1681)",
    "Salmonella (/25 g)",
  ],
  [
    5386,
    "Makanan Siap Saji Berbasis Roti (Terkemas) (1681)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    5387,
    "Makanan Siap Saji Berbasis Roti (Terkemas) (1681)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5388,
    "Makanan Siap Saji Berbasis Roti (Terkemas) (1681)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5389,
    "Makanan Siap Saji Berbasis Roti (Terkemas) (1681)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5390,
    "Makanan Siap Saji Berbasis Roti (Terkemas) (1681)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5391,
    "Makanan Siap Saji Berbasis Roti (Terkemas) (1681)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5392,
    "Makanan Siap Saji Berbasis Roti (Terkemas) (1681)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    5393,
    "Makanan Siap Saji Berbasis Roti (Terkemas) (1681)",
    "Jumlah Sampel - Listeria monocytogenes",
    "",
    "\x{2265}5",
  ],
  [
    5394,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas) (1683)",
    "Salmonella (/25 g)",
  ],
  [
    5395,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas) (1683)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    5396,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas) (1683)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5397,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas) (1683)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5398,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas) (1683)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5399,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas) (1683)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5400,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas) (1683)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5401,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas) (1683)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    5402,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas) (1683)",
    "Jumlah Sampel - Listeria monocytogenes",
    "",
    "\x{2265}5",
  ],
  [
    5403,
    "Makanan Siap Saji Berbasis Umbi (Terkemas) (1680)",
    "Salmonella (/25 g)",
  ],
  [
    5404,
    "Makanan Siap Saji Berbasis Umbi (Terkemas) (1680)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    5405,
    "Makanan Siap Saji Berbasis Umbi (Terkemas) (1680)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5406,
    "Makanan Siap Saji Berbasis Umbi (Terkemas) (1680)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5407,
    "Makanan Siap Saji Berbasis Umbi (Terkemas) (1680)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5408,
    "Makanan Siap Saji Berbasis Umbi (Terkemas) (1680)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5409,
    "Makanan Siap Saji Berbasis Umbi (Terkemas) (1680)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5410,
    "Makanan Siap Saji Berbasis Umbi (Terkemas) (1680)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    5411,
    "Makanan Siap Saji Berbasis Umbi (Terkemas) (1680)",
    "Jumlah Sampel - Listeria monocytogenes",
    "",
    "\x{2265}5",
  ],
  [5412, "Makaroni (06040202)", "Salmonella (/25 g)"],
  [5413, "Makaroni (06040202)", "Jumlah Sampel - Salmonella"],
  [5414, "Makaroni (06040302)", "Salmonella (/25 g)"],
  [5415, "Makaroni (06040302)", "Jumlah Sampel - Salmonella"],
  [5416, "Makaroni Instan (06040307)", "Salmonella (/25 g)"],
  [
    5417,
    "Makaroni Instan (06040307)",
    "Jumlah Sampel - Salmonella",
  ],
  [5418, "Malkist (07010204)", "Salmonella (/25 g)"],
  [5419, "Malkist (07010204)", "Jumlah Sampel - Salmonella"],
  [
    5420,
    "Malkist (07010204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5421,
    "Malkist (07010204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5422,
    "Malkist (07010204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5423,
    "Malkist (07010204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5424,
    "Malkist (07010204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [5425, "Malkist (150137)", "Salmonella (/25 g)"],
  [
    5426,
    "Malkist (150137)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    5427,
    "Malkist (150137)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5428,
    "Malkist (150137)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5429,
    "Malkist (150137)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5430,
    "Malkist (150137)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5431,
    "Malkist (150137)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [5432, "Manjyu (07010508)", "Salmonella (/25 g)"],
  [5433, "Manjyu (07010508)", "Jumlah Sampel - Salmonella"],
  [5434, "Mantao (07010501)", "Salmonella (/25 g)"],
  [5435, "Mantao (07010501)", "Jumlah Sampel - Salmonella"],
  [5436, "Margarin (02020205)", "Jumlah Sampel - Salmonella"],
  [5437, "Margarin (02020205)", "Salmonella (/25 g)"],
  [
    5438,
    "Margarin (02020205)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5439,
    "Margarin (02020205)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5440,
    "Margarin (02020205)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5441,
    "Margarin (02020205)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5442,
    "Margarin (02020205)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5443,
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020203)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5444,
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020203)",
    "Salmonella (/25 g)",
  ],
  [
    5445,
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020203)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5446,
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020203)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5447,
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020203)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5448,
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020203)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5449,
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound (02020203)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [5450, "Margarin Meja (02020207)", "Jumlah Sampel - Salmonella"],
  [5451, "Margarin Meja (02020207)", "Salmonella (/25 g)"],
  [
    5452,
    "Margarin Meja (02020207)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5453,
    "Margarin Meja (02020207)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5454,
    "Margarin Meja (02020207)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5455,
    "Margarin Meja (02020207)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5456,
    "Margarin Meja (02020207)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [5457, "Marjoram (12020177)", "Salmonella (/25 g)"],
  [5458, "Marjoram (12020177)", "Jumlah Sampel - Salmonella"],
  [5459, "Marshmallow (05020208)", "Salmonella (Kembang"],
  [5460, "Gula/Permen"],
  [5461, "Lunak (bukan jeli)"],
  [5462, ") (/25 g)"],
  [5463, "Marshmallow (05020208)", "Jumlah Sampel - Salmonella"],
  [5464, "Marshmallow (05020208)", "Jumlah Sampel - Salmonella"],
  [
    5465,
    "Marshmallow (05020208)",
    "Salmonella (Kembang Gula/Permen Lunak (jeli)) (/25 g)",
  ],
  [5466, "Martabak Telur (100405)", "Salmonella (/25 g)"],
  [5467, "Martabak Telur (100405)", "Jumlah Sampel - Salmonella"],
  [
    5468,
    "Martabak Telur (100405)",
    "Jumlah Sampel -Listeria monocytogenes",
  ],
  [
    5469,
    "Martabak Telur (100405)",
    "Listeria monocytogenes (koloni/25 g) - Khusus Produk Beku",
  ],
  [
    5470,
    "Marzipan, Almond Paste (05020306)",
    "Salmonella (/25 g)",
  ],
  [
    5471,
    "Marzipan, Almond Paste (05020306)",
    "Jumlah Sampel - Salmonella",
  ],
  [5472, "Masin (09020521)", "Salmonella (/25 g)"],
  [5473, "Masin (09020521)", "Jumlah Sampel - Salmonella"],
  [5474, "Mayonais, Mayonnaise (12060101)", "Salmonella (/25 g)"],
  [
    5475,
    "Mayonais, Mayonnaise (12060101)",
    "Jumlah Sampel - Salmonella",
  ],
  [5476, "Meal (060303)", "Salmonella (/25 g)"],
  [5477, "Meal (060303)", "Jumlah Sampel - Salmonella"],
  [
    5478,
    "Meal (060303)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5479,
    "Meal (060303)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5480,
    "Meal (060303)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5481,
    "Meal (060303)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5482,
    "Meal (060303)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5483,
    "Meal Lembaga Gandum (Wheat Germ Meal) (060304)",
    "Salmonella (/25 g)",
  ],
  [
    5484,
    "Meal Lembaga Gandum (Wheat Germ Meal) (060304)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5485,
    "Meal Lembaga Gandum (Wheat Germ Meal) (060304)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5486,
    "Meal Lembaga Gandum (Wheat Germ Meal) (060304)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5487,
    "Meal Lembaga Gandum (Wheat Germ Meal) (060304)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5488,
    "Meal Lembaga Gandum (Wheat Germ Meal) (060304)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5489,
    "Meal Lembaga Gandum (Wheat Germ Meal) (060304)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5490,
    "Melorin atau Non-Dairy Ice Cream (020401)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5491,
    "Melorin atau Non-Dairy Ice Cream (020401)",
    "Salmonella (/25 g)",
  ],
  [5492, "Mentega (0202010101)", "Jumlah Sampel - Salmonella"],
  [5493, "Mentega (0202010101)", "Salmonella (/25 g)"],
  [
    5494,
    "Mentega (0202010101)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5495,
    "Mentega (0202010101)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5496,
    "Mentega (0202010101)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5497,
    "Mentega (0202010101)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5498,
    "Mentega (0202010101)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5499,
    "Mentega Rekombinasi (0202010102)",
    "Jumlah Sampel - Salmonella",
  ],
  [5500, "Mentega Rekombinasi (0202010102)", "Salmonella (/25 g)"],
  [
    5501,
    "Mentega Rekombinasi (0202010102)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5502,
    "Mentega Rekombinasi (0202010102)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5503,
    "Mentega Rekombinasi (0202010102)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5504,
    "Mentega Rekombinasi (0202010102)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5505,
    "Mentega Rekombinasi (0202010102)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5506,
    "Meses Susu/Cokelat Susu Butir/Cokelat Susu Vermicelli (05010432)",
    "Salmonella (/25 g)",
  ],
  [
    5507,
    "Meses Susu/Cokelat Susu Butir/Cokelat Susu Vermicelli (05010432)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    5508,
    "Meses/Cokelat Butir/Cokelat Vermicelli/Streusel (05010416)",
    "Salmonella (/25 g)",
  ],
  [
    5509,
    "Meses/Cokelat Butir/Cokelat Vermicelli/Streusel (05010416)",
    "Jumlah Sampel - Salmonella",
  ],
  [5510, "Mesoyi (120201A6)", "Salmonella (/25 g)"],
  [5511, "Mesoyi (120201A6)", "Jumlah Sampel - Salmonella"],
  [5512, "Mi Basah Matang (06040308)", "Salmonella (/25 g)"],
  [
    5513,
    "Mi Basah Matang (06040308)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5514,
    "Mi Basah Matang (06040308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5515,
    "Mi Basah Matang (06040308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5516,
    "Mi Basah Matang (06040308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5517,
    "Mi Basah Matang (06040308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5518,
    "Mi Basah Matang (06040308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5519,
    "Mi Basah Matang Lainnya (06040316)",
    "Salmonella (/25 g)",
  ],
  [
    5520,
    "Mi Basah Matang Lainnya (06040316)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5521,
    "Mi Basah Matang Lainnya (06040316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5522,
    "Mi Basah Matang Lainnya (06040316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5523,
    "Mi Basah Matang Lainnya (06040316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5524,
    "Mi Basah Matang Lainnya (06040316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5525,
    "Mi Basah Matang Lainnya (06040316)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [5526, "Mi Basah Mentah (06040101)", "Salmonella (/25 g)"],
  [
    5527,
    "Mi Basah Mentah (06040101)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5528,
    "Mi Basah Mentah (06040101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5529,
    "Mi Basah Mentah (06040101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5530,
    "Mi Basah Mentah (06040101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5531,
    "Mi Basah Mentah (06040101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5532,
    "Mi Basah Mentah (06040101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5533,
    "Mi Basah Mentah lainnya (06040104)",
    "Salmonella (/25 g)",
  ],
  [
    5534,
    "Mi Basah Mentah lainnya (06040104)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5535,
    "Mi Basah Mentah lainnya (06040104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5536,
    "Mi Basah Mentah lainnya (06040104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5537,
    "Mi Basah Mentah lainnya (06040104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5538,
    "Mi Basah Mentah lainnya (06040104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5539,
    "Mi Basah Mentah lainnya (06040104)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [5540, "Mi Instan (06040309)", "Salmonella (/25 g)"],
  [5541, "Mi Instan (06040309)", "Jumlah Sampel - Salmonella"],
  [5542, "Mi Instan Lainnya (06040310)", "Salmonella (/25 g)"],
  [
    5543,
    "Mi Instan Lainnya (06040310)",
    "Jumlah Sampel - Salmonella",
  ],
  [5544, "Mi Kering Gandum (06040303)", "Salmonella (/25 g)"],
  [
    5545,
    "Mi Kering Gandum (06040303)",
    "Jumlah Sampel - Salmonella",
  ],
  [5546, "Mi Kering Lainnya (06040304)", "Salmonella (/25 g)"],
  [
    5547,
    "Mi Kering Lainnya (06040304)",
    "Jumlah Sampel - Salmonella",
  ],
  [5548, "Mi Soa (06040322)", "Salmonella (/25 g)"],
  [5549, "Mi Soa (06040322)", "Jumlah Sampel - Salmonella"],
  [
    5550,
    "Minarin Meja atau Halvarine (02020209)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5551,
    "Minarin Meja atau Halvarine (02020209)",
    "Salmonella (/25 g)",
  ],
  [
    5552,
    "Minarin Meja atau Halvarine (02020209)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5553,
    "Minarin Meja atau Halvarine (02020209)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5554,
    "Minarin Meja atau Halvarine (02020209)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5555,
    "Minarin Meja atau Halvarine (02020209)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5556,
    "Minarin Meja atau Halvarine (02020209)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [5557, "Mint (12020178)", "Salmonella (/25 g)"],
  [5558, "Mint (12020178)", "Jumlah Sampel - Salmonella"],
  [
    5559,
    "Minuman Berbasis Whey (Berperisa/Rasa) (01010407)",
    "Salmonella (/25 g)",
  ],
  [
    5560,
    "Minuman Berbasis Whey (Berperisa/Rasa) (01010407)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    5561,
    "Minuman Cokelat Paduan (Bubuk) (05010509)",
    "Salmonella (/25 g)",
  ],
  [
    5562,
    "Minuman Cokelat Paduan (Bubuk) (05010509)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5563,
    "Minuman Elektrolit Tidak Berkarbonat (1401040215)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    5564,
    "Minuman Elektrolit Tidak Berkarbonat (1401040215)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    5565,
    "Minuman Elektrolit Tidak Berkarbonat (1401040215)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    5566,
    "Minuman Elektrolit Tidak Berkarbonat (1401040215)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    5567,
    "Minuman Elektrolit Tidak Berkarbonat (1401040215)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    5568,
    "Minuman Ibu Hamil dan atau Ibu Menyusui (130502)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5569,
    "Minuman Ibu Hamil dan atau Ibu Menyusui (130502)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5570,
    "Minuman Ibu Hamil dan atau Ibu Menyusui (130502)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5571,
    "Minuman Ibu Hamil dan atau Ibu Menyusui (130502)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5572,
    "Minuman Ibu Hamil dan atau Ibu Menyusui (130502)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5573,
    "Minuman Ibu Hamil dan atau Ibu Menyusui (130502)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5574,
    "Minuman Ibu Hamil dan atau Ibu Menyusui (130502)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5575,
    "Minuman Ibu Hamil dan atau Ibu Menyusui (130502)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5576,
    "Minuman Ibu Hamil dan atau Ibu Menyusui (130502)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5577,
    "Minuman Ibu Hamil dan atau Ibu Menyusui (130502)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5578,
    "Minuman Ibu Hamil dan atau Ibu Menyusui (130502)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5579,
    "Minuman Ibu Hamil dan atau Ibu Menyusui (130502)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5580,
    "Minuman Ibu Hamil dan atau Ibu Menyusui (130502)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5581,
    "Minuman Ibu Hamil dan atau Ibu Menyusui (130502)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5582,
    "Minuman Ibu Hamil dan atau Ibu Menyusui (130502)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5583,
    "Minuman Ibu Hamil dan atau Ibu Menyusui (130502)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5584,
    "Minuman Ibu Hamil dan atau Ibu Menyusui (130502)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5585,
    "Minuman Isotonik Tidak Berkarbonat (1401040217)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    5586,
    "Minuman Isotonik Tidak Berkarbonat (1401040217)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    5587,
    "Minuman Isotonik Tidak Berkarbonat (1401040217)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    5588,
    "Minuman Isotonik Tidak Berkarbonat (1401040217)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    5589,
    "Minuman Isotonik Tidak Berkarbonat (1401040217)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    5590,
    "Minuman Mengandung Susu (Cair) (Plain) (01010202)",
    "Salmonella (/25 ml)",
  ],
  [
    5591,
    "Minuman Mengandung Susu (Cair) (Plain) (01010202)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5592,
    "Minuman Mengandung Susu (Serbuk) (01010210)",
    "Salmonella (/25 ml)",
  ],
  [
    5593,
    "Minuman Mengandung Susu (Serbuk) (01010210)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5594,
    "Minuman Mengandung Susu Bubuk (Plain) (01050112)",
    "Salmonella (/25 g)",
  ],
  [
    5595,
    "Minuman Mengandung Susu Bubuk (Plain) (01050112)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    5596,
    "Minuman Mengandung Susu Bubuk (Plain) (01050112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5597,
    "Minuman Mengandung Susu Bubuk (Plain) (01050112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5598,
    "Minuman Mengandung Susu Bubuk (Plain) (01050112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5599,
    "Minuman Mengandung Susu Bubuk (Plain) (01050112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5600,
    "Minuman Mengandung Susu Bubuk (Plain) (01050112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5601,
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa) (01010415)",
    "Salmonella (/25 g)",
  ],
  [
    5602,
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa) (01010415)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    5603,
    "Minuman Ringan (Plain) (1401040252)",
    "Pseudomonas aeruginosa (/250 ml)",
  ],
  [
    5604,
    "Minuman Ringan (Plain) (1401040252)",
    "Jumlah Sampel - Pseudomonas aeruginosa",
  ],
  [
    5605,
    "Minuman Susu Evaporasi (Plain dan Berperisa) (01010209)",
    "Salmonella (/25 ml)",
  ],
  [
    5606,
    "Minuman Susu Evaporasi (Plain dan Berperisa) (01010209)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5607,
    "Minuman Susu Fermentasi (Plain) (01010203)",
    "Salmonella (/25 ml)",
  ],
  [
    5608,
    "Minuman Susu Fermentasi (Plain) (01010203)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5609,
    "Minuman Susu Fermentasi Berperisa/Rasa (01010405)",
    "Salmonella (/25 g)",
  ],
  [
    5610,
    "Minuman Susu Fermentasi Berperisa/Rasa (01010405)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    5611,
    "Minuman Susu Pasteurisasi (Plain) (01010208)",
    "Salmonella (/25 ml)",
  ],
  [
    5612,
    "Minuman Susu Pasteurisasi (Plain) (01010208)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5613,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5614,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5615,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5616,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5617,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5618,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5619,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5620,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5621,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5622,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5623,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5624,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5625,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5626,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5627,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5628,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5629,
    "Minuman untuk Ibu Hamil Bubuk (13050106)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5630,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5631,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5632,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5633,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5634,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5635,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5636,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5637,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5638,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5639,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    5640,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5641,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5642,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5643,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5644,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5645,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5646,
    "Minuman untuk Ibu Menyusui Bubuk (13050103)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5647,
    "Minuman Yogurt (Plain dan Berperisa) (01010204)",
    "Salmonella (/25 ml)",
  ],
  [
    5648,
    "Minuman Yogurt (Plain dan Berperisa) (01010204)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5649,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5650,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5651,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5652,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5653,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5654,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5655,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5656,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5657,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5658,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5659,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5660,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5661,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5662,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5663,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5664,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5665,
    "MP ASI Kudapan usia 6 sampai 12 bulan Cair (1318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5666,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5667,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5668,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5669,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5670,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5671,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5672,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5673,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5674,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5675,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5676,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5677,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5678,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    5679,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    5680,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    5681,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    5682,
    "MP ASI Kudapan usia 6 sampai 12 bulan Padat (1317)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    5683,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5684,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5685,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5686,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5687,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5688,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5689,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5690,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5691,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5692,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5693,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5694,
    "MP ASI Kudapan usia sampai 2 tahun Cair (1320)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5695,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5696,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5697,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5698,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5699,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5700,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5701,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5702,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5703,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5704,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5705,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5706,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5707,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
  ],
  [
    5708,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
  ],
  [
    5709,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
  ],
  [
    5710,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
  ],
  [
    5711,
    "MP ASI Kudapan usia sampai 2 tahun Padat (1319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
  ],
  [
    5712,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5713,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5714,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5715,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5716,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5717,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5718,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5719,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5720,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5721,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5722,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5723,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5724,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5725,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5726,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5727,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5728,
    "MP ASI Pokok usia 6 sampai 12 bulan Cair (1314)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    "\x{2264}0",
  ],
  [
    5729,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5730,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5731,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5732,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5733,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5734,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5735,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5736,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5737,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5738,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5739,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5740,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5741,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    5742,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    5743,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    5744,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    5745,
    "MP ASI Pokok usia 6 sampai 12 bulan Padat (1313)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}10",
  ],
  [
    5746,
    "MP ASI Pokok usia sampai 2 tahun Cair (1316)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5747,
    "MP ASI Pokok usia sampai 2 tahun Cair (1316)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5748,
    "MP ASI Pokok usia sampai 2 tahun Cair (1316)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5749,
    "MP ASI Pokok usia sampai 2 tahun Cair (1316)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5750,
    "MP ASI Pokok usia sampai 2 tahun Cair (1316)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    5751,
    "MP ASI Pokok usia sampai 2 tahun Cair (1316)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5752,
    "MP ASI Pokok usia sampai 2 tahun Cair (1316)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5753,
    "MP ASI Pokok usia sampai 2 tahun Cair (1316)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5754,
    "MP ASI Pokok usia sampai 2 tahun Cair (1316)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5755,
    "MP ASI Pokok usia sampai 2 tahun Cair (1316)",
    "Koliform (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    5756,
    "MP ASI Pokok usia sampai 2 tahun Cair (1316)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5757,
    "MP ASI Pokok usia sampai 2 tahun Cair (1316)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5758,
    "MP ASI Pokok usia sampai 2 tahun Padat (1315)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5759,
    "MP ASI Pokok usia sampai 2 tahun Padat (1315)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5760,
    "MP ASI Pokok usia sampai 2 tahun Padat (1315)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5761,
    "MP ASI Pokok usia sampai 2 tahun Padat (1315)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5762,
    "MP ASI Pokok usia sampai 2 tahun Padat (1315)",
    "ALT (koloni/g)",
    "\x{2264}10000",
    "\x{2264}3000",
  ],
  [
    5763,
    "MP ASI Pokok usia sampai 2 tahun Padat (1315)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5764,
    "MP ASI Pokok usia sampai 2 tahun Padat (1315)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5765,
    "MP ASI Pokok usia sampai 2 tahun Padat (1315)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5766,
    "MP ASI Pokok usia sampai 2 tahun Padat (1315)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5767,
    "MP ASI Pokok usia sampai 2 tahun Padat (1315)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    5768,
    "MP ASI Pokok usia sampai 2 tahun Padat (1315)",
    "Salmonella (koloni/25 g)",
  ],
  [
    5769,
    "MP ASI Pokok usia sampai 2 tahun Padat (1315)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5770,
    "MP ASI Pokok usia sampai 2 tahun Padat (1315)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    ">0",
  ],
  [
    5771,
    "MP ASI Pokok usia sampai 2 tahun Padat (1315)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    ">0",
  ],
  [
    5772,
    "MP ASI Pokok usia sampai 2 tahun Padat (1315)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    ">0",
  ],
  [
    5773,
    "MP ASI Pokok usia sampai 2 tahun Padat (1315)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    ">0",
  ],
  [
    5774,
    "MP ASI Pokok usia sampai 2 tahun Padat (1315)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10",
    ">0",
  ],
  [
    5775,
    "Muffin Amerika (American Muffin) (07020206)",
    "Salmonella (/25 g)",
  ],
  [
    5776,
    "Muffin Amerika (American Muffin) (07020206)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5777,
    "Muffin Amerika (American Muffin) (07020206)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    5778,
    "Muffin Amerika (American Muffin) (07020206)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    5779,
    "Muffin Amerika (American Muffin) (07020206)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    5780,
    "Muffin Amerika (American Muffin) (07020206)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    5781,
    "Muffin Amerika (American Muffin) (07020206)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    5782,
    "Muffin Inggris (English Muffin) (07010304)",
    "Salmonella (/25 g)",
  ],
  [
    5783,
    "Muffin Inggris (English Muffin) (07010304)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5784,
    "Musipan (060503)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5785,
    "Musipan (060503)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5786,
    "Musipan (060503)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5787,
    "Musipan (060503)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5788,
    "Musipan (060503)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [5789, "Musipan (060503)", "Salmonella (/25 g)"],
  [5790, "Musipan (060503)", "Jumlah Sampel - Salmonella"],
  [
    5791,
    "Musipan (060503)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5792,
    "Musipan (060503)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5793,
    "Musipan (060503)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5794,
    "Musipan (060503)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5795,
    "Musipan (060503)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [5796, "Mustard (1204)", "Salmonella (koloni/25 g)"],
  [5797, "Mustard (1204)", "Salmonella (koloni/25 g)"],
  [5798, "Mustard (1204)", "Jumlah Sampel - Salmonella"],
  [5799, "Mustard (1204)", "Jumlah Sampel - Salmonella"],
  [
    5800,
    "Nagamishi (060504)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5801,
    "Nagamishi (060504)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5802,
    "Nagamishi (060504)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5803,
    "Nagamishi (060504)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5804,
    "Nagamishi (060504)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [5805, "Nagamishi (060504)", "Salmonella (/25 g)"],
  [5806, "Nagamishi (060504)", "Jumlah Sampel - Salmonella"],
  [
    5807,
    "Nagamishi (060504)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5808,
    "Nagamishi (060504)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5809,
    "Nagamishi (060504)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5810,
    "Nagamishi (060504)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5811,
    "Nagamishi (060504)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5812,
    "Nagasari/Kue Pisang (060705)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5813,
    "Nagasari/Kue Pisang (060705)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5814,
    "Nagasari/Kue Pisang (060705)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5815,
    "Nagasari/Kue Pisang (060705)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5816,
    "Nagasari/Kue Pisang (060705)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [5817, "Nagasari/Kue Pisang (060705)", "Salmonella (/25 g)"],
  [
    5818,
    "Nagasari/Kue Pisang (060705)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5819,
    "Nagasari/Kue Pisang (060705)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5820,
    "Nagasari/Kue Pisang (060705)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5821,
    "Nagasari/Kue Pisang (060705)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5822,
    "Nagasari/Kue Pisang (060705)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5823,
    "Nagasari/Kue Pisang (060705)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [5824, "Naget Ayam (08030321)", "Salmonella (koloni/25 ml)"],
  [5825, "Naget Ayam (08030321)", "Jumlah Sampel - Salmonella"],
  [
    5826,
    "Naget Ayam (08030321)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5827,
    "Naget Ayam (08030321)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5828,
    "Naget Ayam (08030321)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5829,
    "Naget Ayam (08030321)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5830,
    "Naget Ayam (08030321)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5831,
    "Naget Ayam (08030321)",
    "Listeria monocytogenes (/25 g)",
  ],
  [
    5832,
    "Naget Ayam (08030321)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [
    5833,
    "Naget Ayam Kombinasi (08030306)",
    "Salmonella (koloni/25 ml)",
  ],
  [
    5834,
    "Naget Ayam Kombinasi (08030306)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5835,
    "Naget Ayam Kombinasi (08030306)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5836,
    "Naget Ayam Kombinasi (08030306)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5837,
    "Naget Ayam Kombinasi (08030306)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5838,
    "Naget Ayam Kombinasi (08030306)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5839,
    "Naget Ayam Kombinasi (08030306)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    5840,
    "Naget Ayam Kombinasi (08030306)",
    "Listeria monocytogenes (/25 g)",
  ],
  [
    5841,
    "Naget Ayam Kombinasi (08030306)",
    "Jumlah Sampel - Listeria monocytogenes",
  ],
  [5842, "Naget Daging Sapi (08030322)", "Salmonella (/25 g)"],
  [5843, "Naget Daging Sapi (08030322)", "Jumlah - Salmonella"],
  [
    5844,
    "Naget Daging Sapi (08030322)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5845,
    "Naget Daging Sapi (08030322)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5846,
    "Naget Daging Sapi (08030322)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5847,
    "Naget Daging Sapi (08030322)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5848,
    "Naget Daging Sapi (08030322)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5849,
    "Naget Daging Sapi (08030322)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    5850,
    "Naget Daging Sapi (08030322)",
    "Jumlah - Listeria monocytogenes",
  ],
  [
    5851,
    "Naget Daging Sapi Kombinasi (08030307)",
    "Salmonella (/25 g)",
  ],
  [
    5852,
    "Naget Daging Sapi Kombinasi (08030307)",
    "Jumlah - Salmonella",
  ],
  [
    5853,
    "Naget Daging Sapi Kombinasi (08030307)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5854,
    "Naget Daging Sapi Kombinasi (08030307)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5855,
    "Naget Daging Sapi Kombinasi (08030307)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5856,
    "Naget Daging Sapi Kombinasi (08030307)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5857,
    "Naget Daging Sapi Kombinasi (08030307)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5858,
    "Naget Daging Sapi Kombinasi (08030307)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    5859,
    "Naget Daging Sapi Kombinasi (08030307)",
    "Jumlah - Listeria monocytogenes",
  ],
  [
    5860,
    "Naget Ikan/Udang/Cumi/Kerang Beku (09020204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5861,
    "Naget Ikan/Udang/Cumi/Kerang Beku (09020204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5862,
    "Naget Ikan/Udang/Cumi/Kerang Beku (09020204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5863,
    "Naget Ikan/Udang/Cumi/Kerang Beku (09020204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5864,
    "Naget Ikan/Udang/Cumi/Kerang Beku (09020204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5865,
    "Naget Udang (09020205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5866,
    "Naget Udang (09020205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5867,
    "Naget Udang (09020205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5868,
    "Naget Udang (09020205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5869,
    "Naget Udang (09020205)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [5870, "Namagashi (0402020610)", "Salmonella (/25 g)"],
  [5871, "Namagashi (0402020610)", "Jumlah Sampel - Salmonella"],
  [
    5872,
    "Nasi Beku (06070101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5873,
    "Nasi Beku (06070101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5874,
    "Nasi Beku (06070101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5875,
    "Nasi Beku (06070101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5876,
    "Nasi Beku (06070101)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5877,
    "Nasi Beku (06070101)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5878,
    "Nasi Beku (06070101)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5879,
    "Nasi Beku (06070101)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5880,
    "Nasi Beku (06070101)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5881,
    "Nasi Beku (06070101)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [5882, "Nasi Instan (06040311)", "Salmonella (/25 g)"],
  [5883, "Nasi Instan (06040311)", "Jumlah Sampel - Salmonella"],
  [5884, "Nasi Jagung (060308)", "Salmonella (/25 g)"],
  [5885, "Nasi Jagung (060308)", "Jumlah Sampel - Salmonella"],
  [
    5886,
    "Nasi Jagung (060308)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5887,
    "Nasi Jagung (060308)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5888,
    "Nasi Jagung (060308)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5889,
    "Nasi Jagung (060308)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5890,
    "Nasi Jagung (060308)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [5891, "Nastar (07020134)", "Salmonella (/25 g)"],
  [5892, "Nastar (07020134)", "Jumlah Sampel - Salmonella"],
  [
    5893,
    "Nastar (07020134)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    5894,
    "Nastar (07020134)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    5895,
    "Nastar (07020134)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    5896,
    "Nastar (07020134)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    5897,
    "Nastar (07020134)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [5898, "Nata Dalam Kemasan (0401020902)", "Salmonella (/25 g)"],
  [
    5899,
    "Nata Dalam Kemasan (0401020902)",
    "Jumlah Sampel - Salmonella",
  ],
  [5900, "Natto (06080602)", "Salmonella (/25 g)"],
  [5901, "Natto (06080602)", "Jumlah Sampel - Salmonella"],
  [
    5902,
    "Non-Dairy Mousse (020402)",
    "Jumlah Sampel - Salmonella",
  ],
  [5903, "Non-Dairy Mousse (020402)", "Salmonella (/25 g)"],
  [
    5904,
    "Non-Dairy Toppings, Fillings, Frostings (020301)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5905,
    "Non-Dairy Toppings, Fillings, Frostings (020301)",
    "Salmonella (/25 g)",
  ],
  [
    5906,
    "Non-Dairy Toppings, Fillings, Frostings (020301)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5907,
    "Non-Dairy Toppings, Fillings, Frostings (020301)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5908,
    "Non-Dairy Toppings, Fillings, Frostings (020301)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5909,
    "Non-Dairy Toppings, Fillings, Frostings (020301)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5910,
    "Non-Dairy Toppings, Fillings, Frostings (020301)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [5911, "Non-Dairy Whipped Cream (020302)", "Salmonella (/25 g)"],
  [
    5912,
    "Non-Dairy Whipped Cream (020302)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5913,
    "Non-Dairy Whipped Cream (020302)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5914,
    "Non-Dairy Whipped Cream (020302)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5915,
    "Non-Dairy Whipped Cream (020302)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5916,
    "Non-Dairy Whipped Cream (020302)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    5917,
    "Non-Dairy Whipped Cream (020302)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [5918, "Nopia (07020217)", "Salmonella (/25 g)"],
  [5919, "Nopia (07020217)", "Jumlah Sampel - Salmonella"],
  [
    5920,
    "Nopia (07020217)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    5921,
    "Nopia (07020217)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    5922,
    "Nopia (07020217)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    5923,
    "Nopia (07020217)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    5924,
    "Nopia (07020217)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [5925, "Nougat (05020301)", "Salmonella (/25 g)"],
  [5926, "Nougat (05020301)", "Jumlah Sampel - Salmonella"],
  [5927, "Oatmeal (060305)", "Salmonella (/25 g)"],
  [5928, "Oatmeal (060305)", "Jumlah Sampel - Salmonella"],
  [
    5929,
    "Oatmeal (060305)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5930,
    "Oatmeal (060305)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5931,
    "Oatmeal (060305)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5932,
    "Oatmeal (060305)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5933,
    "Oatmeal (060305)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [5934, "Odading/Kue Bantal (07020124)", "Salmonella (/25 g)"],
  [
    5935,
    "Odading/Kue Bantal (07020124)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5936,
    "Odading/Kue Bantal (07020124)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    5937,
    "Odading/Kue Bantal (07020124)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    5938,
    "Odading/Kue Bantal (07020124)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    5939,
    "Odading/Kue Bantal (07020124)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    5940,
    "Odading/Kue Bantal (07020124)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [5941, "Okra yang Digoreng (0402020806)", "Salmonella (/25 g)"],
  [
    5942,
    "Okra yang Digoreng (0402020806)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5943,
    "Okra yang Digoreng (0402020806)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5944,
    "Okra yang Digoreng (0402020806)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5945,
    "Okra yang Digoreng (0402020806)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5946,
    "Okra yang Digoreng (0402020806)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5947,
    "Okra yang Digoreng (0402020806)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    5948,
    "Olahan Ikan Berbumbu (0902040122)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5949,
    "Olahan Ikan Berbumbu (0902040122)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5950,
    "Olahan Ikan Berbumbu (0902040122)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5951,
    "Olahan Ikan Berbumbu (0902040122)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5952,
    "Olahan Ikan Berbumbu (0902040122)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5953,
    "Olahan Ikan Dalam Kemasan (090419)",
    "Salmonella (/25 g)",
  ],
  [
    5954,
    "Olahan Ikan Dalam Kemasan (090419)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    5955,
    "Olahan Ikan Dalam Kemasan (090419)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    5956,
    "Olahan Ikan Dalam Kemasan (090419)",
    "Jumlah Sampel - Listeria monocytogenes",
    "\x{2265}",
  ],
  [
    5957,
    "Olahan Ikan dan Produk Perikanan Termasuk Moluska, Krustase, Ekinodermata Goreng atau Panggang (Oven atau Bara) (0902040308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5958,
    "Olahan Ikan dan Produk Perikanan Termasuk Moluska, Krustase, Ekinodermata Goreng atau Panggang (Oven atau Bara) (0902040308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5959,
    "Olahan Ikan dan Produk Perikanan Termasuk Moluska, Krustase, Ekinodermata Goreng atau Panggang (Oven atau Bara) (0902040308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5960,
    "Olahan Ikan dan Produk Perikanan Termasuk Moluska, Krustase, Ekinodermata Goreng atau Panggang (Oven atau Bara) (0902040308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5961,
    "Olahan Ikan dan Produk Perikanan Termasuk Moluska, Krustase, Ekinodermata Goreng atau Panggang (Oven atau Bara) (0902040308)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    5962,
    "Olesan Berbasis Kacang (0402020508)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5963,
    "Olesan Berbasis Kacang (0402020508)",
    "Salmonella (/25 g)",
  ],
  [
    5964,
    "Olesan Berbasis Kacang-Cokelat (Nut-Chocolate Based Spread) (05010302)",
    "Salmonella (/25 g)",
  ],
  [
    5965,
    "Olesan Berbasis Kacang-Cokelat (Nut-Chocolate Based Spread) (05010302)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5966,
    "Olesan Berbasis Sayur (0402020506)",
    "Salmonella (/25 g)",
  ],
  [
    5967,
    "Olesan Berbasis Sayur (0402020506)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    5968,
    "Olesan Cokelat Berbasis Air (Chocolate Water-Based Spread) (05010303)",
    "Salmonella (/25 g)",
  ],
  [
    5969,
    "Olesan Cokelat Berbasis Air (Chocolate Water-Based Spread) (05010303)",
    "Jumlah Sampel - Salmonella",
  ],
  [5970, "Olesan Kacang (0402020509)", "Salmonella (/25ml)"],
  [
    5971,
    "Olesan Kacang (0402020509)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    5972,
    "Olesan Mengandung Kacang (0402020510)",
    "Salmonella (/25ml)",
  ],
  [
    5973,
    "Olesan Mengandung Kacang (0402020510)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [5974, "Olesan/Saus (120703)", "Salmonella (/25 g)"],
  [5975, "Olesan/Saus (120703)", "Jumlah Sampel - Salmonella"],
  [5976, "Ombus-ombus (060734)", "Salmonella (/25 g)"],
  [
    5977,
    "Ombus-ombus (060734)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    5978,
    "Ombus-ombus (060734)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5979,
    "Ombus-ombus (060734)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5980,
    "Ombus-ombus (060734)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5981,
    "Ombus-ombus (060734)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5982,
    "Ombus-ombus (060734)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5983,
    "Ombus-ombus (060734)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5984,
    "Ombus-ombus (060734)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5985,
    "Ombus-ombus (060734)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5986,
    "Ombus-ombus (060734)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5987,
    "Ombus-ombus (060734)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5988,
    "Onde-Onde (060725)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5989,
    "Onde-Onde (060725)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5990,
    "Onde-Onde (060725)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5991,
    "Onde-Onde (060725)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    5992,
    "Onde-Onde (060725)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [5993, "Onde-Onde (060725)", "Salmonella (/25 g)"],
  [5994, "Onde-Onde (060725)", "Jumlah Sampel - Salmonella"],
  [
    5995,
    "Onde-Onde (060725)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5996,
    "Onde-Onde (060725)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5997,
    "Onde-Onde (060725)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5998,
    "Onde-Onde (060725)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    5999,
    "Onde-Onde (060725)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    6000,
    "Onion Bubuk/Bawang Bombay Bubuk (12020180)",
    "Salmonella (/25 g)",
  ],
  [
    6001,
    "Onion Bubuk/Bawang Bombay Bubuk (12020180)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6002,
    "Onion Bubuk/Bawang Bombay Bubuk (12020180)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6003,
    "Onion Bubuk/Bawang Bombay Bubuk (12020180)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6004,
    "Onion Bubuk/Bawang Bombay Bubuk (12020180)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6005,
    "Onion Bubuk/Bawang Bombay Bubuk (12020180)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6006,
    "Onion Bubuk/Bawang Bombay Bubuk (12020180)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6007,
    "Onion Bubuk/Bawang Bombay Bubuk (12020180)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6008,
    "Onion Bubuk/Bawang Bombay Bubuk (12020180)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6009,
    "Onion Bubuk/Bawang Bombay Bubuk (12020180)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6010,
    "Onion Bubuk/Bawang Bombay Bubuk (12020180)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6011,
    "Onion Bubuk/Bawang Bombay Bubuk (12020180)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [6012, "Onion/Bawang Bombay (12020179)", "Salmonella (/25 g)"],
  [
    6013,
    "Onion/Bawang Bombay (12020179)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6014,
    "Onion/Bawang Bombay (12020179)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6015,
    "Onion/Bawang Bombay (12020179)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6016,
    "Onion/Bawang Bombay (12020179)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6017,
    "Onion/Bawang Bombay (12020179)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6018,
    "Onion/Bawang Bombay (12020179)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6019,
    "Onion/Bawang Bombay (12020179)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6020,
    "Onion/Bawang Bombay (12020179)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6021,
    "Onion/Bawang Bombay (12020179)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6022,
    "Onion/Bawang Bombay (12020179)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6023,
    "Onion/Bawang Bombay (12020179)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [6024, "Opak (150115)", "Salmonella (/25 g)"],
  [6025, "Opak (150115)", "Jumlah Sampel - Salmonella"],
  [
    6026,
    "Opak (150115)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6027,
    "Opak (150115)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6028,
    "Opak (150115)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6029,
    "Opak (150115)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6030,
    "Opak (150115)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [6031, "Oregano (12020181)", "Salmonella (/25 g)"],
  [6032, "Oregano (12020181)", "Jumlah Sampel - Salmonella"],
  [
    6033,
    "Otak-Otak Ikan (0902040109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6034,
    "Otak-Otak Ikan (0902040109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6035,
    "Otak-Otak Ikan (0902040109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6036,
    "Otak-Otak Ikan (0902040109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6037,
    "Otak-Otak Ikan (0902040109)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6038,
    "Otak-Otak Ikan Analog/Produk ikan Analog (0902040118)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6039,
    "Otak-Otak Ikan Analog/Produk ikan Analog (0902040118)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6040,
    "Otak-Otak Ikan Analog/Produk ikan Analog (0902040118)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6041,
    "Otak-Otak Ikan Analog/Produk ikan Analog (0902040118)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6042,
    "Otak-Otak Ikan Analog/Produk ikan Analog (0902040118)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6043,
    "Otak-Otak Ikan/Moluska/Krustase/Ekinodermata Siap Santap (090415)",
    "Salmonella (/25 g)",
  ],
  [
    6044,
    "Otak-Otak Ikan/Moluska/Krustase/Ekinodermata Siap Santap (090415)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    6045,
    "Otak-Otak Ikan/Moluska/Krustase/Ekinodermata Siap Santap (090415)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    6046,
    "Otak-Otak Ikan/Moluska/Krustase/Ekinodermata Siap Santap (090415)",
    "Jumlah Sampel - Listeria monocytogenes",
    "\x{2265}",
  ],
  [6047, "Pai (07020136)", "Salmonella (/25 g)"],
  [6048, "Pai (07020136)", "Jumlah Sampel - Salmonella"],
  [
    6049,
    "Pai (07020136)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6050,
    "Pai (07020136)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6051,
    "Pai (07020136)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6052,
    "Pai (07020136)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6053,
    "Pai (07020136)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [6054, "Pai Isi (07020137)", "Salmonella (/25 g)"],
  [6055, "Pai Isi (07020137)", "Jumlah Sampel - Salmonella"],
  [
    6056,
    "Pai Isi (07020137)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6057,
    "Pai Isi (07020137)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6058,
    "Pai Isi (07020137)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6059,
    "Pai Isi (07020137)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6060,
    "Pai Isi (07020137)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [6061, "Pala (12020182)", "Salmonella (/25 g)"],
  [6062, "Pala (12020182)", "Jumlah Sampel - Salmonella"],
  [
    6063,
    "Pala (12020182)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6064,
    "Pala (12020182)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6065,
    "Pala (12020182)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6066,
    "Pala (12020182)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6067,
    "Pala (12020182)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6068,
    "Pala (12020182)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6069,
    "Pala (12020182)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6070,
    "Pala (12020182)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6071,
    "Pala (12020182)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6072,
    "Pala (12020182)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [6073, "Pala Bubuk (12020184)", "Salmonella (/25 g)"],
  [6074, "Pala Bubuk (12020184)", "Jumlah Sampel - Salmonella"],
  [
    6075,
    "Pala Bubuk (12020184)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6076,
    "Pala Bubuk (12020184)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6077,
    "Pala Bubuk (12020184)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6078,
    "Pala Bubuk (12020184)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6079,
    "Pala Bubuk (12020184)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6080,
    "Pala Bubuk (12020184)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6081,
    "Pala Bubuk (12020184)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6082,
    "Pala Bubuk (12020184)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6083,
    "Pala Bubuk (12020184)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6084,
    "Pala Bubuk (12020184)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [6085, "Pala Untuk Destilasi (12020183)", "Salmonella (/25 g)"],
  [
    6086,
    "Pala Untuk Destilasi (12020183)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6087,
    "Pala Untuk Destilasi (12020183)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6088,
    "Pala Untuk Destilasi (12020183)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6089,
    "Pala Untuk Destilasi (12020183)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6090,
    "Pala Untuk Destilasi (12020183)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6091,
    "Pala Untuk Destilasi (12020183)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6092,
    "Pala Untuk Destilasi (12020183)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6093,
    "Pala Untuk Destilasi (12020183)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6094,
    "Pala Untuk Destilasi (12020183)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6095,
    "Pala Untuk Destilasi (12020183)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6096,
    "Pala Untuk Destilasi (12020183)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6097,
    "Palai Bada/Teri (0902040117)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6098,
    "Palai Bada/Teri (0902040117)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6099,
    "Palai Bada/Teri (0902040117)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6100,
    "Palai Bada/Teri (0902040117)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6101,
    "Palai Bada/Teri (0902040117)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [6102, "Panekuk (07020214)", "Salmonella (/25 g)"],
  [6103, "Panekuk (07020214)", "Jumlah Sampel - Salmonella"],
  [
    6104,
    "Panekuk (07020214)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6105,
    "Panekuk (07020214)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6106,
    "Panekuk (07020214)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6107,
    "Panekuk (07020214)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6108,
    "Panekuk (07020214)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6109,
    "Pangan Diet Penurun Berat Badan Cair (1338)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6110,
    "Pangan Diet Penurun Berat Badan Cair (1338)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6111,
    "Pangan Diet Penurun Berat Badan Cair (1338)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6112,
    "Pangan Diet Penurun Berat Badan Cair (1338)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6113,
    "Pangan Diet Penurun Berat Badan Cair (1338)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6114,
    "Pangan Diet Penurun Berat Badan Cair (1338)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    6115,
    "Pangan Diet Penurun Berat Badan Cair (1338)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    6116,
    "Pangan Diet Penurun Berat Badan Cair (1338)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    6117,
    "Pangan Diet Penurun Berat Badan Cair (1338)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    6118,
    "Pangan Diet Penurun Berat Badan Cair (1338)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    6119,
    "Pangan Diet Penurun Berat Badan Cair (1338)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6120,
    "Pangan Diet Penurun Berat Badan Cair (1338)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6121,
    "Pangan Diet Penurun Berat Badan Cair (1338)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6122,
    "Pangan Diet Penurun Berat Badan Cair (1338)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6123,
    "Pangan Diet Penurun Berat Badan Cair (1338)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6124,
    "Pangan Diet Penurun Berat Badan Cair (1338)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6125,
    "Pangan Diet Penurun Berat Badan Cair (1338)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6126,
    "Pangan Diet Penurun Berat Badan Padat (1337)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6127,
    "Pangan Diet Penurun Berat Badan Padat (1337)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6128,
    "Pangan Diet Penurun Berat Badan Padat (1337)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6129,
    "Pangan Diet Penurun Berat Badan Padat (1337)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6130,
    "Pangan Diet Penurun Berat Badan Padat (1337)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6131,
    "Pangan Diet Penurun Berat Badan Padat (1337)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    6132,
    "Pangan Diet Penurun Berat Badan Padat (1337)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    6133,
    "Pangan Diet Penurun Berat Badan Padat (1337)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    6134,
    "Pangan Diet Penurun Berat Badan Padat (1337)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    6135,
    "Pangan Diet Penurun Berat Badan Padat (1337)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}10",
  ],
  [
    6136,
    "Pangan Diet Penurun Berat Badan Padat (1337)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6137,
    "Pangan Diet Penurun Berat Badan Padat (1337)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6138,
    "Pangan Diet Penurun Berat Badan Padat (1337)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6139,
    "Pangan Diet Penurun Berat Badan Padat (1337)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6140,
    "Pangan Diet Penurun Berat Badan Padat (1337)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6141,
    "Pangan Diet Penurun Berat Badan Padat (1337)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6142,
    "Pangan Diet Penurun Berat Badan Padat (1337)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6143,
    "Pangan Ibu Hamil Cair (1322)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6144,
    "Pangan Ibu Hamil Cair (1322)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6145,
    "Pangan Ibu Hamil Cair (1322)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6146,
    "Pangan Ibu Hamil Cair (1322)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6147,
    "Pangan Ibu Hamil Cair (1322)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6148,
    "Pangan Ibu Hamil Cair (1322)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6149,
    "Pangan Ibu Hamil Cair (1322)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6150,
    "Pangan Ibu Hamil Cair (1322)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6151,
    "Pangan Ibu Hamil Cair (1322)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6152,
    "Pangan Ibu Hamil Cair (1322)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6153,
    "Pangan Ibu Hamil Cair (1322)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6154,
    "Pangan Ibu Hamil Cair (1322)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6155,
    "Pangan Ibu Hamil Cair (1322)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6156,
    "Pangan Ibu Hamil Cair (1322)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6157,
    "Pangan Ibu Hamil Cair (1322)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6158,
    "Pangan Ibu Hamil Cair (1322)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6159,
    "Pangan Ibu Hamil Cair (1322)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6160,
    "Pangan Ibu Hamil dan Menyusui Cair (1326)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6161,
    "Pangan Ibu Hamil dan Menyusui Cair (1326)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6162,
    "Pangan Ibu Hamil dan Menyusui Cair (1326)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6163,
    "Pangan Ibu Hamil dan Menyusui Cair (1326)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6164,
    "Pangan Ibu Hamil dan Menyusui Cair (1326)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6165,
    "Pangan Ibu Hamil dan Menyusui Cair (1326)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6166,
    "Pangan Ibu Hamil dan Menyusui Cair (1326)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6167,
    "Pangan Ibu Hamil dan Menyusui Cair (1326)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6168,
    "Pangan Ibu Hamil dan Menyusui Cair (1326)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6169,
    "Pangan Ibu Hamil dan Menyusui Cair (1326)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6170,
    "Pangan Ibu Hamil dan Menyusui Cair (1326)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6171,
    "Pangan Ibu Hamil dan Menyusui Cair (1326)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6172,
    "Pangan Ibu Hamil dan Menyusui Cair (1326)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6173,
    "Pangan Ibu Hamil dan Menyusui Cair (1326)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6174,
    "Pangan Ibu Hamil dan Menyusui Cair (1326)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6175,
    "Pangan Ibu Hamil dan Menyusui Cair (1326)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6176,
    "Pangan Ibu Hamil dan Menyusui Cair (1326)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6177,
    "Pangan Ibu Hamil dan Menyusui Padat (1325)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6178,
    "Pangan Ibu Hamil dan Menyusui Padat (1325)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6179,
    "Pangan Ibu Hamil dan Menyusui Padat (1325)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6180,
    "Pangan Ibu Hamil dan Menyusui Padat (1325)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6181,
    "Pangan Ibu Hamil dan Menyusui Padat (1325)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6182,
    "Pangan Ibu Hamil dan Menyusui Padat (1325)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6183,
    "Pangan Ibu Hamil dan Menyusui Padat (1325)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6184,
    "Pangan Ibu Hamil dan Menyusui Padat (1325)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6185,
    "Pangan Ibu Hamil dan Menyusui Padat (1325)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6186,
    "Pangan Ibu Hamil dan Menyusui Padat (1325)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6187,
    "Pangan Ibu Hamil dan Menyusui Padat (1325)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6188,
    "Pangan Ibu Hamil dan Menyusui Padat (1325)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6189,
    "Pangan Ibu Hamil dan Menyusui Padat (1325)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6190,
    "Pangan Ibu Hamil dan Menyusui Padat (1325)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6191,
    "Pangan Ibu Hamil dan Menyusui Padat (1325)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6192,
    "Pangan Ibu Hamil dan Menyusui Padat (1325)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6193,
    "Pangan Ibu Hamil dan Menyusui Padat (1325)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6194,
    "Pangan Ibu Hamil Padat (1321)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6195,
    "Pangan Ibu Hamil Padat (1321)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6196,
    "Pangan Ibu Hamil Padat (1321)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6197,
    "Pangan Ibu Hamil Padat (1321)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6198,
    "Pangan Ibu Hamil Padat (1321)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6199,
    "Pangan Ibu Hamil Padat (1321)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6200,
    "Pangan Ibu Hamil Padat (1321)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6201,
    "Pangan Ibu Hamil Padat (1321)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6202,
    "Pangan Ibu Hamil Padat (1321)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6203,
    "Pangan Ibu Hamil Padat (1321)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6204,
    "Pangan Ibu Hamil Padat (1321)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6205,
    "Pangan Ibu Hamil Padat (1321)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6206,
    "Pangan Ibu Hamil Padat (1321)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6207,
    "Pangan Ibu Hamil Padat (1321)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6208,
    "Pangan Ibu Hamil Padat (1321)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6209,
    "Pangan Ibu Hamil Padat (1321)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6210,
    "Pangan Ibu Hamil Padat (1321)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6211,
    "Pangan Ibu Menyusui Padat (1323)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6212,
    "Pangan Ibu Menyusui Padat (1323)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6213,
    "Pangan Ibu Menyusui Padat (1323)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6214,
    "Pangan Ibu Menyusui Padat (1323)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6215,
    "Pangan Ibu Menyusui Padat (1323)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6216,
    "Pangan Ibu Menyusui Padat (1323)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6217,
    "Pangan Ibu Menyusui Padat (1323)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6218,
    "Pangan Ibu Menyusui Padat (1323)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6219,
    "Pangan Ibu Menyusui Padat (1323)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6220,
    "Pangan Ibu Menyusui Padat (1323)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6221,
    "Pangan Ibu Menyusui Padat (1323)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6222,
    "Pangan Ibu Menyusui Padat (1323)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6223,
    "Pangan Ibu Menyusui Padat (1323)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6224,
    "Pangan Ibu Menyusui Padat (1323)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6225,
    "Pangan Ibu Menyusui Padat (1323)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6226,
    "Pangan Ibu Menyusui Padat (1323)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6227,
    "Pangan Ibu Menyusui Padat (1323)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6228,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6229,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6230,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6231,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6232,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6233,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6234,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6235,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6236,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6237,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6238,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6239,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6240,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6241,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6242,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6243,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6244,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6245,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6246,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6247,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6248,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Salmonella (/25 g)",
  ],
  [
    6249,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6250,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Cronobacter sakazakii (/10 g)",
  ],
  [
    6251,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Jumlah Sampel - Cronobacter sakazakii",
  ],
  [
    6252,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    6253,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    6254,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    6255,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    6256,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Cair) (1397)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    6257,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6258,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6259,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6260,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6261,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6262,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6263,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6264,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6265,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6266,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6267,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6268,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6269,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6270,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6271,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Enterobacteriaceae (/10 g)",
  ],
  [
    6272,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6273,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6274,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6275,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6276,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6277,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Salmonella (/25 g)",
  ],
  [
    6278,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6279,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Cronobacter sakazakii (/10 g)",
  ],
  [
    6280,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Jumlah Sampel - Cronobacter sakazakii",
  ],
  [
    6281,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    6282,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    6283,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    6284,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    6285,
    "Pangan Olahan Keperluan Medis Khusus Bagi Bayi Intoleransi Laktosa (Padat) (1396)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    6286,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair) (1395)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "<10000",
  ],
  [
    6287,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair) (1395)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "<10000",
  ],
  [
    6288,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair) (1395)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "<10000",
  ],
  [
    6289,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair) (1395)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "<10000",
  ],
  [
    6290,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair) (1395)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "<10000",
  ],
  [
    6291,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair) (1395)",
    "Enterobacteriaceae (koloni/ml)",
    "\x{2264}10",
    "<1",
  ],
  [
    6292,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair) (1395)",
    "Enterobacteriaceae (koloni/ml)",
    "\x{2264}10",
    "<1",
  ],
  [
    6293,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair) (1395)",
    "Enterobacteriaceae (koloni/ml)",
    "\x{2264}10",
    "<1",
  ],
  [
    6294,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair) (1395)",
    "Enterobacteriaceae (koloni/ml)",
    "\x{2264}10",
    "<1",
  ],
  [
    6295,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair) (1395)",
    "Enterobacteriaceae (koloni/ml)",
    "\x{2264}10",
    "<1",
  ],
  [
    6296,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair) (1395)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "<10",
  ],
  [
    6297,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair) (1395)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "<10",
  ],
  [
    6298,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair) (1395)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "<10",
  ],
  [
    6299,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair) (1395)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "<10",
  ],
  [
    6300,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair) (1395)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "<10",
  ],
  [
    6301,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair) (1395)",
    "Salmonella (/25 g)",
  ],
  [
    6302,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Cair) (1395)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}10",
  ],
  [
    6303,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat) (1394)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "<10000",
  ],
  [
    6304,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat) (1394)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "<10000",
  ],
  [
    6305,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat) (1394)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "<10000",
  ],
  [
    6306,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat) (1394)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "<10000",
  ],
  [
    6307,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat) (1394)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "<10000",
  ],
  [
    6308,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat) (1394)",
    "Enterobacteriaceae (koloni/g)",
    "\x{2264}100",
    "<10",
  ],
  [
    6309,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat) (1394)",
    "Enterobacteriaceae (koloni/g)",
    "\x{2264}100",
    "<10",
  ],
  [
    6310,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat) (1394)",
    "Enterobacteriaceae (koloni/g)",
    "\x{2264}100",
    "<10",
  ],
  [
    6311,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat) (1394)",
    "Enterobacteriaceae (koloni/g)",
    "\x{2264}100",
    "<10",
  ],
  [
    6312,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat) (1394)",
    "Enterobacteriaceae (koloni/g)",
    "\x{2264}100",
    "<10",
  ],
  [
    6313,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat) (1394)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "<10",
  ],
  [
    6314,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat) (1394)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "<10",
  ],
  [
    6315,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat) (1394)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "<10",
  ],
  [
    6316,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat) (1394)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "<10",
  ],
  [
    6317,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat) (1394)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "<10",
  ],
  [
    6318,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat) (1394)",
    "Salmonella (/25 g)",
  ],
  [
    6319,
    "Pangan Olahan Keperluan Medis Khusus Diet Ketogenik (Padat) (1394)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}10",
  ],
  [
    6320,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1357)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6321,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1357)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6322,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1357)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6323,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1357)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6324,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1357)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6325,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1357)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    6326,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1357)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    6327,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1357)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    6328,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1357)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    6329,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1357)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    6330,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1357)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6331,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1357)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6332,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1357)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6333,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1357)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6334,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1357)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6335,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1357)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6336,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1357)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6337,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1375)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6338,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1375)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6339,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1375)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6340,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1375)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6341,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1375)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6342,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1375)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6343,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1375)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6344,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1375)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6345,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1375)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6346,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1375)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6347,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1375)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6348,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1375)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6349,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1375)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6350,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1375)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6351,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1375)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6352,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1375)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6353,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Dukungan Nutrisi Bagi Orang Dewasa Beresiko Gizi Kurang, Atau Gizi Buruk Padat (1375)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6354,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair (1376)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6355,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair (1376)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6356,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair (1376)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6357,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair (1376)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6358,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair (1376)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6359,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair (1376)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6360,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair (1376)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6361,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair (1376)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6362,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair (1376)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6363,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair (1376)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6364,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair (1376)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6365,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair (1376)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6366,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair (1376)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6367,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair (1376)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6368,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair (1376)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6369,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair (1376)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6370,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik dengan Terapi Dialisis Cair (1376)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6371,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair (1374)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6372,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair (1374)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6373,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair (1374)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6374,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair (1374)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6375,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair (1374)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6376,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair (1374)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6377,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair (1374)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6378,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair (1374)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6379,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair (1374)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6380,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair (1374)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6381,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair (1374)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6382,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair (1374)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6383,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair (1374)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6384,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair (1374)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6385,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair (1374)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6386,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair (1374)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6387,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Cair (1374)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6388,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat (1373)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6389,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat (1373)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6390,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat (1373)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6391,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat (1373)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6392,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat (1373)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6393,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat (1373)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6394,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat (1373)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6395,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat (1373)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6396,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat (1373)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6397,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat (1373)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6398,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat (1373)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6399,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat (1373)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6400,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat (1373)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6401,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat (1373)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6402,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat (1373)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6403,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat (1373)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6404,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Ginjal Kronik Pradialisis Padat (1373)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6405,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6406,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6407,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6408,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6409,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6410,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    6411,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    6412,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    6413,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    6414,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    6415,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    6416,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    6417,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    6418,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    6419,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Enterobacteriaceae (koloni/10 g)",
    "",
    "\x{2264}0",
  ],
  [
    6420,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Enterobacter sakazakii (koloni/10 g)",
  ],
  [
    6421,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Jumlah Sampel - Enterobacter sakazakii",
  ],
  [
    6422,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6423,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6424,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6425,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6426,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6427,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6428,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6429,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    6430,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    6431,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    6432,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    6433,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Ensefalopati Padat (1371)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}500",
    "\x{2264}50",
  ],
  [
    6434,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6435,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6436,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6437,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6438,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6439,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Salmonella (/25 g)",
  ],
  [
    6440,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6441,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6442,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6443,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6444,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Salmonella (/25 g)",
  ],
  [
    6445,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6446,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Salmonella (/25 g)",
  ],
  [
    6447,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Salmonella (/25 g)",
  ],
  [
    6448,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Salmonella (/25 g)",
  ],
  [
    6449,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Salmonella (/25 g)",
  ],
  [
    6450,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Salmonella (/25 g)",
  ],
  [
    6451,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Salmonella (/25 g)",
  ],
  [
    6452,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Salmonella (/25 g)",
  ],
  [
    6453,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Salmonella (/25 g)",
  ],
  [
    6454,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Enterobacteriaceae (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6455,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Enterobacteriaceae (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6456,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Enterobacteriaceae (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6457,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Enterobacteriaceae (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6458,
    "Pangan Olahan untuk Keperluan Medis Khusus untuk Pasien Penyakit Hati Non Ensefalopati Padat (1369)",
    "Enterobacteriaceae (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6459,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat (1367)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6460,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat (1367)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6461,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat (1367)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6462,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat (1367)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6463,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat (1367)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6464,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat (1367)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6465,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat (1367)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6466,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat (1367)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6467,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat (1367)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6468,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat (1367)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6469,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat (1367)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6470,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat (1367)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6471,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat (1367)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6472,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat (1367)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6473,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat (1367)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6474,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat (1367)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6475,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Peyandang Diabetes Padat (1367)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6476,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1366)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6477,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1366)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6478,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1366)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6479,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1366)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6480,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1366)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6481,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1366)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6482,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1366)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6483,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1366)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6484,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1366)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6485,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1366)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6486,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1366)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6487,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1366)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6488,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1366)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6489,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1366)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6490,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1366)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6491,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1366)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6492,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Cair (1366)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6493,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1365)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6494,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1365)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6495,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1365)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6496,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1365)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6497,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1365)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6498,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1365)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6499,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1365)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6500,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1365)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6501,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1365)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6502,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1365)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6503,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1365)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6504,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1365)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6505,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1365)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6506,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1365)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6507,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1365)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6508,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1365)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6509,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Maple Syrup Urine Disease (MSUD) Padat (1365)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6510,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1364)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6511,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1364)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6512,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1364)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6513,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1364)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6514,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1364)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6515,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1364)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6516,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1364)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6517,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1364)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6518,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1364)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6519,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1364)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6520,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1364)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6521,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1364)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6522,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1364)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6523,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1364)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6524,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1364)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6525,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1364)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6526,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Cair (1364)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6527,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1363)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6528,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1363)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6529,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1363)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6530,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1363)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6531,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1363)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6532,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1363)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6533,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1363)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6534,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1363)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6535,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1363)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6536,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1363)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6537,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1363)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6538,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1363)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6539,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1363)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6540,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1363)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6541,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1363)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6542,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1363)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6543,
    "Pangan Olahan Untuk Keperluan Medis Khusus Untuk Tatalaksana Diet Penyakit Kelainan Bawaan Metabolik Tyrosinemia Padat (1363)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6544,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (1377)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6545,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (1377)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6546,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (1377)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6547,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (1377)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6548,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (1377)",
    "ALT (koloni/g)",
    "\x{2264}5000",
    "\x{2264}500",
  ],
  [
    6549,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (1377)",
    "Kapang dan khamir (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6550,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (1377)",
    "Kapang dan khamir (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6551,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (1377)",
    "Kapang dan khamir (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6552,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (1377)",
    "Kapang dan khamir (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6553,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (1377)",
    "Kapang dan khamir (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6554,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "ALT (koloni/ml)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6555,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "ALT (koloni/ml)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6556,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "ALT (koloni/ml)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6557,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "ALT (koloni/ml)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6558,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "ALT (koloni/ml)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6559,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6560,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6561,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6562,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6563,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6564,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6565,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6566,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6567,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6568,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6569,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    6570,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    6571,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    6572,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    6573,
    "Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat (Cair) (1378)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    6574,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair (1334)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6575,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair (1334)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6576,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair (1334)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6577,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair (1334)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6578,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair (1334)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6579,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair (1334)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6580,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair (1334)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6581,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair (1334)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6582,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair (1334)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6583,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair (1334)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6584,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair (1334)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6585,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair (1334)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6586,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair (1334)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6587,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair (1334)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6588,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair (1334)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6589,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair (1334)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6590,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Cair (1334)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6591,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat (1333)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6592,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat (1333)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6593,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat (1333)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6594,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat (1333)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6595,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat (1333)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6596,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat (1333)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6597,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat (1333)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6598,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat (1333)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6599,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat (1333)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6600,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat (1333)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6601,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat (1333)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6602,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat (1333)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6603,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat (1333)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6604,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat (1333)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6605,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat (1333)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6606,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat (1333)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6607,
    "Pangan Tambahan untuk Olahragawan Diperkaya Protein Padat (1333)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6608,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "ALT (koloni/ml)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6609,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "ALT (koloni/ml)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6610,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "ALT (koloni/ml)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6611,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "ALT (koloni/ml)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6612,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "ALT (koloni/ml)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6613,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6614,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6615,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6616,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6617,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6618,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6619,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6620,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6621,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6622,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "Koliform (APM/100 ml)",
    "\x{2264}10",
    "<1.8",
  ],
  [
    6623,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    6624,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    6625,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    6626,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    6627,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Cair (1330)",
    "Pseudomonas aeruginosa (/100 ml)",
  ],
  [
    6628,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat (1329)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6629,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat (1329)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6630,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat (1329)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6631,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat (1329)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6632,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat (1329)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6633,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat (1329)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6634,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat (1329)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6635,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat (1329)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6636,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat (1329)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6637,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat (1329)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6638,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat (1329)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6639,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat (1329)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6640,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat (1329)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6641,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat (1329)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6642,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat (1329)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6643,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat (1329)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6644,
    "Pangan Tambahan untuk Olahragawan Karbohidrat Elektrolit Padat (1329)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6645,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat (1331)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6646,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat (1331)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6647,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat (1331)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6648,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat (1331)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6649,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat (1331)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6650,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat (1331)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6651,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat (1331)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6652,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat (1331)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6653,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat (1331)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6654,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat (1331)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6655,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat (1331)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6656,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat (1331)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6657,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat (1331)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6658,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat (1331)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6659,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat (1331)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6660,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat (1331)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6661,
    "Pangan Tambahan untuk Olahragawan Protein Konsentrat Padat (1331)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6662,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat (13050505)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6663,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat (13050505)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6664,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat (13050505)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6665,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat (13050505)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6666,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat (13050505)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6667,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat (13050505)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6668,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat (13050505)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6669,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat (13050505)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6670,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat (13050505)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6671,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat (13050505)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6672,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat (13050505)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6673,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat (13050505)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6674,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat (13050505)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6675,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat (13050505)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6676,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat (13050505)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6677,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat (13050505)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6678,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Dari Karbohidrat - Padat (13050505)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6679,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat (1327)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6680,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat (1327)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6681,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat (1327)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6682,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat (1327)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6683,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat (1327)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6684,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat (1327)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6685,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat (1327)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6686,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat (1327)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6687,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat (1327)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6688,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat (1327)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6689,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat (1327)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6690,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat (1327)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6691,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat (1327)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6692,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat (1327)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6693,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat (1327)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6694,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat (1327)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6695,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi dari Karbohidrat Padat (1327)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6696,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat (13050507)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6697,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat (13050507)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6698,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat (13050507)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6699,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat (13050507)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6700,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat (13050507)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6701,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat (13050507)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6702,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat (13050507)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6703,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat (13050507)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6704,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat (13050507)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6705,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat (13050507)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6706,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat (13050507)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6707,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat (13050507)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6708,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat (13050507)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6709,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat (13050507)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6710,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat (13050507)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6711,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat (13050507)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6712,
    "Pangan Tambahan Untuk Olahragawan Tinggi Karbohidrat Elektrolit - Padat (13050507)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6713,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat (13050501)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6714,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat (13050501)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6715,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat (13050501)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6716,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat (13050501)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6717,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat (13050501)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6718,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat (13050501)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6719,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat (13050501)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6720,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat (13050501)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6721,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat (13050501)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6722,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat (13050501)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6723,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat (13050501)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6724,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat (13050501)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6725,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat (13050501)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6726,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat (13050501)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6727,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat (13050501)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6728,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat (13050501)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6729,
    "Pangan Tambahan Untuk Olahragawan Tinggi Protein Konsentrat - Padat (13050501)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6730,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat (13050503)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6731,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat (13050503)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6732,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat (13050503)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6733,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat (13050503)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6734,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat (13050503)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6735,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat (13050503)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6736,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat (13050503)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6737,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat (13050503)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6738,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat (13050503)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6739,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat (13050503)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6740,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat (13050503)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6741,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat (13050503)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6742,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat (13050503)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6743,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat (13050503)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6744,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat (13050503)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6745,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat (13050503)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6746,
    "Pangan Tambahan Untuk Olahragawan Yang Diperkaya Protein - Padat (13050503)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6747,
    "Pangan Untuk Kontrol Berat Badan Cair (1336)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6748,
    "Pangan Untuk Kontrol Berat Badan Cair (1336)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6749,
    "Pangan Untuk Kontrol Berat Badan Cair (1336)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6750,
    "Pangan Untuk Kontrol Berat Badan Cair (1336)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6751,
    "Pangan Untuk Kontrol Berat Badan Cair (1336)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6752,
    "Pangan Untuk Kontrol Berat Badan Cair (1336)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6753,
    "Pangan Untuk Kontrol Berat Badan Cair (1336)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6754,
    "Pangan Untuk Kontrol Berat Badan Cair (1336)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6755,
    "Pangan Untuk Kontrol Berat Badan Cair (1336)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6756,
    "Pangan Untuk Kontrol Berat Badan Cair (1336)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6757,
    "Pangan Untuk Kontrol Berat Badan Cair (1336)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6758,
    "Pangan Untuk Kontrol Berat Badan Cair (1336)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6759,
    "Pangan Untuk Kontrol Berat Badan Cair (1336)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6760,
    "Pangan Untuk Kontrol Berat Badan Cair (1336)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6761,
    "Pangan Untuk Kontrol Berat Badan Cair (1336)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6762,
    "Pangan Untuk Kontrol Berat Badan Cair (1336)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6763,
    "Pangan Untuk Kontrol Berat Badan Cair (1336)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6764,
    "Pangan Untuk Kontrol Berat Badan Padat (1335)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6765,
    "Pangan Untuk Kontrol Berat Badan Padat (1335)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6766,
    "Pangan Untuk Kontrol Berat Badan Padat (1335)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6767,
    "Pangan Untuk Kontrol Berat Badan Padat (1335)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6768,
    "Pangan Untuk Kontrol Berat Badan Padat (1335)",
    "ALT (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6769,
    "Pangan Untuk Kontrol Berat Badan Padat (1335)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6770,
    "Pangan Untuk Kontrol Berat Badan Padat (1335)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6771,
    "Pangan Untuk Kontrol Berat Badan Padat (1335)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6772,
    "Pangan Untuk Kontrol Berat Badan Padat (1335)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6773,
    "Pangan Untuk Kontrol Berat Badan Padat (1335)",
    "Enterobacteriaceae (koloni/10 g)",
    "\x{2264}10",
    "\x{2264}1",
  ],
  [
    6774,
    "Pangan Untuk Kontrol Berat Badan Padat (1335)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6775,
    "Pangan Untuk Kontrol Berat Badan Padat (1335)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6776,
    "Pangan Untuk Kontrol Berat Badan Padat (1335)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6777,
    "Pangan Untuk Kontrol Berat Badan Padat (1335)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6778,
    "Pangan Untuk Kontrol Berat Badan Padat (1335)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}100",
    "\x{2264}10",
  ],
  [
    6779,
    "Pangan Untuk Kontrol Berat Badan Padat (1335)",
    "Salmonella (koloni/25 g)",
  ],
  [
    6780,
    "Pangan Untuk Kontrol Berat Badan Padat (1335)",
    "Jumlah Sampel - Salmonella",
  ],
  [6781, "Pangsit Daging (08030315)", "Salmonella (/25 g)"],
  [6782, "Pangsit Daging (08030315)", "Jumlah - Salmonella"],
  [
    6783,
    "Pangsit Daging (08030315)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6784,
    "Pangsit Daging (08030315)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6785,
    "Pangsit Daging (08030315)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6786,
    "Pangsit Daging (08030315)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6787,
    "Pangsit Daging (08030315)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6788,
    "Pangsit Daging (08030315)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    6789,
    "Pangsit Daging (08030315)",
    "Jumlah - Listeria monocytogenes",
  ],
  [
    6790,
    "Pangsit Seafood (Ikan, Udang, Cumi, dll) (0902040119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6791,
    "Pangsit Seafood (Ikan, Udang, Cumi, dll) (0902040119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6792,
    "Pangsit Seafood (Ikan, Udang, Cumi, dll) (0902040119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6793,
    "Pangsit Seafood (Ikan, Udang, Cumi, dll) (0902040119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6794,
    "Pangsit Seafood (Ikan, Udang, Cumi, dll) (0902040119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6795,
    "Pangsit Seafood (Ikan, Udang, Cumi, dll) (0902040119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6796,
    "Pangsit Seafood (Ikan, Udang, Cumi, dll) (0902040119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6797,
    "Pangsit Seafood (Ikan, Udang, Cumi, dll) (0902040119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6798,
    "Pangsit Seafood (Ikan, Udang, Cumi, dll) (0902040119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6799,
    "Pangsit Seafood (Ikan, Udang, Cumi, dll) (0902040119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6800,
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah (06040105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6801,
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah (06040105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6802,
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah (06040105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6803,
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah (06040105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6804,
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah (06040105)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6805,
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah (06040105)",
    "Salmonella (/25 g)",
  ],
  [
    6806,
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah (06040105)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    6807,
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak (06040326)",
    "Salmonella (/25 g)",
  ],
  [
    6808,
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak (06040326)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    6809,
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak (06040326)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    6810,
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak (06040326)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    6811,
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak (06040326)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    6812,
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak (06040326)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    6813,
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak (06040326)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [6814, "Paprika Bubuk (12020186)", "Salmonella (/25 g)"],
  [6815, "Paprika Bubuk (12020186)", "Jumlah Sampel - Salmonella"],
  [
    6816,
    "Paprika Bubuk (12020186)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6817,
    "Paprika Bubuk (12020186)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6818,
    "Paprika Bubuk (12020186)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6819,
    "Paprika Bubuk (12020186)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6820,
    "Paprika Bubuk (12020186)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6821,
    "Paprika Bubuk (12020186)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6822,
    "Paprika Bubuk (12020186)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6823,
    "Paprika Bubuk (12020186)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6824,
    "Paprika Bubuk (12020186)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6825,
    "Paprika Bubuk (12020186)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [6826, "Parsley (12020185)", "Salmonella (/25 g)"],
  [6827, "Parsley (12020185)", "Jumlah Sampel - Salmonella"],
  [6828, "Pasta (06040218)", "Salmonella (/25 g)"],
  [6829, "Pasta (06040218)", "Jumlah Sampel - Salmonella"],
  [6830, "Pasta (0604A0)", "Salmonella (/25 g)"],
  [6831, "Pasta (0604A0)", "Jumlah Sampel - Salmonella"],
  [
    6832,
    "Pasta Biji Kopi Manis (Untuk Bahan Pengisi) (0402020608)",
    "Salmonella (/25 g)",
  ],
  [
    6833,
    "Pasta Biji Kopi Manis (Untuk Bahan Pengisi) (0402020608)",
    "Jumlah Sampel - Salmonella",
  ],
  [6834, "Pasta Buah (0401020803)", "Jumlah Sampel - Salmonella"],
  [6835, "Pasta Buah (0401020803)", "Salmonella (/25 g)"],
  [
    6836,
    "Pasta Daging (08030208)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6837,
    "Pasta Daging (08030208)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6838,
    "Pasta Daging (08030208)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6839,
    "Pasta Daging (08030208)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6840,
    "Pasta Daging (08030208)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [6841, "Pasta Daging (08030208)", "Salmonella (/25 g)"],
  [6842, "Pasta Daging (08030208)", "Salmonella (/25 g)"],
  [6843, "Pasta Daging (08030208)", "Jumlah - Salmonella"],
  [
    6844,
    "Pasta Daging (08030208)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6845,
    "Pasta Daging (08030208)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6846,
    "Pasta Daging (08030208)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6847,
    "Pasta Daging (08030208)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6848,
    "Pasta Daging (08030208)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [6849, "Pasta Gonad Bulu Babi (09020523)", "Salmonella (/25 g)"],
  [
    6850,
    "Pasta Gonad Bulu Babi (09020523)",
    "Jumlah Sampel - Salmonella",
  ],
  [6851, "Pasta Ikan (09020518)", "Salmonella (/25 g)"],
  [6852, "Pasta Ikan (09020518)", "Jumlah Sampel - Salmonella"],
  [6853, "Pasta Instan (06040321)", "Salmonella (/25 g)"],
  [6854, "Pasta Instan (06040321)", "Jumlah Sampel - Salmonella"],
  [6855, "Pasta Instan Lainnya (06040320)", "Salmonella (/25 g)"],
  [
    6856,
    "Pasta Instan Lainnya (06040320)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6857,
    "Pasta Kacang Merah Manis (0402020607)",
    "Salmonella (/25 g)",
  ],
  [
    6858,
    "Pasta Kacang Merah Manis (0402020607)",
    "Jumlah Sampel - Salmonella",
  ],
  [6859, "Pasta lainnya (06040219)", "Salmonella (/25 g)"],
  [6860, "Pasta lainnya (06040219)", "Jumlah Sampel - Salmonella"],
  [6861, "Pasta Tomat (0402020601)", "Salmonella (/25 g)"],
  [6862, "Pasta Tomat (0402020601)", "Jumlah Sampel - Salmonella"],
  [6863, "Pasta Umbi (0402020615)", "Salmonella (/25ml)"],
  [
    6864,
    "Pasta Umbi (0402020615)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [6865, "Pastiles (05020102)", "Salmonella (/25 g)"],
  [6866, "Pastiles (05020102)", "Jumlah Sampel - Salmonella"],
  [6867, "Pastri (07020201)", "Salmonella (/25 g)"],
  [6868, "Pastri (07020201)", "Jumlah Sampel - Salmonella"],
  [
    6869,
    "Pastri (07020201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6870,
    "Pastri (07020201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6871,
    "Pastri (07020201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6872,
    "Pastri (07020201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    6873,
    "Pastri (07020201)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [6874, "Pati Garut (06020201)", "Salmonella (/25 g)"],
  [6875, "Pati Garut (06020201)", "Jumlah Sampel - Salmonella"],
  [
    6876,
    "Pati Garut (06020201)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6877,
    "Pati Garut (06020201)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6878,
    "Pati Garut (06020201)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6879,
    "Pati Garut (06020201)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6880,
    "Pati Garut (06020201)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6881,
    "Pati Jagung atau Maizena (06020202)",
    "Salmonella (/25 g)",
  ],
  [
    6882,
    "Pati Jagung atau Maizena (06020202)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6883,
    "Pati Jagung atau Maizena (06020202)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6884,
    "Pati Jagung atau Maizena (06020202)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6885,
    "Pati Jagung atau Maizena (06020202)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6886,
    "Pati Jagung atau Maizena (06020202)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6887,
    "Pati Jagung atau Maizena (06020202)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6888,
    "Pati Kacang Hijau/Hunkwee (06020204)",
    "Salmonella (/25 g)",
  ],
  [
    6889,
    "Pati Kacang Hijau/Hunkwee (06020204)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6890,
    "Pati Kacang Hijau/Hunkwee (06020204)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6891,
    "Pati Kacang Hijau/Hunkwee (06020204)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6892,
    "Pati Kacang Hijau/Hunkwee (06020204)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6893,
    "Pati Kacang Hijau/Hunkwee (06020204)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6894,
    "Pati Kacang Hijau/Hunkwee (06020204)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6895,
    "Pati Lainnya (Biji-Bijian, Umbi-Umbian, dll) (06020210)",
    "Salmonella (/25 g)",
  ],
  [
    6896,
    "Pati Lainnya (Biji-Bijian, Umbi-Umbian, dll) (06020210)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    6897,
    "Pati Lainnya (Biji-Bijian, Umbi-Umbian, dll) (06020210)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "<1000",
  ],
  [
    6898,
    "Pati Lainnya (Biji-Bijian, Umbi-Umbian, dll) (06020210)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "<1000",
  ],
  [
    6899,
    "Pati Lainnya (Biji-Bijian, Umbi-Umbian, dll) (06020210)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "<1000",
  ],
  [
    6900,
    "Pati Lainnya (Biji-Bijian, Umbi-Umbian, dll) (06020210)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "<1000",
  ],
  [
    6901,
    "Pati Lainnya (Biji-Bijian, Umbi-Umbian, dll) (06020210)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "<1000",
  ],
  [6902, "Pati Pragelatinisasi (06020208)", "Salmonella (/25 g)"],
  [
    6903,
    "Pati Pragelatinisasi (06020208)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6904,
    "Pati Pragelatinisasi (06020208)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6905,
    "Pati Pragelatinisasi (06020208)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6906,
    "Pati Pragelatinisasi (06020208)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6907,
    "Pati Pragelatinisasi (06020208)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6908,
    "Pati Pragelatinisasi (06020208)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [6909, "Pati Sagu (06020203)", "Salmonella (/25 g)"],
  [6910, "Pati Sagu (06020203)", "Jumlah Sampel - Salmonella"],
  [
    6911,
    "Pati Sagu (06020203)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6912,
    "Pati Sagu (06020203)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6913,
    "Pati Sagu (06020203)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6914,
    "Pati Sagu (06020203)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6915,
    "Pati Sagu (06020203)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [6916, "Pati Termodifikasi (06020207)", "Salmonella (/25 g)"],
  [
    6917,
    "Pati Termodifikasi (06020207)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6918,
    "Pati Termodifikasi (06020207)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6919,
    "Pati Termodifikasi (06020207)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6920,
    "Pati Termodifikasi (06020207)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6921,
    "Pati Termodifikasi (06020207)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6922,
    "Pati Termodifikasi (06020207)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6923,
    "Patilo / Rengginang Singkong (150139)",
    "Salmonella (/25 g)",
  ],
  [
    6924,
    "Patilo / Rengginang Singkong (150139)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    6925,
    "Patilo / Rengginang Singkong (150139)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6926,
    "Patilo / Rengginang Singkong (150139)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6927,
    "Patilo / Rengginang Singkong (150139)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6928,
    "Patilo / Rengginang Singkong (150139)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6929,
    "Patilo / Rengginang Singkong (150139)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6930,
    "Patties Daging Panggang Setengah Matang (08030201)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6931,
    "Patties Daging Panggang Setengah Matang (08030201)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6932,
    "Patties Daging Panggang Setengah Matang (08030201)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6933,
    "Patties Daging Panggang Setengah Matang (08030201)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6934,
    "Patties Daging Panggang Setengah Matang (08030201)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6935,
    "Patties Daging Panggang Setengah Matang (08030201)",
    "Salmonella (/25 g)",
  ],
  [
    6936,
    "Patties Daging Panggang Setengah Matang (08030201)",
    "Salmonella (/25 g)",
  ],
  [
    6937,
    "Patties Daging Panggang Setengah Matang (08030201)",
    "Jumlah - Salmonella",
  ],
  [
    6938,
    "Pekak/Bunga Lawang/Star Anise (12020191)",
    "Salmonella (/25 g)",
  ],
  [
    6939,
    "Pekak/Bunga Lawang/Star Anise (12020191)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6940,
    "Pekak/Bunga Lawang/Star Anise (12020191)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6941,
    "Pekak/Bunga Lawang/Star Anise (12020191)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6942,
    "Pekak/Bunga Lawang/Star Anise (12020191)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6943,
    "Pekak/Bunga Lawang/Star Anise (12020191)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6944,
    "Pekak/Bunga Lawang/Star Anise (12020191)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    6945,
    "Pekak/Bunga Lawang/Star Anise (12020191)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6946,
    "Pekak/Bunga Lawang/Star Anise (12020191)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6947,
    "Pekak/Bunga Lawang/Star Anise (12020191)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6948,
    "Pekak/Bunga Lawang/Star Anise (12020191)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6949,
    "Pekak/Bunga Lawang/Star Anise (12020191)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    6950,
    "Pempek Ikan (Goreng atau Panggang) (0902040313)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6951,
    "Pempek Ikan (Goreng atau Panggang) (0902040313)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6952,
    "Pempek Ikan (Goreng atau Panggang) (0902040313)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6953,
    "Pempek Ikan (Goreng atau Panggang) (0902040313)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6954,
    "Pempek Ikan (Goreng atau Panggang) (0902040313)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6955,
    "Pempek Ikan (Rebus) (0902040112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6956,
    "Pempek Ikan (Rebus) (0902040112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6957,
    "Pempek Ikan (Rebus) (0902040112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6958,
    "Pempek Ikan (Rebus) (0902040112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6959,
    "Pempek Ikan (Rebus) (0902040112)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6960,
    "Pempek Ikan Rebus Beku (09020132)",
    "Salmonella (/25 g)",
  ],
  [
    6961,
    "Pempek Ikan Rebus Beku (09020132)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    6962,
    "Pengganti Lemak Kakao Laurat (Lauric Cocoa Butter Replacer/",
  ],
  [
    6963,
    "Substitute=CBS Lauric) (05010502)",
    "Salmonella (/25 g)",
  ],
  [
    6964,
    "Pengganti Lemak Kakao Laurat (Lauric Cocoa Butter Replacer/",
  ],
  [
    6965,
    "Substitute=CBS Lauric) (05010502)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6966,
    "Pengganti Lemak Kakao Non-Laurat (Nonlauric Cocoa Butter Replacer/",
  ],
  [
    6967,
    "Substitute = CBS Non-Lauric) (05010503)",
    "Salmonella (/25 g)",
  ],
  [
    6968,
    "Pengganti Lemak Kakao Non-Laurat (Nonlauric Cocoa Butter Replacer/",
  ],
  [
    6969,
    "Substitute = CBS Non-Lauric) (05010503)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6970,
    "Pengganti Minyak Mentega (Butter Oil Substitute) (02010210)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    6971,
    "Pengganti Minyak Mentega (Butter Oil Substitute) (02010210)",
    "Salmonella (/25 g)",
  ],
  [
    6972,
    "Pengganti Minyak Mentega (Butter Oil Substitute) (02010210)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    6973,
    "Pengganti Minyak Mentega (Butter Oil Substitute) (02010210)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    6974,
    "Pengganti Minyak Mentega (Butter Oil Substitute) (02010210)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    6975,
    "Pengganti Minyak Mentega (Butter Oil Substitute) (02010210)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    6976,
    "Pengganti Minyak Mentega (Butter Oil Substitute) (02010210)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    6977,
    "Pepes Ikan/Pepes Teri (0902040114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6978,
    "Pepes Ikan/Pepes Teri (0902040114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6979,
    "Pepes Ikan/Pepes Teri (0902040114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6980,
    "Pepes Ikan/Pepes Teri (0902040114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    6981,
    "Pepes Ikan/Pepes Teri (0902040114)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [6982, "Pepes Udang (0902040207)", "Salmonella (/25 g)"],
  [6983, "Pepes Udang (0902040207)", "Jumlah Sampel - Salmonella"],
  [
    6984,
    "Pepes Udang (0902040207)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    6985,
    "Pepes Udang (0902040207)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    6986,
    "Pepes Udang (0902040207)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    6987,
    "Pepes Udang (0902040207)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    6988,
    "Pepes Udang (0902040207)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}1000",
  ],
  [
    6989,
    "Pepes Udang (0902040207)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    6990,
    "Pepes Udang (0902040207)",
    "Jumlah Sampel -Listeria monocytogenes",
  ],
  [
    6991,
    "Pepperoni (08030243)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6992,
    "Pepperoni (08030243)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6993,
    "Pepperoni (08030243)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6994,
    "Pepperoni (08030243)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6995,
    "Pepperoni (08030243)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6996,
    "Pepperoni (08030243)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6997,
    "Pepperoni (08030243)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6998,
    "Pepperoni (08030243)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    6999,
    "Pepperoni (08030243)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7000,
    "Pepperoni (08030243)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [7001, "Pepperoni (08030243)", "Salmonella (/25 g)"],
  [7002, "Pepperoni (08030243)", "Salmonella (/25 g)"],
  [7003, "Pepperoni (08030243)", "Jumlah - Salmonella"],
  [7004, "Pepperoni (08030243)", "Jumlah - Salmonella"],
  [
    7005,
    "Perkedel Kentang Beku (0402020116)",
    "Salmonella (/25ml)",
  ],
  [
    7006,
    "Perkedel Kentang Beku (0402020116)",
    "Listeria monocytogenes (koloni/ g)",
    "",
    "<100",
  ],
  [
    7007,
    "Perkedel Kentang Beku (0402020116)",
    "Listeria monocytogenes (koloni/ g)",
    "",
    "<100",
  ],
  [
    7008,
    "Perkedel Kentang Beku (0402020116)",
    "Listeria monocytogenes (koloni/ g)",
    "",
    "<100",
  ],
  [
    7009,
    "Perkedel Kentang Beku (0402020116)",
    "Listeria monocytogenes (koloni/ g)",
    "",
    "<100",
  ],
  [
    7010,
    "Perkedel Kentang Beku (0402020116)",
    "Listeria monocytogenes (koloni/ g)",
    "",
    "<100",
  ],
  [
    7011,
    "Perkedel Kentang Beku (0402020116)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    7012,
    "Permen Enting-Enting atau Nut Brittles (05020303)",
    "Salmonella (/25 g)",
  ],
  [
    7013,
    "Permen Enting-Enting atau Nut Brittles (05020303)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7014,
    "Petah (060714)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7015,
    "Petah (060714)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7016,
    "Petah (060714)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7017,
    "Petah (060714)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7018,
    "Petah (060714)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [7019, "Petah (060714)", "Salmonella (/25 g)"],
  [7020, "Petah (060714)", "Jumlah Sampel - Salmonella"],
  [
    7021,
    "Petah (060714)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7022,
    "Petah (060714)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7023,
    "Petah (060714)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7024,
    "Petah (060714)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7025,
    "Petah (060714)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [7026, "Petis Udang (09020519)", "Salmonella (/25 g)"],
  [7027, "Petis Udang (09020519)", "Jumlah Sampel - Salmonella"],
  [7028, "Picalili (0402020311)", "Salmonella (/25 g)"],
  [7029, "Picalili (0402020311)", "Jumlah Sampel - Salmonella"],
  [7030, "Picung (12020164)", "Salmonella (/25 g)"],
  [7031, "Picung (12020164)", "Jumlah Sampel - Salmonella"],
  [
    7032,
    "Picung (12020164)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7033,
    "Picung (12020164)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7034,
    "Picung (12020164)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7035,
    "Picung (12020164)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7036,
    "Picung (12020164)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7037,
    "Picung (12020164)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7038,
    "Picung (12020164)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7039,
    "Picung (12020164)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7040,
    "Picung (12020164)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7041,
    "Picung (12020164)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [7042, "Pikel (fermentasi) (0402020701)", "Salmonella (/25 g)"],
  [
    7043,
    "Pikel (fermentasi) (0402020701)",
    "Jumlah Sampel - Salmonella",
  ],
  [7044, "Pikel Buah (0401021005)", "Salmonella (/25 g)"],
  [
    7045,
    "Pikel Buah (0401021005)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    7046,
    "Pikel Daging Anjing Laut (Pickled Whale) (09030206)",
    "Salmonella (/25 g)",
  ],
  [
    7047,
    "Pikel Daging Anjing Laut (Pickled Whale) (09030206)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7048,
    "Pikel Daging Anjing Laut (Pickled Whale) (09030206)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    7049,
    "Pikel Daging Anjing Laut (Pickled Whale) (09030206)",
    "Jumlah Sampel -Listeria monocytogenes",
  ],
  [7050, "Pikel Ikan Haring (09030208)", "Salmonella (/25 g)"],
  [
    7051,
    "Pikel Ikan Haring (09030208)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7052,
    "Pikel Ikan Haring (09030208)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    7053,
    "Pikel Ikan Haring (09030208)",
    "Jumlah Sampel -Listeria monocytogenes",
  ],
  [7054, "Pikel Jahe (0402020706)", "Salmonella (/25 g)"],
  [7055, "Pikel Jahe (0402020706)", "Jumlah Sampel - Salmonella"],
  [7056, "Pikel Mentimun (0402020705)", "Salmonella (/25 g)"],
  [
    7057,
    "Pikel Mentimun (0402020705)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7058,
    "Pikel Persik (Plum Pickles) (0401021002)",
    "Salmonella (/25 g)",
  ],
  [
    7059,
    "Pikel Persik (Plum Pickles) (0401021002)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7060,
    "Pikel Pir (Pear Pickles) (0401021001)",
    "Salmonella (/25 g)",
  ],
  [
    7061,
    "Pikel Pir (Pear Pickles) (0401021001)",
    "Jumlah Sampel - Salmonella",
  ],
  [7062, "Pikel Sprat (09030207)", "Salmonella (/25 g)"],
  [7063, "Pikel Sprat (09030207)", "Jumlah Sampel - Salmonella"],
  [
    7064,
    "Pikel Sprat (09030207)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    7065,
    "Pikel Sprat (09030207)",
    "Jumlah Sampel -Listeria monocytogenes",
  ],
  [
    7066,
    "Pikel Zaitun (Olives) (0402020707)",
    "Salmonella (/25 g)",
  ],
  [
    7067,
    "Pikel Zaitun (Olives) (0402020707)",
    "Jumlah Sampel - Salmonella",
  ],
  [7068, "Pilus (150118)", "Salmonella (/25 g)"],
  [7069, "Pilus (150118)", "Jumlah Sampel - Salmonella"],
  [
    7070,
    "Pilus (150118)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7071,
    "Pilus (150118)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7072,
    "Pilus (150118)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7073,
    "Pilus (150118)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7074,
    "Pilus (150118)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7075,
    "Pisang Hijau (060717)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7076,
    "Pisang Hijau (060717)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7077,
    "Pisang Hijau (060717)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7078,
    "Pisang Hijau (060717)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7079,
    "Pisang Hijau (060717)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [7080, "Pisang Hijau (060717)", "Salmonella (/25 g)"],
  [7081, "Pisang Hijau (060717)", "Jumlah Sampel - Salmonella"],
  [
    7082,
    "Pisang Hijau (060717)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7083,
    "Pisang Hijau (060717)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7084,
    "Pisang Hijau (060717)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7085,
    "Pisang Hijau (060717)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7086,
    "Pisang Hijau (060717)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [7087, "Pizza (07020209)", "Salmonella (/25 g)"],
  [7088, "Pizza (07020209)", "Jumlah Sampel - Salmonella"],
  [
    7089,
    "Pizza (07020209)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7090,
    "Pizza (07020209)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7091,
    "Pizza (07020209)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7092,
    "Pizza (07020209)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7093,
    "Pizza (07020209)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7094,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat) (1398)",
    "ALT (koloni/g)",
  ],
  [7095, "", "\x{2264}100000", "\x{2264}10000"],
  [
    7096,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat) (1398)",
    "ALT (koloni/g)",
  ],
  [7097, "", "\x{2264}100000", "\x{2264}10000"],
  [
    7098,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat) (1398)",
    "ALT (koloni/g)",
  ],
  [7099, "", "\x{2264}100000", "\x{2264}10000"],
  [
    7100,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat) (1398)",
    "ALT (koloni/g)",
  ],
  [7101, "", "\x{2264}100000", "\x{2264}10000"],
  [
    7102,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat) (1398)",
    "ALT (koloni/g)",
  ],
  [7103, "", "\x{2264}100000", "\x{2264}10000"],
  [
    7104,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat) (1398)",
    "Enterobacteriaceae (koloni/g)",
  ],
  [7105, "", "\x{2264}100", "\x{2264}10"],
  [
    7106,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat) (1398)",
    "Enterobacteriaceae (koloni/g)",
  ],
  [7107, "", "\x{2264}100", "\x{2264}10"],
  [
    7108,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat) (1398)",
    "Enterobacteriaceae (koloni/g)",
  ],
  [7109, "", "\x{2264}100", "\x{2264}10"],
  [
    7110,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat) (1398)",
    "Enterobacteriaceae (koloni/g)",
  ],
  [7111, "", "\x{2264}100", "\x{2264}10"],
  [
    7112,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat) (1398)",
    "Enterobacteriaceae (koloni/g)",
  ],
  [7113, "", "\x{2264}100", "\x{2264}10"],
  [
    7114,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat) (1398)",
    "Staphylococcus aureus (koloni/g)",
  ],
  [7115, "", "\x{2264}100", "\x{2264}10"],
  [
    7116,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat) (1398)",
    "Staphylococcus aureus (koloni/g)",
  ],
  [7117, "", "\x{2264}100", "\x{2264}10"],
  [
    7118,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat) (1398)",
    "Staphylococcus aureus (koloni/g)",
  ],
  [7119, "", "\x{2264}100", "\x{2264}10"],
  [
    7120,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat) (1398)",
    "Staphylococcus aureus (koloni/g)",
  ],
  [7121, "", "\x{2264}100", "\x{2264}10"],
  [
    7122,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat) (1398)",
    "Staphylococcus aureus (koloni/g)",
  ],
  [7123, "", "\x{2264}100", "\x{2264}10"],
  [
    7124,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat) (1398)",
    "Salmonella (koloni/25 g)",
  ],
  [
    7125,
    "PKMK untuk Pasien Penyakit Ginjal Kronik dengan Terapi Dialisis (Padat) (1398)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7126,
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan (08020312)",
    "Salmonella (/25 g)",
  ],
  [
    7127,
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan (08020312)",
    "Salmonella (/25 g)",
  ],
  [
    7128,
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan (08020312)",
    "Salmonella (/25 g)",
  ],
  [
    7129,
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan (08020312)",
    "Jumlah - Salmonella",
  ],
  [
    7130,
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan (08020312)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7131,
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan (08020312)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7132,
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan (08020312)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7133,
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan (08020312)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7134,
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan (08020312)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7135,
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan (08020312)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    7136,
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan (08020312)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    7137,
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan (08020312)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    7138,
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan (08020312)",
    "Jumlah - Listeria monocytogenes",
  ],
  [
    7139,
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan (08030241)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7140,
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan (08030241)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7141,
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan (08030241)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7142,
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan (08030241)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7143,
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan (08030241)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7144,
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan (08030241)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7145,
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan (08030241)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7146,
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan (08030241)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7147,
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan (08030241)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7148,
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan (08030241)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7149,
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan (08030241)",
    "Salmonella (/25 g)",
  ],
  [
    7150,
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan (08030241)",
    "Salmonella (/25 g)",
  ],
  [
    7151,
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan (08030241)",
    "Jumlah - Salmonella",
  ],
  [
    7152,
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan (08030241)",
    "Jumlah - Salmonella",
  ],
  [7153, "Praline (05010428)", "Salmonella (/25 g)"],
  [7154, "Praline (05010428)", "Jumlah Sampel - Salmonella"],
  [7155, "Pre-Fried Potatoes (0402020805)", "Salmonella (/25 g)"],
  [
    7156,
    "Pre-Fried Potatoes (0402020805)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7157,
    "Pre-Fried Potatoes (0402020805)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7158,
    "Pre-Fried Potatoes (0402020805)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7159,
    "Pre-Fried Potatoes (0402020805)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7160,
    "Pre-Fried Potatoes (0402020805)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7161,
    "Pre-Fried Potatoes (0402020805)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [7162, "Premiks Es Bentuk Bubuk (0321)", "Salmonella (/25ml)"],
  [
    7163,
    "Premiks Es Bentuk Bubuk (0321)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [7164, "Premiks Es Bentuk Cair (0322)", "Salmonella (/25ml)"],
  [
    7165,
    "Premiks Es Bentuk Cair (0322)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    7166,
    "Premiks Es Krim (Bubuk) (010712)",
    "Salmonella (koloni/25 g)",
  ],
  [
    7167,
    "Premiks Es Krim (Bubuk) (010712)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    7168,
    "Premiks Es Krim (Bubuk) (010712)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    7169,
    "Premiks Es Krim (Bubuk) (010712)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    7170,
    "Premiks Es Krim (Bubuk) (010712)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    7171,
    "Premiks Es Krim (Bubuk) (010712)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    7172,
    "Premiks Es Krim (Bubuk) (010712)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    7173,
    "Premiks Es Krim (Cair) (010715)",
    "Salmonella (koloni/25 g)",
  ],
  [
    7174,
    "Premiks Es Krim (Cair) (010715)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    7175,
    "Premiks Es Krim (Cair) (010715)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    7176,
    "Premiks Es Krim (Cair) (010715)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    7177,
    "Premiks Es Krim (Cair) (010715)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    7178,
    "Premiks Es Krim (Cair) (010715)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    7179,
    "Premiks Es Krim (Cair) (010715)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    7180,
    "Premiks Es Susu (Bubuk) (010721)",
    "Salmonella (koloni/25 g)",
  ],
  [
    7181,
    "Premiks Es Susu (Bubuk) (010721)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    7182,
    "Premiks Es Susu (Cair) (010722)",
    "Salmonella (koloni/25 g)",
  ],
  [
    7183,
    "Premiks Es Susu (Cair) (010722)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    7184,
    "Premiks Pengisi Roti (Serbuk) (050409)",
    "Salmonella (/25 g)",
  ],
  [
    7185,
    "Premiks Pengisi Roti (Serbuk) (050409)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7186,
    "Premiks Untuk Makanan Pencuci Mulut Berbasis Serealia dan Pati (060510)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7187,
    "Premiks Untuk Makanan Pencuci Mulut Berbasis Serealia dan Pati (060510)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7188,
    "Premiks Untuk Makanan Pencuci Mulut Berbasis Serealia dan Pati (060510)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7189,
    "Premiks Untuk Makanan Pencuci Mulut Berbasis Serealia dan Pati (060510)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7190,
    "Premiks Untuk Makanan Pencuci Mulut Berbasis Serealia dan Pati (060510)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7191,
    "Premiks Untuk Makanan Pencuci Mulut Berbasis Serealia dan Pati (060510)",
    "Salmonella (/25 g)",
  ],
  [
    7192,
    "Premiks Untuk Makanan Pencuci Mulut Berbasis Serealia dan Pati (060510)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7193,
    "Premiks Untuk Makanan Pencuci Mulut Berbasis Serealia dan Pati (060510)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7194,
    "Premiks Untuk Makanan Pencuci Mulut Berbasis Serealia dan Pati (060510)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7195,
    "Premiks Untuk Makanan Pencuci Mulut Berbasis Serealia dan Pati (060510)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7196,
    "Premiks Untuk Makanan Pencuci Mulut Berbasis Serealia dan Pati (060510)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7197,
    "Premiks Untuk Makanan Pencuci Mulut Berbasis Serealia dan Pati (060510)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7198,
    "Premiks Untuk Produk Bakeri Istimewa (07020301)",
    "Salmonella (/25 g)",
  ],
  [
    7199,
    "Premiks Untuk Produk Bakeri Istimewa (07020301)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7200,
    "Premiks Untuk Roti Tawar Dan Produk Bakeri Tawar (07010601)",
    "Salmonella (/25 g)",
  ],
  [
    7201,
    "Premiks Untuk Roti Tawar Dan Produk Bakeri Tawar (07010601)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7202,
    "Premiks Untuk Stuffing (07010405)",
    "Salmonella (/25 g)",
  ],
  [
    7203,
    "Premiks Untuk Stuffing (07010405)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7204,
    "Pressed Candy/Lozenges (05020103)",
    "Salmonella (/25 g)",
  ],
  [
    7205,
    "Pressed Candy/Lozenges (05020103)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7206,
    "Produk Buah Oles (0401020603)",
    "Salmonella (/25 g) - Semua produk dengan proses pasteurisasi",
  ],
  [
    7207,
    "Produk Buah Oles (0401020603)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    7208,
    "Produk Buah Oles (0401020603)",
    "Salmonella (/25 g) - Semua produk dengan proses non pasteurisasi",
  ],
  [
    7209,
    "Produk Buah Oles (0401020603)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    7210,
    "Produk Jeli Tidak Siap Konsumsi (0402020617)",
    "Salmonella (/25 g)",
  ],
  [
    7211,
    "Produk Jeli Tidak Siap Konsumsi (0402020617)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    7212,
    "Produk Makaroni Diperkaya (06040203)",
    "Salmonella (/25 g)",
  ],
  [
    7213,
    "Produk Makaroni Diperkaya (06040203)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7214,
    "Produk Makaroni Diperkaya dan Fortifikasi Protein (06040204)",
    "Salmonella (/25 g)",
  ],
  [
    7215,
    "Produk Makaroni Diperkaya dan Fortifikasi Protein (06040204)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7216,
    "Produk Makaroni Sayur yang Diperkaya (06040209)",
    "Salmonella (/25 g)",
  ],
  [
    7217,
    "Produk Makaroni Sayur yang Diperkaya (06040209)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7218,
    "Produk Makaroni Susu Tanpa Lemak (06040210)",
    "Salmonella (/25 g)",
  ],
  [
    7219,
    "Produk Makaroni Susu Tanpa Lemak (06040210)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7220,
    "Produk Makaroni Susu Tanpa Lemak Yang Diperkaya (06040211)",
    "Salmonella (/25 g)",
  ],
  [
    7221,
    "Produk Makaroni Susu Tanpa Lemak Yang Diperkaya (06040211)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7222,
    "Produk Mi Gandum dan Kedelai (06040213)",
    "Salmonella (/25 g)",
  ],
  [
    7223,
    "Produk Mi Gandum dan Kedelai (06040213)",
    "Jumlah Sampel - Salmonella",
  ],
  [7224, "Produk Mi Sayur (06040214)", "Salmonella (/25 g)"],
  [
    7225,
    "Produk Mi Sayur (06040214)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7226,
    "Produk Mi Sayur yang Diperkaya (06040215)",
    "Salmonella (/25 g)",
  ],
  [
    7227,
    "Produk Mi Sayur yang Diperkaya (06040215)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7228,
    "Produk Mi yang Diperkaya (06040212)",
    "Salmonella (/25 g)",
  ],
  [
    7229,
    "Produk Mi yang Diperkaya (06040212)",
    "Jumlah Sampel - Salmonella",
  ],
  [7230, "Produk Oles Untuk Salad (120701)", "Salmonella (/25 g)"],
  [7231, "Produk Oles Untuk Salad (120701)", "Salmonella (/25 g)"],
  [
    7232,
    "Produk Oles Untuk Salad (120701)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7233,
    "Produk Oles Untuk Salad (120701)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7234,
    "Produk Oles Untuk Salad (Misalnya Salad Makaroni, Salad Kentang) dan Sandwich, Tidak Mencakup Produk Oles Berbasis Cokelat dan Kacang Dari Kategori 04.2.2.5 dan 05.1.3 (1207)",
    "Salmonella (/25 g)",
  ],
  [
    7235,
    "Produk Oles Untuk Salad (Misalnya Salad Makaroni, Salad Kentang) dan Sandwich, Tidak Mencakup Produk Oles Berbasis Cokelat dan Kacang Dari Kategori 04.2.2.5 dan 05.1.3 (1207)",
    "Salmonella (/25 g)",
  ],
  [
    7236,
    "Produk Oles Untuk Salad (Misalnya Salad Makaroni, Salad Kentang) dan Sandwich, Tidak Mencakup Produk Oles Berbasis Cokelat dan Kacang Dari Kategori 04.2.2.5 dan 05.1.3 (1207)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7237,
    "Produk Oles Untuk Salad (Misalnya Salad Makaroni, Salad Kentang) dan Sandwich, Tidak Mencakup Produk Oles Berbasis Cokelat dan Kacang Dari Kategori 04.2.2.5 dan 05.1.3 (1207)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7238,
    "Produk Pasta Gandum dan Kedelai (06040206)",
    "Salmonella (/25 g)",
  ],
  [
    7239,
    "Produk Pasta Gandum dan Kedelai (06040206)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7240,
    "Produk Pasta Gandum Utuh (06040205)",
    "Salmonella (/25 g)",
  ],
  [
    7241,
    "Produk Pasta Gandum Utuh (06040205)",
    "Jumlah Sampel - Salmonella",
  ],
  [7242, "Produk Pasta Sayur (06040208)", "Salmonella (/25 g)"],
  [
    7243,
    "Produk Pasta Sayur (06040208)",
    "Jumlah Sampel - Salmonella",
  ],
  [7244, "Produk Pasta Susu (06040207)", "Salmonella (/25 g)"],
  [
    7245,
    "Produk Pasta Susu (06040207)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7246,
    "Puding berbahan dasar susu (010710)",
    "Salmonella (/25 g)",
  ],
  [
    7247,
    "Puding berbahan dasar susu (010710)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7248,
    "Puding Butterscotch atau Puding Susu (010706)",
    "Salmonella (/25 g)",
  ],
  [
    7249,
    "Puding Butterscotch atau Puding Susu (010706)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7250,
    "Puding Nasi (060505)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7251,
    "Puding Nasi (060505)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7252,
    "Puding Nasi (060505)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7253,
    "Puding Nasi (060505)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7254,
    "Puding Nasi (060505)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [7255, "Puding Nasi (060505)", "Salmonella (/25 g)"],
  [7256, "Puding Nasi (060505)", "Jumlah Sampel - Salmonella"],
  [
    7257,
    "Puding Nasi (060505)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7258,
    "Puding Nasi (060505)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7259,
    "Puding Nasi (060505)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7260,
    "Puding Nasi (060505)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7261,
    "Puding Nasi (060505)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7262,
    "Puding Tapioka (060506)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7263,
    "Puding Tapioka (060506)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7264,
    "Puding Tapioka (060506)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7265,
    "Puding Tapioka (060506)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7266,
    "Puding Tapioka (060506)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [7267, "Puding Tapioka (060506)", "Salmonella (/25 g)"],
  [7268, "Puding Tapioka (060506)", "Jumlah Sampel - Salmonella"],
  [
    7269,
    "Puding Tapioka (060506)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7270,
    "Puding Tapioka (060506)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7271,
    "Puding Tapioka (060506)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7272,
    "Puding Tapioka (060506)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7273,
    "Puding Tapioka (060506)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [7274, "Pukis (07020120)", "Salmonella (/25 g)"],
  [7275, "Pukis (07020120)", "Jumlah Sampel - Salmonella"],
  [
    7276,
    "Pukis (07020120)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7277,
    "Pukis (07020120)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7278,
    "Pukis (07020120)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7279,
    "Pukis (07020120)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7280,
    "Pukis (07020120)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [7281, "Puree Buah (0401020802)", "Jumlah Sampel - Salmonella"],
  [7282, "Puree Buah (0401020802)", "Salmonella (/25 g)"],
  [7283, "Puree Tomat (0402020501)", "Salmonella (/25 g)"],
  [7284, "Puree Tomat (0402020501)", "Jumlah Sampel - Salmonella"],
  [7285, "Putih Telur Beku (10020202)", "Salmonella (/25 g)"],
  [
    7286,
    "Putih Telur Beku (10020202)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7287,
    "Putu Ayu (060706)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7288,
    "Putu Ayu (060706)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7289,
    "Putu Ayu (060706)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7290,
    "Putu Ayu (060706)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7291,
    "Putu Ayu (060706)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [7292, "Putu Ayu (060706)", "Salmonella (/25 g)"],
  [7293, "Putu Ayu (060706)", "Jumlah Sampel - Salmonella"],
  [
    7294,
    "Putu Ayu (060706)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7295,
    "Putu Ayu (060706)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7296,
    "Putu Ayu (060706)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7297,
    "Putu Ayu (060706)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7298,
    "Putu Ayu (060706)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7299,
    "Raw Marzipan, Base Almond Paste (05020305)",
    "Salmonella (/25 g)",
  ],
  [
    7300,
    "Raw Marzipan, Base Almond Paste (05020305)",
    "Jumlah Sampel - Salmonella",
  ],
  [7301, "Rebon (09020533)", "Salmonella (/25 g)"],
  [
    7302,
    "Rebon (09020533)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    7303,
    "Remahan Biskuit (07020216)",
    "Jumlah Sampel - Salmonella",
  ],
  [7304, "Remahan Biskuit (07020216)", "Salmonella (/25 g)"],
  [
    7305,
    "Remahan Biskuit (07020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7306,
    "Remahan Biskuit (07020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7307,
    "Remahan Biskuit (07020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7308,
    "Remahan Biskuit (07020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7309,
    "Remahan Biskuit (07020216)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [7310, "Rempah (12020102)", "Salmonella (/25 g)"],
  [7311, "Rempah (12020102)", "Jumlah Sampel - Salmonella"],
  [
    7312,
    "Rempah (12020102)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7313,
    "Rempah (12020102)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7314,
    "Rempah (12020102)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7315,
    "Rempah (12020102)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7316,
    "Rempah (12020102)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7317,
    "Rempah (12020102)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7318,
    "Rempah (12020102)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7319,
    "Rempah (12020102)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7320,
    "Rempah (12020102)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7321,
    "Rempah (12020102)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [7322, "Rempah Bubuk (12020103)", "Salmonella (/25 g)"],
  [7323, "Rempah Bubuk (12020103)", "Jumlah Sampel - Salmonella"],
  [
    7324,
    "Rempah Bubuk (12020103)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7325,
    "Rempah Bubuk (12020103)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7326,
    "Rempah Bubuk (12020103)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7327,
    "Rempah Bubuk (12020103)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7328,
    "Rempah Bubuk (12020103)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7329,
    "Rempah Bubuk (12020103)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7330,
    "Rempah Bubuk (12020103)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7331,
    "Rempah Bubuk (12020103)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7332,
    "Rempah Bubuk (12020103)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7333,
    "Rempah Bubuk (12020103)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [7334, "Rempeyek (150128)", "Salmonella (/25 g)"],
  [7335, "Rempeyek (150128)", "Jumlah Sampel - Salmonella"],
  [
    7336,
    "Rempeyek (150128)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7337,
    "Rempeyek (150128)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7338,
    "Rempeyek (150128)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7339,
    "Rempeyek (150128)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7340,
    "Rempeyek (150128)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [7341, "Rempeyek Ikan (150305)", "Salmonella (/25 g)"],
  [7342, "Rempeyek Ikan (150305)", "Jumlah Sampel - Salmonella"],
  [
    7343,
    "Rempeyek Ikan (150305)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7344,
    "Rempeyek Ikan (150305)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7345,
    "Rempeyek Ikan (150305)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7346,
    "Rempeyek Ikan (150305)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7347,
    "Rempeyek Ikan (150305)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7348,
    "Rendang Ikan Tuna (0902040318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7349,
    "Rendang Ikan Tuna (0902040318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7350,
    "Rendang Ikan Tuna (0902040318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7351,
    "Rendang Ikan Tuna (0902040318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7352,
    "Rendang Ikan Tuna (0902040318)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7353,
    "Rendang Kerang (0902040319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7354,
    "Rendang Kerang (0902040319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7355,
    "Rendang Kerang (0902040319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7356,
    "Rendang Kerang (0902040319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7357,
    "Rendang Kerang (0902040319)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [7358, "Rendang Telur (10020305)", "Salmonella (koloni/25 g)"],
  [
    7359,
    "Rendang Telur (10020305)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [7360, "Rengginang/ Batiah (150127 )", "Salmonella (/25 g)"],
  [
    7361,
    "Rengginang/ Batiah (150127 )",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7362,
    "Rengginang/ Batiah (150127 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7363,
    "Rengginang/ Batiah (150127 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7364,
    "Rengginang/ Batiah (150127 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7365,
    "Rengginang/ Batiah (150127 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7366,
    "Rengginang/ Batiah (150127 )",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7367,
    "Rolade Daging (08030219)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7368,
    "Rolade Daging (08030219)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7369,
    "Rolade Daging (08030219)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7370,
    "Rolade Daging (08030219)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7371,
    "Rolade Daging (08030219)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7372,
    "Rolade Daging (08030219)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7373,
    "Rolade Daging (08030219)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7374,
    "Rolade Daging (08030219)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7375,
    "Rolade Daging (08030219)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7376,
    "Rolade Daging (08030219)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [7377, "Rolade Daging (08030219)", "Salmonella (/25 g)"],
  [7378, "Rolade Daging (08030219)", "Salmonella (/25 g)"],
  [7379, "Rolade Daging (08030219)", "Jumlah - Salmonella"],
  [7380, "Rolade Daging (08030219)", "Jumlah - Salmonella"],
  [
    7381,
    "Rolade Ikan (0902040129)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7382,
    "Rolade Ikan (0902040129)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7383,
    "Rolade Ikan (0902040129)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7384,
    "Rolade Ikan (0902040129)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7385,
    "Rolade Ikan (0902040129)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [7386, "Rollmops (09030101)", "Salmonella (/25 g)"],
  [7387, "Rollmops (09030101)", "Jumlah Sampel - Salmonella"],
  [7388, "Rosemari (12020188)", "Salmonella (/25 g)"],
  [7389, "Rosemari (12020188)", "Jumlah Sampel - Salmonella"],
  [7390, "Roti Bagelen (07020110)", "Salmonella (/25 g)"],
  [7391, "Roti Bagelen (07020110)", "Jumlah Sampel - Salmonella"],
  [
    7392,
    "Roti Bagelen (07020110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7393,
    "Roti Bagelen (07020110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7394,
    "Roti Bagelen (07020110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7395,
    "Roti Bagelen (07020110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7396,
    "Roti Bagelen (07020110)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [7397, "Roti Bagelen Pisang (07020111)", "Salmonella (/25 g)"],
  [
    7398,
    "Roti Bagelen Pisang (07020111)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7399,
    "Roti Bagelen Pisang (07020111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7400,
    "Roti Bagelen Pisang (07020111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7401,
    "Roti Bagelen Pisang (07020111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7402,
    "Roti Bagelen Pisang (07020111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7403,
    "Roti Bagelen Pisang (07020111)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7404,
    "Roti Buah/Roti Kismis/Roti Chocochips (0701010101)",
    "Salmonella (/25 g)",
  ],
  [
    7405,
    "Roti Buah/Roti Kismis/Roti Chocochips (0701010101)",
    "Jumlah Sampel - Salmonella",
  ],
  [7406, "Roti Buaya (07020207)", "Salmonella (/25 g)"],
  [7407, "Roti Buaya (07020207)", "Jumlah Sampel - Salmonella"],
  [
    7408,
    "Roti Buaya (07020207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7409,
    "Roti Buaya (07020207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7410,
    "Roti Buaya (07020207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7411,
    "Roti Buaya (07020207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7412,
    "Roti Buaya (07020207)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7413,
    "Roti Campuran Tepung Terigu dan Kulit Gandum / Roti dengan Kulit Gandum (Fine Bran) (0701010116)",
    "Salmonella (/25 g)",
  ],
  [
    7414,
    "Roti Campuran Tepung Terigu dan Kulit Gandum / Roti dengan Kulit Gandum (Fine Bran) (0701010116)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7415,
    "Roti Canai/Roti Cane/Roti Kane/Roti Kanai/Roti Maryam (07010306)",
    "Salmonella (/25 g)",
  ],
  [
    7416,
    "Roti Canai/Roti Cane/Roti Kane/Roti Kanai/Roti Maryam (07010306)",
    "Jumlah Sampel - Salmonella",
  ],
  [7417, "Roti Diperkaya (0701010102)", "Salmonella (/25 g)"],
  [
    7418,
    "Roti Diperkaya (0701010102)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7419,
    "Roti Gandum Utuh (WholeWheat) (0701010111)",
    "Salmonella (/25 g)",
  ],
  [
    7420,
    "Roti Gandum Utuh (WholeWheat) (0701010111)",
    "Jumlah Sampel - Salmonella",
  ],
  [7421, "Roti Isi (07020203)", "Salmonella (/25 g)"],
  [7422, "Roti Isi (07020203)", "Jumlah Sampel - Salmonella"],
  [
    7423,
    "Roti Isi (07020203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7424,
    "Roti Isi (07020203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7425,
    "Roti Isi (07020203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7426,
    "Roti Isi (07020203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7427,
    "Roti Isi (07020203)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [7428, "Roti Jala (07010307)", "Salmonella (/25 g)"],
  [7429, "Roti Jala (07010307)", "Jumlah Sampel - Salmonella"],
  [7430, "Roti Kadet (0701010103)", "Salmonella (/25 g)"],
  [7431, "Roti Kadet (0701010103)", "Jumlah Sampel - Salmonella"],
  [7432, "Roti Kadet Gandum (0701010119)", "Salmonella (/25 g)"],
  [
    7433,
    "Roti Kadet Gandum (0701010119)",
    "Jumlah Sampel - Salmonella",
  ],
  [7434, "Roti Kadet Susu (0701010120)", "Salmonella (/25 g)"],
  [
    7435,
    "Roti Kadet Susu (0701010120)",
    "Jumlah Sampel - Salmonella",
  ],
  [7436, "Roti Malt (0701010118)", "Salmonella (/25 g)"],
  [7437, "Roti Malt (0701010118)", "Jumlah Sampel - Salmonella"],
  [7438, "Roti Manis (07020202)", "Salmonella (/25 g)"],
  [7439, "Roti Manis (07020202)", "Jumlah Sampel - Salmonella"],
  [
    7440,
    "Roti Manis (07020202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7441,
    "Roti Manis (07020202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7442,
    "Roti Manis (07020202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7443,
    "Roti Manis (07020202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7444,
    "Roti Manis (07020202)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [7445, "Roti Meal (0701010109)", "Salmonella (/25 g)"],
  [7446, "Roti Meal (0701010109)", "Jumlah Sampel - Salmonella"],
  [
    7447,
    "Roti Meal Utuh (Whole Meal) (0701010110)",
    "Salmonella (/25 g)",
  ],
  [
    7448,
    "Roti Meal Utuh (Whole Meal) (0701010110)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7449,
    "Roti Perancis (Baguette/pain courant francais) (0701010117)",
    "Salmonella (/25 g)",
  ],
  [
    7450,
    "Roti Perancis (Baguette/pain courant francais) (0701010117)",
    "Jumlah Sampel - Salmonella",
  ],
  [7451, "Roti Pita (07010303)", "Salmonella (/25 g)"],
  [7452, "Roti Pita (07010303)", "Jumlah Sampel - Salmonella"],
  [7453, "Roti Pumpernickel (0701010113)", "Salmonella (/25 g)"],
  [
    7454,
    "Roti Pumpernickel (0701010113)",
    "Jumlah Sampel - Salmonella",
  ],
  [7455, "Roti Putih (0701010105)", "Salmonella (/25 g)"],
  [7456, "Roti Putih (0701010105)", "Jumlah Sampel - Salmonella"],
  [7457, "Roti Rye (0701010112)", "Salmonella (/25 g)"],
  [7458, "Roti Rye (0701010112)", "Jumlah Sampel - Salmonella"],
  [7459, "Roti Soda (07010102)", "Salmonella (/25 g)"],
  [7460, "Roti Soda (07010102)", "Jumlah Sampel - Salmonella"],
  [7461, "Roti Soda (0701010201)", "Salmonella (/25 g)"],
  [7462, "Roti Soda (0701010201)", "Jumlah Sampel - Salmonella"],
  [
    7463,
    "Roti Susu, Roll Susu, Bun Susu (0701010107)",
    "Salmonella (/25 g)",
  ],
  [
    7464,
    "Roti Susu, Roll Susu, Bun Susu (0701010107)",
    "Jumlah Sampel - Salmonella",
  ],
  [7465, "Roti Tawar (0701010104)", "Salmonella (/25 g)"],
  [7466, "Roti Tawar (0701010104)", "Jumlah Sampel - Salmonella"],
  [
    7467,
    "Roti Tawar dengan penambahan bahan pangan lain (0701010115)",
    "Salmonella (/25 g)",
  ],
  [
    7468,
    "Roti Tawar dengan penambahan bahan pangan lain (0701010115)",
    "Jumlah Sampel - Salmonella",
  ],
  [7469, "Roti Tawar Kupas (0701010106)", "Salmonella (/25 g)"],
  [
    7470,
    "Roti Tawar Kupas (0701010106)",
    "Jumlah Sampel - Salmonella",
  ],
  [7471, "Roti Untuk Stuffing (07010404)", "Salmonella (/25 g)"],
  [
    7472,
    "Roti Untuk Stuffing (07010404)",
    "Jumlah Sampel - Salmonella",
  ],
  [7473, "Roti Wheat-Germ (0701010108)", "Salmonella (/25 g)"],
  [
    7474,
    "Roti Wheat-Germ (0701010108)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7475,
    "Roti Yang Dikembangkan Dengan Kamir dan Roti Istimewa (07010101)",
    "Salmonella (/25 g)",
  ],
  [
    7476,
    "Roti Yang Dikembangkan Dengan Kamir dan Roti Istimewa (07010101)",
    "Jumlah Sampel - Salmonella",
  ],
  [7477, "Rujak (0401020303)", "Jumlah Sampel - Salmonella"],
  [7478, "Rujak (0401020303)", "Salmonella (/25 g)"],
  [7479, "Rusip (09020532)", "Salmonella (/25 g)"],
  [
    7480,
    "Rusip (09020532)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [7481, "Saffron (12020190)", "Salmonella (/25 g)"],
  [7482, "Saffron (12020190)", "Jumlah Sampel - Salmonella"],
  [
    7483,
    "Saffron (12020190)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7484,
    "Saffron (12020190)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7485,
    "Saffron (12020190)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7486,
    "Saffron (12020190)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7487,
    "Saffron (12020190)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}100000",
    "\x{2264}10000",
  ],
  [
    7488,
    "Saffron (12020190)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7489,
    "Saffron (12020190)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7490,
    "Saffron (12020190)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7491,
    "Saffron (12020190)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7492,
    "Saffron (12020190)",
    "Clostridium pefringens (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [7493, "Saga (12020189)", "Salmonella (/25 g)"],
  [7494, "Saga (12020189)", "Jumlah Sampel - Salmonella"],
  [
    7495,
    "Sagu/Pati Mutiara (060511)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7496,
    "Sagu/Pati Mutiara (060511)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7497,
    "Sagu/Pati Mutiara (060511)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7498,
    "Sagu/Pati Mutiara (060511)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7499,
    "Sagu/Pati Mutiara (060511)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [7500, "Sagu/Pati Mutiara (060511)", "Salmonella (/25 g)"],
  [
    7501,
    "Sagu/Pati Mutiara (060511)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7502,
    "Sagu/Pati Mutiara (060511)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7503,
    "Sagu/Pati Mutiara (060511)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7504,
    "Sagu/Pati Mutiara (060511)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7505,
    "Sagu/Pati Mutiara (060511)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7506,
    "Sagu/Pati Mutiara (060511)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7507,
    "Salad Dressing (Misalnya Thousand Island, Blue Cheese, Burger Dressing, dll) (12060102)",
    "Salmonella (/25 g)",
  ],
  [
    7508,
    "Salad Dressing (Misalnya Thousand Island, Blue Cheese, Burger Dressing, dll) (12060102)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7509,
    "Salami (0803010303)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7510,
    "Salami (0803010303)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7511,
    "Salami (0803010303)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7512,
    "Salami (0803010303)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7513,
    "Salami (0803010303)",
    "Staphylococcus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [7514, "Salami (0803010303)", "Salmonella (/25 g)"],
  [7515, "Salami (0803010303)", "Salmonella (/25 g)"],
  [7516, "Salami (0803010303)", "Jumlah - Salmonella"],
  [
    7517,
    "Salami (0803010303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7518,
    "Salami (0803010303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7519,
    "Salami (0803010303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7520,
    "Salami (0803010303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7521,
    "Salami (0803010303)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [7522, "Salami (0803010303)", "Jumlah Sampel - Salmonella"],
  [
    7523,
    "Salami Matang / Pepperoni Matang (08030229)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7524,
    "Salami Matang / Pepperoni Matang (08030229)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7525,
    "Salami Matang / Pepperoni Matang (08030229)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7526,
    "Salami Matang / Pepperoni Matang (08030229)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7527,
    "Salami Matang / Pepperoni Matang (08030229)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7528,
    "Salami Matang / Pepperoni Matang (08030229)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7529,
    "Salami Matang / Pepperoni Matang (08030229)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7530,
    "Salami Matang / Pepperoni Matang (08030229)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7531,
    "Salami Matang / Pepperoni Matang (08030229)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7532,
    "Salami Matang / Pepperoni Matang (08030229)",
    "Staphylococcus (koloni/g)",
    "\x{2264}200",
    "\x{2264}100",
  ],
  [
    7533,
    "Salami Matang / Pepperoni Matang (08030229)",
    "Salmonella (/25 g)",
  ],
  [
    7534,
    "Salami Matang / Pepperoni Matang (08030229)",
    "Salmonella (/25 g)",
  ],
  [
    7535,
    "Salami Matang / Pepperoni Matang (08030229)",
    "Jumlah - Salmonella",
  ],
  [
    7536,
    "Salami Matang / Pepperoni Matang (08030229)",
    "Jumlah - Salmonella",
  ],
  [7537, "Salsa (0402020606)", "Salmonella (/25 g)"],
  [7538, "Salsa (0402020606)", "Jumlah Sampel - Salmonella"],
  [7539, "Sambal Buah (0401020602)", "Jumlah Sampel - Salmonella"],
  [7540, "Sambal Buah (0401020602)", "Salmonella (/25 g)"],
  [
    7541,
    "Sambal Goreng Ikan (0902040312)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7542,
    "Sambal Goreng Ikan (0902040312)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7543,
    "Sambal Goreng Ikan (0902040312)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7544,
    "Sambal Goreng Ikan (0902040312)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7545,
    "Sambal Goreng Ikan (0902040312)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7546,
    "Sambal Goreng Udang (0902040301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7547,
    "Sambal Goreng Udang (0902040301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7548,
    "Sambal Goreng Udang (0902040301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7549,
    "Sambal Goreng Udang (0902040301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7550,
    "Sambal Goreng Udang (0902040301)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7551,
    "Sambal Goreng Udang Kering (Ebi) (0902040302)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7552,
    "Sambal Goreng Udang Kering (Ebi) (0902040302)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7553,
    "Sambal Goreng Udang Kering (Ebi) (0902040302)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7554,
    "Sambal Goreng Udang Kering (Ebi) (0902040302)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7555,
    "Sambal Goreng Udang Kering (Ebi) (0902040302)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}100",
  ],
  [
    7556,
    "Sambal Kecap/Saus Sambal Kecap (12060202)",
    "Salmonella (/25 g)",
  ],
  [
    7557,
    "Sambal Kecap/Saus Sambal Kecap (12060202)",
    "Jumlah Sampel - Salmonella",
  ],
  [7558, "Sandwich Spread (12060108)", "Salmonella (/25 g)"],
  [
    7559,
    "Sandwich Spread (12060108)",
    "Jumlah Sampel - Salmonella",
  ],
  [7560, "Santan Bubuk (0401020209)", "Salmonella (/25g)"],
  [
    7561,
    "Santan Bubuk (0401020209)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    7562,
    "Santan Ekstraksi Air (0401020808)",
    "Salmonella (/25 g)",
  ],
  [
    7563,
    "Santan Ekstraksi Air (0401020808)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7564,
    "Santan/Santan Encer/Krim Kelapa/Konsentrat Krim Kelapa (0401020807)",
    "Salmonella (/25 g)",
  ],
  [
    7565,
    "Santan/Santan Encer/Krim Kelapa/Konsentrat Krim Kelapa (0401020807)",
    "Jumlah Sampel - Salmonella",
  ],
  [7566, "Sarden Media Saus Tomat (090409)", "Salmonella (/25 g)"],
  [7567, "Sarden Media Saus Tomat (090409)", "Salmonella (/25 g)"],
  [
    7568,
    "Sarden Media Saus Tomat (090409)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7569,
    "Sarden Media Saus Tomat (090409)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7570,
    "Sarden Media Saus Tomat (090409)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    7571,
    "Sarden Media Saus Tomat (090409)",
    "Listeria monocytogenes (koloni/25 g)",
  ],
  [
    7572,
    "Sarden Media Saus Tomat (090409)",
    "Jumlah Sampel -Listeria monocytogenes",
  ],
  [
    7573,
    "Sarden Media Saus Tomat (090409)",
    "Jumlah Sampel -Listeria monocytogenes",
  ],
  [7574, "Sari Buah (1401020101)", "Salmonella (/25 ml)"],
  [7575, "Sari Buah (1401020101)", "Salmonella (/25 ml)"],
  [7576, "Sari Buah (1401020101)", "Jumlah Sampel - Salmonella"],
  [7577, "Sari Buah (1401020101)", "Jumlah Sampel - Salmonella"],
  [
    7578,
    "Sari Buah (Kemasan Tetrapack) (1401020131)",
    "Salmonella (/25 ml)",
  ],
  [
    7579,
    "Sari Buah (Kemasan Tetrapack) (1401020131)",
    "Salmonella (/25 ml)",
  ],
  [
    7580,
    "Sari Buah (Kemasan Tetrapack) (1401020131)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7581,
    "Sari Buah (Kemasan Tetrapack) (1401020131)",
    "Jumlah Sampel - Salmonella",
  ],
  [7582, "Sari Buah Anggur (1401020112)", "Salmonella (/25 ml)"],
  [7583, "Sari Buah Anggur (1401020112)", "Salmonella (/25 ml)"],
  [
    7584,
    "Sari Buah Anggur (1401020112)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7585,
    "Sari Buah Anggur (1401020112)",
    "Jumlah Sampel - Salmonella",
  ],
  [7586, "Sari Buah Apel (1401020104)", "Salmonella (/25 ml)"],
  [7587, "Sari Buah Apel (1401020104)", "Salmonella (/25 ml)"],
  [
    7588,
    "Sari Buah Apel (1401020104)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7589,
    "Sari Buah Apel (1401020104)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7590,
    "Sari Buah Belimbing (1401020118)",
    "Salmonella (/25 ml)",
  ],
  [
    7591,
    "Sari Buah Belimbing (1401020118)",
    "Salmonella (/25 ml)",
  ],
  [
    7592,
    "Sari Buah Belimbing (1401020118)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7593,
    "Sari Buah Belimbing (1401020118)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7594,
    "Sari Buah Blackberry (1401020126)",
    "Salmonella (/25 ml)",
  ],
  [
    7595,
    "Sari Buah Blackberry (1401020126)",
    "Salmonella (/25 ml)",
  ],
  [
    7596,
    "Sari Buah Blackberry (1401020126)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7597,
    "Sari Buah Blackberry (1401020126)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7598,
    "Sari Buah Blackcurrant (1401020114)",
    "Salmonella (/25 ml)",
  ],
  [
    7599,
    "Sari Buah Blackcurrant (1401020114)",
    "Salmonella (/25 ml)",
  ],
  [
    7600,
    "Sari Buah Blackcurrant (1401020114)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7601,
    "Sari Buah Blackcurrant (1401020114)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7602,
    "Sari Buah Blueberry (1401020136)",
    "Salmonella (/25 ml)",
  ],
  [
    7603,
    "Sari Buah Blueberry (1401020136)",
    "Salmonella (/25 ml)",
  ],
  [
    7604,
    "Sari Buah Blueberry (1401020136)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7605,
    "Sari Buah Blueberry (1401020136)",
    "Jumlah Sampel - Salmonella",
  ],
  [7606, "Sari Buah Campuran (1401020102)", "Salmonella (/25 ml)"],
  [7607, "Sari Buah Campuran (1401020102)", "Salmonella (/25 ml)"],
  [
    7608,
    "Sari Buah Campuran (1401020102)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7609,
    "Sari Buah Campuran (1401020102)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7610,
    "Sari Buah dan Sari Sayur (1401020132)",
    "Salmonella (/25 ml)",
  ],
  [
    7611,
    "Sari Buah dan Sari Sayur (1401020132)",
    "Salmonella (/25 ml)",
  ],
  [
    7612,
    "Sari Buah dan Sari Sayur (1401020132)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7613,
    "Sari Buah dan Sari Sayur (1401020132)",
    "Jumlah Sampel - Salmonella",
  ],
  [7614, "Sari Buah Delima (1401020123)", "Salmonella (/25 ml)"],
  [7615, "Sari Buah Delima (1401020123)", "Salmonella (/25 ml)"],
  [
    7616,
    "Sari Buah Delima (1401020123)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7617,
    "Sari Buah Delima (1401020123)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7618,
    "Sari Buah Jambu Biji (1401020122)",
    "Salmonella (/25 ml)",
  ],
  [
    7619,
    "Sari Buah Jambu Biji (1401020122)",
    "Salmonella (/25 ml)",
  ],
  [
    7620,
    "Sari Buah Jambu Biji (1401020122)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7621,
    "Sari Buah Jambu Biji (1401020122)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7622,
    "Sari Buah Jeruk Bali (1401020105)",
    "Salmonella (/25 ml)",
  ],
  [
    7623,
    "Sari Buah Jeruk Bali (1401020105)",
    "Salmonella (/25 ml)",
  ],
  [
    7624,
    "Sari Buah Jeruk Bali (1401020105)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7625,
    "Sari Buah Jeruk Bali (1401020105)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7626,
    "Sari Buah Jeruk Garut (1401020133)",
    "Salmonella (/25 ml)",
  ],
  [
    7627,
    "Sari Buah Jeruk Garut (1401020133)",
    "Salmonella (/25 ml)",
  ],
  [
    7628,
    "Sari Buah Jeruk Garut (1401020133)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7629,
    "Sari Buah Jeruk Garut (1401020133)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7630,
    "Sari Buah Jeruk Medan (1401020134)",
    "Salmonella (/25 ml)",
  ],
  [
    7631,
    "Sari Buah Jeruk Medan (1401020134)",
    "Salmonella (/25 ml)",
  ],
  [
    7632,
    "Sari Buah Jeruk Medan (1401020134)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7633,
    "Sari Buah Jeruk Medan (1401020134)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7634,
    "Sari Buah Jeruk Orange, Valencia (1401020106)",
    "Salmonella (/25 ml)",
  ],
  [
    7635,
    "Sari Buah Jeruk Orange, Valencia (1401020106)",
    "Salmonella (/25 ml)",
  ],
  [
    7636,
    "Sari Buah Jeruk Orange, Valencia (1401020106)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7637,
    "Sari Buah Jeruk Orange, Valencia (1401020106)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7638,
    "Sari Buah Jeruk Siam, Tangerine, Jeruk Pontianak (1401020107)",
    "Salmonella (/25 ml)",
  ],
  [
    7639,
    "Sari Buah Jeruk Siam, Tangerine, Jeruk Pontianak (1401020107)",
    "Salmonella (/25 ml)",
  ],
  [
    7640,
    "Sari Buah Jeruk Siam, Tangerine, Jeruk Pontianak (1401020107)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7641,
    "Sari Buah Jeruk Siam, Tangerine, Jeruk Pontianak (1401020107)",
    "Jumlah Sampel - Salmonella",
  ],
  [7642, "Sari Buah Kiwi (1401020138)", "Salmonella (/25 ml)"],
  [7643, "Sari Buah Kiwi (1401020138)", "Salmonella (/25 ml)"],
  [
    7644,
    "Sari Buah Kiwi (1401020138)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7645,
    "Sari Buah Kiwi (1401020138)",
    "Jumlah Sampel - Salmonella",
  ],
  [7646, "Sari Buah Leci (1401020137)", "Salmonella (/25 ml)"],
  [7647, "Sari Buah Leci (1401020137)", "Salmonella (/25 ml)"],
  [
    7648,
    "Sari Buah Leci (1401020137)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7649,
    "Sari Buah Leci (1401020137)",
    "Jumlah Sampel - Salmonella",
  ],
  [7650, "Sari Buah Lemon (1401020110)", "Salmonella (/25 ml)"],
  [7651, "Sari Buah Lemon (1401020110)", "Salmonella (/25 ml)"],
  [
    7652,
    "Sari Buah Lemon (1401020110)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7653,
    "Sari Buah Lemon (1401020110)",
    "Jumlah Sampel - Salmonella",
  ],
  [7654, "Sari Buah Mangga (1401020115)", "Salmonella (/25 ml)"],
  [7655, "Sari Buah Mangga (1401020115)", "Salmonella (/25 ml)"],
  [
    7656,
    "Sari Buah Mangga (1401020115)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7657,
    "Sari Buah Mangga (1401020115)",
    "Jumlah Sampel - Salmonella",
  ],
  [7658, "Sari Buah Manggis (1401020129)", "Salmonella (/25 ml)"],
  [7659, "Sari Buah Manggis (1401020129)", "Salmonella (/25 ml)"],
  [
    7660,
    "Sari Buah Manggis (1401020129)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7661,
    "Sari Buah Manggis (1401020129)",
    "Jumlah Sampel - Salmonella",
  ],
  [7662, "Sari Buah Markisa (1401020111)", "Salmonella (/25 ml)"],
  [7663, "Sari Buah Markisa (1401020111)", "Salmonella (/25 ml)"],
  [
    7664,
    "Sari Buah Markisa (1401020111)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7665,
    "Sari Buah Markisa (1401020111)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7666,
    "Sari Buah Naga (1401020139)",
    "Salmonella (koloni/25 ml) - Tidak DiPasteurisasi",
  ],
  [
    7667,
    "Sari Buah Naga (1401020139)",
    "Jumlah Sampel - Salmonella - Tidak DiPasteurisasi",
  ],
  [7668, "Sari Buah Nanas (1401020109)", "Salmonella (/25 ml)"],
  [7669, "Sari Buah Nanas (1401020109)", "Salmonella (/25 ml)"],
  [
    7670,
    "Sari Buah Nanas (1401020109)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7671,
    "Sari Buah Nanas (1401020109)",
    "Jumlah Sampel - Salmonella",
  ],
  [7672, "Sari Buah Peach (1401020121)", "Salmonella (/25 ml)"],
  [7673, "Sari Buah Peach (1401020121)", "Salmonella (/25 ml)"],
  [
    7674,
    "Sari Buah Peach (1401020121)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7675,
    "Sari Buah Peach (1401020121)",
    "Jumlah Sampel - Salmonella",
  ],
  [7676, "Sari Buah Pir (1401020124)", "Salmonella (/25 ml)"],
  [7677, "Sari Buah Pir (1401020124)", "Salmonella (/25 ml)"],
  [
    7678,
    "Sari Buah Pir (1401020124)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7679,
    "Sari Buah Pir (1401020124)",
    "Jumlah Sampel - Salmonella",
  ],
  [7680, "Sari Buah Plum (1401020120)", "Salmonella (/25 ml)"],
  [7681, "Sari Buah Plum (1401020120)", "Salmonella (/25 ml)"],
  [
    7682,
    "Sari Buah Plum (1401020120)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7683,
    "Sari Buah Plum (1401020120)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7684,
    "Sari Buah Prune (Prune Juice) (1401020135)",
    "Salmonella (/25 ml)",
  ],
  [
    7685,
    "Sari Buah Prune (Prune Juice) (1401020135)",
    "Salmonella (/25 ml)",
  ],
  [
    7686,
    "Sari Buah Prune (Prune Juice) (1401020135)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7687,
    "Sari Buah Prune (Prune Juice) (1401020135)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7688,
    "Sari Buah Raspberry (1401020127)",
    "Salmonella (/25 ml)",
  ],
  [
    7689,
    "Sari Buah Raspberry (1401020127)",
    "Salmonella (/25 ml)",
  ],
  [
    7690,
    "Sari Buah Raspberry (1401020127)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7691,
    "Sari Buah Raspberry (1401020127)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7692,
    "Sari Buah Redcurrant (1401020125)",
    "Salmonella (/25 ml)",
  ],
  [
    7693,
    "Sari Buah Redcurrant (1401020125)",
    "Salmonella (/25 ml)",
  ],
  [
    7694,
    "Sari Buah Redcurrant (1401020125)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7695,
    "Sari Buah Redcurrant (1401020125)",
    "Jumlah Sampel - Salmonella",
  ],
  [7696, "Sari Buah Sirsak (1401020116)", "Salmonella (/25 ml)"],
  [7697, "Sari Buah Sirsak (1401020116)", "Salmonella (/25 ml)"],
  [
    7698,
    "Sari Buah Sirsak (1401020116)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7699,
    "Sari Buah Sirsak (1401020116)",
    "Jumlah Sampel - Salmonella",
  ],
  [7700, "Sari Buah Stroberi (1401020128)", "Salmonella (/25 ml)"],
  [7701, "Sari Buah Stroberi (1401020128)", "Salmonella (/25 ml)"],
  [
    7702,
    "Sari Buah Stroberi (1401020128)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7703,
    "Sari Buah Stroberi (1401020128)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7704,
    "Sari Buah Terong Belanda (1401020130)",
    "Salmonella (/25 ml)",
  ],
  [
    7705,
    "Sari Buah Terong Belanda (1401020130)",
    "Salmonella (/25 ml)",
  ],
  [
    7706,
    "Sari Buah Terong Belanda (1401020130)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7707,
    "Sari Buah Terong Belanda (1401020130)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7708,
    "Sari Jeruk Nipis (Lime Juice) (1401020103)",
    "Salmonella (/25 ml)",
  ],
  [
    7709,
    "Sari Jeruk Nipis (Lime Juice) (1401020103)",
    "Salmonella (/25 ml)",
  ],
  [
    7710,
    "Sari Jeruk Nipis (Lime Juice) (1401020103)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7711,
    "Sari Jeruk Nipis (Lime Juice) (1401020103)",
    "Jumlah Sampel - Salmonella",
  ],
  [7712, "Sari Kedelai (06080101)", "Salmonella (/25 g)"],
  [7713, "Sari Kedelai (06080101)", "Jumlah Sampel - Salmonella"],
  [
    7714,
    "Sari Sayur (1401020201)",
    "Salmonella (koloni/25 ml) - Tidak DiPasteurisasi",
  ],
  [
    7715,
    "Sari Sayur (1401020201)",
    "Jumlah Sampel - Salmonella - Tidak DiPasteurisasi",
  ],
  [
    7716,
    "Sari Sayur (Kemasan Tetrapack) (1401020204)",
    "Salmonella (koloni/25 ml) - Tidak DiPasteurisasi",
  ],
  [
    7717,
    "Sari Sayur (Kemasan Tetrapack) (1401020204)",
    "Jumlah Sampel - Salmonella - Tidak DiPasteurisasi",
  ],
  [
    7718,
    "Sari Sayur Campuran (1401020206)",
    "Salmonella (koloni/25 ml) - Tidak DiPasteurisasi",
  ],
  [
    7719,
    "Sari Sayur Campuran (1401020206)",
    "Jumlah Sampel - Salmonella - Tidak DiPasteurisasi",
  ],
  [
    7720,
    "Sari Sayur dan Sari Buah (1401020207)",
    "Salmonella (koloni/25 ml) - Tidak DiPasteurisasi",
  ],
  [
    7721,
    "Sari Sayur dan Sari Buah (1401020207)",
    "Jumlah Sampel - Salmonella - Tidak DiPasteurisasi",
  ],
  [
    7722,
    "Sari Tomat (1401020202)",
    "Salmonella (koloni/25 ml) - Tidak DiPasteurisasi",
  ],
  [
    7723,
    "Sari Tomat (1401020202)",
    "Jumlah Sampel - Salmonella - Tidak DiPasteurisasi",
  ],
  [
    7724,
    "Sari Wortel (1401020203)",
    "Salmonella (koloni/25 ml) - Tidak DiPasteurisasi",
  ],
  [
    7725,
    "Sari Wortel (1401020203)",
    "Jumlah Sampel - Salmonella - Tidak DiPasteurisasi",
  ],
  [7726, "Sauerkraut (0402020703)", "Salmonella (/25 g)"],
  [7727, "Sauerkraut (0402020703)", "Jumlah Sampel - Salmonella"],
  [
    7728,
    "Saus Apel (Applesauce) (0401020805)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7729,
    "Saus Apel (Applesauce) (0401020805)",
    "Salmonella (/25 g)",
  ],
  [7730, "Saus Asam Manis (12060221)", "Salmonella (/25 g)"],
  [
    7731,
    "Saus Asam Manis (12060221)",
    "Jumlah Sampel - Salmonella",
  ],
  [7732, "Saus Buah (0401020804)", "Jumlah Sampel - Salmonella"],
  [7733, "Saus Buah (0401020804)", "Salmonella (/25 g)"],
  [
    7734,
    "Saus Bumbu Non-Emulsi Lainnya (12060222)",
    "Salmonella (/25 g)",
  ],
  [
    7735,
    "Saus Bumbu Non-Emulsi Lainnya (12060222)",
    "Jumlah Sampel - Salmonella",
  ],
  [7736, "Saus Bumbu Teremulsi (12060106)", "Salmonella (/25 g)"],
  [
    7737,
    "Saus Bumbu Teremulsi (12060106)",
    "Jumlah Sampel - Salmonella",
  ],
  [7738, "Saus Butterscotch (050403)", "Salmonella (/25 g)"],
  [
    7739,
    "Saus Butterscotch (050403)",
    "Jumlah Sampel - Salmonella",
  ],
  [7740, "Saus Cabe (12060201)", "Salmonella (/25 g)"],
  [7741, "Saus Cabe (12060201)", "Jumlah Sampel - Salmonella"],
  [
    7742,
    "Saus Keju (Cheese Sauce) (12060209)",
    "Salmonella (/25 g)",
  ],
  [
    7743,
    "Saus Keju (Cheese Sauce) (12060209)",
    "Salmonella (/25 g)",
  ],
  [
    7744,
    "Saus Keju (Cheese Sauce) (12060209)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7745,
    "Saus Keju (Cheese Sauce) (12060209)",
    "Jumlah Sampel - Salmonella",
  ],
  [7746, "Saus Lobak (12060210)", "Salmonella (/25 g)"],
  [7747, "Saus Lobak (12060210)", "Salmonella (/25 g)"],
  [7748, "Saus Lobak (12060210)", "Jumlah Sampel - Salmonella"],
  [7749, "Saus Lobak (12060210)", "Jumlah Sampel - Salmonella"],
  [
    7750,
    "Saus Panggang/Saus Barbekue (BBQ Sauce) (12060211)",
    "Salmonella (/25 g)",
  ],
  [
    7751,
    "Saus Panggang/Saus Barbekue (BBQ Sauce) (12060211)",
    "Salmonella (/25 g)",
  ],
  [
    7752,
    "Saus Panggang/Saus Barbekue (BBQ Sauce) (12060211)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7753,
    "Saus Panggang/Saus Barbekue (BBQ Sauce) (12060211)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7754,
    "Saus Perendam/Saus Marinasi (Marinated Sauce) (12060216)",
    "Salmonella (/25 g)",
  ],
  [
    7755,
    "Saus Perendam/Saus Marinasi (Marinated Sauce) (12060216)",
    "Salmonella (/25 g)",
  ],
  [
    7756,
    "Saus Perendam/Saus Marinasi (Marinated Sauce) (12060216)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7757,
    "Saus Perendam/Saus Marinasi (Marinated Sauce) (12060216)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7758,
    "Saus Putih (Berbasis Krim) (12060232)",
    "Salmonella (/25 g)",
  ],
  [
    7759,
    "Saus Putih (Berbasis Krim) (12060232)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [7760, "Saus Salsa (12060230)", "Salmonella (/25 g)"],
  [7761, "Saus Salsa (12060230)", "Jumlah Sampel - Salmonella"],
  [
    7762,
    "Saus Sambal Cabe Hijau (12060203)",
    "Salmonella (/25 g)",
  ],
  [
    7763,
    "Saus Sambal Cabe Hijau (12060203)",
    "Jumlah Sampel - Salmonella",
  ],
  [7764, "Saus Sate (12060213)", "Salmonella (/25 g)"],
  [7765, "Saus Sate (12060213)", "Jumlah Sampel - Salmonella"],
  [
    7766,
    "Saus Spagheti (Spaghetti Sauce) (12060214)",
    "Salmonella (/25 g)",
  ],
  [
    7767,
    "Saus Spagheti (Spaghetti Sauce) (12060214)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}5",
  ],
  [
    7768,
    "Saus Tar Tar (Tar Tar Sauce) (12060103)",
    "Salmonella (/25 g)",
  ],
  [
    7769,
    "Saus Tar Tar (Tar Tar Sauce) (12060103)",
    "Salmonella (/25 g)",
  ],
  [
    7770,
    "Saus Tar Tar (Tar Tar Sauce) (12060103)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7771,
    "Saus Tar Tar (Tar Tar Sauce) (12060103)",
    "Jumlah Sampel - Salmonella",
  ],
  [7772, "Saus Teriyaki (12060228)", "Salmonella (/25 g)"],
  [7773, "Saus Teriyaki (12060228)", "Jumlah Sampel - Salmonella"],
  [7774, "Saus Tiram (12060215)", "Salmonella (/25 g)"],
  [7775, "Saus Tiram (12060215)", "Salmonella (/25 g)"],
  [7776, "Saus Tiram (12060215)", "Jumlah Sampel - Salmonella"],
  [7777, "Saus Tiram (12060215)", "Jumlah Sampel - Salmonella"],
  [7778, "Saus Tiram Bening (12060402)", "Salmonella (/25 g)"],
  [
    7779,
    "Saus Tiram Bening (12060402)",
    "Jumlah Sampel - Salmonella",
  ],
  [7780, "Saus Tomat (12060217)", "Salmonella (/25 g)"],
  [7781, "Saus Tomat (12060217)", "Salmonella (/25 g)"],
  [7782, "Saus Tomat (12060217)", "Jumlah Sampel - Salmonella"],
  [7783, "Saus Tomat (12060217)", "Jumlah Sampel - Salmonella"],
  [
    7784,
    "Saus Toping/Saus Siram (12060229)",
    "Salmonella (/25 g)",
  ],
  [
    7785,
    "Saus Toping/Saus Siram (12060229)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7786,
    "Saus/Topping/Olesan (non buah) (050411)",
    "Salmonella (/25 g)",
  ],
  [
    7787,
    "Saus/Topping/Olesan (non buah) (050411)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    7788,
    "Saus/Topping/Olesan Cokelat (050404)",
    "Salmonella (/25 g)",
  ],
  [
    7789,
    "Saus/Topping/Olesan Cokelat (050404)",
    "Salmonella (/25 g)",
  ],
  [
    7790,
    "Saus/Topping/Olesan Cokelat (050404)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7791,
    "Saus/Topping/Olesan Cokelat (050404)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7792,
    "Saus/Topping/Olesan Manis (050408)",
    "Salmonella (/25 g)",
  ],
  [
    7793,
    "Saus/Topping/Olesan Manis (050408)",
    "Jumlah Sampel - Salmonella",
  ],
  [7794, "Sawi Asin (0402020702)", "Salmonella (/25 g)"],
  [7795, "Sawi Asin (0402020702)", "Jumlah Sampel - Salmonella"],
  [7796, "Sayur Asin (0402020302)", "Salmonella (/25 g)"],
  [7797, "Sayur Asin (0402020302)", "Jumlah Sampel - Salmonella"],
  [7798, "Sayur Beku (0402020101)", "Salmonella (/25 g)"],
  [7799, "Sayur Beku (0402020101)", "Jumlah Sampel - Salmonella"],
  [
    7800,
    "Sayur Beku (0402020101)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    7801,
    "Sayur Beku (0402020101)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    7802,
    "Sayur Beku (0402020101)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    7803,
    "Sayur Beku (0402020101)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    7804,
    "Sayur Beku (0402020101)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    7805,
    "Sayur Beku (Termasuk Jamur, Akar dan Umbi, Polong-polongan dan Aloe Vera) Rumput Laut, Kacang Serta Biji-Bijian Beku yang Diproses dengan Pemasakan dan atau Penambahan Bahan Pangan Lain (0402020114)",
    "Salmonella (/25 g)",
  ],
  [
    7806,
    "Sayur Beku (Termasuk Jamur, Akar dan Umbi, Polong-polongan dan Aloe Vera) Rumput Laut, Kacang Serta Biji-Bijian Beku yang Diproses dengan Pemasakan dan atau Penambahan Bahan Pangan Lain (0402020114)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7807,
    "Sayur Beku (Termasuk Jamur, Akar dan Umbi, Polong-polongan dan Aloe Vera) Rumput Laut, Kacang Serta Biji-Bijian Beku yang Diproses dengan Pemasakan dan atau Penambahan Bahan Pangan Lain (0402020114)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    7808,
    "Sayur Beku (Termasuk Jamur, Akar dan Umbi, Polong-polongan dan Aloe Vera) Rumput Laut, Kacang Serta Biji-Bijian Beku yang Diproses dengan Pemasakan dan atau Penambahan Bahan Pangan Lain (0402020114)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    7809,
    "Sayur Beku (Termasuk Jamur, Akar dan Umbi, Polong-polongan dan Aloe Vera) Rumput Laut, Kacang Serta Biji-Bijian Beku yang Diproses dengan Pemasakan dan atau Penambahan Bahan Pangan Lain (0402020114)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    7810,
    "Sayur Beku (Termasuk Jamur, Akar dan Umbi, Polong-polongan dan Aloe Vera) Rumput Laut, Kacang Serta Biji-Bijian Beku yang Diproses dengan Pemasakan dan atau Penambahan Bahan Pangan Lain (0402020114)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    7811,
    "Sayur Beku (Termasuk Jamur, Akar dan Umbi, Polong-polongan dan Aloe Vera) Rumput Laut, Kacang Serta Biji-Bijian Beku yang Diproses dengan Pemasakan dan atau Penambahan Bahan Pangan Lain (0402020114)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [7812, "Sayur Goreng Beku (0402020115)", "Salmonella (/25 g)"],
  [
    7813,
    "Sayur Goreng Beku (0402020115)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7814,
    "Sayur Goreng Beku (0402020115)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    7815,
    "Sayur Goreng Beku (0402020115)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    7816,
    "Sayur Goreng Beku (0402020115)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    7817,
    "Sayur Goreng Beku (0402020115)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    7818,
    "Sayur Goreng Beku (0402020115)",
    "Listeria monocytogenes (koloni/g)",
    "",
    "<100",
  ],
  [
    7819,
    "Sayur Olahan Yang Dibentuk (Meat Analog / Fish Analog / Seafood Analog) (0402020809)",
    "Salmonella (/25 g)",
  ],
  [
    7820,
    "Sayur Olahan Yang Dibentuk (Meat Analog / Fish Analog / Seafood Analog) (0402020809)",
    "Jumlah Sampel - Salmonella",
    "",
    "\x{2265}5",
  ],
  [
    7821,
    "Sayur Olahan Yang Dibentuk (Meat Analog / Fish Analog / Seafood Analog) (0402020809)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    7822,
    "Sayur Olahan Yang Dibentuk (Meat Analog / Fish Analog / Seafood Analog) (0402020809)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    7823,
    "Sayur Olahan Yang Dibentuk (Meat Analog / Fish Analog / Seafood Analog) (0402020809)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    7824,
    "Sayur Olahan Yang Dibentuk (Meat Analog / Fish Analog / Seafood Analog) (0402020809)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [
    7825,
    "Sayur Olahan Yang Dibentuk (Meat Analog / Fish Analog / Seafood Analog) (0402020809)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}200",
    "<100",
  ],
  [7826, "Scone (07020204)", "Salmonella (/25 g)"],
  [7827, "Scone (07020204)", "Jumlah Sampel - Salmonella"],
  [
    7828,
    "Scone (07020204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7829,
    "Scone (07020204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7830,
    "Scone (07020204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7831,
    "Scone (07020204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7832,
    "Scone (07020204)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [7833, "Sea Gel (09030102)", "Salmonella (/25 g)"],
  [7834, "Sea Gel (09030102)", "Jumlah Sampel - Salmonella"],
  [
    7835,
    "Sediaan Cair Yang Akan Dikonsumsi Dalam Keadaan Beku (0315)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7836,
    "Sediaan Cair Yang Akan Dikonsumsi Dalam Keadaan Beku (0315)",
    "Salmonella (/25 ml)",
  ],
  [
    7837,
    "Selai Kacang (0402020502)",
    "Jumlah Sampel - Salmonella",
  ],
  [7838, "Selai Kacang (0402020502)", "Salmonella (/25 g)"],
  [
    7839,
    "Selai Kacang Lainnya (0402020504)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7840,
    "Selai Kacang Lainnya (0402020504)",
    "Salmonella (/25 g)",
  ],
  [
    7841,
    "Selai Kacang Mede (Cashew Butter) (0402020503)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7842,
    "Selai Kacang Mede (Cashew Butter) (0402020503)",
    "Salmonella (/25 g)",
  ],
  [7843, "Selai Kaya (100401)", "Salmonella (/25 g)"],
  [
    7844,
    "Selai Labu (Pumpkin Butter) (0402020505)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7845,
    "Selai Labu (Pumpkin Butter) (0402020505)",
    "Salmonella (/25 g)",
  ],
  [7846, "Selai Sayur (0402020511)", "Salmonella (/25 g)"],
  [
    7847,
    "Selai Sayur (0402020511)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    7848,
    "Semar Mendem (060720)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7849,
    "Semar Mendem (060720)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7850,
    "Semar Mendem (060720)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7851,
    "Semar Mendem (060720)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7852,
    "Semar Mendem (060720)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [7853, "Semar Mendem (060720)", "Salmonella (/25 g)"],
  [7854, "Semar Mendem (060720)", "Jumlah Sampel - Salmonella"],
  [
    7855,
    "Semar Mendem (060720)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7856,
    "Semar Mendem (060720)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7857,
    "Semar Mendem (060720)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7858,
    "Semar Mendem (060720)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7859,
    "Semar Mendem (060720)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}1000",
    "\x{2264}10",
  ],
  [
    7860,
    "Semolina Gandum Durum dan Tepung Gandum Durum (06020108)",
    "Salmonella (/25 g)",
  ],
  [
    7861,
    "Semolina Gandum Durum dan Tepung Gandum Durum (06020108)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7862,
    "Semolina Gandum Durum dan Tepung Gandum Durum (06020108)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7863,
    "Semolina Gandum Durum dan Tepung Gandum Durum (06020108)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7864,
    "Semolina Gandum Durum dan Tepung Gandum Durum (06020108)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7865,
    "Semolina Gandum Durum dan Tepung Gandum Durum (06020108)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7866,
    "Semolina Gandum Durum dan Tepung Gandum Durum (06020108)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7867,
    "Semolina Gandum Durum Utuh dan Tepung Gandum Durum Utuh (06020109)",
    "Salmonella (/25 g)",
  ],
  [
    7868,
    "Semolina Gandum Durum Utuh dan Tepung Gandum Durum Utuh (06020109)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7869,
    "Semolina Gandum Durum Utuh dan Tepung Gandum Durum Utuh (06020109)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7870,
    "Semolina Gandum Durum Utuh dan Tepung Gandum Durum Utuh (06020109)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7871,
    "Semolina Gandum Durum Utuh dan Tepung Gandum Durum Utuh (06020109)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7872,
    "Semolina Gandum Durum Utuh dan Tepung Gandum Durum Utuh (06020109)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [
    7873,
    "Semolina Gandum Durum Utuh dan Tepung Gandum Durum Utuh (06020109)",
    "Bacillus cereus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}1000",
  ],
  [7874, "Serabi (07020119)", "Salmonella (/25 g)"],
  [7875, "Serabi (07020119)", "Jumlah Sampel - Salmonella"],
  [
    7876,
    "Serabi (07020119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7877,
    "Serabi (07020119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7878,
    "Serabi (07020119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7879,
    "Serabi (07020119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7880,
    "Serabi (07020119)",
    "Staphylococcus aureus (koloni/g)",
    "\x{2264}10000",
    "\x{2264}100",
  ],
  [
    7881,
    "Serbuk Lemak (Fat Powder) (02010242)",
    "Salmonella (/25 g)",
  ],
  [
    7882,
    "Serbuk Lemak (Fat Powder) (02010242)",
    "Jumlah Sampel - Salmonella",
  ],
  [
    7883,
    "Serbuk Lemak (Fat Powder) (02010242)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    7884,
    "Serbuk Lemak (Fat Powder) (02010242)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    7885,
    "Serbuk Lemak (Fat Powder) (02010242)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    7886,
    "Serbuk Lemak (Fat Powder) (02010242)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    7887,
    "Serbuk Lemak (Fat Powder) (02010242)",
    "Staphylococcus aureus (koloni/g)",
    "",
    "\x{2264}100",
  ],
  [
    7888,
    "Serbuk Lemak Hewani (Fat Powder) (02010312)",
    "Salmonella (/25 g)",
  ],
  [
    7889,
    "Serbuk Lemak Hewani (Fat Powder) (02010312)",
    "Jumlah Sampel - Salmonella",
    "\x{2265}",
  ],
  [
    7890,
    "Serbuk Lemak Hewani (Fat Powder) (02010312)",
    "Staphylococcus aureus (koloni/g)",
  ],
  [
    7891,
    "Serbuk Lemak Hewani (Fat Powder) (02010312)",
    "Staphylococcus aureus (koloni/g)",
  ],
  [
    7892,
    "Serbuk Lemak Hewani (Fat Powder) (02010312)",
    "Staphylococcus aureus (koloni/g)",
  ],
  [
    7893,
    "Serbuk Lemak Hewani (Fat Powder) (02010312)",
    "Staphylococcus aureus (koloni/g)",
  ],
  [
    7894,
    "Serbuk Lemak Hewani (Fat Powder) (02010312)",
    "Staphylococcus aureus (koloni/g)",
  ],
  [
    7895,
    "Serbuk Minuman Kedelai (06080103)",
    "Salmonella 