package Acme::PERLANCAR::Test::RequiresUnknownModules;

our $DATE = '2016-01-15'; # DATE
our $DIST = 'Acme-PERLANCAR-Test-RequiresUnknownModules'; # DIST
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

1;
# ABSTRACT: Distribution that has prerequisites to modules not on CPAN

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::PERLANCAR::Test::RequiresUnknownModules - Distribution that has prerequisites to modules not on CPAN

=head1 VERSION

This document describes version 0.01 of Acme::PERLANCAR::Test::RequiresUnknownModules (from Perl distribution Acme-PERLANCAR-Test-RequiresUnknownModules), released on 2016-01-15.

=head1 DESCRIPTION

This distribution is created to test tools like L<App::lcpan>. It contains
prerequisites to modules that are not on CPAN. It should not be installable by
most CPAN clients (due to unresolvable dependencies) and should produce failure
reports from CPAN Testers.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-PERLANCAR-Test-RequiresUnknownModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-PERLANCAR-Test-RequiresUnknownModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-PERLANCAR-Test-RequiresUnknownModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
