/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGPYTHON
#define SWIG_DIRECTORS

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif


#include "Python.h"

/*************************************************************** -*- c -*-
 * python/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Python_TypeRegister
#define SWIG_TypeCheck       SWIG_Python_TypeCheck
#define SWIG_TypeCast        SWIG_Python_TypeCast
#define SWIG_TypeDynamicCast SWIG_Python_TypeDynamicCast
#define SWIG_TypeName        SWIG_Python_TypeName
#define SWIG_TypePrettyName  SWIG_Python_TypePrettyName
#define SWIG_TypeQuery       SWIG_Python_TypeQuery
#define SWIG_TypeClientData  SWIG_Python_TypeClientData
#define SWIG_PackData        SWIG_Python_PackData 
#define SWIG_UnpackData      SWIG_Python_UnpackData 


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/***********************************************************************
 * pyrun.swg
 *
 *     This file contains the runtime support for Python modules
 *     and includes code for managing global variables and pointer
 *     type checking.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#define SWIG_PY_INT     1
#define SWIG_PY_FLOAT   2
#define SWIG_PY_STRING  3
#define SWIG_PY_POINTER 4
#define SWIG_PY_BINARY  5

/* Flags for pointer conversion */

#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

/* Exception handling in wrappers */
#define SWIG_fail   goto fail

/* Constant information structure */
typedef struct swig_const_info {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    swig_type_info **ptype;
} swig_const_info;

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Python_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Python_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Python_MustGetPtr(p, type, argnum, flags)
 
/* Python-specific SWIG API */
#define SWIG_newvarlink() \
  SWIG_Python_newvarlink()
#define SWIG_addvarlink(p, name, get_attr, set_attr) \
  SWIG_Python_addvarlink(p, name, get_attr, set_attr)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Python_ConvertPacked(obj, ptr, sz, ty, flags)
#define SWIG_NewPackedObj(ptr, sz, type) \
  SWIG_Python_NewPackedObj(ptr, sz, type)
#define SWIG_InstallConstants(d, constants) \
  SWIG_Python_InstallConstants(d, constants)

typedef double (*py_objasdbl_conv)(PyObject *obj);

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(int)               SWIG_Python_ConvertPtr(PyObject *, void **, swig_type_info *, int);
SWIGIMPORT(PyObject *)        SWIG_Python_NewPointerObj(void *, swig_type_info *,int own);
SWIGIMPORT(void *)            SWIG_Python_MustGetPtr(PyObject *, swig_type_info *, int, int);
SWIGIMPORT(PyObject *)        SWIG_Python_newvarlink(void);
SWIGIMPORT(void)              SWIG_Python_addvarlink(PyObject *, char *, PyObject *(*)(void), int (*)(PyObject *));
SWIGIMPORT(int)               SWIG_Python_ConvertPacked(PyObject *, void *, int sz, swig_type_info *, int);
SWIGIMPORT(PyObject *)        SWIG_Python_NewPackedObj(void *, int sz, swig_type_info *);
SWIGIMPORT(void)              SWIG_Python_InstallConstants(PyObject *d, swig_const_info constants[]);


#else


/* -----------------------------------------------------------------------------
 * global variable support code.
 * ----------------------------------------------------------------------------- */

typedef struct swig_globalvar {   
  char       *name;                  /* Name of global variable */
  PyObject *(*get_attr)(void);       /* Return the current value */
  int       (*set_attr)(PyObject *); /* Set the value */
  struct swig_globalvar *next;
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar *vars;
} swig_varlinkobject;

static PyObject *
swig_varlink_repr(swig_varlinkobject *v) {
  v = v;
  return PyString_FromString("<Global variables>");
}

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags) {
  swig_globalvar  *var;
  flags = flags;
  fprintf(fp,"Global variables { ");
  for (var = v->vars; var; var=var->next) {
    fprintf(fp,"%s", var->name);
    if (var->next) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->get_attr)();
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return NULL;
}

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->set_attr)(p);
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return 1;
}

statichere PyTypeObject varlinktype = {
  PyObject_HEAD_INIT(0)              
  0,                                  /* Number of items in variable part (ob_size) */
  (char *)"swigvarlink",              /* Type name (tp_name) */
  sizeof(swig_varlinkobject),         /* Basic size (tp_basicsize) */
  0,                                  /* Itemsize (tp_itemsize) */
  0,                                  /* Deallocator (tp_dealloc) */ 
  (printfunc) swig_varlink_print,     /* Print (tp_print) */
  (getattrfunc) swig_varlink_getattr, /* get attr (tp_getattr) */
  (setattrfunc) swig_varlink_setattr, /* Set attr (tp_setattr) */
  0,                                  /* tp_compare */
  (reprfunc) swig_varlink_repr,       /* tp_repr */
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_sequence */
  0,                                  /* tp_as_mapping */
  0,                                  /* tp_hash */
  0,                                  /* tp_call */
  0,                                  /* tp_str */
  0,                                  /* tp_getattro */
  0,                                  /* tp_setattro */
  0,                                  /* tp_as_buffer */
  0,                                  /* tp_flags */
  0,                                  /* tp_doc */
  0,                                  /* tp_traverse */
  0,                                  /* tp_clear */
  0,                                  /* tp_richcompare */
  0,                                  /* tp_weaklistoffset */
#if PY_VERSION_HEX >= 0x02020000
  0,                                  /* tp_iter */
  0,                                  /* tp_iternext */
  0,                                  /* tp_methods */
  0,                                  /* tp_members */
  0,                                  /* tp_getset */
  0,                                  /* tp_base */
  0,                                  /* tp_dict */
  0,                                  /* tp_descr_get */
  0,                                  /* tp_descr_set */
  0,                                  /* tp_dictoffset */
  0,                                  /* tp_init */
  0,                                  /* tp_alloc */
  0,                                  /* tp_new */
  0,                                  /* tp_free */
  0,                                  /* tp_is_gc */
  0,                                  /* tp_bases */
  0,                                  /* tp_mro */
  0,                                  /* tp_cache */
  0,                                  /* tp_subclasses */
  0,                                  /* tp_weaklist */
#endif
#if PY_VERSION_HEX >= 0x02030200
  0,                                  /* tp_del */
#endif
#ifdef COUNT_ALLOCS
  /* these must be last */
  0,                                  /* tp_alloc */
  0,                                  /* tp_free */
  0,                                  /* tp_maxalloc */
  0,                                  /*  tp_next */
#endif
};

/* Create a variable linking object for use later */
SWIGRUNTIME(PyObject *)
SWIG_Python_newvarlink(void) {
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  result->vars = 0;
  result->ob_refcnt = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGRUNTIME(void)
SWIG_Python_addvarlink(PyObject *p, char *name, PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p)) {
  swig_varlinkobject *v;
  swig_globalvar *gv;
  v= (swig_varlinkobject *) p;
  gv = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  gv->name = (char *) malloc(strlen(name)+1);
  strcpy(gv->name,name);
  gv->get_attr = get_attr;
  gv->set_attr = set_attr;
  gv->next = v->vars;
  v->vars = gv;
}

/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_Python_ConvertPtr(PyObject *obj, void **ptr, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c = 0;
  static PyObject *SWIG_this = 0;
  int    newref = 0;
  PyObject  *pyobj = 0;

  if (!obj) return 0;
  if (obj == Py_None) {
    *ptr = 0;
    return 0;
  }
#ifdef SWIG_COBJECT_TYPES
  if (!(PyCObject_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_FromString("this");
    pyobj = obj;
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyCObject_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  }  
  *ptr = PyCObject_AsVoidPtr(obj);
  c = (char *) PyCObject_GetDesc(obj);
  if (newref) Py_DECREF(obj);
  goto cobject;
#else
  if (!(PyString_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_FromString("this");
    pyobj = obj;
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyString_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  } 
  c = PyString_AS_STRING(obj);
  /* Pointer values must start with leading underscore */
  if (*c != '_') {
    *ptr = (void *) 0;
    if (strcmp(c,"NULL") == 0) {
      if (newref) { Py_DECREF(obj); }
      return 0;
    } else {
      if (newref) { Py_DECREF(obj); }
      goto type_error;
    }
  }
  c++;
  c = SWIG_UnpackData(c,ptr,sizeof(void *));
  if (newref) { Py_DECREF(obj); }
#endif

#ifdef SWIG_COBJECT_TYPES
cobject:
#endif

  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
    *ptr = SWIG_TypeCast(tc,(void*) *ptr);
  }

  if ((pyobj) && (flags & SWIG_POINTER_DISOWN)) {
    PyObject_SetAttrString(pyobj,(char*)"thisown",Py_False);
  }
  return 0;

type_error:
  PyErr_Clear();
  if (flags & SWIG_POINTER_EXCEPTION) {
    if (ty && c) {
      PyErr_Format(PyExc_TypeError, 
		   "Type error. Got %s, expected %s",
		   c, ty->name);
    } else {
      PyErr_SetString(PyExc_TypeError,"Expected a pointer");
    }
  }
  return -1;
}

/* Convert a pointer value, signal an exception on a type mismatch */
SWIGRUNTIME(void *)
SWIG_Python_MustGetPtr(PyObject *obj, swig_type_info *ty, int argnum, int flags) {
  void *result;
  SWIG_Python_ConvertPtr(obj, &result, ty, flags | SWIG_POINTER_EXCEPTION);
  return result;
}

/* Convert a packed value value */
SWIGRUNTIME(int)
SWIG_Python_ConvertPacked(PyObject *obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c = 0;

  if ((!obj) || (!PyString_Check(obj))) goto type_error;
  c = PyString_AS_STRING(obj);
  /* Pointer values must start with leading underscore */
  if (*c != '_') goto type_error;
  c++;
  c = SWIG_UnpackData(c,ptr,sz);
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
  }
  return 0;

type_error:

  if (flags) {
    if (ty && c) {
      PyErr_Format(PyExc_TypeError, 
		   "Type error. Got %s, expected %s",
		   c, ty->name);
    } else {
      PyErr_SetString(PyExc_TypeError,"Expected a pointer");
    }
  }
  return -1;
}

/* Create a new pointer object */
SWIGRUNTIME(PyObject *)
SWIG_Python_NewPointerObj(void *ptr, swig_type_info *type, int own) {
  PyObject *robj;
  if (!ptr) {
    Py_INCREF(Py_None);
    return Py_None;
  }
#ifdef SWIG_COBJECT_TYPES
  robj = PyCObject_FromVoidPtrAndDesc((void *) ptr, (char *) type->name, NULL);
#else
  {
    char result[1024];
    char *r = result;
    *(r++) = '_';
    r = SWIG_PackData(r,&ptr,sizeof(void *));
    strcpy(r,type->name);
    robj = PyString_FromString(result);
  }
#endif
  if (!robj || (robj == Py_None)) return robj;
  if (type->clientdata) {
    PyObject *inst;
    PyObject *args = Py_BuildValue((char*)"(O)", robj);
    Py_DECREF(robj);
    inst = PyObject_CallObject((PyObject *) type->clientdata, args);
    Py_DECREF(args);
    if (inst) {
      if (own) {
        PyObject_SetAttrString(inst,(char*)"thisown",Py_True);
      }
      robj = inst;
    }
  }
  return robj;
}

SWIGRUNTIME(PyObject *)
SWIG_Python_NewPackedObj(void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  strcpy(r,type->name);
  return PyString_FromString(result);
}

/* Install Constants */
SWIGRUNTIME(void)
SWIG_Python_InstallConstants(PyObject *d, swig_const_info constants[]) {
  int i;
  PyObject *obj;
  for (i = 0; constants[i].type; i++) {
    switch(constants[i].type) {
    case SWIG_PY_INT:
      obj = PyInt_FromLong(constants[i].lvalue);
      break;
    case SWIG_PY_FLOAT:
      obj = PyFloat_FromDouble(constants[i].dvalue);
      break;
    case SWIG_PY_STRING:
      if (constants[i].pvalue) {
	obj = PyString_FromString((char *) constants[i].pvalue);
      } else {
	Py_INCREF(Py_None);
	obj = Py_None;
      }
      break;
    case SWIG_PY_POINTER:
      obj = SWIG_NewPointerObj(constants[i].pvalue, *(constants[i]).ptype,0);
      break;
    case SWIG_PY_BINARY:
      obj = SWIG_NewPackedObj(constants[i].pvalue, constants[i].lvalue, *(constants[i].ptype));
      break;
    default:
      obj = 0;
      break;
    }
    if (obj) {
      PyDict_SetItemString(d,constants[i].name,obj);
      Py_DECREF(obj);
    }
  }
}

#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { PyErr_SetString(PyExc_RuntimeError, (char *) msg ); goto fail; } else

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_lucene__analysis__Token swig_types[0] 
#define  SWIGTYPE_p_lucene__search__PrefixQuery swig_types[1] 
#define  SWIGTYPE_p_lucene__index__IndexReader swig_types[2] 
#define  SWIGTYPE_p_lucene__search__Filter swig_types[3] 
#define  SWIGTYPE_p_lucene__queryParser__QueryParserBase swig_types[4] 
#define  SWIGTYPE_p_lucene__search__DateFilter swig_types[5] 
#define  SWIGTYPE_p_p_p_char swig_types[6] 
#define  SWIGTYPE_p_char swig_types[7] 
#define  SWIGTYPE_p_lucene__index__IndexWriter swig_types[8] 
#define  SWIGTYPE_p_lucene__search__ScoreDoc swig_types[9] 
#define  SWIGTYPE_p_lucene__store__LuceneLockWith swig_types[10] 
#define  SWIGTYPE_p_void swig_types[11] 
#define  SWIGTYPE_p_lucene__analysis__Analyzer swig_types[12] 
#define  SWIGTYPE_p_lucene__document__Document swig_types[13] 
#define  SWIGTYPE_p_lucene__analysis__standard__StandardAnalyzer swig_types[14] 
#define  SWIGTYPE_p_lucene__store__TransactionalRAMDirectory swig_types[15] 
#define  SWIGTYPE_p_lucene__store__FSDirectory swig_types[16] 
#define  SWIGTYPE_p_lucene__store__Directory swig_types[17] 
#define  SWIGTYPE_p_lucene__store__RAMDirectory swig_types[18] 
#define  SWIGTYPE_p_lucene__index__TermEnum swig_types[19] 
#define  SWIGTYPE_p_FilteredTermEnum swig_types[20] 
#define  SWIGTYPE_p_lucene__search__FuzzyTermEnum swig_types[21] 
#define  SWIGTYPE_p_lucene__search__TopDocs swig_types[22] 
#define  SWIGTYPE_p_lucene__store__FSLock swig_types[23] 
#define  SWIGTYPE_p_lucene__search__MultiTermQuery swig_types[24] 
#define  SWIGTYPE_p_lucene__store__LuceneLock swig_types[25] 
#define  SWIGTYPE_p_lucene__util__FileReader swig_types[26] 
#define  SWIGTYPE_p_lucene__util__StringReader swig_types[27] 
#define  SWIGTYPE_p_lucene__util__Reader swig_types[28] 
#define  SWIGTYPE_p_lucene__search__TermQuery swig_types[29] 
#define  SWIGTYPE_p_lucene__search__Searcher swig_types[30] 
#define  SWIGTYPE_p_lucene__search__MultiSearcher swig_types[31] 
#define  SWIGTYPE_p_lucene__search__IndexSearcher swig_types[32] 
#define  SWIGTYPE_p_lucene__queryParser__QueryParser swig_types[33] 
#define  SWIGTYPE_p_lucene__index__Term swig_types[34] 
#define  SWIGTYPE_p_lucene__search__BooleanClause swig_types[35] 
#define  SWIGTYPE_p_lucene__search__Query swig_types[36] 
#define  SWIGTYPE_p_lucene__search__WildcardQuery swig_types[37] 
#define  SWIGTYPE_p_lucene__search__Hits swig_types[38] 
#define  SWIGTYPE_p_lucene__search__BooleanQuery swig_types[39] 
#define  SWIGTYPE_p_lucene__store__FSOutputStream swig_types[40] 
#define  SWIGTYPE_p_lucene__store__FSInputStream swig_types[41] 
#define  SWIGTYPE_p_lucene__analysis__TokenStream swig_types[42] 
#define  SWIGTYPE_p_lucene__store__InputStream swig_types[43] 
#define  SWIGTYPE_p_lucene__store__OutputStream swig_types[44] 
#define  SWIGTYPE_p_unsigned_char swig_types[45] 
#define  SWIGTYPE_p_PyObject swig_types[46] 
#define  SWIGTYPE_p_BitSet swig_types[47] 
#define  SWIGTYPE_p_long_t swig_types[48] 
#define  SWIGTYPE_p_lucene__search__PhraseQuery swig_types[49] 
#define  SWIGTYPE_p_lucene__search__RangeQuery swig_types[50] 
#define  SWIGTYPE_p_lucene__index__TermPositions swig_types[51] 
#define  SWIGTYPE_p_lucene__search__HitCollector swig_types[52] 
#define  SWIGTYPE_p_lucene__search__FuzzyQuery swig_types[53] 
#define  SWIGTYPE_p_int swig_types[54] 
#define  SWIGTYPE_p_lucene__index__TermDocs swig_types[55] 
#define  SWIGTYPE_p_lucene__analysis__Tokenizer swig_types[56] 
#define  SWIGTYPE_p_lucene__analysis__standard__StandardTokenizer swig_types[57] 
static swig_type_info *swig_types[59];

/* -------- TYPES TABLE (END) -------- */


/*-----------------------------------------------
              @(target):= _cl_c.so
  ------------------------------------------------*/
#define SWIG_init    init_cl_c

#define SWIG_name    "_cl_c"

/* Auxiliar swig  macros that appear in the header */

#define SWIG_OLDOBJ  1
#define SWIG_NEWOBJ  SWIG_OLDOBJ + 1
#define SWIG_PYSTR   SWIG_NEWOBJ + 1

#ifdef __cplusplus
#define SWIGSTATICINLINE(a) static inline a
#define SWIGSTATIC(a) static a
#define swig_new_array(size,Type) (new Type[(size)])
#define swig_delete(cptr) delete cptr
#define swig_delete_array(cptr) delete[] cptr
#define swig_const_cast(a,Type) const_cast<Type >(a)
#define swig_static_cast(a,Type) static_cast<Type >(a)
#define swig_reinterpret_cast(a,Type) reinterpret_cast<Type >(a)
#define swig_new_copy(ptr,Type) (new Type(*ptr))
#define swig_numeric_cast(a,Type) static_cast<Type >(a)

#else /* C case */

#define SWIGSTATICINLINE(a) static a
#define SWIGSTATIC(a) static a
#define swig_new_array(size,Type) ((Type*) malloc((size)*sizeof(Type)))
#define swig_delete(cptr) free((char*)cptr)
#define swig_delete_array(cptr) free((char*)cptr)
#define swig_const_cast(a,Type) (Type)(a)
#define swig_static_cast(a,Type) (Type)(a)
#define swig_reinterpret_cast(a,Type) (Type)(a)
#define swig_numeric_cast(a,Type) (Type)(a)
#define swig_new_copy(ptr,Type)  ((Type*)memcpy(malloc(sizeof(Type)),ptr,sizeof(Type)))

#endif /* __cplusplus */


/*@D:\\dev\\c\\SWIG-1.3.22\\Lib\\python\\pymacros.swg,63,SWIG_define@*/
#define SWIG_From_signed_SS_char PyInt_FromLong
/*@@*/
/*@D:\\dev\\c\\SWIG-1.3.22\\Lib\\python\\pymacros.swg,63,SWIG_define@*/
#define SWIG_From_unsigned_SS_char PyInt_FromLong
/*@@*/
/*@D:\\dev\\c\\SWIG-1.3.22\\Lib\\python\\pymacros.swg,63,SWIG_define@*/
#define SWIG_From_short PyInt_FromLong
/*@@*/
/*@D:\\dev\\c\\SWIG-1.3.22\\Lib\\python\\pymacros.swg,63,SWIG_define@*/
#define SWIG_From_unsigned_SS_short PyInt_FromLong
/*@@*/
/*@D:\\dev\\c\\SWIG-1.3.22\\Lib\\python\\pymacros.swg,63,SWIG_define@*/
#define SWIG_From_int PyInt_FromLong
/*@@*/
/*@D:\\dev\\c\\SWIG-1.3.22\\Lib\\python\\pymacros.swg,63,SWIG_define@*/
#define SWIG_From_long PyInt_FromLong
/*@@*/
/*@D:\\dev\\c\\SWIG-1.3.22\\Lib\\python\\pymacros.swg,63,SWIG_define@*/
#define SWIG_From_float PyFloat_FromDouble
/*@@*/
/*@D:\\dev\\c\\SWIG-1.3.22\\Lib\\python\\pymacros.swg,63,SWIG_define@*/
#define SWIG_From_double PyFloat_FromDouble
/*@@*/

 #define _SUMO 

SWIGSTATICINLINE(PyObject*)
  SWIG_From_bool(bool value)
{
  PyObject *obj = value ? Py_True : Py_False;
  Py_INCREF(obj);
  return obj;
}

 const bool UNICODE_BUILD = false; 
 const bool SUMO_BUILD = true; 
 class PythonExceptionAlreadySet {}; 

  
#if defined(__SUNPRO_CC) 
#define SWIG_STD_NOASSIGN_STL
#endif



#include <string>
#include <stdexcept>


#if PY_VERSION_HEX < 0x02000000
#define PySequence_Size PySequence_Length
#endif
#include <stdexcept>


#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


static void SWIG_exception_(int code, const char *msg) {
  switch(code) {
  case SWIG_MemoryError:
    PyErr_SetString(PyExc_MemoryError,msg);
    break;
  case SWIG_IOError:
    PyErr_SetString(PyExc_IOError,msg);
    break;
  case SWIG_RuntimeError:
    PyErr_SetString(PyExc_RuntimeError,msg);
    break;
  case SWIG_IndexError:
    PyErr_SetString(PyExc_IndexError,msg);
    break;
  case SWIG_TypeError:
    PyErr_SetString(PyExc_TypeError,msg);
    break;
  case SWIG_DivisionByZero:
    PyErr_SetString(PyExc_ZeroDivisionError,msg);
    break;
  case SWIG_OverflowError:
    PyErr_SetString(PyExc_OverflowError,msg);
    break;
  case SWIG_SyntaxError:
    PyErr_SetString(PyExc_SyntaxError,msg);
    break;
  case SWIG_ValueError:
    PyErr_SetString(PyExc_ValueError,msg);
    break;
  case SWIG_SystemError:
    PyErr_SetString(PyExc_SystemError,msg);
    break;
  default:
    PyErr_SetString(PyExc_RuntimeError,msg);
    break;
  }
}

#define SWIG_exception(a,b) { SWIG_exception_(a,b); SWIG_fail; }


#include <stdexcept>


#include <algorithm>


#include <vector>


#include <string>

 #include "pyclene.h" 

  /* Compile entire extension and supporting code as one compilation unit? */
  #ifdef MONOLITHIC_COMPILATION
    #include "nodist__clucene_source_files__include_all.h"
  #else
    #include "CLucene.h"
    #include "CLucene/StdHeader.h"
    #include "CLucene/LuceneThreads.h"

    #include "CLucene/analysis/AnalysisHeader.h"
      #include "CLucene/util/FastCharStream.h"
    #include "CLucene/analysis/standard/StandardAnalyzer.h"

    #include "CLucene/document/Document.h"
    #include "CLucene/document/DateField.h"

    #include "CLucene/index/IndexWriter.h"
    #include "CLucene/index/Term.h"
    #include "CLucene/index/Terms.h"

    #include "CLucene/queryParser/QueryParser.h"

    #include "CLucene/search/BooleanClause.h"
    #include "CLucene/search/DateFilter.h"
    #include "CLucene/search/FuzzyQuery.h"
    #include "CLucene/search/IndexSearcher.h"
    #include "CLucene/search/MultiSearcher.h"
    #include "CLucene/search/MultiTermQuery.h"
    #include "CLucene/search/PrefixQuery.h"
    #include "CLucene/search/PhraseQuery.h"
    #include "CLucene/search/RangeQuery.h"
    #include "CLucene/search/SearchHeader.h"
    #include "CLucene/search/ScoreDoc.h"
    #include "CLucene/search/TermQuery.h"
    #include "CLucene/search/WildcardQuery.h"

    #include "CLucene/store/FSDirectory.h"
    #include "CLucene/store/RAMDirectory.h"

    #include "CLucene/util/BitSet.h"
    #include "CLucene/util/Reader.h"
  #endif /* def MONOLITHIC_COMPILATION? */


    static inline int SWIG_AsCharPtr(PyObject *obj, char **val);
    static inline PyObject *SWIG_FromCharPtr(const char* cptr);
  

    #define CONVERT_STRING_IN(pyIn, cTarget) SWIG_AsCharPtr(pyIn, &cTarget)
    #define CONVERT_STRING_OUT(cIn, pyOut) (pyOut) = SWIG_FromCharPtr(cIn)
  

#include "supp_document.cpp"
#include "supp_index.cpp"
#include "supp_search.cpp"
#include "supp_util.cpp"


/* returns SWIG_OLDOBJ if the input is a raw char*, SWIG_PYSTR if is a PyString */
SWIGSTATIC(int)
SWIG_AsCharPtrAndSize(PyObject *obj, char** cptr, size_t* psize)
{
  static swig_type_info* pchar_info = 0;
  char* vptr = 0;
  if (!pchar_info) pchar_info = SWIG_TypeQuery("char *");
  if (SWIG_ConvertPtr(obj, (void**)&vptr, pchar_info, 0) != -1) {
    if (cptr) *cptr = vptr;
    if (psize) *psize = vptr ? (strlen(vptr) + 1) : 0;
    return SWIG_OLDOBJ;
  } else {
    if (PyString_Check(obj)) {
      if (cptr) {
	*cptr = PyString_AS_STRING(obj);
	if (psize) {
	  *psize = PyString_GET_SIZE(obj) + 1;
	}
      }
      return SWIG_PYSTR;
    }
  }
  if (cptr) {
    PyErr_SetString(PyExc_TypeError, "a string is expected");
  }
  return 0;
}


SWIGSTATICINLINE(int)
SWIG_AsCharPtr(PyObject *obj, char **val)
{
  char* cptr = 0;
  if (SWIG_AsCharPtrAndSize(obj, &cptr, (size_t*)(0))) {
    if (val) *val = cptr;
    return 1;
  }
  if (val) {
    PyErr_SetString(PyExc_TypeError, "a char* is expected");
  }
  return 0;
}


#include <limits.h>


SWIGSTATICINLINE(int)
  SWIG_CheckLongInRange(long value, long min_value, long max_value,
			const char *errmsg)
{
  if (value < min_value) {
    if (errmsg) {
      PyErr_Format(PyExc_OverflowError, 
		   "value %ld is less than '%s' minimum %ld", 
		   value, errmsg, min_value);
    }
    return 0;    
  } else if (value > max_value) {
    if (errmsg) {
      PyErr_Format(PyExc_OverflowError,
		   "value %ld is greater than '%s' maximum %ld", 
		   value, errmsg, max_value);
    }
    return 0;
  }
  return 1;
}


SWIGSTATICINLINE(int)
  SWIG_AsVal_long(PyObject * obj, long* val)
{
  if (PyInt_Check(obj)) {
    if (val) *val = PyInt_AS_LONG(obj);
    return 1;
  }
  if (PyLong_Check(obj)) {
    long v = PyLong_AsLong(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return 1;
    } else {
      if (!val) PyErr_Clear();
      return 0;
    }
  }
  if (val) {
    PyErr_SetString(PyExc_TypeError, "a long is expected");
  }
  return 0;
 }


#if INT_MAX != LONG_MAX
SWIGSTATICINLINE(int)
  SWIG_AsVal_int(PyObject *obj, int *val)
{ 
  const char* errmsg = val ? "int" : 0;
  long v;
  if (SWIG_AsVal_long(obj, &v)) {
    if (SWIG_CheckLongInRange(v, INT_MIN,INT_MAX, errmsg)) {
      if (val) *val = swig_numeric_cast(v, int);
      return 1;
    } else {
      return 0;
    }
  } else {
    PyErr_Clear();
  }
  if (val) {
    PyErr_SetString(PyExc_TypeError, "an int is expected");
  }
  return 0;    
}
#else
SWIGSTATICINLINE(int)
  SWIG_AsVal_int(PyObject *obj, int *val)
{
  return SWIG_AsVal_long(obj,(long*)val);
}
#endif


SWIGSTATICINLINE(int)
SWIG_As_int(PyObject* obj)
{
  int v;
  if (!SWIG_AsVal_int(obj, &v)) {
    /*
      this is needed to make valgrind/purify happier.  the other
      solution is throw an exception, but since this code should work
      with plain C ....
     */
    memset((void*)&v, 0, sizeof(int));
  }
  return v;
}

  
SWIGSTATICINLINE(int)
SWIG_Check_int(PyObject* obj)
{
  return SWIG_AsVal_int(obj, (int*)0);
}

 static 
PyObject *lucene_util_FileReader___eq__(lucene::util::FileReader *self,lucene::util::Reader *other){
    /* YYY: (This equality method chokes on any $other than a Reader.) */
    /* Need to compare the underlying C++ obj pointers, rather than the Python
    ** proxy objects. */
    return PyBool_FromLong(self == other);
  }

   static inline long_t lucene_store_InputStream_filePointer_get(lucene::store::InputStream *o) {
     return (o->getFilePointer());
   }
  

   static inline void lucene_store_InputStream_filePointer_set(lucene::store::InputStream *o, long_t value) {
     PyErr_SetString(PyExc_AttributeError, "property is read-only");
     throw PythonExceptionAlreadySet();
   }
  
 static 
char *lucene_store_InputStream_readString(lucene::store::InputStream *self){
      /* Order readString not to duplicate the string before returning it.
      ** (That duplication will be performed by the C->Python string output
      ** mechanism.) */
      return self->readString(false);
    }

SWIGSTATICINLINE(PyObject *)
SWIG_FromCharPtr(const char* cptr)
{ 
  if (cptr) {
    size_t size = strlen(cptr);
    if (size > INT_MAX) {
      return SWIG_NewPointerObj(swig_const_cast(cptr,char*), 
				SWIG_TypeQuery("char *"), 0);
    } else {
      if (size != 0) {
	return PyString_FromStringAndSize(cptr, size);
      } else {
	return PyString_FromString(cptr);
      }
    }
  }
  Py_INCREF(Py_None);
  return Py_None;
}

 static 
PyObject *lucene_store_InputStream_readByte(lucene::store::InputStream *self){
      /* Return the byte as a single-character Python string rather than an int. */
      char s[1];
      s[0] = (char) self->readByte();
      return PyString_FromStringAndSize(s, 1);
    }
 static 
PyObject *lucene_store_InputStream_readBytes(lucene::store::InputStream *self,int const nBytes){
      if (nBytes > self->Length() - self->getFilePointer()) {
        PyErr_SetString(PyExc_IOError, "Can't read past the end of the stream.");
        return NULL;
      }

      PyObject *retBuf = PyString_FromStringAndSize(NULL, nBytes);
      unsigned char *internalBuf = NULL;
      if ((retBuf) == NULL) { goto fail; };
      internalBuf = (unsigned char *) PyString_AS_STRING(retBuf);
      try {
        self->readBytes(internalBuf, 0, nBytes);
      } catch (THROW_TYPE &e) { /* THROW_TYPE is defined in CL's StdHeader.h. */
        PyErr_SetString(PyExc_IOError, e.what());
        goto fail;
      }

      return retBuf;
      fail:
        if (!PyErr_Occurred()) {
          PyErr_NoMemory();
        }
        Py_DECREF(retBuf);
        return NULL;
    }
 static 
PyObject *lucene_store_InputStream_readChars(lucene::store::InputStream *self,int const nChars){
        return lucene_store_InputStream_readBytes(self, nChars);
      }
 static 
PyObject *lucene_store_InputStream_read(lucene::store::InputStream *self,int const nBytes){
      const long_t bytesLeft = self->Length() - self->getFilePointer();
      const int bytesToActuallyRead =
        nBytes == -1 ?
            (int)bytesLeft
          : (nBytes > bytesLeft ? (int)bytesLeft : nBytes)
        ;
      return lucene_store_InputStream_readBytes(self, bytesToActuallyRead);
    }

   static inline long_t lucene_store_OutputStream_filePointer_get(lucene::store::OutputStream *o) {
     return (o->getFilePointer());
   }
  

   static inline void lucene_store_OutputStream_filePointer_set(lucene::store::OutputStream *o, long_t value) {
     PyErr_SetString(PyExc_AttributeError, "property is read-only");
     throw PythonExceptionAlreadySet();
   }
  
 static 
PyObject *lucene_store_OutputStream_writeByte(lucene::store::OutputStream *self,PyObject *b){
      if (!PyString_Check(b) || PyString_GET_SIZE(b) != 1) {
        PyErr_SetString(PyExc_TypeError,
            "The byte must be passed as a single-character string."
          );
        return NULL;
      }
      self->writeByte( (unsigned char) PyString_AS_STRING(b)[0] );
         Py_INCREF(Py_None);    return Py_None;;
    }
 static 
PyObject *lucene_store_OutputStream_writeChars(lucene::store::OutputStream *self,char const *s,int const length){
      try {
        self->writeChars(s, 0, length);
      } catch (THROW_TYPE &e) { /* THROW_TYPE is defined in CL's StdHeader.h. */
        PyErr_SetString(PyExc_IOError, e.what());
        goto fail;
      }

         Py_INCREF(Py_None);    return Py_None;;
      fail:
        return NULL;
    }
 static 
PyObject *lucene_store_OutputStream_write(lucene::store::OutputStream *self,unsigned char const *b,int const length){
      self->writeBytes(b, length);
         Py_INCREF(Py_None);    return Py_None;;
    }

   static inline const char * lucene_store_FSDirectory_name_get(lucene::store::FSDirectory *o) {
     return (o->getDirName());
   }
  

   static inline void lucene_store_FSDirectory_name_set(lucene::store::FSDirectory *o, const char * value) {
     PyErr_SetString(PyExc_AttributeError, "property is read-only");
     throw PythonExceptionAlreadySet();
   }
  
 static 
lucene::store::FSInputStream &lucene_store_FSInputStream_clone(lucene::store::FSInputStream *self){
      return *new FSInputStream(*self);
    }
 static 
PyObject *lucene_store_RAMDirectory_list(lucene::store::RAMDirectory *self){
    char **dirList = NULL;
    char **&dirListRef = dirList;
    int size = -1;
    int &sizeRef = size;

    try {
      self->list(dirListRef, sizeRef);
    } catch (THROW_TYPE &e) { /* THROW_TYPE is defined in CL's StdHeader.h. */
      PyErr_SetString(PyExc_Exception, e.what());
      return NULL;
    }
    if (size < 0) {
      PyErr_SetString(PyExc_IOError, "Directory size less than zero.");
      return NULL;
    }

    PyObject *ret = PyList_New(size);
    if (ret == NULL) {
      goto fail;
    }
    for (int i = 0; i < size; i++) {
      PyObject *item = NULL;
      CONVERT_STRING_OUT(dirList[i], item);
      if (item == NULL) {
        goto fail;
      }
      PyList_SET_ITEM(ret, i, item); /* PyList_SET_ITEM steals ref to item. */
    }

    delete[] dirList;
    return ret;
    fail:
      if (!PyErr_Occurred()) {
        PyErr_NoMemory();
      }
      delete[] dirList;
      Py_XDECREF(ret);
      return NULL;
  }
PyObject *lucene_store_TransactionalRAMDirectory_dummy_createFile(lucene::store::TransactionalRAMDirectory *self,char const *name,PyObject *pyContents){
    if (!PyString_Check(pyContents)) {
      PyErr_SetString(PyExc_TypeError, "dummy_createFile requires as second arg");
      throw PythonExceptionAlreadySet();
    }
    const unsigned char* contents;
    int length;
    PyString_AsStringAndSize( pyContents, (char **) &contents, &length);

    OutputStream* os = &self->createFile(name);
    try {
      os->writeBytes(contents, length);
    } catch(...){ os->close();
      delete os;; throw; } os->close();
      delete os;;
       Py_INCREF(Py_None);    return Py_None;;
  }
PyObject *lucene_store_TransactionalRAMDirectory_dummy_deleteFile(lucene::store::TransactionalRAMDirectory *self,char const *name){
    self->deleteFile(name);
       Py_INCREF(Py_None);    return Py_None;;
  }
PyObject *lucene_store_TransactionalRAMDirectory_dummy_renameFile(lucene::store::TransactionalRAMDirectory *self,char const *from,char const *to){
    self->renameFile(from, to);
       Py_INCREF(Py_None);    return Py_None;;
  }
PyObject *lucene_store_TransactionalRAMDirectory_dummy_readFile(lucene::store::TransactionalRAMDirectory *self,char const *name){
    PyObject *pyContents = NULL;

    InputStream* is = &self->openFile(name);
    try {
      long_t fileSize = self->fileLength(name);
      pyContents = PyString_FromStringAndSize(NULL, fileSize);
      if (pyContents == NULL) {
        PyErr_NoMemory();
        throw PythonExceptionAlreadySet();
      }
      is->readBytes((unsigned char *) PyString_AS_STRING(pyContents), 0, fileSize);
    } catch(...){ is->close();
      delete is;

      if (PyErr_Occurred()) {
        Py_XDECREF(pyContents);
        pyContents = NULL;
      }; throw; } is->close();
      delete is;

      if (PyErr_Occurred()) {
        Py_XDECREF(pyContents);
        pyContents = NULL;
      };

    return pyContents;
  }

static PyObject *DateField_timeToString(long_t ticks) {
  char_t *cString = lucene::document::DateField::timeToString(ticks);
  PyObject *pyString;
    CONVERT_STRING_OUT(cString, pyString);
  delete[] cString;
  return pyString;
}

static long_t DateField_stringToTime(const char_t* s) {
  return lucene::document::DateField::stringToTime(s);
}


  static PyObject *TermEnum__iter__(PyObject *self) {
    PyObject *iterTarg = PyObject_GetAttrString(self, "itercall");
    if (iterTarg == NULL) return NULL;
    PyObject *iter = PyCallIter_New(iterTarg, Py_None);
    Py_DECREF(iterTarg);
    return iter;
  }

 static 
PyObject *lucene_index_TermEnum_term(lucene::index::TermEnum *self){
    /* supp_convertTermToPythonTuple is defined in supp_index.cpp */
    return supp_convertTermToPythonTuple(self->getTerm(false));
  }
 static 
PyObject *lucene_index_TermEnum_itercall(lucene::index::TermEnum *self){
    if (!self->next()) {
         Py_INCREF(Py_None);    return Py_None;;
    }
    lucene::index::Term *term = self->getTerm(false);
    PyObject *entry = NULL; /* entry consists of (termTuple, frequency) */
    PyObject *termTuple = NULL; /* termTuple consists of (fieldName, text) */
    bool entryAlreadyContainsTermTuple = false;

    
















        /* supp_convertTermToPythonTuple is defined in supp_index.cpp */
        termTuple = supp_convertTermToPythonTuple(term);
        if ((termTuple) == NULL) { goto fail; };
    



    entry = PyTuple_New(2);
    if ((entry) == NULL) { goto fail; };

    PyTuple_SET_ITEM(entry, 0, termTuple);
    entryAlreadyContainsTermTuple = true;
    PyTuple_SET_ITEM(entry, 1, PyInt_FromLong(self->DocFreq()));

    






    return entry;
    fail:
      if (!PyErr_Occurred()) PyErr_NoMemory();
      if (!entryAlreadyContainsTermTuple) Py_XDECREF(termTuple);
      Py_XDECREF(entry);
      return NULL;
  }
 static 
PyObject *lucene_index_IndexWriter_addIndexes(lucene::index::IndexWriter *self,PyObject *pyDirs){
    if (!PySequence_Check(pyDirs)) {
      PyErr_SetString(PyExc_TypeError, "$dirs must be a sequence.");
      return NULL;
    }
    lucene::store::Directory **cDirs = NULL;
    int nDirs = PySequence_Size(pyDirs);
    if (nDirs == -1) { /* PySequence_Size call failed. */
      goto fail;
    } else if (nDirs == 0) {
      PyErr_SetString(PyExc_ValueError, "$dirs must not be empty.");
      goto fail;
    }
    cDirs = new lucene::store::Directory *[nDirs];

    for (int i = 0; i < nDirs; i++) {
      PyObject *curPyDir = PySequence_GetItem(pyDirs, i);
      if (curPyDir == NULL) goto fail;
      /* Invoke SWIG-defined conversion mechanism: */
      const int convAttempt = SWIG_ConvertPtr(curPyDir, (void **) &cDirs[i],
          SWIGTYPE_p_lucene__store__Directory, SWIG_POINTER_EXCEPTION | 0
        );
      Py_DECREF(curPyDir);
      if (convAttempt == -1) {
        goto fail;
      } else if (cDirs[i] == NULL) {
        PyErr_SetString(PyExc_TypeError, "Expected Directory object; got None.");
        goto fail;
      }
    }

    try {
      self->addIndexes(cDirs, nDirs);
    } catch (THROW_TYPE &e) { /* THROW_TYPE is defined in CL's StdHeader.h. */
      PyErr_SetString(PyExc_Exception, e.what());
      goto fail;
    }

    delete[] cDirs;
       Py_INCREF(Py_None);    return Py_None;;
    fail:
      if (!PyErr_Occurred()) PyErr_NoMemory();
      if (cDirs != NULL) delete[] cDirs;
      return NULL;
  }

#include <float.h>
SWIGSTATICINLINE(int)
  SWIG_CheckDoubleInRange(double value, double min_value, 
			  double max_value, const char* errmsg)
{
  if (value < min_value) {
    if (errmsg) {
      PyErr_Format(PyExc_OverflowError, 
		   "value %g is less than %s minimum %g", 
		   value, errmsg, min_value);
    }
    return 0;
  } else if (value > max_value) {
    if (errmsg) {
      PyErr_Format(PyExc_OverflowError, 
		   "value %g is greater than %s maximum %g", 
		   value, errmsg, max_value);
    }
    return 0;
  }
  return 1;
}


SWIGSTATICINLINE(int)
  SWIG_AsVal_double(PyObject *obj, double *val)
{
  if (PyFloat_Check(obj)) {
    if (val) *val = PyFloat_AS_DOUBLE(obj);
    return 1;
  }  
  if (PyInt_Check(obj)) {
    if (val) *val = PyInt_AS_LONG(obj);
    return 1;
  }
  if (PyLong_Check(obj)) {
    double v = PyLong_AsDouble(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return 1;
    } else {
      if (!val) PyErr_Clear();
      return 0;
    }
  }
  if (val) {
    PyErr_SetString(PyExc_TypeError, "a double is expected");
  }
  return 0;
}


SWIGSTATICINLINE(int)
  SWIG_AsVal_float(PyObject *obj, float *val)
{
  const char* errmsg = val ? "float" : 0;
  double v;
  if (SWIG_AsVal_double(obj, &v)) {
    if (SWIG_CheckDoubleInRange(v, -FLT_MAX, FLT_MAX, errmsg)) {
      if (val) *val = v;
      return 1;
    } else {
      return 0;
    }
  } else {
    PyErr_Clear();
  }
  if (val) {
    PyErr_SetString(PyExc_TypeError, "a float is expected");
  }
  return 0;
}


SWIGSTATICINLINE(float)
SWIG_As_float(PyObject* obj)
{
  float v;
  if (!SWIG_AsVal_float(obj, &v)) {
    /*
      this is needed to make valgrind/purify happier.  the other
      solution is throw an exception, but since this code should work
      with plain C ....
     */
    memset((void*)&v, 0, sizeof(float));
  }
  return v;
}

  
SWIGSTATICINLINE(int)
SWIG_Check_float(PyObject* obj)
{
  return SWIG_AsVal_float(obj, (float*)0);
}


  #define GENERIC_TRY try
  #define GENERIC_CATCH \
    catch (THROW_TYPE &e) { \
      PyErr_SetString(PyExc_Exception, e.what()); \
      return NULL; \
    }


   static inline const char * lucene_search_Query_name_get(lucene::search::Query *o) {
     return (o->getQueryName());
   }
  

   static inline void lucene_search_Query_name_set(lucene::search::Query *o, const char * value) {
     PyErr_SetString(PyExc_AttributeError, "property is read-only");
     throw PythonExceptionAlreadySet();
   }
  
 static 
PyObject *lucene_search_Searcher_search(lucene::search::Searcher *self,lucene::search::Query &query,PyObject *pyFilter,PyObject *pyLimitNDocs,PyObject *pyCollector){
    const bool noFilter = (pyFilter == Py_None);
    const bool noLimit = (pyLimitNDocs == Py_None);
    const bool noCollector = (pyCollector == Py_None);

    lucene::search::Filter *filter = NULL;
    int limitNDocs = -1;
    lucene::search::HitCollector *collector = NULL;

    /* Convert pyFilter, if any, via SWIG pointer conversion mechanism. */
    if (!noFilter) {
      if (-1 == (SWIG_ConvertPtr(
            pyFilter, (void **) &filter,
            SWIGTYPE_p_lucene__search__Filter, SWIG_POINTER_EXCEPTION | 0)
         ))
      {
        return NULL; /* SWIG will have already set a TypeError. */
      }
    }
    /* Convert pyLimitNDocs, if any. */
    if (noLimit) {
      limitNDocs = 50; /* Matches CLucene default. */
    } else {
      limitNDocs = (int) PyInt_AsLong(pyLimitNDocs);
      if (PyErr_Occurred()) {
        return NULL; /* PyInt_AsLong will have already set an exception. */
      }
    }
    /* Convert pyCollector, if any, via SWIG pointer conversion mechanism. */
    if (!noCollector) {
      if (-1 == (SWIG_ConvertPtr(
            pyCollector, (void **) &collector,
            SWIGTYPE_p_lucene__search__HitCollector, SWIG_POINTER_EXCEPTION | 0)
         ))
      {
        return NULL; /* SWIG will have already set a TypeError. */
      }
    }

    if (noLimit) {
      if (noFilter && noCollector) {
        lucene::search::Hits *result;
        GENERIC_TRY {
          lucene::search::Hits &_result_ref = self->search(query, filter);
          result = (lucene::search::Hits *) &_result_ref;
        } GENERIC_CATCH
        PyObject *pyResult = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__Hits, 1);
        return pyResult;
      } else if (noFilter) {
        GENERIC_TRY {
          self->search(query, *collector);
        } GENERIC_CATCH
           Py_INCREF(Py_None);    return Py_None;; /* Underlying method has void return type. */
      }
    }

    /* This is not an 'else if' clause because control needs to be able to fall
    ** through from above. */
    if (noCollector) {
      /* In the absence of these range checks, CLucene crashes. */
      if (limitNDocs <= 0) {
        PyErr_SetString(PyExc_ValueError, "limitNDocs must be greater than zero.");
        return NULL;
      } else if (limitNDocs > 1000) {
        PyErr_SetString(PyExc_RuntimeError, /* Really more of a CLBugGuard. */
            "This version of CLucene does not operate reliably with large limitNDocs values."
          );
        return NULL;
      }
      lucene::search::TopDocs *result;
      GENERIC_TRY {
        lucene::search::TopDocs &_result_ref = self->Search(query, filter, limitNDocs);
        result = (lucene::search::TopDocs *) &_result_ref;
      } GENERIC_CATCH
      PyObject *pyResult = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__TopDocs, 1);
      return pyResult;
    } else {
      GENERIC_TRY {
        self->Search(query, filter, *collector);
      } GENERIC_CATCH
         Py_INCREF(Py_None);    return Py_None;; /* Underlying method has void return type. */
    }
  }

  static lucene::search::MultiSearcher *new_MultiSearcher(PyObject *pySearchers) {
    if (!PySequence_Check(pySearchers)) {
      PyErr_SetString(PyExc_TypeError, "$searchers must be a sequence.");
      return NULL;
    }
    lucene::search::Searcher **cSearchers = NULL;
    int nSearchers = PySequence_Size(pySearchers);
    if (nSearchers == -1) { /* PySequence_Size call failed. */
      goto fail;
    } else if (nSearchers == 0) {
      PyErr_SetString(PyExc_ValueError, "$searchers must not be empty.");
      goto fail;
    }
    cSearchers = new lucene::search::Searcher *[nSearchers];

    for (int i = 0; i < nSearchers; i++) {
      PyObject *curPySearcher = PySequence_GetItem(pySearchers, i);
      if (curPySearcher == NULL) goto fail;
      /* Invoke SWIG-defined conversion mechanism: */
      const int convAttempt = SWIG_ConvertPtr(curPySearcher, (void **) &cSearchers[i],
          SWIGTYPE_p_lucene__search__Searcher, SWIG_POINTER_EXCEPTION | 0
        );
      Py_DECREF(curPySearcher);
      if (convAttempt == -1) goto fail;
      if (cSearchers[i] == NULL) {
        PyErr_SetString(PyExc_TypeError, "Expected Searcher object; got None.");
        goto fail;
      }
    }

    {
      lucene::search::MultiSearcher *ms;
      try {
        ms = new lucene::search::MultiSearcher(cSearchers, nSearchers);
      } catch (THROW_TYPE &e) { /* THROW_TYPE is defined in CL's StdHeader.h. */
        PyErr_SetString(PyExc_Exception, e.what());
        goto fail;
      }
      return ms;
    }
    fail:
      if (!PyErr_Occurred()) PyErr_NoMemory();
      if (cSearchers != NULL) delete[] cSearchers;
      throw PythonExceptionAlreadySet();
  }


   static inline lucene::index::Term * lucene_search_TermQuery_term_get(lucene::search::TermQuery *o) {
     return (o->getTerm());
   }
  

   static inline void lucene_search_TermQuery_term_set(lucene::search::TermQuery *o, lucene::index::Term * value) {
     PyErr_SetString(PyExc_AttributeError, "property is read-only");
     throw PythonExceptionAlreadySet();
   }
  

   static inline void lucene_search_PhraseQuery_terms_set(lucene::search::PhraseQuery *o, PyObject * value) {
     PyErr_SetString(PyExc_AttributeError, "property is read-only");
     throw PythonExceptionAlreadySet();
   }
  

  static int_t lucene_search_PhraseQuery_slop_get(lucene::search::PhraseQuery *self) {
    return self->getSlop();
  }

  static void lucene_search_PhraseQuery_slop_set(lucene::search::PhraseQuery *self, int_t slop) {
    self->setSlop(slop);
  }

 static 
PyObject *lucene_search_PhraseQuery_terms_get(lucene::search::PhraseQuery *self){
    Term **terms = NULL;
    int size[1];

    self->getTerms(terms, *size);

    PyObject *pyTerms = PyTuple_New(size[0]);
    if (pyTerms == NULL) goto fail;
    for (int i = 0; i < size[0]; i++) {
      /* supp_convertTermToPythonTuple is defined in supp_index.i */
      PyObject *t = supp_convertTermToPythonTuple(terms[i]);
      if (t == NULL) goto fail;
      PyTuple_SET_ITEM(pyTerms, i, t);
    }

    /* PhraseQuery::getTerms doesn't call IGCollectable::pointer() on each
    ** Term before placing it in the array, so we need not call
    ** IGCollectable::finalize(). */
    delete[] terms;
    return pyTerms;
    fail:
      Py_XDECREF(pyTerms);
      delete[] terms;
      if (!PyErr_Occurred()) PyErr_NoMemory();
      return NULL;
  }

   static inline void lucene_search_BooleanQuery_clauses_set(lucene::search::BooleanQuery *o, PyObject * value) {
     PyErr_SetString(PyExc_AttributeError, "property is read-only");
     throw PythonExceptionAlreadySet();
   }
  
 static 
PyObject *lucene_search_BooleanQuery_clauses_get(lucene::search::BooleanQuery *self){
    lucene::search::BooleanClause **clauses = self->getClauses();
    if (clauses == NULL) return PyErr_NoMemory();
    const int nClauses = self->getClauseCount();
    PyObject *pyClauses = PyTuple_New(nClauses);
    if (pyClauses == NULL) goto fail;

    for (int i = 0; i < nClauses; i++) {
      /* Grabbed this conversion snippet from the SWIG-generated BooleanClause
      ** constructor _wrap_new_BooleanClause: */
      PyObject *c = SWIG_NewPointerObj((void *) clauses[i], SWIGTYPE_p_lucene__search__BooleanClause,
          0 /* Zero (false) indicates that the Python proxy doesn't own this. */
        );
      if (c == NULL) goto fail;
      PyTuple_SET_ITEM(pyClauses, i, c);
    }

    delete[] clauses;
    return pyClauses;
    fail:
      delete[] clauses;
      Py_XDECREF(pyClauses);
      if (!PyErr_Occurred()) PyErr_NoMemory();
      return NULL;
  }
 static 
PyObject *lucene_search_TopDocs___iter__(lucene::search::TopDocs *self){
    /* YYY: Optimization: Should create a TopDocsIterator type instead of
    ** materializing a tuple and then returning the tuple's iterator. */
    /* supp_convertScoreDocsArrayToTupleOfScoreDocsObjects is implemented in
    ** supp_search.cpp: */
    PyObject *pySDocs = supp_convertScoreDocsArrayToTupleOfScoreDocsObjects(
        self->scoreDocs, self->scoreDocsLength
      );
    if (pySDocs == NULL) return NULL;
    /* Refcount note:  ret is of type tupleiterobject; that type creates a new
    ** reference to pySDocs for itself, then discards that reference when the
    ** tupleiterobject object is garbage collected (see Python's
    ** tupleobject.c:tuple_iter/tupleiter_dealloc). */
    PyObject *ret = PyObject_GetIter(pySDocs);
    Py_DECREF(pySDocs);
    return ret;
  }
 static 
PyObject *lucene_search_ScoreDoc___repr__(lucene::search::ScoreDoc *self){
    char scoreStr[80];
    sprintf(scoreStr, "%f", self->score);
    return PyString_FromFormat("<ScoreDoc (doc=%d, score=%s)>", self->doc, scoreStr);
  }

   static inline int lucene_analysis_Token_positionIncrement_get(lucene::analysis::Token *o) {
     return (o->getPositionIncrement());
   }
  

   static inline void lucene_analysis_Token_positionIncrement_set(lucene::analysis::Token *o, int value) {
     o->setPositionIncrement(value);
   }
  

   static inline const char * lucene_analysis_Token_text_get(lucene::analysis::Token *o) {
     return (o->TermText());
   }
  

   static inline void lucene_analysis_Token_text_set(lucene::analysis::Token *o, const char * value) {
     PyErr_SetString(PyExc_AttributeError, "property is read-only");
     throw PythonExceptionAlreadySet();
   }
  

   static inline int lucene_analysis_Token_start_get(lucene::analysis::Token *o) {
     return (o->StartOffset());
   }
  

   static inline void lucene_analysis_Token_start_set(lucene::analysis::Token *o, int value) {
     PyErr_SetString(PyExc_AttributeError, "property is read-only");
     throw PythonExceptionAlreadySet();
   }
  

   static inline int lucene_analysis_Token_end_get(lucene::analysis::Token *o) {
     return (o->EndOffset());
   }
  

   static inline void lucene_analysis_Token_end_set(lucene::analysis::Token *o, int value) {
     PyErr_SetString(PyExc_AttributeError, "property is read-only");
     throw PythonExceptionAlreadySet();
   }
  

   static inline const char * lucene_analysis_Token_type_get(lucene::analysis::Token *o) {
     return (o->Type());
   }
  

   static inline void lucene_analysis_Token_type_set(lucene::analysis::Token *o, const char * value) {
     PyErr_SetString(PyExc_AttributeError, "property is read-only");
     throw PythonExceptionAlreadySet();
   }
  

  static PyObject *lucene_analysis_Token_sourceSlice_get(lucene::analysis::Token *self) {
    PyObject *start, *end, *slice;

    if ( (start = PyInt_FromLong(self->StartOffset())) == NULL ) {
      return NULL;
    }
    if ( (end = PyInt_FromLong(self->EndOffset())) == NULL ) {
      Py_DECREF(start);
      return NULL;
    }

    slice = PySlice_New(start, end, NULL);
    /* PySlice_New created its own refs: */
    Py_DECREF(start);
    Py_DECREF(end);

    return slice;
  }


   static inline void lucene_analysis_Token_sourceSlice_set(lucene::analysis::Token *o, PyObject * value) {
     PyErr_SetString(PyExc_AttributeError, "property is read-only");
     throw PythonExceptionAlreadySet();
   }
  

#include "supp_analysis.h"
#include "supp_analysis.cpp"

/***********************************************************************
 * director.swg
 *
 *     This file contains support for director classes that proxy
 *     method calls from C++ to Python extensions.
 *
 * Author : Mark Rose (mrose@stm.lbl.gov)
 ************************************************************************/

#ifdef __cplusplus

#include <string>

namespace Swig {
  /* base class for director exceptions */
  class DirectorException {
    protected:
      std::string swig_msg;
    public:
      DirectorException(const char* msg="") {
      }
      const char *getMessage() const { 
        return swig_msg.c_str(); 
      }
      virtual ~DirectorException() {}
  };

  /* type mismatch in the return value from a python method call */
  class DirectorTypeMismatchException : public Swig::DirectorException {
    public:
      DirectorTypeMismatchException(const char* msg="") {
        swig_msg = "Swig director type mismatch: ";
        swig_msg += msg;
        PyErr_SetString(PyExc_TypeError, msg);
      }
  };

  /* any python exception that occurs during a director method call */
  class DirectorMethodException : public Swig::DirectorException {};

  /* attempt to call a pure virtual method via a director method */
  class DirectorPureVirtualException : public Swig::DirectorException {};


  /* simple thread abstraction for pthreads on win32 */
#ifdef __THREAD__
#define __PTHREAD__
#if defined(_WIN32) || defined(__WIN32__)
#define pthread_mutex_lock EnterCriticalSection
#define pthread_mutex_unlock LeaveCriticalSection
#define pthread_mutex_t CRITICAL_SECTION
#define MUTEX_INIT(var) CRITICAL_SECTION var
#else
#include <pthread.h>
#define MUTEX_INIT(var) pthread_mutex_t var = PTHREAD_MUTEX_INITIALIZER 
#endif
#endif


  /* director base class */
  class Director {
    private:
      /* pointer to the wrapped python object */
      PyObject* swig_self;
      /* flag indicating whether the object is owned by python or c++ */
      mutable bool swig_disown_flag;
      /* shared flag for breaking recursive director calls */
      static bool swig_up;

#ifdef __PTHREAD__
      /* locks for sharing the swig_up flag in a threaded environment */
      static pthread_mutex_t swig_mutex_up;
      static bool swig_mutex_active;
      static pthread_t swig_mutex_thread;
#endif

      /* decrement the reference count of the wrapped python object */
      void swig_decref() const { 
        if (swig_disown_flag) {
          Py_DECREF(swig_self); 
        }
      }

      /* reset the swig_up flag once the routing direction has been determined */
#ifdef __PTHREAD__
      void swig_clear_up() const { 
        Swig::Director::swig_up = false; 
        Swig::Director::swig_mutex_active = false;
        pthread_mutex_unlock(&swig_mutex_up);
      }
#else
      void swig_clear_up() const { 
        Swig::Director::swig_up = false; 
      }
#endif

    public:
      /* wrap a python object, optionally taking ownership */
      Director(PyObject* self, bool disown) : swig_self(self), swig_disown_flag(disown) {
        swig_incref();
      }

      /* discard our reference at destruction */
      virtual ~Director() {
        swig_decref(); 
      }

      /* return a pointer to the wrapped python object */
      PyObject *swig_get_self() const { 
        return swig_self; 
      }

      /* get the swig_up flag to determine if the method call should be routed
       * to the c++ base class or through the wrapped python object
       */
#ifdef __PTHREAD__
      bool swig_get_up() const { 
        if (Swig::Director::swig_mutex_active) {
          if (pthread_equal(Swig::Director::swig_mutex_thread, pthread_self())) {
            bool up = swig_up;
            swig_clear_up();
            return up;
          }
        }
        return 0;
      }
#else 
      bool swig_get_up() const { 
        bool up = swig_up;
        swig_up = false;
        return up;
      }
#endif

      /* set the swig_up flag if the next method call should be directed to
       * the c++ base class rather than the wrapped python object
       */
#ifdef __PTHREAD__
      void swig_set_up() const { 
        pthread_mutex_lock(&Swig::Director::swig_mutex_up);
        Swig::Director::swig_mutex_thread = pthread_self();
        Swig::Director::swig_mutex_active = true;
        Swig::Director::swig_up = true; 
      }
#else 
      void swig_set_up() const { 
        Swig::Director::swig_up = true; 
      }
#endif

      /* acquire ownership of the wrapped python object (the sense of "disown"
       * is from python) */
      void swig_disown() const { 
        if (!swig_disown_flag) { 
          swig_disown_flag=true;
          swig_incref(); 
        } 
      }

      /* increase the reference count of the wrapped python object */
      void swig_incref() const { 
        if (swig_disown_flag) {
          Py_INCREF(swig_self); 
        }
      }

      /* methods to implement pseudo protected director members */
      virtual bool swig_get_inner(const char* name) const {
        return true;
      }

      virtual void swig_set_inner(const char* name, bool val) const {
      }
  };

  bool Swig::Director::swig_up = false;

#ifdef __PTHREAD__
  MUTEX_INIT(Swig::Director::swig_mutex_up);
  pthread_t Swig::Director::swig_mutex_thread;
  bool Swig::Director::swig_mutex_active = false;
#endif

}

#endif /* __cplusplus */




/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "_clucene_wrap.h"

SwigDirector_HitCollector::SwigDirector_HitCollector(PyObject* self, bool disown) : Swig::Director(self, disown) {
    
}



void SwigDirector_HitCollector::collect(int const doc, float const score) { 
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject *result;
    
    if (swig_get_up()) {
        throw Swig::DirectorPureVirtualException();
    }
    obj0 = SWIG_From_int((int)doc);
    obj1 = SWIG_From_float((float)score);
    result = PyObject_CallMethod(swig_get_self(), (char *)"collect", (char *)"(OO)" ,obj0,obj1);
    if (result == NULL) {
        PyObject *error = PyErr_Occurred();
        {
            if (error != NULL) {
/* (POSTPROCESSING-PATCH : BEGIN) */
Py_XDECREF(obj0);
Py_XDECREF(obj1);
/* (POSTPROCESSING-PATCH : END) */
throw Swig::DirectorMethodException();
            }
        }
    }
    Py_XDECREF(obj0);
    Py_XDECREF(obj1);
    Py_XDECREF(result);
}


SwigDirector_Filter::SwigDirector_Filter(PyObject* self, bool disown) : Swig::Director(self, disown) {
    
}



lucene::util::BitSet *SwigDirector_Filter::bits(lucene::index::IndexReader &reader) const { 
    PyObject * obj0 = 0 ;
    lucene::util::BitSet *c_result ;
    PyObject *result;
    
    if (swig_get_up()) {
        throw Swig::DirectorPureVirtualException();
    }
    obj0 = SWIG_NewPointerObj(&reader, SWIGTYPE_p_lucene__index__IndexReader, 0);
    result = PyObject_CallMethod(swig_get_self(), (char *)"bits", (char *)"(O)" ,obj0);
    if (result == NULL) {
        PyObject *error = PyErr_Occurred();
        {
            if (error != NULL) {
/* (POSTPROCESSING-PATCH : BEGIN) */
Py_XDECREF(obj0);
/* (POSTPROCESSING-PATCH : END) */
throw Swig::DirectorMethodException();
            }
        }
    }
    {
        c_result = supp_convertPythonSequenceToBitSet(result);
    }
    Py_XDECREF(obj0);
    Py_XDECREF(result);
    return (lucene::util::BitSet *) c_result;
}


SwigDirector_Analyzer::SwigDirector_Analyzer(PyObject* self, bool disown) : Swig::Director(self, disown) {
    
}



lucene::analysis::TokenStream &SwigDirector_Analyzer::tokenStream(char const *fieldName, lucene::util::Reader *reader) { 
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    lucene::analysis::TokenStream *c_result ;
    PyObject *result;
    
    if (swig_get_up()) {
        throw Swig::DirectorPureVirtualException();
    }
    {
        /* YYY:
          ** obj0 is the Python object, but I could find no special SWIG variable
          ** name for the C char_t pointer that was bound in the context of a
          ** Director-typemap. */
        CONVERT_STRING_OUT(fieldName, obj0);
    }
    {
        /* YYY:
          ** obj1 is the Python object, but I could find no special SWIG variable
          ** name for the C Reader pointer that was bound in the context of a
          ** Director-typemap. */
        const long_t nCharsAvailable_long = reader->available();
        if (nCharsAvailable_long > INT_MAX) {
            /* Python string can have length no longer than the max of C int. */
            throw THROW_TYPE("Reader value too long to fit in Python string.");
        }
        const int nCharsAvailable = static_cast<int>(nCharsAvailable_long);
        obj1 = PyString_FromStringAndSize(NULL, nCharsAvailable);
        if (obj1 == NULL) {
            PyErr_NoMemory();
            throw PythonExceptionAlreadySet();
        }
        
        /* UNICODE: Will need to be retrofitted. */
        char* internalBuf = PyString_AS_STRING(obj1);
        reader->read(internalBuf, 0, nCharsAvailable);
    }
    result = PyObject_CallMethod(swig_get_self(), (char *)"tokenStream", (char *)"(OO)" ,obj0,obj1);
    if (result == NULL) {
        PyObject *error = PyErr_Occurred();
        {
            if (error != NULL) {
/* (POSTPROCESSING-PATCH : BEGIN) */
Py_XDECREF(obj0);
Py_XDECREF(obj1);
/* (POSTPROCESSING-PATCH : END) */
throw Swig::DirectorMethodException();
            }
        }
    }
    {
        /* YYY: It's safe to decref these specific variable names because I know
          ** that this typemap is currently used in only one context, but this
          ** could cause a problem in the future. */
#define _FREE_THE_SWIGCREATED_DIRECTOR_ARGS()       \
        Py_XDECREF(obj0);                                \
        Py_XDECREF(obj1);                                \
        Py_XDECREF(result);
        
        if (result == Py_None) {
            PyErr_SetString(PyExc_TypeError, "The token stream must not be None.");
            _FREE_THE_SWIGCREATED_DIRECTOR_ARGS();
            throw PythonExceptionAlreadySet();
        }
        if (-1 ==
        SWIG_ConvertPtr(
        result,
        (void **)(&c_result),
        SWIGTYPE_p_lucene__analysis__TokenStream,
        SWIG_POINTER_EXCEPTION | 0
        )
        )
        {
            PyErr_Clear();
            try {
                c_result = new PythonTokenStream(result);
            } catch(...) {
                _FREE_THE_SWIGCREATED_DIRECTOR_ARGS();
                throw;
            }
            /* If there was an error, the alternative constructor should've raised a
                ** C++ exception rather than just setting a Python exception and
                ** returning. */
            assert (!PyErr_Occurred());
        }
    }
    Py_XDECREF(obj0);
    Py_XDECREF(obj1);
    Py_XDECREF(result);
    return (lucene::analysis::TokenStream &) *c_result;
}


#ifdef __cplusplus
extern "C" {
#endif
static int _wrap_UNICODE_BUILD_set(PyObject *) {
    PyErr_SetString(PyExc_TypeError,"Variable UNICODE_BUILD is read-only.");
    return 1;
}


static PyObject *_wrap_UNICODE_BUILD_get() {
    PyObject *pyobj;
    
    pyobj = SWIG_From_bool((bool)UNICODE_BUILD);
    return pyobj;
}


static int _wrap_SUMO_BUILD_set(PyObject *) {
    PyErr_SetString(PyExc_TypeError,"Variable SUMO_BUILD is read-only.");
    return 1;
}


static PyObject *_wrap_SUMO_BUILD_get() {
    PyObject *pyobj;
    
    pyobj = SWIG_From_bool((bool)SUMO_BUILD);
    return pyobj;
}


static int _wrap_global_string_this_set(PyObject *_val) {
    {
        void *temp;
        if ((SWIG_ConvertPtr(_val, &temp, SWIGTYPE_p_PyObject, SWIG_POINTER_EXCEPTION | SWIG_POINTER_DISOWN)) == -1) {
            PyErr_SetString(PyExc_TypeError, "C/C++ variable 'global_string_this (PyObject *)'");
            return 1;
        }
        global_string_this = (PyObject *) temp;
    }
    return 0;
}


static PyObject *_wrap_global_string_this_get() {
    PyObject *pyobj;
    
    pyobj = SWIG_NewPointerObj((void *)(global_string_this), SWIGTYPE_p_PyObject, 0);
    return pyobj;
}


static int _wrap_global_string_thisown_set(PyObject *_val) {
    {
        void *temp;
        if ((SWIG_ConvertPtr(_val, &temp, SWIGTYPE_p_PyObject, SWIG_POINTER_EXCEPTION | SWIG_POINTER_DISOWN)) == -1) {
            PyErr_SetString(PyExc_TypeError, "C/C++ variable 'global_string_thisown (PyObject *)'");
            return 1;
        }
        global_string_thisown = (PyObject *) temp;
    }
    return 0;
}


static PyObject *_wrap_global_string_thisown_get() {
    PyObject *pyobj;
    
    pyobj = SWIG_NewPointerObj((void *)(global_string_thisown), SWIGTYPE_p_PyObject, 0);
    return pyobj;
}


static PyObject *_wrap_setGlobals(PyObject *, PyObject *args) {
    PyObject *resultobj;
    PyObject *arg1 = (PyObject *) 0 ;
    PyObject *arg2 = (PyObject *) 0 ;
    PyObject *arg3 = (PyObject *) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:setGlobals",&obj0,&obj1,&obj2)) goto fail;
    arg1 = obj0;
    arg2 = obj1;
    arg3 = obj2;
    {
        try {
            setGlobals(arg1,arg2,arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_StringReader(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    int arg2 ;
    bool arg3 = (bool) (bool)false ;
    lucene::util::StringReader *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO|O:new_StringReader",&obj0,&obj1,&obj2)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    if (obj2) {
        {
            arg3 = PyObject_IsTrue(obj2) ? true : false;
        }
    }
    {
        try {
            result = (lucene::util::StringReader *)new lucene::util::StringReader((char const *)arg1,arg2,arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__util__StringReader, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_StringReader(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::util::StringReader *arg1 = (lucene::util::StringReader *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_StringReader",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__util__StringReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_StringReader_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::util::StringReader *arg1 = (lucene::util::StringReader *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:StringReader_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__util__StringReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * StringReader_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__util__StringReader, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_FileReader___eq__(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::util::FileReader *arg1 = (lucene::util::FileReader *) 0 ;
    lucene::util::Reader *arg2 = (lucene::util::Reader *) 0 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:FileReader___eq__",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__util__FileReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__util__Reader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (PyObject *)lucene_util_FileReader___eq__(arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_FileReader(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    lucene::util::FileReader *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_FileReader",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    {
        try {
            result = (lucene::util::FileReader *)new lucene::util::FileReader((char const *)arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__util__FileReader, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_FileReader(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::util::FileReader *arg1 = (lucene::util::FileReader *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_FileReader",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__util__FileReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FileReader_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::util::FileReader *arg1 = (lucene::util::FileReader *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:FileReader_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__util__FileReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * FileReader_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__util__FileReader, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_InputStream_readString(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::InputStream *arg1 = (lucene::store::InputStream *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:InputStream_readString",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__InputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (char *)lucene_store_InputStream_readString(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_InputStream_readByte(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::InputStream *arg1 = (lucene::store::InputStream *) 0 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:InputStream_readByte",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__InputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (PyObject *)lucene_store_InputStream_readByte(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_InputStream_readBytes(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::InputStream *arg1 = (lucene::store::InputStream *) 0 ;
    int arg2 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:InputStream_readBytes",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__InputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    {
        try {
            result = (PyObject *)lucene_store_InputStream_readBytes(arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_InputStream_readChars(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::InputStream *arg1 = (lucene::store::InputStream *) 0 ;
    int arg2 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:InputStream_readChars",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__InputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    {
        try {
            result = (PyObject *)lucene_store_InputStream_readChars(arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_InputStream_read(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::InputStream *arg1 = (lucene::store::InputStream *) 0 ;
    int arg2 = (int) (int)-1 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O|O:InputStream_read",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__InputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (obj1) {
        arg2 = (int)SWIG_As_int(obj1); 
        if (PyErr_Occurred()) SWIG_fail;
    }
    {
        try {
            result = (PyObject *)lucene_store_InputStream_read(arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_InputStream_filePointer_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::InputStream *arg1 = (lucene::store::InputStream *) 0 ;
    long_t arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:InputStream_filePointer_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__InputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        if (PyInt_Check(obj1)) {
            arg2 = (long_t) PyInt_AS_LONG(obj1);
        } else if (PyLong_Check(obj1)) {
            arg2 = PyLong_AsLongLong(obj1);
            if (PyErr_Occurred()) {
                /* E.g., an OverflowError in the conversion above. */
                SWIG_fail;
            }
        } else {
            PyErr_SetString(PyExc_TypeError, "int or long required");
            SWIG_fail;
        }
    }
    {
        try {
            lucene_store_InputStream_filePointer_set(arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_InputStream_filePointer_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::InputStream *arg1 = (lucene::store::InputStream *) 0 ;
    long_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:InputStream_filePointer_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__InputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = lucene_store_InputStream_filePointer_get(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        if (result <= LONG_MAX) {
            resultobj = PyInt_FromLong((long)result);
        } else {
            resultobj = PyLong_FromLongLong(result);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_InputStream(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::InputStream *arg1 = (lucene::store::InputStream *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_InputStream",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__InputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_InputStream_clone(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::InputStream *arg1 = (lucene::store::InputStream *) 0 ;
    lucene::store::InputStream *result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:InputStream_clone",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__InputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            {
                lucene::store::InputStream &_result_ref = (arg1)->clone();
                result = (lucene::store::InputStream *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__store__InputStream, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_InputStream_readInt(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::InputStream *arg1 = (lucene::store::InputStream *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:InputStream_readInt",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__InputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (int)(arg1)->readInt();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_InputStream_readVInt(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::InputStream *arg1 = (lucene::store::InputStream *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:InputStream_readVInt",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__InputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (int)(arg1)->readVInt();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_InputStream_readLong(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::InputStream *arg1 = (lucene::store::InputStream *) 0 ;
    long_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:InputStream_readLong",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__InputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (arg1)->readLong();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        if (result <= LONG_MAX) {
            resultobj = PyInt_FromLong((long)result);
        } else {
            resultobj = PyLong_FromLongLong(result);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_InputStream_readVLong(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::InputStream *arg1 = (lucene::store::InputStream *) 0 ;
    long_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:InputStream_readVLong",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__InputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (arg1)->readVLong();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        if (result <= LONG_MAX) {
            resultobj = PyInt_FromLong((long)result);
        } else {
            resultobj = PyLong_FromLongLong(result);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_InputStream_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::InputStream *arg1 = (lucene::store::InputStream *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:InputStream_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__InputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_InputStream_seek(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::InputStream *arg1 = (lucene::store::InputStream *) 0 ;
    long_t arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:InputStream_seek",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__InputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        if (PyInt_Check(obj1)) {
            arg2 = (long_t) PyInt_AS_LONG(obj1);
        } else if (PyLong_Check(obj1)) {
            arg2 = PyLong_AsLongLong(obj1);
            if (PyErr_Occurred()) {
                /* E.g., an OverflowError in the conversion above. */
                SWIG_fail;
            }
        } else {
            PyErr_SetString(PyExc_TypeError, "int or long required");
            SWIG_fail;
        }
    }
    {
        try {
            (arg1)->seek(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_InputStream___len__(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::InputStream *arg1 = (lucene::store::InputStream *) 0 ;
    long_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:InputStream___len__",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__InputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (arg1)->Length();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        if (result <= LONG_MAX) {
            resultobj = PyInt_FromLong((long)result);
        } else {
            resultobj = PyLong_FromLongLong(result);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject * InputStream_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__store__InputStream, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_OutputStream_writeByte(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::OutputStream *arg1 = (lucene::store::OutputStream *) 0 ;
    PyObject *arg2 = (PyObject *) 0 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:OutputStream_writeByte",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__OutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = obj1;
    {
        try {
            result = (PyObject *)lucene_store_OutputStream_writeByte(arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_OutputStream_writeChars(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::OutputStream *arg1 = (lucene::store::OutputStream *) 0 ;
    char *arg2 ;
    int arg3 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:OutputStream_writeChars",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__OutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    arg3 = (int)SWIG_As_int(obj2); 
    if (PyErr_Occurred()) SWIG_fail;
    {
        try {
            result = (PyObject *)lucene_store_OutputStream_writeChars(arg1,(char const *)arg2,arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_OutputStream_write(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::OutputStream *arg1 = (lucene::store::OutputStream *) 0 ;
    unsigned char *arg2 = (unsigned char *) 0 ;
    int arg3 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:OutputStream_write",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__OutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        if (!PyString_Check(obj1)) {
            PyErr_SetString(PyExc_ValueError, "Expecting a string");
            return NULL;
        }
        PyString_AsStringAndSize(obj1, (char **) &arg2, (int *) &arg3);
    }
    {
        try {
            result = (PyObject *)lucene_store_OutputStream_write(arg1,(unsigned char const *)arg2,arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_OutputStream_filePointer_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::OutputStream *arg1 = (lucene::store::OutputStream *) 0 ;
    long_t arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:OutputStream_filePointer_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__OutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        if (PyInt_Check(obj1)) {
            arg2 = (long_t) PyInt_AS_LONG(obj1);
        } else if (PyLong_Check(obj1)) {
            arg2 = PyLong_AsLongLong(obj1);
            if (PyErr_Occurred()) {
                /* E.g., an OverflowError in the conversion above. */
                SWIG_fail;
            }
        } else {
            PyErr_SetString(PyExc_TypeError, "int or long required");
            SWIG_fail;
        }
    }
    {
        try {
            lucene_store_OutputStream_filePointer_set(arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_OutputStream_filePointer_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::OutputStream *arg1 = (lucene::store::OutputStream *) 0 ;
    long_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:OutputStream_filePointer_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__OutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = lucene_store_OutputStream_filePointer_get(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        if (result <= LONG_MAX) {
            resultobj = PyInt_FromLong((long)result);
        } else {
            resultobj = PyLong_FromLongLong(result);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_OutputStream(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::OutputStream *arg1 = (lucene::store::OutputStream *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_OutputStream",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__OutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_OutputStream_writeBytes(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::OutputStream *arg1 = (lucene::store::OutputStream *) 0 ;
    unsigned char *arg2 = (unsigned char *) 0 ;
    int arg3 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:OutputStream_writeBytes",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__OutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        if (!PyString_Check(obj1)) {
            PyErr_SetString(PyExc_ValueError, "Expecting a string");
            return NULL;
        }
        PyString_AsStringAndSize(obj1, (char **) &arg2, (int *) &arg3);
    }
    {
        try {
            (arg1)->writeBytes((unsigned char const *)arg2,arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_OutputStream_writeInt(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::OutputStream *arg1 = (lucene::store::OutputStream *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:OutputStream_writeInt",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__OutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    {
        try {
            (arg1)->writeInt(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_OutputStream_writeVInt(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::OutputStream *arg1 = (lucene::store::OutputStream *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:OutputStream_writeVInt",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__OutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    {
        try {
            (arg1)->writeVInt(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_OutputStream_writeLong(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::OutputStream *arg1 = (lucene::store::OutputStream *) 0 ;
    long_t arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:OutputStream_writeLong",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__OutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        if (PyInt_Check(obj1)) {
            arg2 = (long_t) PyInt_AS_LONG(obj1);
        } else if (PyLong_Check(obj1)) {
            arg2 = PyLong_AsLongLong(obj1);
            if (PyErr_Occurred()) {
                /* E.g., an OverflowError in the conversion above. */
                SWIG_fail;
            }
        } else {
            PyErr_SetString(PyExc_TypeError, "int or long required");
            SWIG_fail;
        }
    }
    {
        try {
            (arg1)->writeLong(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_OutputStream_writeVLong(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::OutputStream *arg1 = (lucene::store::OutputStream *) 0 ;
    long_t arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:OutputStream_writeVLong",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__OutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        if (PyInt_Check(obj1)) {
            arg2 = (long_t) PyInt_AS_LONG(obj1);
        } else if (PyLong_Check(obj1)) {
            arg2 = PyLong_AsLongLong(obj1);
            if (PyErr_Occurred()) {
                /* E.g., an OverflowError in the conversion above. */
                SWIG_fail;
            }
        } else {
            PyErr_SetString(PyExc_TypeError, "int or long required");
            SWIG_fail;
        }
    }
    {
        try {
            (arg1)->writeVLong(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_OutputStream_writeString(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::OutputStream *arg1 = (lucene::store::OutputStream *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:OutputStream_writeString",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__OutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    {
        try {
            (arg1)->writeString((char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_OutputStream_isClosed(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::OutputStream *arg1 = (lucene::store::OutputStream *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:OutputStream_isClosed",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__OutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (bool)((lucene::store::OutputStream const *)arg1)->isClosed();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_OutputStream_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::OutputStream *arg1 = (lucene::store::OutputStream *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:OutputStream_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__OutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_OutputStream___len__(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::OutputStream *arg1 = (lucene::store::OutputStream *) 0 ;
    long_t result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:OutputStream___len__",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__OutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (arg1)->Length();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        if (result <= LONG_MAX) {
            resultobj = PyInt_FromLong((long)result);
        } else {
            resultobj = PyLong_FromLongLong(result);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject * OutputStream_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__store__OutputStream, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_Lock_obtain(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::LuceneLock *arg1 = (lucene::store::LuceneLock *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:Lock_obtain",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__LuceneLock,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (bool)(arg1)->obtain();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Lock_release(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::LuceneLock *arg1 = (lucene::store::LuceneLock *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:Lock_release",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__LuceneLock,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->release();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_Lock(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::LuceneLock *arg1 = (lucene::store::LuceneLock *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_Lock",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__LuceneLock,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * Lock_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__store__LuceneLock, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_delete_LockWith(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::LuceneLockWith *arg1 = (lucene::store::LuceneLockWith *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_LockWith",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__LuceneLockWith,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_LockWith_run(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::LuceneLockWith *arg1 = (lucene::store::LuceneLockWith *) 0 ;
    void *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:LockWith_run",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__LuceneLockWith,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (void *)(arg1)->run();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_void, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject * LockWith_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__store__LuceneLockWith, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_delete_Directory(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::Directory *arg1 = (lucene::store::Directory *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_Directory",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__Directory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Directory_list(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::Directory *arg1 = (lucene::store::Directory *) 0 ;
    char ***arg2 = 0 ;
    int *arg3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:Directory_list",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__Directory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_p_p_char,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    if ((SWIG_ConvertPtr(obj2,(void **)(&arg3),SWIGTYPE_p_int,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg3 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->list(*arg2,*arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Directory_fileExists(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::Directory *arg1 = (lucene::store::Directory *) 0 ;
    char *arg2 ;
    bool result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Directory_fileExists",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__Directory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (bool)((lucene::store::Directory const *)arg1)->fileExists((char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Directory_fileModified(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::Directory *arg1 = (lucene::store::Directory *) 0 ;
    char *arg2 ;
    long_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Directory_fileModified",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__Directory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = ((lucene::store::Directory const *)arg1)->fileModified((char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        if (result <= LONG_MAX) {
            resultobj = PyInt_FromLong((long)result);
        } else {
            resultobj = PyLong_FromLongLong(result);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Directory_fileLength(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::Directory *arg1 = (lucene::store::Directory *) 0 ;
    char *arg2 ;
    long_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Directory_fileLength",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__Directory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = ((lucene::store::Directory const *)arg1)->fileLength((char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        if (result <= LONG_MAX) {
            resultobj = PyInt_FromLong((long)result);
        } else {
            resultobj = PyLong_FromLongLong(result);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Directory_openFile(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::Directory *arg1 = (lucene::store::Directory *) 0 ;
    char *arg2 ;
    lucene::store::InputStream *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Directory_openFile",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__Directory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            {
                lucene::store::InputStream &_result_ref = (arg1)->openFile((char const *)arg2);
                result = (lucene::store::InputStream *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__store__InputStream, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Directory_deleteFile(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::Directory *arg1 = (lucene::store::Directory *) 0 ;
    char *arg2 ;
    bool arg3 = (bool) (bool)true ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO|O:Directory_deleteFile",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__Directory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    if (obj2) {
        {
            arg3 = PyObject_IsTrue(obj2) ? true : false;
        }
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->deleteFile((char const *)arg2,arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Directory_renameFile(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::Directory *arg1 = (lucene::store::Directory *) 0 ;
    char *arg2 ;
    char *arg3 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:Directory_renameFile",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__Directory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj2, (char**)&arg3)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->renameFile((char const *)arg2,(char const *)arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Directory_createFile(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::Directory *arg1 = (lucene::store::Directory *) 0 ;
    char *arg2 ;
    lucene::store::OutputStream *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Directory_createFile",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__Directory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            {
                lucene::store::OutputStream &_result_ref = (arg1)->createFile((char const *)arg2);
                result = (lucene::store::OutputStream *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__store__OutputStream, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Directory_makeLock(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::Directory *arg1 = (lucene::store::Directory *) 0 ;
    char *arg2 ;
    lucene::store::LuceneLock *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Directory_makeLock",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__Directory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (lucene::store::LuceneLock *)(arg1)->makeLock((char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__store__LuceneLock, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Directory_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::Directory *arg1 = (lucene::store::Directory *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:Directory_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__Directory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * Directory_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__store__Directory, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_FSInputStream_clone(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSInputStream *arg1 = (lucene::store::FSInputStream *) 0 ;
    lucene::store::FSInputStream *result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:FSInputStream_clone",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSInputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            {
                lucene::store::FSInputStream &_result_ref = lucene_store_FSInputStream_clone(arg1);
                result = (lucene::store::FSInputStream *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__store__FSInputStream, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FSInputStream_isClone_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSInputStream *arg1 = (lucene::store::FSInputStream *) 0 ;
    bool arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:FSInputStream_isClone_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSInputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        arg2 = PyObject_IsTrue(obj1) ? true : false;
    }
    if (arg1) (arg1)->isClone = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FSInputStream_isClone_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSInputStream *arg1 = (lucene::store::FSInputStream *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:FSInputStream_isClone_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSInputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    result = (bool) ((arg1)->isClone);
    
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_FSInputStream_FromFilename(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    lucene::store::FSInputStream *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_FSInputStream_FromFilename",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    {
        try {
            result = (lucene::store::FSInputStream *)new lucene::store::FSInputStream((char const *)arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__store__FSInputStream, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_FSInputStream(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSInputStream *arg1 = (lucene::store::FSInputStream *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_FSInputStream",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSInputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FSInputStream_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSInputStream *arg1 = (lucene::store::FSInputStream *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:FSInputStream_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSInputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * FSInputStream_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__store__FSInputStream, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_FSOutputStream(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    lucene::store::FSOutputStream *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_FSOutputStream",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    {
        try {
            result = (lucene::store::FSOutputStream *)new lucene::store::FSOutputStream((char const *)arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__store__FSOutputStream, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_FSOutputStream(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSOutputStream *arg1 = (lucene::store::FSOutputStream *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_FSOutputStream",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSOutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FSOutputStream_flushBuffer(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSOutputStream *arg1 = (lucene::store::FSOutputStream *) 0 ;
    unsigned char *arg2 = (unsigned char *) 0 ;
    int arg3 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:FSOutputStream_flushBuffer",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSOutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_unsigned_char,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg3 = (int)SWIG_As_int(obj2); 
    if (PyErr_Occurred()) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->flushBuffer((unsigned char const *)arg2,arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FSOutputStream_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSOutputStream *arg1 = (lucene::store::FSOutputStream *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:FSOutputStream_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSOutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FSOutputStream___len__(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSOutputStream *arg1 = (lucene::store::FSOutputStream *) 0 ;
    long_t result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:FSOutputStream___len__",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSOutputStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (arg1)->Length();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        if (result <= LONG_MAX) {
            resultobj = PyInt_FromLong((long)result);
        } else {
            resultobj = PyLong_FromLongLong(result);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject * FSOutputStream_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__store__FSOutputStream, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_FSDirectory_name_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSDirectory *arg1 = (lucene::store::FSDirectory *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:FSDirectory_name_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    {
        try {
            lucene_store_FSDirectory_name_set(arg1,(char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FSDirectory_name_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSDirectory *arg1 = (lucene::store::FSDirectory *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:FSDirectory_name_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (char *)lucene_store_FSDirectory_name_get(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_FSDirectory(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    bool arg2 ;
    lucene::store::FSDirectory *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:new_FSDirectory",&obj0,&obj1)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    {
        arg2 = PyObject_IsTrue(obj1) ? true : false;
    }
    {
        try {
            result = (lucene::store::FSDirectory *)new lucene::store::FSDirectory((char const *)arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__store__FSDirectory, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_FSDirectory(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSDirectory *arg1 = (lucene::store::FSDirectory *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_FSDirectory",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FSDirectory_fileExists(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSDirectory *arg1 = (lucene::store::FSDirectory *) 0 ;
    char *arg2 ;
    bool result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:FSDirectory_fileExists",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (bool)((lucene::store::FSDirectory const *)arg1)->fileExists((char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FSDirectory_fileLength(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSDirectory *arg1 = (lucene::store::FSDirectory *) 0 ;
    char *arg2 ;
    long_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:FSDirectory_fileLength",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = ((lucene::store::FSDirectory const *)arg1)->fileLength((char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        if (result <= LONG_MAX) {
            resultobj = PyInt_FromLong((long)result);
        } else {
            resultobj = PyLong_FromLongLong(result);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FSDirectory_deleteFile(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSDirectory *arg1 = (lucene::store::FSDirectory *) 0 ;
    char *arg2 ;
    bool arg3 = (bool) (bool)true ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO|O:FSDirectory_deleteFile",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    if (obj2) {
        {
            arg3 = PyObject_IsTrue(obj2) ? true : false;
        }
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->deleteFile((char const *)arg2,arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FSDirectory_renameFile(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSDirectory *arg1 = (lucene::store::FSDirectory *) 0 ;
    char *arg2 ;
    char *arg3 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:FSDirectory_renameFile",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj2, (char**)&arg3)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->renameFile((char const *)arg2,(char const *)arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FSDirectory_createFile(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSDirectory *arg1 = (lucene::store::FSDirectory *) 0 ;
    char *arg2 ;
    lucene::store::OutputStream *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:FSDirectory_createFile",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            {
                lucene::store::OutputStream &_result_ref = (arg1)->createFile((char const *)arg2);
                result = (lucene::store::OutputStream *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__store__OutputStream, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FSDirectory_openFile(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSDirectory *arg1 = (lucene::store::FSDirectory *) 0 ;
    char *arg2 ;
    lucene::store::InputStream *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:FSDirectory_openFile",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            {
                lucene::store::InputStream &_result_ref = (arg1)->openFile((char const *)arg2);
                result = (lucene::store::InputStream *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__store__InputStream, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FSDirectory_makeLock(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSDirectory *arg1 = (lucene::store::FSDirectory *) 0 ;
    char *arg2 ;
    lucene::store::LuceneLock *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:FSDirectory_makeLock",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (lucene::store::LuceneLock *)(arg1)->makeLock((char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__store__LuceneLock, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FSDirectory_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSDirectory *arg1 = (lucene::store::FSDirectory *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:FSDirectory_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * FSDirectory_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__store__FSDirectory, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_FSLock_filename_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSLock *arg1 = (lucene::store::FSLock *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:FSLock_filename_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSLock,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    result = (char *) ((arg1)->fname);
    
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_FSLock(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    lucene::store::FSLock *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_FSLock",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    {
        try {
            result = (lucene::store::FSLock *)new lucene::store::FSLock((char const *)arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__store__FSLock, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_FSLock(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSLock *arg1 = (lucene::store::FSLock *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_FSLock",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSLock,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FSLock_obtain(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSLock *arg1 = (lucene::store::FSLock *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:FSLock_obtain",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSLock,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (bool)(arg1)->obtain();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FSLock_release(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::FSLock *arg1 = (lucene::store::FSLock *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:FSLock_release",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__FSLock,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->release();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * FSLock_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__store__FSLock, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_RAMDirectory_list(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::RAMDirectory *arg1 = (lucene::store::RAMDirectory *) 0 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:RAMDirectory_list",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__RAMDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (PyObject *)lucene_store_RAMDirectory_list(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_RAMDirectory(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::RAMDirectory *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_RAMDirectory")) goto fail;
    {
        try {
            result = (lucene::store::RAMDirectory *)new lucene::store::RAMDirectory();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__store__RAMDirectory, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_RAMDirectory(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::RAMDirectory *arg1 = (lucene::store::RAMDirectory *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_RAMDirectory",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__RAMDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_RAMDirectory_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::RAMDirectory *arg1 = (lucene::store::RAMDirectory *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:RAMDirectory_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__RAMDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * RAMDirectory_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__store__RAMDirectory, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_TransactionalRAMDirectory(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::TransactionalRAMDirectory *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_TransactionalRAMDirectory")) goto fail;
    {
        try {
            result = (lucene::store::TransactionalRAMDirectory *)new lucene::store::TransactionalRAMDirectory();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__store__TransactionalRAMDirectory, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TransactionalRAMDirectory_transIsOpen(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::TransactionalRAMDirectory *arg1 = (lucene::store::TransactionalRAMDirectory *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TransactionalRAMDirectory_transIsOpen",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__TransactionalRAMDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (bool)(arg1)->transIsOpen();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TransactionalRAMDirectory_transStart(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::TransactionalRAMDirectory *arg1 = (lucene::store::TransactionalRAMDirectory *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TransactionalRAMDirectory_transStart",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__TransactionalRAMDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            (arg1)->transStart();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TransactionalRAMDirectory_transCommit(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::TransactionalRAMDirectory *arg1 = (lucene::store::TransactionalRAMDirectory *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TransactionalRAMDirectory_transCommit",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__TransactionalRAMDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            (arg1)->transCommit();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TransactionalRAMDirectory_transAbort(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::TransactionalRAMDirectory *arg1 = (lucene::store::TransactionalRAMDirectory *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TransactionalRAMDirectory_transAbort",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__TransactionalRAMDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            (arg1)->transAbort();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TransactionalRAMDirectory_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::TransactionalRAMDirectory *arg1 = (lucene::store::TransactionalRAMDirectory *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TransactionalRAMDirectory_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__TransactionalRAMDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TransactionalRAMDirectory_dummy_createFile(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::TransactionalRAMDirectory *arg1 = (lucene::store::TransactionalRAMDirectory *) 0 ;
    char *arg2 ;
    PyObject *arg3 = (PyObject *) 0 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:TransactionalRAMDirectory_dummy_createFile",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__TransactionalRAMDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    arg3 = obj2;
    {
        try {
            result = (PyObject *)lucene_store_TransactionalRAMDirectory_dummy_createFile(arg1,(char const *)arg2,arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TransactionalRAMDirectory_dummy_deleteFile(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::TransactionalRAMDirectory *arg1 = (lucene::store::TransactionalRAMDirectory *) 0 ;
    char *arg2 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:TransactionalRAMDirectory_dummy_deleteFile",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__TransactionalRAMDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    {
        try {
            result = (PyObject *)lucene_store_TransactionalRAMDirectory_dummy_deleteFile(arg1,(char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TransactionalRAMDirectory_dummy_renameFile(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::TransactionalRAMDirectory *arg1 = (lucene::store::TransactionalRAMDirectory *) 0 ;
    char *arg2 ;
    char *arg3 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:TransactionalRAMDirectory_dummy_renameFile",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__TransactionalRAMDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj2, (char**)&arg3)) SWIG_fail;
    {
        try {
            result = (PyObject *)lucene_store_TransactionalRAMDirectory_dummy_renameFile(arg1,(char const *)arg2,(char const *)arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TransactionalRAMDirectory_dummy_readFile(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::TransactionalRAMDirectory *arg1 = (lucene::store::TransactionalRAMDirectory *) 0 ;
    char *arg2 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:TransactionalRAMDirectory_dummy_readFile",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__TransactionalRAMDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    {
        try {
            result = (PyObject *)lucene_store_TransactionalRAMDirectory_dummy_readFile(arg1,(char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_TransactionalRAMDirectory(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::TransactionalRAMDirectory *arg1 = (lucene::store::TransactionalRAMDirectory *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_TransactionalRAMDirectory",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__TransactionalRAMDirectory,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * TransactionalRAMDirectory_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__store__TransactionalRAMDirectory, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_DateField_timeToString(PyObject *, PyObject *args) {
    PyObject *resultobj;
    long_t arg1 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:DateField_timeToString",&obj0)) goto fail;
    {
        if (PyInt_Check(obj0)) {
            arg1 = (long_t) PyInt_AS_LONG(obj0);
        } else if (PyLong_Check(obj0)) {
            arg1 = PyLong_AsLongLong(obj0);
            if (PyErr_Occurred()) {
                /* E.g., an OverflowError in the conversion above. */
                SWIG_fail;
            }
        } else {
            PyErr_SetString(PyExc_TypeError, "int or long required");
            SWIG_fail;
        }
    }
    {
        try {
            result = (PyObject *)DateField_timeToString(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_DateField_stringToTime(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    long_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:DateField_stringToTime",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    {
        try {
            result = DateField_stringToTime((char const *)arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        if (result <= LONG_MAX) {
            resultobj = PyInt_FromLong((long)result);
        } else {
            resultobj = PyLong_FromLongLong(result);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TermEnum__iter__(PyObject *, PyObject *args) {
    PyObject *resultobj;
    PyObject *arg1 = (PyObject *) 0 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TermEnum__iter__",&obj0)) goto fail;
    arg1 = obj0;
    {
        try {
            result = (PyObject *)TermEnum__iter__(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_TermDocs(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::TermDocs *arg1 = (lucene::index::TermDocs *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_TermDocs",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__TermDocs,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TermDocs_seek(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::TermDocs *arg1 = (lucene::index::TermDocs *) 0 ;
    lucene::index::Term *arg2 = (lucene::index::Term *) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:TermDocs_seek",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__TermDocs,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        arg2 = supp_convertPythonTupleToTerm(obj1);
        if (arg2 == NULL) SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->seek(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    {
        arg2->finalize();
    }
    return resultobj;
    fail:
    {
        arg2->finalize();
    }
    return NULL;
}


static PyObject *_wrap_TermDocs_doc(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::TermDocs *arg1 = (lucene::index::TermDocs *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TermDocs_doc",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__TermDocs,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (int)((lucene::index::TermDocs const *)arg1)->Doc();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TermDocs_freq(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::TermDocs *arg1 = (lucene::index::TermDocs *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TermDocs_freq",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__TermDocs,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (int)((lucene::index::TermDocs const *)arg1)->Freq();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TermDocs_next(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::TermDocs *arg1 = (lucene::index::TermDocs *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TermDocs_next",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__TermDocs,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (bool)(arg1)->next();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TermDocs_skipTo(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::TermDocs *arg1 = (lucene::index::TermDocs *) 0 ;
    int arg2 ;
    bool result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:TermDocs_skipTo",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__TermDocs,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (bool)(arg1)->skipTo(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TermDocs_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::TermDocs *arg1 = (lucene::index::TermDocs *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TermDocs_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__TermDocs,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * TermDocs_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__index__TermDocs, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_TermEnum_term(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::TermEnum *arg1 = (lucene::index::TermEnum *) 0 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TermEnum_term",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__TermEnum,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (PyObject *)lucene_index_TermEnum_term(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TermEnum_itercall(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::TermEnum *arg1 = (lucene::index::TermEnum *) 0 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TermEnum_itercall",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__TermEnum,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (PyObject *)lucene_index_TermEnum_itercall(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TermEnum_next(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::TermEnum *arg1 = (lucene::index::TermEnum *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TermEnum_next",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__TermEnum,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (bool)(arg1)->next();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TermEnum_docFreq(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::TermEnum *arg1 = (lucene::index::TermEnum *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TermEnum_docFreq",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__TermEnum,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (int)((lucene::index::TermEnum const *)arg1)->DocFreq();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TermEnum_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::TermEnum *arg1 = (lucene::index::TermEnum *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TermEnum_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__TermEnum,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_TermEnum(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::TermEnum *arg1 = (lucene::index::TermEnum *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_TermEnum",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__TermEnum,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * TermEnum_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__index__TermEnum, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_TermPositions_nextPosition(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::TermPositions *arg1 = (lucene::index::TermPositions *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TermPositions_nextPosition",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__TermPositions,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (int)(arg1)->nextPosition();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_TermPositions(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::TermPositions *arg1 = (lucene::index::TermPositions *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_TermPositions",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__TermPositions,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * TermPositions_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__index__TermPositions, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_IndexReader_directory_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexReader *arg1 = (lucene::index::IndexReader *) 0 ;
    lucene::store::Directory *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexReader_directory_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        lucene::store::Directory &_result_ref = (lucene::store::Directory &) ((arg1)->directory);
        result = (lucene::store::Directory *) &_result_ref;
    }
    
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__store__Directory, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_IndexReader(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexReader *arg1 = (lucene::index::IndexReader *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_IndexReader",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_openFromDirName(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    bool arg2 = (bool) (bool)true ;
    lucene::index::IndexReader *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O|O:IndexReader_openFromDirName",&obj0,&obj1)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    if (obj1) {
        {
            arg2 = PyObject_IsTrue(obj1) ? true : false;
        }
    }
    {
        try {
            {
                lucene::index::IndexReader &_result_ref = lucene::index::IndexReader::open((char const *)arg1,arg2);
                result = (lucene::index::IndexReader *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__index__IndexReader, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_openFromDir(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::Directory *arg1 = 0 ;
    bool arg2 = (bool) (bool)true ;
    lucene::index::IndexReader *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O|O:IndexReader_openFromDir",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__Directory,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg1 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    if (obj1) {
        {
            arg2 = PyObject_IsTrue(obj1) ? true : false;
        }
    }
    {
        try {
            {
                lucene::index::IndexReader &_result_ref = lucene::index::IndexReader::open(*arg1,arg2);
                result = (lucene::index::IndexReader *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__index__IndexReader, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_lastModified__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    long_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexReader_lastModified",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    {
        try {
            result = lucene::index::IndexReader::lastModified((char const *)arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        if (result <= LONG_MAX) {
            resultobj = PyInt_FromLong((long)result);
        } else {
            resultobj = PyLong_FromLongLong(result);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_lastModified__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::Directory *arg1 = 0 ;
    long_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexReader_lastModified",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__Directory,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg1 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    {
        try {
            result = lucene::index::IndexReader::lastModified((lucene::store::Directory const &)*arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        if (result <= LONG_MAX) {
            resultobj = PyInt_FromLong((long)result);
        } else {
            resultobj = PyLong_FromLongLong(result);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_lastModified(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[2];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_lucene__store__Directory, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_IndexReader_lastModified__SWIG_1(self,args);
        }
    }
    if (argc == 1) {
        int _v;
        _v = SWIG_AsCharPtr(argv[0], (char **)(0));
        if (_v) {
            return _wrap_IndexReader_lastModified__SWIG_0(self,args);
        }
    }
    
    PyErr_SetString(PyExc_TypeError,"No matching function for overloaded 'IndexReader_lastModified'");
    return NULL;
}


static PyObject *_wrap_IndexReader_indexExists__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexReader_indexExists",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    {
        try {
            result = (bool)lucene::index::IndexReader::indexExists((char const *)arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_indexExists__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::Directory *arg1 = 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexReader_indexExists",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__Directory,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg1 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    {
        try {
            result = (bool)lucene::index::IndexReader::indexExists((lucene::store::Directory const &)*arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_indexExists(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[2];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_lucene__store__Directory, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_IndexReader_indexExists__SWIG_1(self,args);
        }
    }
    if (argc == 1) {
        int _v;
        _v = SWIG_AsCharPtr(argv[0], (char **)(0));
        if (_v) {
            return _wrap_IndexReader_indexExists__SWIG_0(self,args);
        }
    }
    
    PyErr_SetString(PyExc_TypeError,"No matching function for overloaded 'IndexReader_indexExists'");
    return NULL;
}


static PyObject *_wrap_IndexReader_numDocs(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexReader *arg1 = (lucene::index::IndexReader *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexReader_numDocs",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (int)(arg1)->NumDocs();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_maxDoc(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexReader *arg1 = (lucene::index::IndexReader *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexReader_maxDoc",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (int)((lucene::index::IndexReader const *)arg1)->MaxDoc();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_document(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexReader *arg1 = (lucene::index::IndexReader *) 0 ;
    int arg2 ;
    lucene::document::Document *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:IndexReader_document",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            {
                lucene::document::Document &_result_ref = (arg1)->document(arg2);
                result = (lucene::document::Document *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = supp_convertDocumentToPythonDocument(result);
    }
    {
        delete result;
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_isDeleted(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexReader *arg1 = (lucene::index::IndexReader *) 0 ;
    int arg2 ;
    bool result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:IndexReader_isDeleted",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (bool)(arg1)->isDeleted(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_termsAll(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexReader *arg1 = (lucene::index::IndexReader *) 0 ;
    lucene::index::TermEnum *result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexReader_termsAll",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            {
                lucene::index::TermEnum &_result_ref = ((lucene::index::IndexReader const *)arg1)->getTerms();
                result = (lucene::index::TermEnum *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__index__TermEnum, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_termsSpecific(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexReader *arg1 = (lucene::index::IndexReader *) 0 ;
    lucene::index::Term *arg2 = (lucene::index::Term *) 0 ;
    lucene::index::TermEnum *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:IndexReader_termsSpecific",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        arg2 = supp_convertPythonTupleToTerm(obj1);
        if (arg2 == NULL) SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            {
                lucene::index::TermEnum &_result_ref = ((lucene::index::IndexReader const *)arg1)->getTerms((lucene::index::Term const *)arg2);
                result = (lucene::index::TermEnum *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__index__TermEnum, 1);
    {
        arg2->finalize();
    }
    return resultobj;
    fail:
    {
        arg2->finalize();
    }
    return NULL;
}


static PyObject *_wrap_IndexReader_docFreq(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexReader *arg1 = (lucene::index::IndexReader *) 0 ;
    lucene::index::Term *arg2 = 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:IndexReader_docFreq",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        arg2 = supp_convertPythonTupleToTerm(obj1);
        if (arg2 == NULL) SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (int)((lucene::index::IndexReader const *)arg1)->docFreq((lucene::index::Term const &)*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    {
        arg2->finalize();
    }
    return resultobj;
    fail:
    {
        arg2->finalize();
    }
    return NULL;
}


static PyObject *_wrap_IndexReader_termDocsContaining(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexReader *arg1 = (lucene::index::IndexReader *) 0 ;
    lucene::index::Term *arg2 = (lucene::index::Term *) 0 ;
    lucene::index::TermDocs *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:IndexReader_termDocsContaining",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        arg2 = supp_convertPythonTupleToTerm(obj1);
        if (arg2 == NULL) SWIG_fail;
    }
    {
        try {
            {
                lucene::index::TermDocs &_result_ref = ((lucene::index::IndexReader const *)arg1)->termDocs(arg2);
                result = (lucene::index::TermDocs *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__index__TermDocs, 1);
    {
        arg2->finalize();
    }
    return resultobj;
    fail:
    {
        arg2->finalize();
    }
    return NULL;
}


static PyObject *_wrap_IndexReader_termPositionsContaining(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexReader *arg1 = (lucene::index::IndexReader *) 0 ;
    lucene::index::Term *arg2 = (lucene::index::Term *) 0 ;
    lucene::index::TermPositions *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:IndexReader_termPositionsContaining",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        arg2 = supp_convertPythonTupleToTerm(obj1);
        if (arg2 == NULL) SWIG_fail;
    }
    {
        try {
            {
                lucene::index::TermPositions &_result_ref = (arg1)->termPositions(arg2);
                result = (lucene::index::TermPositions *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__index__TermPositions, 1);
    {
        arg2->finalize();
    }
    return resultobj;
    fail:
    {
        arg2->finalize();
    }
    return NULL;
}


static PyObject *_wrap_IndexReader_termPositionsAll(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexReader *arg1 = (lucene::index::IndexReader *) 0 ;
    lucene::index::TermPositions *result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexReader_termPositionsAll",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            {
                lucene::index::TermPositions &_result_ref = ((lucene::index::IndexReader const *)arg1)->termPositions();
                result = (lucene::index::TermPositions *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__index__TermPositions, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_termDocsAll(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexReader *arg1 = (lucene::index::IndexReader *) 0 ;
    lucene::index::TermDocs *result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexReader_termDocsAll",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            {
                lucene::index::TermDocs &_result_ref = ((lucene::index::IndexReader const *)arg1)->termDocs();
                result = (lucene::index::TermDocs *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__index__TermDocs, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_deleteAt(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexReader *arg1 = (lucene::index::IndexReader *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:IndexReader_deleteAt",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    {
        try {
            (arg1)->Delete(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_deleteWithTerm(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexReader *arg1 = (lucene::index::IndexReader *) 0 ;
    lucene::index::Term *arg2 = (lucene::index::Term *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:IndexReader_deleteWithTerm",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        arg2 = supp_convertPythonTupleToTerm(obj1);
        if (arg2 == NULL) SWIG_fail;
    }
    {
        try {
            result = (int)(arg1)->Delete(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    {
        arg2->finalize();
    }
    return resultobj;
    fail:
    {
        arg2->finalize();
    }
    return NULL;
}


static PyObject *_wrap_IndexReader_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexReader *arg1 = (lucene::index::IndexReader *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexReader_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_isLocked__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::Directory *arg1 = 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexReader_isLocked",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__Directory,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg1 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    {
        try {
            result = (bool)lucene::index::IndexReader::isLocked((lucene::store::Directory const &)*arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_isLocked__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexReader_isLocked",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    {
        try {
            result = (bool)lucene::index::IndexReader::isLocked((char const *)arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexReader_isLocked(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[2];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_lucene__store__Directory, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_IndexReader_isLocked__SWIG_0(self,args);
        }
    }
    if (argc == 1) {
        int _v;
        _v = SWIG_AsCharPtr(argv[0], (char **)(0));
        if (_v) {
            return _wrap_IndexReader_isLocked__SWIG_1(self,args);
        }
    }
    
    PyErr_SetString(PyExc_TypeError,"No matching function for overloaded 'IndexReader_isLocked'");
    return NULL;
}


static PyObject *_wrap_IndexReader_unlock(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::Directory *arg1 = 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexReader_unlock",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__Directory,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg1 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    {
        try {
            lucene::index::IndexReader::unlock(*arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * IndexReader_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__index__IndexReader, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_IndexWriter_addIndexes(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexWriter *arg1 = (lucene::index::IndexWriter *) 0 ;
    PyObject *arg2 = (PyObject *) 0 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:IndexWriter_addIndexes",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexWriter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = obj1;
    {
        try {
            result = (PyObject *)lucene_index_IndexWriter_addIndexes(arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_IndexWriter(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexWriter *arg1 = (lucene::index::IndexWriter *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_IndexWriter",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexWriter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexWriter_maxFieldLength_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexWriter *arg1 = (lucene::index::IndexWriter *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:IndexWriter_maxFieldLength_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexWriter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    if (arg1) (arg1)->maxFieldLength = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexWriter_maxFieldLength_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexWriter *arg1 = (lucene::index::IndexWriter *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexWriter_maxFieldLength_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexWriter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    result = (int) ((arg1)->maxFieldLength);
    
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexWriter_mergeFactor_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexWriter *arg1 = (lucene::index::IndexWriter *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:IndexWriter_mergeFactor_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexWriter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    if (arg1) (arg1)->mergeFactor = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexWriter_mergeFactor_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexWriter *arg1 = (lucene::index::IndexWriter *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexWriter_mergeFactor_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexWriter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    result = (int) ((arg1)->mergeFactor);
    
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexWriter_maxMergeDocs_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexWriter *arg1 = (lucene::index::IndexWriter *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:IndexWriter_maxMergeDocs_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexWriter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    if (arg1) (arg1)->maxMergeDocs = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexWriter_maxMergeDocs_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexWriter *arg1 = (lucene::index::IndexWriter *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexWriter_maxMergeDocs_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexWriter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    result = (int) ((arg1)->maxMergeDocs);
    
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_IndexWriter__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    lucene::analysis::Analyzer *arg2 = 0 ;
    bool arg3 ;
    lucene::index::IndexWriter *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:new_IndexWriter",&obj0,&obj1,&obj2)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__analysis__Analyzer,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    {
        arg3 = PyObject_IsTrue(obj2) ? true : false;
    }
    {
        try {
            result = (lucene::index::IndexWriter *)new lucene::index::IndexWriter((char const *)arg1,*arg2,arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__index__IndexWriter, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_IndexWriter__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::store::Directory *arg1 = 0 ;
    lucene::analysis::Analyzer *arg2 = 0 ;
    bool arg3 ;
    lucene::index::IndexWriter *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:new_IndexWriter",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__store__Directory,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg1 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__analysis__Analyzer,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    {
        arg3 = PyObject_IsTrue(obj2) ? true : false;
    }
    {
        try {
            result = (lucene::index::IndexWriter *)new lucene::index::IndexWriter(*arg1,*arg2,arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__index__IndexWriter, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_IndexWriter(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[4];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_lucene__store__Directory, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_lucene__analysis__Analyzer, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = PyBool_Check(argv[2]) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_IndexWriter__SWIG_1(self,args);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        _v = SWIG_AsCharPtr(argv[0], (char **)(0));
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_lucene__analysis__Analyzer, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = PyBool_Check(argv[2]) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_IndexWriter__SWIG_0(self,args);
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_TypeError,"No matching function for overloaded 'new_IndexWriter'");
    return NULL;
}


static PyObject *_wrap_IndexWriter_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexWriter *arg1 = (lucene::index::IndexWriter *) 0 ;
    bool arg2 = (bool) (bool)true ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O|O:IndexWriter_close",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexWriter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (obj1) {
        {
            arg2 = PyObject_IsTrue(obj1) ? true : false;
        }
    }
    {
        try {
            (arg1)->close(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexWriter_docCount(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexWriter *arg1 = (lucene::index::IndexWriter *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexWriter_docCount",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexWriter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (int)(arg1)->docCount();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexWriter_addDocument(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexWriter *arg1 = (lucene::index::IndexWriter *) 0 ;
    lucene::document::Document *arg2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:IndexWriter_addDocument",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexWriter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            arg2 = supp_convertPythonDocumentToDocument(obj1);
            if (arg2 == NULL) SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        try {
            (arg1)->addDocument(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    {
        delete arg2;
    }
    return resultobj;
    fail:
    {
        delete arg2;
    }
    return NULL;
}


static PyObject *_wrap_IndexWriter_optimize(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexWriter *arg1 = (lucene::index::IndexWriter *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexWriter_optimize",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexWriter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            (arg1)->optimize();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * IndexWriter_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__index__IndexWriter, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_HitCollector_collect(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::HitCollector *arg1 = (lucene::search::HitCollector *) 0 ;
    int arg2 ;
    float arg3 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:HitCollector_collect",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__HitCollector,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    arg3 = (float)SWIG_As_float(obj2); 
    if (PyErr_Occurred()) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->collect(arg2,arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_HitCollector(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::HitCollector *arg1 = (lucene::search::HitCollector *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_HitCollector",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__HitCollector,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_HitCollector(PyObject *, PyObject *args) {
    PyObject *resultobj;
    PyObject *arg1 = (PyObject *) 0 ;
    lucene::search::HitCollector *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_HitCollector",&obj0)) goto fail;
    arg1 = obj0;
    {
        try {
            result = (lucene::search::HitCollector *)new SwigDirector_HitCollector(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__HitCollector, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_disown_HitCollector(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::HitCollector *arg1 = (lucene::search::HitCollector *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:disown_HitCollector",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__HitCollector,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        Swig::Director *director = dynamic_cast<Swig::Director *>(arg1);
        if (director) director->swig_disown();
    }
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * HitCollector_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__HitCollector, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_Hits(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Searcher *arg1 = 0 ;
    lucene::search::Query *arg2 = 0 ;
    lucene::search::Filter *arg3 = (lucene::search::Filter *) 0 ;
    lucene::search::Hits *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:new_Hits",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Searcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg1 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__search__Query,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    if ((SWIG_ConvertPtr(obj2,(void **)(&arg3),SWIGTYPE_p_lucene__search__Filter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (lucene::search::Hits *)new lucene::search::Hits(*arg1,*arg2,(lucene::search::Filter const *)arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__Hits, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_Hits(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Hits *arg1 = (lucene::search::Hits *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_Hits",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Hits,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Hits_Length(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Hits *arg1 = (lucene::search::Hits *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:Hits_Length",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Hits,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (int)((lucene::search::Hits const *)arg1)->Length();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Hits_doc(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Hits *arg1 = (lucene::search::Hits *) 0 ;
    int arg2 ;
    lucene::document::Document *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Hits_doc",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Hits,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    {
        try {
            {
                lucene::document::Document &_result_ref = (arg1)->doc(arg2);
                result = (lucene::document::Document *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = supp_convertDocumentToPythonDocument(result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Hits_id(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Hits *arg1 = (lucene::search::Hits *) 0 ;
    int arg2 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Hits_id",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Hits,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    {
        try {
            result = (int)(arg1)->id(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Hits_score(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Hits *arg1 = (lucene::search::Hits *) 0 ;
    int arg2 ;
    float result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Hits_score",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Hits,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    {
        try {
            result = (float)(arg1)->score(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_float((float)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject * Hits_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__Hits, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_Searcher_search(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Searcher *arg1 = (lucene::search::Searcher *) 0 ;
    lucene::search::Query *arg2 = 0 ;
    PyObject *arg3 = (PyObject *) 0 ;
    PyObject *arg4 = (PyObject *) 0 ;
    PyObject *arg5 = (PyObject *) 0 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:Searcher_search",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Searcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__search__Query,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    arg3 = obj2;
    arg4 = obj3;
    arg5 = obj4;
    {
        try {
            result = (PyObject *)lucene_search_Searcher_search(arg1,*arg2,arg3,arg4,arg5);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_Searcher(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Searcher *arg1 = (lucene::search::Searcher *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_Searcher",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Searcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Searcher_docFreq(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Searcher *arg1 = (lucene::search::Searcher *) 0 ;
    lucene::index::Term *arg2 = 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Searcher_docFreq",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Searcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        arg2 = supp_convertPythonTupleToTerm(obj1);
        if (arg2 == NULL) SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (int)((lucene::search::Searcher const *)arg1)->docFreq((lucene::index::Term const &)*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    {
        arg2->finalize();
    }
    return resultobj;
    fail:
    {
        arg2->finalize();
    }
    return NULL;
}


static PyObject *_wrap_Searcher_maxDoc(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Searcher *arg1 = (lucene::search::Searcher *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:Searcher_maxDoc",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Searcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (int)((lucene::search::Searcher const *)arg1)->maxDoc();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Searcher_doc(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Searcher *arg1 = (lucene::search::Searcher *) 0 ;
    int arg2 ;
    lucene::document::Document *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Searcher_doc",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Searcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            {
                lucene::document::Document &_result_ref = (arg1)->doc(arg2);
                result = (lucene::document::Document *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = supp_convertDocumentToPythonDocument(result);
    }
    {
        delete result;
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Searcher_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Searcher *arg1 = (lucene::search::Searcher *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:Searcher_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Searcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * Searcher_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__Searcher, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_Query_name_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Query *arg1 = (lucene::search::Query *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Query_name_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Query,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    {
        try {
            lucene_search_Query_name_set(arg1,(char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Query_name_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Query *arg1 = (lucene::search::Query *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:Query_name_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Query,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (char *)lucene_search_Query_name_get(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_Query(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Query *arg1 = (lucene::search::Query *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_Query",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Query,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Query_boost_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Query *arg1 = (lucene::search::Query *) 0 ;
    float arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Query_boost_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Query,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (float)SWIG_As_float(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    if (arg1) (arg1)->boost = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Query_boost_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Query *arg1 = (lucene::search::Query *) 0 ;
    float result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:Query_boost_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Query,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    result = (float) ((arg1)->boost);
    
    resultobj = SWIG_From_float((float)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Query_sumOfSquaredWeights(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Query *arg1 = (lucene::search::Query *) 0 ;
    lucene::search::Searcher *arg2 = 0 ;
    float result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Query_sumOfSquaredWeights",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Query,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__search__Searcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (float)(arg1)->sumOfSquaredWeights(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_float((float)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Query_normalize(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Query *arg1 = (lucene::search::Query *) 0 ;
    float arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Query_normalize",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Query,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (float)SWIG_As_float(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->normalize(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Query_prepare(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Query *arg1 = (lucene::search::Query *) 0 ;
    lucene::index::IndexReader *arg2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Query_prepare",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Query,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->prepare(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Query_toString(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Query *arg1 = (lucene::search::Query *) 0 ;
    char *arg2 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Query_toString",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Query,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (char *)(arg1)->toString((char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_FromCharPtr(result);
    delete [] result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * Query_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__Query, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_MultiSearcher(PyObject *, PyObject *args) {
    PyObject *resultobj;
    PyObject *arg1 = (PyObject *) 0 ;
    lucene::search::MultiSearcher *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_MultiSearcher",&obj0)) goto fail;
    arg1 = obj0;
    {
        try {
            result = (lucene::search::MultiSearcher *)new_MultiSearcher(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__MultiSearcher, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_MultiSearcher(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::MultiSearcher *arg1 = (lucene::search::MultiSearcher *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_MultiSearcher",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__MultiSearcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_MultiSearcher_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::MultiSearcher *arg1 = (lucene::search::MultiSearcher *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:MultiSearcher_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__MultiSearcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_MultiSearcher_docFreq(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::MultiSearcher *arg1 = (lucene::search::MultiSearcher *) 0 ;
    lucene::index::Term *arg2 = 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:MultiSearcher_docFreq",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__MultiSearcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        arg2 = supp_convertPythonTupleToTerm(obj1);
        if (arg2 == NULL) SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (int)((lucene::search::MultiSearcher const *)arg1)->docFreq((lucene::index::Term const &)*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    {
        arg2->finalize();
    }
    return resultobj;
    fail:
    {
        arg2->finalize();
    }
    return NULL;
}


static PyObject *_wrap_MultiSearcher_doc(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::MultiSearcher *arg1 = (lucene::search::MultiSearcher *) 0 ;
    int arg2 ;
    lucene::document::Document *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:MultiSearcher_doc",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__MultiSearcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            {
                lucene::document::Document &_result_ref = (arg1)->doc(arg2);
                result = (lucene::document::Document *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = supp_convertDocumentToPythonDocument(result);
    }
    {
        delete result;
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_MultiSearcher_subSearcher(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::MultiSearcher *arg1 = (lucene::search::MultiSearcher *) 0 ;
    int arg2 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:MultiSearcher_subSearcher",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__MultiSearcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    {
        try {
            result = (int)(arg1)->searcherIndex(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_MultiSearcher_maxDoc(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::MultiSearcher *arg1 = (lucene::search::MultiSearcher *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:MultiSearcher_maxDoc",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__MultiSearcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (int)((lucene::search::MultiSearcher const *)arg1)->maxDoc();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject * MultiSearcher_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__MultiSearcher, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_TermQuery_term_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::TermQuery *arg1 = (lucene::search::TermQuery *) 0 ;
    lucene::index::Term *arg2 = (lucene::index::Term *) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:TermQuery_term_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__TermQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        arg2 = supp_convertPythonTupleToTerm(obj1);
        if (arg2 == NULL) SWIG_fail;
    }
    {
        try {
            lucene_search_TermQuery_term_set(arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    {
        arg2->finalize();
    }
    return resultobj;
    fail:
    {
        arg2->finalize();
    }
    return NULL;
}


static PyObject *_wrap_TermQuery_term_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::TermQuery *arg1 = (lucene::search::TermQuery *) 0 ;
    lucene::index::Term *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TermQuery_term_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__TermQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (lucene::index::Term *)lucene_search_TermQuery_term_get(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = supp_convertTermToPythonTuple(result);
        /* Release our IGCollectable reference to result: */
        result->finalize();
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_TermQuery(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::Term *arg1 = 0 ;
    lucene::search::TermQuery *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_TermQuery",&obj0)) goto fail;
    {
        arg1 = supp_convertPythonTupleToTerm(obj0);
        if (arg1 == NULL) SWIG_fail;
    }
    {
        try {
            result = (lucene::search::TermQuery *)new lucene::search::TermQuery(*arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__TermQuery, 1);
    {
        arg1->finalize();
    }
    return resultobj;
    fail:
    {
        arg1->finalize();
    }
    return NULL;
}


static PyObject *_wrap_delete_TermQuery(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::TermQuery *arg1 = (lucene::search::TermQuery *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_TermQuery",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__TermQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TermQuery_sumOfSquaredWeights(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::TermQuery *arg1 = (lucene::search::TermQuery *) 0 ;
    lucene::search::Searcher *arg2 = 0 ;
    float result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:TermQuery_sumOfSquaredWeights",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__TermQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__search__Searcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (float)(arg1)->sumOfSquaredWeights(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_float((float)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TermQuery_normalize(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::TermQuery *arg1 = (lucene::search::TermQuery *) 0 ;
    float arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:TermQuery_normalize",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__TermQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (float)SWIG_As_float(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->normalize(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TermQuery_toString(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::TermQuery *arg1 = (lucene::search::TermQuery *) 0 ;
    char *arg2 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:TermQuery_toString",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__TermQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (char *)(arg1)->toString((char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_FromCharPtr(result);
    delete [] result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TermQuery_prepare(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::TermQuery *arg1 = (lucene::search::TermQuery *) 0 ;
    lucene::index::IndexReader *arg2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:TermQuery_prepare",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__TermQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->prepare(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * TermQuery_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__TermQuery, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_delete_MultiTermQuery(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::MultiTermQuery *arg1 = (lucene::search::MultiTermQuery *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_MultiTermQuery",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__MultiTermQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_MultiTermQuery_sumOfSquaredWeights(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::MultiTermQuery *arg1 = (lucene::search::MultiTermQuery *) 0 ;
    lucene::search::Searcher *arg2 = 0 ;
    float result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:MultiTermQuery_sumOfSquaredWeights",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__MultiTermQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__search__Searcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (float)(arg1)->sumOfSquaredWeights(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_float((float)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_MultiTermQuery_normalize(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::MultiTermQuery *arg1 = (lucene::search::MultiTermQuery *) 0 ;
    float arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:MultiTermQuery_normalize",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__MultiTermQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (float)SWIG_As_float(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->normalize(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_MultiTermQuery_toString(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::MultiTermQuery *arg1 = (lucene::search::MultiTermQuery *) 0 ;
    char *arg2 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:MultiTermQuery_toString",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__MultiTermQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (char *)(arg1)->toString((char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_FromCharPtr(result);
    delete [] result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * MultiTermQuery_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__MultiTermQuery, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_PhraseQuery_terms_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::PhraseQuery *arg1 = (lucene::search::PhraseQuery *) 0 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:PhraseQuery_terms_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__PhraseQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (PyObject *)lucene_search_PhraseQuery_terms_get(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_PhraseQuery_terms_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::PhraseQuery *arg1 = (lucene::search::PhraseQuery *) 0 ;
    PyObject *arg2 = (PyObject *) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:PhraseQuery_terms_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__PhraseQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = obj1;
    {
        try {
            lucene_search_PhraseQuery_terms_set(arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_PhraseQuery_slop_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::PhraseQuery *arg1 = (lucene::search::PhraseQuery *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:PhraseQuery_slop_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__PhraseQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    {
        try {
            lucene_search_PhraseQuery_slop_set(arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_PhraseQuery_slop_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::PhraseQuery *arg1 = (lucene::search::PhraseQuery *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:PhraseQuery_slop_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__PhraseQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (int)lucene_search_PhraseQuery_slop_get(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_PhraseQuery(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::PhraseQuery *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_PhraseQuery")) goto fail;
    {
        try {
            result = (lucene::search::PhraseQuery *)new lucene::search::PhraseQuery();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__PhraseQuery, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_PhraseQuery(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::PhraseQuery *arg1 = (lucene::search::PhraseQuery *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_PhraseQuery",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__PhraseQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_PhraseQuery_add(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::PhraseQuery *arg1 = (lucene::search::PhraseQuery *) 0 ;
    lucene::index::Term *arg2 = (lucene::index::Term *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:PhraseQuery_add",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__PhraseQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        arg2 = supp_convertPythonTupleToTerm(obj1);
        if (arg2 == NULL) SWIG_fail;
    }
    {
        try {
            result = (bool)(arg1)->add(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = PyBool_FromLong((long)result);
    }
    {
        arg2->finalize();
    }
    return resultobj;
    fail:
    {
        arg2->finalize();
    }
    return NULL;
}


static PyObject *_wrap_PhraseQuery_sumOfSquaredWeights(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::PhraseQuery *arg1 = (lucene::search::PhraseQuery *) 0 ;
    lucene::search::Searcher *arg2 = 0 ;
    float result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:PhraseQuery_sumOfSquaredWeights",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__PhraseQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__search__Searcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (float)(arg1)->sumOfSquaredWeights(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_float((float)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_PhraseQuery_normalize(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::PhraseQuery *arg1 = (lucene::search::PhraseQuery *) 0 ;
    float arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:PhraseQuery_normalize",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__PhraseQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (float)SWIG_As_float(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->normalize(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_PhraseQuery_toString(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::PhraseQuery *arg1 = (lucene::search::PhraseQuery *) 0 ;
    char *arg2 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:PhraseQuery_toString",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__PhraseQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (char *)(arg1)->toString((char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_FromCharPtr(result);
    delete [] result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_PhraseQuery_prepare(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::PhraseQuery *arg1 = (lucene::search::PhraseQuery *) 0 ;
    lucene::index::IndexReader *arg2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:PhraseQuery_prepare",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__PhraseQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->prepare(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * PhraseQuery_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__PhraseQuery, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_BooleanClause__deleteQuery_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanClause *arg1 = (lucene::search::BooleanClause *) 0 ;
    bool arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:BooleanClause__deleteQuery_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__BooleanClause,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        arg2 = PyObject_IsTrue(obj1) ? true : false;
    }
    if (arg1) (arg1)->deleteQuery = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_BooleanClause__deleteQuery_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanClause *arg1 = (lucene::search::BooleanClause *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:BooleanClause__deleteQuery_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__BooleanClause,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    result = (bool) ((arg1)->deleteQuery);
    
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_BooleanClause_query_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanClause *arg1 = (lucene::search::BooleanClause *) 0 ;
    lucene::search::Query *arg2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:BooleanClause_query_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__BooleanClause,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__search__Query,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    if (arg1) (arg1)->query = *arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_BooleanClause_query_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanClause *arg1 = (lucene::search::BooleanClause *) 0 ;
    lucene::search::Query *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:BooleanClause_query_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__BooleanClause,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        lucene::search::Query &_result_ref = (lucene::search::Query &) ((arg1)->query);
        result = (lucene::search::Query *) &_result_ref;
    }
    
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__Query, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_BooleanClause_required_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanClause *arg1 = (lucene::search::BooleanClause *) 0 ;
    bool arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:BooleanClause_required_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__BooleanClause,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        arg2 = PyObject_IsTrue(obj1) ? true : false;
    }
    if (arg1) (arg1)->required = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_BooleanClause_required_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanClause *arg1 = (lucene::search::BooleanClause *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:BooleanClause_required_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__BooleanClause,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    result = (bool) ((arg1)->required);
    
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_BooleanClause_prohibited_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanClause *arg1 = (lucene::search::BooleanClause *) 0 ;
    bool arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:BooleanClause_prohibited_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__BooleanClause,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        arg2 = PyObject_IsTrue(obj1) ? true : false;
    }
    if (arg1) (arg1)->prohibited = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_BooleanClause_prohibited_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanClause *arg1 = (lucene::search::BooleanClause *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:BooleanClause_prohibited_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__BooleanClause,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    result = (bool) ((arg1)->prohibited);
    
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_BooleanClause(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Query *arg1 = 0 ;
    bool arg2 ;
    bool arg3 ;
    bool arg4 ;
    lucene::search::BooleanClause *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:new_BooleanClause",&obj0,&obj1,&obj2,&obj3)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Query,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg1 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    {
        arg2 = PyObject_IsTrue(obj1) ? true : false;
    }
    {
        arg3 = PyObject_IsTrue(obj2) ? true : false;
    }
    {
        arg4 = PyObject_IsTrue(obj3) ? true : false;
    }
    {
        try {
            result = (lucene::search::BooleanClause *)new lucene::search::BooleanClause(*arg1,arg2,arg3,arg4);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__BooleanClause, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_BooleanClause(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanClause *arg1 = (lucene::search::BooleanClause *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_BooleanClause",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__BooleanClause,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * BooleanClause_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__BooleanClause, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_BooleanQuery_clauses_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanQuery *arg1 = (lucene::search::BooleanQuery *) 0 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:BooleanQuery_clauses_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__BooleanQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (PyObject *)lucene_search_BooleanQuery_clauses_get(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_BooleanQuery_clauses_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanQuery *arg1 = (lucene::search::BooleanQuery *) 0 ;
    PyObject *arg2 = (PyObject *) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:BooleanQuery_clauses_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__BooleanQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = obj1;
    {
        try {
            lucene_search_BooleanQuery_clauses_set(arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_BooleanQuery(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanQuery *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_BooleanQuery")) goto fail;
    {
        try {
            result = (lucene::search::BooleanQuery *)new lucene::search::BooleanQuery();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__BooleanQuery, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_BooleanQuery(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanQuery *arg1 = (lucene::search::BooleanQuery *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_BooleanQuery",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__BooleanQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_BooleanQuery_add(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanQuery *arg1 = (lucene::search::BooleanQuery *) 0 ;
    lucene::search::BooleanClause *arg2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:BooleanQuery_add",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__BooleanQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__search__BooleanClause,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    {
        try {
            (arg1)->add(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_BooleanQuery_prepare(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanQuery *arg1 = (lucene::search::BooleanQuery *) 0 ;
    lucene::index::IndexReader *arg2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:BooleanQuery_prepare",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__BooleanQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->prepare(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_BooleanQuery_sumOfSquaredWeights(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanQuery *arg1 = (lucene::search::BooleanQuery *) 0 ;
    lucene::search::Searcher *arg2 = 0 ;
    float result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:BooleanQuery_sumOfSquaredWeights",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__BooleanQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__search__Searcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (float)(arg1)->sumOfSquaredWeights(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_float((float)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_BooleanQuery_normalize(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanQuery *arg1 = (lucene::search::BooleanQuery *) 0 ;
    float arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:BooleanQuery_normalize",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__BooleanQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (float)SWIG_As_float(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->normalize(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_BooleanQuery_toString(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::BooleanQuery *arg1 = (lucene::search::BooleanQuery *) 0 ;
    char *arg2 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:BooleanQuery_toString",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__BooleanQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (char *)(arg1)->toString((char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_FromCharPtr(result);
    delete [] result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * BooleanQuery_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__BooleanQuery, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_WildcardQuery(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::Term *arg1 = (lucene::index::Term *) 0 ;
    lucene::search::WildcardQuery *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_WildcardQuery",&obj0)) goto fail;
    {
        arg1 = supp_convertPythonTupleToTerm(obj0);
        if (arg1 == NULL) SWIG_fail;
    }
    {
        try {
            result = (lucene::search::WildcardQuery *)new lucene::search::WildcardQuery(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__WildcardQuery, 1);
    {
        arg1->finalize();
    }
    return resultobj;
    fail:
    {
        arg1->finalize();
    }
    return NULL;
}


static PyObject *_wrap_delete_WildcardQuery(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::WildcardQuery *arg1 = (lucene::search::WildcardQuery *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_WildcardQuery",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__WildcardQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_WildcardQuery_prepare(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::WildcardQuery *arg1 = (lucene::search::WildcardQuery *) 0 ;
    lucene::index::IndexReader *arg2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:WildcardQuery_prepare",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__WildcardQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->prepare(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_WildcardQuery_toString(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::WildcardQuery *arg1 = (lucene::search::WildcardQuery *) 0 ;
    char *arg2 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:WildcardQuery_toString",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__WildcardQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (char *)(arg1)->toString((char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_FromCharPtr(result);
    delete [] result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * WildcardQuery_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__WildcardQuery, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_PrefixQuery(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::Term *arg1 = (lucene::index::Term *) 0 ;
    lucene::search::PrefixQuery *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_PrefixQuery",&obj0)) goto fail;
    {
        arg1 = supp_convertPythonTupleToTerm(obj0);
        if (arg1 == NULL) SWIG_fail;
    }
    {
        try {
            result = (lucene::search::PrefixQuery *)new lucene::search::PrefixQuery(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__PrefixQuery, 1);
    {
        arg1->finalize();
    }
    return resultobj;
    fail:
    {
        arg1->finalize();
    }
    return NULL;
}


static PyObject *_wrap_delete_PrefixQuery(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::PrefixQuery *arg1 = (lucene::search::PrefixQuery *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_PrefixQuery",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__PrefixQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_PrefixQuery_prepare(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::PrefixQuery *arg1 = (lucene::search::PrefixQuery *) 0 ;
    lucene::index::IndexReader *arg2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:PrefixQuery_prepare",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__PrefixQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->prepare(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_PrefixQuery_sumOfSquaredWeights(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::PrefixQuery *arg1 = (lucene::search::PrefixQuery *) 0 ;
    lucene::search::Searcher *arg2 = 0 ;
    float result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:PrefixQuery_sumOfSquaredWeights",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__PrefixQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__search__Searcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (float)(arg1)->sumOfSquaredWeights(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_float((float)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_PrefixQuery_normalize(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::PrefixQuery *arg1 = (lucene::search::PrefixQuery *) 0 ;
    float arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:PrefixQuery_normalize",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__PrefixQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (float)SWIG_As_float(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->normalize(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_PrefixQuery_toString(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::PrefixQuery *arg1 = (lucene::search::PrefixQuery *) 0 ;
    char *arg2 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:PrefixQuery_toString",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__PrefixQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (char *)(arg1)->toString((char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_FromCharPtr(result);
    delete [] result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * PrefixQuery_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__PrefixQuery, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_delete_FilteredTermEnum(PyObject *, PyObject *args) {
    PyObject *resultobj;
    FilteredTermEnum *arg1 = (FilteredTermEnum *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_FilteredTermEnum",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_FilteredTermEnum,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * FilteredTermEnum_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_FilteredTermEnum, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_delete_FuzzyTermEnum(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::FuzzyTermEnum *arg1 = (lucene::search::FuzzyTermEnum *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_FuzzyTermEnum",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__FuzzyTermEnum,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FuzzyTermEnum_EndEnum(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::FuzzyTermEnum *arg1 = (lucene::search::FuzzyTermEnum *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:FuzzyTermEnum_EndEnum",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__FuzzyTermEnum,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (bool)(arg1)->EndEnum();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = PyBool_FromLong((long)result);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FuzzyTermEnum_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::FuzzyTermEnum *arg1 = (lucene::search::FuzzyTermEnum *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:FuzzyTermEnum_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__FuzzyTermEnum,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FuzzyTermEnum_setFuzzyThreshold(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::FuzzyTermEnum *arg1 = (lucene::search::FuzzyTermEnum *) 0 ;
    float arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:FuzzyTermEnum_setFuzzyThreshold",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__FuzzyTermEnum,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (float)SWIG_As_float(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    {
        try {
            (arg1)->setFuzzyThreshold(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * FuzzyTermEnum_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__FuzzyTermEnum, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_FuzzyQuery(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::Term *arg1 = (lucene::index::Term *) 0 ;
    lucene::search::FuzzyQuery *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_FuzzyQuery",&obj0)) goto fail;
    {
        arg1 = supp_convertPythonTupleToTerm(obj0);
        if (arg1 == NULL) SWIG_fail;
    }
    {
        try {
            result = (lucene::search::FuzzyQuery *)new lucene::search::FuzzyQuery(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__FuzzyQuery, 1);
    {
        arg1->finalize();
    }
    return resultobj;
    fail:
    {
        arg1->finalize();
    }
    return NULL;
}


static PyObject *_wrap_delete_FuzzyQuery(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::FuzzyQuery *arg1 = (lucene::search::FuzzyQuery *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_FuzzyQuery",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__FuzzyQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FuzzyQuery_prepare(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::FuzzyQuery *arg1 = (lucene::search::FuzzyQuery *) 0 ;
    lucene::index::IndexReader *arg2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:FuzzyQuery_prepare",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__FuzzyQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->prepare(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_FuzzyQuery_toString(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::FuzzyQuery *arg1 = (lucene::search::FuzzyQuery *) 0 ;
    char *arg2 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:FuzzyQuery_toString",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__FuzzyQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (char *)(arg1)->toString((char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_FromCharPtr(result);
    delete [] result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * FuzzyQuery_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__FuzzyQuery, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_RangeQuery(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::Term *arg1 = (lucene::index::Term *) 0 ;
    lucene::index::Term *arg2 = (lucene::index::Term *) 0 ;
    bool arg3 ;
    lucene::search::RangeQuery *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:new_RangeQuery",&obj0,&obj1,&obj2)) goto fail;
    {
        arg1 = supp_convertPythonTupleToTerm(obj0);
        if (arg1 == NULL) SWIG_fail;
    }
    {
        arg2 = supp_convertPythonTupleToTerm(obj1);
        if (arg2 == NULL) SWIG_fail;
    }
    {
        arg3 = PyObject_IsTrue(obj2) ? true : false;
    }
    {
        try {
            result = (lucene::search::RangeQuery *)new lucene::search::RangeQuery(arg1,arg2,arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__RangeQuery, 1);
    {
        arg1->finalize();
    }
    {
        arg2->finalize();
    }
    return resultobj;
    fail:
    {
        arg1->finalize();
    }
    {
        arg2->finalize();
    }
    return NULL;
}


static PyObject *_wrap_delete_RangeQuery(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::RangeQuery *arg1 = (lucene::search::RangeQuery *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_RangeQuery",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__RangeQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_RangeQuery_prepare(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::RangeQuery *arg1 = (lucene::search::RangeQuery *) 0 ;
    lucene::index::IndexReader *arg2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:RangeQuery_prepare",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__RangeQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->prepare(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_RangeQuery_sumOfSquaredWeights(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::RangeQuery *arg1 = (lucene::search::RangeQuery *) 0 ;
    lucene::search::Searcher *arg2 = 0 ;
    float result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:RangeQuery_sumOfSquaredWeights",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__RangeQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__search__Searcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (float)(arg1)->sumOfSquaredWeights(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_float((float)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_RangeQuery_normalize(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::RangeQuery *arg1 = (lucene::search::RangeQuery *) 0 ;
    float arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:RangeQuery_normalize",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__RangeQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (float)SWIG_As_float(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->normalize(arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_RangeQuery_toString(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::RangeQuery *arg1 = (lucene::search::RangeQuery *) 0 ;
    char *arg2 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:RangeQuery_toString",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__RangeQuery,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (char *)(arg1)->toString((char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_FromCharPtr(result);
    delete [] result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * RangeQuery_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__RangeQuery, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_delete_Filter(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Filter *arg1 = (lucene::search::Filter *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_Filter",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Filter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Filter_bits(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Filter *arg1 = (lucene::search::Filter *) 0 ;
    lucene::index::IndexReader *arg2 = 0 ;
    lucene::util::BitSet *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Filter_bits",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Filter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (lucene::util::BitSet *)((lucene::search::Filter const *)arg1)->bits(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = supp_convertBitSetToPythonList(result, result->getSize());
        delete result;
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_Filter(PyObject *, PyObject *args) {
    PyObject *resultobj;
    PyObject *arg1 = (PyObject *) 0 ;
    lucene::search::Filter *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_Filter",&obj0)) goto fail;
    arg1 = obj0;
    {
        try {
            result = (lucene::search::Filter *)new SwigDirector_Filter(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__Filter, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_disown_Filter(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::Filter *arg1 = (lucene::search::Filter *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:disown_Filter",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__Filter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        Swig::Director *director = dynamic_cast<Swig::Director *>(arg1);
        if (director) director->swig_disown();
    }
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * Filter_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__Filter, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_delete_DateFilter(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::DateFilter *arg1 = (lucene::search::DateFilter *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_DateFilter",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__DateFilter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_DateFilter(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    long_t arg2 ;
    long_t arg3 ;
    lucene::search::DateFilter *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:new_DateFilter",&obj0,&obj1,&obj2)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    {
        if (PyInt_Check(obj1)) {
            arg2 = (long_t) PyInt_AS_LONG(obj1);
        } else if (PyLong_Check(obj1)) {
            arg2 = PyLong_AsLongLong(obj1);
            if (PyErr_Occurred()) {
                /* E.g., an OverflowError in the conversion above. */
                SWIG_fail;
            }
        } else {
            PyErr_SetString(PyExc_TypeError, "int or long required");
            SWIG_fail;
        }
    }
    {
        if (PyInt_Check(obj2)) {
            arg3 = (long_t) PyInt_AS_LONG(obj2);
        } else if (PyLong_Check(obj2)) {
            arg3 = PyLong_AsLongLong(obj2);
            if (PyErr_Occurred()) {
                /* E.g., an OverflowError in the conversion above. */
                SWIG_fail;
            }
        } else {
            PyErr_SetString(PyExc_TypeError, "int or long required");
            SWIG_fail;
        }
    }
    {
        try {
            result = (lucene::search::DateFilter *)new lucene::search::DateFilter((char const *)arg1,arg2,arg3);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__DateFilter, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_DateFilter_Before(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    long_t arg2 ;
    lucene::search::DateFilter *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:DateFilter_Before",&obj0,&obj1)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    {
        if (PyInt_Check(obj1)) {
            arg2 = (long_t) PyInt_AS_LONG(obj1);
        } else if (PyLong_Check(obj1)) {
            arg2 = PyLong_AsLongLong(obj1);
            if (PyErr_Occurred()) {
                /* E.g., an OverflowError in the conversion above. */
                SWIG_fail;
            }
        } else {
            PyErr_SetString(PyExc_TypeError, "int or long required");
            SWIG_fail;
        }
    }
    {
        try {
            result = (lucene::search::DateFilter *)lucene::search::DateFilter::Before((char const *)arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__DateFilter, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_DateFilter_After(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    long_t arg2 ;
    lucene::search::DateFilter *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:DateFilter_After",&obj0,&obj1)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    {
        if (PyInt_Check(obj1)) {
            arg2 = (long_t) PyInt_AS_LONG(obj1);
        } else if (PyLong_Check(obj1)) {
            arg2 = PyLong_AsLongLong(obj1);
            if (PyErr_Occurred()) {
                /* E.g., an OverflowError in the conversion above. */
                SWIG_fail;
            }
        } else {
            PyErr_SetString(PyExc_TypeError, "int or long required");
            SWIG_fail;
        }
    }
    {
        try {
            result = (lucene::search::DateFilter *)lucene::search::DateFilter::After((char const *)arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__DateFilter, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_DateFilter_bits(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::DateFilter *arg1 = (lucene::search::DateFilter *) 0 ;
    lucene::index::IndexReader *arg2 = 0 ;
    BitSet *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:DateFilter_bits",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__DateFilter,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    {
        try {
            result = (BitSet *)((lucene::search::DateFilter const *)arg1)->bits(*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_BitSet, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject * DateFilter_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__DateFilter, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_TopDocs___iter__(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::TopDocs *arg1 = (lucene::search::TopDocs *) 0 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TopDocs___iter__",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__TopDocs,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (PyObject *)lucene_search_TopDocs___iter__(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TopDocs_totalHits_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::TopDocs *arg1 = (lucene::search::TopDocs *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TopDocs_totalHits_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__TopDocs,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    result = (int)(int) ((arg1)->totalHits);
    
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TopDocs_scoreDocs_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::TopDocs *arg1 = (lucene::search::TopDocs *) 0 ;
    lucene::search::ScoreDoc **result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TopDocs_scoreDocs_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__TopDocs,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    result = (lucene::search::ScoreDoc **) ((arg1)->scoreDocs);
    
    {
        lucene::search::TopDocs *self = arg1;
        resultobj = supp_convertScoreDocsArrayToTupleOfScoreDocsObjects(
        self->scoreDocs, self->scoreDocsLength
        );
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_TopDocs(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::TopDocs *arg1 = (lucene::search::TopDocs *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_TopDocs",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__TopDocs,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * TopDocs_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__TopDocs, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_ScoreDoc___repr__(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::ScoreDoc *arg1 = (lucene::search::ScoreDoc *) 0 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:ScoreDoc___repr__",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__ScoreDoc,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (PyObject *)lucene_search_ScoreDoc___repr__(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_ScoreDoc_score_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::ScoreDoc *arg1 = (lucene::search::ScoreDoc *) 0 ;
    float arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:ScoreDoc_score_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__ScoreDoc,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (float)SWIG_As_float(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    if (arg1) (arg1)->score = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_ScoreDoc_score_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::ScoreDoc *arg1 = (lucene::search::ScoreDoc *) 0 ;
    float result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:ScoreDoc_score_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__ScoreDoc,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    result = (float) ((arg1)->score);
    
    resultobj = SWIG_From_float((float)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_ScoreDoc_doc_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::ScoreDoc *arg1 = (lucene::search::ScoreDoc *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:ScoreDoc_doc_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__ScoreDoc,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    if (arg1) (arg1)->doc = arg2;
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_ScoreDoc_doc_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::ScoreDoc *arg1 = (lucene::search::ScoreDoc *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:ScoreDoc_doc_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__ScoreDoc,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    result = (int) ((arg1)->doc);
    
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_ScoreDoc(PyObject *, PyObject *args) {
    PyObject *resultobj;
    int arg1 ;
    float arg2 ;
    lucene::search::ScoreDoc *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:new_ScoreDoc",&obj0,&obj1)) goto fail;
    arg1 = (int)SWIG_As_int(obj0); 
    if (PyErr_Occurred()) SWIG_fail;
    arg2 = (float)SWIG_As_float(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    {
        try {
            result = (lucene::search::ScoreDoc *)new lucene::search::ScoreDoc(arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__ScoreDoc, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_ScoreDoc(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::ScoreDoc *arg1 = (lucene::search::ScoreDoc *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_ScoreDoc",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__ScoreDoc,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * ScoreDoc_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__ScoreDoc, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_IndexSearcher_FromString(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    lucene::search::IndexSearcher *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_IndexSearcher_FromString",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    {
        try {
            result = (lucene::search::IndexSearcher *)new lucene::search::IndexSearcher((char const *)arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__IndexSearcher, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_IndexSearcher_FromIndexReader(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::index::IndexReader *arg1 = 0 ;
    lucene::search::IndexSearcher *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_IndexSearcher_FromIndexReader",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__index__IndexReader,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg1 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    {
        try {
            result = (lucene::search::IndexSearcher *)new lucene::search::IndexSearcher(*arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__IndexSearcher, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_IndexSearcher(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::IndexSearcher *arg1 = (lucene::search::IndexSearcher *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_IndexSearcher",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__IndexSearcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexSearcher_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::IndexSearcher *arg1 = (lucene::search::IndexSearcher *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexSearcher_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__IndexSearcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexSearcher_docFreq(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::IndexSearcher *arg1 = (lucene::search::IndexSearcher *) 0 ;
    lucene::index::Term *arg2 = 0 ;
    int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:IndexSearcher_docFreq",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__IndexSearcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        arg2 = supp_convertPythonTupleToTerm(obj1);
        if (arg2 == NULL) SWIG_fail;
    }
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (int)((lucene::search::IndexSearcher const *)arg1)->docFreq((lucene::index::Term const &)*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    {
        arg2->finalize();
    }
    return resultobj;
    fail:
    {
        arg2->finalize();
    }
    return NULL;
}


static PyObject *_wrap_IndexSearcher_doc(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::IndexSearcher *arg1 = (lucene::search::IndexSearcher *) 0 ;
    int arg2 ;
    lucene::document::Document *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:IndexSearcher_doc",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__IndexSearcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            {
                lucene::document::Document &_result_ref = (arg1)->doc(arg2);
                result = (lucene::document::Document *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    {
        resultobj = supp_convertDocumentToPythonDocument(result);
    }
    {
        delete result;
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_IndexSearcher_maxDoc(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::search::IndexSearcher *arg1 = (lucene::search::IndexSearcher *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:IndexSearcher_maxDoc",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__search__IndexSearcher,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (int)((lucene::search::IndexSearcher const *)arg1)->maxDoc();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject * IndexSearcher_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__search__IndexSearcher, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_Token_positionIncrement_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::Token *arg1 = (lucene::analysis::Token *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Token_positionIncrement_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__Token,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    {
        try {
            lucene_analysis_Token_positionIncrement_set(arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Token_positionIncrement_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::Token *arg1 = (lucene::analysis::Token *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:Token_positionIncrement_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__Token,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (int)lucene_analysis_Token_positionIncrement_get(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Token_text_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::Token *arg1 = (lucene::analysis::Token *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Token_text_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__Token,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    {
        try {
            lucene_analysis_Token_text_set(arg1,(char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Token_text_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::Token *arg1 = (lucene::analysis::Token *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:Token_text_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__Token,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (char *)lucene_analysis_Token_text_get(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Token_start_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::Token *arg1 = (lucene::analysis::Token *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Token_start_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__Token,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    {
        try {
            lucene_analysis_Token_start_set(arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Token_start_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::Token *arg1 = (lucene::analysis::Token *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:Token_start_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__Token,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (int)lucene_analysis_Token_start_get(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Token_end_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::Token *arg1 = (lucene::analysis::Token *) 0 ;
    int arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Token_end_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__Token,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    {
        try {
            lucene_analysis_Token_end_set(arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Token_end_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::Token *arg1 = (lucene::analysis::Token *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:Token_end_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__Token,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (int)lucene_analysis_Token_end_get(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_From_int((int)result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Token_type_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::Token *arg1 = (lucene::analysis::Token *) 0 ;
    char *arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Token_type_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__Token,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    {
        try {
            lucene_analysis_Token_type_set(arg1,(char const *)arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Token_type_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::Token *arg1 = (lucene::analysis::Token *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:Token_type_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__Token,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (char *)lucene_analysis_Token_type_get(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Token_sourceSlice_set(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::Token *arg1 = (lucene::analysis::Token *) 0 ;
    PyObject *arg2 = (PyObject *) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:Token_sourceSlice_set",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__Token,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    arg2 = obj1;
    {
        try {
            lucene_analysis_Token_sourceSlice_set(arg1,arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_Token_sourceSlice_get(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::Token *arg1 = (lucene::analysis::Token *) 0 ;
    PyObject *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:Token_sourceSlice_get",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__Token,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            result = (PyObject *)lucene_analysis_Token_sourceSlice_get(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = result;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_Token(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::Token *arg1 = (lucene::analysis::Token *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_Token",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__Token,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_Token(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    int arg2 ;
    int arg3 ;
    char *arg4 ;
    lucene::analysis::Token *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:new_Token",&obj0,&obj1,&obj2,&obj3)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    arg2 = (int)SWIG_As_int(obj1); 
    if (PyErr_Occurred()) SWIG_fail;
    arg3 = (int)SWIG_As_int(obj2); 
    if (PyErr_Occurred()) SWIG_fail;
    if (!SWIG_AsCharPtr(obj3, (char**)&arg4)) SWIG_fail;
    {
        try {
            result = (lucene::analysis::Token *)new lucene::analysis::Token((char const *)arg1,arg2,arg3,(char const *)arg4);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__analysis__Token, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject * Token_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__analysis__Token, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_TokenStream_next(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::TokenStream *arg1 = (lucene::analysis::TokenStream *) 0 ;
    lucene::analysis::Token *result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TokenStream_next",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__TokenStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (lucene::analysis::Token *)(arg1)->next();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__analysis__Token, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_TokenStream_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::TokenStream *arg1 = (lucene::analysis::TokenStream *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:TokenStream_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__TokenStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_TokenStream(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::TokenStream *arg1 = (lucene::analysis::TokenStream *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_TokenStream",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__TokenStream,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * TokenStream_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__analysis__TokenStream, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_Analyzer_tokenStream(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::Analyzer *arg1 = (lucene::analysis::Analyzer *) 0 ;
    char *arg2 ;
    lucene::util::Reader *arg3 = (lucene::util::Reader *) 0 ;
    lucene::analysis::TokenStream *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:Analyzer_tokenStream",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__Analyzer,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **)(&arg3),SWIGTYPE_p_lucene__util__Reader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            {
                lucene::analysis::TokenStream &_result_ref = (arg1)->tokenStream((char const *)arg2,arg3);
                result = (lucene::analysis::TokenStream *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__analysis__TokenStream, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_Analyzer(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::Analyzer *arg1 = (lucene::analysis::Analyzer *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_Analyzer",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__Analyzer,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_Analyzer(PyObject *, PyObject *args) {
    PyObject *resultobj;
    PyObject *arg1 = (PyObject *) 0 ;
    lucene::analysis::Analyzer *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_Analyzer",&obj0)) goto fail;
    arg1 = obj0;
    {
        try {
            result = (lucene::analysis::Analyzer *)new SwigDirector_Analyzer(arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__analysis__Analyzer, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_disown_Analyzer(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::Analyzer *arg1 = (lucene::analysis::Analyzer *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:disown_Analyzer",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__Analyzer,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        Swig::Director *director = dynamic_cast<Swig::Director *>(arg1);
        if (director) director->swig_disown();
    }
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * Analyzer_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__analysis__Analyzer, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_StandardTokenizer(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::util::Reader *arg1 = 0 ;
    lucene::analysis::standard::StandardTokenizer *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_StandardTokenizer",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__util__Reader,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg1 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    {
        try {
            result = (lucene::analysis::standard::StandardTokenizer *)new lucene::analysis::standard::StandardTokenizer(*arg1);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__analysis__standard__StandardTokenizer, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_StandardTokenizer(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::standard::StandardTokenizer *arg1 = (lucene::analysis::standard::StandardTokenizer *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_StandardTokenizer",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__standard__StandardTokenizer,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_StandardTokenizer_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::standard::StandardTokenizer *arg1 = (lucene::analysis::standard::StandardTokenizer *) 0 ;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:StandardTokenizer_close",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__standard__StandardTokenizer,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            (arg1)->close();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_StandardTokenizer_next(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::standard::StandardTokenizer *arg1 = (lucene::analysis::standard::StandardTokenizer *) 0 ;
    lucene::analysis::Token *result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:StandardTokenizer_next",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__standard__StandardTokenizer,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            result = (lucene::analysis::Token *)(arg1)->next();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__analysis__Token, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject * StandardTokenizer_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__analysis__standard__StandardTokenizer, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_StandardAnalyzer(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::standard::StandardAnalyzer *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_StandardAnalyzer")) goto fail;
    {
        try {
            result = (lucene::analysis::standard::StandardAnalyzer *)new lucene::analysis::standard::StandardAnalyzer();
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__analysis__standard__StandardAnalyzer, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_StandardAnalyzer(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::standard::StandardAnalyzer *arg1 = (lucene::analysis::standard::StandardAnalyzer *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_StandardAnalyzer",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__standard__StandardAnalyzer,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_StandardAnalyzer_tokenStream(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::analysis::standard::StandardAnalyzer *arg1 = (lucene::analysis::standard::StandardAnalyzer *) 0 ;
    char *arg2 ;
    lucene::util::Reader *arg3 = (lucene::util::Reader *) 0 ;
    lucene::analysis::TokenStream *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:StandardAnalyzer_tokenStream",&obj0,&obj1,&obj2)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__analysis__standard__StandardAnalyzer,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **)(&arg3),SWIGTYPE_p_lucene__util__Reader,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    director = dynamic_cast<Swig::Director *>(arg1);
    if (director && (director->swig_get_self()==obj0)) director->swig_set_up();
    {
        try {
            {
                lucene::analysis::TokenStream &_result_ref = (arg1)->tokenStream((char const *)arg2,arg3);
                result = (lucene::analysis::TokenStream *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__analysis__TokenStream, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject * StandardAnalyzer_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__analysis__standard__StandardAnalyzer, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_QueryParser(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    lucene::analysis::Analyzer *arg2 = 0 ;
    lucene::queryParser::QueryParser *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:new_QueryParser",&obj0,&obj1)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),SWIGTYPE_p_lucene__analysis__Analyzer,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg2 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    {
        try {
            result = (lucene::queryParser::QueryParser *)new lucene::queryParser::QueryParser((char const *)arg1,*arg2);
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__queryParser__QueryParser, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_QueryParser(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::queryParser::QueryParser *arg1 = (lucene::queryParser::QueryParser *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_QueryParser",&obj0)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__queryParser__QueryParser,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_QueryParser_parseStatic(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *arg1 ;
    char *arg2 ;
    lucene::analysis::Analyzer *arg3 = 0 ;
    lucene::search::Query *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:QueryParser_parseStatic",&obj0,&obj1,&obj2)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    if ((SWIG_ConvertPtr(obj2,(void **)(&arg3),SWIGTYPE_p_lucene__analysis__Analyzer,
    SWIG_POINTER_EXCEPTION | 0)) == -1)
    SWIG_fail;
    if (arg3 == NULL) {
        PyErr_SetString(PyExc_TypeError,"null reference");
        SWIG_fail;
    }
    {
        try {
            {
                lucene::search::Query &_result_ref = lucene::queryParser::QueryParser::Parse((char const *)arg1,(char const *)arg2,*arg3);
                result = (lucene::search::Query *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__Query, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_QueryParser_parse(PyObject *, PyObject *args) {
    PyObject *resultobj;
    lucene::queryParser::QueryParser *arg1 = (lucene::queryParser::QueryParser *) 0 ;
    char *arg2 ;
    lucene::search::Query *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:QueryParser_parse",&obj0,&obj1)) goto fail;
    if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),SWIGTYPE_p_lucene__queryParser__QueryParser,
    SWIG_POINTER_EXCEPTION | 0)) == -1) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) SWIG_fail;
    {
        try {
            {
                lucene::search::Query &_result_ref = (arg1)->Parse((char const *)arg2);
                result = (lucene::search::Query *) &_result_ref;
            }
            
        } catch (Swig::DirectorException) {
            SWIG_fail;
        } catch (PythonExceptionAlreadySet) {
            SWIG_fail;
        } catch (THROW_TYPE &e) {
            /* THROW_TYPE is defined in CL's StdHeader.h. */
            PyErr_SetString(PyExc_Exception, e.what());
            SWIG_fail;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_lucene__search__Query, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject * QueryParser_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_lucene__queryParser__QueryParser, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyMethodDef SwigMethods[] = {
	 { (char *)"setGlobals", _wrap_setGlobals, METH_VARARGS, NULL },
	 { (char *)"new_StringReader", _wrap_new_StringReader, METH_VARARGS, NULL },
	 { (char *)"delete_StringReader", _wrap_delete_StringReader, METH_VARARGS, NULL },
	 { (char *)"StringReader_close", _wrap_StringReader_close, METH_VARARGS, NULL },
	 { (char *)"StringReader_swigregister", StringReader_swigregister, METH_VARARGS, NULL },
	 { (char *)"FileReader___eq__", _wrap_FileReader___eq__, METH_VARARGS, NULL },
	 { (char *)"new_FileReader", _wrap_new_FileReader, METH_VARARGS, NULL },
	 { (char *)"delete_FileReader", _wrap_delete_FileReader, METH_VARARGS, NULL },
	 { (char *)"FileReader_close", _wrap_FileReader_close, METH_VARARGS, NULL },
	 { (char *)"FileReader_swigregister", FileReader_swigregister, METH_VARARGS, NULL },
	 { (char *)"InputStream_readString", _wrap_InputStream_readString, METH_VARARGS, NULL },
	 { (char *)"InputStream_readByte", _wrap_InputStream_readByte, METH_VARARGS, NULL },
	 { (char *)"InputStream_readBytes", _wrap_InputStream_readBytes, METH_VARARGS, NULL },
	 { (char *)"InputStream_readChars", _wrap_InputStream_readChars, METH_VARARGS, NULL },
	 { (char *)"InputStream_read", _wrap_InputStream_read, METH_VARARGS, NULL },
	 { (char *)"InputStream_filePointer_set", _wrap_InputStream_filePointer_set, METH_VARARGS, NULL },
	 { (char *)"InputStream_filePointer_get", _wrap_InputStream_filePointer_get, METH_VARARGS, NULL },
	 { (char *)"delete_InputStream", _wrap_delete_InputStream, METH_VARARGS, NULL },
	 { (char *)"InputStream_clone", _wrap_InputStream_clone, METH_VARARGS, NULL },
	 { (char *)"InputStream_readInt", _wrap_InputStream_readInt, METH_VARARGS, NULL },
	 { (char *)"InputStream_readVInt", _wrap_InputStream_readVInt, METH_VARARGS, NULL },
	 { (char *)"InputStream_readLong", _wrap_InputStream_readLong, METH_VARARGS, NULL },
	 { (char *)"InputStream_readVLong", _wrap_InputStream_readVLong, METH_VARARGS, NULL },
	 { (char *)"InputStream_close", _wrap_InputStream_close, METH_VARARGS, NULL },
	 { (char *)"InputStream_seek", _wrap_InputStream_seek, METH_VARARGS, NULL },
	 { (char *)"InputStream___len__", _wrap_InputStream___len__, METH_VARARGS, NULL },
	 { (char *)"InputStream_swigregister", InputStream_swigregister, METH_VARARGS, NULL },
	 { (char *)"OutputStream_writeByte", _wrap_OutputStream_writeByte, METH_VARARGS, NULL },
	 { (char *)"OutputStream_writeChars", _wrap_OutputStream_writeChars, METH_VARARGS, NULL },
	 { (char *)"OutputStream_write", _wrap_OutputStream_write, METH_VARARGS, NULL },
	 { (char *)"OutputStream_filePointer_set", _wrap_OutputStream_filePointer_set, METH_VARARGS, NULL },
	 { (char *)"OutputStream_filePointer_get", _wrap_OutputStream_filePointer_get, METH_VARARGS, NULL },
	 { (char *)"delete_OutputStream", _wrap_delete_OutputStream, METH_VARARGS, NULL },
	 { (char *)"OutputStream_writeBytes", _wrap_OutputStream_writeBytes, METH_VARARGS, NULL },
	 { (char *)"OutputStream_writeInt", _wrap_OutputStream_writeInt, METH_VARARGS, NULL },
	 { (char *)"OutputStream_writeVInt", _wrap_OutputStream_writeVInt, METH_VARARGS, NULL },
	 { (char *)"OutputStream_writeLong", _wrap_OutputStream_writeLong, METH_VARARGS, NULL },
	 { (char *)"OutputStream_writeVLong", _wrap_OutputStream_writeVLong, METH_VARARGS, NULL },
	 { (char *)"OutputStream_writeString", _wrap_OutputStream_writeString, METH_VARARGS, NULL },
	 { (char *)"OutputStream_isClosed", _wrap_OutputStream_isClosed, METH_VARARGS, NULL },
	 { (char *)"OutputStream_close", _wrap_OutputStream_close, METH_VARARGS, NULL },
	 { (char *)"OutputStream___len__", _wrap_OutputStream___len__, METH_VARARGS, NULL },
	 { (char *)"OutputStream_swigregister", OutputStream_swigregister, METH_VARARGS, NULL },
	 { (char *)"Lock_obtain", _wrap_Lock_obtain, METH_VARARGS, NULL },
	 { (char *)"Lock_release", _wrap_Lock_release, METH_VARARGS, NULL },
	 { (char *)"delete_Lock", _wrap_delete_Lock, METH_VARARGS, NULL },
	 { (char *)"Lock_swigregister", Lock_swigregister, METH_VARARGS, NULL },
	 { (char *)"delete_LockWith", _wrap_delete_LockWith, METH_VARARGS, NULL },
	 { (char *)"LockWith_run", _wrap_LockWith_run, METH_VARARGS, NULL },
	 { (char *)"LockWith_swigregister", LockWith_swigregister, METH_VARARGS, NULL },
	 { (char *)"delete_Directory", _wrap_delete_Directory, METH_VARARGS, NULL },
	 { (char *)"Directory_list", _wrap_Directory_list, METH_VARARGS, NULL },
	 { (char *)"Directory_fileExists", _wrap_Directory_fileExists, METH_VARARGS, NULL },
	 { (char *)"Directory_fileModified", _wrap_Directory_fileModified, METH_VARARGS, NULL },
	 { (char *)"Directory_fileLength", _wrap_Directory_fileLength, METH_VARARGS, NULL },
	 { (char *)"Directory_openFile", _wrap_Directory_openFile, METH_VARARGS, NULL },
	 { (char *)"Directory_deleteFile", _wrap_Directory_deleteFile, METH_VARARGS, NULL },
	 { (char *)"Directory_renameFile", _wrap_Directory_renameFile, METH_VARARGS, NULL },
	 { (char *)"Directory_createFile", _wrap_Directory_createFile, METH_VARARGS, NULL },
	 { (char *)"Directory_makeLock", _wrap_Directory_makeLock, METH_VARARGS, NULL },
	 { (char *)"Directory_close", _wrap_Directory_close, METH_VARARGS, NULL },
	 { (char *)"Directory_swigregister", Directory_swigregister, METH_VARARGS, NULL },
	 { (char *)"FSInputStream_clone", _wrap_FSInputStream_clone, METH_VARARGS, NULL },
	 { (char *)"FSInputStream_isClone_set", _wrap_FSInputStream_isClone_set, METH_VARARGS, NULL },
	 { (char *)"FSInputStream_isClone_get", _wrap_FSInputStream_isClone_get, METH_VARARGS, NULL },
	 { (char *)"new_FSInputStream_FromFilename", _wrap_new_FSInputStream_FromFilename, METH_VARARGS, NULL },
	 { (char *)"delete_FSInputStream", _wrap_delete_FSInputStream, METH_VARARGS, NULL },
	 { (char *)"FSInputStream_close", _wrap_FSInputStream_close, METH_VARARGS, NULL },
	 { (char *)"FSInputStream_swigregister", FSInputStream_swigregister, METH_VARARGS, NULL },
	 { (char *)"new_FSOutputStream", _wrap_new_FSOutputStream, METH_VARARGS, NULL },
	 { (char *)"delete_FSOutputStream", _wrap_delete_FSOutputStream, METH_VARARGS, NULL },
	 { (char *)"FSOutputStream_flushBuffer", _wrap_FSOutputStream_flushBuffer, METH_VARARGS, NULL },
	 { (char *)"FSOutputStream_close", _wrap_FSOutputStream_close, METH_VARARGS, NULL },
	 { (char *)"FSOutputStream___len__", _wrap_FSOutputStream___len__, METH_VARARGS, NULL },
	 { (char *)"FSOutputStream_swigregister", FSOutputStream_swigregister, METH_VARARGS, NULL },
	 { (char *)"FSDirectory_name_set", _wrap_FSDirectory_name_set, METH_VARARGS, NULL },
	 { (char *)"FSDirectory_name_get", _wrap_FSDirectory_name_get, METH_VARARGS, NULL },
	 { (char *)"new_FSDirectory", _wrap_new_FSDirectory, METH_VARARGS, NULL },
	 { (char *)"delete_FSDirectory", _wrap_delete_FSDirectory, METH_VARARGS, NULL },
	 { (char *)"FSDirectory_fileExists", _wrap_FSDirectory_fileExists, METH_VARARGS, NULL },
	 { (char *)"FSDirectory_fileLength", _wrap_FSDirectory_fileLength, METH_VARARGS, NULL },
	 { (char *)"FSDirectory_deleteFile", _wrap_FSDirectory_deleteFile, METH_VARARGS, NULL },
	 { (char *)"FSDirectory_renameFile", _wrap_FSDirectory_renameFile, METH_VARARGS, NULL },
	 { (char *)"FSDirectory_createFile", _wrap_FSDirectory_createFile, METH_VARARGS, NULL },
	 { (char *)"FSDirectory_openFile", _wrap_FSDirectory_openFile, METH_VARARGS, NULL },
	 { (char *)"FSDirectory_makeLock", _wrap_FSDirectory_makeLock, METH_VARARGS, NULL },
	 { (char *)"FSDirectory_close", _wrap_FSDirectory_close, METH_VARARGS, NULL },
	 { (char *)"FSDirectory_swigregister", FSDirectory_swigregister, METH_VARARGS, NULL },
	 { (char *)"FSLock_filename_get", _wrap_FSLock_filename_get, METH_VARARGS, NULL },
	 { (char *)"new_FSLock", _wrap_new_FSLock, METH_VARARGS, NULL },
	 { (char *)"delete_FSLock", _wrap_delete_FSLock, METH_VARARGS, NULL },
	 { (char *)"FSLock_obtain", _wrap_FSLock_obtain, METH_VARARGS, NULL },
	 { (char *)"FSLock_release", _wrap_FSLock_release, METH_VARARGS, NULL },
	 { (char *)"FSLock_swigregister", FSLock_swigregister, METH_VARARGS, NULL },
	 { (char *)"RAMDirectory_list", _wrap_RAMDirectory_list, METH_VARARGS, NULL },
	 { (char *)"new_RAMDirectory", _wrap_new_RAMDirectory, METH_VARARGS, NULL },
	 { (char *)"delete_RAMDirectory", _wrap_delete_RAMDirectory, METH_VARARGS, NULL },
	 { (char *)"RAMDirectory_close", _wrap_RAMDirectory_close, METH_VARARGS, NULL },
	 { (char *)"RAMDirectory_swigregister", RAMDirectory_swigregister, METH_VARARGS, NULL },
	 { (char *)"new_TransactionalRAMDirectory", _wrap_new_TransactionalRAMDirectory, METH_VARARGS, NULL },
	 { (char *)"TransactionalRAMDirectory_transIsOpen", _wrap_TransactionalRAMDirectory_transIsOpen, METH_VARARGS, NULL },
	 { (char *)"TransactionalRAMDirectory_transStart", _wrap_TransactionalRAMDirectory_transStart, METH_VARARGS, NULL },
	 { (char *)"TransactionalRAMDirectory_transCommit", _wrap_TransactionalRAMDirectory_transCommit, METH_VARARGS, NULL },
	 { (char *)"TransactionalRAMDirectory_transAbort", _wrap_TransactionalRAMDirectory_transAbort, METH_VARARGS, NULL },
	 { (char *)"TransactionalRAMDirectory_close", _wrap_TransactionalRAMDirectory_close, METH_VARARGS, NULL },
	 { (char *)"TransactionalRAMDirectory_dummy_createFile", _wrap_TransactionalRAMDirectory_dummy_createFile, METH_VARARGS, NULL },
	 { (char *)"TransactionalRAMDirectory_dummy_deleteFile", _wrap_TransactionalRAMDirectory_dummy_deleteFile, METH_VARARGS, NULL },
	 { (char *)"TransactionalRAMDirectory_dummy_renameFile", _wrap_TransactionalRAMDirectory_dummy_renameFile, METH_VARARGS, NULL },
	 { (char *)"TransactionalRAMDirectory_dummy_readFile", _wrap_TransactionalRAMDirectory_dummy_readFile, METH_VARARGS, NULL },
	 { (char *)"delete_TransactionalRAMDirectory", _wrap_delete_TransactionalRAMDirectory, METH_VARARGS, NULL },
	 { (char *)"TransactionalRAMDirectory_swigregister", TransactionalRAMDirectory_swigregister, METH_VARARGS, NULL },
	 { (char *)"DateField_timeToString", _wrap_DateField_timeToString, METH_VARARGS, NULL },
	 { (char *)"DateField_stringToTime", _wrap_DateField_stringToTime, METH_VARARGS, NULL },
	 { (char *)"TermEnum__iter__", _wrap_TermEnum__iter__, METH_VARARGS, NULL },
	 { (char *)"delete_TermDocs", _wrap_delete_TermDocs, METH_VARARGS, NULL },
	 { (char *)"TermDocs_seek", _wrap_TermDocs_seek, METH_VARARGS, NULL },
	 { (char *)"TermDocs_doc", _wrap_TermDocs_doc, METH_VARARGS, NULL },
	 { (char *)"TermDocs_freq", _wrap_TermDocs_freq, METH_VARARGS, NULL },
	 { (char *)"TermDocs_next", _wrap_TermDocs_next, METH_VARARGS, NULL },
	 { (char *)"TermDocs_skipTo", _wrap_TermDocs_skipTo, METH_VARARGS, NULL },
	 { (char *)"TermDocs_close", _wrap_TermDocs_close, METH_VARARGS, NULL },
	 { (char *)"TermDocs_swigregister", TermDocs_swigregister, METH_VARARGS, NULL },
	 { (char *)"TermEnum_term", _wrap_TermEnum_term, METH_VARARGS, NULL },
	 { (char *)"TermEnum_itercall", _wrap_TermEnum_itercall, METH_VARARGS, NULL },
	 { (char *)"TermEnum_next", _wrap_TermEnum_next, METH_VARARGS, NULL },
	 { (char *)"TermEnum_docFreq", _wrap_TermEnum_docFreq, METH_VARARGS, NULL },
	 { (char *)"TermEnum_close", _wrap_TermEnum_close, METH_VARARGS, NULL },
	 { (char *)"delete_TermEnum", _wrap_delete_TermEnum, METH_VARARGS, NULL },
	 { (char *)"TermEnum_swigregister", TermEnum_swigregister, METH_VARARGS, NULL },
	 { (char *)"TermPositions_nextPosition", _wrap_TermPositions_nextPosition, METH_VARARGS, NULL },
	 { (char *)"delete_TermPositions", _wrap_delete_TermPositions, METH_VARARGS, NULL },
	 { (char *)"TermPositions_swigregister", TermPositions_swigregister, METH_VARARGS, NULL },
	 { (char *)"IndexReader_directory_get", _wrap_IndexReader_directory_get, METH_VARARGS, NULL },
	 { (char *)"delete_IndexReader", _wrap_delete_IndexReader, METH_VARARGS, NULL },
	 { (char *)"IndexReader_openFromDirName", _wrap_IndexReader_openFromDirName, METH_VARARGS, NULL },
	 { (char *)"IndexReader_openFromDir", _wrap_IndexReader_openFromDir, METH_VARARGS, NULL },
	 { (char *)"IndexReader_lastModified", _wrap_IndexReader_lastModified, METH_VARARGS, NULL },
	 { (char *)"IndexReader_indexExists", _wrap_IndexReader_indexExists, METH_VARARGS, NULL },
	 { (char *)"IndexReader_numDocs", _wrap_IndexReader_numDocs, METH_VARARGS, NULL },
	 { (char *)"IndexReader_maxDoc", _wrap_IndexReader_maxDoc, METH_VARARGS, NULL },
	 { (char *)"IndexReader_document", _wrap_IndexReader_document, METH_VARARGS, NULL },
	 { (char *)"IndexReader_isDeleted", _wrap_IndexReader_isDeleted, METH_VARARGS, NULL },
	 { (char *)"IndexReader_termsAll", _wrap_IndexReader_termsAll, METH_VARARGS, NULL },
	 { (char *)"IndexReader_termsSpecific", _wrap_IndexReader_termsSpecific, METH_VARARGS, NULL },
	 { (char *)"IndexReader_docFreq", _wrap_IndexReader_docFreq, METH_VARARGS, NULL },
	 { (char *)"IndexReader_termDocsContaining", _wrap_IndexReader_termDocsContaining, METH_VARARGS, NULL },
	 { (char *)"IndexReader_termPositionsContaining", _wrap_IndexReader_termPositionsContaining, METH_VARARGS, NULL },
	 { (char *)"IndexReader_termPositionsAll", _wrap_IndexReader_termPositionsAll, METH_VARARGS, NULL },
	 { (char *)"IndexReader_termDocsAll", _wrap_IndexReader_termDocsAll, METH_VARARGS, NULL },
	 { (char *)"IndexReader_deleteAt", _wrap_IndexReader_deleteAt, METH_VARARGS, NULL },
	 { (char *)"IndexReader_deleteWithTerm", _wrap_IndexReader_deleteWithTerm, METH_VARARGS, NULL },
	 { (char *)"IndexReader_close", _wrap_IndexReader_close, METH_VARARGS, NULL },
	 { (char *)"IndexReader_isLocked", _wrap_IndexReader_isLocked, METH_VARARGS, NULL },
	 { (char *)"IndexReader_unlock", _wrap_IndexReader_unlock, METH_VARARGS, NULL },
	 { (char *)"IndexReader_swigregister", IndexReader_swigregister, METH_VARARGS, NULL },
	 { (char *)"IndexWriter_addIndexes", _wrap_IndexWriter_addIndexes, METH_VARARGS, NULL },
	 { (char *)"delete_IndexWriter", _wrap_delete_IndexWriter, METH_VARARGS, NULL },
	 { (char *)"IndexWriter_maxFieldLength_set", _wrap_IndexWriter_maxFieldLength_set, METH_VARARGS, NULL },
	 { (char *)"IndexWriter_maxFieldLength_get", _wrap_IndexWriter_maxFieldLength_get, METH_VARARGS, NULL },
	 { (char *)"IndexWriter_mergeFactor_set", _wrap_IndexWriter_mergeFactor_set, METH_VARARGS, NULL },
	 { (char *)"IndexWriter_mergeFactor_get", _wrap_IndexWriter_mergeFactor_get, METH_VARARGS, NULL },
	 { (char *)"IndexWriter_maxMergeDocs_set", _wrap_IndexWriter_maxMergeDocs_set, METH_VARARGS, NULL },
	 { (char *)"IndexWriter_maxMergeDocs_get", _wrap_IndexWriter_maxMergeDocs_get, METH_VARARGS, NULL },
	 { (char *)"new_IndexWriter", _wrap_new_IndexWriter, METH_VARARGS, NULL },
	 { (char *)"IndexWriter_close", _wrap_IndexWriter_close, METH_VARARGS, NULL },
	 { (char *)"IndexWriter_docCount", _wrap_IndexWriter_docCount, METH_VARARGS, NULL },
	 { (char *)"IndexWriter_addDocument", _wrap_IndexWriter_addDocument, METH_VARARGS, NULL },
	 { (char *)"IndexWriter_optimize", _wrap_IndexWriter_optimize, METH_VARARGS, NULL },
	 { (char *)"IndexWriter_swigregister", IndexWriter_swigregister, METH_VARARGS, NULL },
	 { (char *)"HitCollector_collect", _wrap_HitCollector_collect, METH_VARARGS, NULL },
	 { (char *)"delete_HitCollector", _wrap_delete_HitCollector, METH_VARARGS, NULL },
	 { (char *)"new_HitCollector", _wrap_new_HitCollector, METH_VARARGS, NULL },
	 { (char *)"disown_HitCollector", _wrap_disown_HitCollector, METH_VARARGS, NULL },
	 { (char *)"HitCollector_swigregister", HitCollector_swigregister, METH_VARARGS, NULL },
	 { (char *)"new_Hits", _wrap_new_Hits, METH_VARARGS, NULL },
	 { (char *)"delete_Hits", _wrap_delete_Hits, METH_VARARGS, NULL },
	 { (char *)"Hits_Length", _wrap_Hits_Length, METH_VARARGS, NULL },
	 { (char *)"Hits_doc", _wrap_Hits_doc, METH_VARARGS, NULL },
	 { (char *)"Hits_id", _wrap_Hits_id, METH_VARARGS, NULL },
	 { (char *)"Hits_score", _wrap_Hits_score, METH_VARARGS, NULL },
	 { (char *)"Hits_swigregister", Hits_swigregister, METH_VARARGS, NULL },
	 { (char *)"Searcher_search", _wrap_Searcher_search, METH_VARARGS, NULL },
	 { (char *)"delete_Searcher", _wrap_delete_Searcher, METH_VARARGS, NULL },
	 { (char *)"Searcher_docFreq", _wrap_Searcher_docFreq, METH_VARARGS, NULL },
	 { (char *)"Searcher_maxDoc", _wrap_Searcher_maxDoc, METH_VARARGS, NULL },
	 { (char *)"Searcher_doc", _wrap_Searcher_doc, METH_VARARGS, NULL },
	 { (char *)"Searcher_close", _wrap_Searcher_close, METH_VARARGS, NULL },
	 { (char *)"Searcher_swigregister", Searcher_swigregister, METH_VARARGS, NULL },
	 { (char *)"Query_name_set", _wrap_Query_name_set, METH_VARARGS, NULL },
	 { (char *)"Query_name_get", _wrap_Query_name_get, METH_VARARGS, NULL },
	 { (char *)"delete_Query", _wrap_delete_Query, METH_VARARGS, NULL },
	 { (char *)"Query_boost_set", _wrap_Query_boost_set, METH_VARARGS, NULL },
	 { (char *)"Query_boost_get", _wrap_Query_boost_get, METH_VARARGS, NULL },
	 { (char *)"Query_sumOfSquaredWeights", _wrap_Query_sumOfSquaredWeights, METH_VARARGS, NULL },
	 { (char *)"Query_normalize", _wrap_Query_normalize, METH_VARARGS, NULL },
	 { (char *)"Query_prepare", _wrap_Query_prepare, METH_VARARGS, NULL },
	 { (char *)"Query_toString", _wrap_Query_toString, METH_VARARGS, NULL },
	 { (char *)"Query_swigregister", Query_swigregister, METH_VARARGS, NULL },
	 { (char *)"new_MultiSearcher", _wrap_new_MultiSearcher, METH_VARARGS, NULL },
	 { (char *)"delete_MultiSearcher", _wrap_delete_MultiSearcher, METH_VARARGS, NULL },
	 { (char *)"MultiSearcher_close", _wrap_MultiSearcher_close, METH_VARARGS, NULL },
	 { (char *)"MultiSearcher_docFreq", _wrap_MultiSearcher_docFreq, METH_VARARGS, NULL },
	 { (char *)"MultiSearcher_doc", _wrap_MultiSearcher_doc, METH_VARARGS, NULL },
	 { (char *)"MultiSearcher_subSearcher", _wrap_MultiSearcher_subSearcher, METH_VARARGS, NULL },
	 { (char *)"MultiSearcher_maxDoc", _wrap_MultiSearcher_maxDoc, METH_VARARGS, NULL },
	 { (char *)"MultiSearcher_swigregister", MultiSearcher_swigregister, METH_VARARGS, NULL },
	 { (char *)"TermQuery_term_set", _wrap_TermQuery_term_set, METH_VARARGS, NULL },
	 { (char *)"TermQuery_term_get", _wrap_TermQuery_term_get, METH_VARARGS, NULL },
	 { (char *)"new_TermQuery", _wrap_new_TermQuery, METH_VARARGS, NULL },
	 { (char *)"delete_TermQuery", _wrap_delete_TermQuery, METH_VARARGS, NULL },
	 { (char *)"TermQuery_sumOfSquaredWeights", _wrap_TermQuery_sumOfSquaredWeights, METH_VARARGS, NULL },
	 { (char *)"TermQuery_normalize", _wrap_TermQuery_normalize, METH_VARARGS, NULL },
	 { (char *)"TermQuery_toString", _wrap_TermQuery_toString, METH_VARARGS, NULL },
	 { (char *)"TermQuery_prepare", _wrap_TermQuery_prepare, METH_VARARGS, NULL },
	 { (char *)"TermQuery_swigregister", TermQuery_swigregister, METH_VARARGS, NULL },
	 { (char *)"delete_MultiTermQuery", _wrap_delete_MultiTermQuery, METH_VARARGS, NULL },
	 { (char *)"MultiTermQuery_sumOfSquaredWeights", _wrap_MultiTermQuery_sumOfSquaredWeights, METH_VARARGS, NULL },
	 { (char *)"MultiTermQuery_normalize", _wrap_MultiTermQuery_normalize, METH_VARARGS, NULL },
	 { (char *)"MultiTermQuery_toString", _wrap_MultiTermQuery_toString, METH_VARARGS, NULL },
	 { (char *)"MultiTermQuery_swigregister", MultiTermQuery_swigregister, METH_VARARGS, NULL },
	 { (char *)"PhraseQuery_terms_get", _wrap_PhraseQuery_terms_get, METH_VARARGS, NULL },
	 { (char *)"PhraseQuery_terms_set", _wrap_PhraseQuery_terms_set, METH_VARARGS, NULL },
	 { (char *)"PhraseQuery_slop_set", _wrap_PhraseQuery_slop_set, METH_VARARGS, NULL },
	 { (char *)"PhraseQuery_slop_get", _wrap_PhraseQuery_slop_get, METH_VARARGS, NULL },
	 { (char *)"new_PhraseQuery", _wrap_new_PhraseQuery, METH_VARARGS, NULL },
	 { (char *)"delete_PhraseQuery", _wrap_delete_PhraseQuery, METH_VARARGS, NULL },
	 { (char *)"PhraseQuery_add", _wrap_PhraseQuery_add, METH_VARARGS, NULL },
	 { (char *)"PhraseQuery_sumOfSquaredWeights", _wrap_PhraseQuery_sumOfSquaredWeights, METH_VARARGS, NULL },
	 { (char *)"PhraseQuery_normalize", _wrap_PhraseQuery_normalize, METH_VARARGS, NULL },
	 { (char *)"PhraseQuery_toString", _wrap_PhraseQuery_toString, METH_VARARGS, NULL },
	 { (char *)"PhraseQuery_prepare", _wrap_PhraseQuery_prepare, METH_VARARGS, NULL },
	 { (char *)"PhraseQuery_swigregister", PhraseQuery_swigregister, METH_VARARGS, NULL },
	 { (char *)"BooleanClause__deleteQuery_set", _wrap_BooleanClause__deleteQuery_set, METH_VARARGS, NULL },
	 { (char *)"BooleanClause__deleteQuery_get", _wrap_BooleanClause__deleteQuery_get, METH_VARARGS, NULL },
	 { (char *)"BooleanClause_query_set", _wrap_BooleanClause_query_set, METH_VARARGS, NULL },
	 { (char *)"BooleanClause_query_get", _wrap_BooleanClause_query_get, METH_VARARGS, NULL },
	 { (char *)"BooleanClause_required_set", _wrap_BooleanClause_required_set, METH_VARARGS, NULL },
	 { (char *)"BooleanClause_required_get", _wrap_BooleanClause_required_get, METH_VARARGS, NULL },
	 { (char *)"BooleanClause_prohibited_set", _wrap_BooleanClause_prohibited_set, METH_VARARGS, NULL },
	 { (char *)"BooleanClause_prohibited_get", _wrap_BooleanClause_prohibited_get, METH_VARARGS, NULL },
	 { (char *)"new_BooleanClause", _wrap_new_BooleanClause, METH_VARARGS, NULL },
	 { (char *)"delete_BooleanClause", _wrap_delete_BooleanClause, METH_VARARGS, NULL },
	 { (char *)"BooleanClause_swigregister", BooleanClause_swigregister, METH_VARARGS, NULL },
	 { (char *)"BooleanQuery_clauses_get", _wrap_BooleanQuery_clauses_get, METH_VARARGS, NULL },
	 { (char *)"BooleanQuery_clauses_set", _wrap_BooleanQuery_clauses_set, METH_VARARGS, NULL },
	 { (char *)"new_BooleanQuery", _wrap_new_BooleanQuery, METH_VARARGS, NULL },
	 { (char *)"delete_BooleanQuery", _wrap_delete_BooleanQuery, METH_VARARGS, NULL },
	 { (char *)"BooleanQuery_add", _wrap_BooleanQuery_add, METH_VARARGS, NULL },
	 { (char *)"BooleanQuery_prepare", _wrap_BooleanQuery_prepare, METH_VARARGS, NULL },
	 { (char *)"BooleanQuery_sumOfSquaredWeights", _wrap_BooleanQuery_sumOfSquaredWeights, METH_VARARGS, NULL },
	 { (char *)"BooleanQuery_normalize", _wrap_BooleanQuery_normalize, METH_VARARGS, NULL },
	 { (char *)"BooleanQuery_toString", _wrap_BooleanQuery_toString, METH_VARARGS, NULL },
	 { (char *)"BooleanQuery_swigregister", BooleanQuery_swigregister, METH_VARARGS, NULL },
	 { (char *)"new_WildcardQuery", _wrap_new_WildcardQuery, METH_VARARGS, NULL },
	 { (char *)"delete_WildcardQuery", _wrap_delete_WildcardQuery, METH_VARARGS, NULL },
	 { (char *)"WildcardQuery_prepare", _wrap_WildcardQuery_prepare, METH_VARARGS, NULL },
	 { (char *)"WildcardQuery_toString", _wrap_WildcardQuery_toString, METH_VARARGS, NULL },
	 { (char *)"WildcardQuery_swigregister", WildcardQuery_swigregister, METH_VARARGS, NULL },
	 { (char *)"new_PrefixQuery", _wrap_new_PrefixQuery, METH_VARARGS, NULL },
	 { (char *)"delete_PrefixQuery", _wrap_delete_PrefixQuery, METH_VARARGS, NULL },
	 { (char *)"PrefixQuery_prepare", _wrap_PrefixQuery_prepare, METH_VARARGS, NULL },
	 { (char *)"PrefixQuery_sumOfSquaredWeights", _wrap_PrefixQuery_sumOfSquaredWeights, METH_VARARGS, NULL },
	 { (char *)"PrefixQuery_normalize", _wrap_PrefixQuery_normalize, METH_VARARGS, NULL },
	 { (char *)"PrefixQuery_toString", _wrap_PrefixQuery_toString, METH_VARARGS, NULL },
	 { (char *)"PrefixQuery_swigregister", PrefixQuery_swigregister, METH_VARARGS, NULL },
	 { (char *)"delete_FilteredTermEnum", _wrap_delete_FilteredTermEnum, METH_VARARGS, NULL },
	 { (char *)"FilteredTermEnum_swigregister", FilteredTermEnum_swigregister, METH_VARARGS, NULL },
	 { (char *)"delete_FuzzyTermEnum", _wrap_delete_FuzzyTermEnum, METH_VARARGS, NULL },
	 { (char *)"FuzzyTermEnum_EndEnum", _wrap_FuzzyTermEnum_EndEnum, METH_VARARGS, NULL },
	 { (char *)"FuzzyTermEnum_close", _wrap_FuzzyTermEnum_close, METH_VARARGS, NULL },
	 { (char *)"FuzzyTermEnum_setFuzzyThreshold", _wrap_FuzzyTermEnum_setFuzzyThreshold, METH_VARARGS, NULL },
	 { (char *)"FuzzyTermEnum_swigregister", FuzzyTermEnum_swigregister, METH_VARARGS, NULL },
	 { (char *)"new_FuzzyQuery", _wrap_new_FuzzyQuery, METH_VARARGS, NULL },
	 { (char *)"delete_FuzzyQuery", _wrap_delete_FuzzyQuery, METH_VARARGS, NULL },
	 { (char *)"FuzzyQuery_prepare", _wrap_FuzzyQuery_prepare, METH_VARARGS, NULL },
	 { (char *)"FuzzyQuery_toString", _wrap_FuzzyQuery_toString, METH_VARARGS, NULL },
	 { (char *)"FuzzyQuery_swigregister", FuzzyQuery_swigregister, METH_VARARGS, NULL },
	 { (char *)"new_RangeQuery", _wrap_new_RangeQuery, METH_VARARGS, NULL },
	 { (char *)"delete_RangeQuery", _wrap_delete_RangeQuery, METH_VARARGS, NULL },
	 { (char *)"RangeQuery_prepare", _wrap_RangeQuery_prepare, METH_VARARGS, NULL },
	 { (char *)"RangeQuery_sumOfSquaredWeights", _wrap_RangeQuery_sumOfSquaredWeights, METH_VARARGS, NULL },
	 { (char *)"RangeQuery_normalize", _wrap_RangeQuery_normalize, METH_VARARGS, NULL },
	 { (char *)"RangeQuery_toString", _wrap_RangeQuery_toString, METH_VARARGS, NULL },
	 { (char *)"RangeQuery_swigregister", RangeQuery_swigregister, METH_VARARGS, NULL },
	 { (char *)"delete_Filter", _wrap_delete_Filter, METH_VARARGS, NULL },
	 { (char *)"Filter_bits", _wrap_Filter_bits, METH_VARARGS, NULL },
	 { (char *)"new_Filter", _wrap_new_Filter, METH_VARARGS, NULL },
	 { (char *)"disown_Filter", _wrap_disown_Filter, METH_VARARGS, NULL },
	 { (char *)"Filter_swigregister", Filter_swigregister, METH_VARARGS, NULL },
	 { (char *)"delete_DateFilter", _wrap_delete_DateFilter, METH_VARARGS, NULL },
	 { (char *)"new_DateFilter", _wrap_new_DateFilter, METH_VARARGS, NULL },
	 { (char *)"DateFilter_Before", _wrap_DateFilter_Before, METH_VARARGS, NULL },
	 { (char *)"DateFilter_After", _wrap_DateFilter_After, METH_VARARGS, NULL },
	 { (char *)"DateFilter_bits", _wrap_DateFilter_bits, METH_VARARGS, NULL },
	 { (char *)"DateFilter_swigregister", DateFilter_swigregister, METH_VARARGS, NULL },
	 { (char *)"TopDocs___iter__", _wrap_TopDocs___iter__, METH_VARARGS, NULL },
	 { (char *)"TopDocs_totalHits_get", _wrap_TopDocs_totalHits_get, METH_VARARGS, NULL },
	 { (char *)"TopDocs_scoreDocs_get", _wrap_TopDocs_scoreDocs_get, METH_VARARGS, NULL },
	 { (char *)"delete_TopDocs", _wrap_delete_TopDocs, METH_VARARGS, NULL },
	 { (char *)"TopDocs_swigregister", TopDocs_swigregister, METH_VARARGS, NULL },
	 { (char *)"ScoreDoc___repr__", _wrap_ScoreDoc___repr__, METH_VARARGS, NULL },
	 { (char *)"ScoreDoc_score_set", _wrap_ScoreDoc_score_set, METH_VARARGS, NULL },
	 { (char *)"ScoreDoc_score_get", _wrap_ScoreDoc_score_get, METH_VARARGS, NULL },
	 { (char *)"ScoreDoc_doc_set", _wrap_ScoreDoc_doc_set, METH_VARARGS, NULL },
	 { (char *)"ScoreDoc_doc_get", _wrap_ScoreDoc_doc_get, METH_VARARGS, NULL },
	 { (char *)"new_ScoreDoc", _wrap_new_ScoreDoc, METH_VARARGS, NULL },
	 { (char *)"delete_ScoreDoc", _wrap_delete_ScoreDoc, METH_VARARGS, NULL },
	 { (char *)"ScoreDoc_swigregister", ScoreDoc_swigregister, METH_VARARGS, NULL },
	 { (char *)"new_IndexSearcher_FromString", _wrap_new_IndexSearcher_FromString, METH_VARARGS, NULL },
	 { (char *)"new_IndexSearcher_FromIndexReader", _wrap_new_IndexSearcher_FromIndexReader, METH_VARARGS, NULL },
	 { (char *)"delete_IndexSearcher", _wrap_delete_IndexSearcher, METH_VARARGS, NULL },
	 { (char *)"IndexSearcher_close", _wrap_IndexSearcher_close, METH_VARARGS, NULL },
	 { (char *)"IndexSearcher_docFreq", _wrap_IndexSearcher_docFreq, METH_VARARGS, NULL },
	 { (char *)"IndexSearcher_doc", _wrap_IndexSearcher_doc, METH_VARARGS, NULL },
	 { (char *)"IndexSearcher_maxDoc", _wrap_IndexSearcher_maxDoc, METH_VARARGS, NULL },
	 { (char *)"IndexSearcher_swigregister", IndexSearcher_swigregister, METH_VARARGS, NULL },
	 { (char *)"Token_positionIncrement_set", _wrap_Token_positionIncrement_set, METH_VARARGS, NULL },
	 { (char *)"Token_positionIncrement_get", _wrap_Token_positionIncrement_get, METH_VARARGS, NULL },
	 { (char *)"Token_text_set", _wrap_Token_text_set, METH_VARARGS, NULL },
	 { (char *)"Token_text_get", _wrap_Token_text_get, METH_VARARGS, NULL },
	 { (char *)"Token_start_set", _wrap_Token_start_set, METH_VARARGS, NULL },
	 { (char *)"Token_start_get", _wrap_Token_start_get, METH_VARARGS, NULL },
	 { (char *)"Token_end_set", _wrap_Token_end_set, METH_VARARGS, NULL },
	 { (char *)"Token_end_get", _wrap_Token_end_get, METH_VARARGS, NULL },
	 { (char *)"Token_type_set", _wrap_Token_type_set, METH_VARARGS, NULL },
	 { (char *)"Token_type_get", _wrap_Token_type_get, METH_VARARGS, NULL },
	 { (char *)"Token_sourceSlice_set", _wrap_Token_sourceSlice_set, METH_VARARGS, NULL },
	 { (char *)"Token_sourceSlice_get", _wrap_Token_sourceSlice_get, METH_VARARGS, NULL },
	 { (char *)"delete_Token", _wrap_delete_Token, METH_VARARGS, NULL },
	 { (char *)"new_Token", _wrap_new_Token, METH_VARARGS, NULL },
	 { (char *)"Token_swigregister", Token_swigregister, METH_VARARGS, NULL },
	 { (char *)"TokenStream_next", _wrap_TokenStream_next, METH_VARARGS, NULL },
	 { (char *)"TokenStream_close", _wrap_TokenStream_close, METH_VARARGS, NULL },
	 { (char *)"delete_TokenStream", _wrap_delete_TokenStream, METH_VARARGS, NULL },
	 { (char *)"TokenStream_swigregister", TokenStream_swigregister, METH_VARARGS, NULL },
	 { (char *)"Analyzer_tokenStream", _wrap_Analyzer_tokenStream, METH_VARARGS, NULL },
	 { (char *)"delete_Analyzer", _wrap_delete_Analyzer, METH_VARARGS, NULL },
	 { (char *)"new_Analyzer", _wrap_new_Analyzer, METH_VARARGS, NULL },
	 { (char *)"disown_Analyzer", _wrap_disown_Analyzer, METH_VARARGS, NULL },
	 { (char *)"Analyzer_swigregister", Analyzer_swigregister, METH_VARARGS, NULL },
	 { (char *)"new_StandardTokenizer", _wrap_new_StandardTokenizer, METH_VARARGS, NULL },
	 { (char *)"delete_StandardTokenizer", _wrap_delete_StandardTokenizer, METH_VARARGS, NULL },
	 { (char *)"StandardTokenizer_close", _wrap_StandardTokenizer_close, METH_VARARGS, NULL },
	 { (char *)"StandardTokenizer_next", _wrap_StandardTokenizer_next, METH_VARARGS, NULL },
	 { (char *)"StandardTokenizer_swigregister", StandardTokenizer_swigregister, METH_VARARGS, NULL },
	 { (char *)"new_StandardAnalyzer", _wrap_new_StandardAnalyzer, METH_VARARGS, NULL },
	 { (char *)"delete_StandardAnalyzer", _wrap_delete_StandardAnalyzer, METH_VARARGS, NULL },
	 { (char *)"StandardAnalyzer_tokenStream", _wrap_StandardAnalyzer_tokenStream, METH_VARARGS, NULL },
	 { (char *)"StandardAnalyzer_swigregister", StandardAnalyzer_swigregister, METH_VARARGS, NULL },
	 { (char *)"new_QueryParser", _wrap_new_QueryParser, METH_VARARGS, NULL },
	 { (char *)"delete_QueryParser", _wrap_delete_QueryParser, METH_VARARGS, NULL },
	 { (char *)"QueryParser_parseStatic", _wrap_QueryParser_parseStatic, METH_VARARGS, NULL },
	 { (char *)"QueryParser_parse", _wrap_QueryParser_parse, METH_VARARGS, NULL },
	 { (char *)"QueryParser_swigregister", QueryParser_swigregister, METH_VARARGS, NULL },
	 { NULL, NULL, 0, NULL }
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_lucene__queryParser__QueryParserTo_p_lucene__queryParser__QueryParserBase(void *x) {
    return (void *)((lucene::queryParser::QueryParserBase *)  ((lucene::queryParser::QueryParser *) x));
}
static void *_p_lucene__analysis__standard__StandardAnalyzerTo_p_lucene__analysis__Analyzer(void *x) {
    return (void *)((lucene::analysis::Analyzer *)  ((lucene::analysis::standard::StandardAnalyzer *) x));
}
static void *_p_lucene__search__TermQueryTo_p_lucene__search__Query(void *x) {
    return (void *)((lucene::search::Query *)  ((lucene::search::TermQuery *) x));
}
static void *_p_lucene__search__MultiTermQueryTo_p_lucene__search__Query(void *x) {
    return (void *)((lucene::search::Query *)  ((lucene::search::MultiTermQuery *) x));
}
static void *_p_lucene__search__PrefixQueryTo_p_lucene__search__Query(void *x) {
    return (void *)((lucene::search::Query *)  ((lucene::search::PrefixQuery *) x));
}
static void *_p_lucene__search__BooleanQueryTo_p_lucene__search__Query(void *x) {
    return (void *)((lucene::search::Query *)  ((lucene::search::BooleanQuery *) x));
}
static void *_p_lucene__search__WildcardQueryTo_p_lucene__search__Query(void *x) {
    return (void *)((lucene::search::Query *) (lucene::search::MultiTermQuery *) ((lucene::search::WildcardQuery *) x));
}
static void *_p_lucene__search__FuzzyQueryTo_p_lucene__search__Query(void *x) {
    return (void *)((lucene::search::Query *) (lucene::search::MultiTermQuery *) ((lucene::search::FuzzyQuery *) x));
}
static void *_p_lucene__search__PhraseQueryTo_p_lucene__search__Query(void *x) {
    return (void *)((lucene::search::Query *)  ((lucene::search::PhraseQuery *) x));
}
static void *_p_lucene__search__RangeQueryTo_p_lucene__search__Query(void *x) {
    return (void *)((lucene::search::Query *)  ((lucene::search::RangeQuery *) x));
}
static void *_p_lucene__store__FSLockTo_p_lucene__store__LuceneLock(void *x) {
    return (void *)((lucene::store::LuceneLock *)  ((lucene::store::FSLock *) x));
}
static void *_p_lucene__store__RAMLockTo_p_lucene__store__LuceneLock(void *x) {
    return (void *)((lucene::store::LuceneLock *)  ((lucene::store::RAMLock *) x));
}
static void *_p_lucene__search__DateFilterTo_p_lucene__search__Filter(void *x) {
    return (void *)((lucene::search::Filter *)  ((lucene::search::DateFilter *) x));
}
static void *_p_lucene__search__MultiHitCollectorTo_p_lucene__search__HitCollector(void *x) {
    return (void *)((lucene::search::HitCollector *)  ((lucene::search::MultiHitCollector *) x));
}
static void *_p_lucene__search__SimpleTopDocsCollectorTo_p_lucene__search__HitCollector(void *x) {
    return (void *)((lucene::search::HitCollector *)  ((lucene::search::SimpleTopDocsCollector *) x));
}
static void *_p_lucene__search__SimpleFilteredCollectorTo_p_lucene__search__HitCollector(void *x) {
    return (void *)((lucene::search::HitCollector *)  ((lucene::search::SimpleFilteredCollector *) x));
}
static void *_p_lucene__store__FSDirectoryTo_p_lucene__store__Directory(void *x) {
    return (void *)((lucene::store::Directory *)  ((lucene::store::FSDirectory *) x));
}
static void *_p_lucene__store__RAMDirectoryTo_p_lucene__store__Directory(void *x) {
    return (void *)((lucene::store::Directory *)  ((lucene::store::RAMDirectory *) x));
}
static void *_p_lucene__store__TransactionalRAMDirectoryTo_p_lucene__store__Directory(void *x) {
    return (void *)((lucene::store::Directory *) (lucene::store::RAMDirectory *) ((lucene::store::TransactionalRAMDirectory *) x));
}
static void *_p_lucene__store__TransactionalRAMDirectoryTo_p_lucene__store__RAMDirectory(void *x) {
    return (void *)((lucene::store::RAMDirectory *)  ((lucene::store::TransactionalRAMDirectory *) x));
}
static void *_p_lucene__index__IndexReaderLockWithTo_p_lucene__store__LuceneLockWith(void *x) {
    return (void *)((lucene::store::LuceneLockWith *)  ((lucene::index::IndexReaderLockWith *) x));
}
static void *_p_lucene__index__IndexWriterLockWithTo_p_lucene__store__LuceneLockWith(void *x) {
    return (void *)((lucene::store::LuceneLockWith *)  ((lucene::index::IndexWriterLockWith *) x));
}
static void *_p_lucene__index__IndexWriterLockWith2To_p_lucene__store__LuceneLockWith(void *x) {
    return (void *)((lucene::store::LuceneLockWith *)  ((lucene::index::IndexWriterLockWith2 *) x));
}
static void *_p_lucene__search__MultiSearcherTo_p_lucene__search__Searcher(void *x) {
    return (void *)((lucene::search::Searcher *)  ((lucene::search::MultiSearcher *) x));
}
static void *_p_lucene__search__IndexSearcherTo_p_lucene__search__Searcher(void *x) {
    return (void *)((lucene::search::Searcher *)  ((lucene::search::IndexSearcher *) x));
}
static void *_p_lucene__index__TermPositionsTo_p_lucene__index__TermDocs(void *x) {
    return (void *)((lucene::index::TermDocs *)  ((lucene::index::TermPositions *) x));
}
static void *_p_lucene__analysis__TokenizerTo_p_lucene__analysis__TokenStream(void *x) {
    return (void *)((lucene::analysis::TokenStream *)  ((lucene::analysis::Tokenizer *) x));
}
static void *_p_lucene__analysis__standard__StandardTokenizerTo_p_lucene__analysis__TokenStream(void *x) {
    return (void *)((lucene::analysis::TokenStream *) (lucene::analysis::Tokenizer *) ((lucene::analysis::standard::StandardTokenizer *) x));
}
static void *_p_lucene__analysis__TokenFilterTo_p_lucene__analysis__TokenStream(void *x) {
    return (void *)((lucene::analysis::TokenStream *)  ((lucene::analysis::TokenFilter *) x));
}
static void *_p_lucene__store__FSOutputStreamTo_p_lucene__store__OutputStream(void *x) {
    return (void *)((lucene::store::OutputStream *)  ((lucene::store::FSOutputStream *) x));
}
static void *_p_lucene__store__FSInputStreamTo_p_lucene__store__InputStream(void *x) {
    return (void *)((lucene::store::InputStream *)  ((lucene::store::FSInputStream *) x));
}
static void *_p_FilteredTermEnumTo_p_lucene__index__TermEnum(void *x) {
    return (void *)((lucene::index::TermEnum *)  ((FilteredTermEnum *) x));
}
static void *_p_lucene__search__FuzzyTermEnumTo_p_lucene__index__TermEnum(void *x) {
    return (void *)((lucene::index::TermEnum *) (FilteredTermEnum *) ((lucene::search::FuzzyTermEnum *) x));
}
static void *_p_lucene__search__FuzzyTermEnumTo_p_FilteredTermEnum(void *x) {
    return (void *)((FilteredTermEnum *)  ((lucene::search::FuzzyTermEnum *) x));
}
static void *_p_lucene__util__StringReaderTo_p_lucene__util__Reader(void *x) {
    return (void *)((lucene::util::Reader *)  ((lucene::util::StringReader *) x));
}
static void *_p_lucene__util__FileReaderTo_p_lucene__util__Reader(void *x) {
    return (void *)((lucene::util::Reader *)  ((lucene::util::FileReader *) x));
}
static void *_p_lucene__analysis__standard__StandardTokenizerTo_p_lucene__analysis__Tokenizer(void *x) {
    return (void *)((lucene::analysis::Tokenizer *)  ((lucene::analysis::standard::StandardTokenizer *) x));
}
static void *_p_lucene__search__WildcardQueryTo_p_lucene__search__MultiTermQuery(void *x) {
    return (void *)((lucene::search::MultiTermQuery *)  ((lucene::search::WildcardQuery *) x));
}
static void *_p_lucene__search__FuzzyQueryTo_p_lucene__search__MultiTermQuery(void *x) {
    return (void *)((lucene::search::MultiTermQuery *)  ((lucene::search::FuzzyQuery *) x));
}
static swig_type_info _swigt__p_lucene__analysis__Token[] = {{"_p_lucene__analysis__Token", 0, "lucene::analysis::Token *", 0, 0, 0, 0},{"_p_lucene__analysis__Token", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__PrefixQuery[] = {{"_p_lucene__search__PrefixQuery", 0, "lucene::search::PrefixQuery *", 0, 0, 0, 0},{"_p_lucene__search__PrefixQuery", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__index__IndexReader[] = {{"_p_lucene__index__IndexReader", 0, "lucene::index::IndexReader *", 0, 0, 0, 0},{"_p_lucene__index__IndexReader", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__Filter[] = {{"_p_lucene__search__Filter", 0, "lucene::search::Filter *", 0, 0, 0, 0},{"_p_lucene__search__Filter", 0, 0, 0, 0, 0, 0},{"_p_lucene__search__DateFilter", _p_lucene__search__DateFilterTo_p_lucene__search__Filter, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__queryParser__QueryParserBase[] = {{"_p_lucene__queryParser__QueryParserBase", 0, "lucene::queryParser::QueryParserBase *", 0, 0, 0, 0},{"_p_lucene__queryParser__QueryParser", _p_lucene__queryParser__QueryParserTo_p_lucene__queryParser__QueryParserBase, 0, 0, 0, 0, 0},{"_p_lucene__queryParser__QueryParserBase", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__DateFilter[] = {{"_p_lucene__search__DateFilter", 0, "lucene::search::DateFilter *", 0, 0, 0, 0},{"_p_lucene__search__DateFilter", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_p_p_char[] = {{"_p_p_p_char", 0, "char ***", 0, 0, 0, 0},{"_p_p_p_char", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_char[] = {{"_p_char", 0, "char *", 0, 0, 0, 0},{"_p_char", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__index__IndexWriter[] = {{"_p_lucene__index__IndexWriter", 0, "lucene::index::IndexWriter *", 0, 0, 0, 0},{"_p_lucene__index__IndexWriter", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__ScoreDoc[] = {{"_p_lucene__search__ScoreDoc", 0, "lucene::search::ScoreDoc *", 0, 0, 0, 0},{"_p_lucene__search__ScoreDoc", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__store__LuceneLockWith[] = {{"_p_lucene__store__LuceneLockWith", 0, "lucene::store::LuceneLockWith *", 0, 0, 0, 0},{"_p_lucene__store__LuceneLockWith", 0, 0, 0, 0, 0, 0},{"_p_lucene__index__IndexReaderLockWith", _p_lucene__index__IndexReaderLockWithTo_p_lucene__store__LuceneLockWith, 0, 0, 0, 0, 0},{"_p_lucene__index__IndexWriterLockWith", _p_lucene__index__IndexWriterLockWithTo_p_lucene__store__LuceneLockWith, 0, 0, 0, 0, 0},{"_p_lucene__index__IndexWriterLockWith2", _p_lucene__index__IndexWriterLockWith2To_p_lucene__store__LuceneLockWith, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_void[] = {{"_p_void", 0, "void *", 0, 0, 0, 0},{"_p_void", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__analysis__Analyzer[] = {{"_p_lucene__analysis__Analyzer", 0, "lucene::analysis::Analyzer *", 0, 0, 0, 0},{"_p_lucene__analysis__Analyzer", 0, 0, 0, 0, 0, 0},{"_p_lucene__analysis__standard__StandardAnalyzer", _p_lucene__analysis__standard__StandardAnalyzerTo_p_lucene__analysis__Analyzer, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__document__Document[] = {{"_p_lucene__document__Document", 0, "lucene::document::Document *", 0, 0, 0, 0},{"_p_lucene__document__Document", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__analysis__standard__StandardAnalyzer[] = {{"_p_lucene__analysis__standard__StandardAnalyzer", 0, "lucene::analysis::standard::StandardAnalyzer *", 0, 0, 0, 0},{"_p_lucene__analysis__standard__StandardAnalyzer", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__store__TransactionalRAMDirectory[] = {{"_p_lucene__store__TransactionalRAMDirectory", 0, "lucene::store::TransactionalRAMDirectory *", 0, 0, 0, 0},{"_p_lucene__store__TransactionalRAMDirectory", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__store__FSDirectory[] = {{"_p_lucene__store__FSDirectory", 0, "lucene::store::FSDirectory *", 0, 0, 0, 0},{"_p_lucene__store__FSDirectory", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__store__Directory[] = {{"_p_lucene__store__Directory", 0, "lucene::store::Directory *", 0, 0, 0, 0},{"_p_lucene__store__Directory", 0, 0, 0, 0, 0, 0},{"_p_lucene__store__FSDirectory", _p_lucene__store__FSDirectoryTo_p_lucene__store__Directory, 0, 0, 0, 0, 0},{"_p_lucene__store__RAMDirectory", _p_lucene__store__RAMDirectoryTo_p_lucene__store__Directory, 0, 0, 0, 0, 0},{"_p_lucene__store__TransactionalRAMDirectory", _p_lucene__store__TransactionalRAMDirectoryTo_p_lucene__store__Directory, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__store__RAMDirectory[] = {{"_p_lucene__store__RAMDirectory", 0, "lucene::store::RAMDirectory *", 0, 0, 0, 0},{"_p_lucene__store__RAMDirectory", 0, 0, 0, 0, 0, 0},{"_p_lucene__store__TransactionalRAMDirectory", _p_lucene__store__TransactionalRAMDirectoryTo_p_lucene__store__RAMDirectory, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__index__TermEnum[] = {{"_p_lucene__index__TermEnum", 0, "lucene::index::TermEnum *", 0, 0, 0, 0},{"_p_lucene__index__TermEnum", 0, 0, 0, 0, 0, 0},{"_p_FilteredTermEnum", _p_FilteredTermEnumTo_p_lucene__index__TermEnum, 0, 0, 0, 0, 0},{"_p_lucene__search__FuzzyTermEnum", _p_lucene__search__FuzzyTermEnumTo_p_lucene__index__TermEnum, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FilteredTermEnum[] = {{"_p_FilteredTermEnum", 0, "FilteredTermEnum *", 0, 0, 0, 0},{"_p_FilteredTermEnum", 0, 0, 0, 0, 0, 0},{"_p_lucene__search__FuzzyTermEnum", _p_lucene__search__FuzzyTermEnumTo_p_FilteredTermEnum, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__FuzzyTermEnum[] = {{"_p_lucene__search__FuzzyTermEnum", 0, "lucene::search::FuzzyTermEnum *", 0, 0, 0, 0},{"_p_lucene__search__FuzzyTermEnum", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__TopDocs[] = {{"_p_lucene__search__TopDocs", 0, "lucene::search::TopDocs *", 0, 0, 0, 0},{"_p_lucene__search__TopDocs", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__store__FSLock[] = {{"_p_lucene__store__FSLock", 0, "lucene::store::FSLock *", 0, 0, 0, 0},{"_p_lucene__store__FSLock", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__MultiTermQuery[] = {{"_p_lucene__search__MultiTermQuery", 0, "lucene::search::MultiTermQuery *", 0, 0, 0, 0},{"_p_lucene__search__MultiTermQuery", 0, 0, 0, 0, 0, 0},{"_p_lucene__search__WildcardQuery", _p_lucene__search__WildcardQueryTo_p_lucene__search__MultiTermQuery, 0, 0, 0, 0, 0},{"_p_lucene__search__FuzzyQuery", _p_lucene__search__FuzzyQueryTo_p_lucene__search__MultiTermQuery, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__store__LuceneLock[] = {{"_p_lucene__store__LuceneLock", 0, "lucene::store::LuceneLock *", 0, 0, 0, 0},{"_p_lucene__store__LuceneLock", 0, 0, 0, 0, 0, 0},{"_p_lucene__store__FSLock", _p_lucene__store__FSLockTo_p_lucene__store__LuceneLock, 0, 0, 0, 0, 0},{"_p_lucene__store__RAMLock", _p_lucene__store__RAMLockTo_p_lucene__store__LuceneLock, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__util__FileReader[] = {{"_p_lucene__util__FileReader", 0, "lucene::util::FileReader *", 0, 0, 0, 0},{"_p_lucene__util__FileReader", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__util__StringReader[] = {{"_p_lucene__util__StringReader", 0, "lucene::util::StringReader *", 0, 0, 0, 0},{"_p_lucene__util__StringReader", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__util__Reader[] = {{"_p_lucene__util__Reader", 0, "lucene::util::Reader *", 0, 0, 0, 0},{"_p_lucene__util__Reader", 0, 0, 0, 0, 0, 0},{"_p_lucene__util__StringReader", _p_lucene__util__StringReaderTo_p_lucene__util__Reader, 0, 0, 0, 0, 0},{"_p_lucene__util__FileReader", _p_lucene__util__FileReaderTo_p_lucene__util__Reader, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__TermQuery[] = {{"_p_lucene__search__TermQuery", 0, "lucene::search::TermQuery *", 0, 0, 0, 0},{"_p_lucene__search__TermQuery", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__Searcher[] = {{"_p_lucene__search__Searcher", 0, "lucene::search::Searcher *", 0, 0, 0, 0},{"_p_lucene__search__Searcher", 0, 0, 0, 0, 0, 0},{"_p_lucene__search__MultiSearcher", _p_lucene__search__MultiSearcherTo_p_lucene__search__Searcher, 0, 0, 0, 0, 0},{"_p_lucene__search__IndexSearcher", _p_lucene__search__IndexSearcherTo_p_lucene__search__Searcher, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__MultiSearcher[] = {{"_p_lucene__search__MultiSearcher", 0, "lucene::search::MultiSearcher *", 0, 0, 0, 0},{"_p_lucene__search__MultiSearcher", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__IndexSearcher[] = {{"_p_lucene__search__IndexSearcher", 0, "lucene::search::IndexSearcher *", 0, 0, 0, 0},{"_p_lucene__search__IndexSearcher", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__queryParser__QueryParser[] = {{"_p_lucene__queryParser__QueryParser", 0, "lucene::queryParser::QueryParser *", 0, 0, 0, 0},{"_p_lucene__queryParser__QueryParser", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__index__Term[] = {{"_p_lucene__index__Term", 0, "lucene::index::Term *", 0, 0, 0, 0},{"_p_lucene__index__Term", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__BooleanClause[] = {{"_p_lucene__search__BooleanClause", 0, "lucene::search::BooleanClause *", 0, 0, 0, 0},{"_p_lucene__search__BooleanClause", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__Query[] = {{"_p_lucene__search__Query", 0, "lucene::search::Query *", 0, 0, 0, 0},{"_p_lucene__search__Query", 0, 0, 0, 0, 0, 0},{"_p_lucene__search__TermQuery", _p_lucene__search__TermQueryTo_p_lucene__search__Query, 0, 0, 0, 0, 0},{"_p_lucene__search__MultiTermQuery", _p_lucene__search__MultiTermQueryTo_p_lucene__search__Query, 0, 0, 0, 0, 0},{"_p_lucene__search__PrefixQuery", _p_lucene__search__PrefixQueryTo_p_lucene__search__Query, 0, 0, 0, 0, 0},{"_p_lucene__search__BooleanQuery", _p_lucene__search__BooleanQueryTo_p_lucene__search__Query, 0, 0, 0, 0, 0},{"_p_lucene__search__WildcardQuery", _p_lucene__search__WildcardQueryTo_p_lucene__search__Query, 0, 0, 0, 0, 0},{"_p_lucene__search__FuzzyQuery", _p_lucene__search__FuzzyQueryTo_p_lucene__search__Query, 0, 0, 0, 0, 0},{"_p_lucene__search__PhraseQuery", _p_lucene__search__PhraseQueryTo_p_lucene__search__Query, 0, 0, 0, 0, 0},{"_p_lucene__search__RangeQuery", _p_lucene__search__RangeQueryTo_p_lucene__search__Query, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__WildcardQuery[] = {{"_p_lucene__search__WildcardQuery", 0, "lucene::search::WildcardQuery *", 0, 0, 0, 0},{"_p_lucene__search__WildcardQuery", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__Hits[] = {{"_p_lucene__search__Hits", 0, "lucene::search::Hits *", 0, 0, 0, 0},{"_p_lucene__search__Hits", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__BooleanQuery[] = {{"_p_lucene__search__BooleanQuery", 0, "lucene::search::BooleanQuery *", 0, 0, 0, 0},{"_p_lucene__search__BooleanQuery", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__store__FSOutputStream[] = {{"_p_lucene__store__FSOutputStream", 0, "lucene::store::FSOutputStream *", 0, 0, 0, 0},{"_p_lucene__store__FSOutputStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__store__FSInputStream[] = {{"_p_lucene__store__FSInputStream", 0, "lucene::store::FSInputStream *", 0, 0, 0, 0},{"_p_lucene__store__FSInputStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__analysis__TokenStream[] = {{"_p_lucene__analysis__TokenStream", 0, "lucene::analysis::TokenStream *", 0, 0, 0, 0},{"_p_lucene__analysis__Tokenizer", _p_lucene__analysis__TokenizerTo_p_lucene__analysis__TokenStream, 0, 0, 0, 0, 0},{"_p_lucene__analysis__standard__StandardTokenizer", _p_lucene__analysis__standard__StandardTokenizerTo_p_lucene__analysis__TokenStream, 0, 0, 0, 0, 0},{"_p_lucene__analysis__TokenFilter", _p_lucene__analysis__TokenFilterTo_p_lucene__analysis__TokenStream, 0, 0, 0, 0, 0},{"_p_lucene__analysis__TokenStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__store__InputStream[] = {{"_p_lucene__store__InputStream", 0, "lucene::store::InputStream *", 0, 0, 0, 0},{"_p_lucene__store__InputStream", 0, 0, 0, 0, 0, 0},{"_p_lucene__store__FSInputStream", _p_lucene__store__FSInputStreamTo_p_lucene__store__InputStream, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__store__OutputStream[] = {{"_p_lucene__store__OutputStream", 0, "lucene::store::OutputStream *", 0, 0, 0, 0},{"_p_lucene__store__OutputStream", 0, 0, 0, 0, 0, 0},{"_p_lucene__store__FSOutputStream", _p_lucene__store__FSOutputStreamTo_p_lucene__store__OutputStream, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_unsigned_char[] = {{"_p_unsigned_char", 0, "unsigned char *", 0, 0, 0, 0},{"_p_unsigned_char", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_PyObject[] = {{"_p_PyObject", 0, "PyObject *", 0, 0, 0, 0},{"_p_PyObject", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_BitSet[] = {{"_p_BitSet", 0, "BitSet *", 0, 0, 0, 0},{"_p_BitSet", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_long_t[] = {{"_p_long_t", 0, "long_t *", 0, 0, 0, 0},{"_p_long_t", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__PhraseQuery[] = {{"_p_lucene__search__PhraseQuery", 0, "lucene::search::PhraseQuery *", 0, 0, 0, 0},{"_p_lucene__search__PhraseQuery", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__RangeQuery[] = {{"_p_lucene__search__RangeQuery", 0, "lucene::search::RangeQuery *", 0, 0, 0, 0},{"_p_lucene__search__RangeQuery", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__index__TermPositions[] = {{"_p_lucene__index__TermPositions", 0, "lucene::index::TermPositions *", 0, 0, 0, 0},{"_p_lucene__index__TermPositions", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__HitCollector[] = {{"_p_lucene__search__HitCollector", 0, "lucene::search::HitCollector *", 0, 0, 0, 0},{"_p_lucene__search__HitCollector", 0, 0, 0, 0, 0, 0},{"_p_lucene__search__MultiHitCollector", _p_lucene__search__MultiHitCollectorTo_p_lucene__search__HitCollector, 0, 0, 0, 0, 0},{"_p_lucene__search__SimpleTopDocsCollector", _p_lucene__search__SimpleTopDocsCollectorTo_p_lucene__search__HitCollector, 0, 0, 0, 0, 0},{"_p_lucene__search__SimpleFilteredCollector", _p_lucene__search__SimpleFilteredCollectorTo_p_lucene__search__HitCollector, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__search__FuzzyQuery[] = {{"_p_lucene__search__FuzzyQuery", 0, "lucene::search::FuzzyQuery *", 0, 0, 0, 0},{"_p_lucene__search__FuzzyQuery", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_int[] = {{"_p_int", 0, "int *", 0, 0, 0, 0},{"_p_int", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__index__TermDocs[] = {{"_p_lucene__index__TermDocs", 0, "lucene::index::TermDocs *", 0, 0, 0, 0},{"_p_lucene__index__TermDocs", 0, 0, 0, 0, 0, 0},{"_p_lucene__index__TermPositions", _p_lucene__index__TermPositionsTo_p_lucene__index__TermDocs, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__analysis__Tokenizer[] = {{"_p_lucene__analysis__Tokenizer", 0, "lucene::analysis::Tokenizer *", 0, 0, 0, 0},{"_p_lucene__analysis__Tokenizer", 0, 0, 0, 0, 0, 0},{"_p_lucene__analysis__standard__StandardTokenizer", _p_lucene__analysis__standard__StandardTokenizerTo_p_lucene__analysis__Tokenizer, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_lucene__analysis__standard__StandardTokenizer[] = {{"_p_lucene__analysis__standard__StandardTokenizer", 0, "lucene::analysis::standard::StandardTokenizer *", 0, 0, 0, 0},{"_p_lucene__analysis__standard__StandardTokenizer", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_lucene__analysis__Token, 
_swigt__p_lucene__search__PrefixQuery, 
_swigt__p_lucene__index__IndexReader, 
_swigt__p_lucene__search__Filter, 
_swigt__p_lucene__queryParser__QueryParserBase, 
_swigt__p_lucene__search__DateFilter, 
_swigt__p_p_p_char, 
_swigt__p_char, 
_swigt__p_lucene__index__IndexWriter, 
_swigt__p_lucene__search__ScoreDoc, 
_swigt__p_lucene__store__LuceneLockWith, 
_swigt__p_void, 
_swigt__p_lucene__analysis__Analyzer, 
_swigt__p_lucene__document__Document, 
_swigt__p_lucene__analysis__standard__StandardAnalyzer, 
_swigt__p_lucene__store__TransactionalRAMDirectory, 
_swigt__p_lucene__store__FSDirectory, 
_swigt__p_lucene__store__Directory, 
_swigt__p_lucene__store__RAMDirectory, 
_swigt__p_lucene__index__TermEnum, 
_swigt__p_FilteredTermEnum, 
_swigt__p_lucene__search__FuzzyTermEnum, 
_swigt__p_lucene__search__TopDocs, 
_swigt__p_lucene__store__FSLock, 
_swigt__p_lucene__search__MultiTermQuery, 
_swigt__p_lucene__store__LuceneLock, 
_swigt__p_lucene__util__FileReader, 
_swigt__p_lucene__util__StringReader, 
_swigt__p_lucene__util__Reader, 
_swigt__p_lucene__search__TermQuery, 
_swigt__p_lucene__search__Searcher, 
_swigt__p_lucene__search__MultiSearcher, 
_swigt__p_lucene__search__IndexSearcher, 
_swigt__p_lucene__queryParser__QueryParser, 
_swigt__p_lucene__index__Term, 
_swigt__p_lucene__search__BooleanClause, 
_swigt__p_lucene__search__Query, 
_swigt__p_lucene__search__WildcardQuery, 
_swigt__p_lucene__search__Hits, 
_swigt__p_lucene__search__BooleanQuery, 
_swigt__p_lucene__store__FSOutputStream, 
_swigt__p_lucene__store__FSInputStream, 
_swigt__p_lucene__analysis__TokenStream, 
_swigt__p_lucene__store__InputStream, 
_swigt__p_lucene__store__OutputStream, 
_swigt__p_unsigned_char, 
_swigt__p_PyObject, 
_swigt__p_BitSet, 
_swigt__p_long_t, 
_swigt__p_lucene__search__PhraseQuery, 
_swigt__p_lucene__search__RangeQuery, 
_swigt__p_lucene__index__TermPositions, 
_swigt__p_lucene__search__HitCollector, 
_swigt__p_lucene__search__FuzzyQuery, 
_swigt__p_int, 
_swigt__p_lucene__index__TermDocs, 
_swigt__p_lucene__analysis__Tokenizer, 
_swigt__p_lucene__analysis__standard__StandardTokenizer, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

static swig_const_info swig_const_table[] = {
{0, 0, 0, 0.0, 0, 0}};

#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) SWIG_init(void) {
    static PyObject *SWIG_globals = 0; 
    static int       typeinit = 0;
    PyObject *m, *d;
    int       i;
    if (!SWIG_globals) SWIG_globals = SWIG_newvarlink();
    m = Py_InitModule((char *) SWIG_name, SwigMethods);
    d = PyModule_GetDict(m);
    
    if (!typeinit) {
        for (i = 0; swig_types_initial[i]; i++) {
            swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        }
        typeinit = 1;
    }
    SWIG_InstallConstants(d,swig_const_table);
    
    PyDict_SetItemString(d,(char*)"cvar", SWIG_globals);
    SWIG_addvarlink(SWIG_globals,(char*)"UNICODE_BUILD",_wrap_UNICODE_BUILD_get, _wrap_UNICODE_BUILD_set);
    SWIG_addvarlink(SWIG_globals,(char*)"SUMO_BUILD",_wrap_SUMO_BUILD_get, _wrap_SUMO_BUILD_set);
    SWIG_addvarlink(SWIG_globals,(char*)"global_string_this",_wrap_global_string_this_get, _wrap_global_string_this_set);
    SWIG_addvarlink(SWIG_globals,(char*)"global_string_thisown",_wrap_global_string_thisown_get, _wrap_global_string_thisown_set);
    
    /* HI__I_AM_A_BAIT_TOKEN_DELIBERATELY_INSERTED_AT_END_OF_HUGE_FILE__SO_LEAVE_ME_HERE
      ** HI__I_AM_A_BAIT_TOKEN_DELIBERATELY_INSERTED_AT_END_OF_HUGE_FILE__SO_LEAVE_ME_HERE */
    
}

