# 
# This file is part of Task-WebGUI
# 
# This software is copyright (c) 2010 by Patrick Donelan.
# 
# This is free software; you can redistribute it and/or modify it under
# the same terms as the Perl 5 programming language system itself.
# 
package Task::WebGUI;
BEGIN {
  $Task::WebGUI::VERSION = '1.101110';
}

# ABSTRACT: Install WebGUI dependencies


1;

__END__
=pod

=head1 NAME

Task::WebGUI - Install WebGUI dependencies

=head1 VERSION

version 1.101110

=head1 DESCRIPTION

This Task bundles up all WebGUI prerequisites (currently targeting the WebGUI8
development branch).

The preferred way of installing WebGUI is via the WRE (see L<http://getwebgui.com>)
however you may find this module useful in some circumstances (especially
on dev servers).

Even if you don't find it useful, we find the following CPAN Testers
reports that are generated by the existence of this module useful!

=over 4

=item *

L<http://www.cpantesters.org/distro/T/Task-WebGUI.html>

=item *

L<http://deps.cpantesters.org/?module=Task::WebGUI>

=back

Thanks CPAN Testers!

=head1 Image::Magick

If Image::Magick fails to install, you may need to download it from 
L<http://www.imagemagick.org> and install it manually:

 tar xvfz ImageMagick.tar.gz
 cd ImageMagick-*
 ./configure
 make && make check && sudo make install
 cd PerlMagick
 perl Makefile.PL
 make test && make install

=head1 SEE ALSO

L<http://webgui.org>

=head1 AUTHOR

  Patrick Donelan <pat@patspam.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2010 by Patrick Donelan.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

