# This Makefile.PL for Proc-Background was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

my @programs_to_install = qw(timed-process);

# Allow us to suppress all program installation with the -n (library only)
# option.  This is for those that don't want to mess with the configuration
# section of this file.
use Getopt::Std;
use vars qw($opt_n);
unless (getopts('n')) {
  die "Usage: $0 [-n]\n";
}
@programs_to_install = () if $opt_n;
my %optional_PL_FILES= map {("bin/$_.PL" => "bin/$_")} @programs_to_install;
my @optional_EXE_FILES= map {"bin/$_"} @programs_to_install;

my %WriteMakefileArgs = (
  "ABSTRACT" => "Run asynchronous child processes under Unix or Windows",
  "AUTHOR" => "Blair Zajac <blair\@orcaware.com>, Michael Conrad <mike\@nrdvana.net>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Proc-Background",
  "LICENSE" => "perl",
  "NAME" => "Proc::Background",
  "PREREQ_PM" => {},
  "VERSION" => "1.31",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    PL_FILES  => { %{$WriteMakefileArgs{PL_FILES}||{}}, %optional_PL_FILES },
    EXE_FILES => [ @{$WriteMakefileArgs{EXE_FILES}||[]}, @optional_EXE_FILES ],
);

my %FallbackPrereqs = ();

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

if ( $^O eq 'MSWin32' ) {
	$WriteMakefileArgs{PREREQ_PM}{'Win32::Process'} = $FallbackPrereqs{'Win32::Process'} = '0.04';
	$WriteMakefileArgs{PREREQ_PM}{'Win32::ShellQuote'} = $FallbackPrereqs{'Win32::ShellQuote'} = '0.003001';
}

WriteMakefile(%WriteMakefileArgs);
