#==========================================================================
#			   Copyright (c) 1995-1998 Martien Verbruggen
#--------------------------------------------------------------------------
#
#	Name:
#		GD::Graph::lines.pm
#
# $Id: lines.pm,v 1.5 2000/01/07 13:44:42 mgjv Exp $
#
#==========================================================================

package GD::Graph::lines;

use strict;
 
use GD;
use GD::Graph::axestype;

@GD::Graph::lines::ISA = qw( GD::Graph::axestype );

# PRIVATE

sub draw_data_set # GD::Image, \@data
{
	my $s = shift;
	my $d = shift;
	my $ds = shift;
	my $g = $s->{graph};

	my $dsci = $s->set_clr($s->pick_data_clr($ds) );
	my $type = $s->pick_line_type($ds);
	my ($xb, $yb) = (defined $d->[0]) ?
		$s->val_to_pixel( 1, $d->[0], $ds) :
		(undef, undef);

	my $i;
	for $i (1 .. $s->{numpoints}) 
	{
		next unless (defined $d->[$i]);

		my ($xe, $ye) = $s->val_to_pixel($i+1, $d->[$i], $ds);

		$s->draw_line($xb, $yb, $xe, $ye, $type, $dsci ) 
			if defined $xb;
		($xb, $yb) = ($xe, $ye);
   }
}

sub pick_line_type
{
	my $s = shift;
	my $num = shift;

	ref $s->{line_types} ?
		$s->{line_types}[ $num % (1 + $#{$s->{line_types}}) - 1 ] :
		$num % 4 ? $num % 4 : 4
}

sub draw_line # ($xs, $ys, $xe, $ye, $type, $colour_index)
{
	my $s = shift;
	my ($xs, $ys, $xe, $ye, $type, $clr) = @_;
	my $g = $s->{graph};

	my $lw = $s->{line_width};
	my $lts = $s->{line_type_scale};

	my $style = gdStyled;
	my @pattern = ();

	LINE: {

		($type == 2) && do {
			# dashed

			for (1 .. $lts) { push(@pattern, $clr) }
			for (1 .. $lts) { push(@pattern, gdTransparent) }

			$g->setStyle(@pattern);

			last LINE;
		};

		($type == 3) && do {
			# dotted,

			for (1 .. 2) { push(@pattern, $clr) }
			for (1 .. 2) { push(@pattern, gdTransparent) }

			$g->setStyle(@pattern);

			last LINE;
		};

		($type == 4) && do {
			# dashed and dotted

			for (1 .. $lts) { push(@pattern, $clr) }
			for (1 .. 2) 	{ push(@pattern, gdTransparent) }
			for (1 .. 2) 	{ push(@pattern, $clr) }
			for (1 .. 2) 	{ push(@pattern, gdTransparent) }

			$g->setStyle(@pattern);

			last LINE;
		};

		# default: solid
		$style = $clr;
	}

	# Tried the line_width thing with setBrush, ugly results
	# TODO: This loop probably should be around the datasets 
	# for nicer results
	my $i;
	for $i (1..$lw)
	{
		my $yslw = $ys + int($lw/2) - $i;
		my $yelw = $ye + int($lw/2) - $i;

		# Need the setstyle to reset 
		$g->setStyle(@pattern) if (@pattern);
		$g->line( $xs, $yslw, $xe, $yelw, $style );
	}
}

sub draw_legend_marker # (data_set_number, x, y)
{
	my $s = shift;
	my $n = shift;
	my $x = shift;
	my $y = shift;

	my $ci = $s->set_clr($s->pick_data_clr($n));
	my $type = $s->pick_line_type($n);

	$y += int($s->{lg_el_height}/2);

	#  Joe Smith <jms@tardis.Tymnet.COM>
	local($s->{line_width}) = 2;    # Make these show up better

	$s->draw_line(
		$x, $y, 
		$x + $s->{legend_marker_width}, $y,
		$type, $ci
	);
}

1;
