# simple.t

use Test::More;

use strict;
use warnings;

use Geo::UK::Postcode::Regex::Simple ':all';

subtest(
    postcode_re => sub {
        ok my $re = postcode_re, "got postcode regex";
        ok 'AB10 1AA' =~ $re, "regex ok";

        {
            local $Geo::UK::Postcode::Regex::Simple::MODE = 'lax';
            ok $re = postcode_re, "got lax postcode regex";
            ok 'XX10 1AA' =~ $re, "lax regex ok";
        }

        {
            local $Geo::UK::Postcode::Regex::Simple::MODE = 'valid';
            ok $re = postcode_re, "got valid postcode regex";
            ok 'XX10 1AA' !~ $re, "valid regex ok - fail";
            ok 'CW13 1AA' !~ $re, "valid regex ok - fail";
            ok 'AB10 1AA' =~ $re, "valid regex ok - success";
        }

        {
            local $Geo::UK::Postcode::Regex::Simple::ANCHORED = 0;
            ok $re = postcode_re, "got unanchored postcode regex";
            ok 'blah AB10 1AA blah' =~ $re, "unanchored regex ok";
        }

        {
            local $Geo::UK::Postcode::Regex::Simple::ANCHORED = 1;
            ok $re = postcode_re, "got anchored postcode regex";
            ok 'blah AB10 1AA blah' !~ $re, "anchored regex ok";
        }

        {
            local $Geo::UK::Postcode::Regex::Simple::CAPTURES = 0;
            ok $re = postcode_re, "got postcode regex with no captures";
            ok my @matches = 'AB10 1AA' =~ $re, "regex ok with no captures";
            is_deeply \@matches, [1], "no matches, only true value";
        }
    }
);

subtest(
    parse_pc => sub {
        ok my $parsed = parse_pc("AB10 1AA"), "parse_pc with defaults";
        is $parsed->{unit}, 'AA', "parsed ok";
        ok !parse_pc("XX10 1AA"), "parse_pc with defaults - strict mode";

        {
            local $Geo::UK::Postcode::Regex::Simple::MODE = 'lax';
            ok my $parsed = parse_pc("AB10 1BB"), "parse_pc, lax mode";
            is $parsed->{unit}, 'BB', "parsed ok";
            ok $parsed = parse_pc("XX10 1XX"), "parse_pc, lax mode";
            is $parsed->{unit}, 'XX', "parsed ok";
        }

    }
);

done_testing();

