package WebService::Mattermost::V4::API::Object::Response;

# ABSTRACT: A generic response item.

use Moo;

extends 'WebService::Mattermost::V4::API::Object';
with    qw(
    WebService::Mattermost::V4::API::Object::Role::ID
    WebService::Mattermost::V4::API::Object::Role::Message
    WebService::Mattermost::V4::API::Object::Role::RequestID
    WebService::Mattermost::V4::API::Object::Role::StatusCode
);

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Object::Response - A generic response item.

=head1 VERSION

version 0.27

=head1 DESCRIPTION

Details a generic response from Mattermost.

=head1 SEE ALSO

=over 4

=item L<WebService::Mattermost::V4::API::Object::Role::ID>

=item L<WebService::Mattermost::V4::API::Object::Role::Message>

=item L<WebService::Mattermost::V4::API::Object::Role::RequestID>

=item L<WebService::Mattermost::V4::API::Object::Role::StatusCode>

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
