use 5.006;
use strict;
use warnings FATAL => 'all';

use Module::Build;
my $class = Module::Build->subclass(
    class => "Module::Build::Custom",
    code  => q{
sub ACTION_standalone {
    my $self = shift;
    open( my $app, '>', 'dategrep-standalone' )
      or die "Can't open dategrep-standalone: $!\n";
    print $app <<'HEADER';
#!/usr/bin/env perl
# script autogenerated, do not patch

exit App::dategrep->run();

HEADER
    open( my $lib, '<', 'lib/App/dategrep.pm' )
      or die "Can't open lib: $!\n";
    while(<$lib>) {
    	last if /=pod/;
	print {$app} $_;
    }
    open( my $pod, '<', 'bin/dategrep' )
      or die "Can't open pod: $!\n";
    while(<$pod>) {
        if ( /^=pod/ .. /^=cut/ ) {
    	  print {$app} $_;
	}
    }
    close $lib;
    close $app;
    close $pod;
    }
    },
);

my $builder = $class->new(
    module_name => 'App::dategrep',
    configure_requires => {
        'Module::Build' => 0,
    },
    build_requires => {
        'Date::Manip'  => 0,
        'Getopt::Long' => 0,
        'Pod::Usage'   => 0,
    },
    test_requires => {
        'Test::Output'   => 0,
        'Test::More'     => 0,
        'Test::MockTime' => 0,
        'FindBin'        => 0,
        'POSIX'          => 0,
    },
    create_makefile_pl => 'traditional',
);

$builder->create_build_script();
