/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.server.CommandQueue;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.CommandQueueAware;
import org.openqa.selenium.server.browserlaunchers.DestroyableRuntimeExecutingBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.FirefoxChromeLauncher;
import org.openqa.selenium.server.browserlaunchers.FirefoxCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.HTABrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.InternetExplorerCustomProxyLauncher;
import org.openqa.selenium.server.browserlaunchers.KonquerorLauncher;
import org.openqa.selenium.server.browserlaunchers.MockBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.OperaCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.ProxyInjectionFirefoxCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.ProxyInjectionInternetExplorerCustomProxyLauncher;
import org.openqa.selenium.server.browserlaunchers.SafariCustomProfileLauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserLauncherFactory {
    private static final Pattern CUSTOM_PATTERN = Pattern.compile("^\\*custom( .*)?$");
    private static final Map<String, Class<? extends BrowserLauncher>> supportedBrowsers = new HashMap<String, Class<? extends BrowserLauncher>>();
    SeleniumServer server;

    public BrowserLauncherFactory(SeleniumServer server) {
        this.server = server;
    }

    public BrowserLauncher getBrowserLauncher(String browser, String sessionId, CommandQueue queue) {
        if (browser == null) {
            throw new IllegalArgumentException("browser may not be null");
        }
        for (Map.Entry<String, Class<? extends BrowserLauncher>> entry : supportedBrowsers.entrySet()) {
            String name = entry.getKey();
            Class<? extends BrowserLauncher> c = entry.getValue();
            Pattern pat = Pattern.compile("^\\*" + name + "( .*)?$");
            Matcher mat = pat.matcher(browser);
            if (!mat.find()) continue;
            String browserStartCommand = browser.equals("*" + name) ? null : mat.group(1).substring(1);
            return this.createBrowserLauncher(c, browserStartCommand, sessionId, queue);
        }
        Matcher CustomMatcher = CUSTOM_PATTERN.matcher(browser);
        if (CustomMatcher.find()) {
            String browserStartCommand = CustomMatcher.group(1).substring(1);
            return new DestroyableRuntimeExecutingBrowserLauncher(browserStartCommand, sessionId);
        }
        throw this.browserNotSupported(browser);
    }

    public static void addBrowserLauncher(String browser, Class<? extends BrowserLauncher> clazz) {
        supportedBrowsers.put(browser, clazz);
    }

    private RuntimeException browserNotSupported(String browser) {
        StringBuffer errorMessage = new StringBuffer("Browser not supported: " + browser);
        errorMessage.append('\n');
        if (!browser.startsWith("*")) {
            errorMessage.append("(Did you forget to add a *?)\n");
        }
        errorMessage.append('\n');
        errorMessage.append("Supported browsers include:\n");
        for (String name : supportedBrowsers.keySet()) {
            errorMessage.append("  *").append(name).append('\n');
        }
        errorMessage.append("  *custom\n");
        return new RuntimeException(errorMessage.toString());
    }

    private BrowserLauncher createBrowserLauncher(Class<? extends BrowserLauncher> c, String browserStartCommand, String sessionId, CommandQueue queue) {
        try {
            try {
                BrowserLauncher browserLauncher;
                int port = SeleniumServer.getPortDriversShouldContact();
                if (null == browserStartCommand) {
                    Constructor<? extends BrowserLauncher> ctor = c.getConstructor(Integer.TYPE, String.class);
                    browserLauncher = ctor.newInstance(port, sessionId);
                } else {
                    Constructor<? extends BrowserLauncher> ctor = c.getConstructor(Integer.TYPE, String.class, String.class);
                    browserLauncher = ctor.newInstance(port, sessionId, browserStartCommand);
                }
                if (browserLauncher instanceof CommandQueueAware) {
                    ((CommandQueueAware)((Object)browserLauncher)).setCommandQueue(queue);
                }
                return browserLauncher;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        supportedBrowsers.put("firefox", FirefoxCustomProfileLauncher.class);
        supportedBrowsers.put("iexplore", InternetExplorerCustomProxyLauncher.class);
        supportedBrowsers.put("safari", SafariCustomProfileLauncher.class);
        supportedBrowsers.put("iehta", HTABrowserLauncher.class);
        supportedBrowsers.put("chrome", FirefoxChromeLauncher.class);
        supportedBrowsers.put("opera", OperaCustomProfileLauncher.class);
        supportedBrowsers.put("piiexplore", ProxyInjectionInternetExplorerCustomProxyLauncher.class);
        supportedBrowsers.put("pifirefox", ProxyInjectionFirefoxCustomProfileLauncher.class);
        supportedBrowsers.put("konqueror", KonquerorLauncher.class);
        supportedBrowsers.put("mock", MockBrowserLauncher.class);
    }
}

