/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.jetty.Server;
import org.mortbay.util.Resource;
import org.openqa.selenium.server.ClassPathResource;
import org.openqa.selenium.server.ProxyHandler;
import org.openqa.selenium.server.SeleniumDriverResourceHandler;
import org.openqa.selenium.server.SingleEntryAsyncQueue;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.htmlrunner.HTMLLauncher;
import org.openqa.selenium.server.htmlrunner.HTMLResultsListener;
import org.openqa.selenium.server.htmlrunner.SeleniumHTMLRunnerResultsHandler;
import org.openqa.selenium.server.htmlrunner.SingleTestSuiteResourceHandler;

public class SeleniumServer {
    private Server server;
    private SeleniumDriverResourceHandler driver;
    private SeleniumHTMLRunnerResultsHandler postResultsHandler;
    private HttpContext context;
    private StaticContentHandler staticContentHandler;
    private int port;
    public static final int DEFAULT_PORT = 4444;
    public static final int DEFAULT_TIMEOUT = 1800;

    public static void main(String[] args) throws Exception {
        int port = 4444;
        int timeout = 1800;
        boolean interactive = false;
        boolean htmlSuite = false;
        String browserString = null;
        String startURL = null;
        String suiteFilePath = null;
        String resultFilePath = null;
        File userExtensions = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-help".equals(arg)) {
                System.err.println("Usage: java -jar selenium-server.jar [-port nnnn] [-timeout nnnn] [-interactive] [-htmlSuite browserString (e.g. \"*firefox\") startURL (e.g. \"http://www.google.com\") suiteFile (e.g. \"c:\\absolute\\path\\to\\my\\HTMLSuite.html\") resultFile (e.g. \"c:\\absolute\\path\\to\\my\\results.html\"]\nwhere:\nthe argument for timeout is an integer number of seconds before we should give up\nthe argument for port is the port number the selenium server should use (default 4444)\n-interactive puts you into interactive mode.  See the tutorial for more details");
                System.exit(1);
                continue;
            }
            if ("-port".equals(arg)) {
                port = Integer.parseInt(args[i + 1]);
                continue;
            }
            if ("-timeout".equals(arg)) {
                timeout = Integer.parseInt(args[i + 1]);
                continue;
            }
            if ("-userExtensions".equals(arg)) {
                if (!(userExtensions = new File(args[++i])).exists()) {
                    System.err.println("User Extensions file doesn't exist: " + userExtensions.getAbsolutePath());
                    System.exit(1);
                }
                if ("user-extensions.js".equals(userExtensions.getName())) continue;
                System.err.println("User extensions file MUST be called \"user-extensions.js\": " + userExtensions.getAbsolutePath());
                System.exit(1);
                continue;
            }
            if ("-htmlSuite".equals(arg)) {
                try {
                    browserString = args[++i];
                    startURL = args[++i];
                    suiteFilePath = args[++i];
                    resultFilePath = args[++i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.err.println("Not enough command line arguments for -htmlSuite");
                    System.err.println("-htmlSuite requires you to specify:");
                    System.err.println("* browserString (e.g. \"*firefox\")");
                    System.err.println("* startURL (e.g. \"http://www.google.com\")");
                    System.err.println("* suiteFile (e.g. \"c:\\absolute\\path\\to\\my\\HTMLSuite.html\")");
                    System.err.println("* resultFile (e.g. \"c:\\absolute\\path\\to\\my\\results.html\")");
                    System.exit(1);
                }
                htmlSuite = true;
                continue;
            }
            if (!"-interactive".equals(arg)) continue;
            timeout = Integer.MAX_VALUE;
            interactive = true;
        }
        if (interactive && htmlSuite) {
            System.err.println("You can't use -interactive and -htmlSuite on the same line!");
            System.exit(1);
        }
        SingleEntryAsyncQueue.setTimeout(timeout);
        final SeleniumServer seleniumProxy = new SeleniumServer(port);
        Thread jetty = new Thread(new Runnable(){

            public void run() {
                try {
                    seleniumProxy.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        if (interactive) {
            jetty.setDaemon(true);
        }
        jetty.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                try {
                    System.out.println("Shutting down...");
                    seleniumProxy.stop();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }));
        if (userExtensions != null) {
            seleniumProxy.addNewStaticContent(userExtensions.getParentFile());
        }
        if (htmlSuite) {
            String result = null;
            try {
                File suiteFile = new File(suiteFilePath);
                seleniumProxy.addNewStaticContent(suiteFile.getParentFile());
                String suiteURL = startURL + "/selenium-server/" + suiteFile.getName();
                HTMLLauncher launcher = new HTMLLauncher(seleniumProxy);
                result = launcher.runHTMLSuite(browserString, startURL, suiteURL, new File(resultFilePath), timeout);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            if (!"PASSED".equals(result)) {
                System.err.println("Tests failed");
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
        if (interactive) {
            String userInput;
            AsyncExecute.sleepTight(500L);
            System.out.println("Entering interactive mode... type Selenium commands here (e.g: cmd=open&1=http://www.yahoo.com)");
            BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
            while ((userInput = stdIn.readLine()) != null) {
                if ("quit".equals(userInput)) {
                    System.out.println("Stopping...");
                    seleniumProxy.stop();
                    System.exit(0);
                }
                if ("".equals(userInput)) continue;
                if (!userInput.startsWith("cmd=") && !userInput.startsWith("commandResult=")) {
                    System.err.println("ERROR -  Invalid command: " + userInput);
                    continue;
                }
                final URL url = new URL("http://localhost:" + port + "/selenium-server/driver?" + userInput);
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        try {
                            System.out.println("---> Requesting " + url.toString());
                            URLConnection conn = url.openConnection();
                            conn.connect();
                            conn.getContent();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
                t.start();
            }
        }
    }

    public SeleniumServer(int port) throws Exception {
        this.port = port;
        this.server = new Server();
        SocketListener socketListener = new SocketListener();
        socketListener.setPort(port);
        this.server.addListener(socketListener);
        HttpContext root = new HttpContext();
        root.setContextPath("/");
        ProxyHandler rootProxy = new ProxyHandler();
        root.addHandler(rootProxy);
        this.server.addContext(null, root);
        this.context = new HttpContext();
        this.context.setContextPath("/selenium-server");
        this.staticContentHandler = new StaticContentHandler();
        this.context.addHandler(this.staticContentHandler);
        this.server.addContext(null, this.context);
        this.context.addHandler(new SingleTestSuiteResourceHandler());
        this.server.addContext(null, this.context);
        this.postResultsHandler = new SeleniumHTMLRunnerResultsHandler();
        this.context.addHandler(this.postResultsHandler);
        this.server.addContext(null, this.context);
        HttpContext driverContext = new HttpContext();
        driverContext.setContextPath("/selenium-server/driver");
        this.driver = new SeleniumDriverResourceHandler(this);
        this.context.addHandler(this.driver);
        this.server.addContext(null, driverContext);
    }

    public SeleniumServer() throws Exception {
        this(4444);
    }

    public void addNewStaticContent(File directory) {
        this.staticContentHandler.addStaticContent(directory);
    }

    public void handleHTMLRunnerResults(HTMLResultsListener listener) {
        this.postResultsHandler.addListener(listener);
    }

    public String doCommand(String cmd, Vector values, String sessionId) {
        return this.driver.doCommand(cmd, values, sessionId, null);
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws InterruptedException {
        this.server.stop();
        this.driver.stopAllBrowsers();
    }

    public int getPort() {
        return this.port;
    }

    public Server getServer() {
        return this.server;
    }

    private class StaticContentHandler
    extends ResourceHandler {
        List contentDirs = new Vector();

        private StaticContentHandler() {
        }

        public void handle(String string, String string1, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
            httpResponse.setField("Expires", "-1");
            super.handle(string, string1, httpRequest, httpResponse);
        }

        protected Resource getResource(String s) throws IOException {
            Resource r = new ClassPathResource(s);
            SeleniumServer.this.context.getResourceMetaData(r);
            if (!r.exists()) {
                Iterator i = this.contentDirs.iterator();
                while (i.hasNext()) {
                    File dir = (File)i.next();
                    File resFile = new File(dir, s);
                    r = Resource.newResource(resFile.toURL());
                    SeleniumServer.this.context.getResourceMetaData(r);
                    if (r.exists()) break;
                    if (!"user-extensions.js".equals(resFile.getName())) continue;
                    resFile = new File(dir, "user-extensions.js");
                    r = Resource.newResource(resFile.toURL());
                    SeleniumServer.this.context.getResourceMetaData(r);
                    if (!r.exists()) continue;
                    break;
                }
            }
            return r;
        }

        public void addStaticContent(File directory) {
            this.contentDirs.add(directory);
        }
    }
}

