package Monitoring::GLPlugin::SNMP::MibsAndOids::SENTRY3MIB;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'Sentry3-MIB'} = {
  url => "",
  name => "Sentry3-MIB",
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::mib_ids->{'Sentry3-MIB'} =
  '1.3.6.1.4.1.1718.3';

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'Sentry3-MIB'} = {
  serverTech => '1.3.6.1.4.1.1718',
  sentry3 => '1.3.6.1.4.1.1718.3',
  systemGroup => '1.3.6.1.4.1.1718.3.1',
  systemVersion => '1.3.6.1.4.1.1718.3.1.1',
  systemNICSerialNumber => '1.3.6.1.4.1.1718.3.1.2',
  systemLocation => '1.3.6.1.4.1.1718.3.1.3',
  systemTowerCount => '1.3.6.1.4.1.1718.3.1.4',
  systemEnvMonCount => '1.3.6.1.4.1.1718.3.1.5',
  systemTotalPower => '1.3.6.1.4.1.1718.3.1.6',
  systemArea => '1.3.6.1.4.1.1718.3.1.7',
  systemWattsPerAreaUnit => '1.3.6.1.4.1.1718.3.1.8',
  systemAreaUnit => '1.3.6.1.4.1.1718.3.1.9',
  systemAreaUnitDefinition => 'Sentry3-MIB::systemAreaUnit',
  systemPowerFactor => '1.3.6.1.4.1.1718.3.1.10',
  systemFeatures => '1.3.6.1.4.1.1718.3.1.11',
  systemFeatureKey => '1.3.6.1.4.1.1718.3.1.12',
  systemOutletSeqInterval => '1.3.6.1.4.1.1718.3.1.13',
  systemOutletRebootDelay => '1.3.6.1.4.1.1718.3.1.14',
  systemConfigModifiedCount => '1.3.6.1.4.1.1718.3.1.15',
  systemTables => '1.3.6.1.4.1.1718.3.2',
  towerTable => '1.3.6.1.4.1.1718.3.2.1',
  towerEntry => '1.3.6.1.4.1.1718.3.2.1.1',
  towerIndex => '1.3.6.1.4.1.1718.3.2.1.1.1',
  towerID => '1.3.6.1.4.1.1718.3.2.1.1.2',
  towerName => '1.3.6.1.4.1.1718.3.2.1.1.3',
  towerStatus => '1.3.6.1.4.1.1718.3.2.1.1.4',
  towerStatusDefinition => 'Sentry3-MIB::towerStatus',
  towerInfeedCount => '1.3.6.1.4.1.1718.3.2.1.1.5',
  towerProductSN => '1.3.6.1.4.1.1718.3.2.1.1.6',
  towerModelNumber => '1.3.6.1.4.1.1718.3.2.1.1.7',
  towerCapabilities => '1.3.6.1.4.1.1718.3.2.1.1.8',
  towerVACapacity => '1.3.6.1.4.1.1718.3.2.1.1.9',
  towerVACapacityUsed => '1.3.6.1.4.1.1718.3.2.1.1.10',
  towerActivePower => '1.3.6.1.4.1.1718.3.2.1.1.11',
  towerApparentPower => '1.3.6.1.4.1.1718.3.2.1.1.12',
  towerPowerFactor => '1.3.6.1.4.1.1718.3.2.1.1.13',
  towerEnergy => '1.3.6.1.4.1.1718.3.2.1.1.14',
  towerLineFrequency => '1.3.6.1.4.1.1718.3.2.1.1.15',
  infeedTable => '1.3.6.1.4.1.1718.3.2.2',
  infeedEntry => '1.3.6.1.4.1.1718.3.2.2.1',
  infeedIndex => '1.3.6.1.4.1.1718.3.2.2.1.1',
  infeedID => '1.3.6.1.4.1.1718.3.2.2.1.2',
  infeedName => '1.3.6.1.4.1.1718.3.2.2.1.3',
  infeedCapabilities => '1.3.6.1.4.1.1718.3.2.2.1.4',
  infeedStatus => '1.3.6.1.4.1.1718.3.2.2.1.5',
  infeedStatusDefinition => 'Sentry3-MIB::infeedStatus',
  infeedLoadStatus => '1.3.6.1.4.1.1718.3.2.2.1.6',
  infeedLoadStatusDefinition => 'Sentry3-MIB::infeedLoadStatus',
  infeedLoadValue => '1.3.6.1.4.1.1718.3.2.2.1.7',
  infeedLoadHighThresh => '1.3.6.1.4.1.1718.3.2.2.1.8',
  infeedOutletCount => '1.3.6.1.4.1.1718.3.2.2.1.9',
  infeedCapacity => '1.3.6.1.4.1.1718.3.2.2.1.10',
  infeedVoltage => '1.3.6.1.4.1.1718.3.2.2.1.11',
  infeedPower => '1.3.6.1.4.1.1718.3.2.2.1.12',
  infeedApparentPower => '1.3.6.1.4.1.1718.3.2.2.1.13',
  infeedPowerFactor => '1.3.6.1.4.1.1718.3.2.2.1.14',
  infeedCrestFactor => '1.3.6.1.4.1.1718.3.2.2.1.15',
  infeedEnergy => '1.3.6.1.4.1.1718.3.2.2.1.16',
  infeedReactance => '1.3.6.1.4.1.1718.3.2.2.1.17',
  infeedReactanceDefinition => 'Sentry3-MIB::infeedReactance',
  infeedPhaseVoltage => '1.3.6.1.4.1.1718.3.2.2.1.18',
  infeedPhaseCurrent => '1.3.6.1.4.1.1718.3.2.2.1.19',
  infeedCapacityUsed => '1.3.6.1.4.1.1718.3.2.2.1.20',
  infeedLineID => '1.3.6.1.4.1.1718.3.2.2.1.21',
  infeedLineToLineID => '1.3.6.1.4.1.1718.3.2.2.1.22',
  infeedPhaseID => '1.3.6.1.4.1.1718.3.2.2.1.23',
  infeedVACapacity => '1.3.6.1.4.1.1718.3.2.2.1.24',
  infeedVACapacityUsed => '1.3.6.1.4.1.1718.3.2.2.1.25',
  outletTable => '1.3.6.1.4.1.1718.3.2.3',
  outletEntry => '1.3.6.1.4.1.1718.3.2.3.1',
  outletIndex => '1.3.6.1.4.1.1718.3.2.3.1.1',
  outletID => '1.3.6.1.4.1.1718.3.2.3.1.2',
  outletName => '1.3.6.1.4.1.1718.3.2.3.1.3',
  outletCapabilities => '1.3.6.1.4.1.1718.3.2.3.1.4',
  outletStatus => '1.3.6.1.4.1.1718.3.2.3.1.5',
  outletStatusDefinition => 'Sentry3-MIB::outletStatus',
  outletLoadStatus => '1.3.6.1.4.1.1718.3.2.3.1.6',
  outletLoadStatusDefinition => 'Sentry3-MIB::outletLoadStatus',
  outletLoadValue => '1.3.6.1.4.1.1718.3.2.3.1.7',
  outletLoadLowThresh => '1.3.6.1.4.1.1718.3.2.3.1.8',
  outletLoadHighThresh => '1.3.6.1.4.1.1718.3.2.3.1.9',
  outletControlState => '1.3.6.1.4.1.1718.3.2.3.1.10',
  outletControlStateDefinition => 'Sentry3-MIB::outletControlState',
  outletControlAction => '1.3.6.1.4.1.1718.3.2.3.1.11',
  outletControlActionDefinition => 'Sentry3-MIB::outletControlAction',
  outletCapacity => '1.3.6.1.4.1.1718.3.2.3.1.12',
  outletVoltage => '1.3.6.1.4.1.1718.3.2.3.1.13',
  outletPower => '1.3.6.1.4.1.1718.3.2.3.1.14',
  outletApparentPower => '1.3.6.1.4.1.1718.3.2.3.1.15',
  outletPowerFactor => '1.3.6.1.4.1.1718.3.2.3.1.16',
  outletCrestFactor => '1.3.6.1.4.1.1718.3.2.3.1.17',
  outletEnergy => '1.3.6.1.4.1.1718.3.2.3.1.18',
  outletWakeupState => '1.3.6.1.4.1.1718.3.2.3.1.19',
  outletWakeupStateDefinition => 'Sentry3-MIB::outletWakeupState',
  outletPostOnDelay => '1.3.6.1.4.1.1718.3.2.3.1.20',
  envMonTable => '1.3.6.1.4.1.1718.3.2.4',
  envMonEntry => '1.3.6.1.4.1.1718.3.2.4.1',
  envMonIndex => '1.3.6.1.4.1.1718.3.2.4.1.1',
  envMonID => '1.3.6.1.4.1.1718.3.2.4.1.2',
  envMonName => '1.3.6.1.4.1.1718.3.2.4.1.3',
  envMonStatus => '1.3.6.1.4.1.1718.3.2.4.1.4',
  envMonStatusDefinition => 'Sentry3-MIB::envMonStatus',
  envMonWaterSensorName => '1.3.6.1.4.1.1718.3.2.4.1.5',
  envMonWaterSensorStatus => '1.3.6.1.4.1.1718.3.2.4.1.6',
  envMonWaterSensorStatusDefinition => 'Sentry3-MIB::envMonWaterSensorStatus',
  envMonADCName => '1.3.6.1.4.1.1718.3.2.4.1.7',
  envMonADCStatus => '1.3.6.1.4.1.1718.3.2.4.1.8',
  envMonADCStatusDefinition => 'Sentry3-MIB::envMonADCStatus',
  envMonADCCount => '1.3.6.1.4.1.1718.3.2.4.1.9',
  envMonADCLowThresh => '1.3.6.1.4.1.1718.3.2.4.1.10',
  envMonADCHighThresh => '1.3.6.1.4.1.1718.3.2.4.1.11',
  envMonTempHumidSensorCount => '1.3.6.1.4.1.1718.3.2.4.1.12',
  envMonContactClosureCount => '1.3.6.1.4.1.1718.3.2.4.1.13',
  tempHumidSensorTable => '1.3.6.1.4.1.1718.3.2.5',
  tempHumidSensorEntry => '1.3.6.1.4.1.1718.3.2.5.1',
  tempHumidSensorIndex => '1.3.6.1.4.1.1718.3.2.5.1.1',
  tempHumidSensorID => '1.3.6.1.4.1.1718.3.2.5.1.2',
  tempHumidSensorName => '1.3.6.1.4.1.1718.3.2.5.1.3',
  tempHumidSensorStatus => '1.3.6.1.4.1.1718.3.2.5.1.4',
  tempHumidSensorStatusDefinition => 'Sentry3-MIB::tempHumidSensorStatus',
  tempHumidSensorTempStatus => '1.3.6.1.4.1.1718.3.2.5.1.5',
  tempHumidSensorTempStatusDefinition => 'Sentry3-MIB::tempHumidSensorTempStatus',
  tempHumidSensorTempValue => '1.3.6.1.4.1.1718.3.2.5.1.6',
  tempHumidSensorTempLowThresh => '1.3.6.1.4.1.1718.3.2.5.1.7',
  tempHumidSensorTempHighThresh => '1.3.6.1.4.1.1718.3.2.5.1.8',
  tempHumidSensorHumidStatus => '1.3.6.1.4.1.1718.3.2.5.1.9',
  tempHumidSensorHumidStatusDefinition => 'Sentry3-MIB::tempHumidSensorHumidStatus',
  tempHumidSensorHumidValue => '1.3.6.1.4.1.1718.3.2.5.1.10',
  tempHumidSensorHumidLowThresh => '1.3.6.1.4.1.1718.3.2.5.1.11',
  tempHumidSensorHumidHighThresh => '1.3.6.1.4.1.1718.3.2.5.1.12',
  tempHumidSensorTempScale => '1.3.6.1.4.1.1718.3.2.5.1.13',
  tempHumidSensorTempScaleDefinition => 'Sentry3-MIB::tempHumidSensorTempScale',
  tempHumidSensorTempRecDelta => '1.3.6.1.4.1.1718.3.2.5.1.14',
  tempHumidSensorHumidRecDelta => '1.3.6.1.4.1.1718.3.2.5.1.15',
  contactClosureTable => '1.3.6.1.4.1.1718.3.2.6',
  contactClosureEntry => '1.3.6.1.4.1.1718.3.2.6.1',
  contactClosureIndex => '1.3.6.1.4.1.1718.3.2.6.1.1',
  contactClosureID => '1.3.6.1.4.1.1718.3.2.6.1.2',
  contactClosureName => '1.3.6.1.4.1.1718.3.2.6.1.3',
  contactClosureStatus => '1.3.6.1.4.1.1718.3.2.6.1.4',
  contactClosureStatusDefinition => 'Sentry3-MIB::contactClosureStatus',
  branchTable => '1.3.6.1.4.1.1718.3.2.7',
  branchEntry => '1.3.6.1.4.1.1718.3.2.7.1',
  branchIndex => '1.3.6.1.4.1.1718.3.2.7.1.1',
  branchID => '1.3.6.1.4.1.1718.3.2.7.1.2',
  branchName => '1.3.6.1.4.1.1718.3.2.7.1.3',
  branchCapabilities => '1.3.6.1.4.1.1718.3.2.7.1.4',
  branchStatus => '1.3.6.1.4.1.1718.3.2.7.1.5',
  branchStatusDefinition => 'Sentry3-MIB::branchStatus',
  branchLoadStatus => '1.3.6.1.4.1.1718.3.2.7.1.6',
  branchLoadStatusDefinition => 'Sentry3-MIB::branchLoadStatus',
  branchLoadValue => '1.3.6.1.4.1.1718.3.2.7.1.7',
  branchLoadHighThresh => '1.3.6.1.4.1.1718.3.2.7.1.8',
  branchCapacity => '1.3.6.1.4.1.1718.3.2.7.1.9',
  eventInformationGroup => '1.3.6.1.4.1.1718.3.99',
  eventStatusText => '1.3.6.1.4.1.1718.3.99.1',
  eventStatusCondition => '1.3.6.1.4.1.1718.3.99.2',
  eventStatusConditionDefinition => 'Sentry3-MIB::eventStatusCondition',
  sentry3Traps => '1.3.6.1.4.1.1718.3.100',
  events => '1.3.6.1.4.1.1718.3.100.0',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'Sentry3-MIB'} = {
  contactClosureStatus => {
    '0' => 'normal',
    '1' => 'alarm',
    '2' => 'noComm',
  },
  tempHumidSensorTempStatus => {
    '0' => 'normal',
    '1' => 'notFound',
    '2' => 'reading',
    '3' => 'tempLow',
    '4' => 'tempHigh',
    '5' => 'readError',
    '6' => 'lost',
    '7' => 'noComm',
  },
  eventStatusCondition => {
    '0' => 'nonError',
    '1' => 'error',
  },
  outletWakeupState => {
    '1' => 'last',
    '2' => 'off',
    '3' => 'on',
  },
  infeedStatus => {
    '0' => 'off',
    '1' => 'on',
    '2' => 'offWait',
    '3' => 'onWait',
    '4' => 'offError',
    '5' => 'onError',
    '6' => 'noComm',
    '7' => 'reading',
    '8' => 'offFuse',
    '9' => 'onFuse',
  },
  tempHumidSensorHumidStatus => {
    '0' => 'normal',
    '1' => 'notFound',
    '2' => 'reading',
    '3' => 'humidLow',
    '4' => 'humidHigh',
    '5' => 'readError',
    '6' => 'lost',
    '7' => 'noComm',
  },
  tempHumidSensorTempScale => {
    '0' => 'celsius',
    '1' => 'fahrenheit',
  },
  systemAreaUnit => {
    '0' => 'squareMeter',
    '1' => 'squareFoot',
  },
  outletStatus => {
    '0' => 'off',
    '1' => 'on',
    '2' => 'offWait',
    '3' => 'onWait',
    '4' => 'offError',
    '5' => 'onError',
    '6' => 'noComm',
    '7' => 'reading',
    '8' => 'offFuse',
    '9' => 'onFuse',
  },
  infeedReactance => {
    '0' => 'unknown',
    '1' => 'capacitive',
    '2' => 'inductive',
    '3' => 'resistive',
  },
  branchStatus => {
    '0' => 'off',
    '1' => 'on',
    '2' => 'offWait',
    '3' => 'onWait',
    '4' => 'offError',
    '5' => 'onError',
    '6' => 'noComm',
    '7' => 'reading',
    '8' => 'offFuse',
    '9' => 'onFuse',
  },
  infeedLoadStatus => {
    '0' => 'normal',
    '1' => 'notOn',
    '2' => 'reading',
    '3' => 'loadLow',
    '4' => 'loadHigh',
    '5' => 'overLoad',
    '6' => 'readError',
    '7' => 'noComm',
  },
  tempHumidSensorStatus => {
    '0' => 'found',
    '1' => 'notFound',
    '2' => 'lost',
    '3' => 'noComm',
  },
  outletLoadStatus => {
    '0' => 'normal',
    '1' => 'notOn',
    '2' => 'reading',
    '3' => 'loadLow',
    '4' => 'loadHigh',
    '5' => 'overLoad',
    '6' => 'readError',
    '7' => 'noComm',
  },
  envMonADCStatus => {
    '0' => 'normal',
    '1' => 'reading',
    '2' => 'countLow',
    '3' => 'countHigh',
    '4' => 'readError',
    '5' => 'noComm',
  },
  branchLoadStatus => {
    '0' => 'normal',
    '1' => 'notOn',
    '2' => 'reading',
    '3' => 'loadLow',
    '4' => 'loadHigh',
    '5' => 'overLoad',
    '6' => 'readError',
    '7' => 'noComm',
  },
  outletControlState => {
    '0' => 'idleOff',
    '1' => 'idleOn',
    '2' => 'wakeOff',
    '3' => 'wakeOn',
    '4' => 'off',
    '5' => 'on',
    '6' => 'lockedOff',
    '7' => 'lockedOn',
    '8' => 'reboot',
    '9' => 'shutdown',
    '10' => 'pendOn',
    '11' => 'pendOff',
    '12' => 'minimumOff',
    '13' => 'minimumOn',
    '14' => 'eventOff',
    '15' => 'eventOn',
    '16' => 'eventReboot',
    '17' => 'eventShutdown',
  },
  envMonWaterSensorStatus => {
    '0' => 'normal',
    '1' => 'alarm',
    '2' => 'noComm',
  },
  envMonStatus => {
    '0' => 'normal',
    '1' => 'noComm',
  },
  outletControlAction => {
    '0' => 'none',
    '1' => 'on',
    '2' => 'off',
    '3' => 'reboot',
  },
  towerStatus => {
    '0' => 'normal',
    '1' => 'noComm',
    '2' => 'fanFail',
    '3' => 'overTemp',
    '4' => 'nvmFail',
    '5' => 'outOfBalance',
  },
};

1;

__END__

