#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_TestCase__Point_3b__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3b__x = -1;
static int32_t FIELD_ID_TestCase__Point_3b__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3b__y = -1;
static int32_t FIELD_ID_TestCase__Point_3b__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3b__z = -1;
static int32_t FIELD_ID_TestCase__Point_3d__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3d__x = -1;
static int32_t FIELD_ID_TestCase__Point_3d__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3d__y = -1;
static int32_t FIELD_ID_TestCase__Point_3d__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3d__z = -1;
static int32_t FIELD_ID_TestCase__Point_3f__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3f__x = -1;
static int32_t FIELD_ID_TestCase__Point_3f__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3f__y = -1;
static int32_t FIELD_ID_TestCase__Point_3f__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3f__z = -1;
static int32_t FIELD_ID_TestCase__Point_3i__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3i__x = -1;
static int32_t FIELD_ID_TestCase__Point_3i__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3i__y = -1;
static int32_t FIELD_ID_TestCase__Point_3i__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3i__z = -1;
static int32_t FIELD_ID_TestCase__Point_3l__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3l__x = -1;
static int32_t FIELD_ID_TestCase__Point_3l__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3l__y = -1;
static int32_t FIELD_ID_TestCase__Point_3l__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3l__z = -1;
static int32_t FIELD_ID_TestCase__Point_3s__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3s__x = -1;
static int32_t FIELD_ID_TestCase__Point_3s__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3s__y = -1;
static int32_t FIELD_ID_TestCase__Point_3s__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3s__z = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x11 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x11 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x21 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x21 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x31 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x31 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x41 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x41 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x12 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x12 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x22 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x22 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x32 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x32 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x42 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x42 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x13 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x13 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x23 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x23 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x33 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x33 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x43 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x43 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x14 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x14 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x24 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x24 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x34 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x34 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x44 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x44 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x11 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x11 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x21 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x21 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x31 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x31 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x41 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x41 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x12 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x12 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x22 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x22 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x32 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x32 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x42 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x42 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x13 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x13 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x23 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x23 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x33 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x33 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x43 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x43 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x14 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x14 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x24 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x24 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x34 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x34 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x44 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x44 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x11 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x11 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x21 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x21 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x31 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x31 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x41 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x41 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x12 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x12 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x22 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x22 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x32 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x32 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x42 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x42 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x13 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x13 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x23 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x23 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x33 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x33 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x43 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x43 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x14 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x14 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x24 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x24 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x34 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x34 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x44 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x44 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x11 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x11 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x21 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x21 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x31 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x31 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x41 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x41 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x12 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x12 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x22 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x22 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x32 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x32 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x42 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x42 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x13 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x13 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x23 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x23 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x33 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x33 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x43 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x43 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x14 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x14 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x24 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x24 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x34 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x34 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x44 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x44 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x11 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x11 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x21 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x21 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x31 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x31 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x41 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x41 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x12 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x12 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x22 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x22 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x32 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x32 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x42 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x42 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x13 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x13 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x23 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x23 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x33 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x33 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x43 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x43 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x14 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x14 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x24 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x24 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x34 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x34 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x44 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x44 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x11 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x11 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x21 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x21 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x31 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x31 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x41 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x41 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x12 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x12 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x22 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x22 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x32 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x32 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x42 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x42 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x13 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x13 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x23 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x23 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x33 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x33 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x43 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x43 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x14 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x14 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x24 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x24 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x34 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x34 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x44 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x44 = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__Util__INT8_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT16_MIN = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_TestCase__Point_3b = -1;
static int32_t BASIC_TYPE_ID_TestCase__Point_3d = -1;
static int32_t BASIC_TYPE_ID_TestCase__Point_3f = -1;
static int32_t BASIC_TYPE_ID_TestCase__Point_3i = -1;
static int32_t BASIC_TYPE_ID_TestCase__Point_3l = -1;
static int32_t BASIC_TYPE_ID_TestCase__Point_3s = -1;
static int32_t BASIC_TYPE_ID_TestCase__Matrix4_16b = -1;
static int32_t BASIC_TYPE_ID_TestCase__Matrix4_16d = -1;
static int32_t BASIC_TYPE_ID_TestCase__Matrix4_16f = -1;
static int32_t BASIC_TYPE_ID_TestCase__Matrix4_16i = -1;
static int32_t BASIC_TYPE_ID_TestCase__Matrix4_16l = -1;
static int32_t BASIC_TYPE_ID_TestCase__Matrix4_16s = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__array_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__array_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__array_field_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__array_field_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__array_field_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__array_field_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__array_field_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__array_field_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__array_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__array_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__array_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__array_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__move_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__move_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__move_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__move_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__move_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__move_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__value_array_max_fields_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__value_array_max_fields_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__value_array_max_fields_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__value_array_max_fields_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__value_array_max_fields_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ValueArray__value_array_max_fields_short(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__ValueArray__array_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[5];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3b < 0) {
      BASIC_TYPE_ID_TestCase__Point_3b = env->get_basic_type_id(env, "TestCase::Point_3b");
      if (BASIC_TYPE_ID_TestCase__Point_3b < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3b");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3b;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 714;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L5: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 715;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L7: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L9: // MOVE_INT
  int_vars[3] = int_vars[2];
L10: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = byte_vars[1];
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 715;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L12: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 716;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L14: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L16: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L17: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L19: // MOVE_INT
  int_vars[6] = int_vars[5];
L20: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = byte_vars[1];
      }
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 716;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L22: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 717;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L24: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L26: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L27: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L29: // MOVE_INT
  int_vars[6] = int_vars[5];
L30: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = byte_vars[1];
      }
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 717;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 10;
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L34: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3b < 0) {
      BASIC_TYPE_ID_TestCase__Point_3b = env->get_basic_type_id(env, "TestCase::Point_3b");
      if (BASIC_TYPE_ID_TestCase__Point_3b < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3b");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3b;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 719;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L37: // MULNUM_ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[2] = ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
        byte_vars[3] = ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
        byte_vars[4] = ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 720;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L40: // MULNUM_ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
      ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = byte_vars[2];
      ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = byte_vars[3];
      ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = byte_vars[4];
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 720;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L43: // MOVE_INT
  int_vars[3] = int_vars[2];
L44: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 722;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L47: // MOVE_INT
  int_vars[3] = int_vars[2];
L48: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 723;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L51: // MOVE_INT
  int_vars[3] = int_vars[2];
L52: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[2] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 724;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L54: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L55: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[3] = *(int8_t*)&stack[0];
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 726;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L57: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[3];
L58: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L76; }
L61: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[1];
L62: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[3] = *(int8_t*)&stack[0];
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 726;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L64: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[3];
L65: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L66: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L67: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L73; }
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L71: // BOOL_INT
  int_vars[0] = int_vars[2];
L72: // GOTO
  goto L75;
L73: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L74: // BOOL_INT
  int_vars[0] = int_vars[3];
L75: // GOTO
  goto L78;
L76: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L77: // BOOL_INT
  int_vars[0] = int_vars[4];
L78: // BOOL_INT
  int_vars[0] = int_vars[0];
L79: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L80: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L81: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[3] = *(int8_t*)&stack[0];
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 726;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L83: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[3];
L84: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L85: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L86: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L90: // BOOL_INT
  int_vars[0] = int_vars[2];
L91: // GOTO
  goto L94;
L92: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L93: // BOOL_INT
  int_vars[0] = int_vars[3];
L94: // GOTO
  goto L97;
L95: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L96: // BOOL_INT
  int_vars[0] = int_vars[4];
L97: // BOOL_INT
  int_vars[0] = int_vars[0];
L98: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L102; }
L99: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L106;
L101: // GOTO
  goto L102;
L102: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L103: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L106;
L104: // INIT_INT
  int_vars[6] = 0;
L105: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L106;
L106: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L107: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__array_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[6];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3d < 0) {
      BASIC_TYPE_ID_TestCase__Point_3d = env->get_basic_type_id(env, "TestCase::Point_3d");
      if (BASIC_TYPE_ID_TestCase__Point_3d < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3d");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3d;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 815;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L5: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 816;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L8: // MOVE_INT
  int_vars[3] = int_vars[2];
L9: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = double_vars[0];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 816;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L11: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 817;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L13: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L14: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L16: // MOVE_INT
  int_vars[3] = int_vars[2];
L17: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = double_vars[2];
      }
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 817;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L19: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 818;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L21: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L22: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L24: // MOVE_INT
  int_vars[3] = int_vars[2];
L25: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = double_vars[2];
      }
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 818;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 10;
L28: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L29: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3d < 0) {
      BASIC_TYPE_ID_TestCase__Point_3d = env->get_basic_type_id(env, "TestCase::Point_3d");
      if (BASIC_TYPE_ID_TestCase__Point_3d < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3d");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3d;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 820;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L32: // MULNUM_ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
        double_vars[1] = ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
        double_vars[2] = ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 821;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L34: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L35: // MULNUM_ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
      ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = double_vars[0];
      ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = double_vars[1];
      ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = double_vars[2];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 821;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L38: // MOVE_INT
  int_vars[3] = int_vars[2];
L39: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 823;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L42: // MOVE_INT
  int_vars[3] = int_vars[2];
L43: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 824;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L45: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L46: // MOVE_INT
  int_vars[3] = int_vars[2];
L47: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[2] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 825;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L49: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 827;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L51: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[3]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L67; }
L54: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 827;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L56: // MOVE_CONSTANT_DOUBLE
  double_vars[4] = 0.25;
L57: // ADD_DOUBLE
  double_vars[5] = double_vars[3] + double_vars[4];
L58: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[5]);
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L64; }
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L62: // BOOL_INT
  int_vars[0] = int_vars[2];
L63: // GOTO
  goto L66;
L64: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L65: // BOOL_INT
  int_vars[0] = int_vars[3];
L66: // GOTO
  goto L69;
L67: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L68: // BOOL_INT
  int_vars[0] = int_vars[4];
L69: // BOOL_INT
  int_vars[0] = int_vars[0];
L70: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L71: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 827;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L73: // MOVE_CONSTANT_DOUBLE
  double_vars[4] = 0.5;
L74: // ADD_DOUBLE
  double_vars[5] = double_vars[3] + double_vars[4];
L75: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[5]);
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L81; }
L78: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L79: // BOOL_INT
  int_vars[0] = int_vars[2];
L80: // GOTO
  goto L83;
L81: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L82: // BOOL_INT
  int_vars[0] = int_vars[3];
L83: // GOTO
  goto L86;
L84: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L85: // BOOL_INT
  int_vars[0] = int_vars[4];
L86: // BOOL_INT
  int_vars[0] = int_vars[0];
L87: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L91; }
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L89: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L90: // GOTO
  goto L91;
L91: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L95;
L93: // INIT_INT
  int_vars[6] = 0;
L94: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L95;
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__array_field_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[4];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3b < 0) {
      BASIC_TYPE_ID_TestCase__Point_3b = env->get_basic_type_id(env, "TestCase::Point_3b");
      if (BASIC_TYPE_ID_TestCase__Point_3b < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3b");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3b;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 835;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L5: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 836;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L7: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L9: // MOVE_INT
  int_vars[3] = int_vars[2];
L10: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = byte_vars[1];
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 836;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L12: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 837;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L14: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L16: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L17: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L19: // MOVE_INT
  int_vars[6] = int_vars[5];
L20: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = byte_vars[1];
      }
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 837;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L22: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 838;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L24: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L26: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L27: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L29: // MOVE_INT
  int_vars[6] = int_vars[5];
L30: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = byte_vars[1];
      }
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 838;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L33: // MOVE_INT
  int_vars[3] = int_vars[2];
L34: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 840;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L37: // MOVE_INT
  int_vars[3] = int_vars[2];
L38: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 841;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L41: // MOVE_INT
  int_vars[3] = int_vars[2];
L42: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[2] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 842;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L44: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L45: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[3] = *(int8_t*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 844;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L47: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[3];
L48: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L66; }
L51: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[1];
L52: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[3] = *(int8_t*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 844;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L54: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[3];
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L56: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L57: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L58: // BOOL_INT
  int_vars[0] = int_vars[0];
L59: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L63; }
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L61: // BOOL_INT
  int_vars[0] = int_vars[2];
L62: // GOTO
  goto L65;
L63: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L64: // BOOL_INT
  int_vars[0] = int_vars[3];
L65: // GOTO
  goto L68;
L66: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L67: // BOOL_INT
  int_vars[0] = int_vars[4];
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L70: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L71: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[3] = *(int8_t*)&stack[0];
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 844;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L73: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[3];
L74: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L75: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L76: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L77: // BOOL_INT
  int_vars[0] = int_vars[0];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L80: // BOOL_INT
  int_vars[0] = int_vars[2];
L81: // GOTO
  goto L84;
L82: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L83: // BOOL_INT
  int_vars[0] = int_vars[3];
L84: // GOTO
  goto L87;
L85: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L86: // BOOL_INT
  int_vars[0] = int_vars[4];
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L96;
L91: // GOTO
  goto L92;
L92: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L96;
L94: // INIT_INT
  int_vars[6] = 0;
L95: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L96;
L96: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L97: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__array_field_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[6];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3d < 0) {
      BASIC_TYPE_ID_TestCase__Point_3d = env->get_basic_type_id(env, "TestCase::Point_3d");
      if (BASIC_TYPE_ID_TestCase__Point_3d < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3d");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3d;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 921;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L5: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 922;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L8: // MOVE_INT
  int_vars[3] = int_vars[2];
L9: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = double_vars[0];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 922;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L11: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 923;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L13: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L14: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L16: // MOVE_INT
  int_vars[3] = int_vars[2];
L17: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = double_vars[2];
      }
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 923;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L19: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 924;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L21: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L22: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L24: // MOVE_INT
  int_vars[3] = int_vars[2];
L25: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = double_vars[2];
      }
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 924;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L28: // MOVE_INT
  int_vars[3] = int_vars[2];
L29: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 926;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L32: // MOVE_INT
  int_vars[3] = int_vars[2];
L33: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 927;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L36: // MOVE_INT
  int_vars[3] = int_vars[2];
L37: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[2] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 928;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L39: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 930;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L41: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[3]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L44: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 930;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L46: // MOVE_CONSTANT_DOUBLE
  double_vars[4] = 0.25;
L47: // ADD_DOUBLE
  double_vars[5] = double_vars[3] + double_vars[4];
L48: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[5]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L52: // BOOL_INT
  int_vars[0] = int_vars[2];
L53: // GOTO
  goto L56;
L54: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L55: // BOOL_INT
  int_vars[0] = int_vars[3];
L56: // GOTO
  goto L59;
L57: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L58: // BOOL_INT
  int_vars[0] = int_vars[4];
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L74; }
L61: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 930;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L63: // MOVE_CONSTANT_DOUBLE
  double_vars[4] = 0.5;
L64: // ADD_DOUBLE
  double_vars[5] = double_vars[3] + double_vars[4];
L65: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[5]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L71; }
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L69: // BOOL_INT
  int_vars[0] = int_vars[2];
L70: // GOTO
  goto L73;
L71: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L72: // BOOL_INT
  int_vars[0] = int_vars[3];
L73: // GOTO
  goto L76;
L74: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L75: // BOOL_INT
  int_vars[0] = int_vars[4];
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L81; }
L78: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L79: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L85;
L80: // GOTO
  goto L81;
L81: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L85;
L83: // INIT_INT
  int_vars[6] = 0;
L84: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L85;
L85: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L86: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__array_field_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[4];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3f < 0) {
      BASIC_TYPE_ID_TestCase__Point_3f = env->get_basic_type_id(env, "TestCase::Point_3f");
      if (BASIC_TYPE_ID_TestCase__Point_3f < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3f");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3f;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 904;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L5: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 905;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L8: // MOVE_INT
  int_vars[3] = int_vars[2];
L9: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = float_vars[0];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 905;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L11: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 906;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L13: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.25;
L14: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L16: // MOVE_INT
  int_vars[3] = int_vars[2];
L17: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = float_vars[2];
      }
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 906;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L19: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 907;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L21: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L22: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L24: // MOVE_INT
  int_vars[3] = int_vars[2];
L25: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = float_vars[2];
      }
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 907;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L28: // MOVE_INT
  int_vars[3] = int_vars[2];
L29: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 909;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L32: // MOVE_INT
  int_vars[3] = int_vars[2];
L33: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 910;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L36: // MOVE_INT
  int_vars[3] = int_vars[2];
L37: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[2] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 911;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L39: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 913;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L41: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[3]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L59; }
L44: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[1];
L45: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 913;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L47: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[1] = (double)float_vars[3];
L48: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 0.25;
L49: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[2];
L50: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[3]);
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L56; }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L54: // BOOL_INT
  int_vars[0] = int_vars[2];
L55: // GOTO
  goto L58;
L56: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L57: // BOOL_INT
  int_vars[0] = int_vars[3];
L58: // GOTO
  goto L61;
L59: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L60: // BOOL_INT
  int_vars[0] = int_vars[4];
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L78; }
L63: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[2];
L64: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 913;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L66: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[1] = (double)float_vars[3];
L67: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 0.5;
L68: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[2];
L69: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[3]);
L70: // BOOL_INT
  int_vars[0] = int_vars[0];
L71: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L75; }
L72: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L73: // BOOL_INT
  int_vars[0] = int_vars[2];
L74: // GOTO
  goto L77;
L75: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L76: // BOOL_INT
  int_vars[0] = int_vars[3];
L77: // GOTO
  goto L80;
L78: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L79: // BOOL_INT
  int_vars[0] = int_vars[4];
L80: // BOOL_INT
  int_vars[0] = int_vars[0];
L81: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L83: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L89;
L84: // GOTO
  goto L85;
L85: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L86: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L89;
L87: // INIT_INT
  int_vars[6] = 0;
L88: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L89;
L89: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L90: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__array_field_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
      BASIC_TYPE_ID_TestCase__Point_3i = env->get_basic_type_id(env, "TestCase::Point_3i");
      if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3i;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 870;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L5: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 871;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 9;
L8: // MOVE_INT
  int_vars[4] = int_vars[3];
L9: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = int_vars[2];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 871;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L11: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 872;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L14: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L16: // MOVE_INT
  int_vars[6] = int_vars[5];
L17: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = int_vars[4];
      }
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 872;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L19: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 873;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L22: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L23: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L24: // MOVE_INT
  int_vars[6] = int_vars[5];
L25: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = int_vars[4];
      }
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 873;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L28: // MOVE_INT
  int_vars[3] = int_vars[2];
L29: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 875;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L32: // MOVE_INT
  int_vars[3] = int_vars[2];
L33: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 876;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L36: // MOVE_INT
  int_vars[3] = int_vars[2];
L37: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 877;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L39: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 879;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L41: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L44: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 879;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L47: // ADD_INT
  int_vars[7] = int_vars[2] + int_vars[3];
L48: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L52: // BOOL_INT
  int_vars[0] = int_vars[2];
L53: // GOTO
  goto L56;
L54: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L55: // BOOL_INT
  int_vars[0] = int_vars[3];
L56: // GOTO
  goto L59;
L57: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L58: // BOOL_INT
  int_vars[0] = int_vars[7];
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L74; }
L61: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 879;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L63: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L64: // ADD_INT
  int_vars[7] = int_vars[2] + int_vars[3];
L65: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L71; }
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L69: // BOOL_INT
  int_vars[0] = int_vars[2];
L70: // GOTO
  goto L73;
L71: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L72: // BOOL_INT
  int_vars[0] = int_vars[3];
L73: // GOTO
  goto L76;
L74: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L75: // BOOL_INT
  int_vars[0] = int_vars[7];
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L81; }
L78: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L79: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L85;
L80: // GOTO
  goto L81;
L81: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L85;
L83: // INIT_INT
  int_vars[9] = 0;
L84: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L85;
L85: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L86: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__array_field_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[6];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3l < 0) {
      BASIC_TYPE_ID_TestCase__Point_3l = env->get_basic_type_id(env, "TestCase::Point_3l");
      if (BASIC_TYPE_ID_TestCase__Point_3l < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3l");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3l;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 887;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L5: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 888;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L8: // MOVE_INT
  int_vars[3] = int_vars[2];
L9: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = long_vars[0];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 888;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L11: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 889;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L15: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L16: // MOVE_CONSTANT_INT
  int_vars[3] = 9;
L17: // MOVE_INT
  int_vars[4] = int_vars[3];
L18: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = long_vars[2];
      }
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 889;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L20: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 890;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L23: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L24: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 9;
L26: // MOVE_INT
  int_vars[4] = int_vars[3];
L27: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = long_vars[2];
      }
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 890;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L30: // MOVE_INT
  int_vars[3] = int_vars[2];
L31: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 892;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L34: // MOVE_INT
  int_vars[3] = int_vars[2];
L35: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 893;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L38: // MOVE_INT
  int_vars[3] = int_vars[2];
L39: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[2] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 894;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L41: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[3] = *(int64_t*)&stack[0];
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 896;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L43: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[3]);
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L60; }
L46: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[3] = *(int64_t*)&stack[0];
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 896;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L48: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L49: // CONVERT_INT_TO_LONG
  long_vars[4] = (int64_t)int_vars[2];
L50: // ADD_LONG
  long_vars[5] = long_vars[3] + long_vars[4];
L51: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[5]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L55: // BOOL_INT
  int_vars[0] = int_vars[2];
L56: // GOTO
  goto L59;
L57: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L58: // BOOL_INT
  int_vars[0] = int_vars[3];
L59: // GOTO
  goto L62;
L60: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L61: // BOOL_INT
  int_vars[0] = int_vars[4];
L62: // BOOL_INT
  int_vars[0] = int_vars[0];
L63: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L78; }
L64: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[3] = *(int64_t*)&stack[0];
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 896;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L67: // CONVERT_INT_TO_LONG
  long_vars[4] = (int64_t)int_vars[2];
L68: // ADD_LONG
  long_vars[5] = long_vars[3] + long_vars[4];
L69: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[5]);
L70: // BOOL_INT
  int_vars[0] = int_vars[0];
L71: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L75; }
L72: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L73: // BOOL_INT
  int_vars[0] = int_vars[2];
L74: // GOTO
  goto L77;
L75: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L76: // BOOL_INT
  int_vars[0] = int_vars[3];
L77: // GOTO
  goto L80;
L78: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L79: // BOOL_INT
  int_vars[0] = int_vars[4];
L80: // BOOL_INT
  int_vars[0] = int_vars[0];
L81: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L83: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L89;
L84: // GOTO
  goto L85;
L85: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L86: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L89;
L87: // INIT_INT
  int_vars[6] = 0;
L88: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L89;
L89: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L90: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__array_field_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[4];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3s < 0) {
      BASIC_TYPE_ID_TestCase__Point_3s = env->get_basic_type_id(env, "TestCase::Point_3s");
      if (BASIC_TYPE_ID_TestCase__Point_3s < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3s");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3s;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 853;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L5: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 854;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L7: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L9: // MOVE_INT
  int_vars[3] = int_vars[2];
L10: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = short_vars[1];
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 854;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L12: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 855;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L14: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L16: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L17: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L19: // MOVE_INT
  int_vars[6] = int_vars[5];
L20: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = short_vars[1];
      }
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 855;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L22: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 856;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L24: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L26: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L27: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L29: // MOVE_INT
  int_vars[6] = int_vars[5];
L30: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = short_vars[1];
      }
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 856;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L33: // MOVE_INT
  int_vars[3] = int_vars[2];
L34: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 858;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L37: // MOVE_INT
  int_vars[3] = int_vars[2];
L38: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[1] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 859;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L41: // MOVE_INT
  int_vars[3] = int_vars[2];
L42: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[2] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 860;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L44: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L45: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[3] = *(int16_t*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 862;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L47: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[3];
L48: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L66; }
L51: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[1];
L52: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[3] = *(int16_t*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 862;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L54: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[3];
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L56: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L57: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L58: // BOOL_INT
  int_vars[0] = int_vars[0];
L59: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L63; }
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L61: // BOOL_INT
  int_vars[0] = int_vars[2];
L62: // GOTO
  goto L65;
L63: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L64: // BOOL_INT
  int_vars[0] = int_vars[3];
L65: // GOTO
  goto L68;
L66: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L67: // BOOL_INT
  int_vars[0] = int_vars[4];
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L70: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L71: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[3] = *(int16_t*)&stack[0];
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_field_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 862;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L73: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[3];
L74: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L75: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L76: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L77: // BOOL_INT
  int_vars[0] = int_vars[0];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L80: // BOOL_INT
  int_vars[0] = int_vars[2];
L81: // GOTO
  goto L84;
L82: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L83: // BOOL_INT
  int_vars[0] = int_vars[3];
L84: // GOTO
  goto L87;
L85: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L86: // BOOL_INT
  int_vars[0] = int_vars[4];
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L96;
L91: // GOTO
  goto L92;
L92: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L96;
L94: // INIT_INT
  int_vars[6] = 0;
L95: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L96;
L96: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L97: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__array_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[4];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3f < 0) {
      BASIC_TYPE_ID_TestCase__Point_3f = env->get_basic_type_id(env, "TestCase::Point_3f");
      if (BASIC_TYPE_ID_TestCase__Point_3f < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3f");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3f;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 795;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L5: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 796;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L8: // MOVE_INT
  int_vars[3] = int_vars[2];
L9: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = float_vars[0];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 796;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L11: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 797;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L13: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.25;
L14: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L16: // MOVE_INT
  int_vars[3] = int_vars[2];
L17: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = float_vars[2];
      }
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 797;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L19: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 798;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L21: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L22: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L24: // MOVE_INT
  int_vars[3] = int_vars[2];
L25: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = float_vars[2];
      }
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 798;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 10;
L28: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L29: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3f < 0) {
      BASIC_TYPE_ID_TestCase__Point_3f = env->get_basic_type_id(env, "TestCase::Point_3f");
      if (BASIC_TYPE_ID_TestCase__Point_3f < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3f");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3f;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 800;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L32: // MULNUM_ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
        float_vars[1] = ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
        float_vars[2] = ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 801;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L34: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L35: // MULNUM_ARRAY_STORE_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
      ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = float_vars[0];
      ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = float_vars[1];
      ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = float_vars[2];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 801;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L38: // MOVE_INT
  int_vars[3] = int_vars[2];
L39: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 803;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L42: // MOVE_INT
  int_vars[3] = int_vars[2];
L43: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 804;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L45: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L46: // MOVE_INT
  int_vars[3] = int_vars[2];
L47: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[2] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 805;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L49: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 807;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L51: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[3]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L69; }
L54: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[1];
L55: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 807;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L57: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[1] = (double)float_vars[3];
L58: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 0.25;
L59: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[2];
L60: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[3]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L66; }
L63: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L64: // BOOL_INT
  int_vars[0] = int_vars[2];
L65: // GOTO
  goto L68;
L66: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L67: // BOOL_INT
  int_vars[0] = int_vars[3];
L68: // GOTO
  goto L71;
L69: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L70: // BOOL_INT
  int_vars[0] = int_vars[4];
L71: // BOOL_INT
  int_vars[0] = int_vars[0];
L72: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L88; }
L73: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[2];
L74: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 807;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L76: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[1] = (double)float_vars[3];
L77: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 0.5;
L78: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[2];
L79: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[3]);
L80: // BOOL_INT
  int_vars[0] = int_vars[0];
L81: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L83: // BOOL_INT
  int_vars[0] = int_vars[2];
L84: // GOTO
  goto L87;
L85: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L86: // BOOL_INT
  int_vars[0] = int_vars[3];
L87: // GOTO
  goto L90;
L88: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L89: // BOOL_INT
  int_vars[0] = int_vars[4];
L90: // BOOL_INT
  int_vars[0] = int_vars[0];
L91: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L92: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L99;
L94: // GOTO
  goto L95;
L95: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L96: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L99;
L97: // INIT_INT
  int_vars[6] = 0;
L98: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L99;
L99: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L100: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__array_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
      BASIC_TYPE_ID_TestCase__Point_3i = env->get_basic_type_id(env, "TestCase::Point_3i");
      if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3i;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 755;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L5: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 756;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 9;
L8: // MOVE_INT
  int_vars[4] = int_vars[3];
L9: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = int_vars[2];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 756;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L11: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 757;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L14: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L16: // MOVE_INT
  int_vars[6] = int_vars[5];
L17: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = int_vars[4];
      }
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 757;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L19: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 758;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L22: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L23: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L24: // MOVE_INT
  int_vars[6] = int_vars[5];
L25: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = int_vars[4];
      }
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 758;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 10;
L28: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L29: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
      BASIC_TYPE_ID_TestCase__Point_3i = env->get_basic_type_id(env, "TestCase::Point_3i");
      if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3i;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 760;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L32: // MULNUM_ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
        int_vars[5] = ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 761;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L34: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L35: // MULNUM_ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
      ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = int_vars[3];
      ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = int_vars[4];
      ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = int_vars[5];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 761;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L38: // MOVE_INT
  int_vars[3] = int_vars[2];
L39: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 763;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L42: // MOVE_INT
  int_vars[3] = int_vars[2];
L43: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 764;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L45: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L46: // MOVE_INT
  int_vars[3] = int_vars[2];
L47: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 765;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L49: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 767;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L51: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L67; }
L54: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 767;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L56: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L57: // ADD_INT
  int_vars[7] = int_vars[2] + int_vars[3];
L58: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L64; }
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L62: // BOOL_INT
  int_vars[0] = int_vars[2];
L63: // GOTO
  goto L66;
L64: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L65: // BOOL_INT
  int_vars[0] = int_vars[3];
L66: // GOTO
  goto L69;
L67: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L68: // BOOL_INT
  int_vars[0] = int_vars[7];
L69: // BOOL_INT
  int_vars[0] = int_vars[0];
L70: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L71: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 767;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L73: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L74: // ADD_INT
  int_vars[7] = int_vars[2] + int_vars[3];
L75: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L81; }
L78: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L79: // BOOL_INT
  int_vars[0] = int_vars[2];
L80: // GOTO
  goto L83;
L81: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L82: // BOOL_INT
  int_vars[0] = int_vars[3];
L83: // GOTO
  goto L86;
L84: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L85: // BOOL_INT
  int_vars[0] = int_vars[7];
L86: // BOOL_INT
  int_vars[0] = int_vars[0];
L87: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L91; }
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L89: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L90: // GOTO
  goto L91;
L91: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L95;
L93: // INIT_INT
  int_vars[9] = 0;
L94: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L95;
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__array_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[6];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3l < 0) {
      BASIC_TYPE_ID_TestCase__Point_3l = env->get_basic_type_id(env, "TestCase::Point_3l");
      if (BASIC_TYPE_ID_TestCase__Point_3l < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3l");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3l;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 775;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L5: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 776;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L8: // MOVE_INT
  int_vars[3] = int_vars[2];
L9: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = long_vars[0];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 776;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L11: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 777;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L15: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L16: // MOVE_CONSTANT_INT
  int_vars[3] = 9;
L17: // MOVE_INT
  int_vars[4] = int_vars[3];
L18: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = long_vars[2];
      }
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 777;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L20: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 778;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L23: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L24: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 9;
L26: // MOVE_INT
  int_vars[4] = int_vars[3];
L27: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = long_vars[2];
      }
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 778;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 10;
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L31: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3l < 0) {
      BASIC_TYPE_ID_TestCase__Point_3l = env->get_basic_type_id(env, "TestCase::Point_3l");
      if (BASIC_TYPE_ID_TestCase__Point_3l < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3l");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3l;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 780;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L34: // MULNUM_ARRAY_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
        long_vars[1] = ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
        long_vars[2] = ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 781;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L37: // MULNUM_ARRAY_STORE_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
      ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = long_vars[0];
      ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = long_vars[1];
      ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = long_vars[2];
      } 
    } 
  } 
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 781;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L40: // MOVE_INT
  int_vars[3] = int_vars[2];
L41: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 783;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L44: // MOVE_INT
  int_vars[3] = int_vars[2];
L45: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 784;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L48: // MOVE_INT
  int_vars[3] = int_vars[2];
L49: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[2] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 785;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L51: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[3] = *(int64_t*)&stack[0];
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 787;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L53: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[3]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L70; }
L56: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[3] = *(int64_t*)&stack[0];
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 787;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L59: // CONVERT_INT_TO_LONG
  long_vars[4] = (int64_t)int_vars[2];
L60: // ADD_LONG
  long_vars[5] = long_vars[3] + long_vars[4];
L61: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[5]);
L62: // BOOL_INT
  int_vars[0] = int_vars[0];
L63: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L67; }
L64: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L65: // BOOL_INT
  int_vars[0] = int_vars[2];
L66: // GOTO
  goto L69;
L67: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L68: // BOOL_INT
  int_vars[0] = int_vars[3];
L69: // GOTO
  goto L72;
L70: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L71: // BOOL_INT
  int_vars[0] = int_vars[4];
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L88; }
L74: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[3] = *(int64_t*)&stack[0];
    }
  }
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 787;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L77: // CONVERT_INT_TO_LONG
  long_vars[4] = (int64_t)int_vars[2];
L78: // ADD_LONG
  long_vars[5] = long_vars[3] + long_vars[4];
L79: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[5]);
L80: // BOOL_INT
  int_vars[0] = int_vars[0];
L81: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L83: // BOOL_INT
  int_vars[0] = int_vars[2];
L84: // GOTO
  goto L87;
L85: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L86: // BOOL_INT
  int_vars[0] = int_vars[3];
L87: // GOTO
  goto L90;
L88: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L89: // BOOL_INT
  int_vars[0] = int_vars[4];
L90: // BOOL_INT
  int_vars[0] = int_vars[0];
L91: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L92: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L99;
L94: // GOTO
  goto L95;
L95: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L96: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L99;
L97: // INIT_INT
  int_vars[6] = 0;
L98: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L99;
L99: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L100: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__array_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[5];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3s < 0) {
      BASIC_TYPE_ID_TestCase__Point_3s = env->get_basic_type_id(env, "TestCase::Point_3s");
      if (BASIC_TYPE_ID_TestCase__Point_3s < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3s");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3s;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 735;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L5: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 736;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L7: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L9: // MOVE_INT
  int_vars[3] = int_vars[2];
L10: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = short_vars[1];
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 736;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L12: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 737;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L14: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L16: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L17: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L19: // MOVE_INT
  int_vars[6] = int_vars[5];
L20: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = short_vars[1];
      }
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 737;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L22: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 738;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L24: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L26: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L27: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L29: // MOVE_INT
  int_vars[6] = int_vars[5];
L30: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = short_vars[1];
      }
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 738;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 10;
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L34: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3s < 0) {
      BASIC_TYPE_ID_TestCase__Point_3s = env->get_basic_type_id(env, "TestCase::Point_3s");
      if (BASIC_TYPE_ID_TestCase__Point_3s < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3s");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3s;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 740;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L37: // MULNUM_ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[2] = ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
        short_vars[3] = ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
        short_vars[4] = ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 741;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L40: // MULNUM_ARRAY_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
      ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = short_vars[2];
      ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = short_vars[3];
      ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = short_vars[4];
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 741;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L43: // MOVE_INT
  int_vars[3] = int_vars[2];
L44: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 743;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L47: // MOVE_INT
  int_vars[3] = int_vars[2];
L48: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[1] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 744;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L51: // MOVE_INT
  int_vars[3] = int_vars[2];
L52: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[2] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 745;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L54: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L55: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[3] = *(int16_t*)&stack[0];
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 747;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L57: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[3];
L58: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L76; }
L61: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[1];
L62: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[3] = *(int16_t*)&stack[0];
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 747;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L64: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[3];
L65: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L66: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L67: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L73; }
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L71: // BOOL_INT
  int_vars[0] = int_vars[2];
L72: // GOTO
  goto L75;
L73: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L74: // BOOL_INT
  int_vars[0] = int_vars[3];
L75: // GOTO
  goto L78;
L76: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L77: // BOOL_INT
  int_vars[0] = int_vars[4];
L78: // BOOL_INT
  int_vars[0] = int_vars[0];
L79: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L80: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L81: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[3] = *(int16_t*)&stack[0];
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "array_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 747;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L106;
  }
L83: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[3];
L84: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L85: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L86: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L90: // BOOL_INT
  int_vars[0] = int_vars[2];
L91: // GOTO
  goto L94;
L92: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L93: // BOOL_INT
  int_vars[0] = int_vars[3];
L94: // GOTO
  goto L97;
L95: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L96: // BOOL_INT
  int_vars[0] = int_vars[4];
L97: // BOOL_INT
  int_vars[0] = int_vars[0];
L98: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L102; }
L99: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L106;
L101: // GOTO
  goto L102;
L102: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L103: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L106;
L104: // INIT_INT
  int_vars[6] = 0;
L105: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L106;
L106: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L107: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__move_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[4];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3b < 0) {
      BASIC_TYPE_ID_TestCase__Point_3b = env->get_basic_type_id(env, "TestCase::Point_3b");
      if (BASIC_TYPE_ID_TestCase__Point_3b < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3b");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3b;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 938;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L5: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 939;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L7: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L9: // MOVE_INT
  int_vars[3] = int_vars[2];
L10: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = byte_vars[1];
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 939;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L12: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 940;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L14: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L16: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L17: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L19: // MOVE_INT
  int_vars[6] = int_vars[5];
L20: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = byte_vars[1];
      }
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 940;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L22: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 941;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L24: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L26: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L27: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L29: // MOVE_INT
  int_vars[6] = int_vars[5];
L30: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = byte_vars[1];
      }
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 941;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L33: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L35: // MOVE_INT
  int_vars[3] = int_vars[2];
L36: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 945;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L39: // MOVE_INT
  int_vars[3] = int_vars[2];
L40: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 946;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L43: // MOVE_INT
  int_vars[3] = int_vars[2];
L44: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[2] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 947;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L46: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L47: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[3] = *(int8_t*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 949;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L49: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[3];
L50: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L68; }
L53: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[1];
L54: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[3] = *(int8_t*)&stack[0];
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 949;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L56: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[3];
L57: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L58: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L59: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L65; }
L62: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L63: // BOOL_INT
  int_vars[0] = int_vars[2];
L64: // GOTO
  goto L67;
L65: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L66: // BOOL_INT
  int_vars[0] = int_vars[3];
L67: // GOTO
  goto L70;
L68: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L69: // BOOL_INT
  int_vars[0] = int_vars[4];
L70: // BOOL_INT
  int_vars[0] = int_vars[0];
L71: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L87; }
L72: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L73: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[3] = *(int8_t*)&stack[0];
    }
  }
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 949;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L75: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[3];
L76: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L77: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L78: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L79: // BOOL_INT
  int_vars[0] = int_vars[0];
L80: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L81: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L82: // BOOL_INT
  int_vars[0] = int_vars[2];
L83: // GOTO
  goto L86;
L84: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L85: // BOOL_INT
  int_vars[0] = int_vars[3];
L86: // GOTO
  goto L89;
L87: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L88: // BOOL_INT
  int_vars[0] = int_vars[4];
L89: // BOOL_INT
  int_vars[0] = int_vars[0];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L98;
L93: // GOTO
  goto L94;
L94: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L95: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L98;
L96: // INIT_INT
  int_vars[6] = 0;
L97: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L98;
L98: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L99: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__move_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[6];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3d < 0) {
      BASIC_TYPE_ID_TestCase__Point_3d = env->get_basic_type_id(env, "TestCase::Point_3d");
      if (BASIC_TYPE_ID_TestCase__Point_3d < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3d");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3d;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1034;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L5: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1035;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L8: // MOVE_INT
  int_vars[3] = int_vars[2];
L9: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = double_vars[0];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1035;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L11: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1036;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L13: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L14: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L16: // MOVE_INT
  int_vars[3] = int_vars[2];
L17: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = double_vars[2];
      }
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1036;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L19: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1037;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L21: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L22: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L24: // MOVE_INT
  int_vars[3] = int_vars[2];
L25: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = double_vars[2];
      }
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1037;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L28: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L30: // MOVE_INT
  int_vars[3] = int_vars[2];
L31: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1041;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L34: // MOVE_INT
  int_vars[3] = int_vars[2];
L35: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1042;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L38: // MOVE_INT
  int_vars[3] = int_vars[2];
L39: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[2] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1043;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L41: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1045;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L43: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[3]);
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L59; }
L46: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1045;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L48: // MOVE_CONSTANT_DOUBLE
  double_vars[4] = 0.25;
L49: // ADD_DOUBLE
  double_vars[5] = double_vars[3] + double_vars[4];
L50: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[5]);
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L56; }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L54: // BOOL_INT
  int_vars[0] = int_vars[2];
L55: // GOTO
  goto L58;
L56: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L57: // BOOL_INT
  int_vars[0] = int_vars[3];
L58: // GOTO
  goto L61;
L59: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L60: // BOOL_INT
  int_vars[0] = int_vars[4];
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L76; }
L63: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1045;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L65: // MOVE_CONSTANT_DOUBLE
  double_vars[4] = 0.5;
L66: // ADD_DOUBLE
  double_vars[5] = double_vars[3] + double_vars[4];
L67: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[5]);
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L73; }
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L71: // BOOL_INT
  int_vars[0] = int_vars[2];
L72: // GOTO
  goto L75;
L73: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L74: // BOOL_INT
  int_vars[0] = int_vars[3];
L75: // GOTO
  goto L78;
L76: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L77: // BOOL_INT
  int_vars[0] = int_vars[4];
L78: // BOOL_INT
  int_vars[0] = int_vars[0];
L79: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L83; }
L80: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L81: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L87;
L82: // GOTO
  goto L83;
L83: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L84: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L87;
L85: // INIT_INT
  int_vars[6] = 0;
L86: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L87;
L87: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L88: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__move_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[4];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3f < 0) {
      BASIC_TYPE_ID_TestCase__Point_3f = env->get_basic_type_id(env, "TestCase::Point_3f");
      if (BASIC_TYPE_ID_TestCase__Point_3f < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3f");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3f;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1015;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L5: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1016;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L8: // MOVE_INT
  int_vars[3] = int_vars[2];
L9: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = float_vars[0];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1016;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L11: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1017;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L13: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.25;
L14: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L16: // MOVE_INT
  int_vars[3] = int_vars[2];
L17: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = float_vars[2];
      }
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1017;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L19: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1018;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L21: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L22: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L24: // MOVE_INT
  int_vars[3] = int_vars[2];
L25: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = float_vars[2];
      }
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1018;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L28: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L30: // MOVE_INT
  int_vars[3] = int_vars[2];
L31: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1022;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L34: // MOVE_INT
  int_vars[3] = int_vars[2];
L35: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1023;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L38: // MOVE_INT
  int_vars[3] = int_vars[2];
L39: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[2] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1024;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L41: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1026;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L43: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[3]);
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L61; }
L46: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[1];
L47: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1026;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L49: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[1] = (double)float_vars[3];
L50: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 0.25;
L51: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[2];
L52: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[3]);
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L58; }
L55: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L56: // BOOL_INT
  int_vars[0] = int_vars[2];
L57: // GOTO
  goto L60;
L58: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L59: // BOOL_INT
  int_vars[0] = int_vars[3];
L60: // GOTO
  goto L63;
L61: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L62: // BOOL_INT
  int_vars[0] = int_vars[4];
L63: // BOOL_INT
  int_vars[0] = int_vars[0];
L64: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L80; }
L65: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[2];
L66: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1026;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L68: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[1] = (double)float_vars[3];
L69: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 0.5;
L70: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[2];
L71: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[3]);
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L77; }
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L75: // BOOL_INT
  int_vars[0] = int_vars[2];
L76: // GOTO
  goto L79;
L77: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L78: // BOOL_INT
  int_vars[0] = int_vars[3];
L79: // GOTO
  goto L82;
L80: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L81: // BOOL_INT
  int_vars[0] = int_vars[4];
L82: // BOOL_INT
  int_vars[0] = int_vars[0];
L83: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L87; }
L84: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L85: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L91;
L86: // GOTO
  goto L87;
L87: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L88: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L91;
L89: // INIT_INT
  int_vars[6] = 0;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L91;
L91: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L92: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__move_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
      BASIC_TYPE_ID_TestCase__Point_3i = env->get_basic_type_id(env, "TestCase::Point_3i");
      if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3i;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 977;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L5: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 978;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 9;
L8: // MOVE_INT
  int_vars[4] = int_vars[3];
L9: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = int_vars[2];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 978;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L11: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 979;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L14: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L16: // MOVE_INT
  int_vars[6] = int_vars[5];
L17: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = int_vars[4];
      }
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 979;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L19: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 980;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L22: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L23: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L24: // MOVE_INT
  int_vars[6] = int_vars[5];
L25: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = int_vars[4];
      }
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 980;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L28: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L30: // MOVE_INT
  int_vars[3] = int_vars[2];
L31: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 984;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L34: // MOVE_INT
  int_vars[3] = int_vars[2];
L35: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 985;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L38: // MOVE_INT
  int_vars[3] = int_vars[2];
L39: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 986;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L41: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 988;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L43: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L59; }
L46: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 988;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L48: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L49: // ADD_INT
  int_vars[7] = int_vars[2] + int_vars[3];
L50: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L56; }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L54: // BOOL_INT
  int_vars[0] = int_vars[2];
L55: // GOTO
  goto L58;
L56: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L57: // BOOL_INT
  int_vars[0] = int_vars[3];
L58: // GOTO
  goto L61;
L59: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L60: // BOOL_INT
  int_vars[0] = int_vars[7];
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L76; }
L63: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 988;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L66: // ADD_INT
  int_vars[7] = int_vars[2] + int_vars[3];
L67: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L73; }
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L71: // BOOL_INT
  int_vars[0] = int_vars[2];
L72: // GOTO
  goto L75;
L73: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L74: // BOOL_INT
  int_vars[0] = int_vars[3];
L75: // GOTO
  goto L78;
L76: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L77: // BOOL_INT
  int_vars[0] = int_vars[7];
L78: // BOOL_INT
  int_vars[0] = int_vars[0];
L79: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L83; }
L80: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L81: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L87;
L82: // GOTO
  goto L83;
L83: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L84: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L87;
L85: // INIT_INT
  int_vars[9] = 0;
L86: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L87;
L87: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L88: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__move_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[6];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3l < 0) {
      BASIC_TYPE_ID_TestCase__Point_3l = env->get_basic_type_id(env, "TestCase::Point_3l");
      if (BASIC_TYPE_ID_TestCase__Point_3l < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3l");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3l;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 996;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L5: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 997;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L8: // MOVE_INT
  int_vars[3] = int_vars[2];
L9: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = long_vars[0];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 997;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L11: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 998;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L15: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L16: // MOVE_CONSTANT_INT
  int_vars[3] = 9;
L17: // MOVE_INT
  int_vars[4] = int_vars[3];
L18: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = long_vars[2];
      }
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 998;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L20: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 999;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L23: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L24: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 9;
L26: // MOVE_INT
  int_vars[4] = int_vars[3];
L27: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = long_vars[2];
      }
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 999;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L30: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L32: // MOVE_INT
  int_vars[3] = int_vars[2];
L33: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1003;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L36: // MOVE_INT
  int_vars[3] = int_vars[2];
L37: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1004;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L40: // MOVE_INT
  int_vars[3] = int_vars[2];
L41: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[2] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1005;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L43: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[3] = *(int64_t*)&stack[0];
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1007;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L45: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[3]);
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L62; }
L48: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[3] = *(int64_t*)&stack[0];
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1007;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L51: // CONVERT_INT_TO_LONG
  long_vars[4] = (int64_t)int_vars[2];
L52: // ADD_LONG
  long_vars[5] = long_vars[3] + long_vars[4];
L53: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[5]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L59; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L57: // BOOL_INT
  int_vars[0] = int_vars[2];
L58: // GOTO
  goto L61;
L59: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L60: // BOOL_INT
  int_vars[0] = int_vars[3];
L61: // GOTO
  goto L64;
L62: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L63: // BOOL_INT
  int_vars[0] = int_vars[4];
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L80; }
L66: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[3] = *(int64_t*)&stack[0];
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 1007;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L69: // CONVERT_INT_TO_LONG
  long_vars[4] = (int64_t)int_vars[2];
L70: // ADD_LONG
  long_vars[5] = long_vars[3] + long_vars[4];
L71: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[5]);
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L77; }
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L75: // BOOL_INT
  int_vars[0] = int_vars[2];
L76: // GOTO
  goto L79;
L77: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L78: // BOOL_INT
  int_vars[0] = int_vars[3];
L79: // GOTO
  goto L82;
L80: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L81: // BOOL_INT
  int_vars[0] = int_vars[4];
L82: // BOOL_INT
  int_vars[0] = int_vars[0];
L83: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L87; }
L84: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L85: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L91;
L86: // GOTO
  goto L87;
L87: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L88: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L91;
L89: // INIT_INT
  int_vars[6] = 0;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L91;
L91: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L92: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__move_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[4];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3s < 0) {
      BASIC_TYPE_ID_TestCase__Point_3s = env->get_basic_type_id(env, "TestCase::Point_3s");
      if (BASIC_TYPE_ID_TestCase__Point_3s < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3s");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3s;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 958;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L5: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 959;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L7: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L9: // MOVE_INT
  int_vars[3] = int_vars[2];
L10: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = short_vars[1];
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 959;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L12: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 960;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L14: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L16: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L17: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L19: // MOVE_INT
  int_vars[6] = int_vars[5];
L20: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1] = short_vars[1];
      }
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 960;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L22: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 961;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L24: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L26: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L27: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L29: // MOVE_INT
  int_vars[6] = int_vars[5];
L30: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2] = short_vars[1];
      }
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 961;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L33: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L35: // MOVE_INT
  int_vars[3] = int_vars[2];
L36: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 965;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L39: // MOVE_INT
  int_vars[3] = int_vars[2];
L40: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[1] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 966;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L43: // MOVE_INT
  int_vars[3] = int_vars[2];
L44: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[2] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 967;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L46: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L47: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[3] = *(int16_t*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 969;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L49: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[3];
L50: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L68; }
L53: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[1];
L54: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[3] = *(int16_t*)&stack[0];
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 969;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L56: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[3];
L57: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L58: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L59: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L65; }
L62: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L63: // BOOL_INT
  int_vars[0] = int_vars[2];
L64: // GOTO
  goto L67;
L65: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L66: // BOOL_INT
  int_vars[0] = int_vars[3];
L67: // GOTO
  goto L70;
L68: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L69: // BOOL_INT
  int_vars[0] = int_vars[4];
L70: // BOOL_INT
  int_vars[0] = int_vars[0];
L71: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L87; }
L72: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L73: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[3] = *(int16_t*)&stack[0];
    }
  }
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "move_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 969;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L75: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[3];
L76: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L77: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L78: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L79: // BOOL_INT
  int_vars[0] = int_vars[0];
L80: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L81: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L82: // BOOL_INT
  int_vars[0] = int_vars[2];
L83: // GOTO
  goto L86;
L84: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L85: // BOOL_INT
  int_vars[0] = int_vars[3];
L86: // GOTO
  goto L89;
L87: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L88: // BOOL_INT
  int_vars[0] = int_vars[4];
L89: // BOOL_INT
  int_vars[0] = int_vars[0];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L98;
L93: // GOTO
  goto L94;
L94: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L95: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L98;
L96: // INIT_INT
  int_vars[6] = 0;
L97: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L98;
L98: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L99: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__value_array_max_fields_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Matrix4_16b < 0) {
      BASIC_TYPE_ID_TestCase__Matrix4_16b = env->get_basic_type_id(env, "TestCase::Matrix4_16b");
      if (BASIC_TYPE_ID_TestCase__Matrix4_16b < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Matrix4_16b");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Matrix4_16b;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L5: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // MOVE_INT
  int_vars[3] = int_vars[2];
L9: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0] = byte_vars[0];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 21;
L12: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // MOVE_INT
  int_vars[4] = int_vars[3];
L15: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1] = byte_vars[0];
      }
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 22;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 31;
L18: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // MOVE_INT
  int_vars[4] = int_vars[3];
L21: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2] = byte_vars[0];
      }
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 23;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 41;
L24: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L26: // MOVE_INT
  int_vars[4] = int_vars[3];
L27: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3] = byte_vars[0];
      }
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 12;
L30: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L32: // MOVE_INT
  int_vars[4] = int_vars[3];
L33: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4] = byte_vars[0];
      }
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 26;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 22;
L36: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L37: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L38: // MOVE_INT
  int_vars[4] = int_vars[3];
L39: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5] = byte_vars[0];
      }
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 27;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 32;
L42: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L44: // MOVE_INT
  int_vars[4] = int_vars[3];
L45: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6] = byte_vars[0];
      }
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 28;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 42;
L48: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L49: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L50: // MOVE_INT
  int_vars[4] = int_vars[3];
L51: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7] = byte_vars[0];
      }
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 29;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 13;
L54: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L55: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L56: // MOVE_INT
  int_vars[4] = int_vars[3];
L57: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8] = byte_vars[0];
      }
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 23;
L60: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L61: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L62: // MOVE_INT
  int_vars[4] = int_vars[3];
L63: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9] = byte_vars[0];
      }
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 32;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 33;
L66: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L67: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L68: // MOVE_INT
  int_vars[4] = int_vars[3];
L69: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10] = byte_vars[0];
      }
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 33;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[2] = 43;
L72: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L73: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L74: // MOVE_INT
  int_vars[4] = int_vars[3];
L75: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11] = byte_vars[0];
      }
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 34;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L77: // MOVE_CONSTANT_INT
  int_vars[2] = 14;
L78: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L79: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L80: // MOVE_INT
  int_vars[4] = int_vars[3];
L81: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 12] = byte_vars[0];
      }
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 36;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L83: // MOVE_CONSTANT_INT
  int_vars[2] = 24;
L84: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L85: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L86: // MOVE_INT
  int_vars[4] = int_vars[3];
L87: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 13] = byte_vars[0];
      }
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 37;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 34;
L90: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L91: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L92: // MOVE_INT
  int_vars[4] = int_vars[3];
L93: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 14] = byte_vars[0];
      }
    }
  }
L94: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 38;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L95: // MOVE_CONSTANT_INT
  int_vars[2] = 44;
L96: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L97: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L98: // MOVE_INT
  int_vars[4] = int_vars[3];
L99: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15] = byte_vars[0];
      }
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 39;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L101: // MOVE_CONSTANT_INT
  int_vars[2] = 21;
L102: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L103: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L104: // MOVE_INT
  int_vars[4] = int_vars[3];
L105: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0] = byte_vars[0];
      }
    }
  }
L106: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L107: // MOVE_CONSTANT_INT
  int_vars[2] = 31;
L108: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L109: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L110: // MOVE_INT
  int_vars[4] = int_vars[3];
L111: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1] = byte_vars[0];
      }
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 42;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L113: // MOVE_CONSTANT_INT
  int_vars[2] = 41;
L114: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L115: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L116: // MOVE_INT
  int_vars[4] = int_vars[3];
L117: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2] = byte_vars[0];
      }
    }
  }
L118: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L119: // MOVE_CONSTANT_INT
  int_vars[2] = 51;
L120: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L121: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L122: // MOVE_INT
  int_vars[4] = int_vars[3];
L123: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3] = byte_vars[0];
      }
    }
  }
L124: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 44;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L125: // MOVE_CONSTANT_INT
  int_vars[2] = 22;
L126: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L127: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L128: // MOVE_INT
  int_vars[4] = int_vars[3];
L129: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4] = byte_vars[0];
      }
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 46;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L131: // MOVE_CONSTANT_INT
  int_vars[2] = 32;
L132: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L133: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L134: // MOVE_INT
  int_vars[4] = int_vars[3];
L135: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5] = byte_vars[0];
      }
    }
  }
L136: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 47;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L137: // MOVE_CONSTANT_INT
  int_vars[2] = 42;
L138: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L139: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L140: // MOVE_INT
  int_vars[4] = int_vars[3];
L141: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6] = byte_vars[0];
      }
    }
  }
L142: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 48;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L143: // MOVE_CONSTANT_INT
  int_vars[2] = 52;
L144: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L145: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L146: // MOVE_INT
  int_vars[4] = int_vars[3];
L147: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7] = byte_vars[0];
      }
    }
  }
L148: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 49;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L149: // MOVE_CONSTANT_INT
  int_vars[2] = 23;
L150: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L151: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L152: // MOVE_INT
  int_vars[4] = int_vars[3];
L153: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8] = byte_vars[0];
      }
    }
  }
L154: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 51;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L155: // MOVE_CONSTANT_INT
  int_vars[2] = 33;
L156: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L157: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L158: // MOVE_INT
  int_vars[4] = int_vars[3];
L159: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9] = byte_vars[0];
      }
    }
  }
L160: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L161: // MOVE_CONSTANT_INT
  int_vars[2] = 43;
L162: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L163: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L164: // MOVE_INT
  int_vars[4] = int_vars[3];
L165: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10] = byte_vars[0];
      }
    }
  }
L166: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 53;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L167: // MOVE_CONSTANT_INT
  int_vars[2] = 53;
L168: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L169: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L170: // MOVE_INT
  int_vars[4] = int_vars[3];
L171: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11] = byte_vars[0];
      }
    }
  }
L172: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 54;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L173: // MOVE_CONSTANT_INT
  int_vars[2] = 24;
L174: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L175: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L176: // MOVE_INT
  int_vars[4] = int_vars[3];
L177: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 12] = byte_vars[0];
      }
    }
  }
L178: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 56;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L179: // MOVE_CONSTANT_INT
  int_vars[2] = 34;
L180: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L181: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L182: // MOVE_INT
  int_vars[4] = int_vars[3];
L183: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 13] = byte_vars[0];
      }
    }
  }
L184: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 57;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L185: // MOVE_CONSTANT_INT
  int_vars[2] = 44;
L186: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L187: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L188: // MOVE_INT
  int_vars[4] = int_vars[3];
L189: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 14] = byte_vars[0];
      }
    }
  }
L190: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 58;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L191: // MOVE_CONSTANT_INT
  int_vars[2] = 54;
L192: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L193: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L194: // MOVE_INT
  int_vars[4] = int_vars[3];
L195: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15] = byte_vars[0];
      }
    }
  }
L196: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L197: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L198: // MOVE_INT
  int_vars[3] = int_vars[2];
L199: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0]; 
      } 
    } 
  } 
L200: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L201: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L202: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L203: // MOVE_INT
  int_vars[6] = int_vars[5];
L204: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0]; 
      } 
    } 
  } 
L205: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L206: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[1];
L207: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L208: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[8];
L209: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L210: // MOVE_INT
  int_vars[10] = int_vars[9];
L211: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0] = byte_vars[2];
      }
    }
  }
L212: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L213: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L214: // MOVE_INT
  int_vars[3] = int_vars[2];
L215: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1]; 
      } 
    } 
  } 
L216: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 62;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L217: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L218: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L219: // MOVE_INT
  int_vars[6] = int_vars[5];
L220: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1]; 
      } 
    } 
  } 
L221: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 62;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L222: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[1];
L223: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L224: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[8];
L225: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L226: // MOVE_INT
  int_vars[10] = int_vars[9];
L227: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1] = byte_vars[2];
      }
    }
  }
L228: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 62;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L229: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L230: // MOVE_INT
  int_vars[3] = int_vars[2];
L231: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2]; 
      } 
    } 
  } 
L232: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 63;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L233: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L234: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L235: // MOVE_INT
  int_vars[6] = int_vars[5];
L236: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2]; 
      } 
    } 
  } 
L237: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 63;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L238: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[1];
L239: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L240: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[8];
L241: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L242: // MOVE_INT
  int_vars[10] = int_vars[9];
L243: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2] = byte_vars[2];
      }
    }
  }
L244: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 63;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L245: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L246: // MOVE_INT
  int_vars[3] = int_vars[2];
L247: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L248: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L249: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L250: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L251: // MOVE_INT
  int_vars[6] = int_vars[5];
L252: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L253: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L254: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[1];
L255: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L256: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[8];
L257: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L258: // MOVE_INT
  int_vars[10] = int_vars[9];
L259: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3] = byte_vars[2];
      }
    }
  }
L260: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L261: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L262: // MOVE_INT
  int_vars[3] = int_vars[2];
L263: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4]; 
      } 
    } 
  } 
L264: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 66;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L265: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L266: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L267: // MOVE_INT
  int_vars[6] = int_vars[5];
L268: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4]; 
      } 
    } 
  } 
L269: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 66;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L270: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[1];
L271: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L272: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[8];
L273: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L274: // MOVE_INT
  int_vars[10] = int_vars[9];
L275: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4] = byte_vars[2];
      }
    }
  }
L276: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 66;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L277: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L278: // MOVE_INT
  int_vars[3] = int_vars[2];
L279: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5]; 
      } 
    } 
  } 
L280: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 67;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L281: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L282: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L283: // MOVE_INT
  int_vars[6] = int_vars[5];
L284: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5]; 
      } 
    } 
  } 
L285: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 67;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L286: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[1];
L287: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L288: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[8];
L289: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L290: // MOVE_INT
  int_vars[10] = int_vars[9];
L291: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5] = byte_vars[2];
      }
    }
  }
L292: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 67;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L293: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L294: // MOVE_INT
  int_vars[3] = int_vars[2];
L295: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6]; 
      } 
    } 
  } 
L296: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L297: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L298: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L299: // MOVE_INT
  int_vars[6] = int_vars[5];
L300: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6]; 
      } 
    } 
  } 
L301: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L302: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[1];
L303: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L304: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[8];
L305: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L306: // MOVE_INT
  int_vars[10] = int_vars[9];
L307: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6] = byte_vars[2];
      }
    }
  }
L308: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L309: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L310: // MOVE_INT
  int_vars[3] = int_vars[2];
L311: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L312: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 69;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L313: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L314: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L315: // MOVE_INT
  int_vars[6] = int_vars[5];
L316: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L317: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 69;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L318: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[1];
L319: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L320: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[8];
L321: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L322: // MOVE_INT
  int_vars[10] = int_vars[9];
L323: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7] = byte_vars[2];
      }
    }
  }
L324: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 69;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L325: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L326: // MOVE_INT
  int_vars[3] = int_vars[2];
L327: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8]; 
      } 
    } 
  } 
L328: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 71;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L329: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L330: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L331: // MOVE_INT
  int_vars[6] = int_vars[5];
L332: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8]; 
      } 
    } 
  } 
L333: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 71;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L334: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[1];
L335: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L336: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[8];
L337: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L338: // MOVE_INT
  int_vars[10] = int_vars[9];
L339: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8] = byte_vars[2];
      }
    }
  }
L340: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 71;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L341: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L342: // MOVE_INT
  int_vars[3] = int_vars[2];
L343: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9]; 
      } 
    } 
  } 
L344: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 72;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L345: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L346: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L347: // MOVE_INT
  int_vars[6] = int_vars[5];
L348: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9]; 
      } 
    } 
  } 
L349: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 72;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L350: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[1];
L351: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L352: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[8];
L353: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L354: // MOVE_INT
  int_vars[10] = int_vars[9];
L355: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9] = byte_vars[2];
      }
    }
  }
L356: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 72;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L357: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L358: // MOVE_INT
  int_vars[3] = int_vars[2];
L359: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10]; 
      } 
    } 
  } 
L360: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L361: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L362: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L363: // MOVE_INT
  int_vars[6] = int_vars[5];
L364: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10]; 
      } 
    } 
  } 
L365: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L366: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[1];
L367: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L368: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[8];
L369: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L370: // MOVE_INT
  int_vars[10] = int_vars[9];
L371: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10] = byte_vars[2];
      }
    }
  }
L372: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L373: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L374: // MOVE_INT
  int_vars[3] = int_vars[2];
L375: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L376: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 74;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L377: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L378: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L379: // MOVE_INT
  int_vars[6] = int_vars[5];
L380: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L381: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 74;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L382: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[1];
L383: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L384: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[8];
L385: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L386: // MOVE_INT
  int_vars[10] = int_vars[9];
L387: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11] = byte_vars[2];
      }
    }
  }
L388: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 74;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L389: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L390: // MOVE_INT
  int_vars[3] = int_vars[2];
L391: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 12]; 
      } 
    } 
  } 
L392: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 76;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L393: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L394: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L395: // MOVE_INT
  int_vars[6] = int_vars[5];
L396: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 12]; 
      } 
    } 
  } 
L397: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 76;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L398: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[1];
L399: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L400: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[8];
L401: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L402: // MOVE_INT
  int_vars[10] = int_vars[9];
L403: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 12] = byte_vars[2];
      }
    }
  }
L404: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 76;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L405: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L406: // MOVE_INT
  int_vars[3] = int_vars[2];
L407: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 13]; 
      } 
    } 
  } 
L408: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L409: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L410: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L411: // MOVE_INT
  int_vars[6] = int_vars[5];
L412: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 13]; 
      } 
    } 
  } 
L413: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L414: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[1];
L415: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L416: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[8];
L417: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L418: // MOVE_INT
  int_vars[10] = int_vars[9];
L419: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 13] = byte_vars[2];
      }
    }
  }
L420: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L421: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L422: // MOVE_INT
  int_vars[3] = int_vars[2];
L423: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 14]; 
      } 
    } 
  } 
L424: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 78;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L425: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L426: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L427: // MOVE_INT
  int_vars[6] = int_vars[5];
L428: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 14]; 
      } 
    } 
  } 
L429: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 78;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L430: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[1];
L431: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L432: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[8];
L433: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L434: // MOVE_INT
  int_vars[10] = int_vars[9];
L435: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 14] = byte_vars[2];
      }
    }
  }
L436: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 78;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L437: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L438: // MOVE_INT
  int_vars[3] = int_vars[2];
L439: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15]; 
      } 
    } 
  } 
L440: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 79;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L441: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L442: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L443: // MOVE_INT
  int_vars[6] = int_vars[5];
L444: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15]; 
      } 
    } 
  } 
L445: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 79;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L446: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[1];
L447: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L448: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[8];
L449: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L450: // MOVE_INT
  int_vars[10] = int_vars[9];
L451: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15] = byte_vars[2];
      }
    }
  }
L452: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 79;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L453: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L454: // MOVE_INT
  int_vars[3] = int_vars[2];
L455: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0]; 
      } 
    } 
  } 
L456: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 81;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L457: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L458: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L459: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 81;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L460: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[1];
L461: // MOVE_CONSTANT_INT
  int_vars[6] = 21;
L462: // ADD_INT
  int_vars[7] = int_vars[5] + int_vars[6];
L463: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[7]);
L464: // BOOL_INT
  int_vars[0] = int_vars[0];
L465: // IF_NE_ZERO
  if (int_vars[0]) { goto L469; }
L466: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L467: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L653;
L468: // GOTO
  goto L469;
L469: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L470: // MOVE_INT
  int_vars[5] = int_vars[4];
L471: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1]; 
      } 
    } 
  } 
L472: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 84;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L473: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L474: // MOVE_CONSTANT_INT
  int_vars[7] = 52;
L475: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L476: // BOOL_INT
  int_vars[0] = int_vars[0];
L477: // IF_NE_ZERO
  if (int_vars[0]) { goto L481; }
L478: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L479: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L653;
L480: // GOTO
  goto L481;
L481: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L482: // MOVE_INT
  int_vars[5] = int_vars[4];
L483: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2]; 
      } 
    } 
  } 
L484: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 87;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L485: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L486: // MOVE_CONSTANT_INT
  int_vars[7] = 72;
L487: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L488: // BOOL_INT
  int_vars[0] = int_vars[0];
L489: // IF_NE_ZERO
  if (int_vars[0]) { goto L493; }
L490: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L491: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L653;
L492: // GOTO
  goto L493;
L493: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L494: // MOVE_INT
  int_vars[5] = int_vars[4];
L495: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L496: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 90;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L497: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L498: // MOVE_CONSTANT_INT
  int_vars[7] = 92;
L499: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L500: // BOOL_INT
  int_vars[0] = int_vars[0];
L501: // IF_NE_ZERO
  if (int_vars[0]) { goto L505; }
L502: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L503: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L653;
L504: // GOTO
  goto L505;
L505: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L506: // MOVE_INT
  int_vars[5] = int_vars[4];
L507: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4]; 
      } 
    } 
  } 
L508: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 93;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L509: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L510: // MOVE_CONSTANT_INT
  int_vars[7] = 34;
L511: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L512: // BOOL_INT
  int_vars[0] = int_vars[0];
L513: // IF_NE_ZERO
  if (int_vars[0]) { goto L517; }
L514: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L515: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L653;
L516: // GOTO
  goto L517;
L517: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L518: // MOVE_INT
  int_vars[5] = int_vars[4];
L519: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5]; 
      } 
    } 
  } 
L520: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 96;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L521: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L522: // MOVE_CONSTANT_INT
  int_vars[7] = 54;
L523: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L524: // BOOL_INT
  int_vars[0] = int_vars[0];
L525: // IF_NE_ZERO
  if (int_vars[0]) { goto L529; }
L526: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L527: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L653;
L528: // GOTO
  goto L529;
L529: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L530: // MOVE_INT
  int_vars[5] = int_vars[4];
L531: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6]; 
      } 
    } 
  } 
L532: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 99;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L533: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L534: // MOVE_CONSTANT_INT
  int_vars[7] = 74;
L535: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L536: // BOOL_INT
  int_vars[0] = int_vars[0];
L537: // IF_NE_ZERO
  if (int_vars[0]) { goto L541; }
L538: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L539: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L653;
L540: // GOTO
  goto L541;
L541: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L542: // MOVE_INT
  int_vars[5] = int_vars[4];
L543: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L544: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 102;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L545: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L546: // MOVE_CONSTANT_INT
  int_vars[7] = 94;
L547: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L548: // BOOL_INT
  int_vars[0] = int_vars[0];
L549: // IF_NE_ZERO
  if (int_vars[0]) { goto L553; }
L550: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L551: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L653;
L552: // GOTO
  goto L553;
L553: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L554: // MOVE_INT
  int_vars[5] = int_vars[4];
L555: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8]; 
      } 
    } 
  } 
L556: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L557: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L558: // MOVE_CONSTANT_INT
  int_vars[7] = 36;
L559: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L560: // BOOL_INT
  int_vars[0] = int_vars[0];
L561: // IF_NE_ZERO
  if (int_vars[0]) { goto L565; }
L562: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L563: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L653;
L564: // GOTO
  goto L565;
L565: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L566: // MOVE_INT
  int_vars[5] = int_vars[4];
L567: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9]; 
      } 
    } 
  } 
L568: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 108;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L569: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L570: // MOVE_CONSTANT_INT
  int_vars[7] = 56;
L571: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L572: // BOOL_INT
  int_vars[0] = int_vars[0];
L573: // IF_NE_ZERO
  if (int_vars[0]) { goto L577; }
L574: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L575: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L653;
L576: // GOTO
  goto L577;
L577: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L578: // MOVE_INT
  int_vars[5] = int_vars[4];
L579: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10]; 
      } 
    } 
  } 
L580: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 111;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L581: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L582: // MOVE_CONSTANT_INT
  int_vars[7] = 76;
L583: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L584: // BOOL_INT
  int_vars[0] = int_vars[0];
L585: // IF_NE_ZERO
  if (int_vars[0]) { goto L589; }
L586: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L587: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L653;
L588: // GOTO
  goto L589;
L589: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L590: // MOVE_INT
  int_vars[5] = int_vars[4];
L591: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L592: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L593: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L594: // MOVE_CONSTANT_INT
  int_vars[7] = 96;
L595: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L596: // BOOL_INT
  int_vars[0] = int_vars[0];
L597: // IF_NE_ZERO
  if (int_vars[0]) { goto L601; }
L598: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L599: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L653;
L600: // GOTO
  goto L601;
L601: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L602: // MOVE_INT
  int_vars[5] = int_vars[4];
L603: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L604: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 117;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L605: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L606: // MOVE_CONSTANT_INT
  int_vars[7] = 92;
L607: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L608: // BOOL_INT
  int_vars[0] = int_vars[0];
L609: // IF_NE_ZERO
  if (int_vars[0]) { goto L613; }
L610: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L611: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L653;
L612: // GOTO
  goto L613;
L613: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L614: // MOVE_INT
  int_vars[5] = int_vars[4];
L615: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L616: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 120;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L617: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L618: // MOVE_CONSTANT_INT
  int_vars[7] = 94;
L619: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L620: // BOOL_INT
  int_vars[0] = int_vars[0];
L621: // IF_NE_ZERO
  if (int_vars[0]) { goto L625; }
L622: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L623: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L653;
L624: // GOTO
  goto L625;
L625: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L626: // MOVE_INT
  int_vars[5] = int_vars[4];
L627: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L628: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 123;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L629: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L630: // MOVE_CONSTANT_INT
  int_vars[7] = 96;
L631: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L632: // BOOL_INT
  int_vars[0] = int_vars[0];
L633: // IF_NE_ZERO
  if (int_vars[0]) { goto L637; }
L634: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L635: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L653;
L636: // GOTO
  goto L637;
L637: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L638: // MOVE_INT
  int_vars[5] = int_vars[4];
L639: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15]; 
      } 
    } 
  } 
L640: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_byte";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 126;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L641: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L642: // MOVE_CONSTANT_INT
  int_vars[7] = 98;
L643: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L644: // BOOL_INT
  int_vars[0] = int_vars[0];
L645: // IF_NE_ZERO
  if (int_vars[0]) { goto L649; }
L646: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L647: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L653;
L648: // GOTO
  goto L649;
L649: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L650: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L653;
L651: // INIT_INT
  int_vars[6] = 0;
L652: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L653;
L653: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L654: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__value_array_max_fields_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Matrix4_16d < 0) {
      BASIC_TYPE_ID_TestCase__Matrix4_16d = env->get_basic_type_id(env, "TestCase::Matrix4_16d");
      if (BASIC_TYPE_ID_TestCase__Matrix4_16d < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Matrix4_16d");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Matrix4_16d;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 598;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L5: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 600;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // MOVE_INT
  int_vars[3] = int_vars[2];
L9: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 0] = double_vars[0];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 600;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 21;
L12: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // MOVE_INT
  int_vars[4] = int_vars[3];
L15: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 1] = double_vars[0];
      }
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 601;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 31;
L18: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // MOVE_INT
  int_vars[4] = int_vars[3];
L21: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 2] = double_vars[0];
      }
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 602;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 41;
L24: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L26: // MOVE_INT
  int_vars[4] = int_vars[3];
L27: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 3] = double_vars[0];
      }
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 603;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 12;
L30: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L32: // MOVE_INT
  int_vars[4] = int_vars[3];
L33: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 4] = double_vars[0];
      }
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 605;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 22;
L36: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L37: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L38: // MOVE_INT
  int_vars[4] = int_vars[3];
L39: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 5] = double_vars[0];
      }
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 606;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 32;
L42: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L44: // MOVE_INT
  int_vars[4] = int_vars[3];
L45: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 6] = double_vars[0];
      }
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 607;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 42;
L48: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L49: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L50: // MOVE_INT
  int_vars[4] = int_vars[3];
L51: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 7] = double_vars[0];
      }
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 608;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 13;
L54: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L55: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L56: // MOVE_INT
  int_vars[4] = int_vars[3];
L57: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 8] = double_vars[0];
      }
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 610;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 23;
L60: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L61: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L62: // MOVE_INT
  int_vars[4] = int_vars[3];
L63: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 9] = double_vars[0];
      }
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 611;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 33;
L66: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L67: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L68: // MOVE_INT
  int_vars[4] = int_vars[3];
L69: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 10] = double_vars[0];
      }
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 612;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[2] = 43;
L72: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L73: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L74: // MOVE_INT
  int_vars[4] = int_vars[3];
L75: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 11] = double_vars[0];
      }
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 613;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L77: // MOVE_CONSTANT_INT
  int_vars[2] = 14;
L78: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L79: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L80: // MOVE_INT
  int_vars[4] = int_vars[3];
L81: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 12] = double_vars[0];
      }
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 615;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L83: // MOVE_CONSTANT_INT
  int_vars[2] = 24;
L84: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L85: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L86: // MOVE_INT
  int_vars[4] = int_vars[3];
L87: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 13] = double_vars[0];
      }
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 616;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 34;
L90: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L91: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L92: // MOVE_INT
  int_vars[4] = int_vars[3];
L93: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 14] = double_vars[0];
      }
    }
  }
L94: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 617;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L95: // MOVE_CONSTANT_INT
  int_vars[2] = 44;
L96: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L97: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L98: // MOVE_INT
  int_vars[4] = int_vars[3];
L99: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 15] = double_vars[0];
      }
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 618;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L101: // MOVE_CONSTANT_INT
  int_vars[2] = 111;
L102: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L103: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L104: // MOVE_INT
  int_vars[4] = int_vars[3];
L105: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 0] = double_vars[0];
      }
    }
  }
L106: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 620;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L107: // MOVE_CONSTANT_INT
  int_vars[2] = 121;
L108: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L109: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L110: // MOVE_INT
  int_vars[4] = int_vars[3];
L111: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 1] = double_vars[0];
      }
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 621;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L113: // MOVE_CONSTANT_INT
  int_vars[2] = 131;
L114: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L115: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L116: // MOVE_INT
  int_vars[4] = int_vars[3];
L117: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 2] = double_vars[0];
      }
    }
  }
L118: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 622;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L119: // MOVE_CONSTANT_INT
  int_vars[2] = 141;
L120: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L121: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L122: // MOVE_INT
  int_vars[4] = int_vars[3];
L123: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 3] = double_vars[0];
      }
    }
  }
L124: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 623;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L125: // MOVE_CONSTANT_INT
  int_vars[2] = 112;
L126: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L127: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L128: // MOVE_INT
  int_vars[4] = int_vars[3];
L129: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 4] = double_vars[0];
      }
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 625;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L131: // MOVE_CONSTANT_INT
  int_vars[2] = 122;
L132: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L133: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L134: // MOVE_INT
  int_vars[4] = int_vars[3];
L135: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 5] = double_vars[0];
      }
    }
  }
L136: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 626;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L137: // MOVE_CONSTANT_INT
  int_vars[2] = 132;
L138: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L139: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L140: // MOVE_INT
  int_vars[4] = int_vars[3];
L141: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 6] = double_vars[0];
      }
    }
  }
L142: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 627;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L143: // MOVE_CONSTANT_INT
  int_vars[2] = 142;
L144: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L145: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L146: // MOVE_INT
  int_vars[4] = int_vars[3];
L147: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 7] = double_vars[0];
      }
    }
  }
L148: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 628;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L149: // MOVE_CONSTANT_INT
  int_vars[2] = 113;
L150: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L151: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L152: // MOVE_INT
  int_vars[4] = int_vars[3];
L153: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 8] = double_vars[0];
      }
    }
  }
L154: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 630;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L155: // MOVE_CONSTANT_INT
  int_vars[2] = 123;
L156: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L157: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L158: // MOVE_INT
  int_vars[4] = int_vars[3];
L159: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 9] = double_vars[0];
      }
    }
  }
L160: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 631;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L161: // MOVE_CONSTANT_INT
  int_vars[2] = 133;
L162: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L163: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L164: // MOVE_INT
  int_vars[4] = int_vars[3];
L165: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 10] = double_vars[0];
      }
    }
  }
L166: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 632;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L167: // MOVE_CONSTANT_INT
  int_vars[2] = 143;
L168: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L169: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L170: // MOVE_INT
  int_vars[4] = int_vars[3];
L171: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 11] = double_vars[0];
      }
    }
  }
L172: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 633;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L173: // MOVE_CONSTANT_INT
  int_vars[2] = 114;
L174: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L175: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L176: // MOVE_INT
  int_vars[4] = int_vars[3];
L177: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 12] = double_vars[0];
      }
    }
  }
L178: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 635;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L179: // MOVE_CONSTANT_INT
  int_vars[2] = 124;
L180: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L181: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L182: // MOVE_INT
  int_vars[4] = int_vars[3];
L183: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 13] = double_vars[0];
      }
    }
  }
L184: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 636;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L185: // MOVE_CONSTANT_INT
  int_vars[2] = 134;
L186: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L187: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L188: // MOVE_INT
  int_vars[4] = int_vars[3];
L189: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 14] = double_vars[0];
      }
    }
  }
L190: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 637;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L191: // MOVE_CONSTANT_INT
  int_vars[2] = 144;
L192: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L193: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L194: // MOVE_INT
  int_vars[4] = int_vars[3];
L195: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 15] = double_vars[0];
      }
    }
  }
L196: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 638;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L197: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L198: // MOVE_INT
  int_vars[3] = int_vars[2];
L199: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 0]; 
      } 
    } 
  } 
L200: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 640;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L201: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L202: // MOVE_INT
  int_vars[5] = int_vars[4];
L203: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 0]; 
      } 
    } 
  } 
L204: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 640;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L205: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L206: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L207: // MOVE_INT
  int_vars[7] = int_vars[6];
L208: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 0] = double_vars[2];
      }
    }
  }
L209: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 640;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L210: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L211: // MOVE_INT
  int_vars[3] = int_vars[2];
L212: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 1]; 
      } 
    } 
  } 
L213: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 641;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L214: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L215: // MOVE_INT
  int_vars[5] = int_vars[4];
L216: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 1]; 
      } 
    } 
  } 
L217: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 641;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L218: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L219: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L220: // MOVE_INT
  int_vars[7] = int_vars[6];
L221: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 1] = double_vars[2];
      }
    }
  }
L222: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 641;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L223: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L224: // MOVE_INT
  int_vars[3] = int_vars[2];
L225: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 2]; 
      } 
    } 
  } 
L226: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 642;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L227: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L228: // MOVE_INT
  int_vars[5] = int_vars[4];
L229: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 2]; 
      } 
    } 
  } 
L230: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 642;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L231: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L232: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L233: // MOVE_INT
  int_vars[7] = int_vars[6];
L234: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 2] = double_vars[2];
      }
    }
  }
L235: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 642;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L236: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L237: // MOVE_INT
  int_vars[3] = int_vars[2];
L238: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L239: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 643;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L240: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L241: // MOVE_INT
  int_vars[5] = int_vars[4];
L242: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L243: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 643;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L244: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L245: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L246: // MOVE_INT
  int_vars[7] = int_vars[6];
L247: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 3] = double_vars[2];
      }
    }
  }
L248: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 643;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L249: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L250: // MOVE_INT
  int_vars[3] = int_vars[2];
L251: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 4]; 
      } 
    } 
  } 
L252: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 645;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L253: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L254: // MOVE_INT
  int_vars[5] = int_vars[4];
L255: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 4]; 
      } 
    } 
  } 
L256: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 645;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L257: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L258: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L259: // MOVE_INT
  int_vars[7] = int_vars[6];
L260: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 4] = double_vars[2];
      }
    }
  }
L261: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 645;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L262: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L263: // MOVE_INT
  int_vars[3] = int_vars[2];
L264: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 5]; 
      } 
    } 
  } 
L265: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 646;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L266: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L267: // MOVE_INT
  int_vars[5] = int_vars[4];
L268: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 5]; 
      } 
    } 
  } 
L269: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 646;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L270: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L271: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L272: // MOVE_INT
  int_vars[7] = int_vars[6];
L273: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 5] = double_vars[2];
      }
    }
  }
L274: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 646;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L275: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L276: // MOVE_INT
  int_vars[3] = int_vars[2];
L277: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 6]; 
      } 
    } 
  } 
L278: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 647;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L279: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L280: // MOVE_INT
  int_vars[5] = int_vars[4];
L281: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 6]; 
      } 
    } 
  } 
L282: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 647;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L283: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L284: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L285: // MOVE_INT
  int_vars[7] = int_vars[6];
L286: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 6] = double_vars[2];
      }
    }
  }
L287: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 647;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L288: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L289: // MOVE_INT
  int_vars[3] = int_vars[2];
L290: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L291: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 648;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L292: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L293: // MOVE_INT
  int_vars[5] = int_vars[4];
L294: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L295: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 648;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L296: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L297: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L298: // MOVE_INT
  int_vars[7] = int_vars[6];
L299: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 7] = double_vars[2];
      }
    }
  }
L300: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 648;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L301: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L302: // MOVE_INT
  int_vars[3] = int_vars[2];
L303: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 8]; 
      } 
    } 
  } 
L304: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 650;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L305: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L306: // MOVE_INT
  int_vars[5] = int_vars[4];
L307: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 8]; 
      } 
    } 
  } 
L308: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 650;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L309: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L310: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L311: // MOVE_INT
  int_vars[7] = int_vars[6];
L312: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 8] = double_vars[2];
      }
    }
  }
L313: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 650;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L314: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L315: // MOVE_INT
  int_vars[3] = int_vars[2];
L316: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 9]; 
      } 
    } 
  } 
L317: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 651;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L318: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L319: // MOVE_INT
  int_vars[5] = int_vars[4];
L320: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 9]; 
      } 
    } 
  } 
L321: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 651;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L322: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L323: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L324: // MOVE_INT
  int_vars[7] = int_vars[6];
L325: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 9] = double_vars[2];
      }
    }
  }
L326: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 651;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L327: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L328: // MOVE_INT
  int_vars[3] = int_vars[2];
L329: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 10]; 
      } 
    } 
  } 
L330: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 652;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L331: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L332: // MOVE_INT
  int_vars[5] = int_vars[4];
L333: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 10]; 
      } 
    } 
  } 
L334: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 652;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L335: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L336: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L337: // MOVE_INT
  int_vars[7] = int_vars[6];
L338: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 10] = double_vars[2];
      }
    }
  }
L339: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 652;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L340: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L341: // MOVE_INT
  int_vars[3] = int_vars[2];
L342: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L343: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 653;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L344: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L345: // MOVE_INT
  int_vars[5] = int_vars[4];
L346: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L347: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 653;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L348: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L349: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L350: // MOVE_INT
  int_vars[7] = int_vars[6];
L351: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 11] = double_vars[2];
      }
    }
  }
L352: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 653;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L353: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L354: // MOVE_INT
  int_vars[3] = int_vars[2];
L355: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 12]; 
      } 
    } 
  } 
L356: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 655;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L357: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L358: // MOVE_INT
  int_vars[5] = int_vars[4];
L359: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 12]; 
      } 
    } 
  } 
L360: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 655;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L361: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L362: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L363: // MOVE_INT
  int_vars[7] = int_vars[6];
L364: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 12] = double_vars[2];
      }
    }
  }
L365: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 655;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L366: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L367: // MOVE_INT
  int_vars[3] = int_vars[2];
L368: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 13]; 
      } 
    } 
  } 
L369: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 656;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L370: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L371: // MOVE_INT
  int_vars[5] = int_vars[4];
L372: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 13]; 
      } 
    } 
  } 
L373: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 656;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L374: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L375: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L376: // MOVE_INT
  int_vars[7] = int_vars[6];
L377: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 13] = double_vars[2];
      }
    }
  }
L378: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 656;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L379: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L380: // MOVE_INT
  int_vars[3] = int_vars[2];
L381: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 14]; 
      } 
    } 
  } 
L382: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 657;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L383: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L384: // MOVE_INT
  int_vars[5] = int_vars[4];
L385: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 14]; 
      } 
    } 
  } 
L386: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 657;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L387: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L388: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L389: // MOVE_INT
  int_vars[7] = int_vars[6];
L390: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 14] = double_vars[2];
      }
    }
  }
L391: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 657;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L392: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L393: // MOVE_INT
  int_vars[3] = int_vars[2];
L394: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 15]; 
      } 
    } 
  } 
L395: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 658;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L396: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L397: // MOVE_INT
  int_vars[5] = int_vars[4];
L398: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 15]; 
      } 
    } 
  } 
L399: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 658;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L400: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L401: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L402: // MOVE_INT
  int_vars[7] = int_vars[6];
L403: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[16 * index + 15] = double_vars[2];
      }
    }
  }
L404: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 658;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L405: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L406: // MOVE_INT
  int_vars[3] = int_vars[2];
L407: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 0]; 
      } 
    } 
  } 
L408: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 660;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L409: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L410: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 660;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L411: // MOVE_CONSTANT_INT
  int_vars[4] = 111;
L412: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[4];
L413: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[2];
L414: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[3]);
L415: // BOOL_INT
  int_vars[0] = int_vars[0];
L416: // IF_NE_ZERO
  if (int_vars[0]) { goto L420; }
L417: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L418: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L419: // GOTO
  goto L420;
L420: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L421: // MOVE_INT
  int_vars[5] = int_vars[4];
L422: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 1]; 
      } 
    } 
  } 
L423: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 664;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L424: // MOVE_CONSTANT_INT
  int_vars[6] = 142;
L425: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[6];
L426: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L427: // BOOL_INT
  int_vars[0] = int_vars[0];
L428: // IF_NE_ZERO
  if (int_vars[0]) { goto L432; }
L429: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L430: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L431: // GOTO
  goto L432;
L432: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L433: // MOVE_INT
  int_vars[5] = int_vars[4];
L434: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 2]; 
      } 
    } 
  } 
L435: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 667;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L436: // MOVE_CONSTANT_INT
  int_vars[6] = 162;
L437: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[6];
L438: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L439: // BOOL_INT
  int_vars[0] = int_vars[0];
L440: // IF_NE_ZERO
  if (int_vars[0]) { goto L444; }
L441: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L442: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L443: // GOTO
  goto L444;
L444: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L445: // MOVE_INT
  int_vars[5] = int_vars[4];
L446: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L447: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 670;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L448: // MOVE_CONSTANT_INT
  int_vars[6] = 182;
L449: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[6];
L450: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L451: // BOOL_INT
  int_vars[0] = int_vars[0];
L452: // IF_NE_ZERO
  if (int_vars[0]) { goto L456; }
L453: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L454: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L455: // GOTO
  goto L456;
L456: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L457: // MOVE_INT
  int_vars[5] = int_vars[4];
L458: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 4]; 
      } 
    } 
  } 
L459: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 673;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L460: // MOVE_CONSTANT_INT
  int_vars[6] = 124;
L461: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[6];
L462: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L463: // BOOL_INT
  int_vars[0] = int_vars[0];
L464: // IF_NE_ZERO
  if (int_vars[0]) { goto L468; }
L465: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L466: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L467: // GOTO
  goto L468;
L468: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L469: // MOVE_INT
  int_vars[5] = int_vars[4];
L470: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 5]; 
      } 
    } 
  } 
L471: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 676;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L472: // MOVE_CONSTANT_INT
  int_vars[6] = 144;
L473: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[6];
L474: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L475: // BOOL_INT
  int_vars[0] = int_vars[0];
L476: // IF_NE_ZERO
  if (int_vars[0]) { goto L480; }
L477: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L478: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L479: // GOTO
  goto L480;
L480: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L481: // MOVE_INT
  int_vars[5] = int_vars[4];
L482: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 6]; 
      } 
    } 
  } 
L483: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 679;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L484: // MOVE_CONSTANT_INT
  int_vars[6] = 164;
L485: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[6];
L486: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L487: // BOOL_INT
  int_vars[0] = int_vars[0];
L488: // IF_NE_ZERO
  if (int_vars[0]) { goto L492; }
L489: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L490: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L491: // GOTO
  goto L492;
L492: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L493: // MOVE_INT
  int_vars[5] = int_vars[4];
L494: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L495: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 682;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L496: // MOVE_CONSTANT_INT
  int_vars[6] = 184;
L497: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[6];
L498: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L499: // BOOL_INT
  int_vars[0] = int_vars[0];
L500: // IF_NE_ZERO
  if (int_vars[0]) { goto L504; }
L501: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L502: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L503: // GOTO
  goto L504;
L504: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L505: // MOVE_INT
  int_vars[5] = int_vars[4];
L506: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 8]; 
      } 
    } 
  } 
L507: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 685;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L508: // MOVE_CONSTANT_INT
  int_vars[6] = 126;
L509: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[6];
L510: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L511: // BOOL_INT
  int_vars[0] = int_vars[0];
L512: // IF_NE_ZERO
  if (int_vars[0]) { goto L516; }
L513: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L514: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L515: // GOTO
  goto L516;
L516: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L517: // MOVE_INT
  int_vars[5] = int_vars[4];
L518: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 9]; 
      } 
    } 
  } 
L519: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 688;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L520: // MOVE_CONSTANT_INT
  int_vars[6] = 146;
L521: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[6];
L522: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L523: // BOOL_INT
  int_vars[0] = int_vars[0];
L524: // IF_NE_ZERO
  if (int_vars[0]) { goto L528; }
L525: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L526: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L527: // GOTO
  goto L528;
L528: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L529: // MOVE_INT
  int_vars[5] = int_vars[4];
L530: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 10]; 
      } 
    } 
  } 
L531: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 691;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L532: // MOVE_CONSTANT_INT
  int_vars[6] = 166;
L533: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[6];
L534: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L535: // BOOL_INT
  int_vars[0] = int_vars[0];
L536: // IF_NE_ZERO
  if (int_vars[0]) { goto L540; }
L537: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L538: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L539: // GOTO
  goto L540;
L540: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L541: // MOVE_INT
  int_vars[5] = int_vars[4];
L542: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L543: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 694;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L544: // MOVE_CONSTANT_INT
  int_vars[6] = 186;
L545: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[6];
L546: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L547: // BOOL_INT
  int_vars[0] = int_vars[0];
L548: // IF_NE_ZERO
  if (int_vars[0]) { goto L552; }
L549: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L550: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L551: // GOTO
  goto L552;
L552: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L553: // MOVE_INT
  int_vars[5] = int_vars[4];
L554: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L555: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 697;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L556: // MOVE_CONSTANT_INT
  int_vars[6] = 182;
L557: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[6];
L558: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L559: // BOOL_INT
  int_vars[0] = int_vars[0];
L560: // IF_NE_ZERO
  if (int_vars[0]) { goto L564; }
L561: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L562: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L563: // GOTO
  goto L564;
L564: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L565: // MOVE_INT
  int_vars[5] = int_vars[4];
L566: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L567: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 700;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L568: // MOVE_CONSTANT_INT
  int_vars[6] = 184;
L569: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[6];
L570: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L571: // BOOL_INT
  int_vars[0] = int_vars[0];
L572: // IF_NE_ZERO
  if (int_vars[0]) { goto L576; }
L573: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L574: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L575: // GOTO
  goto L576;
L576: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L577: // MOVE_INT
  int_vars[5] = int_vars[4];
L578: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L579: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 703;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L580: // MOVE_CONSTANT_INT
  int_vars[6] = 186;
L581: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[6];
L582: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L583: // BOOL_INT
  int_vars[0] = int_vars[0];
L584: // IF_NE_ZERO
  if (int_vars[0]) { goto L588; }
L585: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L586: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L587: // GOTO
  goto L588;
L588: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L589: // MOVE_INT
  int_vars[5] = int_vars[4];
L590: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[16 * index + 15]; 
      } 
    } 
  } 
L591: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_double";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 706;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L592: // MOVE_CONSTANT_INT
  int_vars[6] = 188;
L593: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[6];
L594: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L595: // BOOL_INT
  int_vars[0] = int_vars[0];
L596: // IF_NE_ZERO
  if (int_vars[0]) { goto L600; }
L597: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L598: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L599: // GOTO
  goto L600;
L600: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L601: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L604;
L602: // INIT_INT
  int_vars[6] = 0;
L603: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L604;
L604: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L605: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__value_array_max_fields_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Matrix4_16f < 0) {
      BASIC_TYPE_ID_TestCase__Matrix4_16f = env->get_basic_type_id(env, "TestCase::Matrix4_16f");
      if (BASIC_TYPE_ID_TestCase__Matrix4_16f < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Matrix4_16f");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Matrix4_16f;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 482;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L5: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 484;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // MOVE_INT
  int_vars[3] = int_vars[2];
L9: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 0] = float_vars[0];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 484;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 21;
L12: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // MOVE_INT
  int_vars[4] = int_vars[3];
L15: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 1] = float_vars[0];
      }
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 485;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 31;
L18: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // MOVE_INT
  int_vars[4] = int_vars[3];
L21: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 2] = float_vars[0];
      }
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 486;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 41;
L24: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L26: // MOVE_INT
  int_vars[4] = int_vars[3];
L27: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 3] = float_vars[0];
      }
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 487;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 12;
L30: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L32: // MOVE_INT
  int_vars[4] = int_vars[3];
L33: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 4] = float_vars[0];
      }
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 489;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 22;
L36: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L37: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L38: // MOVE_INT
  int_vars[4] = int_vars[3];
L39: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 5] = float_vars[0];
      }
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 490;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 32;
L42: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L44: // MOVE_INT
  int_vars[4] = int_vars[3];
L45: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 6] = float_vars[0];
      }
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 491;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 42;
L48: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L49: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L50: // MOVE_INT
  int_vars[4] = int_vars[3];
L51: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 7] = float_vars[0];
      }
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 492;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 13;
L54: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L55: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L56: // MOVE_INT
  int_vars[4] = int_vars[3];
L57: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 8] = float_vars[0];
      }
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 494;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 23;
L60: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L61: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L62: // MOVE_INT
  int_vars[4] = int_vars[3];
L63: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 9] = float_vars[0];
      }
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 495;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 33;
L66: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L67: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L68: // MOVE_INT
  int_vars[4] = int_vars[3];
L69: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 10] = float_vars[0];
      }
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 496;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[2] = 43;
L72: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L73: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L74: // MOVE_INT
  int_vars[4] = int_vars[3];
L75: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 11] = float_vars[0];
      }
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 497;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L77: // MOVE_CONSTANT_INT
  int_vars[2] = 14;
L78: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L79: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L80: // MOVE_INT
  int_vars[4] = int_vars[3];
L81: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 12] = float_vars[0];
      }
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 499;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L83: // MOVE_CONSTANT_INT
  int_vars[2] = 24;
L84: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L85: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L86: // MOVE_INT
  int_vars[4] = int_vars[3];
L87: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 13] = float_vars[0];
      }
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 500;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 34;
L90: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L91: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L92: // MOVE_INT
  int_vars[4] = int_vars[3];
L93: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 14] = float_vars[0];
      }
    }
  }
L94: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 501;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L95: // MOVE_CONSTANT_INT
  int_vars[2] = 44;
L96: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L97: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L98: // MOVE_INT
  int_vars[4] = int_vars[3];
L99: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 15] = float_vars[0];
      }
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 502;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L101: // MOVE_CONSTANT_INT
  int_vars[2] = 111;
L102: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L103: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L104: // MOVE_INT
  int_vars[4] = int_vars[3];
L105: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 0] = float_vars[0];
      }
    }
  }
L106: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 504;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L107: // MOVE_CONSTANT_INT
  int_vars[2] = 121;
L108: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L109: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L110: // MOVE_INT
  int_vars[4] = int_vars[3];
L111: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 1] = float_vars[0];
      }
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 505;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L113: // MOVE_CONSTANT_INT
  int_vars[2] = 131;
L114: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L115: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L116: // MOVE_INT
  int_vars[4] = int_vars[3];
L117: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 2] = float_vars[0];
      }
    }
  }
L118: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 506;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L119: // MOVE_CONSTANT_INT
  int_vars[2] = 141;
L120: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L121: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L122: // MOVE_INT
  int_vars[4] = int_vars[3];
L123: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 3] = float_vars[0];
      }
    }
  }
L124: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 507;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L125: // MOVE_CONSTANT_INT
  int_vars[2] = 112;
L126: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L127: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L128: // MOVE_INT
  int_vars[4] = int_vars[3];
L129: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 4] = float_vars[0];
      }
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 509;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L131: // MOVE_CONSTANT_INT
  int_vars[2] = 122;
L132: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L133: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L134: // MOVE_INT
  int_vars[4] = int_vars[3];
L135: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 5] = float_vars[0];
      }
    }
  }
L136: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 510;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L137: // MOVE_CONSTANT_INT
  int_vars[2] = 132;
L138: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L139: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L140: // MOVE_INT
  int_vars[4] = int_vars[3];
L141: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 6] = float_vars[0];
      }
    }
  }
L142: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 511;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L143: // MOVE_CONSTANT_INT
  int_vars[2] = 142;
L144: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L145: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L146: // MOVE_INT
  int_vars[4] = int_vars[3];
L147: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 7] = float_vars[0];
      }
    }
  }
L148: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 512;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L149: // MOVE_CONSTANT_INT
  int_vars[2] = 113;
L150: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L151: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L152: // MOVE_INT
  int_vars[4] = int_vars[3];
L153: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 8] = float_vars[0];
      }
    }
  }
L154: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 514;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L155: // MOVE_CONSTANT_INT
  int_vars[2] = 123;
L156: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L157: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L158: // MOVE_INT
  int_vars[4] = int_vars[3];
L159: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 9] = float_vars[0];
      }
    }
  }
L160: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 515;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L161: // MOVE_CONSTANT_INT
  int_vars[2] = 133;
L162: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L163: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L164: // MOVE_INT
  int_vars[4] = int_vars[3];
L165: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 10] = float_vars[0];
      }
    }
  }
L166: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 516;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L167: // MOVE_CONSTANT_INT
  int_vars[2] = 143;
L168: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L169: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L170: // MOVE_INT
  int_vars[4] = int_vars[3];
L171: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 11] = float_vars[0];
      }
    }
  }
L172: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 517;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L173: // MOVE_CONSTANT_INT
  int_vars[2] = 114;
L174: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L175: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L176: // MOVE_INT
  int_vars[4] = int_vars[3];
L177: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 12] = float_vars[0];
      }
    }
  }
L178: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 519;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L179: // MOVE_CONSTANT_INT
  int_vars[2] = 124;
L180: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L181: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L182: // MOVE_INT
  int_vars[4] = int_vars[3];
L183: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 13] = float_vars[0];
      }
    }
  }
L184: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 520;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L185: // MOVE_CONSTANT_INT
  int_vars[2] = 134;
L186: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L187: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L188: // MOVE_INT
  int_vars[4] = int_vars[3];
L189: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 14] = float_vars[0];
      }
    }
  }
L190: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 521;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L191: // MOVE_CONSTANT_INT
  int_vars[2] = 144;
L192: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L193: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L194: // MOVE_INT
  int_vars[4] = int_vars[3];
L195: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 15] = float_vars[0];
      }
    }
  }
L196: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 522;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L197: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L198: // MOVE_INT
  int_vars[3] = int_vars[2];
L199: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 0]; 
      } 
    } 
  } 
L200: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 524;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L201: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L202: // MOVE_INT
  int_vars[5] = int_vars[4];
L203: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 0]; 
      } 
    } 
  } 
L204: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 524;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L205: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L206: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L207: // MOVE_INT
  int_vars[7] = int_vars[6];
L208: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 0] = float_vars[2];
      }
    }
  }
L209: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 524;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L210: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L211: // MOVE_INT
  int_vars[3] = int_vars[2];
L212: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 1]; 
      } 
    } 
  } 
L213: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 525;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L214: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L215: // MOVE_INT
  int_vars[5] = int_vars[4];
L216: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 1]; 
      } 
    } 
  } 
L217: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 525;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L218: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L219: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L220: // MOVE_INT
  int_vars[7] = int_vars[6];
L221: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 1] = float_vars[2];
      }
    }
  }
L222: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 525;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L223: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L224: // MOVE_INT
  int_vars[3] = int_vars[2];
L225: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 2]; 
      } 
    } 
  } 
L226: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 526;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L227: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L228: // MOVE_INT
  int_vars[5] = int_vars[4];
L229: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 2]; 
      } 
    } 
  } 
L230: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 526;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L231: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L232: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L233: // MOVE_INT
  int_vars[7] = int_vars[6];
L234: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 2] = float_vars[2];
      }
    }
  }
L235: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 526;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L236: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L237: // MOVE_INT
  int_vars[3] = int_vars[2];
L238: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L239: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 527;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L240: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L241: // MOVE_INT
  int_vars[5] = int_vars[4];
L242: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L243: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 527;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L244: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L245: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L246: // MOVE_INT
  int_vars[7] = int_vars[6];
L247: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 3] = float_vars[2];
      }
    }
  }
L248: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 527;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L249: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L250: // MOVE_INT
  int_vars[3] = int_vars[2];
L251: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 4]; 
      } 
    } 
  } 
L252: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 529;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L253: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L254: // MOVE_INT
  int_vars[5] = int_vars[4];
L255: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 4]; 
      } 
    } 
  } 
L256: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 529;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L257: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L258: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L259: // MOVE_INT
  int_vars[7] = int_vars[6];
L260: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 4] = float_vars[2];
      }
    }
  }
L261: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 529;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L262: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L263: // MOVE_INT
  int_vars[3] = int_vars[2];
L264: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 5]; 
      } 
    } 
  } 
L265: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 530;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L266: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L267: // MOVE_INT
  int_vars[5] = int_vars[4];
L268: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 5]; 
      } 
    } 
  } 
L269: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 530;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L270: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L271: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L272: // MOVE_INT
  int_vars[7] = int_vars[6];
L273: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 5] = float_vars[2];
      }
    }
  }
L274: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 530;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L275: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L276: // MOVE_INT
  int_vars[3] = int_vars[2];
L277: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 6]; 
      } 
    } 
  } 
L278: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 531;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L279: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L280: // MOVE_INT
  int_vars[5] = int_vars[4];
L281: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 6]; 
      } 
    } 
  } 
L282: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 531;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L283: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L284: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L285: // MOVE_INT
  int_vars[7] = int_vars[6];
L286: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 6] = float_vars[2];
      }
    }
  }
L287: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 531;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L288: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L289: // MOVE_INT
  int_vars[3] = int_vars[2];
L290: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L291: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 532;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L292: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L293: // MOVE_INT
  int_vars[5] = int_vars[4];
L294: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L295: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 532;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L296: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L297: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L298: // MOVE_INT
  int_vars[7] = int_vars[6];
L299: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 7] = float_vars[2];
      }
    }
  }
L300: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 532;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L301: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L302: // MOVE_INT
  int_vars[3] = int_vars[2];
L303: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 8]; 
      } 
    } 
  } 
L304: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 534;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L305: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L306: // MOVE_INT
  int_vars[5] = int_vars[4];
L307: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 8]; 
      } 
    } 
  } 
L308: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 534;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L309: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L310: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L311: // MOVE_INT
  int_vars[7] = int_vars[6];
L312: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 8] = float_vars[2];
      }
    }
  }
L313: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 534;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L314: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L315: // MOVE_INT
  int_vars[3] = int_vars[2];
L316: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 9]; 
      } 
    } 
  } 
L317: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 535;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L318: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L319: // MOVE_INT
  int_vars[5] = int_vars[4];
L320: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 9]; 
      } 
    } 
  } 
L321: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 535;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L322: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L323: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L324: // MOVE_INT
  int_vars[7] = int_vars[6];
L325: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 9] = float_vars[2];
      }
    }
  }
L326: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 535;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L327: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L328: // MOVE_INT
  int_vars[3] = int_vars[2];
L329: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 10]; 
      } 
    } 
  } 
L330: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 536;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L331: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L332: // MOVE_INT
  int_vars[5] = int_vars[4];
L333: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 10]; 
      } 
    } 
  } 
L334: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 536;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L335: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L336: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L337: // MOVE_INT
  int_vars[7] = int_vars[6];
L338: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 10] = float_vars[2];
      }
    }
  }
L339: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 536;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L340: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L341: // MOVE_INT
  int_vars[3] = int_vars[2];
L342: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L343: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 537;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L344: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L345: // MOVE_INT
  int_vars[5] = int_vars[4];
L346: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L347: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 537;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L348: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L349: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L350: // MOVE_INT
  int_vars[7] = int_vars[6];
L351: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 11] = float_vars[2];
      }
    }
  }
L352: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 537;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L353: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L354: // MOVE_INT
  int_vars[3] = int_vars[2];
L355: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 12]; 
      } 
    } 
  } 
L356: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 539;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L357: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L358: // MOVE_INT
  int_vars[5] = int_vars[4];
L359: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 12]; 
      } 
    } 
  } 
L360: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 539;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L361: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L362: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L363: // MOVE_INT
  int_vars[7] = int_vars[6];
L364: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 12] = float_vars[2];
      }
    }
  }
L365: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 539;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L366: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L367: // MOVE_INT
  int_vars[3] = int_vars[2];
L368: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 13]; 
      } 
    } 
  } 
L369: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 540;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L370: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L371: // MOVE_INT
  int_vars[5] = int_vars[4];
L372: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 13]; 
      } 
    } 
  } 
L373: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 540;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L374: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L375: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L376: // MOVE_INT
  int_vars[7] = int_vars[6];
L377: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 13] = float_vars[2];
      }
    }
  }
L378: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 540;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L379: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L380: // MOVE_INT
  int_vars[3] = int_vars[2];
L381: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 14]; 
      } 
    } 
  } 
L382: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 541;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L383: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L384: // MOVE_INT
  int_vars[5] = int_vars[4];
L385: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 14]; 
      } 
    } 
  } 
L386: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 541;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L387: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L388: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L389: // MOVE_INT
  int_vars[7] = int_vars[6];
L390: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 14] = float_vars[2];
      }
    }
  }
L391: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 541;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L392: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L393: // MOVE_INT
  int_vars[3] = int_vars[2];
L394: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 15]; 
      } 
    } 
  } 
L395: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 542;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L396: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L397: // MOVE_INT
  int_vars[5] = int_vars[4];
L398: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 15]; 
      } 
    } 
  } 
L399: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 542;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L400: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L401: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L402: // MOVE_INT
  int_vars[7] = int_vars[6];
L403: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[16 * index + 15] = float_vars[2];
      }
    }
  }
L404: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 542;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L405: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L406: // MOVE_INT
  int_vars[3] = int_vars[2];
L407: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 0]; 
      } 
    } 
  } 
L408: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 544;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L409: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L410: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 544;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L411: // MOVE_CONSTANT_INT
  int_vars[4] = 111;
L412: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[4];
L413: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[2];
L414: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[3]);
L415: // BOOL_INT
  int_vars[0] = int_vars[0];
L416: // IF_NE_ZERO
  if (int_vars[0]) { goto L420; }
L417: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L418: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L419: // GOTO
  goto L420;
L420: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L421: // MOVE_INT
  int_vars[5] = int_vars[4];
L422: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 1]; 
      } 
    } 
  } 
L423: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 548;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L424: // MOVE_CONSTANT_INT
  int_vars[6] = 142;
L425: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[6];
L426: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L427: // BOOL_INT
  int_vars[0] = int_vars[0];
L428: // IF_NE_ZERO
  if (int_vars[0]) { goto L432; }
L429: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L430: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L431: // GOTO
  goto L432;
L432: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L433: // MOVE_INT
  int_vars[5] = int_vars[4];
L434: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 2]; 
      } 
    } 
  } 
L435: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 551;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L436: // MOVE_CONSTANT_INT
  int_vars[6] = 162;
L437: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[6];
L438: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L439: // BOOL_INT
  int_vars[0] = int_vars[0];
L440: // IF_NE_ZERO
  if (int_vars[0]) { goto L444; }
L441: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L442: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L443: // GOTO
  goto L444;
L444: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L445: // MOVE_INT
  int_vars[5] = int_vars[4];
L446: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L447: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 554;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L448: // MOVE_CONSTANT_INT
  int_vars[6] = 182;
L449: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[6];
L450: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L451: // BOOL_INT
  int_vars[0] = int_vars[0];
L452: // IF_NE_ZERO
  if (int_vars[0]) { goto L456; }
L453: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L454: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L455: // GOTO
  goto L456;
L456: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L457: // MOVE_INT
  int_vars[5] = int_vars[4];
L458: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 4]; 
      } 
    } 
  } 
L459: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 557;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L460: // MOVE_CONSTANT_INT
  int_vars[6] = 124;
L461: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[6];
L462: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L463: // BOOL_INT
  int_vars[0] = int_vars[0];
L464: // IF_NE_ZERO
  if (int_vars[0]) { goto L468; }
L465: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L466: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L467: // GOTO
  goto L468;
L468: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L469: // MOVE_INT
  int_vars[5] = int_vars[4];
L470: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 5]; 
      } 
    } 
  } 
L471: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 560;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L472: // MOVE_CONSTANT_INT
  int_vars[6] = 144;
L473: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[6];
L474: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L475: // BOOL_INT
  int_vars[0] = int_vars[0];
L476: // IF_NE_ZERO
  if (int_vars[0]) { goto L480; }
L477: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L478: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L479: // GOTO
  goto L480;
L480: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L481: // MOVE_INT
  int_vars[5] = int_vars[4];
L482: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 6]; 
      } 
    } 
  } 
L483: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 563;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L484: // MOVE_CONSTANT_INT
  int_vars[6] = 164;
L485: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[6];
L486: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L487: // BOOL_INT
  int_vars[0] = int_vars[0];
L488: // IF_NE_ZERO
  if (int_vars[0]) { goto L492; }
L489: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L490: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L491: // GOTO
  goto L492;
L492: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L493: // MOVE_INT
  int_vars[5] = int_vars[4];
L494: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L495: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 566;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L496: // MOVE_CONSTANT_INT
  int_vars[6] = 184;
L497: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[6];
L498: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L499: // BOOL_INT
  int_vars[0] = int_vars[0];
L500: // IF_NE_ZERO
  if (int_vars[0]) { goto L504; }
L501: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L502: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L503: // GOTO
  goto L504;
L504: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L505: // MOVE_INT
  int_vars[5] = int_vars[4];
L506: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 8]; 
      } 
    } 
  } 
L507: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 569;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L508: // MOVE_CONSTANT_INT
  int_vars[6] = 126;
L509: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[6];
L510: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L511: // BOOL_INT
  int_vars[0] = int_vars[0];
L512: // IF_NE_ZERO
  if (int_vars[0]) { goto L516; }
L513: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L514: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L515: // GOTO
  goto L516;
L516: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L517: // MOVE_INT
  int_vars[5] = int_vars[4];
L518: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 9]; 
      } 
    } 
  } 
L519: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 572;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L520: // MOVE_CONSTANT_INT
  int_vars[6] = 146;
L521: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[6];
L522: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L523: // BOOL_INT
  int_vars[0] = int_vars[0];
L524: // IF_NE_ZERO
  if (int_vars[0]) { goto L528; }
L525: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L526: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L527: // GOTO
  goto L528;
L528: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L529: // MOVE_INT
  int_vars[5] = int_vars[4];
L530: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 10]; 
      } 
    } 
  } 
L531: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 575;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L532: // MOVE_CONSTANT_INT
  int_vars[6] = 166;
L533: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[6];
L534: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L535: // BOOL_INT
  int_vars[0] = int_vars[0];
L536: // IF_NE_ZERO
  if (int_vars[0]) { goto L540; }
L537: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L538: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L539: // GOTO
  goto L540;
L540: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L541: // MOVE_INT
  int_vars[5] = int_vars[4];
L542: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L543: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 578;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L544: // MOVE_CONSTANT_INT
  int_vars[6] = 186;
L545: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[6];
L546: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L547: // BOOL_INT
  int_vars[0] = int_vars[0];
L548: // IF_NE_ZERO
  if (int_vars[0]) { goto L552; }
L549: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L550: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L551: // GOTO
  goto L552;
L552: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L553: // MOVE_INT
  int_vars[5] = int_vars[4];
L554: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L555: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 581;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L556: // MOVE_CONSTANT_INT
  int_vars[6] = 182;
L557: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[6];
L558: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L559: // BOOL_INT
  int_vars[0] = int_vars[0];
L560: // IF_NE_ZERO
  if (int_vars[0]) { goto L564; }
L561: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L562: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L563: // GOTO
  goto L564;
L564: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L565: // MOVE_INT
  int_vars[5] = int_vars[4];
L566: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L567: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 584;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L568: // MOVE_CONSTANT_INT
  int_vars[6] = 184;
L569: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[6];
L570: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L571: // BOOL_INT
  int_vars[0] = int_vars[0];
L572: // IF_NE_ZERO
  if (int_vars[0]) { goto L576; }
L573: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L574: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L575: // GOTO
  goto L576;
L576: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L577: // MOVE_INT
  int_vars[5] = int_vars[4];
L578: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L579: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 587;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L580: // MOVE_CONSTANT_INT
  int_vars[6] = 186;
L581: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[6];
L582: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L583: // BOOL_INT
  int_vars[0] = int_vars[0];
L584: // IF_NE_ZERO
  if (int_vars[0]) { goto L588; }
L585: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L586: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L587: // GOTO
  goto L588;
L588: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L589: // MOVE_INT
  int_vars[5] = int_vars[4];
L590: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[16 * index + 15]; 
      } 
    } 
  } 
L591: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_float";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 590;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L592: // MOVE_CONSTANT_INT
  int_vars[6] = 188;
L593: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[6];
L594: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L595: // BOOL_INT
  int_vars[0] = int_vars[0];
L596: // IF_NE_ZERO
  if (int_vars[0]) { goto L600; }
L597: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L598: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L599: // GOTO
  goto L600;
L600: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L601: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L604;
L602: // INIT_INT
  int_vars[6] = 0;
L603: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L604;
L604: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L605: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__value_array_max_fields_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Matrix4_16i < 0) {
      BASIC_TYPE_ID_TestCase__Matrix4_16i = env->get_basic_type_id(env, "TestCase::Matrix4_16i");
      if (BASIC_TYPE_ID_TestCase__Matrix4_16i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Matrix4_16i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Matrix4_16i;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 250;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L5: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 252;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // MOVE_INT
  int_vars[4] = int_vars[3];
L9: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0] = int_vars[2];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 252;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 21;
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L13: // MOVE_INT
  int_vars[4] = int_vars[3];
L14: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1] = int_vars[2];
      }
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 253;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 31;
L17: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L18: // MOVE_INT
  int_vars[4] = int_vars[3];
L19: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2] = int_vars[2];
      }
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 254;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 41;
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L23: // MOVE_INT
  int_vars[4] = int_vars[3];
L24: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3] = int_vars[2];
      }
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 255;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 12;
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L28: // MOVE_INT
  int_vars[4] = int_vars[3];
L29: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4] = int_vars[2];
      }
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 257;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 22;
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L33: // MOVE_INT
  int_vars[4] = int_vars[3];
L34: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5] = int_vars[2];
      }
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 258;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 32;
L37: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L38: // MOVE_INT
  int_vars[4] = int_vars[3];
L39: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6] = int_vars[2];
      }
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 259;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 42;
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L43: // MOVE_INT
  int_vars[4] = int_vars[3];
L44: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7] = int_vars[2];
      }
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 260;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 13;
L47: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L48: // MOVE_INT
  int_vars[4] = int_vars[3];
L49: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8] = int_vars[2];
      }
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 262;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 23;
L52: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L53: // MOVE_INT
  int_vars[4] = int_vars[3];
L54: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9] = int_vars[2];
      }
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 263;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 33;
L57: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L58: // MOVE_INT
  int_vars[4] = int_vars[3];
L59: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10] = int_vars[2];
      }
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 264;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 43;
L62: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L63: // MOVE_INT
  int_vars[4] = int_vars[3];
L64: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11] = int_vars[2];
      }
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 265;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 14;
L67: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L68: // MOVE_INT
  int_vars[4] = int_vars[3];
L69: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 12] = int_vars[2];
      }
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 267;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[2] = 24;
L72: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L73: // MOVE_INT
  int_vars[4] = int_vars[3];
L74: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 13] = int_vars[2];
      }
    }
  }
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 268;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 34;
L77: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L78: // MOVE_INT
  int_vars[4] = int_vars[3];
L79: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 14] = int_vars[2];
      }
    }
  }
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 269;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L81: // MOVE_CONSTANT_INT
  int_vars[2] = 44;
L82: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L83: // MOVE_INT
  int_vars[4] = int_vars[3];
L84: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15] = int_vars[2];
      }
    }
  }
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 270;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L86: // MOVE_CONSTANT_INT
  int_vars[2] = 111;
L87: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L88: // MOVE_INT
  int_vars[4] = int_vars[3];
L89: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0] = int_vars[2];
      }
    }
  }
L90: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 272;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 121;
L92: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L93: // MOVE_INT
  int_vars[4] = int_vars[3];
L94: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1] = int_vars[2];
      }
    }
  }
L95: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 273;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L96: // MOVE_CONSTANT_INT
  int_vars[2] = 131;
L97: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L98: // MOVE_INT
  int_vars[4] = int_vars[3];
L99: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2] = int_vars[2];
      }
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 274;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L101: // MOVE_CONSTANT_INT
  int_vars[2] = 141;
L102: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L103: // MOVE_INT
  int_vars[4] = int_vars[3];
L104: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3] = int_vars[2];
      }
    }
  }
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 275;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L106: // MOVE_CONSTANT_INT
  int_vars[2] = 112;
L107: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L108: // MOVE_INT
  int_vars[4] = int_vars[3];
L109: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4] = int_vars[2];
      }
    }
  }
L110: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 277;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L111: // MOVE_CONSTANT_INT
  int_vars[2] = 122;
L112: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L113: // MOVE_INT
  int_vars[4] = int_vars[3];
L114: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5] = int_vars[2];
      }
    }
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 278;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L116: // MOVE_CONSTANT_INT
  int_vars[2] = 132;
L117: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L118: // MOVE_INT
  int_vars[4] = int_vars[3];
L119: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6] = int_vars[2];
      }
    }
  }
L120: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 279;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L121: // MOVE_CONSTANT_INT
  int_vars[2] = 142;
L122: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L123: // MOVE_INT
  int_vars[4] = int_vars[3];
L124: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7] = int_vars[2];
      }
    }
  }
L125: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 280;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L126: // MOVE_CONSTANT_INT
  int_vars[2] = 113;
L127: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L128: // MOVE_INT
  int_vars[4] = int_vars[3];
L129: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8] = int_vars[2];
      }
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 282;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L131: // MOVE_CONSTANT_INT
  int_vars[2] = 123;
L132: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L133: // MOVE_INT
  int_vars[4] = int_vars[3];
L134: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9] = int_vars[2];
      }
    }
  }
L135: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 283;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L136: // MOVE_CONSTANT_INT
  int_vars[2] = 133;
L137: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L138: // MOVE_INT
  int_vars[4] = int_vars[3];
L139: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10] = int_vars[2];
      }
    }
  }
L140: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 284;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L141: // MOVE_CONSTANT_INT
  int_vars[2] = 143;
L142: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L143: // MOVE_INT
  int_vars[4] = int_vars[3];
L144: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11] = int_vars[2];
      }
    }
  }
L145: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 285;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L146: // MOVE_CONSTANT_INT
  int_vars[2] = 114;
L147: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L148: // MOVE_INT
  int_vars[4] = int_vars[3];
L149: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 12] = int_vars[2];
      }
    }
  }
L150: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 287;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L151: // MOVE_CONSTANT_INT
  int_vars[2] = 124;
L152: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L153: // MOVE_INT
  int_vars[4] = int_vars[3];
L154: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 13] = int_vars[2];
      }
    }
  }
L155: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 288;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L156: // MOVE_CONSTANT_INT
  int_vars[2] = 134;
L157: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L158: // MOVE_INT
  int_vars[4] = int_vars[3];
L159: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 14] = int_vars[2];
      }
    }
  }
L160: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 289;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L161: // MOVE_CONSTANT_INT
  int_vars[2] = 144;
L162: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L163: // MOVE_INT
  int_vars[4] = int_vars[3];
L164: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15] = int_vars[2];
      }
    }
  }
L165: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 290;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L166: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L167: // MOVE_INT
  int_vars[3] = int_vars[2];
L168: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0]; 
      } 
    } 
  } 
L169: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 292;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L170: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L171: // MOVE_INT
  int_vars[6] = int_vars[5];
L172: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0]; 
      } 
    } 
  } 
L173: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 292;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L174: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L175: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L176: // MOVE_INT
  int_vars[10] = int_vars[9];
L177: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0] = int_vars[8];
      }
    }
  }
L178: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 292;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L179: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L180: // MOVE_INT
  int_vars[3] = int_vars[2];
L181: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1]; 
      } 
    } 
  } 
L182: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L183: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L184: // MOVE_INT
  int_vars[6] = int_vars[5];
L185: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1]; 
      } 
    } 
  } 
L186: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L187: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L188: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L189: // MOVE_INT
  int_vars[10] = int_vars[9];
L190: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1] = int_vars[8];
      }
    }
  }
L191: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L192: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L193: // MOVE_INT
  int_vars[3] = int_vars[2];
L194: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2]; 
      } 
    } 
  } 
L195: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 294;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L196: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L197: // MOVE_INT
  int_vars[6] = int_vars[5];
L198: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2]; 
      } 
    } 
  } 
L199: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 294;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L200: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L201: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L202: // MOVE_INT
  int_vars[10] = int_vars[9];
L203: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2] = int_vars[8];
      }
    }
  }
L204: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 294;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L205: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L206: // MOVE_INT
  int_vars[3] = int_vars[2];
L207: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L208: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L209: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L210: // MOVE_INT
  int_vars[6] = int_vars[5];
L211: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L212: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L213: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L214: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L215: // MOVE_INT
  int_vars[10] = int_vars[9];
L216: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3] = int_vars[8];
      }
    }
  }
L217: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L218: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L219: // MOVE_INT
  int_vars[3] = int_vars[2];
L220: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4]; 
      } 
    } 
  } 
L221: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 297;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L222: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L223: // MOVE_INT
  int_vars[6] = int_vars[5];
L224: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4]; 
      } 
    } 
  } 
L225: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 297;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L226: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L227: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L228: // MOVE_INT
  int_vars[10] = int_vars[9];
L229: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4] = int_vars[8];
      }
    }
  }
L230: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 297;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L231: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L232: // MOVE_INT
  int_vars[3] = int_vars[2];
L233: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5]; 
      } 
    } 
  } 
L234: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 298;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L235: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L236: // MOVE_INT
  int_vars[6] = int_vars[5];
L237: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5]; 
      } 
    } 
  } 
L238: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 298;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L239: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L240: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L241: // MOVE_INT
  int_vars[10] = int_vars[9];
L242: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5] = int_vars[8];
      }
    }
  }
L243: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 298;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L244: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L245: // MOVE_INT
  int_vars[3] = int_vars[2];
L246: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6]; 
      } 
    } 
  } 
L247: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 299;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L248: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L249: // MOVE_INT
  int_vars[6] = int_vars[5];
L250: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6]; 
      } 
    } 
  } 
L251: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 299;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L252: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L253: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L254: // MOVE_INT
  int_vars[10] = int_vars[9];
L255: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6] = int_vars[8];
      }
    }
  }
L256: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 299;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L257: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L258: // MOVE_INT
  int_vars[3] = int_vars[2];
L259: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L260: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 300;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L261: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L262: // MOVE_INT
  int_vars[6] = int_vars[5];
L263: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L264: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 300;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L265: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L266: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L267: // MOVE_INT
  int_vars[10] = int_vars[9];
L268: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7] = int_vars[8];
      }
    }
  }
L269: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 300;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L270: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L271: // MOVE_INT
  int_vars[3] = int_vars[2];
L272: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8]; 
      } 
    } 
  } 
L273: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 302;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L274: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L275: // MOVE_INT
  int_vars[6] = int_vars[5];
L276: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8]; 
      } 
    } 
  } 
L277: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 302;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L278: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L279: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L280: // MOVE_INT
  int_vars[10] = int_vars[9];
L281: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8] = int_vars[8];
      }
    }
  }
L282: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 302;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L283: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L284: // MOVE_INT
  int_vars[3] = int_vars[2];
L285: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9]; 
      } 
    } 
  } 
L286: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 303;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L287: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L288: // MOVE_INT
  int_vars[6] = int_vars[5];
L289: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9]; 
      } 
    } 
  } 
L290: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 303;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L291: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L292: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L293: // MOVE_INT
  int_vars[10] = int_vars[9];
L294: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9] = int_vars[8];
      }
    }
  }
L295: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 303;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L296: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L297: // MOVE_INT
  int_vars[3] = int_vars[2];
L298: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10]; 
      } 
    } 
  } 
L299: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 304;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L300: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L301: // MOVE_INT
  int_vars[6] = int_vars[5];
L302: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10]; 
      } 
    } 
  } 
L303: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 304;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L304: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L305: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L306: // MOVE_INT
  int_vars[10] = int_vars[9];
L307: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10] = int_vars[8];
      }
    }
  }
L308: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 304;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L309: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L310: // MOVE_INT
  int_vars[3] = int_vars[2];
L311: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L312: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L313: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L314: // MOVE_INT
  int_vars[6] = int_vars[5];
L315: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L316: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L317: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L318: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L319: // MOVE_INT
  int_vars[10] = int_vars[9];
L320: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11] = int_vars[8];
      }
    }
  }
L321: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L322: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L323: // MOVE_INT
  int_vars[3] = int_vars[2];
L324: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 12]; 
      } 
    } 
  } 
L325: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 307;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L326: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L327: // MOVE_INT
  int_vars[6] = int_vars[5];
L328: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 12]; 
      } 
    } 
  } 
L329: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 307;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L330: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L331: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L332: // MOVE_INT
  int_vars[10] = int_vars[9];
L333: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 12] = int_vars[8];
      }
    }
  }
L334: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 307;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L335: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L336: // MOVE_INT
  int_vars[3] = int_vars[2];
L337: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 13]; 
      } 
    } 
  } 
L338: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 308;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L339: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L340: // MOVE_INT
  int_vars[6] = int_vars[5];
L341: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 13]; 
      } 
    } 
  } 
L342: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 308;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L343: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L344: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L345: // MOVE_INT
  int_vars[10] = int_vars[9];
L346: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 13] = int_vars[8];
      }
    }
  }
L347: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 308;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L348: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L349: // MOVE_INT
  int_vars[3] = int_vars[2];
L350: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 14]; 
      } 
    } 
  } 
L351: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 309;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L352: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L353: // MOVE_INT
  int_vars[6] = int_vars[5];
L354: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 14]; 
      } 
    } 
  } 
L355: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 309;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L356: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L357: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L358: // MOVE_INT
  int_vars[10] = int_vars[9];
L359: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 14] = int_vars[8];
      }
    }
  }
L360: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 309;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L361: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L362: // MOVE_INT
  int_vars[3] = int_vars[2];
L363: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15]; 
      } 
    } 
  } 
L364: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 310;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L365: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L366: // MOVE_INT
  int_vars[6] = int_vars[5];
L367: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15]; 
      } 
    } 
  } 
L368: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 310;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L369: // ADD_INT
  int_vars[8] = int_vars[4] + int_vars[7];
L370: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L371: // MOVE_INT
  int_vars[10] = int_vars[9];
L372: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15] = int_vars[8];
      }
    }
  }
L373: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 310;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L374: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L375: // MOVE_INT
  int_vars[3] = int_vars[2];
L376: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0]; 
      } 
    } 
  } 
L377: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 312;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L378: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L379: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 312;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L380: // MOVE_CONSTANT_INT
  int_vars[6] = 111;
L381: // ADD_INT
  int_vars[7] = int_vars[5] + int_vars[6];
L382: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[7]);
L383: // BOOL_INT
  int_vars[0] = int_vars[0];
L384: // IF_NE_ZERO
  if (int_vars[0]) { goto L388; }
L385: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L386: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L557;
L387: // GOTO
  goto L388;
L388: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L389: // MOVE_INT
  int_vars[5] = int_vars[4];
L390: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1]; 
      } 
    } 
  } 
L391: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 316;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L392: // MOVE_CONSTANT_INT
  int_vars[7] = 142;
L393: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L394: // BOOL_INT
  int_vars[0] = int_vars[0];
L395: // IF_NE_ZERO
  if (int_vars[0]) { goto L399; }
L396: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L397: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L557;
L398: // GOTO
  goto L399;
L399: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L400: // MOVE_INT
  int_vars[5] = int_vars[4];
L401: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2]; 
      } 
    } 
  } 
L402: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 319;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L403: // MOVE_CONSTANT_INT
  int_vars[7] = 162;
L404: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L405: // BOOL_INT
  int_vars[0] = int_vars[0];
L406: // IF_NE_ZERO
  if (int_vars[0]) { goto L410; }
L407: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L408: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L557;
L409: // GOTO
  goto L410;
L410: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L411: // MOVE_INT
  int_vars[5] = int_vars[4];
L412: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L413: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 322;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L414: // MOVE_CONSTANT_INT
  int_vars[7] = 182;
L415: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L416: // BOOL_INT
  int_vars[0] = int_vars[0];
L417: // IF_NE_ZERO
  if (int_vars[0]) { goto L421; }
L418: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L419: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L557;
L420: // GOTO
  goto L421;
L421: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L422: // MOVE_INT
  int_vars[5] = int_vars[4];
L423: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4]; 
      } 
    } 
  } 
L424: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 325;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L425: // MOVE_CONSTANT_INT
  int_vars[7] = 124;
L426: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L427: // BOOL_INT
  int_vars[0] = int_vars[0];
L428: // IF_NE_ZERO
  if (int_vars[0]) { goto L432; }
L429: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L430: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L557;
L431: // GOTO
  goto L432;
L432: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L433: // MOVE_INT
  int_vars[5] = int_vars[4];
L434: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5]; 
      } 
    } 
  } 
L435: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 328;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L436: // MOVE_CONSTANT_INT
  int_vars[7] = 144;
L437: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L438: // BOOL_INT
  int_vars[0] = int_vars[0];
L439: // IF_NE_ZERO
  if (int_vars[0]) { goto L443; }
L440: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L441: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L557;
L442: // GOTO
  goto L443;
L443: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L444: // MOVE_INT
  int_vars[5] = int_vars[4];
L445: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6]; 
      } 
    } 
  } 
L446: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 331;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L447: // MOVE_CONSTANT_INT
  int_vars[7] = 164;
L448: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L449: // BOOL_INT
  int_vars[0] = int_vars[0];
L450: // IF_NE_ZERO
  if (int_vars[0]) { goto L454; }
L451: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L452: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L557;
L453: // GOTO
  goto L454;
L454: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L455: // MOVE_INT
  int_vars[5] = int_vars[4];
L456: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L457: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 334;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L458: // MOVE_CONSTANT_INT
  int_vars[7] = 184;
L459: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L460: // BOOL_INT
  int_vars[0] = int_vars[0];
L461: // IF_NE_ZERO
  if (int_vars[0]) { goto L465; }
L462: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L463: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L557;
L464: // GOTO
  goto L465;
L465: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L466: // MOVE_INT
  int_vars[5] = int_vars[4];
L467: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8]; 
      } 
    } 
  } 
L468: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 337;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L469: // MOVE_CONSTANT_INT
  int_vars[7] = 126;
L470: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L471: // BOOL_INT
  int_vars[0] = int_vars[0];
L472: // IF_NE_ZERO
  if (int_vars[0]) { goto L476; }
L473: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L474: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L557;
L475: // GOTO
  goto L476;
L476: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L477: // MOVE_INT
  int_vars[5] = int_vars[4];
L478: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9]; 
      } 
    } 
  } 
L479: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 340;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L480: // MOVE_CONSTANT_INT
  int_vars[7] = 146;
L481: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L482: // BOOL_INT
  int_vars[0] = int_vars[0];
L483: // IF_NE_ZERO
  if (int_vars[0]) { goto L487; }
L484: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L485: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L557;
L486: // GOTO
  goto L487;
L487: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L488: // MOVE_INT
  int_vars[5] = int_vars[4];
L489: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10]; 
      } 
    } 
  } 
L490: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 343;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L491: // MOVE_CONSTANT_INT
  int_vars[7] = 166;
L492: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L493: // BOOL_INT
  int_vars[0] = int_vars[0];
L494: // IF_NE_ZERO
  if (int_vars[0]) { goto L498; }
L495: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L496: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L557;
L497: // GOTO
  goto L498;
L498: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L499: // MOVE_INT
  int_vars[5] = int_vars[4];
L500: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L501: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 346;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L502: // MOVE_CONSTANT_INT
  int_vars[7] = 186;
L503: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L504: // BOOL_INT
  int_vars[0] = int_vars[0];
L505: // IF_NE_ZERO
  if (int_vars[0]) { goto L509; }
L506: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L507: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L557;
L508: // GOTO
  goto L509;
L509: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L510: // MOVE_INT
  int_vars[5] = int_vars[4];
L511: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L512: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 349;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L513: // MOVE_CONSTANT_INT
  int_vars[7] = 182;
L514: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L515: // BOOL_INT
  int_vars[0] = int_vars[0];
L516: // IF_NE_ZERO
  if (int_vars[0]) { goto L520; }
L517: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L518: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L557;
L519: // GOTO
  goto L520;
L520: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L521: // MOVE_INT
  int_vars[5] = int_vars[4];
L522: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L523: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 352;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L524: // MOVE_CONSTANT_INT
  int_vars[7] = 184;
L525: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L526: // BOOL_INT
  int_vars[0] = int_vars[0];
L527: // IF_NE_ZERO
  if (int_vars[0]) { goto L531; }
L528: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L529: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L557;
L530: // GOTO
  goto L531;
L531: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L532: // MOVE_INT
  int_vars[5] = int_vars[4];
L533: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L534: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 355;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L535: // MOVE_CONSTANT_INT
  int_vars[7] = 186;
L536: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L537: // BOOL_INT
  int_vars[0] = int_vars[0];
L538: // IF_NE_ZERO
  if (int_vars[0]) { goto L542; }
L539: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L540: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L557;
L541: // GOTO
  goto L542;
L542: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L543: // MOVE_INT
  int_vars[5] = int_vars[4];
L544: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[6] =((int32_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15]; 
      } 
    } 
  } 
L545: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_int";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 358;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L557;
  }
L546: // MOVE_CONSTANT_INT
  int_vars[7] = 188;
L547: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L548: // BOOL_INT
  int_vars[0] = int_vars[0];
L549: // IF_NE_ZERO
  if (int_vars[0]) { goto L553; }
L550: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L551: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L557;
L552: // GOTO
  goto L553;
L553: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L554: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L557;
L555: // INIT_INT
  int_vars[6] = 0;
L556: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L557;
L557: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L558: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__value_array_max_fields_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Matrix4_16l < 0) {
      BASIC_TYPE_ID_TestCase__Matrix4_16l = env->get_basic_type_id(env, "TestCase::Matrix4_16l");
      if (BASIC_TYPE_ID_TestCase__Matrix4_16l < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Matrix4_16l");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Matrix4_16l;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 366;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L5: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 368;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // MOVE_INT
  int_vars[3] = int_vars[2];
L9: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0] = long_vars[0];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 368;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 21;
L12: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // MOVE_INT
  int_vars[4] = int_vars[3];
L15: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1] = long_vars[0];
      }
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 369;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 31;
L18: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // MOVE_INT
  int_vars[4] = int_vars[3];
L21: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2] = long_vars[0];
      }
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 370;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 41;
L24: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L26: // MOVE_INT
  int_vars[4] = int_vars[3];
L27: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3] = long_vars[0];
      }
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 371;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 12;
L30: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L32: // MOVE_INT
  int_vars[4] = int_vars[3];
L33: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4] = long_vars[0];
      }
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 22;
L36: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L37: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L38: // MOVE_INT
  int_vars[4] = int_vars[3];
L39: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5] = long_vars[0];
      }
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 374;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 32;
L42: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L44: // MOVE_INT
  int_vars[4] = int_vars[3];
L45: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6] = long_vars[0];
      }
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 375;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 42;
L48: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L49: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L50: // MOVE_INT
  int_vars[4] = int_vars[3];
L51: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7] = long_vars[0];
      }
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 376;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 13;
L54: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L55: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L56: // MOVE_INT
  int_vars[4] = int_vars[3];
L57: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8] = long_vars[0];
      }
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 378;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 23;
L60: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L61: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L62: // MOVE_INT
  int_vars[4] = int_vars[3];
L63: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9] = long_vars[0];
      }
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 379;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 33;
L66: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L67: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L68: // MOVE_INT
  int_vars[4] = int_vars[3];
L69: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10] = long_vars[0];
      }
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 380;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[2] = 43;
L72: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L73: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L74: // MOVE_INT
  int_vars[4] = int_vars[3];
L75: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11] = long_vars[0];
      }
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 381;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L77: // MOVE_CONSTANT_INT
  int_vars[2] = 14;
L78: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L79: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L80: // MOVE_INT
  int_vars[4] = int_vars[3];
L81: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 12] = long_vars[0];
      }
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 383;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L83: // MOVE_CONSTANT_INT
  int_vars[2] = 24;
L84: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L85: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L86: // MOVE_INT
  int_vars[4] = int_vars[3];
L87: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 13] = long_vars[0];
      }
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 384;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 34;
L90: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L91: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L92: // MOVE_INT
  int_vars[4] = int_vars[3];
L93: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 14] = long_vars[0];
      }
    }
  }
L94: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 385;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L95: // MOVE_CONSTANT_INT
  int_vars[2] = 44;
L96: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L97: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L98: // MOVE_INT
  int_vars[4] = int_vars[3];
L99: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15] = long_vars[0];
      }
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 386;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L101: // MOVE_CONSTANT_INT
  int_vars[2] = 111;
L102: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L103: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L104: // MOVE_INT
  int_vars[4] = int_vars[3];
L105: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0] = long_vars[0];
      }
    }
  }
L106: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 388;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L107: // MOVE_CONSTANT_INT
  int_vars[2] = 121;
L108: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L109: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L110: // MOVE_INT
  int_vars[4] = int_vars[3];
L111: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1] = long_vars[0];
      }
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 389;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L113: // MOVE_CONSTANT_INT
  int_vars[2] = 131;
L114: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L115: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L116: // MOVE_INT
  int_vars[4] = int_vars[3];
L117: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2] = long_vars[0];
      }
    }
  }
L118: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 390;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L119: // MOVE_CONSTANT_INT
  int_vars[2] = 141;
L120: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L121: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L122: // MOVE_INT
  int_vars[4] = int_vars[3];
L123: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3] = long_vars[0];
      }
    }
  }
L124: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 391;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L125: // MOVE_CONSTANT_INT
  int_vars[2] = 112;
L126: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L127: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L128: // MOVE_INT
  int_vars[4] = int_vars[3];
L129: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4] = long_vars[0];
      }
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 393;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L131: // MOVE_CONSTANT_INT
  int_vars[2] = 122;
L132: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L133: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L134: // MOVE_INT
  int_vars[4] = int_vars[3];
L135: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5] = long_vars[0];
      }
    }
  }
L136: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 394;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L137: // MOVE_CONSTANT_INT
  int_vars[2] = 132;
L138: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L139: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L140: // MOVE_INT
  int_vars[4] = int_vars[3];
L141: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6] = long_vars[0];
      }
    }
  }
L142: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 395;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L143: // MOVE_CONSTANT_INT
  int_vars[2] = 142;
L144: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L145: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L146: // MOVE_INT
  int_vars[4] = int_vars[3];
L147: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7] = long_vars[0];
      }
    }
  }
L148: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 396;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L149: // MOVE_CONSTANT_INT
  int_vars[2] = 113;
L150: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L151: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L152: // MOVE_INT
  int_vars[4] = int_vars[3];
L153: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8] = long_vars[0];
      }
    }
  }
L154: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 398;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L155: // MOVE_CONSTANT_INT
  int_vars[2] = 123;
L156: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L157: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L158: // MOVE_INT
  int_vars[4] = int_vars[3];
L159: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9] = long_vars[0];
      }
    }
  }
L160: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 399;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L161: // MOVE_CONSTANT_INT
  int_vars[2] = 133;
L162: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L163: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L164: // MOVE_INT
  int_vars[4] = int_vars[3];
L165: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10] = long_vars[0];
      }
    }
  }
L166: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 400;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L167: // MOVE_CONSTANT_INT
  int_vars[2] = 143;
L168: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L169: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L170: // MOVE_INT
  int_vars[4] = int_vars[3];
L171: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11] = long_vars[0];
      }
    }
  }
L172: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 401;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L173: // MOVE_CONSTANT_INT
  int_vars[2] = 114;
L174: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L175: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L176: // MOVE_INT
  int_vars[4] = int_vars[3];
L177: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 12] = long_vars[0];
      }
    }
  }
L178: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 403;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L179: // MOVE_CONSTANT_INT
  int_vars[2] = 124;
L180: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L181: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L182: // MOVE_INT
  int_vars[4] = int_vars[3];
L183: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 13] = long_vars[0];
      }
    }
  }
L184: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 404;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L185: // MOVE_CONSTANT_INT
  int_vars[2] = 134;
L186: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L187: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L188: // MOVE_INT
  int_vars[4] = int_vars[3];
L189: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 14] = long_vars[0];
      }
    }
  }
L190: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 405;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L191: // MOVE_CONSTANT_INT
  int_vars[2] = 144;
L192: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L193: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L194: // MOVE_INT
  int_vars[4] = int_vars[3];
L195: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15] = long_vars[0];
      }
    }
  }
L196: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 406;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L197: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L198: // MOVE_INT
  int_vars[3] = int_vars[2];
L199: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0]; 
      } 
    } 
  } 
L200: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 408;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L201: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L202: // MOVE_INT
  int_vars[5] = int_vars[4];
L203: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0]; 
      } 
    } 
  } 
L204: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 408;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L205: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L206: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L207: // MOVE_INT
  int_vars[7] = int_vars[6];
L208: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0] = long_vars[2];
      }
    }
  }
L209: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 408;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L210: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L211: // MOVE_INT
  int_vars[3] = int_vars[2];
L212: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1]; 
      } 
    } 
  } 
L213: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 409;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L214: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L215: // MOVE_INT
  int_vars[5] = int_vars[4];
L216: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1]; 
      } 
    } 
  } 
L217: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 409;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L218: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L219: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L220: // MOVE_INT
  int_vars[7] = int_vars[6];
L221: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1] = long_vars[2];
      }
    }
  }
L222: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 409;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L223: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L224: // MOVE_INT
  int_vars[3] = int_vars[2];
L225: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2]; 
      } 
    } 
  } 
L226: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 410;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L227: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L228: // MOVE_INT
  int_vars[5] = int_vars[4];
L229: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2]; 
      } 
    } 
  } 
L230: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 410;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L231: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L232: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L233: // MOVE_INT
  int_vars[7] = int_vars[6];
L234: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2] = long_vars[2];
      }
    }
  }
L235: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 410;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L236: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L237: // MOVE_INT
  int_vars[3] = int_vars[2];
L238: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L239: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 411;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L240: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L241: // MOVE_INT
  int_vars[5] = int_vars[4];
L242: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L243: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 411;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L244: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L245: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L246: // MOVE_INT
  int_vars[7] = int_vars[6];
L247: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3] = long_vars[2];
      }
    }
  }
L248: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 411;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L249: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L250: // MOVE_INT
  int_vars[3] = int_vars[2];
L251: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4]; 
      } 
    } 
  } 
L252: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 413;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L253: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L254: // MOVE_INT
  int_vars[5] = int_vars[4];
L255: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4]; 
      } 
    } 
  } 
L256: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 413;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L257: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L258: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L259: // MOVE_INT
  int_vars[7] = int_vars[6];
L260: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4] = long_vars[2];
      }
    }
  }
L261: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 413;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L262: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L263: // MOVE_INT
  int_vars[3] = int_vars[2];
L264: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5]; 
      } 
    } 
  } 
L265: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 414;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L266: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L267: // MOVE_INT
  int_vars[5] = int_vars[4];
L268: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5]; 
      } 
    } 
  } 
L269: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 414;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L270: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L271: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L272: // MOVE_INT
  int_vars[7] = int_vars[6];
L273: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5] = long_vars[2];
      }
    }
  }
L274: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 414;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L275: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L276: // MOVE_INT
  int_vars[3] = int_vars[2];
L277: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6]; 
      } 
    } 
  } 
L278: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 415;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L279: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L280: // MOVE_INT
  int_vars[5] = int_vars[4];
L281: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6]; 
      } 
    } 
  } 
L282: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 415;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L283: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L284: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L285: // MOVE_INT
  int_vars[7] = int_vars[6];
L286: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6] = long_vars[2];
      }
    }
  }
L287: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 415;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L288: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L289: // MOVE_INT
  int_vars[3] = int_vars[2];
L290: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L291: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 416;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L292: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L293: // MOVE_INT
  int_vars[5] = int_vars[4];
L294: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L295: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 416;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L296: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L297: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L298: // MOVE_INT
  int_vars[7] = int_vars[6];
L299: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7] = long_vars[2];
      }
    }
  }
L300: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 416;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L301: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L302: // MOVE_INT
  int_vars[3] = int_vars[2];
L303: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8]; 
      } 
    } 
  } 
L304: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 418;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L305: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L306: // MOVE_INT
  int_vars[5] = int_vars[4];
L307: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8]; 
      } 
    } 
  } 
L308: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 418;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L309: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L310: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L311: // MOVE_INT
  int_vars[7] = int_vars[6];
L312: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8] = long_vars[2];
      }
    }
  }
L313: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 418;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L314: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L315: // MOVE_INT
  int_vars[3] = int_vars[2];
L316: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9]; 
      } 
    } 
  } 
L317: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 419;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L318: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L319: // MOVE_INT
  int_vars[5] = int_vars[4];
L320: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9]; 
      } 
    } 
  } 
L321: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 419;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L322: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L323: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L324: // MOVE_INT
  int_vars[7] = int_vars[6];
L325: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9] = long_vars[2];
      }
    }
  }
L326: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 419;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L327: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L328: // MOVE_INT
  int_vars[3] = int_vars[2];
L329: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10]; 
      } 
    } 
  } 
L330: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 420;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L331: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L332: // MOVE_INT
  int_vars[5] = int_vars[4];
L333: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10]; 
      } 
    } 
  } 
L334: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 420;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L335: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L336: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L337: // MOVE_INT
  int_vars[7] = int_vars[6];
L338: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10] = long_vars[2];
      }
    }
  }
L339: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 420;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L340: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L341: // MOVE_INT
  int_vars[3] = int_vars[2];
L342: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L343: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 421;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L344: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L345: // MOVE_INT
  int_vars[5] = int_vars[4];
L346: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L347: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 421;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L348: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L349: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L350: // MOVE_INT
  int_vars[7] = int_vars[6];
L351: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11] = long_vars[2];
      }
    }
  }
L352: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 421;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L353: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L354: // MOVE_INT
  int_vars[3] = int_vars[2];
L355: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 12]; 
      } 
    } 
  } 
L356: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 423;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L357: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L358: // MOVE_INT
  int_vars[5] = int_vars[4];
L359: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 12]; 
      } 
    } 
  } 
L360: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 423;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L361: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L362: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L363: // MOVE_INT
  int_vars[7] = int_vars[6];
L364: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 12] = long_vars[2];
      }
    }
  }
L365: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 423;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L366: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L367: // MOVE_INT
  int_vars[3] = int_vars[2];
L368: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 13]; 
      } 
    } 
  } 
L369: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 424;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L370: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L371: // MOVE_INT
  int_vars[5] = int_vars[4];
L372: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 13]; 
      } 
    } 
  } 
L373: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 424;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L374: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L375: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L376: // MOVE_INT
  int_vars[7] = int_vars[6];
L377: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 13] = long_vars[2];
      }
    }
  }
L378: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 424;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L379: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L380: // MOVE_INT
  int_vars[3] = int_vars[2];
L381: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 14]; 
      } 
    } 
  } 
L382: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 425;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L383: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L384: // MOVE_INT
  int_vars[5] = int_vars[4];
L385: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 14]; 
      } 
    } 
  } 
L386: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 425;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L387: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L388: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L389: // MOVE_INT
  int_vars[7] = int_vars[6];
L390: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 14] = long_vars[2];
      }
    }
  }
L391: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 425;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L392: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L393: // MOVE_INT
  int_vars[3] = int_vars[2];
L394: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15]; 
      } 
    } 
  } 
L395: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 426;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L396: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L397: // MOVE_INT
  int_vars[5] = int_vars[4];
L398: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15]; 
      } 
    } 
  } 
L399: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 426;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L400: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L401: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L402: // MOVE_INT
  int_vars[7] = int_vars[6];
L403: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15] = long_vars[2];
      }
    }
  }
L404: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 426;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L405: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L406: // MOVE_INT
  int_vars[3] = int_vars[2];
L407: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0]; 
      } 
    } 
  } 
L408: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 428;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L409: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L410: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 428;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L411: // MOVE_CONSTANT_INT
  int_vars[4] = 111;
L412: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[4];
L413: // ADD_LONG
  long_vars[3] = long_vars[1] + long_vars[2];
L414: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[3]);
L415: // BOOL_INT
  int_vars[0] = int_vars[0];
L416: // IF_NE_ZERO
  if (int_vars[0]) { goto L420; }
L417: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L418: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L419: // GOTO
  goto L420;
L420: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L421: // MOVE_INT
  int_vars[5] = int_vars[4];
L422: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1]; 
      } 
    } 
  } 
L423: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 432;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L424: // MOVE_CONSTANT_INT
  int_vars[6] = 142;
L425: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L426: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L427: // BOOL_INT
  int_vars[0] = int_vars[0];
L428: // IF_NE_ZERO
  if (int_vars[0]) { goto L432; }
L429: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L430: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L431: // GOTO
  goto L432;
L432: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L433: // MOVE_INT
  int_vars[5] = int_vars[4];
L434: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2]; 
      } 
    } 
  } 
L435: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 435;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L436: // MOVE_CONSTANT_INT
  int_vars[6] = 162;
L437: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L438: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L439: // BOOL_INT
  int_vars[0] = int_vars[0];
L440: // IF_NE_ZERO
  if (int_vars[0]) { goto L444; }
L441: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L442: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L443: // GOTO
  goto L444;
L444: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L445: // MOVE_INT
  int_vars[5] = int_vars[4];
L446: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L447: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 438;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L448: // MOVE_CONSTANT_INT
  int_vars[6] = 182;
L449: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L450: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L451: // BOOL_INT
  int_vars[0] = int_vars[0];
L452: // IF_NE_ZERO
  if (int_vars[0]) { goto L456; }
L453: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L454: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L455: // GOTO
  goto L456;
L456: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L457: // MOVE_INT
  int_vars[5] = int_vars[4];
L458: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 4]; 
      } 
    } 
  } 
L459: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 441;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L460: // MOVE_CONSTANT_INT
  int_vars[6] = 124;
L461: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L462: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L463: // BOOL_INT
  int_vars[0] = int_vars[0];
L464: // IF_NE_ZERO
  if (int_vars[0]) { goto L468; }
L465: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L466: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L467: // GOTO
  goto L468;
L468: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L469: // MOVE_INT
  int_vars[5] = int_vars[4];
L470: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 5]; 
      } 
    } 
  } 
L471: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 444;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L472: // MOVE_CONSTANT_INT
  int_vars[6] = 144;
L473: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L474: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L475: // BOOL_INT
  int_vars[0] = int_vars[0];
L476: // IF_NE_ZERO
  if (int_vars[0]) { goto L480; }
L477: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L478: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L479: // GOTO
  goto L480;
L480: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L481: // MOVE_INT
  int_vars[5] = int_vars[4];
L482: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 6]; 
      } 
    } 
  } 
L483: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 447;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L484: // MOVE_CONSTANT_INT
  int_vars[6] = 164;
L485: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L486: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L487: // BOOL_INT
  int_vars[0] = int_vars[0];
L488: // IF_NE_ZERO
  if (int_vars[0]) { goto L492; }
L489: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L490: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L491: // GOTO
  goto L492;
L492: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L493: // MOVE_INT
  int_vars[5] = int_vars[4];
L494: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L495: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 450;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L496: // MOVE_CONSTANT_INT
  int_vars[6] = 184;
L497: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L498: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L499: // BOOL_INT
  int_vars[0] = int_vars[0];
L500: // IF_NE_ZERO
  if (int_vars[0]) { goto L504; }
L501: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L502: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L503: // GOTO
  goto L504;
L504: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L505: // MOVE_INT
  int_vars[5] = int_vars[4];
L506: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 8]; 
      } 
    } 
  } 
L507: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 453;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L508: // MOVE_CONSTANT_INT
  int_vars[6] = 126;
L509: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L510: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L511: // BOOL_INT
  int_vars[0] = int_vars[0];
L512: // IF_NE_ZERO
  if (int_vars[0]) { goto L516; }
L513: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L514: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L515: // GOTO
  goto L516;
L516: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L517: // MOVE_INT
  int_vars[5] = int_vars[4];
L518: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 9]; 
      } 
    } 
  } 
L519: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 456;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L520: // MOVE_CONSTANT_INT
  int_vars[6] = 146;
L521: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L522: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L523: // BOOL_INT
  int_vars[0] = int_vars[0];
L524: // IF_NE_ZERO
  if (int_vars[0]) { goto L528; }
L525: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L526: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L527: // GOTO
  goto L528;
L528: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L529: // MOVE_INT
  int_vars[5] = int_vars[4];
L530: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 10]; 
      } 
    } 
  } 
L531: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 459;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L532: // MOVE_CONSTANT_INT
  int_vars[6] = 166;
L533: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L534: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L535: // BOOL_INT
  int_vars[0] = int_vars[0];
L536: // IF_NE_ZERO
  if (int_vars[0]) { goto L540; }
L537: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L538: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L539: // GOTO
  goto L540;
L540: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L541: // MOVE_INT
  int_vars[5] = int_vars[4];
L542: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L543: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 462;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L544: // MOVE_CONSTANT_INT
  int_vars[6] = 186;
L545: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L546: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L547: // BOOL_INT
  int_vars[0] = int_vars[0];
L548: // IF_NE_ZERO
  if (int_vars[0]) { goto L552; }
L549: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L550: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L551: // GOTO
  goto L552;
L552: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L553: // MOVE_INT
  int_vars[5] = int_vars[4];
L554: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 3]; 
      } 
    } 
  } 
L555: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 465;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L556: // MOVE_CONSTANT_INT
  int_vars[6] = 182;
L557: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L558: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L559: // BOOL_INT
  int_vars[0] = int_vars[0];
L560: // IF_NE_ZERO
  if (int_vars[0]) { goto L564; }
L561: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L562: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L563: // GOTO
  goto L564;
L564: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L565: // MOVE_INT
  int_vars[5] = int_vars[4];
L566: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 7]; 
      } 
    } 
  } 
L567: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 468;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L568: // MOVE_CONSTANT_INT
  int_vars[6] = 184;
L569: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L570: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L571: // BOOL_INT
  int_vars[0] = int_vars[0];
L572: // IF_NE_ZERO
  if (int_vars[0]) { goto L576; }
L573: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L574: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L575: // GOTO
  goto L576;
L576: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L577: // MOVE_INT
  int_vars[5] = int_vars[4];
L578: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 11]; 
      } 
    } 
  } 
L579: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 471;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L580: // MOVE_CONSTANT_INT
  int_vars[6] = 186;
L581: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L582: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L583: // BOOL_INT
  int_vars[0] = int_vars[0];
L584: // IF_NE_ZERO
  if (int_vars[0]) { goto L588; }
L585: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L586: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L587: // GOTO
  goto L588;
L588: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L589: // MOVE_INT
  int_vars[5] = int_vars[4];
L590: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[16 * index + 15]; 
      } 
    } 
  } 
L591: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_long";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 474;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L604;
  }
L592: // MOVE_CONSTANT_INT
  int_vars[6] = 188;
L593: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L594: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L595: // BOOL_INT
  int_vars[0] = int_vars[0];
L596: // IF_NE_ZERO
  if (int_vars[0]) { goto L600; }
L597: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L598: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L604;
L599: // GOTO
  goto L600;
L600: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L601: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L604;
L602: // INIT_INT
  int_vars[6] = 0;
L603: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L604;
L604: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L605: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ValueArray__value_array_max_fields_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Matrix4_16s < 0) {
      BASIC_TYPE_ID_TestCase__Matrix4_16s = env->get_basic_type_id(env, "TestCase::Matrix4_16s");
      if (BASIC_TYPE_ID_TestCase__Matrix4_16s < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Matrix4_16s");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Matrix4_16s;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 134;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L5: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 136;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // MOVE_INT
  int_vars[3] = int_vars[2];
L9: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[16 * index + 0] = short_vars[0];
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 136;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 21;
L12: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // MOVE_INT
  int_vars[4] = int_vars[3];
L15: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[16 * index + 1] = short_vars[0];
      }
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 137;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L653;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 31;
L18: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // MOVE_INT
  int_vars[4] = int_vars[3];
L21: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[16 * index + 2] = short_vars[0];
      }
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ValueArray";
    const char* sub_name = "value_array_max_fields_short";
    const char* file = "TestCase/ValueArray.spvm";
    int32_t line = 138;
    env->set_ex