use Test::More tests => 2;

use Graph::Undirected;

my $g1 = Graph::Undirected->new;
my $g2 = Graph::Undirected->new;

while (<DATA>) {
    my ($u, $v) = split(' ');
    $g1->add_edge($u, $v);
    $g2->add_edge($u, $v);
}

my @d = (
	 'Ht001a_ome01:6/1',
	 'Bd001a_ome01:5/1',
	 'Bd001a_ome01:10/1',
	 'Ddt001a_ome01:9/1',
	 'Ddt001a_ome01:1/4',
	);

$g1->set_edge_weight("Asd001a_ome01:9/1", "Asd001a_ome05:10/1", 30);
my @w1 = $g1->SP_Dijkstra("Ht001a_ome01:6/1", "Ddt001a_ome01:1/4");

is_deeply(\@w1, \@d);

my @v2 = $g2->SP_Dijkstra("Ht001a_ome01:6/1", "Ddt001a_ome01:1/4");
$g2->set_edge_weight("Asd001a_ome01:9/1", "Asd001a_ome05:10/1", 30);
my @w2 = $g2->SP_Dijkstra("Ht001a_ome01:6/1", "Ddt001a_ome01:1/4");

is_deeply(\@w2, \@d);

__END__
Ah001a_ome01:1/1 Ah001a_ome01:1/2
Ah001a_ome01:1/1 Ah001a_ome01:1/3
Ah001a_ome01:1/1 Ah001a_ome01:1/4
Ah001a_ome01:1/1 Ah001a_ome01:2/1
Ah001a_ome01:1/1 Ah001a_ome01:2/2
Ah001a_ome01:1/1 Ah001a_ome01:2/3
Ah001a_ome01:1/1 Ah001a_ome01:2/4
Ah001a_ome01:1/1 Ah001a_ome01:6/1
Ah001a_ome01:1/1 Ah001a_ome01:9/1
Ah001a_ome01:1/2 Ah001a_ome01:1/1
Ah001a_ome01:1/2 Ah001a_ome01:1/3
Ah001a_ome01:1/2 Ah001a_ome01:1/4
Ah001a_ome01:1/2 Ah001a_ome01:2/1
Ah001a_ome01:1/2 Ah001a_ome01:2/2
Ah001a_ome01:1/2 Ah001a_ome01:2/3
Ah001a_ome01:1/2 Ah001a_ome01:2/4
Ah001a_ome01:1/2 Ah001a_ome01:6/1
Ah001a_ome01:1/2 Ah001a_ome01:9/1
Ah001a_ome01:1/3 Ah001a_ome01:1/1
Ah001a_ome01:1/3 Ah001a_ome01:1/2
Ah001a_ome01:1/3 Ah001a_ome01:1/4
Ah001a_ome01:1/3 Ah001a_ome01:2/1
Ah001a_ome01:1/3 Ah001a_ome01:2/2
Ah001a_ome01:1/3 Ah001a_ome01:2/3
Ah001a_ome01:1/3 Ah001a_ome01:2/4
Ah001a_ome01:1/3 Ah001a_ome01:6/1
Ah001a_ome01:1/3 Ah001a_ome01:9/1
Ah001a_ome01:1/4 Ah001a_ome01:1/1
Ah001a_ome01:1/4 Ah001a_ome01:1/2
Ah001a_ome01:1/4 Ah001a_ome01:1/3
Ah001a_ome01:1/4 Ah001a_ome01:2/1
Ah001a_ome01:1/4 Ah001a_ome01:2/2
Ah001a_ome01:1/4 Ah001a_ome01:2/3
Ah001a_ome01:1/4 Ah001a_ome01:2/4
Ah001a_ome01:1/4 Ah001a_ome01:6/1
Ah001a_ome01:1/4 Ah001a_ome01:9/1
Ah001a_ome01:2/1 Ah001a_ome01:1/1
Ah001a_ome01:2/1 Ah001a_ome01:1/2
Ah001a_ome01:2/1 Ah001a_ome01:1/3
Ah001a_ome01:2/1 Ah001a_ome01:1/4
Ah001a_ome01:2/1 Ah001a_ome01:2/2
Ah001a_ome01:2/1 Ah001a_ome01:2/3
Ah001a_ome01:2/1 Ah001a_ome01:2/4
Ah001a_ome01:2/1 Ah001a_ome01:6/1
Ah001a_ome01:2/1 Ah001a_ome01:9/1
Ah001a_ome01:2/2 Ah001a_ome01:1/1
Ah001a_ome01:2/2 Ah001a_ome01:1/2
Ah001a_ome01:2/2 Ah001a_ome01:1/3
Ah001a_ome01:2/2 Ah001a_ome01:1/4
Ah001a_ome01:2/2 Ah001a_ome01:2/1
Ah001a_ome01:2/2 Ah001a_ome01:2/3
Ah001a_ome01:2/2 Ah001a_ome01:2/4
Ah001a_ome01:2/2 Ah001a_ome01:6/1
Ah001a_ome01:2/2 Ah001a_ome01:9/1
Ah001a_ome01:2/3 Ah001a_ome01:1/1
Ah001a_ome01:2/3 Ah001a_ome01:1/2
Ah001a_ome01:2/3 Ah001a_ome01:1/3
Ah001a_ome01:2/3 Ah001a_ome01:1/4
Ah001a_ome01:2/3 Ah001a_ome01:2/1
Ah001a_ome01:2/3 Ah001a_ome01:2/2
Ah001a_ome01:2/3 Ah001a_ome01:2/4
Ah001a_ome01:2/3 Ah001a_ome01:6/1
Ah001a_ome01:2/3 Ah001a_ome01:9/1
Ah001a_ome01:2/4 Ah001a_ome01:1/1
Ah001a_ome01:2/4 Ah001a_ome01:1/2
Ah001a_ome01:2/4 Ah001a_ome01:1/3
Ah001a_ome01:2/4 Ah001a_ome01:1/4
Ah001a_ome01:2/4 Ah001a_ome01:2/1
Ah001a_ome01:2/4 Ah001a_ome01:2/2
Ah001a_ome01:2/4 Ah001a_ome01:2/3
Ah001a_ome01:2/4 Ah001a_ome01:6/1
Ah001a_ome01:2/4 Ah001a_ome01:9/1
Ah001a_ome01:6/1 Ah001a_ome01:1/1
Ah001a_ome01:6/1 Ah001a_ome01:1/2
Ah001a_ome01:6/1 Ah001a_ome01:1/3
Ah001a_ome01:6/1 Ah001a_ome01:1/4
Ah001a_ome01:6/1 Ah001a_ome01:2/1
Ah001a_ome01:6/1 Ah001a_ome01:2/2
Ah001a_ome01:6/1 Ah001a_ome01:2/3
Ah001a_ome01:6/1 Ah001a_ome01:2/4
Ah001a_ome01:6/1 Ah001a_ome01:9/1
Ah001a_ome01:6/1 Ap001a_ome01:9/1
Ah001a_ome01:9/1 Ah001a_ome01:1/1
Ah001a_ome01:9/1 Ah001a_ome01:1/2
Ah001a_ome01:9/1 Ah001a_ome01:1/3
Ah001a_ome01:9/1 Ah001a_ome01:1/4
Ah001a_ome01:9/1 Ah001a_ome01:2/1
Ah001a_ome01:9/1 Ah001a_ome01:2/2
Ah001a_ome01:9/1 Ah001a_ome01:2/3
Ah001a_ome01:9/1 Ah001a_ome01:2/4
Ah001a_ome01:9/1 Ah001a_ome01:6/1
Ah001a_ome01:9/1 Nm001a_ome01:6/1
Ap001a_ome01:1/1 Ap001a_ome01:1/2
Ap001a_ome01:1/1 Ap001a_ome01:1/3
Ap001a_ome01:1/1 Ap001a_ome01:1/4
Ap001a_ome01:1/1 Ap001a_ome01:14/1
Ap001a_ome01:1/1 Ap001a_ome01:14/2
Ap001a_ome01:1/1 Ap001a_ome01:14/3
Ap001a_ome01:1/1 Ap001a_ome01:14/4
Ap001a_ome01:1/1 Ap001a_ome01:6/1
Ap001a_ome01:1/1 Ap001a_ome01:9/1
Ap001a_ome01:1/2 Ap001a_ome01:1/1
Ap001a_ome01:1/2 Ap001a_ome01:1/3
Ap001a_ome01:1/2 Ap001a_ome01:1/4
Ap001a_ome01:1/2 Ap001a_ome01:14/1
Ap001a_ome01:1/2 Ap001a_ome01:14/2
Ap001a_ome01:1/2 Ap001a_ome01:14/3
Ap001a_ome01:1/2 Ap001a_ome01:14/4
Ap001a_ome01:1/2 Ap001a_ome01:6/1
Ap001a_ome01:1/2 Ap001a_ome01:9/1
Ap001a_ome01:1/3 Ap001a_ome01:1/1
Ap001a_ome01:1/3 Ap001a_ome01:1/2
Ap001a_ome01:1/3 Ap001a_ome01:1/4
Ap001a_ome01:1/3 Ap001a_ome01:14/1
Ap001a_ome01:1/3 Ap001a_ome01:14/2
Ap001a_ome01:1/3 Ap001a_ome01:14/3
Ap001a_ome01:1/3 Ap001a_ome01:14/4
Ap001a_ome01:1/3 Ap001a_ome01:6/1
Ap001a_ome01:1/3 Ap001a_ome01:9/1
Ap001a_ome01:1/4 Ap001a_ome01:1/1
Ap001a_ome01:1/4 Ap001a_ome01:1/2
Ap001a_ome01:1/4 Ap001a_ome01:1/3
Ap001a_ome01:1/4 Ap001a_ome01:14/1
Ap001a_ome01:1/4 Ap001a_ome01:14/2
Ap001a_ome01:1/4 Ap001a_ome01:14/3
Ap001a_ome01:1/4 Ap001a_ome01:14/4
Ap001a_ome01:1/4 Ap001a_ome01:6/1
Ap001a_ome01:1/4 Ap001a_ome01:9/1
Ap001a_ome01:14/1 Ap001a_ome01:1/1
Ap001a_ome01:14/1 Ap001a_ome01:1/2
Ap001a_ome01:14/1 Ap001a_ome01:1/3
Ap001a_ome01:14/1 Ap001a_ome01:1/4
Ap001a_ome01:14/1 Ap001a_ome01:14/2
Ap001a_ome01:14/1 Ap001a_ome01:14/3
Ap001a_ome01:14/1 Ap001a_ome01:14/4
Ap001a_ome01:14/1 Ap001a_ome01:6/1
Ap001a_ome01:14/1 Ap001a_ome01:9/1
Ap001a_ome01:14/2 Ap001a_ome01:1/1
Ap001a_ome01:14/2 Ap001a_ome01:1/2
Ap001a_ome01:14/2 Ap001a_ome01:1/3
Ap001a_ome01:14/2 Ap001a_ome01:1/4
Ap001a_ome01:14/2 Ap001a_ome01:14/1
Ap001a_ome01:14/2 Ap001a_ome01:14/3
Ap001a_ome01:14/2 Ap001a_ome01:14/4
Ap001a_ome01:14/2 Ap001a_ome01:6/1
Ap001a_ome01:14/2 Ap001a_ome01:9/1
Ap001a_ome01:14/3 Ap001a_ome01:1/1
Ap001a_ome01:14/3 Ap001a_ome01:1/2
Ap001a_ome01:14/3 Ap001a_ome01:1/3
Ap001a_ome01:14/3 Ap001a_ome01:1/4
Ap001a_ome01:14/3 Ap001a_ome01:14/1
Ap001a_ome01:14/3 Ap001a_ome01:14/2
Ap001a_ome01:14/3 Ap001a_ome01:14/4
Ap001a_ome01:14/3 Ap001a_ome01:6/1
Ap001a_ome01:14/3 Ap001a_ome01:9/1
Ap001a_ome01:14/4 Ap001a_ome01:1/1
Ap001a_ome01:14/4 Ap001a_ome01:1/2
Ap001a_ome01:14/4 Ap001a_ome01:1/3
Ap001a_ome01:14/4 Ap001a_ome01:1/4
Ap001a_ome01:14/4 Ap001a_ome01:14/1
Ap001a_ome01:14/4 Ap001a_ome01:14/2
Ap001a_ome01:14/4 Ap001a_ome01:14/3
Ap001a_ome01:14/4 Ap001a_ome01:6/1
Ap001a_ome01:14/4 Ap001a_ome01:9/1
Ap001a_ome01:6/1 Ap001a_ome01:1/1
Ap001a_ome01:6/1 Ap001a_ome01:1/2
Ap001a_ome01:6/1 Ap001a_ome01:1/3
Ap001a_ome01:6/1 Ap001a_ome01:1/4
Ap001a_ome01:6/1 Ap001a_ome01:14/1
Ap001a_ome01:6/1 Ap001a_ome01:14/2
Ap001a_ome01:6/1 Ap001a_ome01:14/3
Ap001a_ome01:6/1 Ap001a_ome01:14/4
Ap001a_ome01:6/1 Ap001a_ome01:9/1
Ap001a_ome01:6/1 Zl001a_ome01:9/1
Ap001a_ome01:9/1 Ah001a_ome01:6/1
Ap001a_ome01:9/1 Ap001a_ome01:1/1
Ap001a_ome01:9/1 Ap001a_ome01:1/2
Ap001a_ome01:9/1 Ap001a_ome01:1/3
Ap001a_ome01:9/1 Ap001a_ome01:1/4
Ap001a_ome01:9/1 Ap001a_ome01:14/1
Ap001a_ome01:9/1 Ap001a_ome01:14/2
Ap001a_ome01:9/1 Ap001a_ome01:14/3
Ap001a_ome01:9/1 Ap001a_ome01:14/4
Ap001a_ome01:9/1 Ap001a_ome01:6/1
Asd001a_ome01:1/1 Asd001a_ome01:1/2
Asd001a_ome01:1/1 Asd001a_ome01:10/1
Asd001a_ome01:1/1 Asd001a_ome01:3/1
Asd001a_ome01:1/1 Asd001a_ome01:4/1
Asd001a_ome01:1/1 Asd001a_ome01:5/1
Asd001a_ome01:1/1 Asd001a_ome01:6/1
Asd001a_ome01:1/1 Asd001a_ome01:9/1
Asd001a_ome01:1/1 Asd001a_ome02:1/1
Asd001a_ome01:1/2 Asd001a_ome01:1/1
Asd001a_ome01:1/2 Asd001a_ome01:10/1
Asd001a_ome01:1/2 Asd001a_ome01:3/1
Asd001a_ome01:1/2 Asd001a_ome01:4/1
Asd001a_ome01:1/2 Asd001a_ome01:5/1
Asd001a_ome01:1/2 Asd001a_ome01:6/1
Asd001a_ome01:1/2 Asd001a_ome01:9/1
Asd001a_ome01:1/2 Asd001a_ome02:1/2
Asd001a_ome01:10/1 Asd001a_ome01:1/1
Asd001a_ome01:10/1 Asd001a_ome01:1/2
Asd001a_ome01:10/1 Asd001a_ome01:3/1
Asd001a_ome01:10/1 Asd001a_ome01:4/1
Asd001a_ome01:10/1 Asd001a_ome01:5/1
Asd001a_ome01:10/1 Asd001a_ome01:6/1
Asd001a_ome01:10/1 Asd001a_ome01:9/1
Asd001a_ome01:10/1 Asd002a_ome01:10/1
Asd001a_ome01:3/1 Asd001a_ome01:1/1
Asd001a_ome01:3/1 Asd001a_ome01:1/2
Asd001a_ome01:3/1 Asd001a_ome01:10/1
Asd001a_ome01:3/1 Asd001a_ome01:4/1
Asd001a_ome01:3/1 Asd001a_ome01:5/1
Asd001a_ome01:3/1 Asd001a_ome01:6/1
Asd001a_ome01:3/1 Asd001a_ome01:9/1
Asd001a_ome01:3/1 Ut001a_ome01:6/1
Asd001a_ome01:4/1 Asd001a_ome01:1/1
Asd001a_ome01:4/1 Asd001a_ome01:1/2
Asd001a_ome01:4/1 Asd001a_ome01:10/1
Asd001a_ome01:4/1 Asd001a_ome01:3/1
Asd001a_ome01:4/1 Asd001a_ome01:5/1
Asd001a_ome01:4/1 Asd001a_ome01:6/1
Asd001a_ome01:4/1 Asd001a_ome01:9/1
Asd001a_ome01:4/1 Ledn001a_ome01:5/1
Asd001a_ome01:5/1 Asd001a_ome01:1/1
Asd001a_ome01:5/1 Asd001a_ome01:1/2
Asd001a_ome01:5/1 Asd001a_ome01:10/1
Asd001a_ome01:5/1 Asd001a_ome01:3/1
Asd001a_ome01:5/1 Asd001a_ome01:4/1
Asd001a_ome01:5/1 Asd001a_ome01:6/1
Asd001a_ome01:5/1 Asd001a_ome01:9/1
Asd001a_ome01:5/1 Asd001a_ome03:10/1
Asd001a_ome01:6/1 Asd001a_ome01:1/1
Asd001a_ome01:6/1 Asd001a_ome01:1/2
Asd001a_ome01:6/1 Asd001a_ome01:10/1
Asd001a_ome01:6/1 Asd001a_ome01:3/1
Asd001a_ome01:6/1 Asd001a_ome01:4/1
Asd001a_ome01:6/1 Asd001a_ome01:5/1
Asd001a_ome01:6/1 Asd001a_ome01:9/1
Asd001a_ome01:6/1 Asd001a_ome04:10/1
Asd001a_ome01:9/1 Asd001a_ome01:1/1
Asd001a_ome01:9/1 Asd001a_ome01:1/2
Asd001a_ome01:9/1 Asd001a_ome01:10/1
Asd001a_ome01:9/1 Asd001a_ome01:3/1
Asd001a_ome01:9/1 Asd001a_ome01:4/1
Asd001a_ome01:9/1 Asd001a_ome01:5/1
Asd001a_ome01:9/1 Asd001a_ome01:6/1
Asd001a_ome01:9/1 Asd001a_ome05:10/1
Asd001a_ome02:1/1 Asd001a_ome01:1/1
Asd001a_ome02:1/1 Asd001a_ome02:1/2
Asd001a_ome02:1/1 Asd001a_ome02:10/1
Asd001a_ome02:1/1 Asd001a_ome02:4/1
Asd001a_ome02:1/1 Asd001a_ome02:5/1
Asd001a_ome02:1/1 Asd001a_ome02:6/1
Asd001a_ome02:1/2 Asd001a_ome01:1/2
Asd001a_ome02:1/2 Asd001a_ome02:1/1
Asd001a_ome02:1/2 Asd001a_ome02:10/1
Asd001a_ome02:1/2 Asd001a_ome02:4/1
Asd001a_ome02:1/2 Asd001a_ome02:5/1
Asd001a_ome02:1/2 Asd001a_ome02:6/1
Asd001a_ome02:10/1 Asd001a_ome02:1/1
Asd001a_ome02:10/1 Asd001a_ome02:1/2
Asd001a_ome02:10/1 Asd001a_ome02:4/1
Asd001a_ome02:10/1 Asd001a_ome02:5/1
Asd001a_ome02:10/1 Asd001a_ome02:6/1
Asd001a_ome02:10/1 Asd002a_ome02:10/1
Asd001a_ome02:4/1 Asd001a_ome02:1/1
Asd001a_ome02:4/1 Asd001a_ome02:1/2
Asd001a_ome02:4/1 Asd001a_ome02:10/1
Asd001a_ome02:4/1 Asd001a_ome02:5/1
Asd001a_ome02:4/1 Asd001a_ome02:6/1
Asd001a_ome02:4/1 Nm001a_ome02:6/1
Asd001a_ome02:5/1 Asd001a_ome02:1/1
Asd001a_ome02:5/1 Asd001a_ome02:1/2
Asd001a_ome02:5/1 Asd001a_ome02:10/1
Asd001a_ome02:5/1 Asd001a_ome02:4/1
Asd001a_ome02:5/1 Asd001a_ome02:6/1
Asd001a_ome02:5/1 Asd001a_ome06:10/1
Asd001a_ome02:6/1 Asd001a_ome02:1/1
Asd001a_ome02:6/1 Asd001a_ome02:1/2
Asd001a_ome02:6/1 Asd001a_ome02:10/1
Asd001a_ome02:6/1 Asd001a_ome02:4/1
Asd001a_ome02:6/1 Asd001a_ome02:5/1
Asd001a_ome02:6/1 Asd001a_ome07:10/1
Asd001a_ome03:1/1 Asd001a_ome03:1/2
Asd001a_ome03:1/1 Asd001a_ome03:1/3
Asd001a_ome03:1/1 Asd001a_ome03:1/4
Asd001a_ome03:1/1 Asd001a_ome03:10/1
Asd001a_ome03:1/1 Asd001a_ome03:2/1
Asd001a_ome03:1/1 Asd001a_ome03:2/2
Asd001a_ome03:1/1 Asd001a_ome03:2/3
Asd001a_ome03:1/1 Asd001a_ome03:5/1
Asd001a_ome03:1/1 Asd001a_ome03:6/1
Asd001a_ome03:1/1 Asd001a_ome03:9/1
Asd001a_ome03:1/2 Asd001a_ome03:1/1
Asd001a_ome03:1/2 Asd001a_ome03:1/3
Asd001a_ome03:1/2 Asd001a_ome03:1/4
Asd001a_ome03:1/2 Asd001a_ome03:10/1
Asd001a_ome03:1/2 Asd001a_ome03:2/1
Asd001a_ome03:1/2 Asd001a_ome03:2/2
Asd001a_ome03:1/2 Asd001a_ome03:2/3
Asd001a_ome03:1/2 Asd001a_ome03:5/1
Asd001a_ome03:1/2 Asd001a_ome03:6/1
Asd001a_ome03:1/2 Asd001a_ome03:9/1
Asd001a_ome03:1/3 Asd001a_ome03:1/1
Asd001a_ome03:1/3 Asd001a_ome03:1/2
Asd001a_ome03:1/3 Asd001a_ome03:1/4
Asd001a_ome03:1/3 Asd001a_ome03:10/1
Asd001a_ome03:1/3 Asd001a_ome03:2/1
Asd001a_ome03:1/3 Asd001a_ome03:2/2
Asd001a_ome03:1/3 Asd001a_ome03:2/3
Asd001a_ome03:1/3 Asd001a_ome03:5/1
Asd001a_ome03:1/3 Asd001a_ome03:6/1
Asd001a_ome03:1/3 Asd001a_ome03:9/1
Asd001a_ome03:1/4 Asd001a_ome03:1/1
Asd001a_ome03:1/4 Asd001a_ome03:1/2
Asd001a_ome03:1/4 Asd001a_ome03:1/3
Asd001a_ome03:1/4 Asd001a_ome03:10/1
Asd001a_ome03:1/4 Asd001a_ome03:2/1
Asd001a_ome03:1/4 Asd001a_ome03:2/2
Asd001a_ome03:1/4 Asd001a_ome03:2/3
Asd001a_ome03:1/4 Asd001a_ome03:5/1
Asd001a_ome03:1/4 Asd001a_ome03:6/1
Asd001a_ome03:1/4 Asd001a_ome03:9/1
Asd001a_ome03:10/1 Asd001a_ome01:5/1
Asd001a_ome03:10/1 Asd001a_ome03:1/1
Asd001a_ome03:10/1 Asd001a_ome03:1/2
Asd001a_ome03:10/1 Asd001a_ome03:1/3
Asd001a_ome03:10/1 Asd001a_ome03:1/4
Asd001a_ome03:10/1 Asd001a_ome03:2/1
Asd001a_ome03:10/1 Asd001a_ome03:2/2
Asd001a_ome03:10/1 Asd001a_ome03:2/3
Asd001a_ome03:10/1 Asd001a_ome03:5/1
Asd001a_ome03:10/1 Asd001a_ome03:6/1
Asd001a_ome03:10/1 Asd001a_ome03:9/1
Asd001a_ome03:2/1 Asd001a_ome03:1/1
Asd001a_ome03:2/1 Asd001a_ome03:1/2
Asd001a_ome03:2/1 Asd001a_ome03:1/3
Asd001a_ome03:2/1 Asd001a_ome03:1/4
Asd001a_ome03:2/1 Asd001a_ome03:10/1
Asd001a_ome03:2/1 Asd001a_ome03:2/2
Asd001a_ome03:2/1 Asd001a_ome03:2/3
Asd001a_ome03:2/1 Asd001a_ome03:5/1
Asd001a_ome03:2/1 Asd001a_ome03:6/1
Asd001a_ome03:2/1 Asd001a_ome03:9/1
Asd001a_ome03:2/2 Asd001a_ome03:1/1
Asd001a_ome03:2/2 Asd001a_ome03:1/2
Asd001a_ome03:2/2 Asd001a_ome03:1/3
Asd001a_ome03:2/2 Asd001a_ome03:1/4
Asd001a_ome03:2/2 Asd001a_ome03:10/1
Asd001a_ome03:2/2 Asd001a_ome03:2/1
Asd001a_ome03:2/2 Asd001a_ome03:2/3
Asd001a_ome03:2/2 Asd001a_ome03:5/1
Asd001a_ome03:2/2 Asd001a_ome03:6/1
Asd001a_ome03:2/2 Asd001a_ome03:9/1
Asd001a_ome03:2/3 Asd001a_ome03:1/1
Asd001a_ome03:2/3 Asd001a_ome03:1/2
Asd001a_ome03:2/3 Asd001a_ome03:1/3
Asd001a_ome03:2/3 Asd001a_ome03:1/4
Asd001a_ome03:2/3 Asd001a_ome03:10/1
Asd001a_ome03:2/3 Asd001a_ome03:2/1
Asd001a_ome03:2/3 Asd001a_ome03:2/2
Asd001a_ome03:2/3 Asd001a_ome03:5/1
Asd001a_ome03:2/3 Asd001a_ome03:6/1
Asd001a_ome03:2/3 Asd001a_ome03:9/1
Asd001a_ome03:5/1 Asd001a_ome03:1/1
Asd001a_ome03:5/1 Asd001a_ome03:1/2
Asd001a_ome03:5/1 Asd001a_ome03:1/3
Asd001a_ome03:5/1 Asd001a_ome03:1/4
Asd001a_ome03:5/1 Asd001a_ome03:10/1
Asd001a_ome03:5/1 Asd001a_ome03:2/1
Asd001a_ome03:5/1 Asd001a_ome03:2/2
Asd001a_ome03:5/1 Asd001a_ome03:2/3
Asd001a_ome03:5/1 Asd001a_ome03:6/1
Asd001a_ome03:5/1 Asd001a_ome03:9/1
Asd001a_ome03:5/1 Spl001a_ome01:6/1
Asd001a_ome03:6/1 Asd001a_ome03:1/1
Asd001a_ome03:6/1 Asd001a_ome03:1/2
Asd001a_ome03:6/1 Asd001a_ome03:1/3
Asd001a_ome03:6/1 Asd001a_ome03:1/4
Asd001a_ome03:6/1 Asd001a_ome03:10/1
Asd001a_ome03:6/1 Asd001a_ome03:2/1
Asd001a_ome03:6/1 Asd001a_ome03:2/2
Asd001a_ome03:6/1 Asd001a_ome03:2/3
Asd001a_ome03:6/1 Asd001a_ome03:5/1
Asd001a_ome03:6/1 Asd001a_ome03:9/1
Asd001a_ome03:6/1 Gv001a_ome01:6/1
Asd001a_ome03:9/1 Asd001a_ome03:1/1
Asd001a_ome03:9/1 Asd001a_ome03:1/2
Asd001a_ome03:9/1 Asd001a_ome03:1/3
Asd001a_ome03:9/1 Asd001a_ome03:1/4
Asd001a_ome03:9/1 Asd001a_ome03:10/1
Asd001a_ome03:9/1 Asd001a_ome03:2/1
Asd001a_ome03:9/1 Asd001a_ome03:2/2
Asd001a_ome03:9/1 Asd001a_ome03:2/3
Asd001a_ome03:9/1 Asd001a_ome03:5/1
Asd001a_ome03:9/1 Asd001a_ome03:6/1
Asd001a_ome03:9/1 Dt001a_ome01:6/1
Asd001a_ome04:1/1 Asd001a_ome04:1/2
Asd001a_ome04:1/1 Asd001a_ome04:1/3
Asd001a_ome04:1/1 Asd001a_ome04:1/4
Asd001a_ome04:1/1 Asd001a_ome04:10/1
Asd001a_ome04:1/1 Asd001a_ome04:2/1
Asd001a_ome04:1/1 Asd001a_ome04:2/2
Asd001a_ome04:1/1 Asd001a_ome04:2/3
Asd001a_ome04:1/1 Asd001a_ome04:6/1
Asd001a_ome04:1/1 Asd001a_ome04:9/1
Asd001a_ome04:1/2 Asd001a_ome04:1/1
Asd001a_ome04:1/2 Asd001a_ome04:1/3
Asd001a_ome04:1/2 Asd001a_ome04:1/4
Asd001a_ome04:1/2 Asd001a_ome04:10/1
Asd001a_ome04:1/2 Asd001a_ome04:2/1
Asd001a_ome04:1/2 Asd001a_ome04:2/2
Asd001a_ome04:1/2 Asd001a_ome04:2/3
Asd001a_ome04:1/2 Asd001a_ome04:6/1
Asd001a_ome04:1/2 Asd001a_ome04:9/1
Asd001a_ome04:1/3 Asd001a_ome04:1/1
Asd001a_ome04:1/3 Asd001a_ome04:1/2
Asd001a_ome04:1/3 Asd001a_ome04:1/4
Asd001a_ome04:1/3 Asd001a_ome04:10/1
Asd001a_ome04:1/3 Asd001a_ome04:2/1
Asd001a_ome04:1/3 Asd001a_ome04:2/2
Asd001a_ome04:1/3 Asd001a_ome04:2/3
Asd001a_ome04:1/3 Asd001a_ome04:6/1
Asd001a_ome04:1/3 Asd001a_ome04:9/1
Asd001a_ome04:1/4 Asd001a_ome04:1/1
Asd001a_ome04:1/4 Asd001a_ome04:1/2
Asd001a_ome04:1/4 Asd001a_ome04:1/3
Asd001a_ome04:1/4 Asd001a_ome04:10/1
Asd001a_ome04:1/4 Asd001a_ome04:2/1
Asd001a_ome04:1/4 Asd001a_ome04:2/2
Asd001a_ome04:1/4 Asd001a_ome04:2/3
Asd001a_ome04:1/4 Asd001a_ome04:6/1
Asd001a_ome04:1/4 Asd001a_ome04:9/1
Asd001a_ome04:10/1 Asd001a_ome01:6/1
Asd001a_ome04:10/1 Asd001a_ome04:1/1
Asd001a_ome04:10/1 Asd001a_ome04:1/2
Asd001a_ome04:10/1 Asd001a_ome04:1/3
Asd001a_ome04:10/1 Asd001a_ome04:1/4
Asd001a_ome04:10/1 Asd001a_ome04:2/1
Asd001a_ome04:10/1 Asd001a_ome04:2/2
Asd001a_ome04:10/1 Asd001a_ome04:2/3
Asd001a_ome04:10/1 Asd001a_ome04:6/1
Asd001a_ome04:10/1 Asd001a_ome04:9/1
Asd001a_ome04:2/1 Asd001a_ome04:1/1
Asd001a_ome04:2/1 Asd001a_ome04:1/2
Asd001a_ome04:2/1 Asd001a_ome04:1/3
Asd001a_ome04:2/1 Asd001a_ome04:1/4
Asd001a_ome04:2/1 Asd001a_ome04:10/1
Asd001a_ome04:2/1 Asd001a_ome04:2/2
Asd001a_ome04:2/1 Asd001a_ome04:2/3
Asd001a_ome04:2/1 Asd001a_ome04:6/1
Asd001a_ome04:2/1 Asd001a_ome04:9/1
Asd001a_ome04:2/2 Asd001a_ome04:1/1
Asd001a_ome04:2/2 Asd001a_ome04:1/2
Asd001a_ome04:2/2 Asd001a_ome04:1/3
Asd001a_ome04:2/2 Asd001a_ome04:1/4
Asd001a_ome04:2/2 Asd001a_ome04:10/1
Asd001a_ome04:2/2 Asd001a_ome04:2/1
Asd001a_ome04:2/2 Asd001a_ome04:2/3
Asd001a_ome04:2/2 Asd001a_ome04:6/1
Asd001a_ome04:2/2 Asd001a_ome04:9/1
Asd001a_ome04:2/3 Asd001a_ome04:1/1
Asd001a_ome04:2/3 Asd001a_ome04:1/2
Asd001a_ome04:2/3 Asd001a_ome04:1/3
Asd001a_ome04:2/3 Asd001a_ome04:1/4
Asd001a_ome04:2/3 Asd001a_ome04:10/1
Asd001a_ome04:2/3 Asd001a_ome04:2/1
Asd001a_ome04:2/3 Asd001a_ome04:2/2
Asd001a_ome04:2/3 Asd001a_ome04:6/1
Asd001a_ome04:2/3 Asd001a_ome04:9/1
Asd001a_ome04:6/1 Asd001a_ome04:1/1
Asd001a_ome04:6/1 Asd001a_ome04:1/2
Asd001a_ome04:6/1 Asd001a_ome04:1/3
Asd001a_ome04:6/1 Asd001a_ome04:1/4
Asd001a_ome04:6/1 Asd001a_ome04:10/1
Asd001a_ome04:6/1 Asd001a_ome04:2/1
Asd001a_ome04:6/1 Asd001a_ome04:2/2
Asd001a_ome04:6/1 Asd001a_ome04:2/3
Asd001a_ome04:6/1 Asd001a_ome04:9/1
Asd001a_ome04:6/1 Hvs001a_ome01:6/1
Asd001a_ome04:9/1 Asd001a_ome04:1/1
Asd001a_ome04:9/1 Asd001a_ome04:1/2
Asd001a_ome04:9/1 Asd001a_ome04:1/3
Asd001a_ome04:9/1 Asd001a_ome04:1/4
Asd001a_ome04:9/1 Asd001a_ome04:10/1
Asd001a_ome04:9/1 Asd001a_ome04:2/1
Asd001a_ome04:9/1 Asd001a_ome04:2/2
Asd001a_ome04:9/1 Asd001a_ome04:2/3
Asd001a_ome04:9/1 Asd001a_ome04:6/1
Asd001a_ome04:9/1 Rt001a_ome01:6/1
Asd001a_ome05:1/1 Asd001a_ome05:1/2
Asd001a_ome05:1/1 Asd001a_ome05:1/3
Asd001a_ome05:1/1 Asd001a_ome05:1/4
Asd001a_ome05:1/1 Asd001a_ome05:10/1
Asd001a_ome05:1/1 Asd001a_ome05:2/1
Asd001a_ome05:1/1 Asd001a_ome05:2/2
Asd001a_ome05:1/1 Asd001a_ome05:2/3
Asd001a_ome05:1/1 Asd001a_ome05:2/4
Asd001a_ome05:1/1 Asd001a_ome05:3/1
Asd001a_ome05:1/1 Asd001a_ome05:3/2
Asd001a_ome05:1/1 Asd001a_ome05:3/3
Asd001a_ome05:1/1 Asd001a_ome05:3/4
Asd001a_ome05:1/1 Asd001a_ome05:4/1
Asd001a_ome05:1/1 Asd001a_ome05:4/2
Asd001a_ome05:1/1 Asd001a_ome05:4/3
Asd001a_ome05:1/1 Asd001a_ome05:4/4
Asd001a_ome05:1/1 Asd001a_ome05:5/1
Asd001a_ome05:1/1 Asd001a_ome05:6/1
Asd001a_ome05:1/1 Asd001a_ome05:9/1
Asd001a_ome05:1/2 Asd001a_ome05:1/1
Asd001a_ome05:1/2 Asd001a_ome05:1/3
Asd001a_ome05:1/2 Asd001a_ome05:1/4
Asd001a_ome05:1/2 Asd001a_ome05:10/1
Asd001a_ome05:1/2 Asd001a_ome05:2/1
Asd001a_ome05:1/2 Asd001a_ome05:2/2
Asd001a_ome05:1/2 Asd001a_ome05:2/3
Asd001a_ome05:1/2 Asd001a_ome05:2/4
Asd001a_ome05:1/2 Asd001a_ome05:3/1
Asd001a_ome05:1/2 Asd001a_ome05:3/2
Asd001a_ome05:1/2 Asd001a_ome05:3/3
Asd001a_ome05:1/2 Asd001a_ome05:3/4
Asd001a_ome05:1/2 Asd001a_ome05:4/1
Asd001a_ome05:1/2 Asd001a_ome05:4/2
Asd001a_ome05:1/2 Asd001a_ome05:4/3
Asd001a_ome05:1/2 Asd001a_ome05:4/4
Asd001a_ome05:1/2 Asd001a_ome05:5/1
Asd001a_ome05:1/2 Asd001a_ome05:6/1
Asd001a_ome05:1/2 Asd001a_ome05:9/1
Asd001a_ome05:1/3 Asd001a_ome05:1/1
Asd001a_ome05:1/3 Asd001a_ome05:1/2
Asd001a_ome05:1/3 Asd001a_ome05:1/4
Asd001a_ome05:1/3 Asd001a_ome05:10/1
Asd001a_ome05:1/3 Asd001a_ome05:2/1
Asd001a_ome05:1/3 Asd001a_ome05:2/2
Asd001a_ome05:1/3 Asd001a_ome05:2/3
Asd001a_ome05:1/3 Asd001a_ome05:2/4
Asd001a_ome05:1/3 Asd001a_ome05:3/1
Asd001a_ome05:1/3 Asd001a_ome05:3/2
Asd001a_ome05:1/3 Asd001a_ome05:3/3
Asd001a_ome05:1/3 Asd001a_ome05:3/4
Asd001a_ome05:1/3 Asd001a_ome05:4/1
Asd001a_ome05:1/3 Asd001a_ome05:4/2
Asd001a_ome05:1/3 Asd001a_ome05:4/3
Asd001a_ome05:1/3 Asd001a_ome05:4/4
Asd001a_ome05:1/3 Asd001a_ome05:5/1
Asd001a_ome05:1/3 Asd001a_ome05:6/1
Asd001a_ome05:1/3 Asd001a_ome05:9/1
Asd001a_ome05:1/4 Asd001a_ome05:1/1
Asd001a_ome05:1/4 Asd001a_ome05:1/2
Asd001a_ome05:1/4 Asd001a_ome05:1/3
Asd001a_ome05:1/4 Asd001a_ome05:10/1
Asd001a_ome05:1/4 Asd001a_ome05:2/1
Asd001a_ome05:1/4 Asd001a_ome05:2/2
Asd001a_ome05:1/4 Asd001a_ome05:2/3
Asd001a_ome05:1/4 Asd001a_ome05:2/4
Asd001a_ome05:1/4 Asd001a_ome05:3/1
Asd001a_ome05:1/4 Asd001a_ome05:3/2
Asd001a_ome05:1/4 Asd001a_ome05:3/3
Asd001a_ome05:1/4 Asd001a_ome05:3/4
Asd001a_ome05:1/4 Asd001a_ome05:4/1
Asd001a_ome05:1/4 Asd001a_ome05:4/2
Asd001a_ome05:1/4 Asd001a_ome05:4/3
Asd001a_ome05:1/4 Asd001a_ome05:4/4
Asd001a_ome05:1/4 Asd001a_ome05:5/1
Asd001a_ome05:1/4 Asd001a_ome05:6/1
Asd001a_ome05:1/4 Asd001a_ome05:9/1
Asd001a_ome05:10/1 Asd001a_ome01:9/1
Asd001a_ome05:10/1 Asd001a_ome05:1/1
Asd001a_ome05:10/1 Asd001a_ome05:1/2
Asd001a_ome05:10/1 Asd001a_ome05:1/3
Asd001a_ome05:10/1 Asd001a_ome05:1/4
Asd001a_ome05:10/1 Asd001a_ome05:2/1
Asd001a_ome05:10/1 Asd001a_ome05:2/2
Asd001a_ome05:10/1 Asd001a_ome05:2/3
Asd001a_ome05:10/1 Asd001a_ome05:2/4
Asd001a_ome05:10/1 Asd001a_ome05:3/1
Asd001a_ome05:10/1 Asd001a_ome05:3/2
Asd001a_ome05:10/1 Asd001a_ome05:3/3
Asd001a_ome05:10/1 Asd001a_ome05:3/4
Asd001a_ome05:10/1 Asd001a_ome05:4/1
Asd001a_ome05:10/1 Asd001a_ome05:4/2
Asd001a_ome05:10/1 Asd001a_ome05:4/3
Asd001a_ome05:10/1 Asd001a_ome05:4/4
Asd001a_ome05:10/1 Asd001a_ome05:5/1
Asd001a_ome05:10/1 Asd001a_ome05:6/1
Asd001a_ome05:10/1 Asd001a_ome05:9/1
Asd001a_ome05:2/1 Asd001a_ome05:1/1
Asd001a_ome05:2/1 Asd001a_ome05:1/2
Asd001a_ome05:2/1 Asd001a_ome05:1/3
Asd001a_ome05:2/1 Asd001a_ome05:1/4
Asd001a_ome05:2/1 Asd001a_ome05:10/1
Asd001a_ome05:2/1 Asd001a_ome05:2/2
Asd001a_ome05:2/1 Asd001a_ome05:2/3
Asd001a_ome05:2/1 Asd001a_ome05:2/4
Asd001a_ome05:2/1 Asd001a_ome05:3/1
Asd001a_ome05:2/1 Asd001a_ome05:3/2
Asd001a_ome05:2/1 Asd001a_ome05:3/3
Asd001a_ome05:2/1 Asd001a_ome05:3/4
Asd001a_ome05:2/1 Asd001a_ome05:4/1
Asd001a_ome05:2/1 Asd001a_ome05:4/2
Asd001a_ome05:2/1 Asd001a_ome05:4/3
Asd001a_ome05:2/1 Asd001a_ome05:4/4
Asd001a_ome05:2/1 Asd001a_ome05:5/1
Asd001a_ome05:2/1 Asd001a_ome05:6/1
Asd001a_ome05:2/1 Asd001a_ome05:9/1
Asd001a_ome05:2/2 Asd001a_ome05:1/1
Asd001a_ome05:2/2 Asd001a_ome05:1/2
Asd001a_ome05:2/2 Asd001a_ome05:1/3
Asd001a_ome05:2/2 Asd001a_ome05:1/4
Asd001a_ome05:2/2 Asd001a_ome05:10/1
Asd001a_ome05:2/2 Asd001a_ome05:2/1
Asd001a_ome05:2/2 Asd001a_ome05:2/3
Asd001a_ome05:2/2 Asd001a_ome05:2/4
Asd001a_ome05:2/2 Asd001a_ome05:3/1
Asd001a_ome05:2/2 Asd001a_ome05:3/2
Asd001a_ome05:2/2 Asd001a_ome05:3/3
Asd001a_ome05:2/2 Asd001a_ome05:3/4
Asd001a_ome05:2/2 Asd001a_ome05:4/1
Asd001a_ome05:2/2 Asd001a_ome05:4/2
Asd001a_ome05:2/2 Asd001a_ome05:4/3
Asd001a_ome05:2/2 Asd001a_ome05:4/4
Asd001a_ome05:2/2 Asd001a_ome05:5/1
Asd001a_ome05:2/2 Asd001a_ome05:6/1
Asd001a_ome05:2/2 Asd001a_ome05:9/1
Asd001a_ome05:2/3 Asd001a_ome05:1/1
Asd001a_ome05:2/3 Asd001a_ome05:1/2
Asd001a_ome05:2/3 Asd001a_ome05:1/3
Asd001a_ome05:2/3 Asd001a_ome05:1/4
Asd001a_ome05:2/3 Asd001a_ome05:10/1
Asd001a_ome05:2/3 Asd001a_ome05:2/1
Asd001a_ome05:2/3 Asd001a_ome05:2/2
Asd001a_ome05:2/3 Asd001a_ome05:2/4
Asd001a_ome05:2/3 Asd001a_ome05:3/1
Asd001a_ome05:2/3 Asd001a_ome05:3/2
Asd001a_ome05:2/3 Asd001a_ome05:3/3
Asd001a_ome05:2/3 Asd001a_ome05:3/4
Asd001a_ome05:2/3 Asd001a_ome05:4/1
Asd001a_ome05:2/3 Asd001a_ome05:4/2
Asd001a_ome05:2/3 Asd001a_ome05:4/3
Asd001a_ome05:2/3 Asd001a_ome05:4/4
Asd001a_ome05:2/3 Asd001a_ome05:5/1
Asd001a_ome05:2/3 Asd001a_ome05:6/1
Asd001a_ome05:2/3 Asd001a_ome05:9/1
Asd001a_ome05:2/4 Asd001a_ome05:1/1
Asd001a_ome05:2/4 Asd001a_ome05:1/2
Asd001a_ome05:2/4 Asd001a_ome05:1/3
Asd001a_ome05:2/4 Asd001a_ome05:1/4
Asd001a_ome05:2/4 Asd001a_ome05:10/1
Asd001a_ome05:2/4 Asd001a_ome05:2/1
Asd001a_ome05:2/4 Asd001a_ome05:2/2
Asd001a_ome05:2/4 Asd001a_ome05:2/3
Asd001a_ome05:2/4 Asd001a_ome05:3/1
Asd001a_ome05:2/4 Asd001a_ome05:3/2
Asd001a_ome05:2/4 Asd001a_ome05:3/3
Asd001a_ome05:2/4 Asd001a_ome05:3/4
Asd001a_ome05:2/4 Asd001a_ome05:4/1
Asd001a_ome05:2/4 Asd001a_ome05:4/2
Asd001a_ome05:2/4 Asd001a_ome05:4/3
Asd001a_ome05:2/4 Asd001a_ome05:4/4
Asd001a_ome05:2/4 Asd001a_ome05:5/1
Asd001a_ome05:2/4 Asd001a_ome05:6/1
Asd001a_ome05:2/4 Asd001a_ome05:9/1
Asd001a_ome05:3/1 Asd001a_ome05:1/1
Asd001a_ome05:3/1 Asd001a_ome05:1/2
Asd001a_ome05:3/1 Asd001a_ome05:1/3
Asd001a_ome05:3/1 Asd001a_ome05:1/4
Asd001a_ome05:3/1 Asd001a_ome05:10/1
Asd001a_ome05:3/1 Asd001a_ome05:2/1
Asd001a_ome05:3/1 Asd001a_ome05:2/2
Asd001a_ome05:3/1 Asd001a_ome05:2/3
Asd001a_ome05:3/1 Asd001a_ome05:2/4
Asd001a_ome05:3/1 Asd001a_ome05:3/2
Asd001a_ome05:3/1 Asd001a_ome05:3/3
Asd001a_ome05:3/1 Asd001a_ome05:3/4
Asd001a_ome05:3/1 Asd001a_ome05:4/1
Asd001a_ome05:3/1 Asd001a_ome05:4/2
Asd001a_ome05:3/1 Asd001a_ome05:4/3
Asd001a_ome05:3/1 Asd001a_ome05:4/4
Asd001a_ome05:3/1 Asd001a_ome05:5/1
Asd001a_ome05:3/1 Asd001a_ome05:6/1
Asd001a_ome05:3/1 Asd001a_ome05:9/1
Asd001a_ome05:3/2 Asd001a_ome05:1/1
Asd001a_ome05:3/2 Asd001a_ome05:1/2
Asd001a_ome05:3/2 Asd001a_ome05:1/3
Asd001a_ome05:3/2 Asd001a_ome05:1/4
Asd001a_ome05:3/2 Asd001a_ome05:10/1
Asd001a_ome05:3/2 Asd001a_ome05:2/1
Asd001a_ome05:3/2 Asd001a_ome05:2/2
Asd001a_ome05:3/2 Asd001a_ome05:2/3
Asd001a_ome05:3/2 Asd001a_ome05:2/4
Asd001a_ome05:3/2 Asd001a_ome05:3/1
Asd001a_ome05:3/2 Asd001a_ome05:3/3
Asd001a_ome05:3/2 Asd001a_ome05:3/4
Asd001a_ome05:3/2 Asd001a_ome05:4/1
Asd001a_ome05:3/2 Asd001a_ome05:4/2
Asd001a_ome05:3/2 Asd001a_ome05:4/3
Asd001a_ome05:3/2 Asd001a_ome05:4/4
Asd001a_ome05:3/2 Asd001a_ome05:5/1
Asd001a_ome05:3/2 Asd001a_ome05:6/1
Asd001a_ome05:3/2 Asd001a_ome05:9/1
Asd001a_ome05:3/3 Asd001a_ome05:1/1
Asd001a_ome05:3/3 Asd001a_ome05:1/2
Asd001a_ome05:3/3 Asd001a_ome05:1/3
Asd001a_ome05:3/3 Asd001a_ome05:1/4
Asd001a_ome05:3/3 Asd001a_ome05:10/1
Asd001a_ome05:3/3 Asd001a_ome05:2/1
Asd001a_ome05:3/3 Asd001a_ome05:2/2
Asd001a_ome05:3/3 Asd001a_ome05:2/3
Asd001a_ome05:3/3 Asd001a_ome05:2/4
Asd001a_ome05:3/3 Asd001a_ome05:3/1
Asd001a_ome05:3/3 Asd001a_ome05:3/2
Asd001a_ome05:3/3 Asd001a_ome05:3/4
Asd001a_ome05:3/3 Asd001a_ome05:4/1
Asd001a_ome05:3/3 Asd001a_ome05:4/2
Asd001a_ome05:3/3 Asd001a_ome05:4/3
Asd001a_ome05:3/3 Asd001a_ome05:4/4
Asd001a_ome05:3/3 Asd001a_ome05:5/1
Asd001a_ome05:3/3 Asd001a_ome05:6/1
Asd001a_ome05:3/3 Asd001a_ome05:9/1
Asd001a_ome05:3/4 Asd001a_ome05:1/1
Asd001a_ome05:3/4 Asd001a_ome05:1/2
Asd001a_ome05:3/4 Asd001a_ome05:1/3
Asd001a_ome05:3/4 Asd001a_ome05:1/4
Asd001a_ome05:3/4 Asd001a_ome05:10/1
Asd001a_ome05:3/4 Asd001a_ome05:2/1
Asd001a_ome05:3/4 Asd001a_ome05:2/2
Asd001a_ome05:3/4 Asd001a_ome05:2/3
Asd001a_ome05:3/4 Asd001a_ome05:2/4
Asd001a_ome05:3/4 Asd001a_ome05:3/1
Asd001a_ome05:3/4 Asd001a_ome05:3/2
Asd001a_ome05:3/4 Asd001a_ome05:3/3
Asd001a_ome05:3/4 Asd001a_ome05:4/1
Asd001a_ome05:3/4 Asd001a_ome05:4/2
Asd001a_ome05:3/4 Asd001a_ome05:4/3
Asd001a_ome05:3/4 Asd001a_ome05:4/4
Asd001a_ome05:3/4 Asd001a_ome05:5/1
Asd001a_ome05:3/4 Asd001a_ome05:6/1
Asd001a_ome05:3/4 Asd001a_ome05:9/1
Asd001a_ome05:4/1 Asd001a_ome05:1/1
Asd001a_ome05:4/1 Asd001a_ome05:1/2
Asd001a_ome05:4/1 Asd001a_ome05:1/3
Asd001a_ome05:4/1 Asd001a_ome05:1/4
Asd001a_ome05:4/1 Asd001a_ome05:10/1
Asd001a_ome05:4/1 Asd001a_ome05:2/1
Asd001a_ome05:4/1 Asd001a_ome05:2/2
Asd001a_ome05:4/1 Asd001a_ome05:2/3
Asd001a_ome05:4/1 Asd001a_ome05:2/4
Asd001a_ome05:4/1 Asd001a_ome05:3/1
Asd001a_ome05:4/1 Asd001a_ome05:3/2
Asd001a_ome05:4/1 Asd001a_ome05:3/3
Asd001a_ome05:4/1 Asd001a_ome05:3/4
Asd001a_ome05:4/1 Asd001a_ome05:4/2
Asd001a_ome05:4/1 Asd001a_ome05:4/3
Asd001a_ome05:4/1 Asd001a_ome05:4/4
Asd001a_ome05:4/1 Asd001a_ome05:5/1
Asd001a_ome05:4/1 Asd001a_ome05:6/1
Asd001a_ome05:4/1 Asd001a_ome05:9/1
Asd001a_ome05:4/2 Asd001a_ome05:1/1
Asd001a_ome05:4/2 Asd001a_ome05:1/2
Asd001a_ome05:4/2 Asd001a_ome05:1/3
Asd001a_ome05:4/2 Asd001a_ome05:1/4
Asd001a_ome05:4/2 Asd001a_ome05:10/1
Asd001a_ome05:4/2 Asd001a_ome05:2/1
Asd001a_ome05:4/2 Asd001a_ome05:2/2
Asd001a_ome05:4/2 Asd001a_ome05:2/3
Asd001a_ome05:4/2 Asd001a_ome05:2/4
Asd001a_ome05:4/2 Asd001a_ome05:3/1
Asd001a_ome05:4/2 Asd001a_ome05:3/2
Asd001a_ome05:4/2 Asd001a_ome05:3/3
Asd001a_ome05:4/2 Asd001a_ome05:3/4
Asd001a_ome05:4/2 Asd001a_ome05:4/1
Asd001a_ome05:4/2 Asd001a_ome05:4/3
Asd001a_ome05:4/2 Asd001a_ome05:4/4
Asd001a_ome05:4/2 Asd001a_ome05:5/1
Asd001a_ome05:4/2 Asd001a_ome05:6/1
Asd001a_ome05:4/2 Asd001a_ome05:9/1
Asd001a_ome05:4/3 Asd001a_ome05:1/1
Asd001a_ome05:4/3 Asd001a_ome05:1/2
Asd001a_ome05:4/3 Asd001a_ome05:1/3
Asd001a_ome05:4/3 Asd001a_ome05:1/4
Asd001a_ome05:4/3 Asd001a_ome05:10/1
Asd001a_ome05:4/3 Asd001a_ome05:2/1
Asd001a_ome05:4/3 Asd001a_ome05:2/2
Asd001a_ome05:4/3 Asd001a_ome05:2/3
Asd001a_ome05:4/3 Asd001a_ome05:2/4
Asd001a_ome05:4/3 Asd001a_ome05:3/1
Asd001a_ome05:4/3 Asd001a_ome05:3/2
Asd001a_ome05:4/3 Asd001a_ome05:3/3
Asd001a_ome05:4/3 Asd001a_ome05:3/4
Asd001a_ome05:4/3 Asd001a_ome05:4/1
Asd001a_ome05:4/3 Asd001a_ome05:4/2
Asd001a_ome05:4/3 Asd001a_ome05:4/4
Asd001a_ome05:4/3 Asd001a_ome05:5/1
Asd001a_ome05:4/3 Asd001a_ome05:6/1
Asd001a_ome05:4/3 Asd001a_ome05:9/1
Asd001a_ome05:4/4 Asd001a_ome05:1/1
Asd001a_ome05:4/4 Asd001a_ome05:1/2
Asd001a_ome05:4/4 Asd001a_ome05:1/3
Asd001a_ome05:4/4 Asd001a_ome05:1/4
Asd001a_ome05:4/4 Asd001a_ome05:10/1
Asd001a_ome05:4/4 Asd001a_ome05:2/1
Asd001a_ome05:4/4 Asd001a_ome05:2/2
Asd001a_ome05:4/4 Asd001a_ome05:2/3
Asd001a_ome05:4/4 Asd001a_ome05:2/4
Asd001a_ome05:4/4 Asd001a_ome05:3/1
Asd001a_ome05:4/4 Asd001a_ome05:3/2
Asd001a_ome05:4/4 Asd001a_ome05:3/3
Asd001a_ome05:4/4 Asd001a_ome05:3/4
Asd001a_ome05:4/4 Asd001a_ome05:4/1
Asd001a_ome05:4/4 Asd001a_ome05:4/2
Asd001a_ome05:4/4 Asd001a_ome05:4/3
Asd001a_ome05:4/4 Asd001a_ome05:5/1
Asd001a_ome05:4/4 Asd001a_ome05:6/1
Asd001a_ome05:4/4 Asd001a_ome05:9/1
Asd001a_ome05:5/1 Asd001a_ome05:1/1
Asd001a_ome05:5/1 Asd001a_ome05:1/2
Asd001a_ome05:5/1 Asd001a_ome05:1/3
Asd001a_ome05:5/1 Asd001a_ome05:1/4
Asd001a_ome05:5/1 Asd001a_ome05:10/1
Asd001a_ome05:5/1 Asd001a_ome05:2/1
Asd001a_ome05:5/1 Asd001a_ome05:2/2
Asd001a_ome05:5/1 Asd001a_ome05:2/3
Asd001a_ome05:5/1 Asd001a_ome05:2/4
Asd001a_ome05:5/1 Asd001a_ome05:3/1
Asd001a_ome05:5/1 Asd001a_ome05:3/2
Asd001a_ome05:5/1 Asd001a_ome05:3/3
Asd001a_ome05:5/1 Asd001a_ome05:3/4
Asd001a_ome05:5/1 Asd001a_ome05:4/1
Asd001a_ome05:5/1 Asd001a_ome05:4/2
Asd001a_ome05:5/1 Asd001a_ome05:4/3
Asd001a_ome05:5/1 Asd001a_ome05:4/4
Asd001a_ome05:5/1 Asd001a_ome05:6/1
Asd001a_ome05:5/1 Asd001a_ome05:9/1
Asd001a_ome05:5/1 Ddt001a_ome01:6/1
Asd001a_ome05:6/1 Asd001a_ome05:1/1
Asd001a_ome05:6/1 Asd001a_ome05:1/2
Asd001a_ome05:6/1 Asd001a_ome05:1/3
Asd001a_ome05:6/1 Asd001a_ome05:1/4
Asd001a_ome05:6/1 Asd001a_ome05:10/1
Asd001a_ome05:6/1 Asd001a_ome05:2/1
Asd001a_ome05:6/1 Asd001a_ome05:2/2
Asd001a_ome05:6/1 Asd001a_ome05:2/3
Asd001a_ome05:6/1 Asd001a_ome05:2/4
Asd001a_ome05:6/1 Asd001a_ome05:3/1
Asd001a_ome05:6/1 Asd001a_ome05:3/2
Asd001a_ome05:6/1 Asd001a_ome05:3/3
Asd001a_ome05:6/1 Asd001a_ome05:3/4
Asd001a_ome05:6/1 Asd001a_ome05:4/1
Asd001a_ome05:6/1 Asd001a_ome05:4/2
Asd001a_ome05:6/1 Asd001a_ome05:4/3
Asd001a_ome05:6/1 Asd001a_ome05:4/4
Asd001a_ome05:6/1 Asd001a_ome05:5/1
Asd001a_ome05:6/1 Asd001a_ome05:9/1
Asd001a_ome05:6/1 Tb001a_ome01:6/1
Asd001a_ome05:9/1 Asd001a_ome05:1/1
Asd001a_ome05:9/1 Asd001a_ome05:1/2
Asd001a_ome05:9/1 Asd001a_ome05:1/3
Asd001a_ome05:9/1 Asd001a_ome05:1/4
Asd001a_ome05:9/1 Asd001a_ome05:10/1
Asd001a_ome05:9/1 Asd001a_ome05:2/1
Asd001a_ome05:9/1 Asd001a_ome05:2/2
Asd001a_ome05:9/1 Asd001a_ome05:2/3
Asd001a_ome05:9/1 Asd001a_ome05:2/4
Asd001a_ome05:9/1 Asd001a_ome05:3/1
Asd001a_ome05:9/1 Asd001a_ome05:3/2
Asd001a_ome05:9/1 Asd001a_ome05:3/3
Asd001a_ome05:9/1 Asd001a_ome05:3/4
Asd001a_ome05:9/1 Asd001a_ome05:4/1
Asd001a_ome05:9/1 Asd001a_ome05:4/2
Asd001a_ome05:9/1 Asd001a_ome05:4/3
Asd001a_ome05:9/1 Asd001a_ome05:4/4
Asd001a_ome05:9/1 Asd001a_ome05:5/1
Asd001a_ome05:9/1 Asd001a_ome05:6/1
Asd001a_ome05:9/1 Ehv001a_ome01:6/1
Asd001a_ome06:1/1 Asd001a_ome06:1/2
Asd001a_ome06:1/1 Asd001a_ome06:1/3
Asd001a_ome06:1/1 Asd001a_ome06:10/1
Asd001a_ome06:1/1 Asd001a_ome06:2/1
Asd001a_ome06:1/1 Asd001a_ome06:2/2
Asd001a_ome06:1/1 Asd001a_ome06:2/4
Asd001a_ome06:1/1 Asd001a_ome06:3/1
Asd001a_ome06:1/1 Asd001a_ome06:3/2
Asd001a_ome06:1/1 Asd001a_ome06:3/3
Asd001a_ome06:1/1 Asd001a_ome06:3/4
Asd001a_ome06:1/1 Asd001a_ome06:4/1
Asd001a_ome06:1/1 Asd001a_ome06:4/2
Asd001a_ome06:1/1 Asd001a_ome06:5/1
Asd001a_ome06:1/1 Asd001a_ome06:6/1
Asd001a_ome06:1/1 Asd001a_ome06:9/1
Asd001a_ome06:1/2 Asd001a_ome06:1/1
Asd001a_ome06:1/2 Asd001a_ome06:1/3
Asd001a_ome06:1/2 Asd001a_ome06:10/1
Asd001a_ome06:1/2 Asd001a_ome06:2/1
Asd001a_ome06:1/2 Asd001a_ome06:2/2
Asd001a_ome06:1/2 Asd001a_ome06:2/4
Asd001a_ome06:1/2 Asd001a_ome06:3/1
Asd001a_ome06:1/2 Asd001a_ome06:3/2
Asd001a_ome06:1/2 Asd001a_ome06:3/3
Asd001a_ome06:1/2 Asd001a_ome06:3/4
Asd001a_ome06:1/2 Asd001a_ome06:4/1
Asd001a_ome06:1/2 Asd001a_ome06:4/2
Asd001a_ome06:1/2 Asd001a_ome06:5/1
Asd001a_ome06:1/2 Asd001a_ome06:6/1
Asd001a_ome06:1/2 Asd001a_ome06:9/1
Asd001a_ome06:1/3 Asd001a_ome06:1/1
Asd001a_ome06:1/3 Asd001a_ome06:1/2
Asd001a_ome06:1/3 Asd001a_ome06:10/1
Asd001a_ome06:1/3 Asd001a_ome06:2/1
Asd001a_ome06:1/3 Asd001a_ome06:2/2
Asd001a_ome06:1/3 Asd001a_ome06:2/4
Asd001a_ome06:1/3 Asd001a_ome06:3/1
Asd001a_ome06:1/3 Asd001a_ome06:3/2
Asd001a_ome06:1/3 Asd001a_ome06:3/3
Asd001a_ome06:1/3 Asd001a_ome06:3/4
Asd001a_ome06:1/3 Asd001a_ome06:4/1
Asd001a_ome06:1/3 Asd001a_ome06:4/2
Asd001a_ome06:1/3 Asd001a_ome06:5/1
Asd001a_ome06:1/3 Asd001a_ome06:6/1
Asd001a_ome06:1/3 Asd001a_ome06:9/1
Asd001a_ome06:10/1 Asd001a_ome02:5/1
Asd001a_ome06:10/1 Asd001a_ome06:1/1
Asd001a_ome06:10/1 Asd001a_ome06:1/2
Asd001a_ome06:10/1 Asd001a_ome06:1/3
Asd001a_ome06:10/1 Asd001a_ome06:2/1
Asd001a_ome06:10/1 Asd001a_ome06:2/2
Asd001a_ome06:10/1 Asd001a_ome06:2/4
Asd001a_ome06:10/1 Asd001a_ome06:3/1
Asd001a_ome06:10/1 Asd001a_ome06:3/2
Asd001a_ome06:10/1 Asd001a_ome06:3/3
Asd001a_ome06:10/1 Asd001a_ome06:3/4
Asd001a_ome06:10/1 Asd001a_ome06:4/1
Asd001a_ome06:10/1 Asd001a_ome06:4/2
Asd001a_ome06:10/1 Asd001a_ome06:5/1
Asd001a_ome06:10/1 Asd001a_ome06:6/1
Asd001a_ome06:10/1 Asd001a_ome06:9/1
Asd001a_ome06:2/1 Asd001a_ome06:1/1
Asd001a_ome06:2/1 Asd001a_ome06:1/2
Asd001a_ome06:2/1 Asd001a_ome06:1/3
Asd001a_ome06:2/1 Asd001a_ome06:10/1
Asd001a_ome06:2/1 Asd001a_ome06:2/2
Asd001a_ome06:2/1 Asd001a_ome06:2/4
Asd001a_ome06:2/1 Asd001a_ome06:3/1
Asd001a_ome06:2/1 Asd001a_ome06:3/2
Asd001a_ome06:2/1 Asd001a_ome06:3/3
Asd001a_ome06:2/1 Asd001a_ome06:3/4
Asd001a_ome06:2/1 Asd001a_ome06:4/1
Asd001a_ome06:2/1 Asd001a_ome06:4/2
Asd001a_ome06:2/1 Asd001a_ome06:5/1
Asd001a_ome06:2/1 Asd001a_ome06:6/1
Asd001a_ome06:2/1 Asd001a_ome06:9/1
Asd001a_ome06:2/2 Asd001a_ome06:1/1
Asd001a_ome06:2/2 Asd001a_ome06:1/2
Asd001a_ome06:2/2 Asd001a_ome06:1/3
Asd001a_ome06:2/2 Asd001a_ome06:10/1
Asd001a_ome06:2/2 Asd001a_ome06:2/1
Asd001a_ome06:2/2 Asd001a_ome06:2/4
Asd001a_ome06:2/2 Asd001a_ome06:3/1
Asd001a_ome06:2/2 Asd001a_ome06:3/2
Asd001a_ome06:2/2 Asd001a_ome06:3/3
Asd001a_ome06:2/2 Asd001a_ome06:3/4
Asd001a_ome06:2/2 Asd001a_ome06:4/1
Asd001a_ome06:2/2 Asd001a_ome06:4/2
Asd001a_ome06:2/2 Asd001a_ome06:5/1
Asd001a_ome06:2/2 Asd001a_ome06:6/1
Asd001a_ome06:2/2 Asd001a_ome06:9/1
Asd001a_ome06:2/4 Asd001a_ome06:1/1
Asd001a_ome06:2/4 Asd001a_ome06:1/2
Asd001a_ome06:2/4 Asd001a_ome06:1/3
Asd001a_ome06:2/4 Asd001a_ome06:10/1
Asd001a_ome06:2/4 Asd001a_ome06:2/1
Asd001a_ome06:2/4 Asd001a_ome06:2/2
Asd001a_ome06:2/4 Asd001a_ome06:3/1
Asd001a_ome06:2/4 Asd001a_ome06:3/2
Asd001a_ome06:2/4 Asd001a_ome06:3/3
Asd001a_ome06:2/4 Asd001a_ome06:3/4
Asd001a_ome06:2/4 Asd001a_ome06:4/1
Asd001a_ome06:2/4 Asd001a_ome06:4/2
Asd001a_ome06:2/4 Asd001a_ome06:5/1
Asd001a_ome06:2/4 Asd001a_ome06:6/1
Asd001a_ome06:2/4 Asd001a_ome06:9/1
Asd001a_ome06:3/1 Asd001a_ome06:1/1
Asd001a_ome06:3/1 Asd001a_ome06:1/2
Asd001a_ome06:3/1 Asd001a_ome06:1/3
Asd001a_ome06:3/1 Asd001a_ome06:10/1
Asd001a_ome06:3/1 Asd001a_ome06:2/1
Asd001a_ome06:3/1 Asd001a_ome06:2/2
Asd001a_ome06:3/1 Asd001a_ome06:2/4
Asd001a_ome06:3/1 Asd001a_ome06:3/2
Asd001a_ome06:3/1 Asd001a_ome06:3/3
Asd001a_ome06:3/1 Asd001a_ome06:3/4
Asd001a_ome06:3/1 Asd001a_ome06:4/1
Asd001a_ome06:3/1 Asd001a_ome06:4/2
Asd001a_ome06:3/1 Asd001a_ome06:5/1
Asd001a_ome06:3/1 Asd001a_ome06:6/1
Asd001a_ome06:3/1 Asd001a_ome06:9/1
Asd001a_ome06:3/2 Asd001a_ome06:1/1
Asd001a_ome06:3/2 Asd001a_ome06:1/2
Asd001a_ome06:3/2 Asd001a_ome06:1/3
Asd001a_ome06:3/2 Asd001a_ome06:10/1
Asd001a_ome06:3/2 Asd001a_ome06:2/1
Asd001a_ome06:3/2 Asd001a_ome06:2/2
Asd001a_ome06:3/2 Asd001a_ome06:2/4
Asd001a_ome06:3/2 Asd001a_ome06:3/1
Asd001a_ome06:3/2 Asd001a_ome06:3/3
Asd001a_ome06:3/2 Asd001a_ome06:3/4
Asd001a_ome06:3/2 Asd001a_ome06:4/1
Asd001a_ome06:3/2 Asd001a_ome06:4/2
Asd001a_ome06:3/2 Asd001a_ome06:5/1
Asd001a_ome06:3/2 Asd001a_ome06:6/1
Asd001a_ome06:3/2 Asd001a_ome06:9/1
Asd001a_ome06:3/3 Asd001a_ome06:1/1
Asd001a_ome06:3/3 Asd001a_ome06:1/2
Asd001a_ome06:3/3 Asd001a_ome06:1/3
Asd001a_ome06:3/3 Asd001a_ome06:10/1
Asd001a_ome06:3/3 Asd001a_ome06:2/1
Asd001a_ome06:3/3 Asd001a_ome06:2/2
Asd001a_ome06:3/3 Asd001a_ome06:2/4
Asd001a_ome06:3/3 Asd001a_ome06:3/1
Asd001a_ome06:3/3 Asd001a_ome06:3/2
Asd001a_ome06:3/3 Asd001a_ome06:3/4
Asd001a_ome06:3/3 Asd001a_ome06:4/1
Asd001a_ome06:3/3 Asd001a_ome06:4/2
Asd001a_ome06:3/3 Asd001a_ome06:5/1
Asd001a_ome06:3/3 Asd001a_ome06:6/1
Asd001a_ome06:3/3 Asd001a_ome06:9/1
Asd001a_ome06:3/4 Asd001a_ome06:1/1
Asd001a_ome06:3/4 Asd001a_ome06:1/2
Asd001a_ome06:3/4 Asd001a_ome06:1/3
Asd001a_ome06:3/4 Asd001a_ome06:10/1
Asd001a_ome06:3/4 Asd001a_ome06:2/1
Asd001a_ome06:3/4 Asd001a_ome06:2/2
Asd001a_ome06:3/4 Asd001a_ome06:2/4
Asd001a_ome06:3/4 Asd001a_ome06:3/1
Asd001a_ome06:3/4 Asd001a_ome06:3/2
Asd001a_ome06:3/4 Asd001a_ome06:3/3
Asd001a_ome06:3/4 Asd001a_ome06:4/1
Asd001a_ome06:3/4 Asd001a_ome06:4/2
Asd001a_ome06:3/4 Asd001a_ome06:5/1
Asd001a_ome06:3/4 Asd001a_ome06:6/1
Asd001a_ome06:3/4 Asd001a_ome06:9/1
Asd001a_ome06:4/1 Asd001a_ome06:1/1
Asd001a_ome06:4/1 Asd001a_ome06:1/2
Asd001a_ome06:4/1 Asd001a_ome06:1/3
Asd001a_ome06:4/1 Asd001a_ome06:10/1
Asd001a_ome06:4/1 Asd001a_ome06:2/1
Asd001a_ome06:4/1 Asd001a_ome06:2/2
Asd001a_ome06:4/1 Asd001a_ome06:2/4
Asd001a_ome06:4/1 Asd001a_ome06:3/1
Asd001a_ome06:4/1 Asd001a_ome06:3/2
Asd001a_ome06:4/1 Asd001a_ome06:3/3
Asd001a_ome06:4/1 Asd001a_ome06:3/4
Asd001a_ome06:4/1 Asd001a_ome06:4/2
Asd001a_ome06:4/1 Asd001a_ome06:5/1
Asd001a_ome06:4/1 Asd001a_ome06:6/1
Asd001a_ome06:4/1 Asd001a_ome06:9/1
Asd001a_ome06:4/2 Asd001a_ome06:1/1
Asd001a_ome06:4/2 Asd001a_ome06:1/2
Asd001a_ome06:4/2 Asd001a_ome06:1/3
Asd001a_ome06:4/2 Asd001a_ome06:10/1
Asd001a_ome06:4/2 Asd001a_ome06:2/1
Asd001a_ome06:4/2 Asd001a_ome06:2/2
Asd001a_ome06:4/2 Asd001a_ome06:2/4
Asd001a_ome06:4/2 Asd001a_ome06:3/1
Asd001a_ome06:4/2 Asd001a_ome06:3/2
Asd001a_ome06:4/2 Asd001a_ome06:3/3
Asd001a_ome06:4/2 Asd001a_ome06:3/4
Asd001a_ome06:4/2 Asd001a_ome06:4/1
Asd001a_ome06:4/2 Asd001a_ome06:5/1
Asd001a_ome06:4/2 Asd001a_ome06:6/1
Asd001a_ome06:4/2 Asd001a_ome06:9/1
Asd001a_ome06:5/1 Asd001a_ome06:1/1
Asd001a_ome06:5/1 Asd001a_ome06:1/2
Asd001a_ome06:5/1 Asd001a_ome06:1/3
Asd001a_ome06:5/1 Asd001a_ome06:10/1
Asd001a_ome06:5/1 Asd001a_ome06:2/1
Asd001a_ome06:5/1 Asd001a_ome06:2/2
Asd001a_ome06:5/1 Asd001a_ome06:2/4
Asd001a_ome06:5/1 Asd001a_ome06:3/1
Asd001a_ome06:5/1 Asd001a_ome06:3/2
Asd001a_ome06:5/1 Asd001a_ome06:3/3
Asd001a_ome06:5/1 Asd001a_ome06:3/4
Asd001a_ome06:5/1 Asd001a_ome06:4/1
Asd001a_ome06:5/1 Asd001a_ome06:4/2
Asd001a_ome06:5/1 Asd001a_ome06:6/1
Asd001a_ome06:5/1 Asd001a_ome06:9/1
Asd001a_ome06:5/1 Wg001a_ome01:6/1
Asd001a_ome06:6/1 Asd001a_ome06:1/1
Asd001a_ome06:6/1 Asd001a_ome06:1/2
Asd001a_ome06:6/1 Asd001a_ome06:1/3
Asd001a_ome06:6/1 Asd001a_ome06:10/1
Asd001a_ome06:6/1 Asd001a_ome06:2/1
Asd001a_ome06:6/1 Asd001a_ome06:2/2
Asd001a_ome06:6/1 Asd001a_ome06:2/4
Asd001a_ome06:6/1 Asd001a_ome06:3/1
Asd001a_ome06:6/1 Asd001a_ome06:3/2
Asd001a_ome06:6/1 Asd001a_ome06:3/3
Asd001a_ome06:6/1 Asd001a_ome06:3/4
Asd001a_ome06:6/1 Asd001a_ome06:4/1
Asd001a_ome06:6/1 Asd001a_ome06:4/2
Asd001a_ome06:6/1 Asd001a_ome06:5/1
Asd001a_ome06:6/1 Asd001a_ome06:9/1
Asd001a_ome06:6/1 Zl001a_ome01:6/1
Asd001a_ome06:9/1 Asd001a_ome06:1/1
Asd001a_ome06:9/1 Asd001a_ome06:1/2
Asd001a_ome06:9/1 Asd001a_ome06:1/3
Asd001a_ome06:9/1 Asd001a_ome06:10/1
Asd001a_ome06:9/1 Asd001a_ome06:2/1
Asd001a_ome06:9/1 Asd001a_ome06:2/2
Asd001a_ome06:9/1 Asd001a_ome06:2/4
Asd001a_ome06:9/1 Asd001a_ome06:3/1
Asd001a_ome06:9/1 Asd001a_ome06:3/2
Asd001a_ome06:9/1 Asd001a_ome06:3/3
Asd001a_ome06:9/1 Asd001a_ome06:3/4
Asd001a_ome06:9/1 Asd001a_ome06:4/1
Asd001a_ome06:9/1 Asd001a_ome06:4/2
Asd001a_ome06:9/1 Asd001a_ome06:5/1
Asd001a_ome06:9/1 Asd001a_ome06:6/1
Asd001a_ome06:9/1 Es001a_ome01:6/1
Asd001a_ome07:1/1 Asd001a_ome07:1/2
Asd001a_ome07:1/1 Asd001a_ome07:1/3
Asd001a_ome07:1/1 Asd001a_ome07:1/4
Asd001a_ome07:1/1 Asd001a_ome07:10/1
Asd001a_ome07:1/1 Asd001a_ome07:2/1
Asd001a_ome07:1/1 Asd001a_ome07:2/2
Asd001a_ome07:1/1 Asd001a_ome07:2/3
Asd001a_ome07:1/1 Asd001a_ome07:2/4
Asd001a_ome07:1/1 Asd001a_ome07:3/1
Asd001a_ome07:1/1 Asd001a_ome07:3/2
Asd001a_ome07:1/1 Asd001a_ome07:3/3
Asd001a_ome07:1/1 Asd001a_ome07:3/4
Asd001a_ome07:1/1 Asd001a_ome07:4/1
Asd001a_ome07:1/1 Asd001a_ome07:4/2
Asd001a_ome07:1/1 Asd001a_ome07:4/3
Asd001a_ome07:1/1 Asd001a_ome07:4/4
Asd001a_ome07:1/1 Asd001a_ome07:5/1
Asd001a_ome07:1/1 Asd001a_ome07:6/1
Asd001a_ome07:1/1 Asd001a_ome07:9/1
Asd001a_ome07:1/2 Asd001a_ome07:1/1
Asd001a_ome07:1/2 Asd001a_ome07:1/3
Asd001a_ome07:1/2 Asd001a_ome07:1/4
Asd001a_ome07:1/2 Asd001a_ome07:10/1
Asd001a_ome07:1/2 Asd001a_ome07:2/1
Asd001a_ome07:1/2 Asd001a_ome07:2/2
Asd001a_ome07:1/2 Asd001a_ome07:2/3
Asd001a_ome07:1/2 Asd001a_ome07:2/4
Asd001a_ome07:1/2 Asd001a_ome07:3/1
Asd001a_ome07:1/2 Asd001a_ome07:3/2
Asd001a_ome07:1/2 Asd001a_ome07:3/3
Asd001a_ome07:1/2 Asd001a_ome07:3/4
Asd001a_ome07:1/2 Asd001a_ome07:4/1
Asd001a_ome07:1/2 Asd001a_ome07:4/2
Asd001a_ome07:1/2 Asd001a_ome07:4/3
Asd001a_ome07:1/2 Asd001a_ome07:4/4
Asd001a_ome07:1/2 Asd001a_ome07:5/1
Asd001a_ome07:1/2 Asd001a_ome07:6/1
Asd001a_ome07:1/2 Asd001a_ome07:9/1
Asd001a_ome07:1/3 Asd001a_ome07:1/1
Asd001a_ome07:1/3 Asd001a_ome07:1/2
Asd001a_ome07:1/3 Asd001a_ome07:1/4
Asd001a_ome07:1/3 Asd001a_ome07:10/1
Asd001a_ome07:1/3 Asd001a_ome07:2/1
Asd001a_ome07:1/3 Asd001a_ome07:2/2
Asd001a_ome07:1/3 Asd001a_ome07:2/3
Asd001a_ome07:1/3 Asd001a_ome07:2/4
Asd001a_ome07:1/3 Asd001a_ome07:3/1
Asd001a_ome07:1/3 Asd001a_ome07:3/2
Asd001a_ome07:1/3 Asd001a_ome07:3/3
Asd001a_ome07:1/3 Asd001a_ome07:3/4
Asd001a_ome07:1/3 Asd001a_ome07:4/1
Asd001a_ome07:1/3 Asd001a_ome07:4/2
Asd001a_ome07:1/3 Asd001a_ome07:4/3
Asd001a_ome07:1/3 Asd001a_ome07:4/4
Asd001a_ome07:1/3 Asd001a_ome07:5/1
Asd001a_ome07:1/3 Asd001a_ome07:6/1
Asd001a_ome07:1/3 Asd001a_ome07:9/1
Asd001a_ome07:1/4 Asd001a_ome07:1/1
Asd001a_ome07:1/4 Asd001a_ome07:1/2
Asd001a_ome07:1/4 Asd001a_ome07:1/3
Asd001a_ome07:1/4 Asd001a_ome07:10/1
Asd001a_ome07:1/4 Asd001a_ome07:2/1
Asd001a_ome07:1/4 Asd001a_ome07:2/2
Asd001a_ome07:1/4 Asd001a_ome07:2/3
Asd001a_ome07:1/4 Asd001a_ome07:2/4
Asd001a_ome07:1/4 Asd001a_ome07:3/1
Asd001a_ome07:1/4 Asd001a_ome07:3/2
Asd001a_ome07:1/4 Asd001a_ome07:3/3
Asd001a_ome07:1/4 Asd001a_ome07:3/4
Asd001a_ome07:1/4 Asd001a_ome07:4/1
Asd001a_ome07:1/4 Asd001a_ome07:4/2
Asd001a_ome07:1/4 Asd001a_ome07:4/3
Asd001a_ome07:1/4 Asd001a_ome07:4/4
Asd001a_ome07:1/4 Asd001a_ome07:5/1
Asd001a_ome07:1/4 Asd001a_ome07:6/1
Asd001a_ome07:1/4 Asd001a_ome07:9/1
Asd001a_ome07:10/1 Asd001a_ome02:6/1
Asd001a_ome07:10/1 Asd001a_ome07:1/1
Asd001a_ome07:10/1 Asd001a_ome07:1/2
Asd001a_ome07:10/1 Asd001a_ome07:1/3
Asd001a_ome07:10/1 Asd001a_ome07:1/4
Asd001a_ome07:10/1 Asd001a_ome07:2/1
Asd001a_ome07:10/1 Asd001a_ome07:2/2
Asd001a_ome07:10/1 Asd001a_ome07:2/3
Asd001a_ome07:10/1 Asd001a_ome07:2/4
Asd001a_ome07:10/1 Asd001a_ome07:3/1
Asd001a_ome07:10/1 Asd001a_ome07:3/2
Asd001a_ome07:10/1 Asd001a_ome07:3/3
Asd001a_ome07:10/1 Asd001a_ome07:3/4
Asd001a_ome07:10/1 Asd001a_ome07:4/1
Asd001a_ome07:10/1 Asd001a_ome07:4/2
Asd001a_ome07:10/1 Asd001a_ome07:4/3
Asd001a_ome07:10/1 Asd001a_ome07:4/4
Asd001a_ome07:10/1 Asd001a_ome07:5/1
Asd001a_ome07:10/1 Asd001a_ome07:6/1
Asd001a_ome07:10/1 Asd001a_ome07:9/1
Asd001a_ome07:2/1 Asd001a_ome07:1/1
Asd001a_ome07:2/1 Asd001a_ome07:1/2
Asd001a_ome07:2/1 Asd001a_ome07:1/3
Asd001a_ome07:2/1 Asd001a_ome07:1/4
Asd001a_ome07:2/1 Asd001a_ome07:10/1
Asd001a_ome07:2/1 Asd001a_ome07:2/2
Asd001a_ome07:2/1 Asd001a_ome07:2/3
Asd001a_ome07:2/1 Asd001a_ome07:2/4
Asd001a_ome07:2/1 Asd001a_ome07:3/1
Asd001a_ome07:2/1 Asd001a_ome07:3/2
Asd001a_ome07:2/1 Asd001a_ome07:3/3
Asd001a_ome07:2/1 Asd001a_ome07:3/4
Asd001a_ome07:2/1 Asd001a_ome07:4/1
Asd001a_ome07:2/1 Asd001a_ome07:4/2
Asd001a_ome07:2/1 Asd001a_ome07:4/3
Asd001a_ome07:2/1 Asd001a_ome07:4/4
Asd001a_ome07:2/1 Asd001a_ome07:5/1
Asd001a_ome07:2/1 Asd001a_ome07:6/1
Asd001a_ome07:2/1 Asd001a_ome07:9/1
Asd001a_ome07:2/2 Asd001a_ome07:1/1
Asd001a_ome07:2/2 Asd001a_ome07:1/2
Asd001a_ome07:2/2 Asd001a_ome07:1/3
Asd001a_ome07:2/2 Asd001a_ome07:1/4
Asd001a_ome07:2/2 Asd001a_ome07:10/1
Asd001a_ome07:2/2 Asd001a_ome07:2/1
Asd001a_ome07:2/2 Asd001a_ome07:2/3
Asd001a_ome07:2/2 Asd001a_ome07:2/4
Asd001a_ome07:2/2 Asd001a_ome07:3/1
Asd001a_ome07:2/2 Asd001a_ome07:3/2
Asd001a_ome07:2/2 Asd001a_ome07:3/3
Asd001a_ome07:2/2 Asd001a_ome07:3/4
Asd001a_ome07:2/2 Asd001a_ome07:4/1
Asd001a_ome07:2/2 Asd001a_ome07:4/2
Asd001a_ome07:2/2 Asd001a_ome07:4/3
Asd001a_ome07:2/2 Asd001a_ome07:4/4
Asd001a_ome07:2/2 Asd001a_ome07:5/1
Asd001a_ome07:2/2 Asd001a_ome07:6/1
Asd001a_ome07:2/2 Asd001a_ome07:9/1
Asd001a_ome07:2/3 Asd001a_ome07:1/1
Asd001a_ome07:2/3 Asd001a_ome07:1/2
Asd001a_ome07:2/3 Asd001a_ome07:1/3
Asd001a_ome07:2/3 Asd001a_ome07:1/4
Asd001a_ome07:2/3 Asd001a_ome07:10/1
Asd001a_ome07:2/3 Asd001a_ome07:2/1
Asd001a_ome07:2/3 Asd001a_ome07:2/2
Asd001a_ome07:2/3 Asd001a_ome07:2/4
Asd001a_ome07:2/3 Asd001a_ome07:3/1
Asd001a_ome07:2/3 Asd001a_ome07:3/2
Asd001a_ome07:2/3 Asd001a_ome07:3/3
Asd001a_ome07:2/3 Asd001a_ome07:3/4
Asd001a_ome07:2/3 Asd001a_ome07:4/1
Asd001a_ome07:2/3 Asd001a_ome07:4/2
Asd001a_ome07:2/3 Asd001a_ome07:4/3
Asd001a_ome07:2/3 Asd001a_ome07:4/4
Asd001a_ome07:2/3 Asd001a_ome07:5/1
Asd001a_ome07:2/3 Asd001a_ome07:6/1
Asd001a_ome07:2/3 Asd001a_ome07:9/1
Asd001a_ome07:2/4 Asd001a_ome07:1/1
Asd001a_ome07:2/4 Asd001a_ome07:1/2
Asd001a_ome07:2/4 Asd001a_ome07:1/3
Asd001a_ome07:2/4 Asd001a_ome07:1/4
Asd001a_ome07:2/4 Asd001a_ome07:10/1
Asd001a_ome07:2/4 Asd001a_ome07:2/1
Asd001a_ome07:2/4 Asd001a_ome07:2/2
Asd001a_ome07:2/4 Asd001a_ome07:2/3
Asd001a_ome07:2/4 Asd001a_ome07:3/1
Asd001a_ome07:2/4 Asd001a_ome07:3/2
Asd001a_ome07:2/4 Asd001a_ome07:3/3
Asd001a_ome07:2/4 Asd001a_ome07:3/4
Asd001a_ome07:2/4 Asd001a_ome07:4/1
Asd001a_ome07:2/4 Asd001a_ome07:4/2
Asd001a_ome07:2/4 Asd001a_ome07:4/3
Asd001a_ome07:2/4 Asd001a_ome07:4/4
Asd001a_ome07:2/4 Asd001a_ome07:5/1
Asd001a_ome07:2/4 Asd001a_ome07:6/1
Asd001a_ome07:2/4 Asd001a_ome07:9/1
Asd001a_ome07:3/1 Asd001a_ome07:1/1
Asd001a_ome07:3/1 Asd001a_ome07:1/2
Asd001a_ome07:3/1 Asd001a_ome07:1/3
Asd001a_ome07:3/1 Asd001a_ome07:1/4
Asd001a_ome07:3/1 Asd001a_ome07:10/1
Asd001a_ome07:3/1 Asd001a_ome07:2/1
Asd001a_ome07:3/1 Asd001a_ome07:2/2
Asd001a_ome07:3/1 Asd001a_ome07:2/3
Asd001a_ome07:3/1 Asd001a_ome07:2/4
Asd001a_ome07:3/1 Asd001a_ome07:3/2
Asd001a_ome07:3/1 Asd001a_ome07:3/3
Asd001a_ome07:3/1 Asd001a_ome07:3/4
Asd001a_ome07:3/1 Asd001a_ome07:4/1
Asd001a_ome07:3/1 Asd001a_ome07:4/2
Asd001a_ome07:3/1 Asd001a_ome07:4/3
Asd001a_ome07:3/1 Asd001a_ome07:4/4
Asd001a_ome07:3/1 Asd001a_ome07:5/1
Asd001a_ome07:3/1 Asd001a_ome07:6/1
Asd001a_ome07:3/1 Asd001a_ome07:9/1
Asd001a_ome07:3/2 Asd001a_ome07:1/1
Asd001a_ome07:3/2 Asd001a_ome07:1/2
Asd001a_ome07:3/2 Asd001a_ome07:1/3
Asd001a_ome07:3/2 Asd001a_ome07:1/4
Asd001a_ome07:3/2 Asd001a_ome07:10/1
Asd001a_ome07:3/2 Asd001a_ome07:2/1
Asd001a_ome07:3/2 Asd001a_ome07:2/2
Asd001a_ome07:3/2 Asd001a_ome07:2/3
Asd001a_ome07:3/2 Asd001a_ome07:2/4
Asd001a_ome07:3/2 Asd001a_ome07:3/1
Asd001a_ome07:3/2 Asd001a_ome07:3/3
Asd001a_ome07:3/2 Asd001a_ome07:3/4
Asd001a_ome07:3/2 Asd001a_ome07:4/1
Asd001a_ome07:3/2 Asd001a_ome07:4/2
Asd001a_ome07:3/2 Asd001a_ome07:4/3
Asd001a_ome07:3/2 Asd001a_ome07:4/4
Asd001a_ome07:3/2 Asd001a_ome07:5/1
Asd001a_ome07:3/2 Asd001a_ome07:6/1
Asd001a_ome07:3/2 Asd001a_ome07:9/1
Asd001a_ome07:3/3 Asd001a_ome07:1/1
Asd001a_ome07:3/3 Asd001a_ome07:1/2
Asd001a_ome07:3/3 Asd001a_ome07:1/3
Asd001a_ome07:3/3 Asd001a_ome07:1/4
Asd001a_ome07:3/3 Asd001a_ome07:10/1
Asd001a_ome07:3/3 Asd001a_ome07:2/1
Asd001a_ome07:3/3 Asd001a_ome07:2/2
Asd001a_ome07:3/3 Asd001a_ome07:2/3
Asd001a_ome07:3/3 Asd001a_ome07:2/4
Asd001a_ome07:3/3 Asd001a_ome07:3/1
Asd001a_ome07:3/3 Asd001a_ome07:3/2
Asd001a_ome07:3/3 Asd001a_ome07:3/4
Asd001a_ome07:3/3 Asd001a_ome07:4/1
Asd001a_ome07:3/3 Asd001a_ome07:4/2
Asd001a_ome07:3/3 Asd001a_ome07:4/3
Asd001a_ome07:3/3 Asd001a_ome07:4/4
Asd001a_ome07:3/3 Asd001a_ome07:5/1
Asd001a_ome07:3/3 Asd001a_ome07:6/1
Asd001a_ome07:3/3 Asd001a_ome07:9/1
Asd001a_ome07:3/4 Asd001a_ome07:1/1
Asd001a_ome07:3/4 Asd001a_ome07:1/2
Asd001a_ome07:3/4 Asd001a_ome07:1/3
Asd001a_ome07:3/4 Asd001a_ome07:1/4
Asd001a_ome07:3/4 Asd001a_ome07:10/1
Asd001a_ome07:3/4 Asd001a_ome07:2/1
Asd001a_ome07:3/4 Asd001a_ome07:2/2
Asd001a_ome07:3/4 Asd001a_ome07:2/3
Asd001a_ome07:3/4 Asd001a_ome07:2/4
Asd001a_ome07:3/4 Asd001a_ome07:3/1
Asd001a_ome07:3/4 Asd001a_ome07:3/2
Asd001a_ome07:3/4 Asd001a_ome07:3/3
Asd001a_ome07:3/4 Asd001a_ome07:4/1
Asd001a_ome07:3/4 Asd001a_ome07:4/2
Asd001a_ome07:3/4 Asd001a_ome07:4/3
Asd001a_ome07:3/4 Asd001a_ome07:4/4
Asd001a_ome07:3/4 Asd001a_ome07:5/1
Asd001a_ome07:3/4 Asd001a_ome07:6/1
Asd001a_ome07:3/4 Asd001a_ome07:9/1
Asd001a_ome07:4/1 Asd001a_ome07:1/1
Asd001a_ome07:4/1 Asd001a_ome07:1/2
Asd001a_ome07:4/1 Asd001a_ome07:1/3
Asd001a_ome07:4/1 Asd001a_ome07:1/4
Asd001a_ome07:4/1 Asd001a_ome07:10/1
Asd001a_ome07:4/1 Asd001a_ome07:2/1
Asd001a_ome07:4/1 Asd001a_ome07:2/2
Asd001a_ome07:4/1 Asd001a_ome07:2/3
Asd001a_ome07:4/1 Asd001a_ome07:2/4
Asd001a_ome07:4/1 Asd001a_ome07:3/1
Asd001a_ome07:4/1 Asd001a_ome07:3/2
Asd001a_ome07:4/1 Asd001a_ome07:3/3
Asd001a_ome07:4/1 Asd001a_ome07:3/4
Asd001a_ome07:4/1 Asd001a_ome07:4/2
Asd001a_ome07:4/1 Asd001a_ome07:4/3
Asd001a_ome07:4/1 Asd001a_ome07:4/4
Asd001a_ome07:4/1 Asd001a_ome07:5/1
Asd001a_ome07:4/1 Asd001a_ome07:6/1
Asd001a_ome07:4/1 Asd001a_ome07:9/1
Asd001a_ome07:4/2 Asd001a_ome07:1/1
Asd001a_ome07:4/2 Asd001a_ome07:1/2
Asd001a_ome07:4/2 Asd001a_ome07:1/3
Asd001a_ome07:4/2 Asd001a_ome07:1/4
Asd001a_ome07:4/2 Asd001a_ome07:10/1
Asd001a_ome07:4/2 Asd001a_ome07:2/1
Asd001a_ome07:4/2 Asd001a_ome07:2/2
Asd001a_ome07:4/2 Asd001a_ome07:2/3
Asd001a_ome07:4/2 Asd001a_ome07:2/4
Asd001a_ome07:4/2 Asd001a_ome07:3/1
Asd001a_ome07:4/2 Asd001a_ome07:3/2
Asd001a_ome07:4/2 Asd001a_ome07:3/3
Asd001a_ome07:4/2 Asd001a_ome07:3/4
Asd001a_ome07:4/2 Asd001a_ome07:4/1
Asd001a_ome07:4/2 Asd001a_ome07:4/3
Asd001a_ome07:4/2 Asd001a_ome07:4/4
Asd001a_ome07:4/2 Asd001a_ome07:5/1
Asd001a_ome07:4/2 Asd001a_ome07:6/1
Asd001a_ome07:4/2 Asd001a_ome07:9/1
Asd001a_ome07:4/3 Asd001a_ome07:1/1
Asd001a_ome07:4/3 Asd001a_ome07:1/2
Asd001a_ome07:4/3 Asd001a_ome07:1/3
Asd001a_ome07:4/3 Asd001a_ome07:1/4
Asd001a_ome07:4/3 Asd001a_ome07:10/1
Asd001a_ome07:4/3 Asd001a_ome07:2/1
Asd001a_ome07:4/3 Asd001a_ome07:2/2
Asd001a_ome07:4/3 Asd001a_ome07:2/3
Asd001a_ome07:4/3 Asd001a_ome07:2/4
Asd001a_ome07:4/3 Asd001a_ome07:3/1
Asd001a_ome07:4/3 Asd001a_ome07:3/2
Asd001a_ome07:4/3 Asd001a_ome07:3/3
Asd001a_ome07:4/3 Asd001a_ome07:3/4
Asd001a_ome07:4/3 Asd001a_ome07:4/1
Asd001a_ome07:4/3 Asd001a_ome07:4/2
Asd001a_ome07:4/3 Asd001a_ome07:4/4
Asd001a_ome07:4/3 Asd001a_ome07:5/1
Asd001a_ome07:4/3 Asd001a_ome07:6/1
Asd001a_ome07:4/3 Asd001a_ome07:9/1
Asd001a_ome07:4/4 Asd001a_ome07:1/1
Asd001a_ome07:4/4 Asd001a_ome07:1/2
Asd001a_ome07:4/4 Asd001a_ome07:1/3
Asd001a_ome07:4/4 Asd001a_ome07:1/4
Asd001a_ome07:4/4 Asd001a_ome07:10/1
Asd001a_ome07:4/4 Asd001a_ome07:2/1
Asd001a_ome07:4/4 Asd001a_ome07:2/2
Asd001a_ome07:4/4 Asd001a_ome07:2/3
Asd001a_ome07:4/4 Asd001a_ome07:2/4
Asd001a_ome07:4/4 Asd001a_ome07:3/1
Asd001a_ome07:4/4 Asd001a_ome07:3/2
Asd001a_ome07:4/4 Asd001a_ome07:3/3
Asd001a_ome07:4/4 Asd001a_ome07:3/4
Asd001a_ome07:4/4 Asd001a_ome07:4/1
Asd001a_ome07:4/4 Asd001a_ome07:4/2
Asd001a_ome07:4/4 Asd001a_ome07:4/3
Asd001a_ome07:4/4 Asd001a_ome07:5/1
Asd001a_ome07:4/4 Asd001a_ome07:6/1
Asd001a_ome07:4/4 Asd001a_ome07:9/1
Asd001a_ome07:5/1 Asd001a_ome07:1/1
Asd001a_ome07:5/1 Asd001a_ome07:1/2
Asd001a_ome07:5/1 Asd001a_ome07:1/3
Asd001a_ome07:5/1 Asd001a_ome07:1/4
Asd001a_ome07:5/1 Asd001a_ome07:10/1
Asd001a_ome07:5/1 Asd001a_ome07:2/1
Asd001a_ome07:5/1 Asd001a_ome07:2/2
Asd001a_ome07:5/1 Asd001a_ome07:2/3
Asd001a_ome07:5/1 Asd001a_ome07:2/4
Asd001a_ome07:5/1 Asd001a_ome07:3/1
Asd001a_ome07:5/1 Asd001a_ome07:3/2
Asd001a_ome07:5/1 Asd001a_ome07:3/3
Asd001a_ome07:5/1 Asd001a_ome07:3/4
Asd001a_ome07:5/1 Asd001a_ome07:4/1
Asd001a_ome07:5/1 Asd001a_ome07:4/2
Asd001a_ome07:5/1 Asd001a_ome07:4/3
Asd001a_ome07:5/1 Asd001a_ome07:4/4
Asd001a_ome07:5/1 Asd001a_ome07:6/1
Asd001a_ome07:5/1 Asd001a_ome07:9/1
Asd001a_ome07:5/1 Gn001a_ome01:6/1
Asd001a_ome07:6/1 Asd001a_ome07:1/1
Asd001a_ome07:6/1 Asd001a_ome07:1/2
Asd001a_ome07:6/1 Asd001a_ome07:1/3
Asd001a_ome07:6/1 Asd001a_ome07:1/4
Asd001a_ome07:6/1 Asd001a_ome07:10/1
Asd001a_ome07:6/1 Asd001a_ome07:2/1
Asd001a_ome07:6/1 Asd001a_ome07:2/2
Asd001a_ome07:6/1 Asd001a_ome07:2/3
Asd001a_ome07:6/1 Asd001a_ome07:2/4
Asd001a_ome07:6/1 Asd001a_ome07:3/1
Asd001a_ome07:6/1 Asd001a_ome07:3/2
Asd001a_ome07:6/1 Asd001a_ome07:3/3
Asd001a_ome07:6/1 Asd001a_ome07:3/4
Asd001a_ome07:6/1 Asd001a_ome07:4/1
Asd001a_ome07:6/1 Asd001a_ome07:4/2
Asd001a_ome07:6/1 Asd001a_ome07:4/3
Asd001a_ome07:6/1 Asd001a_ome07:4/4
Asd001a_ome07:6/1 Asd001a_ome07:5/1
Asd001a_ome07:6/1 Asd001a_ome07:9/1
Asd001a_ome07:6/1 Dgl001a_ome01:6/1
Asd001a_ome07:9/1 Asd001a_ome07:1/1
Asd001a_ome07:9/1 Asd001a_ome07:1/2
Asd001a_ome07:9/1 Asd001a_ome07:1/3
Asd001a_ome07:9/1 Asd001a_ome07:1/4
Asd001a_ome07:9/1 Asd001a_ome07:10/1
Asd001a_ome07:9/1 Asd001a_ome07:2/1
Asd001a_ome07:9/1 Asd001a_ome07:2/2
Asd001a_ome07:9/1 Asd001a_ome07:2/3
Asd001a_ome07:9/1 Asd001a_ome07:2/4
Asd001a_ome07:9/1 Asd001a_ome07:3/1
Asd001a_ome07:9/1 Asd001a_ome07:3/2
Asd001a_ome07:9/1 Asd001a_ome07:3/3
Asd001a_ome07:9/1 Asd001a_ome07:3/4
Asd001a_ome07:9/1 Asd001a_ome07:4/1
Asd001a_ome07:9/1 Asd001a_ome07:4/2
Asd001a_ome07:9/1 Asd001a_ome07:4/3
Asd001a_ome07:9/1 Asd001a_ome07:4/4
Asd001a_ome07:9/1 Asd001a_ome07:5/1
Asd001a_ome07:9/1 Asd001a_ome07:6/1
Asd001a_ome07:9/1 Asd003a_ome01:6/1
Asd002a_ome01:1/1 Asd002a_ome01:1/2
Asd002a_ome01:1/1 Asd002a_ome01:10/1
Asd002a_ome01:1/1 Asd002a_ome01:4/1
Asd002a_ome01:1/1 Asd002a_ome01:5/1
Asd002a_ome01:1/1 Asd002a_ome01:6/1
Asd002a_ome01:1/1 Asd002a_ome01:9/1
Asd002a_ome01:1/1 Asd002a_ome02:1/1
Asd002a_ome01:1/2 Asd002a_ome01:1/1
Asd002a_ome01:1/2 Asd002a_ome01:10/1
Asd002a_ome01:1/2 Asd002a_ome01:4/1
Asd002a_ome01:1/2 Asd002a_ome01:5/1
Asd002a_ome01:1/2 Asd002a_ome01:6/1
Asd002a_ome01:1/2 Asd002a_ome01:9/1
Asd002a_ome01:1/2 Asd002a_ome02:1/2
Asd002a_ome01:10/1 Asd001a_ome01:10/1
Asd002a_ome01:10/1 Asd002a_ome01:1/1
Asd002a_ome01:10/1 Asd002a_ome01:1/2
Asd002a_ome01:10/1 Asd002a_ome01:4/1
Asd002a_ome01:10/1 Asd002a_ome01:5/1
Asd002a_ome01:10/1 Asd002a_ome01:6/1
Asd002a_ome01:10/1 Asd002a_ome01:9/1
Asd002a_ome01:4/1 Asd002a_ome01:1/1
Asd002a_ome01:4/1 Asd002a_ome01:1/2
Asd002a_ome01:4/1 Asd002a_ome01:10/1
Asd002a_ome01:4/1 Asd002a_ome01:5/1
Asd002a_ome01:4/1 Asd002a_ome01:6/1
Asd002a_ome01:4/1 Asd002a_ome01:9/1
Asd002a_ome01:4/1 Ledn001a_ome01:10/1
Asd002a_ome01:5/1 Asd002a_ome01:1/1
Asd002a_ome01:5/1 Asd002a_ome01:1/2
Asd002a_ome01:5/1 Asd002a_ome01:10/1
Asd002a_ome01:5/1 Asd002a_ome01:4/1
Asd002a_ome01:5/1 Asd002a_ome01:6/1
Asd002a_ome01:5/1 Asd002a_ome01:9/1
Asd002a_ome01:5/1 Asd002a_ome05:10/1
Asd002a_ome01:6/1 Asd002a_ome01:1/1
Asd002a_ome01:6/1 Asd002a_ome01:1/2
Asd002a_ome01:6/1 Asd002a_ome01:10/1
Asd002a_ome01:6/1 Asd002a_ome01:4/1
Asd002a_ome01:6/1 Asd002a_ome01:5/1
Asd002a_ome01:6/1 Asd002a_ome01:9/1
Asd002a_ome01:6/1 Asd002a_ome04:10/1
Asd002a_ome01:9/1 Asd002a_ome01:1/1
Asd002a_ome01:9/1 Asd002a_ome01:1/2
Asd002a_ome01:9/1 Asd002a_ome01:10/1
Asd002a_ome01:9/1 Asd002a_ome01:4/1
Asd002a_ome01:9/1 Asd002a_ome01:5/1
Asd002a_ome01:9/1 Asd002a_ome01:6/1
Asd002a_ome01:9/1 Asd002a_ome03:10/1
Asd002a_ome02:1/1 Asd002a_ome01:1/1
Asd002a_ome02:1/1 Asd002a_ome02:1/2
Asd002a_ome02:1/1 Asd002a_ome02:10/1
Asd002a_ome02:1/1 Asd002a_ome02:4/1
Asd002a_ome02:1/1 Asd002a_ome02:5/1
Asd002a_ome02:1/1 Asd002a_ome02:6/1
Asd002a_ome02:1/2 Asd002a_ome01:1/2
Asd002a_ome02:1/2 Asd002a_ome02:1/1
Asd002a_ome02:1/2 Asd002a_ome02:10/1
Asd002a_ome02:1/2 Asd002a_ome02:4/1
Asd002a_ome02:1/2 Asd002a_ome02:5/1
Asd002a_ome02:1/2 Asd002a_ome02:6/1
Asd002a_ome02:10/1 Asd001a_ome02:10/1
Asd002a_ome02:10/1 Asd002a_ome02:1/1
Asd002a_ome02:10/1 Asd002a_ome02:1/2
Asd002a_ome02:10/1 Asd002a_ome02:4/1
Asd002a_ome02:10/1 Asd002a_ome02:5/1
Asd002a_ome02:10/1 Asd002a_ome02:6/1
Asd002a_ome02:4/1 Asd002a_ome02:1/1
Asd002a_ome02:4/1 Asd002a_ome02:1/2
Asd002a_ome02:4/1 Asd002a_ome02:10/1
Asd002a_ome02:4/1 Asd002a_ome02:5/1
Asd002a_ome02:4/1 Asd002a_ome02:6/1
Asd002a_ome02:4/1 Nm001a_ome02:9/1
Asd002a_ome02:5/1 Asd002a_ome02:1/1
Asd002a_ome02:5/1 Asd002a_ome02:1/2
Asd002a_ome02:5/1 Asd002a_ome02:10/1
Asd002a_ome02:5/1 Asd002a_ome02:4/1
Asd002a_ome02:5/1 Asd002a_ome02:6/1
Asd002a_ome02:5/1 Asd002a_ome07:10/1
Asd002a_ome02:6/1 Asd002a_ome02:1/1
Asd002a_ome02:6/1 Asd002a_ome02:1/2
Asd002a_ome02:6/1 Asd002a_ome02:10/1
Asd002a_ome02:6/1 Asd002a_ome02:4/1
Asd002a_ome02:6/1 Asd002a_ome02:5/1
Asd002a_ome02:6/1 Asd002a_ome06:10/1
Asd002a_ome03:1/1 Asd002a_ome03:1/2
Asd002a_ome03:1/1 Asd002a_ome03:10/1
Asd002a_ome03:1/1 Asd002a_ome03:2/1
Asd002a_ome03:1/1 Asd002a_ome03:2/2
Asd002a_ome03:1/1 Asd002a_ome03:5/1
Asd002a_ome03:1/1 Asd002a_ome03:6/1
Asd002a_ome03:1/1 Asd002a_ome03:9/1
Asd002a_ome03:1/2 Asd002a_ome03:1/1
Asd002a_ome03:1/2 Asd002a_ome03:10/1
Asd002a_ome03:1/2 Asd002a_ome03:2/1
Asd002a_ome03:1/2 Asd002a_ome03:2/2
Asd002a_ome03:1/2 Asd002a_ome03:5/1
Asd002a_ome03:1/2 Asd002a_ome03:6/1
Asd002a_ome03:1/2 Asd002a_ome03:9/1
Asd002a_ome03:10/1 Asd002a_ome01:9/1
Asd002a_ome03:10/1 Asd002a_ome03:1/1
Asd002a_ome03:10/1 Asd002a_ome03:1/2
Asd002a_ome03:10/1 Asd002a_ome03:2/1
Asd002a_ome03:10/1 Asd002a_ome03:2/2
Asd002a_ome03:10/1 Asd002a_ome03:5/1
Asd002a_ome03:10/1 Asd002a_ome03:6/1
Asd002a_ome03:10/1 Asd002a_ome03:9/1
Asd002a_ome03:2/1 Asd002a_ome03:1/1
Asd002a_ome03:2/1 Asd002a_ome03:1/2
Asd002a_ome03:2/1 Asd002a_ome03:10/1
Asd002a_ome03:2/1 Asd002a_ome03:2/2
Asd002a_ome03:2/1 Asd002a_ome03:5/1
Asd002a_ome03:2/1 Asd002a_ome03:6/1
Asd002a_ome03:2/1 Asd002a_ome03:9/1
Asd002a_ome03:2/2 Asd002a_ome03:1/1
Asd002a_ome03:2/2 Asd002a_ome03:1/2
Asd002a_ome03:2/2 Asd002a_ome03:10/1
Asd002a_ome03:2/2 Asd002a_ome03:2/1
Asd002a_ome03:2/2 Asd002a_ome03:5/1
Asd002a_ome03:2/2 Asd002a_ome03:6/1
Asd002a_ome03:2/2 Asd002a_ome03:9/1
Asd002a_ome03:5/1 Asd002a_ome03:1/1
Asd002a_ome03:5/1 Asd002a_ome03:1/2
Asd002a_ome03:5/1 Asd002a_ome03:10/1
Asd002a_ome03:5/1 Asd002a_ome03:2/1
Asd002a_ome03:5/1 Asd002a_ome03:2/2
Asd002a_ome03:5/1 Asd002a_ome03:6/1
Asd002a_ome03:5/1 Asd002a_ome03:9/1
Asd002a_ome03:5/1 Ledn001a_ome01:9/1
Asd002a_ome03:6/1 Asd002a_ome03:1/1
Asd002a_ome03:6/1 Asd002a_ome03:1/2
Asd002a_ome03:6/1 Asd002a_ome03:10/1
Asd002a_ome03:6/1 Asd002a_ome03:2/1
Asd002a_ome03:6/1 Asd002a_ome03:2/2
Asd002a_ome03:6/1 Asd002a_ome03:5/1
Asd002a_ome03:6/1 Asd002a_ome03:9/1
Asd002a_ome03:6/1 Gv001a_ome01:9/1
Asd002a_ome03:9/1 Asd002a_ome03:1/1
Asd002a_ome03:9/1 Asd002a_ome03:1/2
Asd002a_ome03:9/1 Asd002a_ome03:10/1
Asd002a_ome03:9/1 Asd002a_ome03:2/1
Asd002a_ome03:9/1 Asd002a_ome03:2/2
Asd002a_ome03:9/1 Asd002a_ome03:5/1
Asd002a_ome03:9/1 Asd002a_ome03:6/1
Asd002a_ome03:9/1 Dt001a_ome01:9/1
Asd002a_ome04:1/1 Asd002a_ome04:1/2
Asd002a_ome04:1/1 Asd002a_ome04:1/3
Asd002a_ome04:1/1 Asd002a_ome04:1/4
Asd002a_ome04:1/1 Asd002a_ome04:10/1
Asd002a_ome04:1/1 Asd002a_ome04:2/1
Asd002a_ome04:1/1 Asd002a_ome04:2/2
Asd002a_ome04:1/1 Asd002a_ome04:2/4
Asd002a_ome04:1/1 Asd002a_ome04:5/1
Asd002a_ome04:1/1 Asd002a_ome04:6/1
Asd002a_ome04:1/1 Asd002a_ome04:9/1
Asd002a_ome04:1/2 Asd002a_ome04:1/1
Asd002a_ome04:1/2 Asd002a_ome04:1/3
Asd002a_ome04:1/2 Asd002a_ome04:1/4
Asd002a_ome04:1/2 Asd002a_ome04:10/1
Asd002a_ome04:1/2 Asd002a_ome04:2/1
Asd002a_ome04:1/2 Asd002a_ome04:2/2
Asd002a_ome04:1/2 Asd002a_ome04:2/4
Asd002a_ome04:1/2 Asd002a_ome04:5/1
Asd002a_ome04:1/2 Asd002a_ome04:6/1
Asd002a_ome04:1/2 Asd002a_ome04:9/1
Asd002a_ome04:1/3 Asd002a_ome04:1/1
Asd002a_ome04:1/3 Asd002a_ome04:1/2
Asd002a_ome04:1/3 Asd002a_ome04:1/4
Asd002a_ome04:1/3 Asd002a_ome04:10/1
Asd002a_ome04:1/3 Asd002a_ome04:2/1
Asd002a_ome04:1/3 Asd002a_ome04:2/2
Asd002a_ome04:1/3 Asd002a_ome04:2/4
Asd002a_ome04:1/3 Asd002a_ome04:5/1
Asd002a_ome04:1/3 Asd002a_ome04:6/1
Asd002a_ome04:1/3 Asd002a_ome04:9/1
Asd002a_ome04:1/4 Asd002a_ome04:1/1
Asd002a_ome04:1/4 Asd002a_ome04:1/2
Asd002a_ome04:1/4 Asd002a_ome04:1/3
Asd002a_ome04:1/4 Asd002a_ome04:10/1
Asd002a_ome04:1/4 Asd002a_ome04:2/1
Asd002a_ome04:1/4 Asd002a_ome04:2/2
Asd002a_ome04:1/4 Asd002a_ome04:2/4
Asd002a_ome04:1/4 Asd002a_ome04:5/1
Asd002a_ome04:1/4 Asd002a_ome04:6/1
Asd002a_ome04:1/4 Asd002a_ome04:9/1
Asd002a_ome04:10/1 Asd002a_ome01:6/1
Asd002a_ome04:10/1 Asd002a_ome04:1/1
Asd002a_ome04:10/1 Asd002a_ome04:1/2
Asd002a_ome04:10/1 Asd002a_ome04:1/3
Asd002a_ome04:10/1 Asd002a_ome04:1/4
Asd002a_ome04:10/1 Asd002a_ome04:2/1
Asd002a_ome04:10/1 Asd002a_ome04:2/2
Asd002a_ome04:10/1 Asd002a_ome04:2/4
Asd002a_ome04:10/1 Asd002a_ome04:5/1
Asd002a_ome04:10/1 Asd002a_ome04:6/1
Asd002a_ome04:10/1 Asd002a_ome04:9/1
Asd002a_ome04:2/1 Asd002a_ome04:1/1
Asd002a_ome04:2/1 Asd002a_ome04:1/2
Asd002a_ome04:2/1 Asd002a_ome04:1/3
Asd002a_ome04:2/1 Asd002a_ome04:1/4
Asd002a_ome04:2/1 Asd002a_ome04:10/1
Asd002a_ome04:2/1 Asd002a_ome04:2/2
Asd002a_ome04:2/1 Asd002a_ome04:2/4
Asd002a_ome04:2/1 Asd002a_ome04:5/1
Asd002a_ome04:2/1 Asd002a_ome04:6/1
Asd002a_ome04:2/1 Asd002a_ome04:9/1
Asd002a_ome04:2/2 Asd002a_ome04:1/1
Asd002a_ome04:2/2 Asd002a_ome04:1/2
Asd002a_ome04:2/2 Asd002a_ome04:1/3
Asd002a_ome04:2/2 Asd002a_ome04:1/4
Asd002a_ome04:2/2 Asd002a_ome04:10/1
Asd002a_ome04:2/2 Asd002a_ome04:2/1
Asd002a_ome04:2/2 Asd002a_ome04:2/4
Asd002a_ome04:2/2 Asd002a_ome04:5/1
Asd002a_ome04:2/2 Asd002a_ome04:6/1
Asd002a_ome04:2/2 Asd002a_ome04:9/1
Asd002a_ome04:2/4 Asd002a_ome04:1/1
Asd002a_ome04:2/4 Asd002a_ome04:1/2
Asd002a_ome04:2/4 Asd002a_ome04:1/3
Asd002a_ome04:2/4 Asd002a_ome04:1/4
Asd002a_ome04:2/4 Asd002a_ome04:10/1
Asd002a_ome04:2/4 Asd002a_ome04:2/1
Asd002a_ome04:2/4 Asd002a_ome04:2/2
Asd002a_ome04:2/4 Asd002a_ome04:5/1
Asd002a_ome04:2/4 Asd002a_ome04:6/1
Asd002a_ome04:2/4 Asd002a_ome04:9/1
Asd002a_ome04:5/1 Asd002a_ome04:1/1
Asd002a_ome04:5/1 Asd002a_ome04:1/2
Asd002a_ome04:5/1 Asd002a_ome04:1/3
Asd002a_ome04:5/1 Asd002a_ome04:1/4
Asd002a_ome04:5/1 Asd002a_ome04:10/1
Asd002a_ome04:5/1 Asd002a_ome04:2/1
Asd002a_ome04:5/1 Asd002a_ome04:2/2
Asd002a_ome04:5/1 Asd002a_ome04:2/4
Asd002a_ome04:5/1 Asd002a_ome04:6/1
Asd002a_ome04:5/1 Asd002a_ome04:9/1
Asd002a_ome04:5/1 Ut001a_ome01:9/1
Asd002a_ome04:6/1 Asd002a_ome04:1/1
Asd002a_ome04:6/1 Asd002a_ome04:1/2
Asd002a_ome04:6/1 Asd002a_ome04:1/3
Asd002a_ome04:6/1 Asd002a_ome04:1/4
Asd002a_ome04:6/1 Asd002a_ome04:10/1
Asd002a_ome04:6/1 Asd002a_ome04:2/1
Asd002a_ome04:6/1 Asd002a_ome04:2/2
Asd002a_ome04:6/1 Asd002a_ome04:2/4
Asd002a_ome04:6/1 Asd002a_ome04:5/1
Asd002a_ome04:6/1 Asd002a_ome04:9/1
Asd002a_ome04:6/1 Hvs001a_ome01:9/1
Asd002a_ome04:9/1 Asd002a_ome04:1/1
Asd002a_ome04:9/1 Asd002a_ome04:1/2
Asd002a_ome04:9/1 Asd002a_ome04:1/3
Asd002a_ome04:9/1 Asd002a_ome04:1/4
Asd002a_ome04:9/1 Asd002a_ome04:10/1
Asd002a_ome04:9/1 Asd002a_ome04:2/1
Asd002a_ome04:9/1 Asd002a_ome04:2/2
Asd002a_ome04:9/1 Asd002a_ome04:2/4
Asd002a_ome04:9/1 Asd002a_ome04:5/1
Asd002a_ome04:9/1 Asd002a_ome04:6/1
Asd002a_ome04:9/1 Rt001a_ome01:9/1
Asd002a_ome05:1/1 Asd002a_ome05:1/2
Asd002a_ome05:1/1 Asd002a_ome05:1/3
Asd002a_ome05:1/1 Asd002a_ome05:1/4
Asd002a_ome05:1/1 Asd002a_ome05:10/1
Asd002a_ome05:1/1 Asd002a_ome05:2/1
Asd002a_ome05:1/1 Asd002a_ome05:2/2
Asd002a_ome05:1/1 Asd002a_ome05:2/3
Asd002a_ome05:1/1 Asd002a_ome05:2/4
Asd002a_ome05:1/1 Asd002a_ome05:3/2
Asd002a_ome05:1/1 Asd002a_ome05:3/3
Asd002a_ome05:1/1 Asd002a_ome05:3/4
Asd002a_ome05:1/1 Asd002a_ome05:5/1
Asd002a_ome05:1/1 Asd002a_ome05:6/1
Asd002a_ome05:1/1 Asd002a_ome05:9/1
Asd002a_ome05:1/2 Asd002a_ome05:1/1
Asd002a_ome05:1/2 Asd002a_ome05:1/3
Asd002a_ome05:1/2 Asd002a_ome05:1/4
Asd002a_ome05:1/2 Asd002a_ome05:10/1
Asd002a_ome05:1/2 Asd002a_ome05:2/1
Asd002a_ome05:1/2 Asd002a_ome05:2/2
Asd002a_ome05:1/2 Asd002a_ome05:2/3
Asd002a_ome05:1/2 Asd002a_ome05:2/4
Asd002a_ome05:1/2 Asd002a_ome05:3/2
Asd002a_ome05:1/2 Asd002a_ome05:3/3
Asd002a_ome05:1/2 Asd002a_ome05:3/4
Asd002a_ome05:1/2 Asd002a_ome05:5/1
Asd002a_ome05:1/2 Asd002a_ome05:6/1
Asd002a_ome05:1/2 Asd002a_ome05:9/1
Asd002a_ome05:1/3 Asd002a_ome05:1/1
Asd002a_ome05:1/3 Asd002a_ome05:1/2
Asd002a_ome05:1/3 Asd002a_ome05:1/4
Asd002a_ome05:1/3 Asd002a_ome05:10/1
Asd002a_ome05:1/3 Asd002a_ome05:2/1
Asd002a_ome05:1/3 Asd002a_ome05:2/2
Asd002a_ome05:1/3 Asd002a_ome05:2/3
Asd002a_ome05:1/3 Asd002a_ome05:2/4
Asd002a_ome05:1/3 Asd002a_ome05:3/2
Asd002a_ome05:1/3 Asd002a_ome05:3/3
Asd002a_ome05:1/3 Asd002a_ome05:3/4
Asd002a_ome05:1/3 Asd002a_ome05:5/1
Asd002a_ome05:1/3 Asd002a_ome05:6/1
Asd002a_ome05:1/3 Asd002a_ome05:9/1
Asd002a_ome05:1/4 Asd002a_ome05:1/1
Asd002a_ome05:1/4 Asd002a_ome05:1/2
Asd002a_ome05:1/4 Asd002a_ome05:1/3
Asd002a_ome05:1/4 Asd002a_ome05:10/1
Asd002a_ome05:1/4 Asd002a_ome05:2/1
Asd002a_ome05:1/4 Asd002a_ome05:2/2
Asd002a_ome05:1/4 Asd002a_ome05:2/3
Asd002a_ome05:1/4 Asd002a_ome05:2/4
Asd002a_ome05:1/4 Asd002a_ome05:3/2
Asd002a_ome05:1/4 Asd002a_ome05:3/3
Asd002a_ome05:1/4 Asd002a_ome05:3/4
Asd002a_ome05:1/4 Asd002a_ome05:5/1
Asd002a_ome05:1/4 Asd002a_ome05:6/1
Asd002a_ome05:1/4 Asd002a_ome05:9/1
Asd002a_ome05:10/1 Asd002a_ome01:5/1
Asd002a_ome05:10/1 Asd002a_ome05:1/1
Asd002a_ome05:10/1 Asd002a_ome05:1/2
Asd002a_ome05:10/1 Asd002a_ome05:1/3
Asd002a_ome05:10/1 Asd002a_ome05:1/4
Asd002a_ome05:10/1 Asd002a_ome05:2/1
Asd002a_ome05:10/1 Asd002a_ome05:2/2
Asd002a_ome05:10/1 Asd002a_ome05:2/3
Asd002a_ome05:10/1 Asd002a_ome05:2/4
Asd002a_ome05:10/1 Asd002a_ome05:3/2
Asd002a_ome05:10/1 Asd002a_ome05:3/3
Asd002a_ome05:10/1 Asd002a_ome05:3/4
Asd002a_ome05:10/1 Asd002a_ome05:5/1
Asd002a_ome05:10/1 Asd002a_ome05:6/1
Asd002a_ome05:10/1 Asd002a_ome05:9/1
Asd002a_ome05:2/1 Asd002a_ome05:1/1
Asd002a_ome05:2/1 Asd002a_ome05:1/2
Asd002a_ome05:2/1 Asd002a_ome05:1/3
Asd002a_ome05:2/1 Asd002a_ome05:1/4
Asd002a_ome05:2/1 Asd002a_ome05:10/1
Asd002a_ome05:2/1 Asd002a_ome05:2/2
Asd002a_ome05:2/1 Asd002a_ome05:2/3
Asd002a_ome05:2/1 Asd002a_ome05:2/4
Asd002a_ome05:2/1 Asd002a_ome05:3/2
Asd002a_ome05:2/1 Asd002a_ome05:3/3
Asd002a_ome05:2/1 Asd002a_ome05:3/4
Asd002a_ome05:2/1 Asd002a_ome05:5/1
Asd002a_ome05:2/1 Asd002a_ome05:6/1
Asd002a_ome05:2/1 Asd002a_ome05:9/1
Asd002a_ome05:2/2 Asd002a_ome05:1/1
Asd002a_ome05:2/2 Asd002a_ome05:1/2
Asd002a_ome05:2/2 Asd002a_ome05:1/3
Asd002a_ome05:2/2 Asd002a_ome05:1/4
Asd002a_ome05:2/2 Asd002a_ome05:10/1
Asd002a_ome05:2/2 Asd002a_ome05:2/1
Asd002a_ome05:2/2 Asd002a_ome05:2/3
Asd002a_ome05:2/2 Asd002a_ome05:2/4
Asd002a_ome05:2/2 Asd002a_ome05:3/2
Asd002a_ome05:2/2 Asd002a_ome05:3/3
Asd002a_ome05:2/2 Asd002a_ome05:3/4
Asd002a_ome05:2/2 Asd002a_ome05:5/1
Asd002a_ome05:2/2 Asd002a_ome05:6/1
Asd002a_ome05:2/2 Asd002a_ome05:9/1
Asd002a_ome05:2/3 Asd002a_ome05:1/1
Asd002a_ome05:2/3 Asd002a_ome05:1/2
Asd002a_ome05:2/3 Asd002a_ome05:1/3
Asd002a_ome05:2/3 Asd002a_ome05:1/4
Asd002a_ome05:2/3 Asd002a_ome05:10/1
Asd002a_ome05:2/3 Asd002a_ome05:2/1
Asd002a_ome05:2/3 Asd002a_ome05:2/2
Asd002a_ome05:2/3 Asd002a_ome05:2/4
Asd002a_ome05:2/3 Asd002a_ome05:3/2
Asd002a_ome05:2/3 Asd002a_ome05:3/3
Asd002a_ome05:2/3 Asd002a_ome05:3/4
Asd002a_ome05:2/3 Asd002a_ome05:5/1
Asd002a_ome05:2/3 Asd002a_ome05:6/1
Asd002a_ome05:2/3 Asd002a_ome05:9/1
Asd002a_ome05:2/4 Asd002a_ome05:1/1
Asd002a_ome05:2/4 Asd002a_ome05:1/2
Asd002a_ome05:2/4 Asd002a_ome05:1/3
Asd002a_ome05:2/4 Asd002a_ome05:1/4
Asd002a_ome05:2/4 Asd002a_ome05:10/1
Asd002a_ome05:2/4 Asd002a_ome05:2/1
Asd002a_ome05:2/4 Asd002a_ome05:2/2
Asd002a_ome05:2/4 Asd002a_ome05:2/3
Asd002a_ome05:2/4 Asd002a_ome05:3/2
Asd002a_ome05:2/4 Asd002a_ome05:3/3
Asd002a_ome05:2/4 Asd002a_ome05:3/4
Asd002a_ome05:2/4 Asd002a_ome05:5/1
Asd002a_ome05:2/4 Asd002a_ome05:6/1
Asd002a_ome05:2/4 Asd002a_ome05:9/1
Asd002a_ome05:3/2 Asd002a_ome05:1/1
Asd002a_ome05:3/2 Asd002a_ome05:1/2
Asd002a_ome05:3/2 Asd002a_ome05:1/3
Asd002a_ome05:3/2 Asd002a_ome05:1/4
Asd002a_ome05:3/2 Asd002a_ome05:10/1
Asd002a_ome05:3/2 Asd002a_ome05:2/1
Asd002a_ome05:3/2 Asd002a_ome05:2/2
Asd002a_ome05:3/2 Asd002a_ome05:2/3
Asd002a_ome05:3/2 Asd002a_ome05:2/4
Asd002a_ome05:3/2 Asd002a_ome05:3/3
Asd002a_ome05:3/2 Asd002a_ome05:3/4
Asd002a_ome05:3/2 Asd002a_ome05:5/1
Asd002a_ome05:3/2 Asd002a_ome05:6/1
Asd002a_ome05:3/2 Asd002a_ome05:9/1
Asd002a_ome05:3/3 Asd002a_ome05:1/1
Asd002a_ome05:3/3 Asd002a_ome05:1/2
Asd002a_ome05:3/3 Asd002a_ome05:1/3
Asd002a_ome05:3/3 Asd002a_ome05:1/4
Asd002a_ome05:3/3 Asd002a_ome05:10/1
Asd002a_ome05:3/3 Asd002a_ome05:2/1
Asd002a_ome05:3/3 Asd002a_ome05:2/2
Asd002a_ome05:3/3 Asd002a_ome05:2/3
Asd002a_ome05:3/3 Asd002a_ome05:2/4
Asd002a_ome05:3/3 Asd002a_ome05:3/2
Asd002a_ome05:3/3 Asd002a_ome05:3/4
Asd002a_ome05:3/3 Asd002a_ome05:5/1
Asd002a_ome05:3/3 Asd002a_ome05:6/1
Asd002a_ome05:3/3 Asd002a_ome05:9/1
Asd002a_ome05:3/4 Asd002a_ome05:1/1
Asd002a_ome05:3/4 Asd002a_ome05:1/2
Asd002a_ome05:3/4 Asd002a_ome05:1/3
Asd002a_ome05:3/4 Asd002a_ome05:1/4
Asd002a_ome05:3/4 Asd002a_ome05:10/1
Asd002a_ome05:3/4 Asd002a_ome05:2/1
Asd002a_ome05:3/4 Asd002a_ome05:2/2
Asd002a_ome05:3/4 Asd002a_ome05:2/3
Asd002a_ome05:3/4 Asd002a_ome05:2/4
Asd002a_ome05:3/4 Asd002a_ome05:3/2
Asd002a_ome05:3/4 Asd002a_ome05:3/3
Asd002a_ome05:3/4 Asd002a_ome05:5/1
Asd002a_ome05:3/4 Asd002a_ome05:6/1
Asd002a_ome05:3/4 Asd002a_ome05:9/1
Asd002a_ome05:5/1 Asd002a_ome05:1/1
Asd002a_ome05:5/1 Asd002a_ome05:1/2
Asd002a_ome05:5/1 Asd002a_ome05:1/3
Asd002a_ome05:5/1 Asd002a_ome05:1/4
Asd002a_ome05:5/1 Asd002a_ome05:10/1
Asd002a_ome05:5/1 Asd002a_ome05:2/1
Asd002a_ome05:5/1 Asd002a_ome05:2/2
Asd002a_ome05:5/1 Asd002a_ome05:2/3
Asd002a_ome05:5/1 Asd002a_ome05:2/4
Asd002a_ome05:5/1 Asd002a_ome05:3/2
Asd002a_ome05:5/1 Asd002a_ome05:3/3
Asd002a_ome05:5/1 Asd002a_ome05:3/4
Asd002a_ome05:5/1 Asd002a_ome05:6/1
Asd002a_ome05:5/1 Asd002a_ome05:9/1
Asd002a_ome05:5/1 Ht001a_ome01:9/1
Asd002a_ome05:6/1 Asd002a_ome05:1/1
Asd002a_ome05:6/1 Asd002a_ome05:1/2
Asd002a_ome05:6/1 Asd002a_ome05:1/3
Asd002a_ome05:6/1 Asd002a_ome05:1/4
Asd002a_ome05:6/1 Asd002a_ome05:10/1
Asd002a_ome05:6/1 Asd002a_ome05:2/1
Asd002a_ome05:6/1 Asd002a_ome05:2/2
Asd002a_ome05:6/1 Asd002a_ome05:2/3
Asd002a_ome05:6/1 Asd002a_ome05:2/4
Asd002a_ome05:6/1 Asd002a_ome05:3/2
Asd002a_ome05:6/1 Asd002a_ome05:3/3
Asd002a_ome05:6/1 Asd002a_ome05:3/4
Asd002a_ome05:6/1 Asd002a_ome05:5/1
Asd002a_ome05:6/1 Asd002a_ome05:9/1
Asd002a_ome05:6/1 Tb001a_ome01:9/1
Asd002a_ome05:9/1 Asd002a_ome05:1/1
Asd002a_ome05:9/1 Asd002a_ome05:1/2
Asd002a_ome05:9/1 Asd002a_ome05:1/3
Asd002a_ome05:9/1 Asd002a_ome05:1/4
Asd002a_ome05:9/1 Asd002a_ome05:10/1
Asd002a_ome05:9/1 Asd002a_ome05:2/1
Asd002a_ome05:9/1 Asd002a_ome05:2/2
Asd002a_ome05:9/1 Asd002a_ome05:2/3
Asd002a_ome05:9/1 Asd002a_ome05:2/4
Asd002a_ome05:9/1 Asd002a_ome05:3/2
Asd002a_ome05:9/1 Asd002a_ome05:3/3
Asd002a_ome05:9/1 Asd002a_ome05:3/4
Asd002a_ome05:9/1 Asd002a_ome05:5/1
Asd002a_ome05:9/1 Asd002a_ome05:6/1
Asd002a_ome05:9/1 Ehv001a_ome01:9/1
Asd002a_ome06:1/1 Asd002a_ome06:1/2
Asd002a_ome06:1/1 Asd002a_ome06:1/3
Asd002a_ome06:1/1 Asd002a_ome06:1/4
Asd002a_ome06:1/1 Asd002a_ome06:10/1
Asd002a_ome06:1/1 Asd002a_ome06:2/2
Asd002a_ome06:1/1 Asd002a_ome06:3/1
Asd002a_ome06:1/1 Asd002a_ome06:3/2
Asd002a_ome06:1/1 Asd002a_ome06:3/3
Asd002a_ome06:1/1 Asd002a_ome06:5/1
Asd002a_ome06:1/1 Asd002a_ome06:6/1
Asd002a_ome06:1/1 Asd002a_ome06:9/1
Asd002a_ome06:1/2 Asd002a_ome06:1/1
Asd002a_ome06:1/2 Asd002a_ome06:1/3
Asd002a_ome06:1/2 Asd002a_ome06:1/4
Asd002a_ome06:1/2 Asd002a_ome06:10/1
Asd002a_ome06:1/2 Asd002a_ome06:2/2
Asd002a_ome06:1/2 Asd002a_ome06:3/1
Asd002a_ome06:1/2 Asd002a_ome06:3/2
Asd002a_ome06:1/2 Asd002a_ome06:3/3
Asd002a_ome06:1/2 Asd002a_ome06:5/1
Asd002a_ome06:1/2 Asd002a_ome06:6/1
Asd002a_ome06:1/2 Asd002a_ome06:9/1
Asd002a_ome06:1/3 Asd002a_ome06:1/1
Asd002a_ome06:1/3 Asd002a_ome06:1/2
Asd002a_ome06:1/3 Asd002a_ome06:1/4
Asd002a_ome06:1/3 Asd002a_ome06:10/1
Asd002a_ome06:1/3 Asd002a_ome06:2/2
Asd002a_ome06:1/3 Asd002a_ome06:3/1
Asd002a_ome06:1/3 Asd002a_ome06:3/2
Asd002a_ome06:1/3 Asd002a_ome06:3/3
Asd002a_ome06:1/3 Asd002a_ome06:5/1
Asd002a_ome06:1/3 Asd002a_ome06:6/1
Asd002a_ome06:1/3 Asd002a_ome06:9/1
Asd002a_ome06:1/4 Asd002a_ome06:1/1
Asd002a_ome06:1/4 Asd002a_ome06:1/2
Asd002a_ome06:1/4 Asd002a_ome06:1/3
Asd002a_ome06:1/4 Asd002a_ome06:10/1
Asd002a_ome06:1/4 Asd002a_ome06:2/2
Asd002a_ome06:1/4 Asd002a_ome06:3/1
Asd002a_ome06:1/4 Asd002a_ome06:3/2
Asd002a_ome06:1/4 Asd002a_ome06:3/3
Asd002a_ome06:1/4 Asd002a_ome06:5/1
Asd002a_ome06:1/4 Asd002a_ome06:6/1
Asd002a_ome06:1/4 Asd002a_ome06:9/1
Asd002a_ome06:10/1 Asd002a_ome02:6/1
Asd002a_ome06:10/1 Asd002a_ome06:1/1
Asd002a_ome06:10/1 Asd002a_ome06:1/2
Asd002a_ome06:10/1 Asd002a_ome06:1/3
Asd002a_ome06:10/1 Asd002a_ome06:1/4
Asd002a_ome06:10/1 Asd002a_ome06:2/2
Asd002a_ome06:10/1 Asd002a_ome06:3/1
Asd002a_ome06:10/1 Asd002a_ome06:3/2
Asd002a_ome06:10/1 Asd002a_ome06:3/3
Asd002a_ome06:10/1 Asd002a_ome06:5/1
Asd002a_ome06:10/1 Asd002a_ome06:6/1
Asd002a_ome06:10/1 Asd002a_ome06:9/1
Asd002a_ome06:2/2 Asd002a_ome06:1/1
Asd002a_ome06:2/2 Asd002a_ome06:1/2
Asd002a_ome06:2/2 Asd002a_ome06:1/3
Asd002a_ome06:2/2 Asd002a_ome06:1/4
Asd002a_ome06:2/2 Asd002a_ome06:10/1
Asd002a_ome06:2/2 Asd002a_ome06:3/1
Asd002a_ome06:2/2 Asd002a_ome06:3/2
Asd002a_ome06:2/2 Asd002a_ome06:3/3
Asd002a_ome06:2/2 Asd002a_ome06:5/1
Asd002a_ome06:2/2 Asd002a_ome06:6/1
Asd002a_ome06:2/2 Asd002a_ome06:9/1
Asd002a_ome06:3/1 Asd002a_ome06:1/1
Asd002a_ome06:3/1 Asd002a_ome06:1/2
Asd002a_ome06:3/1 Asd002a_ome06:1/3
Asd002a_ome06:3/1 Asd002a_ome06:1/4
Asd002a_ome06:3/1 Asd002a_ome06:10/1
Asd002a_ome06:3/1 Asd002a_ome06:2/2
Asd002a_ome06:3/1 Asd002a_ome06:3/2
Asd002a_ome06:3/1 Asd002a_ome06:3/3
Asd002a_ome06:3/1 Asd002a_ome06:5/1
Asd002a_ome06:3/1 Asd002a_ome06:6/1
Asd002a_ome06:3/1 Asd002a_ome06:9/1
Asd002a_ome06:3/2 Asd002a_ome06:1/1
Asd002a_ome06:3/2 Asd002a_ome06:1/2
Asd002a_ome06:3/2 Asd002a_ome06:1/3
Asd002a_ome06:3/2 Asd002a_ome06:1/4
Asd002a_ome06:3/2 Asd002a_ome06:10/1
Asd002a_ome06:3/2 Asd002a_ome06:2/2
Asd002a_ome06:3/2 Asd002a_ome06:3/1
Asd002a_ome06:3/2 Asd002a_ome06:3/3
Asd002a_ome06:3/2 Asd002a_ome06:5/1
Asd002a_ome06:3/2 Asd002a_ome06:6/1
Asd002a_ome06:3/2 Asd002a_ome06:9/1
Asd002a_ome06:3/3 Asd002a_ome06:1/1
Asd002a_ome06:3/3 Asd002a_ome06:1/2
Asd002a_ome06:3/3 Asd002a_ome06:1/3
Asd002a_ome06:3/3 Asd002a_ome06:1/4
Asd002a_ome06:3/3 Asd002a_ome06:10/1
Asd002a_ome06:3/3 Asd002a_ome06:2/2
Asd002a_ome06:3/3 Asd002a_ome06:3/1
Asd002a_ome06:3/3 Asd002a_ome06:3/2
Asd002a_ome06:3/3 Asd002a_ome06:5/1
Asd002a_ome06:3/3 Asd002a_ome06:6/1
Asd002a_ome06:3/3 Asd002a_ome06:9/1
Asd002a_ome06:5/1 Asd002a_ome06:1/1
Asd002a_ome06:5/1 Asd002a_ome06:1/2
Asd002a_ome06:5/1 Asd002a_ome06:1/3
Asd002a_ome06:5/1 Asd002a_ome06:1/4
Asd002a_ome06:5/1 Asd002a_ome06:10/1
Asd002a_ome06:5/1 Asd002a_ome06:2/2
Asd002a_ome06:5/1 Asd002a_ome06:3/1
Asd002a_ome06:5/1 Asd002a_ome06:3/2
Asd002a_ome06:5/1 Asd002a_ome06:3/3
Asd002a_ome06:5/1 Asd002a_ome06:6/1
Asd002a_ome06:5/1 Asd002a_ome06:9/1
Asd002a_ome06:5/1 Wg001a_ome01:9/1
Asd002a_ome06:6/1 Asd002a_ome06:1/1
Asd002a_ome06:6/1 Asd002a_ome06:1/2
Asd002a_ome06:6/1 Asd002a_ome06:1/3
Asd002a_ome06:6/1 Asd002a_ome06:1/4
Asd002a_ome06:6/1 Asd002a_ome06:10/1
Asd002a_ome06:6/1 Asd002a_ome06:2/2
Asd002a_ome06:6/1 Asd002a_ome06:3/1
Asd002a_ome06:6/1 Asd002a_ome06:3/2
Asd002a_ome06:6/1 Asd002a_ome06:3/3
Asd002a_ome06:6/1 Asd002a_ome06:5/1
Asd002a_ome06:6/1 Asd002a_ome06:9/1
Asd002a_ome06:6/1 Nm001a_ome01:10/1
Asd002a_ome06:9/1 Asd002a_ome06:1/1
Asd002a_ome06:9/1 Asd002a_ome06:1/2
Asd002a_ome06:9/1 Asd002a_ome06:1/3
Asd002a_ome06:9/1 Asd002a_ome06:1/4
Asd002a_ome06:9/1 Asd002a_ome06:10/1
Asd002a_ome06:9/1 Asd002a_ome06:2/2
Asd002a_ome06:9/1 Asd002a_ome06:3/1
Asd002a_ome06:9/1 Asd002a_ome06:3/2
Asd002a_ome06:9/1 Asd002a_ome06:3/3
Asd002a_ome06:9/1 Asd002a_ome06:5/1
Asd002a_ome06:9/1 Asd002a_ome06:6/1
Asd002a_ome06:9/1 Es001a_ome01:9/1
Asd002a_ome07:1/1 Asd002a_ome07:1/2
Asd002a_ome07:1/1 Asd002a_ome07:1/3
Asd002a_ome07:1/1 Asd002a_ome07:1/4
Asd002a_ome07:1/1 Asd002a_ome07:10/1
Asd002a_ome07:1/1 Asd002a_ome07:2/1
Asd002a_ome07:1/1 Asd002a_ome07:2/2
Asd002a_ome07:1/1 Asd002a_ome07:2/3
Asd002a_ome07:1/1 Asd002a_ome07:2/4
Asd002a_ome07:1/1 Asd002a_ome07:3/1
Asd002a_ome07:1/1 Asd002a_ome07:3/2
Asd002a_ome07:1/1 Asd002a_ome07:5/1
Asd002a_ome07:1/1 Asd002a_ome07:6/1
Asd002a_ome07:1/1 Asd002a_ome07:9/1
Asd002a_ome07:1/2 Asd002a_ome07:1/1
Asd002a_ome07:1/2 Asd002a_ome07:1/3
Asd002a_ome07:1/2 Asd002a_ome07:1/4
Asd002a_ome07:1/2 Asd002a_ome07:10/1
Asd002a_ome07:1/2 Asd002a_ome07:2/1
Asd002a_ome07:1/2 Asd002a_ome07:2/2
Asd002a_ome07:1/2 Asd002a_ome07:2/3
Asd002a_ome07:1/2 Asd002a_ome07:2/4
Asd002a_ome07:1/2 Asd002a_ome07:3/1
Asd002a_ome07:1/2 Asd002a_ome07:3/2
Asd002a_ome07:1/2 Asd002a_ome07:5/1
Asd002a_ome07:1/2 Asd002a_ome07:6/1
Asd002a_ome07:1/2 Asd002a_ome07:9/1
Asd002a_ome07:1/3 Asd002a_ome07:1/1
Asd002a_ome07:1/3 Asd002a_ome07:1/2
Asd002a_ome07:1/3 Asd002a_ome07:1/4
Asd002a_ome07:1/3 Asd002a_ome07:10/1
Asd002a_ome07:1/3 Asd002a_ome07:2/1
Asd002a_ome07:1/3 Asd002a_ome07:2/2
Asd002a_ome07:1/3 Asd002a_ome07:2/3
Asd002a_ome07:1/3 Asd002a_ome07:2/4
Asd002a_ome07:1/3 Asd002a_ome07:3/1
Asd002a_ome07:1/3 Asd002a_ome07:3/2
Asd002a_ome07:1/3 Asd002a_ome07:5/1
Asd002a_ome07:1/3 Asd002a_ome07:6/1
Asd002a_ome07:1/3 Asd002a_ome07:9/1
Asd002a_ome07:1/4 Asd002a_ome07:1/1
Asd002a_ome07:1/4 Asd002a_ome07:1/2
Asd002a_ome07:1/4 Asd002a_ome07:1/3
Asd002a_ome07:1/4 Asd002a_ome07:10/1
Asd002a_ome07:1/4 Asd002a_ome07:2/1
Asd002a_ome07:1/4 Asd002a_ome07:2/2
Asd002a_ome07:1/4 Asd002a_ome07:2/3
Asd002a_ome07:1/4 Asd002a_ome07:2/4
Asd002a_ome07:1/4 Asd002a_ome07:3/1
Asd002a_ome07:1/4 Asd002a_ome07:3/2
Asd002a_ome07:1/4 Asd002a_ome07:5/1
Asd002a_ome07:1/4 Asd002a_ome07:6/1
Asd002a_ome07:1/4 Asd002a_ome07:9/1
Asd002a_ome07:10/1 Asd002a_ome02:5/1
Asd002a_ome07:10/1 Asd002a_ome07:1/1
Asd002a_ome07:10/1 Asd002a_ome07:1/2
Asd002a_ome07:10/1 Asd002a_ome07:1/3
Asd002a_ome07:10/1 Asd002a_ome07:1/4
Asd002a_ome07:10/1 Asd002a_ome07:2/1
Asd002a_ome07:10/1 Asd002a_ome07:2/2
Asd002a_ome07:10/1 Asd002a_ome07:2/3
Asd002a_ome07:10/1 Asd002a_ome07:2/4
Asd002a_ome07:10/1 Asd002a_ome07:3/1
Asd002a_ome07:10/1 Asd002a_ome07:3/2
Asd002a_ome07:10/1 Asd002a_ome07:5/1
Asd002a_ome07:10/1 Asd002a_ome07:6/1
Asd002a_ome07:10/1 Asd002a_ome07:9/1
Asd002a_ome07:2/1 Asd002a_ome07:1/1
Asd002a_ome07:2/1 Asd002a_ome07:1/2
Asd002a_ome07:2/1 Asd002a_ome07:1/3
Asd002a_ome07:2/1 Asd002a_ome07:1/4
Asd002a_ome07:2/1 Asd002a_ome07:10/1
Asd002a_ome07:2/1 Asd002a_ome07:2/2
Asd002a_ome07:2/1 Asd002a_ome07:2/3
Asd002a_ome07:2/1 Asd002a_ome07:2/4
Asd002a_ome07:2/1 Asd002a_ome07:3/1
Asd002a_ome07:2/1 Asd002a_ome07:3/2
Asd002a_ome07:2/1 Asd002a_ome07:5/1
Asd002a_ome07:2/1 Asd002a_ome07:6/1
Asd002a_ome07:2/1 Asd002a_ome07:9/1
Asd002a_ome07:2/2 Asd002a_ome07:1/1
Asd002a_ome07:2/2 Asd002a_ome07:1/2
Asd002a_ome07:2/2 Asd002a_ome07:1/3
Asd002a_ome07:2/2 Asd002a_ome07:1/4
Asd002a_ome07:2/2 Asd002a_ome07:10/1
Asd002a_ome07:2/2 Asd002a_ome07:2/1
Asd002a_ome07:2/2 Asd002a_ome07:2/3
Asd002a_ome07:2/2 Asd002a_ome07:2/4
Asd002a_ome07:2/2 Asd002a_ome07:3/1
Asd002a_ome07:2/2 Asd002a_ome07:3/2
Asd002a_ome07:2/2 Asd002a_ome07:5/1
Asd002a_ome07:2/2 Asd002a_ome07:6/1
Asd002a_ome07:2/2 Asd002a_ome07:9/1
Asd002a_ome07:2/3 Asd002a_ome07:1/1
Asd002a_ome07:2/3 Asd002a_ome07:1/2
Asd002a_ome07:2/3 Asd002a_ome07:1/3
Asd002a_ome07:2/3 Asd002a_ome07:1/4
Asd002a_ome07:2/3 Asd002a_ome07:10/1
Asd002a_ome07:2/3 Asd002a_ome07:2/1
Asd002a_ome07:2/3 Asd002a_ome07:2/2
Asd002a_ome07:2/3 Asd002a_ome07:2/4
Asd002a_ome07:2/3 Asd002a_ome07:3/1
Asd002a_ome07:2/3 Asd002a_ome07:3/2
Asd002a_ome07:2/3 Asd002a_ome07:5/1
Asd002a_ome07:2/3 Asd002a_ome07:6/1
Asd002a_ome07:2/3 Asd002a_ome07:9/1
Asd002a_ome07:2/4 Asd002a_ome07:1/1
Asd002a_ome07:2/4 Asd002a_ome07:1/2
Asd002a_ome07:2/4 Asd002a_ome07:1/3
Asd002a_ome07:2/4 Asd002a_ome07:1/4
Asd002a_ome07:2/4 Asd002a_ome07:10/1
Asd002a_ome07:2/4 Asd002a_ome07:2/1
Asd002a_ome07:2/4 Asd002a_ome07:2/2
Asd002a_ome07:2/4 Asd002a_ome07:2/3
Asd002a_ome07:2/4 Asd002a_ome07:3/1
Asd002a_ome07:2/4 Asd002a_ome07:3/2
Asd002a_ome07:2/4 Asd002a_ome07:5/1
Asd002a_ome07:2/4 Asd002a_ome07:6/1
Asd002a_ome07:2/4 Asd002a_ome07:9/1
Asd002a_ome07:3/1 Asd002a_ome07:1/1
Asd002a_ome07:3/1 Asd002a_ome07:1/2
Asd002a_ome07:3/1 Asd002a_ome07:1/3
Asd002a_ome07:3/1 Asd002a_ome07:1/4
Asd002a_ome07:3/1 Asd002a_ome07:10/1
Asd002a_ome07:3/1 Asd002a_ome07:2/1
Asd002a_ome07:3/1 Asd002a_ome07:2/2
Asd002a_ome07:3/1 Asd002a_ome07:2/3
Asd002a_ome07:3/1 Asd002a_ome07:2/4
Asd002a_ome07:3/1 Asd002a_ome07:3/2
Asd002a_ome07:3/1 Asd002a_ome07:5/1
Asd002a_ome07:3/1 Asd002a_ome07:6/1
Asd002a_ome07:3/1 Asd002a_ome07:9/1
Asd002a_ome07:3/2 Asd002a_ome07:1/1
Asd002a_ome07:3/2 Asd002a_ome07:1/2
Asd002a_ome07:3/2 Asd002a_ome07:1/3
Asd002a_ome07:3/2 Asd002a_ome07:1/4
Asd002a_ome07:3/2 Asd002a_ome07:10/1
Asd002a_ome07:3/2 Asd002a_ome07:2/1
Asd002a_ome07:3/2 Asd002a_ome07:2/2
Asd002a_ome07:3/2 Asd002a_ome07:2/3
Asd002a_ome07:3/2 Asd002a_ome07:2/4
Asd002a_ome07:3/2 Asd002a_ome07:3/1
Asd002a_ome07:3/2 Asd002a_ome07:5/1
Asd002a_ome07:3/2 Asd002a_ome07:6/1
Asd002a_ome07:3/2 Asd002a_ome07:9/1
Asd002a_ome07:5/1 Asd002a_ome07:1/1
Asd002a_ome07:5/1 Asd002a_ome07:1/2
Asd002a_ome07:5/1 Asd002a_ome07:1/3
Asd002a_ome07:5/1 Asd002a_ome07:1/4
Asd002a_ome07:5/1 Asd002a_ome07:10/1
Asd002a_ome07:5/1 Asd002a_ome07:2/1
Asd002a_ome07:5/1 Asd002a_ome07:2/2
Asd002a_ome07:5/1 Asd002a_ome07:2/3
Asd002a_ome07:5/1 Asd002a_ome07:2/4
Asd002a_ome07:5/1 Asd002a_ome07:3/1
Asd002a_ome07:5/1 Asd002a_ome07:3/2
Asd002a_ome07:5/1 Asd002a_ome07:6/1
Asd002a_ome07:5/1 Asd002a_ome07:9/1
Asd002a_ome07:5/1 Gn001a_ome01:9/1
Asd002a_ome07:6/1 Asd002a_ome07:1/1
Asd002a_ome07:6/1 Asd002a_ome07:1/2
Asd002a_ome07:6/1 Asd002a_ome07:1/3
Asd002a_ome07:6/1 Asd002a_ome07:1/4
Asd002a_ome07:6/1 Asd002a_ome07:10/1
Asd002a_ome07:6/1 Asd002a_ome07:2/1
Asd002a_ome07:6/1 Asd002a_ome07:2/2
Asd002a_ome07:6/1 Asd002a_ome07:2/3
Asd002a_ome07:6/1 Asd002a_ome07:2/4
Asd002a_ome07:6/1 Asd002a_ome07:3/1
Asd002a_ome07:6/1 Asd002a_ome07:3/2
Asd002a_ome07:6/1 Asd002a_ome07:5/1
Asd002a_ome07:6/1 Asd002a_ome07:9/1
Asd002a_ome07:6/1 Dgl001a_ome01:9/1
Asd002a_ome07:9/1 Asd002a_ome07:1/1
Asd002a_ome07:9/1 Asd002a_ome07:1/2
Asd002a_ome07:9/1 Asd002a_ome07:1/3
Asd002a_ome07:9/1 Asd002a_ome07:1/4
Asd002a_ome07:9/1 Asd002a_ome07:10/1
Asd002a_ome07:9/1 Asd002a_ome07:2/1
Asd002a_ome07:9/1 Asd002a_ome07:2/2
Asd002a_ome07:9/1 Asd002a_ome07:2/3
Asd002a_ome07:9/1 Asd002a_ome07:2/4
Asd002a_ome07:9/1 Asd002a_ome07:3/1
Asd002a_ome07:9/1 Asd002a_ome07:3/2
Asd002a_ome07:9/1 Asd002a_ome07:5/1
Asd002a_ome07:9/1 Asd002a_ome07:6/1
Asd002a_ome07:9/1 Asd003a_ome01:9/1
Asd003a_ome01:1/1 Asd003a_ome01:1/2
Asd003a_ome01:1/1 Asd003a_ome01:1/3
Asd003a_ome01:1/1 Asd003a_ome01:1/4
Asd003a_ome01:1/1 Asd003a_ome01:2/1
Asd003a_ome01:1/1 Asd003a_ome01:2/2
Asd003a_ome01:1/1 Asd003a_ome01:2/3
Asd003a_ome01:1/1 Asd003a_ome01:2/4
Asd003a_ome01:1/1 Asd003a_ome01:6/1
Asd003a_ome01:1/1 Asd003a_ome01:9/1
Asd003a_ome01:1/2 Asd003a_ome01:1/1
Asd003a_ome01:1/2 Asd003a_ome01:1/3
Asd003a_ome01:1/2 Asd003a_ome01:1/4
Asd003a_ome01:1/2 Asd003a_ome01:2/1
Asd003a_ome01:1/2 Asd003a_ome01:2/2
Asd003a_ome01:1/2 Asd003a_ome01:2/3
Asd003a_ome01:1/2 Asd003a_ome01:2/4
Asd003a_ome01:1/2 Asd003a_ome01:6/1
Asd003a_ome01:1/2 Asd003a_ome01:9/1
Asd003a_ome01:1/3 Asd003a_ome01:1/1
Asd003a_ome01:1/3 Asd003a_ome01:1/2
Asd003a_ome01:1/3 Asd003a_ome01:1/4
Asd003a_ome01:1/3 Asd003a_ome01:2/1
Asd003a_ome01:1/3 Asd003a_ome01:2/2
Asd003a_ome01:1/3 Asd003a_ome01:2/3
Asd003a_ome01:1/3 Asd003a_ome01:2/4
Asd003a_ome01:1/3 Asd003a_ome01:6/1
Asd003a_ome01:1/3 Asd003a_ome01:9/1
Asd003a_ome01:1/4 Asd003a_ome01:1/1
Asd003a_ome01:1/4 Asd003a_ome01:1/2
Asd003a_ome01:1/4 Asd003a_ome01:1/3
Asd003a_ome01:1/4 Asd003a_ome01:2/1
Asd003a_ome01:1/4 Asd003a_ome01:2/2
Asd003a_ome01:1/4 Asd003a_ome01:2/3
Asd003a_ome01:1/4 Asd003a_ome01:2/4
Asd003a_ome01:1/4 Asd003a_ome01:6/1
Asd003a_ome01:1/4 Asd003a_ome01:9/1
Asd003a_ome01:2/1 Asd003a_ome01:1/1
Asd003a_ome01:2/1 Asd003a_ome01:1/2
Asd003a_ome01:2/1 Asd003a_ome01:1/3
Asd003a_ome01:2/1 Asd003a_ome01:1/4
Asd003a_ome01:2/1 Asd003a_ome01:2/2
Asd003a_ome01:2/1 Asd003a_ome01:2/3
Asd003a_ome01:2/1 Asd003a_ome01:2/4
Asd003a_ome01:2/1 Asd003a_ome01:6/1
Asd003a_ome01:2/1 Asd003a_ome01:9/1
Asd003a_ome01:2/2 Asd003a_ome01:1/1
Asd003a_ome01:2/2 Asd003a_ome01:1/2
Asd003a_ome01:2/2 Asd003a_ome01:1/3
Asd003a_ome01:2/2 Asd003a_ome01:1/4
Asd003a_ome01:2/2 Asd003a_ome01:2/1
Asd003a_ome01:2/2 Asd003a_ome01:2/3
Asd003a_ome01:2/2 Asd003a_ome01:2/4
Asd003a_ome01:2/2 Asd003a_ome01:6/1
Asd003a_ome01:2/2 Asd003a_ome01:9/1
Asd003a_ome01:2/3 Asd003a_ome01:1/1
Asd003a_ome01:2/3 Asd003a_ome01:1/2
Asd003a_ome01:2/3 Asd003a_ome01:1/3
Asd003a_ome01:2/3 Asd003a_ome01:1/4
Asd003a_ome01:2/3 Asd003a_ome01:2/1
Asd003a_ome01:2/3 Asd003a_ome01:2/2
Asd003a_ome01:2/3 Asd003a_ome01:2/4
Asd003a_ome01:2/3 Asd003a_ome01:6/1
Asd003a_ome01:2/3 Asd003a_ome01:9/1
Asd003a_ome01:2/4 Asd003a_ome01:1/1
Asd003a_ome01:2/4 Asd003a_ome01:1/2
Asd003a_ome01:2/4 Asd003a_ome01:1/3
Asd003a_ome01:2/4 Asd003a_ome01:1/4
Asd003a_ome01:2/4 Asd003a_ome01:2/1
Asd003a_ome01:2/4 Asd003a_ome01:2/2
Asd003a_ome01:2/4 Asd003a_ome01:2/3
Asd003a_ome01:2/4 Asd003a_ome01:6/1
Asd003a_ome01:2/4 Asd003a_ome01:9/1
Asd003a_ome01:6/1 Asd001a_ome07:9/1
Asd003a_ome01:6/1 Asd003a_ome01:1/1
Asd003a_ome01:6/1 Asd003a_ome01:1/2
Asd003a_ome01:6/1 Asd003a_ome01:1/3
Asd003a_ome01:6/1 Asd003a_ome01:1/4
Asd003a_ome01:6/1 Asd003a_ome01:2/1
Asd003a_ome01:6/1 Asd003a_ome01:2/2
Asd003a_ome01:6/1 Asd003a_ome01:2/3
Asd003a_ome01:6/1 Asd003a_ome01:2/4
Asd003a_ome01:6/1 Asd003a_ome01:9/1
Asd003a_ome01:9/1 Asd002a_ome07:9/1
Asd003a_ome01:9/1 Asd003a_ome01:1/1
Asd003a_ome01:9/1 Asd003a_ome01:1/2
Asd003a_ome01:9/1 Asd003a_ome01:1/3
Asd003a_ome01:9/1 Asd003a_ome01:1/4
Asd003a_ome01:9/1 Asd003a_ome01:2/1
Asd003a_ome01:9/1 Asd003a_ome01:2/2
Asd003a_ome01:9/1 Asd003a_ome01:2/3
Asd003a_ome01:9/1 Asd003a_ome01:2/4
Asd003a_ome01:9/1 Asd003a_ome01:6/1
Asn001a_ome01:1/1 Asn001a_ome01:1/2
Asn001a_ome01:1/1 Asn001a_ome01:1/3
Asn001a_ome01:1/1 Asn001a_ome01:1/4
Asn001a_ome01:1/1 Asn001a_ome01:6/1
Asn001a_ome01:1/1 Asn001a_ome01:9/1
Asn001a_ome01:1/2 Asn001a_ome01:1/1
Asn001a_ome01:1/2 Asn001a_ome01:1/3
Asn001a_ome01:1/2 Asn001a_ome01:1/4
Asn001a_ome01:1/2 Asn001a_ome01:6/1
Asn001a_ome01:1/2 Asn001a_ome01:9/1
Asn001a_ome01:1/3 Asn001a_ome01:1/1
Asn001a_ome01:1/3 Asn001a_ome01:1/2
Asn001a_ome01:1/3 Asn001a_ome01:1/4
Asn001a_ome01:1/3 Asn001a_ome01:6/1
Asn001a_ome01:1/3 Asn001a_ome01:9/1
Asn001a_ome01:1/4 Asn001a_ome01:1/1
Asn001a_ome01:1/4 Asn001a_ome01:1/2
Asn001a_ome01:1/4 Asn001a_ome01:1/3
Asn001a_ome01:1/4 Asn001a_ome01:6/1
Asn001a_ome01:1/4 Asn001a_ome01:9/1
Asn001a_ome01:6/1 Asn001a_ome01:1/1
Asn001a_ome01:6/1 Asn001a_ome01:1/2
Asn001a_ome01:6/1 Asn001a_ome01:1/3
Asn001a_ome01:6/1 Asn001a_ome01:1/4
Asn001a_ome01:6/1 Asn001a_ome01:9/1
Asn001a_ome01:6/1 Hgv001a_ome01:9/1
Asn001a_ome01:9/1 Asn001a_ome01:1/1
Asn001a_ome01:9/1 Asn001a_ome01:1/2
Asn001a_ome01:9/1 Asn001a_ome01:1/3
Asn001a_ome01:9/1 Asn001a_ome01:1/4
Asn001a_ome01:9/1 Asn001a_ome01:6/1
Asn001a_ome01:9/1 Gn001a_ome01:2/2
Bd001a_ome01:1/1 Bd001a_ome01:1/2
Bd001a_ome01:1/1 Bd001a_ome01:1/3
Bd001a_ome01:1/1 Bd001a_ome01:1/4
Bd001a_ome01:1/1 Bd001a_ome01:10/1
Bd001a_ome01:1/1 Bd001a_ome01:13/1
Bd001a_ome01:1/1 Bd001a_ome01:13/2
Bd001a_ome01:1/1 Bd001a_ome01:13/3
Bd001a_ome01:1/1 Bd001a_ome01:13/4
Bd001a_ome01:1/1 Bd001a_ome01:14/1
Bd001a_ome01:1/1 Bd001a_ome01:14/3
Bd001a_ome01:1/1 Bd001a_ome01:14/4
Bd001a_ome01:1/1 Bd001a_ome01:2/1
Bd001a_ome01:1/1 Bd001a_ome01:2/2
Bd001a_ome01:1/1 Bd001a_ome01:2/3
Bd001a_ome01:1/1 Bd001a_ome01:2/4
Bd001a_ome01:1/1 Bd001a_ome01:3/1
Bd001a_ome01:1/1 Bd001a_ome01:3/2
Bd001a_ome01:1/1 Bd001a_ome01:3/3
Bd001a_ome01:1/1 Bd001a_ome01:3/4
Bd001a_ome01:1/1 Bd001a_ome01:5/1
Bd001a_ome01:1/1 Bd001a_ome01:6/1
Bd001a_ome01:1/1 Bd001a_ome01:6/2
Bd001a_ome01:1/2 Bd001a_ome01:1/1
Bd001a_ome01:1/2 Bd001a_ome01:1/3
Bd001a_ome01:1/2 Bd001a_ome01:1/4
Bd001a_ome01:1/2 Bd001a_ome01:10/1
Bd001a_ome01:1/2 Bd001a_ome01:13/1
Bd001a_ome01:1/2 Bd001a_ome01:13/2
Bd001a_ome01:1/2 Bd001a_ome01:13/3
Bd001a_ome01:1/2 Bd001a_ome01:13/4
Bd001a_ome01:1/2 Bd001a_ome01:14/1
Bd001a_ome01:1/2 Bd001a_ome01:14/3
Bd001a_ome01:1/2 Bd001a_ome01:14/4
Bd001a_ome01:1/2 Bd001a_ome01:2/1
Bd001a_ome01:1/2 Bd001a_ome01:2/2
Bd001a_ome01:1/2 Bd001a_ome01:2/3
Bd001a_ome01:1/2 Bd001a_ome01:2/4
Bd001a_ome01:1/2 Bd001a_ome01:3/1
Bd001a_ome01:1/2 Bd001a_ome01:3/2
Bd001a_ome01:1/2 Bd001a_ome01:3/3
Bd001a_ome01:1/2 Bd001a_ome01:3/4
Bd001a_ome01:1/2 Bd001a_ome01:5/1
Bd001a_ome01:1/2 Bd001a_ome01:6/1
Bd001a_ome01:1/2 Bd001a_ome01:6/2
Bd001a_ome01:1/3 Bd001a_ome01:1/1
Bd001a_ome01:1/3 Bd001a_ome01:1/2
Bd001a_ome01:1/3 Bd001a_ome01:1/4
Bd001a_ome01:1/3 Bd001a_ome01:10/1
Bd001a_ome01:1/3 Bd001a_ome01:13/1
Bd001a_ome01:1/3 Bd001a_ome01:13/2
Bd001a_ome01:1/3 Bd001a_ome01:13/3
Bd001a_ome01:1/3 Bd001a_ome01:13/4
Bd001a_ome01:1/3 Bd001a_ome01:14/1
Bd001a_ome01:1/3 Bd001a_ome01:14/3
Bd001a_ome01:1/3 Bd001a_ome01:14/4
Bd001a_ome01:1/3 Bd001a_ome01:2/1
Bd001a_ome01:1/3 Bd001a_ome01:2/2
Bd001a_ome01:1/3 Bd001a_ome01:2/3
Bd001a_ome01:1/3 Bd001a_ome01:2/4
Bd001a_ome01:1/3 Bd001a_ome01:3/1
Bd001a_ome01:1/3 Bd001a_ome01:3/2
Bd001a_ome01:1/3 Bd001a_ome01:3/3
Bd001a_ome01:1/3 Bd001a_ome01:3/4
Bd001a_ome01:1/3 Bd001a_ome01:5/1
Bd001a_ome01:1/3 Bd001a_ome01:6/1
Bd001a_ome01:1/3 Bd001a_ome01:6/2
Bd001a_ome01:1/4 Bd001a_ome01:1/1
Bd001a_ome01:1/4 Bd001a_ome01:1/2
Bd001a_ome01:1/4 Bd001a_ome01:1/3
Bd001a_ome01:1/4 Bd001a_ome01:10/1
Bd001a_ome01:1/4 Bd001a_ome01:13/1
Bd001a_ome01:1/4 Bd001a_ome01:13/2
Bd001a_ome01:1/4 Bd001a_ome01:13/3
Bd001a_ome01:1/4 Bd001a_ome01:13/4
Bd001a_ome01:1/4 Bd001a_ome01:14/1
Bd001a_ome01:1/4 Bd001a_ome01:14/3
Bd001a_ome01:1/4 Bd001a_ome01:14/4
Bd001a_ome01:1/4 Bd001a_ome01:2/1
Bd001a_ome01:1/4 Bd001a_ome01:2/2
Bd001a_ome01:1/4 Bd001a_ome01:2/3
Bd001a_ome01:1/4 Bd001a_ome01:2/4
Bd001a_ome01:1/4 Bd001a_ome01:3/1
Bd001a_ome01:1/4 Bd001a_ome01:3/2
Bd001a_ome01:1/4 Bd001a_ome01:3/3
Bd001a_ome01:1/4 Bd001a_ome01:3/4
Bd001a_ome01:1/4 Bd001a_ome01:5/1
Bd001a_ome01:1/4 Bd001a_ome01:6/1
Bd001a_ome01:1/4 Bd001a_ome01:6/2
Bd001a_ome01:10/1 Bd001a_ome01:1/1
Bd001a_ome01:10/1 Bd001a_ome01:1/2
Bd001a_ome01:10/1 Bd001a_ome01:1/3
Bd001a_ome01:10/1 Bd001a_ome01:1/4
Bd001a_ome01:10/1 Bd001a_ome01:13/1
Bd001a_ome01:10/1 Bd001a_ome01:13/2
Bd001a_ome01:10/1 Bd001a_ome01:13/3
Bd001a_ome01:10/1 Bd001a_ome01:13/4
Bd001a_ome01:10/1 Bd001a_ome01:14/1
Bd001a_ome01:10/1 Bd001a_ome01:14/3
Bd001a_ome01:10/1 Bd001a_ome01:14/4
Bd001a_ome01:10/1 Bd001a_ome01:2/1
Bd001a_ome01:10/1 Bd001a_ome01:2/2
Bd001a_ome01:10/1 Bd001a_ome01:2/3
Bd001a_ome01:10/1 Bd001a_ome01:2/4
Bd001a_ome01:10/1 Bd001a_ome01:3/1
Bd001a_ome01:10/1 Bd001a_ome01:3/2
Bd001a_ome01:10/1 Bd001a_ome01:3/3
Bd001a_ome01:10/1 Bd001a_ome01:3/4
Bd001a_ome01:10/1 Bd001a_ome01:5/1
Bd001a_ome01:10/1 Bd001a_ome01:6/1
Bd001a_ome01:10/1 Bd001a_ome01:6/2
Bd001a_ome01:10/1 Ddt001a_ome01:9/1
Bd001a_ome01:13/1 Bd001a_ome01:1/1
Bd001a_ome01:13/1 Bd001a_ome01:1/2
Bd001a_ome01:13/1 Bd001a_ome01:1/3
Bd001a_ome01:13/1 Bd001a_ome01:1/4
Bd001a_ome01:13/1 Bd001a_ome01:10/1
Bd001a_ome01:13/1 Bd001a_ome01:13/2
Bd001a_ome01:13/1 Bd001a_ome01:13/3
Bd001a_ome01:13/1 Bd001a_ome01:13/4
Bd001a_ome01:13/1 Bd001a_ome01:14/1
Bd001a_ome01:13/1 Bd001a_ome01:14/3
Bd001a_ome01:13/1 Bd001a_ome01:14/4
Bd001a_ome01:13/1 Bd001a_ome01:2/1
Bd001a_ome01:13/1 Bd001a_ome01:2/2
Bd001a_ome01:13/1 Bd001a_ome01:2/3
Bd001a_ome01:13/1 Bd001a_ome01:2/4
Bd001a_ome01:13/1 Bd001a_ome01:3/1
Bd001a_ome01:13/1 Bd001a_ome01:3/2
Bd001a_ome01:13/1 Bd001a_ome01:3/3
Bd001a_ome01:13/1 Bd001a_ome01:3/4
Bd001a_ome01:13/1 Bd001a_ome01:5/1
Bd001a_ome01:13/1 Bd001a_ome01:6/1
Bd001a_ome01:13/1 Bd001a_ome01:6/2
Bd001a_ome01:13/2 Bd001a_ome01:1/1
Bd001a_ome01:13/2 Bd001a_ome01:1/2
Bd001a_ome01:13/2 Bd001a_ome01:1/3
Bd001a_ome01:13/2 Bd001a_ome01:1/4
Bd001a_ome01:13/2 Bd001a_ome01:10/1
Bd001a_ome01:13/2 Bd001a_ome01:13/1
Bd001a_ome01:13/2 Bd001a_ome01:13/3
Bd001a_ome01:13/2 Bd001a_ome01:13/4
Bd001a_ome01:13/2 Bd001a_ome01:14/1
Bd001a_ome01:13/2 Bd001a_ome01:14/3
Bd001a_ome01:13/2 Bd001a_ome01:14/4
Bd001a_ome01:13/2 Bd001a_ome01:2/1
Bd001a_ome01:13/2 Bd001a_ome01:2/2
Bd001a_ome01:13/2 Bd001a_ome01:2/3
Bd001a_ome01:13/2 Bd001a_ome01:2/4
Bd001a_ome01:13/2 Bd001a_ome01:3/1
Bd001a_ome01:13/2 Bd001a_ome01:3/2
Bd001a_ome01:13/2 Bd001a_ome01:3/3
Bd001a_ome01:13/2 Bd001a_ome01:3/4
Bd001a_ome01:13/2 Bd001a_ome01:5/1
Bd001a_ome01:13/2 Bd001a_ome01:6/1
Bd001a_ome01:13/2 Bd001a_ome01:6/2
Bd001a_ome01:13/3 Bd001a_ome01:1/1
Bd001a_ome01:13/3 Bd001a_ome01:1/2
Bd001a_ome01:13/3 Bd001a_ome01:1/3
Bd001a_ome01:13/3 Bd001a_ome01:1/4
Bd001a_ome01:13/3 Bd001a_ome01:10/1
Bd001a_ome01:13/3 Bd001a_ome01:13/1
Bd001a_ome01:13/3 Bd001a_ome01:13/2
Bd001a_ome01:13/3 Bd001a_ome01:13/4
Bd001a_ome01:13/3 Bd001a_ome01:14/1
Bd001a_ome01:13/3 Bd001a_ome01:14/3
Bd001a_ome01:13/3 Bd001a_ome01:14/4
Bd001a_ome01:13/3 Bd001a_ome01:2/1
Bd001a_ome01:13/3 Bd001a_ome01:2/2
Bd001a_ome01:13/3 Bd001a_ome01:2/3
Bd001a_ome01:13/3 Bd001a_ome01:2/4
Bd001a_ome01:13/3 Bd001a_ome01:3/1
Bd001a_ome01:13/3 Bd001a_ome01:3/2
Bd001a_ome01:13/3 Bd001a_ome01:3/3
Bd001a_ome01:13/3 Bd001a_ome01:3/4
Bd001a_ome01:13/3 Bd001a_ome01:5/1
Bd001a_ome01:13/3 Bd001a_ome01:6/1
Bd001a_ome01:13/3 Bd001a_ome01:6/2
Bd001a_ome01:13/4 Bd001a_ome01:1/1
Bd001a_ome01:13/4 Bd001a_ome01:1/2
Bd001a_ome01:13/4 Bd001a_ome01:1/3
Bd001a_ome01:13/4 Bd001a_ome01:1/4
Bd001a_ome01:13/4 Bd001a_ome01:10/1
Bd001a_ome01:13/4 Bd001a_ome01:13/1
Bd001a_ome01:13/4 Bd001a_ome01:13/2
Bd001a_ome01:13/4 Bd001a_ome01:13/3
Bd001a_ome01:13/4 Bd001a_ome01:14/1
Bd001a_ome01:13/4 Bd001a_ome01:14/3
Bd001a_ome01:13/4 Bd001a_ome01:14/4
Bd001a_ome01:13/4 Bd001a_ome01:2/1
Bd001a_ome01:13/4 Bd001a_ome01:2/2
Bd001a_ome01:13/4 Bd001a_ome01:2/3
Bd001a_ome01:13/4 Bd001a_ome01:2/4
Bd001a_ome01:13/4 Bd001a_ome01:3/1
Bd001a_ome01:13/4 Bd001a_ome01:3/2
Bd001a_ome01:13/4 Bd001a_ome01:3/3
Bd001a_ome01:13/4 Bd001a_ome01:3/4
Bd001a_ome01:13/4 Bd001a_ome01:5/1
Bd001a_ome01:13/4 Bd001a_ome01:6/1
Bd001a_ome01:13/4 Bd001a_ome01:6/2
Bd001a_ome01:14/1 Bd001a_ome01:1/1
Bd001a_ome01:14/1 Bd001a_ome01:1/2
Bd001a_ome01:14/1 Bd001a_ome01:1/3
Bd001a_ome01:14/1 Bd001a_ome01:1/4
Bd001a_ome01:14/1 Bd001a_ome01:10/1
Bd001a_ome01:14/1 Bd001a_ome01:13/1
Bd001a_ome01:14/1 Bd001a_ome01:13/2
Bd001a_ome01:14/1 Bd001a_ome01:13/3
Bd001a_ome01:14/1 Bd001a_ome01:13/4
Bd001a_ome01:14/1 Bd001a_ome01:14/3
Bd001a_ome01:14/1 Bd001a_ome01:14/4
Bd001a_ome01:14/1 Bd001a_ome01:2/1
Bd001a_ome01:14/1 Bd001a_ome01:2/2
Bd001a_ome01:14/1 Bd001a_ome01:2/3
Bd001a_ome01:14/1 Bd001a_ome01:2/4
Bd001a_ome01:14/1 Bd001a_ome01:3/1
Bd001a_ome01:14/1 Bd001a_ome01:3/2
Bd001a_ome01:14/1 Bd001a_ome01:3/3
Bd001a_ome01:14/1 Bd001a_ome01:3/4
Bd001a_ome01:14/1 Bd001a_ome01:5/1
Bd001a_ome01:14/1 Bd001a_ome01:6/1
Bd001a_ome01:14/1 Bd001a_ome01:6/2
Bd001a_ome01:14/3 Bd001a_ome01:1/1
Bd001a_ome01:14/3 Bd001a_ome01:1/2
Bd001a_ome01:14/3 Bd001a_ome01:1/3
Bd001a_ome01:14/3 Bd001a_ome01:1/4
Bd001a_ome01:14/3 Bd001a_ome01:10/1
Bd001a_ome01:14/3 Bd001a_ome01:13/1
Bd001a_ome01:14/3 Bd001a_ome01:13/2
Bd001a_ome01:14/3 Bd001a_ome01:13/3
Bd001a_ome01:14/3 Bd001a_ome01:13/4
Bd001a_ome01:14/3 Bd001a_ome01:14/1
Bd001a_ome01:14/3 Bd001a_ome01:14/4
Bd001a_ome01:14/3 Bd001a_ome01:2/1
Bd001a_ome01:14/3 Bd001a_ome01:2/2
Bd001a_ome01:14/3 Bd001a_ome01:2/3
Bd001a_ome01:14/3 Bd001a_ome01:2/4
Bd001a_ome01:14/3 Bd001a_ome01:3/1
Bd001a_ome01:14/3 Bd001a_ome01:3/2
Bd001a_ome01:14/3 Bd001a_ome01:3/3
Bd001a_ome01:14/3 Bd001a_ome01:3/4
Bd001a_ome01:14/3 Bd001a_ome01:5/1
Bd001a_ome01:14/3 Bd001a_ome01:6/1
Bd001a_ome01:14/3 Bd001a_ome01:6/2
Bd001a_ome01:14/4 Bd001a_ome01:1/1
Bd001a_ome01:14/4 Bd001a_ome01:1/2
Bd001a_ome01:14/4 Bd001a_ome01:1/3
Bd001a_ome01:14/4 Bd001a_ome01:1/4
Bd001a_ome01:14/4 Bd001a_ome01:10/1
Bd001a_ome01:14/4 Bd001a_ome01:13/1
Bd001a_ome01:14/4 Bd001a_ome01:13/2
Bd001a_ome01:14/4 Bd001a_ome01:13/3
Bd001a_ome01:14/4 Bd001a_ome01:13/4
Bd001a_ome01:14/4 Bd001a_ome01:14/1
Bd001a_ome01:14/4 Bd001a_ome01:14/3
Bd001a_ome01:14/4 Bd001a_ome01:2/1
Bd001a_ome01:14/4 Bd001a_ome01:2/2
Bd001a_ome01:14/4 Bd001a_ome01:2/3
Bd001a_ome01:14/4 Bd001a_ome01:2/4
Bd001a_ome01:14/4 Bd001a_ome01:3/1
Bd001a_ome01:14/4 Bd001a_ome01:3/2
Bd001a_ome01:14/4 Bd001a_ome01:3/3
Bd001a_ome01:14/4 Bd001a_ome01:3/4
Bd001a_ome01:14/4 Bd001a_ome01:5/1
Bd001a_ome01:14/4 Bd001a_ome01:6/1
Bd001a_ome01:14/4 Bd001a_ome01:6/2
Bd001a_ome01:2/1 Bd001a_ome01:1/1
Bd001a_ome01:2/1 Bd001a_ome01:1/2
Bd001a_ome01:2/1 Bd001a_ome01:1/3
Bd001a_ome01:2/1 Bd001a_ome01:1/4
Bd001a_ome01:2/1 Bd001a_ome01:10/1
Bd001a_ome01:2/1 Bd001a_ome01:13/1
Bd001a_ome01:2/1 Bd001a_ome01:13/2
Bd001a_ome01:2/1 Bd001a_ome01:13/3
Bd001a_ome01:2/1 Bd001a_ome01:13/4
Bd001a_ome01:2/1 Bd001a_ome01:14/1
Bd001a_ome01:2/1 Bd001a_ome01:14/3
Bd001a_ome01:2/1 Bd001a_ome01:14/4
Bd001a_ome01:2/1 Bd001a_ome01:2/2
Bd001a_ome01:2/1 Bd001a_ome01:2/3
Bd001a_ome01:2/1 Bd001a_ome01:2/4
Bd001a_ome01:2/1 Bd001a_ome01:3/1
Bd001a_ome01:2/1 Bd001a_ome01:3/2
Bd001a_ome01:2/1 Bd001a_ome01:3/3
Bd001a_ome01:2/1 Bd001a_ome01:3/4
Bd001a_ome01:2/1 Bd001a_ome01:5/1
Bd001a_ome01:2/1 Bd001a_ome01:6/1
Bd001a_ome01:2/1 Bd001a_ome01:6/2
Bd001a_ome01:2/2 Bd001a_ome01:1/1
Bd001a_ome01:2/2 Bd001a_ome01:1/2
Bd001a_ome01:2/2 Bd001a_ome01:1/3
Bd001a_ome01:2/2 Bd001a_ome01:1/4
Bd001a_ome01:2/2 Bd001a_ome01:10/1
Bd001a_ome01:2/2 Bd001a_ome01:13/1
Bd001a_ome01:2/2 Bd001a_ome01:13/2
Bd001a_ome01:2/2 Bd001a_ome01:13/3
Bd001a_ome01:2/2 Bd001a_ome01:13/4
Bd001a_ome01:2/2 Bd001a_ome01:14/1
Bd001a_ome01:2/2 Bd001a_ome01:14/3
Bd001a_ome01:2/2 Bd001a_ome01:14/4
Bd001a_ome01:2/2 Bd001a_ome01:2/1
Bd001a_ome01:2/2 Bd001a_ome01:2/3
Bd001a_ome01:2/2 Bd001a_ome01:2/4
Bd001a_ome01:2/2 Bd001a_ome01:3/1
Bd001a_ome01:2/2 Bd001a_ome01:3/2
Bd001a_ome01:2/2 Bd001a_ome01:3/3
Bd001a_ome01:2/2 Bd001a_ome01:3/4
Bd001a_ome01:2/2 Bd001a_ome01:5/1
Bd001a_ome01:2/2 Bd001a_ome01:6/1
Bd001a_ome01:2/2 Bd001a_ome01:6/2
Bd001a_ome01:2/3 Bd001a_ome01:1/1
Bd001a_ome01:2/3 Bd001a_ome01:1/2
Bd001a_ome01:2/3 Bd001a_ome01:1/3
Bd001a_ome01:2/3 Bd001a_ome01:1/4
Bd001a_ome01:2/3 Bd001a_ome01:10/1
Bd001a_ome01:2/3 Bd001a_ome01:13/1
Bd001a_ome01:2/3 Bd001a_ome01:13/2
Bd001a_ome01:2/3 Bd001a_ome01:13/3
Bd001a_ome01:2/3 Bd001a_ome01:13/4
Bd001a_ome01:2/3 Bd001a_ome01:14/1
Bd001a_ome01:2/3 Bd001a_ome01:14/3
Bd001a_ome01:2/3 Bd001a_ome01:14/4
Bd001a_ome01:2/3 Bd001a_ome01:2/1
Bd001a_ome01:2/3 Bd001a_ome01:2/2
Bd001a_ome01:2/3 Bd001a_ome01:2/4
Bd001a_ome01:2/3 Bd001a_ome01:3/1
Bd001a_ome01:2/3 Bd001a_ome01:3/2
Bd001a_ome01:2/3 Bd001a_ome01:3/3
Bd001a_ome01:2/3 Bd001a_ome01:3/4
Bd001a_ome01:2/3 Bd001a_ome01:5/1
Bd001a_ome01:2/3 Bd001a_ome01:6/1
Bd001a_ome01:2/3 Bd001a_ome01:6/2
Bd001a_ome01:2/4 Bd001a_ome01:1/1
Bd001a_ome01:2/4 Bd001a_ome01:1/2
Bd001a_ome01:2/4 Bd001a_ome01:1/3
Bd001a_ome01:2/4 Bd001a_ome01:1/4
Bd001a_ome01:2/4 Bd001a_ome01:10/1
Bd001a_ome01:2/4 Bd001a_ome01:13/1
Bd001a_ome01:2/4 Bd001a_ome01:13/2
Bd001a_ome01:2/4 Bd001a_ome01:13/3
Bd001a_ome01:2/4 Bd001a_ome01:13/4
Bd001a_ome01:2/4 Bd001a_ome01:14/1
Bd001a_ome01:2/4 Bd001a_ome01:14/3
Bd001a_ome01:2/4 Bd001a_ome01:14/4
Bd001a_ome01:2/4 Bd001a_ome01:2/1
Bd001a_ome01:2/4 Bd001a_ome01:2/2
Bd001a_ome01:2/4 Bd001a_ome01:2/3
Bd001a_ome01:2/4 Bd001a_ome01:3/1
Bd001a_ome01:2/4 Bd001a_ome01:3/2
Bd001a_ome01:2/4 Bd001a_ome01:3/3
Bd001a_ome01:2/4 Bd001a_ome01:3/4
Bd001a_ome01:2/4 Bd001a_ome01:5/1
Bd001a_ome01:2/4 Bd001a_ome01:6/1
Bd001a_ome01:2/4 Bd001a_ome01:6/2
Bd001a_ome01:3/1 Bd001a_ome01:1/1
Bd001a_ome01:3/1 Bd001a_ome01:1/2
Bd001a_ome01:3/1 Bd001a_ome01:1/3
Bd001a_ome01:3/1 Bd001a_ome01:1/4
Bd001a_ome01:3/1 Bd001a_ome01:10/1
Bd001a_ome01:3/1 Bd001a_ome01:13/1
Bd001a_ome01:3/1 Bd001a_ome01:13/2
Bd001a_ome01:3/1 Bd001a_ome01:13/3
Bd001a_ome01:3/1 Bd001a_ome01:13/4
Bd001a_ome01:3/1 Bd001a_ome01:14/1
Bd001a_ome01:3/1 Bd001a_ome01:14/3
Bd001a_ome01:3/1 Bd001a_ome01:14/4
Bd001a_ome01:3/1 Bd001a_ome01:2/1
Bd001a_ome01:3/1 Bd001a_ome01:2/2
Bd001a_ome01:3/1 Bd001a_ome01:2/3
Bd001a_ome01:3/1 Bd001a_ome01:2/4
Bd001a_ome01:3/1 Bd001a_ome01:3/2
Bd001a_ome01:3/1 Bd001a_ome01:3/3
Bd001a_ome01:3/1 Bd001a_ome01:3/4
Bd001a_ome01:3/1 Bd001a_ome01:5/1
Bd001a_ome01:3/1 Bd001a_ome01:6/1
Bd001a_ome01:3/1 Bd001a_ome01:6/2
Bd001a_ome01:3/2 Bd001a_ome01:1/1
Bd001a_ome01:3/2 Bd001a_ome01:1/2
Bd001a_ome01:3/2 Bd001a_ome01:1/3
Bd001a_ome01:3/2 Bd001a_ome01:1/4
Bd001a_ome01:3/2 Bd001a_ome01:10/1
Bd001a_ome01:3/2 Bd001a_ome01:13/1
Bd001a_ome01:3/2 Bd001a_ome01:13/2
Bd001a_ome01:3/2 Bd001a_ome01:13/3
Bd001a_ome01:3/2 Bd001a_ome01:13/4
Bd001a_ome01:3/2 Bd001a_ome01:14/1
Bd001a_ome01:3/2 Bd001a_ome01:14/3
Bd001a_ome01:3/2 Bd001a_ome01:14/4
Bd001a_ome01:3/2 Bd001a_ome01:2/1
Bd001a_ome01:3/2 Bd001a_ome01:2/2
Bd001a_ome01:3/2 Bd001a_ome01:2/3
Bd001a_ome01:3/2 Bd001a_ome01:2/4
Bd001a_ome01:3/2 Bd001a_ome01:3/1
Bd001a_ome01:3/2 Bd001a_ome01:3/3
Bd001a_ome01:3/2 Bd001a_ome01:3/4
Bd001a_ome01:3/2 Bd001a_ome01:5/1
Bd001a_ome01:3/2 Bd001a_ome01:6/1
Bd001a_ome01:3/2 Bd001a_ome01:6/2
Bd001a_ome01:3/3 Bd001a_ome01:1/1
Bd001a_ome01:3/3 Bd001a_ome01:1/2
Bd001a_ome01:3/3 Bd001a_ome01:1/3
Bd001a_ome01:3/3 Bd001a_ome01:1/4
Bd001a_ome01:3/3 Bd001a_ome01:10/1
Bd001a_ome01:3/3 Bd001a_ome01:13/1
Bd001a_ome01:3/3 Bd001a_ome01:13/2
Bd001a_ome01:3/3 Bd001a_ome01:13/3
Bd001a_ome01:3/3 Bd001a_ome01:13/4
Bd001a_ome01:3/3 Bd001a_ome01:14/1
Bd001a_ome01:3/3 Bd001a_ome01:14/3
Bd001a_ome01:3/3 Bd001a_ome01:14/4
Bd001a_ome01:3/3 Bd001a_ome01:2/1
Bd001a_ome01:3/3 Bd001a_ome01:2/2
Bd001a_ome01:3/3 Bd001a_ome01:2/3
Bd001a_ome01:3/3 Bd001a_ome01:2/4
Bd001a_ome01:3/3 Bd001a_ome01:3/1
Bd001a_ome01:3/3 Bd001a_ome01:3/2
Bd001a_ome01:3/3 Bd001a_ome01:3/4
Bd001a_ome01:3/3 Bd001a_ome01:5/1
Bd001a_ome01:3/3 Bd001a_ome01:6/1
Bd001a_ome01:3/3 Bd001a_ome01:6/2
Bd001a_ome01:3/4 Bd001a_ome01:1/1
Bd001a_ome01:3/4 Bd001a_ome01:1/2
Bd001a_ome01:3/4 Bd001a_ome01:1/3
Bd001a_ome01:3/4 Bd001a_ome01:1/4
Bd001a_ome01:3/4 Bd001a_ome01:10/1
Bd001a_ome01:3/4 Bd001a_ome01:13/1
Bd001a_ome01:3/4 Bd001a_ome01:13/2
Bd001a_ome01:3/4 Bd001a_ome01:13/3
Bd001a_ome01:3/4 Bd001a_ome01:13/4
Bd001a_ome01:3/4 Bd001a_ome01:14/1
Bd001a_ome01:3/4 Bd001a_ome01:14/3
Bd001a_ome01:3/4 Bd001a_ome01:14/4
Bd001a_ome01:3/4 Bd001a_ome01:2/1
Bd001a_ome01:3/4 Bd001a_ome01:2/2
Bd001a_ome01:3/4 Bd001a_ome01:2/3
Bd001a_ome01:3/4 Bd001a_ome01:2/4
Bd001a_ome01:3/4 Bd001a_ome01:3/1
Bd001a_ome01:3/4 Bd001a_ome01:3/2
Bd001a_ome01:3/4 Bd001a_ome01:3/3
Bd001a_ome01:3/4 Bd001a_ome01:5/1
Bd001a_ome01:3/4 Bd001a_ome01:6/1
Bd001a_ome01:3/4 Bd001a_ome01:6/2
Bd001a_ome01:5/1 Bd001a_ome01:1/1
Bd001a_ome01:5/1 Bd001a_ome01:1/2
Bd001a_ome01:5/1 Bd001a_ome01:1/3
Bd001a_ome01:5/1 Bd001a_ome01:1/4
Bd001a_ome01:5/1 Bd001a_ome01:10/1
Bd001a_ome01:5/1 Bd001a_ome01:13/1
Bd001a_ome01:5/1 Bd001a_ome01:13/2
Bd001a_ome01:5/1 Bd001a_ome01:13/3
Bd001a_ome01:5/1 Bd001a_ome01:13/4
Bd001a_ome01:5/1 Bd001a_ome01:14/1
Bd001a_ome01:5/1 Bd001a_ome01:14/3
Bd001a_ome01:5/1 Bd001a_ome01:14/4
Bd001a_ome01:5/1 Bd001a_ome01:2/1
Bd001a_ome01:5/1 Bd001a_ome01:2/2
Bd001a_ome01:5/1 Bd001a_ome01:2/3
Bd001a_ome01:5/1 Bd001a_ome01:2/4
Bd001a_ome01:5/1 Bd001a_ome01:3/1
Bd001a_ome01:5/1 Bd001a_ome01:3/2
Bd001a_ome01:5/1 Bd001a_ome01:3/3
Bd001a_ome01:5/1 Bd001a_ome01:3/4
Bd001a_ome01:5/1 Bd001a_ome01:6/1
Bd001a_ome01:5/1 Bd001a_ome01:6/2
Bd001a_ome01:5/1 Ht001a_ome01:6/1
Bd001a_ome01:6/1 Bd001a_ome01:1/1
Bd001a_ome01:6/1 Bd001a_ome01:1/2
Bd001a_ome01:6/1 Bd001a_ome01:1/3
Bd001a_ome01:6/1 Bd001a_ome01:1/4
Bd001a_ome01:6/1 Bd001a_ome01:10/1
Bd001a_ome01:6/1 Bd001a_ome01:13/1
Bd001a_ome01:6/1 Bd001a_ome01:13/2
Bd001a_ome01:6/1 Bd001a_ome01:13/3
Bd001a_ome01:6/1 Bd001a_ome01:13/4
Bd001a_ome01:6/1 Bd001a_ome01:14/1
Bd001a_ome01:6/1 Bd001a_ome01:14/3
Bd001a_ome01:6/1 Bd001a_ome01:14/4
Bd001a_ome01:6/1 Bd001a_ome01:2/1
Bd001a_ome01:6/1 Bd001a_ome01:2/2
Bd001a_ome01:6/1 Bd001a_ome01:2/3
Bd001a_ome01:6/1 Bd001a_ome01:2/4
Bd001a_ome01:6/1 Bd001a_ome01:3/1
Bd001a_ome01:6/1 Bd001a_ome01:3/2
Bd001a_ome01:6/1 Bd001a_ome01:3/3
Bd001a_ome01:6/1 Bd001a_ome01:3/4
Bd001a_ome01:6/1 Bd001a_ome01:5/1
Bd001a_ome01:6/1 Bd001a_ome01:6/2
Bd001a_ome01:6/2 Bd001a_ome01:1/1
Bd001a_ome01:6/2 Bd001a_ome01:1/2
Bd001a_ome01:6/2 Bd001a_ome01:1/3
Bd001a_ome01:6/2 Bd001a_ome01:1/4
Bd001a_ome01:6/2 Bd001a_ome01:10/1
Bd001a_ome01:6/2 Bd001a_ome01:13/1
Bd001a_ome01:6/2 Bd001a_ome01:13/2
Bd001a_ome01:6/2 Bd001a_ome01:13/3
Bd001a_ome01:6/2 Bd001a_ome01:13/4
Bd001a_ome01:6/2 Bd001a_ome01:14/1
Bd001a_ome01:6/2 Bd001a_ome01:14/3
Bd001a_ome01:6/2 Bd001a_ome01:14/4
Bd001a_ome01:6/2 Bd001a_ome01:2/1
Bd001a_ome01:6/2 Bd001a_ome01:2/2
Bd001a_ome01:6/2 Bd001a_ome01:2/3
Bd001a_ome01:6/2 Bd001a_ome01:2/4
Bd001a_ome01:6/2 Bd001a_ome01:3/1
Bd001a_ome01:6/2 Bd001a_ome01:3/2
Bd001a_ome01:6/2 Bd001a_ome01:3/3
Bd001a_ome01:6/2 Bd001a_ome01:3/4
Bd001a_ome01:6/2 Bd001a_ome01:5/1
Bd001a_ome01:6/2 Bd001a_ome01:6/1
Ddt001a_ome01:1/1 Ddt001a_ome01:1/2
Ddt001a_ome01:1/1 Ddt001a_ome01:1/3
Ddt001a_ome01:1/1 Ddt001a_ome01:1/4
Ddt001a_ome01:1/1 Ddt001a_ome01:12/1
Ddt001a_ome01:1/1 Ddt001a_ome01:6/1
Ddt001a_ome01:1/1 Ddt001a_ome01:9/1
Ddt001a_ome01:1/2 Ddt001a_ome01:1/1
Ddt001a_ome01:1/2 Ddt001a_ome01:1/3
Ddt001a_ome01:1/2 Ddt001a_ome01:1/4
Ddt001a_ome01:1/2 Ddt001a_ome01:12/1
Ddt001a_ome01:1/2 Ddt001a_ome01:6/1
Ddt001a_ome01:1/2 Ddt001a_ome01:9/1
Ddt001a_ome01:1/3 Ddt001a_ome01:1/1
Ddt001a_ome01:1/3 Ddt001a_ome01:1/2
Ddt001a_ome01:1/3 Ddt001a_ome01:1/4
Ddt001a_ome01:1/3 Ddt001a_ome01:12/1
Ddt001a_ome01:1/3 Ddt001a_ome01:6/1
Ddt001a_ome01:1/3 Ddt001a_ome01:9/1
Ddt001a_ome01:1/4 Ddt001a_ome01:1/1
Ddt001a_ome01:1/4 Ddt001a_ome01:1/2
Ddt001a_ome01:1/4 Ddt001a_ome01:1/3
Ddt001a_ome01:1/4 Ddt001a_ome01:12/1
Ddt001a_ome01:1/4 Ddt001a_ome01:6/1
Ddt001a_ome01:1/4 Ddt001a_ome01:9/1
Ddt001a_ome01:12/1 Ddt001a_ome01:1/1
Ddt001a_ome01:12/1 Ddt001a_ome01:1/2
Ddt001a_ome01:12/1 Ddt001a_ome01:1/3
Ddt001a_ome01:12/1 Ddt001a_ome01:1/4
Ddt001a_ome01:12/1 Ddt001a_ome01:6/1
Ddt001a_ome01:12/1 Ddt001a_ome01:9/1
Ddt001a_ome01:6/1 Asd001a_ome05:5/1
Ddt001a_ome01:6/1 Ddt001a_ome01:1/1
Ddt001a_ome01:6/1 Ddt001a_ome01:1/2
Ddt001a_ome01:6/1 Ddt001a_ome01:1/3
Ddt001a_ome01:6/1 Ddt001a_ome01:1/4
Ddt001a_ome01:6/1 Ddt001a_ome01:12/1
Ddt001a_ome01:6/1 Ddt001a_ome01:9/1
Ddt001a_ome01:9/1 Bd001a_ome01:10/1
Ddt001a_ome01:9/1 Ddt001a_ome01:1/1
Ddt001a_ome01:9/1 Ddt001a_ome01:1/2
Ddt001a_ome01:9/1 Ddt001a_ome01:1/3
Ddt001a_ome01:9/1 Ddt001a_ome01:1/4
Ddt001a_ome01:9/1 Ddt001a_ome01:12/1
Ddt001a_ome01:9/1 Ddt001a_ome01:6/1
Dgl001a_ome01:1/1 Dgl001a_ome01:1/2
Dgl001a_ome01:1/1 Dgl001a_ome01:1/3
Dgl001a_ome01:1/1 Dgl001a_ome01:1/4
Dgl001a_ome01:1/1 Dgl001a_ome01:2/1
Dgl001a_ome01:1/1 Dgl001a_ome01:2/2
Dgl001a_ome01:1/1 Dgl001a_ome01:2/3
Dgl001a_ome01:1/1 Dgl001a_ome01:2/4
Dgl001a_ome01:1/1 Dgl001a_ome01:3/1
Dgl001a_ome01:1/1 Dgl001a_ome01:3/2
Dgl001a_ome01:1/1 Dgl001a_ome01:3/3
Dgl001a_ome01:1/1 Dgl001a_ome01:3/4
Dgl001a_ome01:1/1 Dgl001a_ome01:6/1
Dgl001a_ome01:1/1 Dgl001a_ome01:9/1
Dgl001a_ome01:1/2 Dgl001a_ome01:1/1
Dgl001a_ome01:1/2 Dgl001a_ome01:1/3
Dgl001a_ome01:1/2 Dgl001a_ome01:1/4
Dgl001a_ome01:1/2 Dgl001a_ome01:2/1
Dgl001a_ome01:1/2 Dgl001a_ome01:2/2
Dgl001a_ome01:1/2 Dgl001a_ome01:2/3
Dgl001a_ome01:1/2 Dgl001a_ome01:2/4
Dgl001a_ome01:1/2 Dgl001a_ome01:3/1
Dgl001a_ome01:1/2 Dgl001a_ome01:3/2
Dgl001a_ome01:1/2 Dgl001a_ome01:3/3
Dgl001a_ome01:1/2 Dgl001a_ome01:3/4
Dgl001a_ome01:1/2 Dgl001a_ome01:6/1
Dgl001a_ome01:1/2 Dgl001a_ome01:9/1
Dgl001a_ome01:1/3 Dgl001a_ome01:1/1
Dgl001a_ome01:1/3 Dgl001a_ome01:1/2
Dgl001a_ome01:1/3 Dgl001a_ome01:1/4
Dgl001a_ome01:1/3 Dgl001a_ome01:2/1
Dgl001a_ome01:1/3 Dgl001a_ome01:2/2
Dgl001a_ome01:1/3 Dgl001a_ome01:2/3
Dgl001a_ome01:1/3 Dgl001a_ome01:2/4
Dgl001a_ome01:1/3 Dgl001a_ome01:3/1
Dgl001a_ome01:1/3 Dgl001a_ome01:3/2
Dgl001a_ome01:1/3 Dgl001a_ome01:3/3
Dgl001a_ome01:1/3 Dgl001a_ome01:3/4
Dgl001a_ome01:1/3 Dgl001a_ome01:6/1
Dgl001a_ome01:1/3 Dgl001a_ome01:9/1
Dgl001a_ome01:1/4 Dgl001a_ome01:1/1
Dgl001a_ome01:1/4 Dgl001a_ome01:1/2
Dgl001a_ome01:1/4 Dgl001a_ome01:1/3
Dgl001a_ome01:1/4 Dgl001a_ome01:2/1
Dgl001a_ome01:1/4 Dgl001a_ome01:2/2
Dgl001a_ome01:1/4 Dgl001a_ome01:2/3
Dgl001a_ome01:1/4 Dgl001a_ome01:2/4
Dgl001a_ome01:1/4 Dgl001a_ome01:3/1
Dgl001a_ome01:1/4 Dgl001a_ome01:3/2
Dgl001a_ome01:1/4 Dgl001a_ome01:3/3
Dgl001a_ome01:1/4 Dgl001a_ome01:3/4
Dgl001a_ome01:1/4 Dgl001a_ome01:6/1
Dgl001a_ome01:1/4 Dgl001a_ome01:9/1
Dgl001a_ome01:2/1 Dgl001a_ome01:1/1
Dgl001a_ome01:2/1 Dgl001a_ome01:1/2
Dgl001a_ome01:2/1 Dgl001a_ome01:1/3
Dgl001a_ome01:2/1 Dgl001a_ome01:1/4
Dgl001a_ome01:2/1 Dgl001a_ome01:2/2
Dgl001a_ome01:2/1 Dgl001a_ome01:2/3
Dgl001a_ome01:2/1 Dgl001a_ome01:2/4
Dgl001a_ome01:2/1 Dgl001a_ome01:3/1
Dgl001a_ome01:2/1 Dgl001a_ome01:3/2
Dgl001a_ome01:2/1 Dgl001a_ome01:3/3
Dgl001a_ome01:2/1 Dgl001a_ome01:3/4
Dgl001a_ome01:2/1 Dgl001a_ome01:6/1
Dgl001a_ome01:2/1 Dgl001a_ome01:9/1
Dgl001a_ome01:2/2 Dgl001a_ome01:1/1
Dgl001a_ome01:2/2 Dgl001a_ome01:1/2
Dgl001a_ome01:2/2 Dgl001a_ome01:1/3
Dgl001a_ome01:2/2 Dgl001a_ome01:1/4
Dgl001a_ome01:2/2 Dgl001a_ome01:2/1
Dgl001a_ome01:2/2 Dgl001a_ome01:2/3
Dgl001a_ome01:2/2 Dgl001a_ome01:2/4
Dgl001a_ome01:2/2 Dgl001a_ome01:3/1
Dgl001a_ome01:2/2 Dgl001a_ome01:3/2
Dgl001a_ome01:2/2 Dgl001a_ome01:3/3
Dgl001a_ome01:2/2 Dgl001a_ome01:3/4
Dgl001a_ome01:2/2 Dgl001a_ome01:6/1
Dgl001a_ome01:2/2 Dgl001a_ome01:9/1
Dgl001a_ome01:2/3 Dgl001a_ome01:1/1
Dgl001a_ome01:2/3 Dgl001a_ome01:1/2
Dgl001a_ome01:2/3 Dgl001a_ome01:1/3
Dgl001a_ome01:2/3 Dgl001a_ome01:1/4
Dgl001a_ome01:2/3 Dgl001a_ome01:2/1
Dgl001a_ome01:2/3 Dgl001a_ome01:2/2
Dgl001a_ome01:2/3 Dgl001a_ome01:2/4
Dgl001a_ome01:2/3 Dgl001a_ome01:3/1
Dgl001a_ome01:2/3 Dgl001a_ome01:3/2
Dgl001a_ome01:2/3 Dgl001a_ome01:3/3
Dgl001a_ome01:2/3 Dgl001a_ome01:3/4
Dgl001a_ome01:2/3 Dgl001a_ome01:6/1
Dgl001a_ome01:2/3 Dgl001a_ome01:9/1
Dgl001a_ome01:2/4 Dgl001a_ome01:1/1
Dgl001a_ome01:2/4 Dgl001a_ome01:1/2
Dgl001a_ome01:2/4 Dgl001a_ome01:1/3
Dgl001a_ome01:2/4 Dgl001a_ome01:1/4
Dgl001a_ome01:2/4 Dgl001a_ome01:2/1
Dgl001a_ome01:2/4 Dgl001a_ome01:2/2
Dgl001a_ome01:2/4 Dgl001a_ome01:2/3
Dgl001a_ome01:2/4 Dgl001a_ome01:3/1
Dgl001a_ome01:2/4 Dgl001a_ome01:3/2
Dgl001a_ome01:2/4 Dgl001a_ome01:3/3
Dgl001a_ome01:2/4 Dgl001a_ome01:3/4
Dgl001a_ome01:2/4 Dgl001a_ome01:6/1
Dgl001a_ome01:2/4 Dgl001a_ome01:9/1
Dgl001a_ome01:3/1 Dgl001a_ome01:1/1
Dgl001a_ome01:3/1 Dgl001a_ome01:1/2
Dgl001a_ome01:3/1 Dgl001a_ome01:1/3
Dgl001a_ome01:3/1 Dgl001a_ome01:1/4
Dgl001a_ome01:3/1 Dgl001a_ome01:2/1
Dgl001a_ome01:3/1 Dgl001a_ome01:2/2
Dgl001a_ome01:3/1 Dgl001a_ome01:2/3
Dgl001a_ome01:3/1 Dgl001a_ome01:2/4
Dgl001a_ome01:3/1 Dgl001a_ome01:3/2
Dgl001a_ome01:3/1 Dgl001a_ome01:3/3
Dgl001a_ome01:3/1 Dgl001a_ome01:3/4
Dgl001a_ome01:3/1 Dgl001a_ome01:6/1
Dgl001a_ome01:3/1 Dgl001a_ome01:9/1
Dgl001a_ome01:3/2 Dgl001a_ome01:1/1
Dgl001a_ome01:3/2 Dgl001a_ome01:1/2
Dgl001a_ome01:3/2 Dgl001a_ome01:1/3
Dgl001a_ome01:3/2 Dgl001a_ome01:1/4
Dgl001a_ome01:3/2 Dgl001a_ome01:2/1
Dgl001a_ome01:3/2 Dgl001a_ome01:2/2
Dgl001a_ome01:3/2 Dgl001a_ome01:2/3
Dgl001a_ome01:3/2 Dgl001a_ome01:2/4
Dgl001a_ome01:3/2 Dgl001a_ome01:3/1
Dgl001a_ome01:3/2 Dgl001a_ome01:3/3
Dgl001a_ome01:3/2 Dgl001a_ome01:3/4
Dgl001a_ome01:3/2 Dgl001a_ome01:6/1
Dgl001a_ome01:3/2 Dgl001a_ome01:9/1
Dgl001a_ome01:3/3 Dgl001a_ome01:1/1
Dgl001a_ome01:3/3 Dgl001a_ome01:1/2
Dgl001a_ome01:3/3 Dgl001a_ome01:1/3
Dgl001a_ome01:3/3 Dgl001a_ome01:1/4
Dgl001a_ome01:3/3 Dgl001a_ome01:2/1
Dgl001a_ome01:3/3 Dgl001a_ome01:2/2
Dgl001a_ome01:3/3 Dgl001a_ome01:2/3
Dgl001a_ome01:3/3 Dgl001a_ome01:2/4
Dgl001a_ome01:3/3 Dgl001a_ome01:3/1
Dgl001a_ome01:3/3 Dgl001a_ome01:3/2
Dgl001a_ome01:3/3 Dgl001a_ome01:3/4
Dgl001a_ome01:3/3 Dgl001a_ome01:6/1
Dgl001a_ome01:3/3 Dgl001a_ome01:9/1
Dgl001a_ome01:3/4 Dgl001a_ome01:1/1
Dgl001a_ome01:3/4 Dgl001a_ome01:1/2
Dgl001a_ome01:3/4 Dgl001a_ome01:1/3
Dgl001a_ome01:3/4 Dgl001a_ome01:1/4
Dgl001a_ome01:3/4 Dgl001a_ome01:2/1
Dgl001a_ome01:3/4 Dgl001a_ome01:2/2
Dgl001a_ome01:3/4 Dgl001a_ome01:2/3
Dgl001a_ome01:3/4 Dgl001a_ome01:2/4
Dgl001a_ome01:3/4 Dgl001a_ome01:3/1
Dgl001a_ome01:3/4 Dgl001a_ome01:3/2
Dgl001a_ome01:3/4 Dgl001a_ome01:3/3
Dgl001a_ome01:3/4 Dgl001a_ome01:6/1
Dgl001a_ome01:3/4 Dgl001a_ome01:9/1
Dgl001a_ome01:6/1 Asd001a_ome07:6/1
Dgl001a_ome01:6/1 Dgl001a_ome01:1/1
Dgl001a_ome01:6/1 Dgl001a_ome01:1/2
Dgl001a_ome01:6/1 Dgl001a_ome01:1/3
Dgl001a_ome01:6/1 Dgl001a_ome01:1/4
Dgl001a_ome01:6/1 Dgl001a_ome01:2/1
Dgl001a_ome01:6/1 Dgl001a_ome01:2/2
Dgl001a_ome01:6/1 Dgl001a_ome01:2/3
Dgl001a_ome01:6/1 Dgl001a_ome01:2/4
Dgl001a_ome01:6/1 Dgl001a_ome01:3/1
Dgl001a_ome01:6/1 Dgl001a_ome01:3/2
Dgl001a_ome01:6/1 Dgl001a_ome01:3/3
Dgl001a_ome01:6/1 Dgl001a_ome01:3/4
Dgl001a_ome01:6/1 Dgl001a_ome01:9/1
Dgl001a_ome01:9/1 Asd002a_ome07:6/1
Dgl001a_ome01:9/1 Dgl001a_ome01:1/1
Dgl001a_ome01:9/1 Dgl001a_ome01:1/2
Dgl001a_ome01:9/1 Dgl001a_ome01:1/3
Dgl001a_ome01:9/1 Dgl001a_ome01:1/4
Dgl001a_ome01:9/1 Dgl001a_ome01:2/1
Dgl001a_ome01:9/1 Dgl001a_ome01:2/2
Dgl001a_ome01:9/1 Dgl001a_ome01:2/3
Dgl001a_ome01:9/1 Dgl001a_ome01:2/4
Dgl001a_ome01:9/1 Dgl001a_ome01:3/1
Dgl001a_ome01:9/1 Dgl001a_ome01:3/2
Dgl001a_ome01:9/1 Dgl001a_ome01:3/3
Dgl001a_ome01:9/1 Dgl001a_ome01:3/4
Dgl001a_ome01:9/1 Dgl001a_ome01:6/1
Dt001a_ome01:1/1 Dt001a_ome01:1/2
Dt001a_ome01:1/1 Dt001a_ome01:1/3
Dt001a_ome01:1/1 Dt001a_ome01:1/4
Dt001a_ome01:1/1 Dt001a_ome01:2/1
Dt001a_ome01:1/1 Dt001a_ome01:2/2
Dt001a_ome01:1/1 Dt001a_ome01:2/3
Dt001a_ome01:1/1 Dt001a_ome01:2/4
Dt001a_ome01:1/1 Dt001a_ome01:6/1
Dt001a_ome01:1/1 Dt001a_ome01:9/1
Dt001a_ome01:1/2 Dt001a_ome01:1/1
Dt001a_ome01:1/2 Dt001a_ome01:1/3
Dt001a_ome01:1/2 Dt001a_ome01:1/4
Dt001a_ome01:1/2 Dt001a_ome01:2/1
Dt001a_ome01:1/2 Dt001a_ome01:2/2
Dt001a_ome01:1/2 Dt001a_ome01:2/3
Dt001a_ome01:1/2 Dt001a_ome01:2/4
Dt001a_ome01:1/2 Dt001a_ome01:6/1
Dt001a_ome01:1/2 Dt001a_ome01:9/1
Dt001a_ome01:1/3 Dt001a_ome01:1/1
Dt001a_ome01:1/3 Dt001a_ome01:1/2
Dt001a_ome01:1/3 Dt001a_ome01:1/4
Dt001a_ome01:1/3 Dt001a_ome01:2/1
Dt001a_ome01:1/3 Dt001a_ome01:2/2
Dt001a_ome01:1/3 Dt001a_ome01:2/3
Dt001a_ome01:1/3 Dt001a_ome01:2/4
Dt001a_ome01:1/3 Dt001a_ome01:6/1
Dt001a_ome01:1/3 Dt001a_ome01:9/1
Dt001a_ome01:1/4 Dt001a_ome01:1/1
Dt001a_ome01:1/4 Dt001a_ome01:1/2
Dt001a_ome01:1/4 Dt001a_ome01:1/3
Dt001a_ome01:1/4 Dt001a_ome01:2/1
Dt001a_ome01:1/4 Dt001a_ome01:2/2
Dt001a_ome01:1/4 Dt001a_ome01:2/3
Dt001a_ome01:1/4 Dt001a_ome01:2/4
Dt001a_ome01:1/4 Dt001a_ome01:6/1
Dt001a_ome01:1/4 Dt001a_ome01:9/1
Dt001a_ome01:2/1 Dt001a_ome01:1/1
Dt001a_ome01:2/1 Dt001a_ome01:1/2
Dt001a_ome01:2/1 Dt001a_ome01:1/3
Dt001a_ome01:2/1 Dt001a_ome01:1/4
Dt001a_ome01:2/1 Dt001a_ome01:2/2
Dt001a_ome01:2/1 Dt001a_ome01:2/3
Dt001a_ome01:2/1 Dt001a_ome01:2/4
Dt001a_ome01:2/1 Dt001a_ome01:6/1
Dt001a_ome01:2/1 Dt001a_ome01:9/1
Dt001a_ome01:2/2 Dt001a_ome01:1/1
Dt001a_ome01:2/2 Dt001a_ome01:1/2
Dt001a_ome01:2/2 Dt001a_ome01:1/3
Dt001a_ome01:2/2 Dt001a_ome01:1/4
Dt001a_ome01:2/2 Dt001a_ome01:2/1
Dt001a_ome01:2/2 Dt001a_ome01:2/3
Dt001a_ome01:2/2 Dt001a_ome01:2/4
Dt001a_ome01:2/2 Dt001a_ome01:6/1
Dt001a_ome01:2/2 Dt001a_ome01:9/1
Dt001a_ome01:2/3 Dt001a_ome01:1/1
Dt001a_ome01:2/3 Dt001a_ome01:1/2
Dt001a_ome01:2/3 Dt001a_ome01:1/3
Dt001a_ome01:2/3 Dt001a_ome01:1/4
Dt001a_ome01:2/3 Dt001a_ome01:2/1
Dt001a_ome01:2/3 Dt001a_ome01:2/2
Dt001a_ome01:2/3 Dt001a_ome01:2/4
Dt001a_ome01:2/3 Dt001a_ome01:6/1
Dt001a_ome01:2/3 Dt001a_ome01:9/1
Dt001a_ome01:2/4 Dt001a_ome01:1/1
Dt001a_ome01:2/4 Dt001a_ome01:1/2
Dt001a_ome01:2/4 Dt001a_ome01:1/3
Dt001a_ome01:2/4 Dt001a_ome01:1/4
Dt001a_ome01:2/4 Dt001a_ome01:2/1
Dt001a_ome01:2/4 Dt001a_ome01:2/2
Dt001a_ome01:2/4 Dt001a_ome01:2/3
Dt001a_ome01:2/4 Dt001a_ome01:6/1
Dt001a_ome01:2/4 Dt001a_ome01:9/1
Dt001a_ome01:6/1 Asd001a_ome03:9/1
Dt001a_ome01:6/1 Dt001a_ome01:1/1
Dt001a_ome01:6/1 Dt001a_ome01:1/2
Dt001a_ome01:6/1 Dt001a_ome01:1/3
Dt001a_ome01:6/1 Dt001a_ome01:1/4
Dt001a_ome01:6/1 Dt001a_ome01:2/1
Dt001a_ome01:6/1 Dt001a_ome01:2/2
Dt001a_ome01:6/1 Dt001a_ome01:2/3
Dt001a_ome01:6/1 Dt001a_ome01:2/4
Dt001a_ome01:6/1 Dt001a_ome01:9/1
Dt001a_ome01:9/1 Asd002a_ome03:9/1
Dt001a_ome01:9/1 Dt001a_ome01:1/1
Dt001a_ome01:9/1 Dt001a_ome01:1/2
Dt001a_ome01:9/1 Dt001a_ome01:1/3
Dt001a_ome01:9/1 Dt001a_ome01:1/4
Dt001a_ome01:9/1 Dt001a_ome01:2/1
Dt001a_ome01:9/1 Dt001a_ome01:2/2
Dt001a_ome01:9/1 Dt001a_ome01:2/3
Dt001a_ome01:9/1 Dt001a_ome01:2/4
Dt001a_ome01:9/1 Dt001a_ome01:6/1
Ed001a_ome01:14/1 Ed001a_ome01:14/2
Ed001a_ome01:14/1 Ed001a_ome01:6/1
Ed001a_ome01:14/2 Ed001a_ome01:14/1
Ed001a_ome01:14/2 Ed001a_ome01:6/1
Ed001a_ome01:6/1 Ed001a_ome01:14/1
Ed001a_ome01:6/1 Ed001a_ome01:14/2
Ed001a_ome01:6/1 Wg001a_ome01:4/1
Ehv001a_ome01:1/1 Ehv001a_ome01:1/2
Ehv001a_ome01:1/1 Ehv001a_ome01:1/3
Ehv001a_ome01:1/1 Ehv001a_ome01:1/4
Ehv001a_ome01:1/1 Ehv001a_ome01:5/1
Ehv001a_ome01:1/1 Ehv001a_ome01:6/1
Ehv001a_ome01:1/1 Ehv001a_ome01:9/1
Ehv001a_ome01:1/2 Ehv001a_ome01:1/1
Ehv001a_ome01:1/2 Ehv001a_ome01:1/3
Ehv001a_ome01:1/2 Ehv001a_ome01:1/4
Ehv001a_ome01:1/2 Ehv001a_ome01:5/1
Ehv001a_ome01:1/2 Ehv001a_ome01:6/1
Ehv001a_ome01:1/2 Ehv001a_ome01:9/1
Ehv001a_ome01:1/3 Ehv001a_ome01:1/1
Ehv001a_ome01:1/3 Ehv001a_ome01:1/2
Ehv001a_ome01:1/3 Ehv001a_ome01:1/4
Ehv001a_ome01:1/3 Ehv001a_ome01:5/1
Ehv001a_ome01:1/3 Ehv001a_ome01:6/1
Ehv001a_ome01:1/3 Ehv001a_ome01:9/1
Ehv001a_ome01:1/4 Ehv001a_ome01:1/1
Ehv001a_ome01:1/4 Ehv001a_ome01:1/2
Ehv001a_ome01:1/4 Ehv001a_ome01:1/3
Ehv001a_ome01:1/4 Ehv001a_ome01:5/1
Ehv001a_ome01:1/4 Ehv001a_ome01:6/1
Ehv001a_ome01:1/4 Ehv001a_ome01:9/1
Ehv001a_ome01:5/1 Ehv001a_ome01:1/1
Ehv001a_ome01:5/1 Ehv001a_ome01:1/2
Ehv001a_ome01:5/1 Ehv001a_ome01:1/3
Ehv001a_ome01:5/1 Ehv001a_ome01:1/4
Ehv001a_ome01:5/1 Ehv001a_ome01:6/1
Ehv001a_ome01:5/1 Ehv001a_ome01:9/1
Ehv001a_ome01:5/1 Mt001a_ome01:9/1
Ehv001a_ome01:6/1 Asd001a_ome05:9/1
Ehv001a_ome01:6/1 Ehv001a_ome01:1/1
Ehv001a_ome01:6/1 Ehv001a_ome01:1/2
Ehv001a_ome01:6/1 Ehv001a_ome01:1/3
Ehv001a_ome01:6/1 Ehv001a_ome01:1/4
Ehv001a_ome01:6/1 Ehv001a_ome01:5/1
Ehv001a_ome01:6/1 Ehv001a_ome01:9/1
Ehv001a_ome01:9/1 Asd002a_ome05:9/1
Ehv001a_ome01:9/1 Ehv001a_ome01:1/1
Ehv001a_ome01:9/1 Ehv001a_ome01:1/2
Ehv001a_ome01:9/1 Ehv001a_ome01:1/3
Ehv001a_ome01:9/1 Ehv001a_ome01:1/4
Ehv001a_ome01:9/1 Ehv001a_ome01:5/1
Ehv001a_ome01:9/1 Ehv001a_ome01:6/1
Emn001a_ome01:1/1 Emn001a_ome01:1/3
Emn001a_ome01:1/1 Emn001a_ome01:1/4
Emn001a_ome01:1/1 Emn001a_ome01:12/1
Emn001a_ome01:1/1 Emn001a_ome01:12/2
Emn001a_ome01:1/1 Emn001a_ome01:2/1
Emn001a_ome01:1/1 Emn001a_ome01:2/2
Emn001a_ome01:1/1 Emn001a_ome01:2/3
Emn001a_ome01:1/1 Emn001a_ome01:6/1
Emn001a_ome01:1/1 Emn001a_ome01:6/2
Emn001a_ome01:1/1 Emn001a_ome01:9/1
Emn001a_ome01:1/1 Emn001a_ome01:9/2
Emn001a_ome01:1/3 Emn001a_ome01:1/1
Emn001a_ome01:1/3 Emn001a_ome01:1/4
Emn001a_ome01:1/3 Emn001a_ome01:12/1
Emn001a_ome01:1/3 Emn001a_ome01:12/2
Emn001a_ome01:1/3 Emn001a_ome01:2/1
Emn001a_ome01:1/3 Emn001a_ome01:2/2
Emn001a_ome01:1/3 Emn001a_ome01:2/3
Emn001a_ome01:1/3 Emn001a_ome01:6/1
Emn001a_ome01:1/3 Emn001a_ome01:6/2
Emn001a_ome01:1/3 Emn001a_ome01:9/1
Emn001a_ome01:1/3 Emn001a_ome01:9/2
Emn001a_ome01:1/4 Emn001a_ome01:1/1
Emn001a_ome01:1/4 Emn001a_ome01:1/3
Emn001a_ome01:1/4 Emn001a_ome01:12/1
Emn001a_ome01:1/4 Emn001a_ome01:12/2
Emn001a_ome01:1/4 Emn001a_ome01:2/1
Emn001a_ome01:1/4 Emn001a_ome01:2/2
Emn001a_ome01:1/4 Emn001a_ome01:2/3
Emn001a_ome01:1/4 Emn001a_ome01:6/1
Emn001a_ome01:1/4 Emn001a_ome01:6/2
Emn001a_ome01:1/4 Emn001a_ome01:9/1
Emn001a_ome01:1/4 Emn001a_ome01:9/2
Emn001a_ome01:12/1 Emn001a_ome01:1/1
Emn001a_ome01:12/1 Emn001a_ome01:1/3
Emn001a_ome01:12/1 Emn001a_ome01:1/4
Emn001a_ome01:12/1 Emn001a_ome01:12/2
Emn001a_ome01:12/1 Emn001a_ome01:2/1
Emn001a_ome01:12/1 Emn001a_ome01:2/2
Emn001a_ome01:12/1 Emn001a_ome01:2/3
Emn001a_ome01:12/1 Emn001a_ome01:6/1
Emn001a_ome01:12/1 Emn001a_ome01:6/2
Emn001a_ome01:12/1 Emn001a_ome01:9/1
Emn001a_ome01:12/1 Emn001a_ome01:9/2
Emn001a_ome01:12/2 Emn001a_ome01:1/1
Emn001a_ome01:12/2 Emn001a_ome01:1/3
Emn001a_ome01:12/2 Emn001a_ome01:1/4
Emn001a_ome01:12/2 Emn001a_ome01:12/1
Emn001a_ome01:12/2 Emn001a_ome01:2/1
Emn001a_ome01:12/2 Emn001a_ome01:2/2
Emn001a_ome01:12/2 Emn001a_ome01:2/3
Emn001a_ome01:12/2 Emn001a_ome01:6/1
Emn001a_ome01:12/2 Emn001a_ome01:6/2
Emn001a_ome01:12/2 Emn001a_ome01:9/1
Emn001a_ome01:12/2 Emn001a_ome01:9/2
Emn001a_ome01:2/1 Emn001a_ome01:1/1
Emn001a_ome01:2/1 Emn001a_ome01:1/3
Emn001a_ome01:2/1 Emn001a_ome01:1/4
Emn001a_ome01:2/1 Emn001a_ome01:12/1
Emn001a_ome01:2/1 Emn001a_ome01:12/2
Emn001a_ome01:2/1 Emn001a_ome01:2/2
Emn001a_ome01:2/1 Emn001a_ome01:2/3
Emn001a_ome01:2/1 Emn001a_ome01:6/1
Emn001a_ome01:2/1 Emn001a_ome01:6/2
Emn001a_ome01:2/1 Emn001a_ome01:9/1
Emn001a_ome01:2/1 Emn001a_ome01:9/2
Emn001a_ome01:2/2 Emn001a_ome01:1/1
Emn001a_ome01:2/2 Emn001a_ome01:1/3
Emn001a_ome01:2/2 Emn001a_ome01:1/4
Emn001a_ome01:2/2 Emn001a_ome01:12/1
Emn001a_ome01:2/2 Emn001a_ome01:12/2
Emn001a_ome01:2/2 Emn001a_ome01:2/1
Emn001a_ome01:2/2 Emn001a_ome01:2/3
Emn001a_ome01:2/2 Emn001a_ome01:6/1
Emn001a_ome01:2/2 Emn001a_ome01:6/2
Emn001a_ome01:2/2 Emn001a_ome01:9/1
Emn001a_ome01:2/2 Emn001a_ome01:9/2
Emn001a_ome01:2/3 Emn001a_ome01:1/1
Emn001a_ome01:2/3 Emn001a_ome01:1/3
Emn001a_ome01:2/3 Emn001a_ome01:1/4
Emn001a_ome01:2/3 Emn001a_ome01:12/1
Emn001a_ome01:2/3 Emn001a_ome01:12/2
Emn001a_ome01:2/3 Emn001a_ome01:2/1
Emn001a_ome01:2/3 Emn001a_ome01:2/2
Emn001a_ome01:2/3 Emn001a_ome01:6/1
Emn001a_ome01:2/3 Emn001a_ome01:6/2
Emn001a_ome01:2/3 Emn001a_ome01:9/1
Emn001a_ome01:2/3 Emn001a_ome01:9/2
Emn001a_ome01:6/1 Emn001a_ome01:1/1
Emn001a_ome01:6/1 Emn001a_ome01:1/3
Emn001a_ome01:6/1 Emn001a_ome01:1/4
Emn001a_ome01:6/1 Emn001a_ome01:12/1
Emn001a_ome01:6/1 Emn001a_ome01:12/2
Emn001a_ome01:6/1 Emn001a_ome01:2/1
Emn001a_ome01:6/1 Emn001a_ome01:2/2
Emn001a_ome01:6/1 Emn001a_ome01:2/3
Emn001a_ome01:6/1 Emn001a_ome01:6/2
Emn001a_ome01:6/1 Emn001a_ome01:9/1
Emn001a_ome01:6/1 Emn001a_ome01:9/2
Emn001a_ome01:6/1 Ws001a_ome01:9/1
Emn001a_ome01:6/2 Emn001a_ome01:1/1
Emn001a_ome01:6/2 Emn001a_ome01:1/3
Emn001a_ome01:6/2 Emn001a_ome01:1/4
Emn001a_ome01:6/2 Emn001a_ome01:12/1
Emn001a_ome01:6/2 Emn001a_ome01:12/2
Emn001a_ome01:6/2 Emn001a_ome01:2/1
Emn001a_ome01:6/2 Emn001a_ome01:2/2
Emn001a_ome01:6/2 Emn001a_ome01:2/3
Emn001a_ome01:6/2 Emn001a_ome01:6/1
Emn001a_ome01:6/2 Emn001a_ome01:9/1
Emn001a_ome01:6/2 Emn001a_ome01:9/2
Emn001a_ome01:6/2 Ws001a_ome01:9/2
Emn001a_ome01:9/1 Emn001a_ome01:1/1
Emn001a_ome01:9/1 Emn001a_ome01:1/3
Emn001a_ome01:9/1 Emn001a_ome01:1/4
Emn001a_ome01:9/1 Emn001a_ome01:12/1
Emn001a_ome01:9/1 Emn001a_ome01:12/2
Emn001a_ome01:9/1 Emn001a_ome01:2/1
Emn001a_ome01:9/1 Emn001a_ome01:2/2
Emn001a_ome01:9/1 Emn001a_ome01:2/3
Emn001a_ome01:9/1 Emn001a_ome01:6/1
Emn001a_ome01:9/1 Emn001a_ome01:6/2
Emn001a_ome01:9/1 Emn001a_ome01:9/2
Emn001a_ome01:9/1 Hgv001a_ome01:6/1
Emn001a_ome01:9/2 Emn001a_ome01:1/1
Emn001a_ome01:9/2 Emn001a_ome01:1/3
Emn001a_ome01:9/2 Emn001a_ome01:1/4
Emn001a_ome01:9/2 Emn001a_ome01:12/1
Emn001a_ome01:9/2 Emn001a_ome01:12/2
Emn001a_ome01:9/2 Emn001a_ome01:2/1
Emn001a_ome01:9/2 Emn001a_ome01:2/2
Emn001a_ome01:9/2 Emn001a_ome01:2/3
Emn001a_ome01:9/2 Emn001a_ome01:6/1
Emn001a_ome01:9/2 Emn001a_ome01:6/2
Emn001a_ome01:9/2 Emn001a_ome01:9/1
Emn001a_ome01:9/2 Hgv001a_ome01:6/2
Es001a_ome01:1/1 Es001a_ome01:1/2
Es001a_ome01:1/1 Es001a_ome01:1/3
Es001a_ome01:1/1 Es001a_ome01:1/4
Es001a_ome01:1/1 Es001a_ome01:2/1
Es001a_ome01:1/1 Es001a_ome01:2/2
Es001a_ome01:1/1 Es001a_ome01:2/3
Es001a_ome01:1/1 Es001a_ome01:2/4
Es001a_ome01:1/1 Es001a_ome01:6/1
Es001a_ome01:1/1 Es001a_ome01:9/1
Es001a_ome01:1/2 Es001a_ome01:1/1
Es001a_ome01:1/2 Es001a_ome01:1/3
Es001a_ome01:1/2 Es001a_ome01:1/4
Es001a_ome01:1/2 Es001a_ome01:2/1
Es001a_ome01:1/2 Es001a_ome01:2/2
Es001a_ome01:1/2 Es001a_ome01:2/3
Es001a_ome01:1/2 Es001a_ome01:2/4
Es001a_ome01:1/2 Es001a_ome01:6/1
Es001a_ome01:1/2 Es001a_ome01:9/1
Es001a_ome01:1/3 Es001a_ome01:1/1
Es001a_ome01:1/3 Es001a_ome01:1/2
Es001a_ome01:1/3 Es001a_ome01:1/4
Es001a_ome01:1/3 Es001a_ome01:2/1
Es001a_ome01:1/3 Es001a_ome01:2/2
Es001a_ome01:1/3 Es001a_ome01:2/3
Es001a_ome01:1/3 Es001a_ome01:2/4
Es001a_ome01:1/3 Es001a_ome01:6/1
Es001a_ome01:1/3 Es001a_ome01:9/1
Es001a_ome01:1/4 Es001a_ome01:1/1
Es001a_ome01:1/4 Es001a_ome01:1/2
Es001a_ome01:1/4 Es001a_ome01:1/3
Es001a_ome01:1/4 Es001a_ome01:2/1
Es001a_ome01:1/4 Es001a_ome01:2/2
Es001a_ome01:1/4 Es001a_ome01:2/3
Es001a_ome01:1/4 Es001a_ome01:2/4
Es001a_ome01:1/4 Es001a_ome01:6/1
Es001a_ome01:1/4 Es001a_ome01:9/1
Es001a_ome01:2/1 Es001a_ome01:1/1
Es001a_ome01:2/1 Es001a_ome01:1/2
Es001a_ome01:2/1 Es001a_ome01:1/3
Es001a_ome01:2/1 Es001a_ome01:1/4
Es001a_ome01:2/1 Es001a_ome01:2/2
Es001a_ome01:2/1 Es001a_ome01:2/3
Es001a_ome01:2/1 Es001a_ome01:2/4
Es001a_ome01:2/1 Es001a_ome01:6/1
Es001a_ome01:2/1 Es001a_ome01:9/1
Es001a_ome01:2/2 Es001a_ome01:1/1
Es001a_ome01:2/2 Es001a_ome01:1/2
Es001a_ome01:2/2 Es001a_ome01:1/3
Es001a_ome01:2/2 Es001a_ome01:1/4
Es001a_ome01:2/2 Es001a_ome01:2/1
Es001a_ome01:2/2 Es001a_ome01:2/3
Es001a_ome01:2/2 Es001a_ome01:2/4
Es001a_ome01:2/2 Es001a_ome01:6/1
Es001a_ome01:2/2 Es001a_ome01:9/1
Es001a_ome01:2/3 Es001a_ome01:1/1
Es001a_ome01:2/3 Es001a_ome01:1/2
Es001a_ome01:2/3 Es001a_ome01:1/3
Es001a_ome01:2/3 Es001a_ome01:1/4
Es001a_ome01:2/3 Es001a_ome01:2/1
Es001a_ome01:2/3 Es001a_ome01:2/2
Es001a_ome01:2/3 Es001a_ome01:2/4
Es001a_ome01:2/3 Es001a_ome01:6/1
Es001a_ome01:2/3 Es001a_ome01:9/1
Es001a_ome01:2/4 Es001a_ome01:1/1
Es001a_ome01:2/4 Es001a_ome01:1/2
Es001a_ome01:2/4 Es001a_ome01:1/3
Es001a_ome01:2/4 Es001a_ome01:1/4
Es001a_ome01:2/4 Es001a_ome01:2/1
Es001a_ome01:2/4 Es001a_ome01:2/2
Es001a_ome01:2/4 Es001a_ome01:2/3
Es001a_ome01:2/4 Es001a_ome01:6/1
Es001a_ome01:2/4 Es001a_ome01:9/1
Es001a_ome01:6/1 Asd001a_ome06:9/1
Es001a_ome01:6/1 Es001a_ome01:1/1
Es001a_ome01:6/1 Es001a_ome01:1/2
Es001a_ome01:6/1 Es001a_ome01:1/3
Es001a_ome01:6/1 Es001a_ome01:1/4
Es001a_ome01:6/1 Es001a_ome01:2/1
Es001a_ome01:6/1 Es001a_ome01:2/2
Es001a_ome01:6/1 Es001a_ome01:2/3
Es001a_ome01:6/1 Es001a_ome01:2/4
Es001a_ome01:6/1 Es001a_ome01:9/1
Es001a_ome01:9/1 Asd002a_ome06:9/1
Es001a_ome01:9/1 Es001a_ome01:1/1
Es001a_ome01:9/1 Es001a_ome01:1/2
Es001a_ome01:9/1 Es001a_ome01:1/3
Es001a_ome01:9/1 Es001a_ome01:1/4
Es001a_ome01:9/1 Es001a_ome01:2/1
Es001a_ome01:9/1 Es001a_ome01:2/2
Es001a_ome01:9/1 Es001a_ome01:2/3
Es001a_ome01:9/1 Es001a_ome01:2/4
Es001a_ome01:9/1 Es001a_ome01:6/1
Gn001a_ome01:2/2 Asn001a_ome01:9/1
Gn001a_ome01:2/2 Gn001a_ome01:3/1
Gn001a_ome01:2/2 Gn001a_ome01:3/2
Gn001a_ome01:2/2 Gn001a_ome01:3/3
Gn001a_ome01:2/2 Gn001a_ome01:3/4
Gn001a_ome01:2/2 Gn001a_ome01:6/1
Gn001a_ome01:2/2 Gn001a_ome01:9/1
Gn001a_ome01:3/1 Gn001a_ome01:2/2
Gn001a_ome01:3/1 Gn001a_ome01:3/2
Gn001a_ome01:3/1 Gn001a_ome01:3/3
Gn001a_ome01:3/1 Gn001a_ome01:3/4
Gn001a_ome01:3/1 Gn001a_ome01:6/1
Gn001a_ome01:3/1 Gn001a_ome01:9/1
Gn001a_ome01:3/2 Gn001a_ome01:2/2
Gn001a_ome01:3/2 Gn001a_ome01:3/1
Gn001a_ome01:3/2 Gn001a_ome01:3/3
Gn001a_ome01:3/2 Gn001a_ome01:3/4
Gn001a_ome01:3/2 Gn001a_ome01:6/1
Gn001a_ome01:3/2 Gn001a_ome01:9/1
Gn001a_ome01:3/3 Gn001a_ome01:2/2
Gn001a_ome01:3/3 Gn001a_ome01:3/1
Gn001a_ome01:3/3 Gn001a_ome01:3/2
Gn001a_ome01:3/3 Gn001a_ome01:3/4
Gn001a_ome01:3/3 Gn001a_ome01:6/1
Gn001a_ome01:3/3 Gn001a_ome01:9/1
Gn001a_ome01:3/4 Gn001a_ome01:2/2
Gn001a_ome01:3/4 Gn001a_ome01:3/1
Gn001a_ome01:3/4 Gn001a_ome01:3/2
Gn001a_ome01:3/4 Gn001a_ome01:3/3
Gn001a_ome01:3/4 Gn001a_ome01:6/1
Gn001a_ome01:3/4 Gn001a_ome01:9/1
Gn001a_ome01:6/1 Asd001a_ome07:5/1
Gn001a_ome01:6/1 Gn001a_ome01:2/2
Gn001a_ome01:6/1 Gn001a_ome01:3/1
Gn001a_ome01:6/1 Gn001a_ome01:3/2
Gn001a_ome01:6/1 Gn001a_ome01:3/3
Gn001a_ome01:6/1 Gn001a_ome01:3/4
Gn001a_ome01:6/1 Gn001a_ome01:9/1
Gn001a_ome01:9/1 Asd002a_ome07:5/1
Gn001a_ome01:9/1 Gn001a_ome01:2/2
Gn001a_ome01:9/1 Gn001a_ome01:3/1
Gn001a_ome01:9/1 Gn001a_ome01:3/2
Gn001a_ome01:9/1 Gn001a_ome01:3/3
Gn001a_ome01:9/1 Gn001a_ome01:3/4
Gn001a_ome01:9/1 Gn001a_ome01:6/1
Gv001a_ome01:1/1 Gv001a_ome01:1/2
Gv001a_ome01:1/1 Gv001a_ome01:1/3
Gv001a_ome01:1/1 Gv001a_ome01:1/4
Gv001a_ome01:1/1 Gv001a_ome01:12/1
Gv001a_ome01:1/1 Gv001a_ome01:12/2
Gv001a_ome01:1/1 Gv001a_ome01:2/1
Gv001a_ome01:1/1 Gv001a_ome01:2/2
Gv001a_ome01:1/1 Gv001a_ome01:2/3
Gv001a_ome01:1/1 Gv001a_ome01:2/4
Gv001a_ome01:1/1 Gv001a_ome01:3/1
Gv001a_ome01:1/1 Gv001a_ome01:3/2
Gv001a_ome01:1/1 Gv001a_ome01:3/3
Gv001a_ome01:1/1 Gv001a_ome01:3/4
Gv001a_ome01:1/1 Gv001a_ome01:4/1
Gv001a_ome01:1/1 Gv001a_ome01:4/2
Gv001a_ome01:1/1 Gv001a_ome01:4/3
Gv001a_ome01:1/1 Gv001a_ome01:4/4
Gv001a_ome01:1/1 Gv001a_ome01:6/1
Gv001a_ome01:1/1 Gv001a_ome01:9/1
Gv001a_ome01:1/2 Gv001a_ome01:1/1
Gv001a_ome01:1/2 Gv001a_ome01:1/3
Gv001a_ome01:1/2 Gv001a_ome01:1/4
Gv001a_ome01:1/2 Gv001a_ome01:12/1
Gv001a_ome01:1/2 Gv001a_ome01:12/2
Gv001a_ome01:1/2 Gv001a_ome01:2/1
Gv001a_ome01:1/2 Gv001a_ome01:2/2
Gv001a_ome01:1/2 Gv001a_ome01:2/3
Gv001a_ome01:1/2 Gv001a_ome01:2/4
Gv001a_ome01:1/2 Gv001a_ome01:3/1
Gv001a_ome01:1/2 Gv001a_ome01:3/2
Gv001a_ome01:1/2 Gv001a_ome01:3/3
Gv001a_ome01:1/2 Gv001a_ome01:3/4
Gv001a_ome01:1/2 Gv001a_ome01:4/1
Gv001a_ome01:1/2 Gv001a_ome01:4/2
Gv001a_ome01:1/2 Gv001a_ome01:4/3
Gv001a_ome01:1/2 Gv001a_ome01:4/4
Gv001a_ome01:1/2 Gv001a_ome01:6/1
Gv001a_ome01:1/2 Gv001a_ome01:9/1
Gv001a_ome01:1/3 Gv001a_ome01:1/1
Gv001a_ome01:1/3 Gv001a_ome01:1/2
Gv001a_ome01:1/3 Gv001a_ome01:1/4
Gv001a_ome01:1/3 Gv001a_ome01:12/1
Gv001a_ome01:1/3 Gv001a_ome01:12/2
Gv001a_ome01:1/3 Gv001a_ome01:2/1
Gv001a_ome01:1/3 Gv001a_ome01:2/2
Gv001a_ome01:1/3 Gv001a_ome01:2/3
Gv001a_ome01:1/3 Gv001a_ome01:2/4
Gv001a_ome01:1/3 Gv001a_ome01:3/1
Gv001a_ome01:1/3 Gv001a_ome01:3/2
Gv001a_ome01:1/3 Gv001a_ome01:3/3
Gv001a_ome01:1/3 Gv001a_ome01:3/4
Gv001a_ome01:1/3 Gv001a_ome01:4/1
Gv001a_ome01:1/3 Gv001a_ome01:4/2
Gv001a_ome01:1/3 Gv001a_ome01:4/3
Gv001a_ome01:1/3 Gv001a_ome01:4/4
Gv001a_ome01:1/3 Gv001a_ome01:6/1
Gv001a_ome01:1/3 Gv001a_ome01:9/1
Gv001a_ome01:1/4 Gv001a_ome01:1/1
Gv001a_ome01:1/4 Gv001a_ome01:1/2
Gv001a_ome01:1/4 Gv001a_ome01:1/3
Gv001a_ome01:1/4 Gv001a_ome01:12/1
Gv001a_ome01:1/4 Gv001a_ome01:12/2
Gv001a_ome01:1/4 Gv001a_ome01:2/1
Gv001a_ome01:1/4 Gv001a_ome01:2/2
Gv001a_ome01:1/4 Gv001a_ome01:2/3
Gv001a_ome01:1/4 Gv001a_ome01:2/4
Gv001a_ome01:1/4 Gv001a_ome01:3/1
Gv001a_ome01:1/4 Gv001a_ome01:3/2
Gv001a_ome01:1/4 Gv001a_ome01:3/3
Gv001a_ome01:1/4 Gv001a_ome01:3/4
Gv001a_ome01:1/4 Gv001a_ome01:4/1
Gv001a_ome01:1/4 Gv001a_ome01:4/2
Gv001a_ome01:1/4 Gv001a_ome01:4/3
Gv001a_ome01:1/4 Gv001a_ome01:4/4
Gv001a_ome01:1/4 Gv001a_ome01:6/1
Gv001a_ome01:1/4 Gv001a_ome01:9/1
Gv001a_ome01:12/1 Gv001a_ome01:1/1
Gv001a_ome01:12/1 Gv001a_ome01:1/2
Gv001a_ome01:12/1 Gv001a_ome01:1/3
Gv001a_ome01:12/1 Gv001a_ome01:1/4
Gv001a_ome01:12/1 Gv001a_ome01:12/2
Gv001a_ome01:12/1 Gv001a_ome01:2/1
Gv001a_ome01:12/1 Gv001a_ome01:2/2
Gv001a_ome01:12/1 Gv001a_ome01:2/3
Gv001a_ome01:12/1 Gv001a_ome01:2/4
Gv001a_ome01:12/1 Gv001a_ome01:3/1
Gv001a_ome01:12/1 Gv001a_ome01:3/2
Gv001a_ome01:12/1 Gv001a_ome01:3/3
Gv001a_ome01:12/1 Gv001a_ome01:3/4
Gv001a_ome01:12/1 Gv001a_ome01:4/1
Gv001a_ome01:12/1 Gv001a_ome01:4/2
Gv001a_ome01:12/1 Gv001a_ome01:4/3
Gv001a_ome01:12/1 Gv001a_ome01:4/4
Gv001a_ome01:12/1 Gv001a_ome01:6/1
Gv001a_ome01:12/1 Gv001a_ome01:9/1
Gv001a_ome01:12/2 Gv001a_ome01:1/1
Gv001a_ome01:12/2 Gv001a_ome01:1/2
Gv001a_ome01:12/2 Gv001a_ome01:1/3
Gv001a_ome01:12/2 Gv001a_ome01:1/4
Gv001a_ome01:12/2 Gv001a_ome01:12/1
Gv001a_ome01:12/2 Gv001a_ome01:2/1
Gv001a_ome01:12/2 Gv001a_ome01:2/2
Gv001a_ome01:12/2 Gv001a_ome01:2/3
Gv001a_ome01:12/2 Gv001a_ome01:2/4
Gv001a_ome01:12/2 Gv001a_ome01:3/1
Gv001a_ome01:12/2 Gv001a_ome01:3/2
Gv001a_ome01:12/2 Gv001a_ome01:3/3
Gv001a_ome01:12/2 Gv001a_ome01:3/4
Gv001a_ome01:12/2 Gv001a_ome01:4/1
Gv001a_ome01:12/2 Gv001a_ome01:4/2
Gv001a_ome01:12/2 Gv001a_ome01:4/3
Gv001a_ome01:12/2 Gv001a_ome01:4/4
Gv001a_ome01:12/2 Gv001a_ome01:6/1
Gv001a_ome01:12/2 Gv001a_ome01:9/1
Gv001a_ome01:2/1 Gv001a_ome01:1/1
Gv001a_ome01:2/1 Gv001a_ome01:1/2
Gv001a_ome01:2/1 Gv001a_ome01:1/3
Gv001a_ome01:2/1 Gv001a_ome01:1/4
Gv001a_ome01:2/1 Gv001a_ome01:12/1
Gv001a_ome01:2/1 Gv001a_ome01:12/2
Gv001a_ome01:2/1 Gv001a_ome01:2/2
Gv001a_ome01:2/1 Gv001a_ome01:2/3
Gv001a_ome01:2/1 Gv001a_ome01:2/4
Gv001a_ome01:2/1 Gv001a_ome01:3/1
Gv001a_ome01:2/1 Gv001a_ome01:3/2
Gv001a_ome01:2/1 Gv001a_ome01:3/3
Gv001a_ome01:2/1 Gv001a_ome01:3/4
Gv001a_ome01:2/1 Gv001a_ome01:4/1
Gv001a_ome01:2/1 Gv001a_ome01:4/2
Gv001a_ome01:2/1 Gv001a_ome01:4/3
Gv001a_ome01:2/1 Gv001a_ome01:4/4
Gv001a_ome01:2/1 Gv001a_ome01:6/1
Gv001a_ome01:2/1 Gv001a_ome01:9/1
Gv001a_ome01:2/2 Gv001a_ome01:1/1
Gv001a_ome01:2/2 Gv001a_ome01:1/2
Gv001a_ome01:2/2 Gv001a_ome01:1/3
Gv001a_ome01:2/2 Gv001a_ome01:1/4
Gv001a_ome01:2/2 Gv001a_ome01:12/1
Gv001a_ome01:2/2 Gv001a_ome01:12/2
Gv001a_ome01:2/2 Gv001a_ome01:2/1
Gv001a_ome01:2/2 Gv001a_ome01:2/3
Gv001a_ome01:2/2 Gv001a_ome01:2/4
Gv001a_ome01:2/2 Gv001a_ome01:3/1
Gv001a_ome01:2/2 Gv001a_ome01:3/2
Gv001a_ome01:2/2 Gv001a_ome01:3/3
Gv001a_ome01:2/2 Gv001a_ome01:3/4
Gv001a_ome01:2/2 Gv001a_ome01:4/1
Gv001a_ome01:2/2 Gv001a_ome01:4/2
Gv001a_ome01:2/2 Gv001a_ome01:4/3
Gv001a_ome01:2/2 Gv001a_ome01:4/4
Gv001a_ome01:2/2 Gv001a_ome01:6/1
Gv001a_ome01:2/2 Gv001a_ome01:9/1
Gv001a_ome01:2/3 Gv001a_ome01:1/1
Gv001a_ome01:2/3 Gv001a_ome01:1/2
Gv001a_ome01:2/3 Gv001a_ome01:1/3
Gv001a_ome01:2/3 Gv001a_ome01:1/4
Gv001a_ome01:2/3 Gv001a_ome01:12/1
Gv001a_ome01:2/3 Gv001a_ome01:12/2
Gv001a_ome01:2/3 Gv001a_ome01:2/1
Gv001a_ome01:2/3 Gv001a_ome01:2/2
Gv001a_ome01:2/3 Gv001a_ome01:2/4
Gv001a_ome01:2/3 Gv001a_ome01:3/1
Gv001a_ome01:2/3 Gv001a_ome01:3/2
Gv001a_ome01:2/3 Gv001a_ome01:3/3
Gv001a_ome01:2/3 Gv001a_ome01:3/4
Gv001a_ome01:2/3 Gv001a_ome01:4/1
Gv001a_ome01:2/3 Gv001a_ome01:4/2
Gv001a_ome01:2/3 Gv001a_ome01:4/3
Gv001a_ome01:2/3 Gv001a_ome01:4/4
Gv001a_ome01:2/3 Gv001a_ome01:6/1
Gv001a_ome01:2/3 Gv001a_ome01:9/1
Gv001a_ome01:2/4 Gv001a_ome01:1/1
Gv001a_ome01:2/4 Gv001a_ome01:1/2
Gv001a_ome01:2/4 Gv001a_ome01:1/3
Gv001a_ome01:2/4 Gv001a_ome01:1/4
Gv001a_ome01:2/4 Gv001a_ome01:12/1
Gv001a_ome01:2/4 Gv001a_ome01:12/2
Gv001a_ome01:2/4 Gv001a_ome01:2/1
Gv001a_ome01:2/4 Gv001a_ome01:2/2
Gv001a_ome01:2/4 Gv001a_ome01:2/3
Gv001a_ome01:2/4 Gv001a_ome01:3/1
Gv001a_ome01:2/4 Gv001a_ome01:3/2
Gv001a_ome01:2/4 Gv001a_ome01:3/3
Gv001a_ome01:2/4 Gv001a_ome01:3/4
Gv001a_ome01:2/4 Gv001a_ome01:4/1
Gv001a_ome01:2/4 Gv001a_ome01:4/2
Gv001a_ome01:2/4 Gv001a_ome01:4/3
Gv001a_ome01:2/4 Gv001a_ome01:4/4
Gv001a_ome01:2/4 Gv001a_ome01:6/1
Gv001a_ome01:2/4 Gv001a_ome01:9/1
Gv001a_ome01:3/1 Gv001a_ome01:1/1
Gv001a_ome01:3/1 Gv001a_ome01:1/2
Gv001a_ome01:3/1 Gv001a_ome01:1/3
Gv001a_ome01:3/1 Gv001a_ome01:1/4
Gv001a_ome01:3/1 Gv001a_ome01:12/1
Gv001a_ome01:3/1 Gv001a_ome01:12/2
Gv001a_ome01:3/1 Gv001a_ome01:2/1
Gv001a_ome01:3/1 Gv001a_ome01:2/2
Gv001a_ome01:3/1 Gv001a_ome01:2/3
Gv001a_ome01:3/1 Gv001a_ome01:2/4
Gv001a_ome01:3/1 Gv001a_ome01:3/2
Gv001a_ome01:3/1 Gv001a_ome01:3/3
Gv001a_ome01:3/1 Gv001a_ome01:3/4
Gv001a_ome01:3/1 Gv001a_ome01:4/1
Gv001a_ome01:3/1 Gv001a_ome01:4/2
Gv001a_ome01:3/1 Gv001a_ome01:4/3
Gv001a_ome01:3/1 Gv001a_ome01:4/4
Gv001a_ome01:3/1 Gv001a_ome01:6/1
Gv001a_ome01:3/1 Gv001a_ome01:9/1
Gv001a_ome01:3/2 Gv001a_ome01:1/1
Gv001a_ome01:3/2 Gv001a_ome01:1/2
Gv001a_ome01:3/2 Gv001a_ome01:1/3
Gv001a_ome01:3/2 Gv001a_ome01:1/4
Gv001a_ome01:3/2 Gv001a_ome01:12/1
Gv001a_ome01:3/2 Gv001a_ome01:12/2
Gv001a_ome01:3/2 Gv001a_ome01:2/1
Gv001a_ome01:3/2 Gv001a_ome01:2/2
Gv001a_ome01:3/2 Gv001a_ome01:2/3
Gv001a_ome01:3/2 Gv001a_ome01:2/4
Gv001a_ome01:3/2 Gv001a_ome01:3/1
Gv001a_ome01:3/2 Gv001a_ome01:3/3
Gv001a_ome01:3/2 Gv001a_ome01:3/4
Gv001a_ome01:3/2 Gv001a_ome01:4/1
Gv001a_ome01:3/2 Gv001a_ome01:4/2
Gv001a_ome01:3/2 Gv001a_ome01:4/3
Gv001a_ome01:3/2 Gv001a_ome01:4/4
Gv001a_ome01:3/2 Gv001a_ome01:6/1
Gv001a_ome01:3/2 Gv001a_ome01:9/1
Gv001a_ome01:3/3 Gv001a_ome01:1/1
Gv001a_ome01:3/3 Gv001a_ome01:1/2
Gv001a_ome01:3/3 Gv001a_ome01:1/3
Gv001a_ome01:3/3 Gv001a_ome01:1/4
Gv001a_ome01:3/3 Gv001a_ome01:12/1
Gv001a_ome01:3/3 Gv001a_ome01:12/2
Gv001a_ome01:3/3 Gv001a_ome01:2/1
Gv001a_ome01:3/3 Gv001a_ome01:2/2
Gv001a_ome01:3/3 Gv001a_ome01:2/3
Gv001a_ome01:3/3 Gv001a_ome01:2/4
Gv001a_ome01:3/3 Gv001a_ome01:3/1
Gv001a_ome01:3/3 Gv001a_ome01:3/2
Gv001a_ome01:3/3 Gv001a_ome01:3/4
Gv001a_ome01:3/3 Gv001a_ome01:4/1
Gv001a_ome01:3/3 Gv001a_ome01:4/2
Gv001a_ome01:3/3 Gv001a_ome01:4/3
Gv001a_ome01:3/3 Gv001a_ome01:4/4
Gv001a_ome01:3/3 Gv001a_ome01:6/1
Gv001a_ome01:3/3 Gv001a_ome01:9/1
Gv001a_ome01:3/4 Gv001a_ome01:1/1
Gv001a_ome01:3/4 Gv001a_ome01:1/2
Gv001a_ome01:3/4 Gv001a_ome01:1/3
Gv001a_ome01:3/4 Gv001a_ome01:1/4
Gv001a_ome01:3/4 Gv001a_ome01:12/1
Gv001a_ome01:3/4 Gv001a_ome01:12/2
Gv001a_ome01:3/4 Gv001a_ome01:2/1
Gv001a_ome01:3/4 Gv001a_ome01:2/2
Gv001a_ome01:3/4 Gv001a_ome01:2/3
Gv001a_ome01:3/4 Gv001a_ome01:2/4
Gv001a_ome01:3/4 Gv001a_ome01:3/1
Gv001a_ome01:3/4 Gv001a_ome01:3/2
Gv001a_ome01:3/4 Gv001a_ome01:3/3
Gv001a_ome01:3/4 Gv001a_ome01:4/1
Gv001a_ome01:3/4 Gv001a_ome01:4/2
Gv001a_ome01:3/4 Gv001a_ome01:4/3
Gv001a_ome01:3/4 Gv001a_ome01:4/4
Gv001a_ome01:3/4 Gv001a_ome01:6/1
Gv001a_ome01:3/4 Gv001a_ome01:9/1
Gv001a_ome01:4/1 Gv001a_ome01:1/1
Gv001a_ome01:4/1 Gv001a_ome01:1/2
Gv001a_ome01:4/1 Gv001a_ome01:1/3
Gv001a_ome01:4/1 Gv001a_ome01:1/4
Gv001a_ome01:4/1 Gv001a_ome01:12/1
Gv001a_ome01:4/1 Gv001a_ome01:12/2
Gv001a_ome01:4/1 Gv001a_ome01:2/1
Gv001a_ome01:4/1 Gv001a_ome01:2/2
Gv001a_ome01:4/1 Gv001a_ome01:2/3
Gv001a_ome01:4/1 Gv001a_ome01:2/4
Gv001a_ome01:4/1 Gv001a_ome01:3/1
Gv001a_ome01:4/1 Gv001a_ome01:3/2
Gv001a_ome01:4/1 Gv001a_ome01:3/3
Gv001a_ome01:4/1 Gv001a_ome01:3/4
Gv001a_ome01:4/1 Gv001a_ome01:4/2
Gv001a_ome01:4/1 Gv001a_ome01:4/3
Gv001a_ome01:4/1 Gv001a_ome01:4/4
Gv001a_ome01:4/1 Gv001a_ome01:6/1
Gv001a_ome01:4/1 Gv001a_ome01:9/1
Gv001a_ome01:4/2 Gv001a_ome01:1/1
Gv001a_ome01:4/2 Gv001a_ome01:1/2
Gv001a_ome01:4/2 Gv001a_ome01:1/3
Gv001a_ome01:4/2 Gv001a_ome01:1/4
Gv001a_ome01:4/2 Gv001a_ome01:12/1
Gv001a_ome01:4/2 Gv001a_ome01:12/2
Gv001a_ome01:4/2 Gv001a_ome01:2/1
Gv001a_ome01:4/2 Gv001a_ome01:2/2
Gv001a_ome01:4/2 Gv001a_ome01:2/3
Gv001a_ome01:4/2 Gv001a_ome01:2/4
Gv001a_ome01:4/2 Gv001a_ome01:3/1
Gv001a_ome01:4/2 Gv001a_ome01:3/2
Gv001a_ome01:4/2 Gv001a_ome01:3/3
Gv001a_ome01:4/2 Gv001a_ome01:3/4
Gv001a_ome01:4/2 Gv001a_ome01:4/1
Gv001a_ome01:4/2 Gv001a_ome01:4/3
Gv001a_ome01:4/2 Gv001a_ome01:4/4
Gv001a_ome01:4/2 Gv001a_ome01:6/1
Gv001a_ome01:4/2 Gv001a_ome01:9/1
Gv001a_ome01:4/3 Gv001a_ome01:1/1
Gv001a_ome01:4/3 Gv001a_ome01:1/2
Gv001a_ome01:4/3 Gv001a_ome01:1/3
Gv001a_ome01:4/3 Gv001a_ome01:1/4
Gv001a_ome01:4/3 Gv001a_ome01:12/1
Gv001a_ome01:4/3 Gv001a_ome01:12/2
Gv001a_ome01:4/3 Gv001a_ome01:2/1
Gv001a_ome01:4/3 Gv001a_ome01:2/2
Gv001a_ome01:4/3 Gv001a_ome01:2/3
Gv001a_ome01:4/3 Gv001a_ome01:2/4
Gv001a_ome01:4/3 Gv001a_ome01:3/1
Gv001a_ome01:4/3 Gv001a_ome01:3/2
Gv001a_ome01:4/3 Gv001a_ome01:3/3
Gv001a_ome01:4/3 Gv001a_ome01:3/4
Gv001a_ome01:4/3 Gv001a_ome01:4/1
Gv001a_ome01:4/3 Gv001a_ome01:4/2
Gv001a_ome01:4/3 Gv001a_ome01:4/4
Gv001a_ome01:4/3 Gv001a_ome01:6/1
Gv001a_ome01:4/3 Gv001a_ome01:9/1
Gv001a_ome01:4/4 Gv001a_ome01:1/1
Gv001a_ome01:4/4 Gv001a_ome01:1/2
Gv001a_ome01:4/4 Gv001a_ome01:1/3
Gv001a_ome01:4/4 Gv001a_ome01:1/4
Gv001a_ome01:4/4 Gv001a_ome01:12/1
Gv001a_ome01:4/4 Gv001a_ome01:12/2
Gv001a_ome01:4/4 Gv001a_ome01:2/1
Gv001a_ome01:4/4 Gv001a_ome01:2/2
Gv001a_ome01:4/4 Gv001a_ome01:2/3
Gv001a_ome01:4/4 Gv001a_ome01:2/4
Gv001a_ome01:4/4 Gv001a_ome01:3/1
Gv001a_ome01:4/4 Gv001a_ome01:3/2
Gv001a_ome01:4/4 Gv001a_ome01:3/3
Gv001a_ome01:4/4 Gv001a_ome01:3/4
Gv001a_ome01:4/4 Gv001a_ome01:4/1
Gv001a_ome01:4/4 Gv001a_ome01:4/2
Gv001a_ome01:4/4 Gv001a_ome01:4/3
Gv001a_ome01:4/4 Gv001a_ome01:6/1
Gv001a_ome01:4/4 Gv001a_ome01:9/1
Gv001a_ome01:6/1 Asd001a_ome03:6/1
Gv001a_ome01:6/1 Gv001a_ome01:1/1
Gv001a_ome01:6/1 Gv001a_ome01:1/2
Gv001a_ome01:6/1 Gv001a_ome01:1/3
Gv001a_ome01:6/1 Gv001a_ome01:1/4
Gv001a_ome01:6/1 Gv001a_ome01:12/1
Gv001a_ome01:6/1 Gv001a_ome01:12/2
Gv001a_ome01:6/1 Gv001a_ome01:2/1
Gv001a_ome01:6/1 Gv001a_ome01:2/2
Gv001a_ome01:6/1 Gv001a_ome01:2/3
Gv001a_ome01:6/1 Gv001a_ome01:2/4
Gv001a_ome01:6/1 Gv001a_ome01:3/1
Gv001a_ome01:6/1 Gv001a_ome01:3/2
Gv001a_ome01:6/1 Gv001a_ome01:3/3
Gv001a_ome01:6/1 Gv001a_ome01:3/4
Gv001a_ome01:6/1 Gv001a_ome01:4/1
Gv001a_ome01:6/1 Gv001a_ome01:4/2
Gv001a_ome01:6/1 Gv001a_ome01:4/3
Gv001a_ome01:6/1 Gv001a_ome01:4/4
Gv001a_ome01:6/1 Gv001a_ome01:9/1
Gv001a_ome01:9/1 Asd002a_ome03:6/1
Gv001a_ome01:9/1 Gv001a_ome01:1/1
Gv001a_ome01:9/1 Gv001a_ome01:1/2
Gv001a_ome01:9/1 Gv001a_ome01:1/3
Gv001a_ome01:9/1 Gv001a_ome01:1/4
Gv001a_ome01:9/1 Gv001a_ome01:12/1
Gv001a_ome01:9/1 Gv001a_ome01:12/2
Gv001a_ome01:9/1 Gv001a_ome01:2/1
Gv001a_ome01:9/1 Gv001a_ome01:2/2
Gv001a_ome01:9/1 Gv001a_ome01:2/3
Gv001a_ome01:9/1 Gv001a_ome01:2/4
Gv001a_ome01:9/1 Gv001a_ome01:3/1
Gv001a_ome01:9/1 Gv001a_ome01:3/2
Gv001a_ome01:9/1 Gv001a_ome01:3/3
Gv001a_ome01:9/1 Gv001a_ome01:3/4
Gv001a_ome01:9/1 Gv001a_ome01:4/1
Gv001a_ome01:9/1 Gv001a_ome01:4/2
Gv001a_ome01:9/1 Gv001a_ome01:4/3
Gv001a_ome01:9/1 Gv001a_ome01:4/4
Gv001a_ome01:9/1 Gv001a_ome01:6/1
Hgv001a_ome01:10/1 Hgv001a_ome01:10/2
Hgv001a_ome01:10/1 Hgv001a_ome01:6/1
Hgv001a_ome01:10/1 Hgv001a_ome01:6/2
Hgv001a_ome01:10/1 Hgv001a_ome01:9/1
Hgv001a_ome01:10/1 Mp001a_ome01:6/1
Hgv001a_ome01:10/2 Hgv001a_ome01:10/1
Hgv001a_ome01:10/2 Hgv001a_ome01:6/1
Hgv001a_ome01:10/2 Hgv001a_ome01:6/2
Hgv001a_ome01:10/2 Hgv001a_ome01:9/1
Hgv001a_ome01:10/2 Mp001a_ome01:6/2
Hgv001a_ome01:6/1 Emn001a_ome01:9/1
Hgv001a_ome01:6/1 Hgv001a_ome01:10/1
Hgv001a_ome01:6/1 Hgv001a_ome01:10/2
Hgv001a_ome01:6/1 Hgv001a_ome01:6/2
Hgv001a_ome01:6/1 Hgv001a_ome01:9/1
Hgv001a_ome01:6/2 Emn001a_ome01:9/2
Hgv001a_ome01:6/2 Hgv001a_ome01:10/1
Hgv001a_ome01:6/2 Hgv001a_ome01:10/2
Hgv001a_ome01:6/2 Hgv001a_ome01:6/1
Hgv001a_ome01:6/2 Hgv001a_ome01:9/1
Hgv001a_ome01:9/1 Asn001a_ome01:6/1
Hgv001a_ome01:9/1 Hgv001a_ome01:10/1
Hgv001a_ome01:9/1 Hgv001a_ome01:10/2
Hgv001a_ome01:9/1 Hgv001a_ome01:6/1
Hgv001a_ome01:9/1 Hgv001a_ome01:6/2
Ht001a_ome01:1/1 Ht001a_ome01:1/2
Ht001a_ome01:1/1 Ht001a_ome01:1/3
Ht001a_ome01:1/1 Ht001a_ome01:1/4
Ht001a_ome01:1/1 Ht001a_ome01:6/1
Ht001a_ome01:1/1 Ht001a_ome01:9/1
Ht001a_ome01:1/2 Ht001a_ome01:1/1
Ht001a_ome01:1/2 Ht001a_ome01:1/3
Ht001a_ome01:1/2 Ht001a_ome01:1/4
Ht001a_ome01:1/2 Ht001a_ome01:6/1
Ht001a_ome01:1/2 Ht001a_ome01:9/1
Ht001a_ome01:1/3 Ht001a_ome01:1/1
Ht001a_ome01:1/3 Ht001a_ome01:1/2
Ht001a_ome01:1/3 Ht001a_ome01:1/4
Ht001a_ome01:1/3 Ht001a_ome01:6/1
Ht001a_ome01:1/3 Ht001a_ome01:9/1
Ht001a_ome01:1/4 Ht001a_ome01:1/1
Ht001a_ome01:1/4 Ht001a_ome01:1/2
Ht001a_ome01:1/4 Ht001a_ome01:1/3
Ht001a_ome01:1/4 Ht001a_ome01:6/1
Ht001a_ome01:1/4 Ht001a_ome01:9/1
Ht001a_ome01:6/1 Bd001a_ome01:5/1
Ht001a_ome01:6/1 Ht001a_ome01:1/1
Ht001a_ome01:6/1 Ht001a_ome01:1/2
Ht001a_ome01:6/1 Ht001a_ome01:1/3
Ht001a_ome01:6/1 Ht001a_ome01:1/4
Ht001a_ome01:6/1 Ht001a_ome01:9/1
Ht001a_ome01:9/1 Asd002a_ome05:5/1
Ht001a_ome01:9/1 Ht001a_ome01:1/1
Ht001a_ome01:9/1 Ht001a_ome01:1/2
Ht001a_ome01:9/1 Ht001a_ome01:1/3
Ht001a_ome01:9/1 Ht001a_ome01:1/4
Ht001a_ome01:9/1 Ht001a_ome01:6/1
Hvs001a_ome01:1/1 Hvs001a_ome01:1/2
Hvs001a_ome01:1/1 Hvs001a_ome01:1/3
Hvs001a_ome01:1/1 Hvs001a_ome01:6/1
Hvs001a_ome01:1/1 Hvs001a_ome01:9/1
Hvs001a_ome01:1/2 Hvs001a_ome01:1/1
Hvs001a_ome01:1/2 Hvs001a_ome01:1/3
Hvs001a_ome01:1/2 Hvs001a_ome01:6/1
Hvs001a_ome01:1/2 Hvs001a_ome01:9/1
Hvs001a_ome01:1/3 Hvs001a_ome01:1/1
Hvs001a_ome01:1/3 Hvs001a_ome01:1/2
Hvs001a_ome01:1/3 Hvs001a_ome01:6/1
Hvs001a_ome01:1/3 Hvs001a_ome01:9/1
Hvs001a_ome01:6/1 Asd001a_ome04:6/1
Hvs001a_ome01:6/1 Hvs001a_ome01:1/1
Hvs001a_ome01:6/1 Hvs001a_ome01:1/2
Hvs001a_ome01:6/1 Hvs001a_ome01:1/3
Hvs001a_ome01:6/1 Hvs001a_ome01:9/1
Hvs001a_ome01:9/1 Asd002a_ome04:6/1
Hvs001a_ome01:9/1 Hvs001a_ome01:1/1
Hvs001a_ome01:9/1 Hvs001a_ome01:1/2
Hvs001a_ome01:9/1 Hvs001a_ome01:1/3
Hvs001a_ome01:9/1 Hvs001a_ome01:6/1
Ledn001a_ome01:1/1 Ledn001a_ome01:1/2
Ledn001a_ome01:1/1 Ledn001a_ome01:1/3
Ledn001a_ome01:1/1 Ledn001a_ome01:1/4
Ledn001a_ome01:1/1 Ledn001a_ome01:10/1
Ledn001a_ome01:1/1 Ledn001a_ome01:2/1
Ledn001a_ome01:1/1 Ledn001a_ome01:2/2
Ledn001a_ome01:1/1 Ledn001a_ome01:2/3
Ledn001a_ome01:1/1 Ledn001a_ome01:2/4
Ledn001a_ome01:1/1 Ledn001a_ome01:5/1
Ledn001a_ome01:1/1 Ledn001a_ome01:6/1
Ledn001a_ome01:1/1 Ledn001a_ome01:9/1
Ledn001a_ome01:1/2 Ledn001a_ome01:1/1
Ledn001a_ome01:1/2 Ledn001a_ome01:1/3
Ledn001a_ome01:1/2 Ledn001a_ome01:1/4
Ledn001a_ome01:1/2 Ledn001a_ome01:10/1
Ledn001a_ome01:1/2 Ledn001a_ome01:2/1
Ledn001a_ome01:1/2 Ledn001a_ome01:2/2
Ledn001a_ome01:1/2 Ledn001a_ome01:2/3
Ledn001a_ome01:1/2 Ledn001a_ome01:2/4
Ledn001a_ome01:1/2 Ledn001a_ome01:5/1
Ledn001a_ome01:1/2 Ledn001a_ome01:6/1
Ledn001a_ome01:1/2 Ledn001a_ome01:9/1
Ledn001a_ome01:1/3 Ledn001a_ome01:1/1
Ledn001a_ome01:1/3 Ledn001a_ome01:1/2
Ledn001a_ome01:1/3 Ledn001a_ome01:1/4
Ledn001a_ome01:1/3 Ledn001a_ome01:10/1
Ledn001a_ome01:1/3 Ledn001a_ome01:2/1
Ledn001a_ome01:1/3 Ledn001a_ome01:2/2
Ledn001a_ome01:1/3 Ledn001a_ome01:2/3
Ledn001a_ome01:1/3 Ledn001a_ome01:2/4
Ledn001a_ome01:1/3 Ledn001a_ome01:5/1
Ledn001a_ome01:1/3 Ledn001a_ome01:6/1
Ledn001a_ome01:1/3 Ledn001a_ome01:9/1
Ledn001a_ome01:1/4 Ledn001a_ome01:1/1
Ledn001a_ome01:1/4 Ledn001a_ome01:1/2
Ledn001a_ome01:1/4 Ledn001a_ome01:1/3
Ledn001a_ome01:1/4 Ledn001a_ome01:10/1
Ledn001a_ome01:1/4 Ledn001a_ome01:2/1
Ledn001a_ome01:1/4 Ledn001a_ome01:2/2
Ledn001a_ome01:1/4 Ledn001a_ome01:2/3
Ledn001a_ome01:1/4 Ledn001a_ome01:2/4
Ledn001a_ome01:1/4 Ledn001a_ome01:5/1
Ledn001a_ome01:1/4 Ledn001a_ome01:6/1
Ledn001a_ome01:1/4 Ledn001a_ome01:9/1
Ledn001a_ome01:10/1 Asd002a_ome01:4/1
Ledn001a_ome01:10/1 Ledn001a_ome01:1/1
Ledn001a_ome01:10/1 Ledn001a_ome01:1/2
Ledn001a_ome01:10/1 Ledn001a_ome01:1/3
Ledn001a_ome01:10/1 Ledn001a_ome01:1/4
Ledn001a_ome01:10/1 Ledn001a_ome01:2/1
Ledn001a_ome01:10/1 Ledn001a_ome01:2/2
Ledn001a_ome01:10/1 Ledn001a_ome01:2/3
Ledn001a_ome01:10/1 Ledn001a_ome01:2/4
Ledn001a_ome01:10/1 Ledn001a_ome01:5/1
Ledn001a_ome01:10/1 Ledn001a_ome01:6/1
Ledn001a_ome01:10/1 Ledn001a_ome01:9/1
Ledn001a_ome01:2/1 Ledn001a_ome01:1/1
Ledn001a_ome01:2/1 Ledn001a_ome01:1/2
Ledn001a_ome01:2/1 Ledn001a_ome01:1/3
Ledn001a_ome01:2/1 Ledn001a_ome01:1/4
Ledn001a_ome01:2/1 Ledn001a_ome01:10/1
Ledn001a_ome01:2/1 Ledn001a_ome01:2/2
Ledn001a_ome01:2/1 Ledn001a_ome01:2/3
Ledn001a_ome01:2/1 Ledn001a_ome01:2/4
Ledn001a_ome01:2/1 Ledn001a_ome01:5/1
Ledn001a_ome01:2/1 Ledn001a_ome01:6/1
Ledn001a_ome01:2/1 Ledn001a_ome01:9/1
Ledn001a_ome01:2/2 Ledn001a_ome01:1/1
Ledn001a_ome01:2/2 Ledn001a_ome01:1/2
Ledn001a_ome01:2/2 Ledn001a_ome01:1/3
Ledn001a_ome01:2/2 Ledn001a_ome01:1/4
Ledn001a_ome01:2/2 Ledn001a_ome01:10/1
Ledn001a_ome01:2/2 Ledn001a_ome01:2/1
Ledn001a_ome01:2/2 Ledn001a_ome01:2/3
Ledn001a_ome01:2/2 Ledn001a_ome01:2/4
Ledn001a_ome01:2/2 Ledn001a_ome01:5/1
Ledn001a_ome01:2/2 Ledn001a_ome01:6/1
Ledn001a_ome01:2/2 Ledn001a_ome01:9/1
Ledn001a_ome01:2/3 Ledn001a_ome01:1/1
Ledn001a_ome01:2/3 Ledn001a_ome01:1/2
Ledn001a_ome01:2/3 Ledn001a_ome01:1/3
Ledn001a_ome01:2/3 Ledn001a_ome01:1/4
Ledn001a_ome01:2/3 Ledn001a_ome01:10/1
Ledn001a_ome01:2/3 Ledn001a_ome01:2/1
Ledn001a_ome01:2/3 Ledn001a_ome01:2/2
Ledn001a_ome01:2/3 Ledn001a_ome01:2/4
Ledn001a_ome01:2/3 Ledn001a_ome01:5/1
Ledn001a_ome01:2/3 Ledn001a_ome01:6/1
Ledn001a_ome01:2/3 Ledn001a_ome01:9/1
Ledn001a_ome01:2/4 Ledn001a_ome01:1/1
Ledn001a_ome01:2/4 Ledn001a_ome01:1/2
Ledn001a_ome01:2/4 Ledn001a_ome01:1/3
Ledn001a_ome01:2/4 Ledn001a_ome01:1/4
Ledn001a_ome01:2/4 Ledn001a_ome01:10/1
Ledn001a_ome01:2/4 Ledn001a_ome01:2/1
Ledn001a_ome01:2/4 Ledn001a_ome01:2/2
Ledn001a_ome01:2/4 Ledn001a_ome01:2/3
Ledn001a_ome01:2/4 Ledn001a_ome01:5/1
Ledn001a_ome01:2/4 Ledn001a_ome01:6/1
Ledn001a_ome01:2/4 Ledn001a_ome01:9/1
Ledn001a_ome01:5/1 Asd001a_ome01:4/1
Ledn001a_ome01:5/1 Ledn001a_ome01:1/1
Ledn001a_ome01:5/1 Ledn001a_ome01:1/2
Ledn001a_ome01:5/1 Ledn001a_ome01:1/3
Ledn001a_ome01:5/1 Ledn001a_ome01:1/4
Ledn001a_ome01:5/1 Ledn001a_ome01:10/1
Ledn001a_ome01:5/1 Ledn001a_ome01:2/1
Ledn001a_ome01:5/1 Ledn001a_ome01:2/2
Ledn001a_ome01:5/1 Ledn001a_ome01:2/3
Ledn001a_ome01:5/1 Ledn001a_ome01:2/4
Ledn001a_ome01:5/1 Ledn001a_ome01:6/1
Ledn001a_ome01:5/1 Ledn001a_ome01:9/1
Ledn001a_ome01:6/1 Ledn001a_ome01:1/1
Ledn001a_ome01:6/1 Ledn001a_ome01:1/2
Ledn001a_ome01:6/1 Ledn001a_ome01:1/3
Ledn001a_ome01:6/1 Ledn001a_ome01:1/4
Ledn001a_ome01:6/1 Ledn001a_ome01:10/1
Ledn001a_ome01:6/1 Ledn001a_ome01:2/1
Ledn001a_ome01:6/1 Ledn001a_ome01:2/2
Ledn001a_ome01:6/1 Ledn001a_ome01:2/3
Ledn001a_ome01:6/1 Ledn001a_ome01:2/4
Ledn001a_ome01:6/1 Ledn001a_ome01:5/1
Ledn001a_ome01:6/1 Ledn001a_ome01:9/1
Ledn001a_ome01:6/1 Spl001a_ome01:9/1
Ledn001a_ome01:9/1 Asd002a_ome03:5/1
Ledn001a_ome01:9/1 Ledn001a_ome01:1/1
Ledn001a_ome01:9/1 Ledn001a_ome01:1/2
Ledn001a_ome01:9/1 Ledn001a_ome01:1/3
Ledn001a_ome01:9/1 Ledn001a_ome01:1/4
Ledn001a_ome01:9/1 Ledn001a_ome01:10/1
Ledn001a_ome01:9/1 Ledn001a_ome01:2/1
Ledn001a_ome01:9/1 Ledn001a_ome01:2/2
Ledn001a_ome01:9/1 Ledn001a_ome01:2/3
Ledn001a_ome01:9/1 Ledn001a_ome01:2/4
Ledn001a_ome01:9/1 Ledn001a_ome01:5/1
Ledn001a_ome01:9/1 Ledn001a_ome01:6/1
Mp001a_ome01:1/1 Mp001a_ome01:1/2
Mp001a_ome01:1/1 Mp001a_ome01:1/3
Mp001a_ome01:1/1 Mp001a_ome01:1/4
Mp001a_ome01:1/1 Mp001a_ome01:6/1
Mp001a_ome01:1/1 Mp001a_ome01:6/2
Mp001a_ome01:1/1 Mp001a_ome01:9/1
Mp001a_ome01:1/1 Mp001a_ome01:9/2
Mp001a_ome01:1/2 Mp001a_ome01:1/1
Mp001a_ome01:1/2 Mp001a_ome01:1/3
Mp001a_ome01:1/2 Mp001a_ome01:1/4
Mp001a_ome01:1/2 Mp001a_ome01:6/1
Mp001a_ome01:1/2 Mp001a_ome01:6/2
Mp001a_ome01:1/2 Mp001a_ome01:9/1
Mp001a_ome01:1/2 Mp001a_ome01:9/2
Mp001a_ome01:1/3 Mp001a_ome01:1/1
Mp001a_ome01:1/3 Mp001a_ome01:1/2
Mp001a_ome01:1/3 Mp001a_ome01:1/4
Mp001a_ome01:1/3 Mp001a_ome01:6/1
Mp001a_ome01:1/3 Mp001a_ome01:6/2
Mp001a_ome01:1/3 Mp001a_ome01:9/1
Mp001a_ome01:1/3 Mp001a_ome01:9/2
Mp001a_ome01:1/4 Mp001a_ome01:1/1
Mp001a_ome01:1/4 Mp001a_ome01:1/2
Mp001a_ome01:1/4 Mp001a_ome01:1/3
Mp001a_ome01:1/4 Mp001a_ome01:6/1
Mp001a_ome01:1/4 Mp001a_ome01:6/2
Mp001a_ome01:1/4 Mp001a_ome01:9/1
Mp001a_ome01:1/4 Mp001a_ome01:9/2
Mp001a_ome01:6/1 Hgv001a_ome01:10/1
Mp001a_ome01:6/1 Mp001a_ome01:1/1
Mp001a_ome01:6/1 Mp001a_ome01:1/2
Mp001a_ome01:6/1 Mp001a_ome01:1/3
Mp001a_ome01:6/1 Mp001a_ome01:1/4
Mp001a_ome01:6/1 Mp001a_ome01:6/2
Mp001a_ome01:6/1 Mp001a_ome01:9/1
Mp001a_ome01:6/1 Mp001a_ome01:9/2
Mp001a_ome01:6/2 Hgv001a_ome01:10/2
Mp001a_ome01:6/2 Mp001a_ome01:1/1
Mp001a_ome01:6/2 Mp001a_ome01:1/2
Mp001a_ome01:6/2 Mp001a_ome01:1/3
Mp001a_ome01:6/2 Mp001a_ome01:1/4
Mp001a_ome01:6/2 Mp001a_ome01:6/1
Mp001a_ome01:6/2 Mp001a_ome01:9/1
Mp001a_ome01:6/2 Mp001a_ome01:9/2
Mp001a_ome01:9/1 Mp001a_ome01:1/1
Mp001a_ome01:9/1 Mp001a_ome01:1/2
Mp001a_ome01:9/1 Mp001a_ome01:1/3
Mp001a_ome01:9/1 Mp001a_ome01:1/4
Mp001a_ome01:9/1 Mp001a_ome01:6/1
Mp001a_ome01:9/1 Mp001a_ome01:6/2
Mp001a_ome01:9/1 Mp001a_ome01:9/2
Mp001a_ome01:9/1 Zl001a_ome01:4/1
Mp001a_ome01:9/2 Mp001a_ome01:1/1
Mp001a_ome01:9/2 Mp001a_ome01:1/2
Mp001a_ome01:9/2 Mp001a_ome01:1/3
Mp001a_ome01:9/2 Mp001a_ome01:1/4
Mp001a_ome01:9/2 Mp001a_ome01:6/1
Mp001a_ome01:9/2 Mp001a_ome01:6/2
Mp001a_ome01:9/2 Mp001a_ome01:9/1
Mp001a_ome01:9/2 Zl001a_ome01:4/2
Mt001a_ome01:1/1 Mt001a_ome01:1/2
Mt001a_ome01:1/1 Mt001a_ome01:1/3
Mt001a_ome01:1/1 Mt001a_ome01:1/4
Mt001a_ome01:1/1 Mt001a_ome01:2/1
Mt001a_ome01:1/1 Mt001a_ome01:2/2
Mt001a_ome01:1/1 Mt001a_ome01:6/1
Mt001a_ome01:1/1 Mt001a_ome01:9/1
Mt001a_ome01:1/2 Mt001a_ome01:1/1
Mt001a_ome01:1/2 Mt001a_ome01:1/3
Mt001a_ome01:1/2 Mt001a_ome01:1/4
Mt001a_ome01:1/2 Mt001a_ome01:2/1
Mt001a_ome01:1/2 Mt001a_ome01:2/2
Mt001a_ome01:1/2 Mt001a_ome01:6/1
Mt001a_ome01:1/2 Mt001a_ome01:9/1
Mt001a_ome01:1/3 Mt001a_ome01:1/1
Mt001a_ome01:1/3 Mt001a_ome01:1/2
Mt001a_ome01:1/3 Mt001a_ome01:1/4
Mt001a_ome01:1/3 Mt001a_ome01:2/1
Mt001a_ome01:1/3 Mt001a_ome01:2/2
Mt001a_ome01:1/3 Mt001a_ome01:6/1
Mt001a_ome01:1/3 Mt001a_ome01:9/1
Mt001a_ome01:1/4 Mt001a_ome01:1/1
Mt001a_ome01:1/4 Mt001a_ome01:1/2
Mt001a_ome01:1/4 Mt001a_ome01:1/3
Mt001a_ome01:1/4 Mt001a_ome01:2/1
Mt001a_ome01:1/4 Mt001a_ome01:2/2
Mt001a_ome01:1/4 Mt001a_ome01:6/1
Mt001a_ome01:1/4 Mt001a_ome01:9/1
Mt001a_ome01:2/1 Mt001a_ome01:1/1
Mt001a_ome01:2/1 Mt001a_ome01:1/2
Mt001a_ome01:2/1 Mt001a_ome01:1/3
Mt001a_ome01:2/1 Mt001a_ome01:1/4
Mt001a_ome01:2/1 Mt001a_ome01:2/2
Mt001a_ome01:2/1 Mt001a_ome01:6/1
Mt001a_ome01:2/1 Mt001a_ome01:9/1
Mt001a_ome01:2/2 Mt001a_ome01:1/1
Mt001a_ome01:2/2 Mt001a_ome01:1/2
Mt001a_ome01:2/2 Mt001a_ome01:1/3
Mt001a_ome01:2/2 Mt001a_ome01:1/4
Mt001a_ome01:2/2 Mt001a_ome01:2/1
Mt001a_ome01:2/2 Mt001a_ome01:6/1
Mt001a_ome01:2/2 Mt001a_ome01:9/1
Mt001a_ome01:6/1 Mt001a_ome01:1/1
Mt001a_ome01:6/1 Mt001a_ome01:1/2
Mt001a_ome01:6/1 Mt001a_ome01:1/3
Mt001a_ome01:6/1 Mt001a_ome01:1/4
Mt001a_ome01:6/1 Mt001a_ome01:2/1
Mt001a_ome01:6/1 Mt001a_ome01:2/2
Mt001a_ome01:6/1 Mt001a_ome01:9/1
Mt001a_ome01:6/1 Nm001a_ome01:5/1
Mt001a_ome01:9/1 Ehv001a_ome01:5/1
Mt001a_ome01:9/1 Mt001a_ome01:1/1
Mt001a_ome01:9/1 Mt001a_ome01:1/2
Mt001a_ome01:9/1 Mt001a_ome01:1/3
Mt001a_ome01:9/1 Mt001a_ome01:1/4
Mt001a_ome01:9/1 Mt001a_ome01:2/1
Mt001a_ome01:9/1 Mt001a_ome01:2/2
Mt001a_ome01:9/1 Mt001a_ome01:6/1
Nm001a_ome01:1/1 Nm001a_ome01:1/2
Nm001a_ome01:1/1 Nm001a_ome01:1/3
Nm001a_ome01:1/1 Nm001a_ome01:1/4
Nm001a_ome01:1/1 Nm001a_ome01:10/1
Nm001a_ome01:1/1 Nm001a_ome01:5/1
Nm001a_ome01:1/1 Nm001a_ome01:6/1
Nm001a_ome01:1/2 Nm001a_ome01:1/1
Nm001a_ome01:1/2 Nm001a_ome01:1/3
Nm001a_ome01:1/2 Nm001a_ome01:1/4
Nm001a_ome01:1/2 Nm001a_ome01:10/1
Nm001a_ome01:1/2 Nm001a_ome01:5/1
Nm001a_ome01:1/2 Nm001a_ome01:6/1
Nm001a_ome01:1/3 Nm001a_ome01:1/1
Nm001a_ome01:1/3 Nm001a_ome01:1/2
Nm001a_ome01:1/3 Nm001a_ome01:1/4
Nm001a_ome01:1/3 Nm001a_ome01:10/1
Nm001a_ome01:1/3 Nm001a_ome01:5/1
Nm001a_ome01:1/3 Nm001a_ome01:6/1
Nm001a_ome01:1/4 Nm001a_ome01:1/1
Nm001a_ome01:1/4 Nm001a_ome01:1/2
Nm001a_ome01:1/4 Nm001a_ome01:1/3
Nm001a_ome01:1/4 Nm001a_ome01:10/1
Nm001a_ome01:1/4 Nm001a_ome01:5/1
Nm001a_ome01:1/4 Nm001a_ome01:6/1
Nm001a_ome01:10/1 Asd002a_ome06:6/1
Nm001a_ome01:10/1 Nm001a_ome01:1/1
Nm001a_ome01:10/1 Nm001a_ome01:1/2
Nm001a_ome01:10/1 Nm001a_ome01:1/3
Nm001a_ome01:10/1 Nm001a_ome01:1/4
Nm001a_ome01:10/1 Nm001a_ome01:5/1
Nm001a_ome01:10/1 Nm001a_ome01:6/1
Nm001a_ome01:5/1 Mt001a_ome01:6/1
Nm001a_ome01:5/1 Nm001a_ome01:1/1
Nm001a_ome01:5/1 Nm001a_ome01:1/2
Nm001a_ome01:5/1 Nm001a_ome01:1/3
Nm001a_ome01:5/1 Nm001a_ome01:1/4
Nm001a_ome01:5/1 Nm001a_ome01:10/1
Nm001a_ome01:5/1 Nm001a_ome01:6/1
Nm001a_ome01:6/1 Ah001a_ome01:9/1
Nm001a_ome01:6/1 Nm001a_ome01:1/1
Nm001a_ome01:6/1 Nm001a_ome01:1/2
Nm001a_ome01:6/1 Nm001a_ome01:1/3
Nm001a_ome01:6/1 Nm001a_ome01:1/4
Nm001a_ome01:6/1 Nm001a_ome01:10/1
Nm001a_ome01:6/1 Nm001a_ome01:5/1
Nm001a_ome02:6/1 Asd001a_ome02:4/1
Nm001a_ome02:6/1 Nm001a_ome02:9/1
Nm001a_ome02:9/1 Asd002a_ome02:4/1
Nm001a_ome02:9/1 Nm001a_ome02:6/1
Rt001a_ome01:1/1 Rt001a_ome01:1/2
Rt001a_ome01:1/1 Rt001a_ome01:1/3
Rt001a_ome01:1/1 Rt001a_ome01:1/4
Rt001a_ome01:1/1 Rt001a_ome01:2/1
Rt001a_ome01:1/1 Rt001a_ome01:2/2
Rt001a_ome01:1/1 Rt001a_ome01:2/3
Rt001a_ome01:1/1 Rt001a_ome01:2/4
Rt001a_ome01:1/1 Rt001a_ome01:6/1
Rt001a_ome01:1/1 Rt001a_ome01:9/1
Rt001a_ome01:1/2 Rt001a_ome01:1/1
Rt001a_ome01:1/2 Rt001a_ome01:1/3
Rt001a_ome01:1/2 Rt001a_ome01:1/4
Rt001a_ome01:1/2 Rt001a_ome01:2/1
Rt001a_ome01:1/2 Rt001a_ome01:2/2
Rt001a_ome01:1/2 Rt001a_ome01:2/3
Rt001a_ome01:1/2 Rt001a_ome01:2/4
Rt001a_ome01:1/2 Rt001a_ome01:6/1
Rt001a_ome01:1/2 Rt001a_ome01:9/1
Rt001a_ome01:1/3 Rt001a_ome01:1/1
Rt001a_ome01:1/3 Rt001a_ome01:1/2
Rt001a_ome01:1/3 Rt001a_ome01:1/4
Rt001a_ome01:1/3 Rt001a_ome01:2/1
Rt001a_ome01:1/3 Rt001a_ome01:2/2
Rt001a_ome01:1/3 Rt001a_ome01:2/3
Rt001a_ome01:1/3 Rt001a_ome01:2/4
Rt001a_ome01:1/3 Rt001a_ome01:6/1
Rt001a_ome01:1/3 Rt001a_ome01:9/1
Rt001a_ome01:1/4 Rt001a_ome01:1/1
Rt001a_ome01:1/4 Rt001a_ome01:1/2
Rt001a_ome01:1/4 Rt001a_ome01:1/3
Rt001a_ome01:1/4 Rt001a_ome01:2/1
Rt001a_ome01:1/4 Rt001a_ome01:2/2
Rt001a_ome01:1/4 Rt001a_ome01:2/3
Rt001a_ome01:1/4 Rt001a_ome01:2/4
Rt001a_ome01:1/4 Rt001a_ome01:6/1
Rt001a_ome01:1/4 Rt001a_ome01:9/1
Rt001a_ome01:2/1 Rt001a_ome01:1/1
Rt001a_ome01:2/1 Rt001a_ome01:1/2
Rt001a_ome01:2/1 Rt001a_ome01:1/3
Rt001a_ome01:2/1 Rt001a_ome01:1/4
Rt001a_ome01:2/1 Rt001a_ome01:2/2
Rt001a_ome01:2/1 Rt001a_ome01:2/3
Rt001a_ome01:2/1 Rt001a_ome01:2/4
Rt001a_ome01:2/1 Rt001a_ome01:6/1
Rt001a_ome01:2/1 Rt001a_ome01:9/1
Rt001a_ome01:2/2 Rt001a_ome01:1/1
Rt001a_ome01:2/2 Rt001a_ome01:1/2
Rt001a_ome01:2/2 Rt001a_ome01:1/3
Rt001a_ome01:2/2 Rt001a_ome01:1/4
Rt001a_ome01:2/2 Rt001a_ome01:2/1
Rt001a_ome01:2/2 Rt001a_ome01:2/3
Rt001a_ome01:2/2 Rt001a_ome01:2/4
Rt001a_ome01:2/2 Rt001a_ome01:6/1
Rt001a_ome01:2/2 Rt001a_ome01:9/1
Rt001a_ome01:2/3 Rt001a_ome01:1/1
Rt001a_ome01:2/3 Rt001a_ome01:1/2
Rt001a_ome01:2/3 Rt001a_ome01:1/3
Rt001a_ome01:2/3 Rt001a_ome01:1/4
Rt001a_ome01:2/3 Rt001a_ome01:2/1
Rt001a_ome01:2/3 Rt001a_ome01:2/2
Rt001a_ome01:2/3 Rt001a_ome01:2/4
Rt001a_ome01:2/3 Rt001a_ome01:6/1
Rt001a_ome01:2/3 Rt001a_ome01:9/1
Rt001a_ome01:2/4 Rt001a_ome01:1/1
Rt001a_ome01:2/4 Rt001a_ome01:1/2
Rt001a_ome01:2/4 Rt001a_ome01:1/3
Rt001a_ome01:2/4 Rt001a_ome01:1/4
Rt001a_ome01:2/4 Rt001a_ome01:2/1
Rt001a_ome01:2/4 Rt001a_ome01:2/2
Rt001a_ome01:2/4 Rt001a_ome01:2/3
Rt001a_ome01:2/4 Rt001a_ome01:6/1
Rt001a_ome01:2/4 Rt001a_ome01:9/1
Rt001a_ome01:6/1 Asd001a_ome04:9/1
Rt001a_ome01:6/1 Rt001a_ome01:1/1
Rt001a_ome01:6/1 Rt001a_ome01:1/2
Rt001a_ome01:6/1 Rt001a_ome01:1/3
Rt001a_ome01:6/1 Rt001a_ome01:1/4
Rt001a_ome01:6/1 Rt001a_ome01:2/1
Rt001a_ome01:6/1 Rt001a_ome01:2/2
Rt001a_ome01:6/1 Rt001a_ome01:2/3
Rt001a_ome01:6/1 Rt001a_ome01:2/4
Rt001a_ome01:6/1 Rt001a_ome01:9/1
Rt001a_ome01:9/1 Asd002a_ome04:9/1
Rt001a_ome01:9/1 Rt001a_ome01:1/1
Rt001a_ome01:9/1 Rt001a_ome01:1/2
Rt001a_ome01:9/1 Rt001a_ome01:1/3
Rt001a_ome01:9/1 Rt001a_ome01:1/4
Rt001a_ome01:9/1 Rt001a_ome01:2/1
Rt001a_ome01:9/1 Rt001a_ome01:2/2
Rt001a_ome01:9/1 Rt001a_ome01:2/3
Rt001a_ome01:9/1 Rt001a_ome01:2/4
Rt001a_ome01:9/1 Rt001a_ome01:6/1
Spl001a_ome01:1/1 Spl001a_ome01:1/2
Spl001a_ome01:1/1 Spl001a_ome01:1/3
Spl001a_ome01:1/1 Spl001a_ome01:1/4
Spl001a_ome01:1/1 Spl001a_ome01:14/1
Spl001a_ome01:1/1 Spl001a_ome01:14/2
Spl001a_ome01:1/1 Spl001a_ome01:2/1
Spl001a_ome01:1/1 Spl001a_ome01:2/2
Spl001a_ome01:1/1 Spl001a_ome01:2/3
Spl001a_ome01:1/1 Spl001a_ome01:2/4
Spl001a_ome01:1/1 Spl001a_ome01:3/1
Spl001a_ome01:1/1 Spl001a_ome01:3/2
Spl001a_ome01:1/1 Spl001a_ome01:3/3
Spl001a_ome01:1/1 Spl001a_ome01:3/4
Spl001a_ome01:1/1 Spl001a_ome01:6/1
Spl001a_ome01:1/1 Spl001a_ome01:9/1
Spl001a_ome01:1/2 Spl001a_ome01:1/1
Spl001a_ome01:1/2 Spl001a_ome01:1/3
Spl001a_ome01:1/2 Spl001a_ome01:1/4
Spl001a_ome01:1/2 Spl001a_ome01:14/1
Spl001a_ome01:1/2 Spl001a_ome01:14/2
Spl001a_ome01:1/2 Spl001a_ome01:2/1
Spl001a_ome01:1/2 Spl001a_ome01:2/2
Spl001a_ome01:1/2 Spl001a_ome01:2/3
Spl001a_ome01:1/2 Spl001a_ome01:2/4
Spl001a_ome01:1/2 Spl001a_ome01:3/1
Spl001a_ome01:1/2 Spl001a_ome01:3/2
Spl001a_ome01:1/2 Spl001a_ome01:3/3
Spl001a_ome01:1/2 Spl001a_ome01:3/4
Spl001a_ome01:1/2 Spl001a_ome01:6/1
Spl001a_ome01:1/2 Spl001a_ome01:9/1
Spl001a_ome01:1/3 Spl001a_ome01:1/1
Spl001a_ome01:1/3 Spl001a_ome01:1/2
Spl001a_ome01:1/3 Spl001a_ome01:1/4
Spl001a_ome01:1/3 Spl001a_ome01:14/1
Spl001a_ome01:1/3 Spl001a_ome01:14/2
Spl001a_ome01:1/3 Spl001a_ome01:2/1
Spl001a_ome01:1/3 Spl001a_ome01:2/2
Spl001a_ome01:1/3 Spl001a_ome01:2/3
Spl001a_ome01:1/3 Spl001a_ome01:2/4
Spl001a_ome01:1/3 Spl001a_ome01:3/1
Spl001a_ome01:1/3 Spl001a_ome01:3/2
Spl001a_ome01:1/3 Spl001a_ome01:3/3
Spl001a_ome01:1/3 Spl001a_ome01:3/4
Spl001a_ome01:1/3 Spl001a_ome01:6/1
Spl001a_ome01:1/3 Spl001a_ome01:9/1
Spl001a_ome01:1/4 Spl001a_ome01:1/1
Spl001a_ome01:1/4 Spl001a_ome01:1/2
Spl001a_ome01:1/4 Spl001a_ome01:1/3
Spl001a_ome01:1/4 Spl001a_ome01:14/1
Spl001a_ome01:1/4 Spl001a_ome01:14/2
Spl001a_ome01:1/4 Spl001a_ome01:2/1
Spl001a_ome01:1/4 Spl001a_ome01:2/2
Spl001a_ome01:1/4 Spl001a_ome01:2/3
Spl001a_ome01:1/4 Spl001a_ome01:2/4
Spl001a_ome01:1/4 Spl001a_ome01:3/1
Spl001a_ome01:1/4 Spl001a_ome01:3/2
Spl001a_ome01:1/4 Spl001a_ome01:3/3
Spl001a_ome01:1/4 Spl001a_ome01:3/4
Spl001a_ome01:1/4 Spl001a_ome01:6/1
Spl001a_ome01:1/4 Spl001a_ome01:9/1
Spl001a_ome01:14/1 Spl001a_ome01:1/1
Spl001a_ome01:14/1 Spl001a_ome01:1/2
Spl001a_ome01:14/1 Spl001a_ome01:1/3
Spl001a_ome01:14/1 Spl001a_ome01:1/4
Spl001a_ome01:14/1 Spl001a_ome01:14/2
Spl001a_ome01:14/1 Spl001a_ome01:2/1
Spl001a_ome01:14/1 Spl001a_ome01:2/2
Spl001a_ome01:14/1 Spl001a_ome01:2/3
Spl001a_ome01:14/1 Spl001a_ome01:2/4
Spl001a_ome01:14/1 Spl001a_ome01:3/1
Spl001a_ome01:14/1 Spl001a_ome01:3/2
Spl001a_ome01:14/1 Spl001a_ome01:3/3
Spl001a_ome01:14/1 Spl001a_ome01:3/4
Spl001a_ome01:14/1 Spl001a_ome01:6/1
Spl001a_ome01:14/1 Spl001a_ome01:9/1
Spl001a_ome01:14/2 Spl001a_ome01:1/1
Spl001a_ome01:14/2 Spl001a_ome01:1/2
Spl001a_ome01:14/2 Spl001a_ome01:1/3
Spl001a_ome01:14/2 Spl001a_ome01:1/4
Spl001a_ome01:14/2 Spl001a_ome01:14/1
Spl001a_ome01:14/2 Spl001a_ome01:2/1
Spl001a_ome01:14/2 Spl001a_ome01:2/2
Spl001a_ome01:14/2 Spl001a_ome01:2/3
Spl001a_ome01:14/2 Spl001a_ome01:2/4
Spl001a_ome01:14/2 Spl001a_ome01:3/1
Spl001a_ome01:14/2 Spl001a_ome01:3/2
Spl001a_ome01:14/2 Spl001a_ome01:3/3
Spl001a_ome01:14/2 Spl001a_ome01:3/4
Spl001a_ome01:14/2 Spl001a_ome01:6/1
Spl001a_ome01:14/2 Spl001a_ome01:9/1
Spl001a_ome01:2/1 Spl001a_ome01:1/1
Spl001a_ome01:2/1 Spl001a_ome01:1/2
Spl001a_ome01:2/1 Spl001a_ome01:1/3
Spl001a_ome01:2/1 Spl001a_ome01:1/4
Spl001a_ome01:2/1 Spl001a_ome01:14/1
Spl001a_ome01:2/1 Spl001a_ome01:14/2
Spl001a_ome01:2/1 Spl001a_ome01:2/2
Spl001a_ome01:2/1 Spl001a_ome01:2/3
Spl001a_ome01:2/1 Spl001a_ome01:2/4
Spl001a_ome01:2/1 Spl001a_ome01:3/1
Spl001a_ome01:2/1 Spl001a_ome01:3/2
Spl001a_ome01:2/1 Spl001a_ome01:3/3
Spl001a_ome01:2/1 Spl001a_ome01:3/4
Spl001a_ome01:2/1 Spl001a_ome01:6/1
Spl001a_ome01:2/1 Spl001a_ome01:9/1
Spl001a_ome01:2/2 Spl001a_ome01:1/1
Spl001a_ome01:2/2 Spl001a_ome01:1/2
Spl001a_ome01:2/2 Spl001a_ome01:1/3
Spl001a_ome01:2/2 Spl001a_ome01:1/4
Spl001a_ome01:2/2 Spl001a_ome01:14/1
Spl001a_ome01:2/2 Spl001a_ome01:14/2
Spl001a_ome01:2/2 Spl001a_ome01:2/1
Spl001a_ome01:2/2 Spl001a_ome01:2/3
Spl001a_ome01:2/2 Spl001a_ome01:2/4
Spl001a_ome01:2/2 Spl001a_ome01:3/1
Spl001a_ome01:2/2 Spl001a_ome01:3/2
Spl001a_ome01:2/2 Spl001a_ome01:3/3
Spl001a_ome01:2/2 Spl001a_ome01:3/4
Spl001a_ome01:2/2 Spl001a_ome01:6/1
Spl001a_ome01:2/2 Spl001a_ome01:9/1
Spl001a_ome01:2/3 Spl001a_ome01:1/1
Spl001a_ome01:2/3 Spl001a_ome01:1/2
Spl001a_ome01:2/3 Spl001a_ome01:1/3
Spl001a_ome01:2/3 Spl001a_ome01:1/4
Spl001a_ome01:2/3 Spl001a_ome01:14/1
Spl001a_ome01:2/3 Spl001a_ome01:14/2
Spl001a_ome01:2/3 Spl001a_ome01:2/1
Spl001a_ome01:2/3 Spl001a_ome01:2/2
Spl001a_ome01:2/3 Spl001a_ome01:2/4
Spl001a_ome01:2/3 Spl001a_ome01:3/1
Spl001a_ome01:2/3 Spl001a_ome01:3/2
Spl001a_ome01:2/3 Spl001a_ome01:3/3
Spl001a_ome01:2/3 Spl001a_ome01:3/4
Spl001a_ome01:2/3 Spl001a_ome01:6/1
Spl001a_ome01:2/3 Spl001a_ome01:9/1
Spl001a_ome01:2/4 Spl001a_ome01:1/1
Spl001a_ome01:2/4 Spl001a_ome01:1/2
Spl001a_ome01:2/4 Spl001a_ome01:1/3
Spl001a_ome01:2/4 Spl001a_ome01:1/4
Spl001a_ome01:2/4 Spl001a_ome01:14/1
Spl001a_ome01:2/4 Spl001a_ome01:14/2
Spl001a_ome01:2/4 Spl001a_ome01:2/1
Spl001a_ome01:2/4 Spl001a_ome01:2/2
Spl001a_ome01:2/4 Spl001a_ome01:2/3
Spl001a_ome01:2/4 Spl001a_ome01:3/1
Spl001a_ome01:2/4 Spl001a_ome01:3/2
Spl001a_ome01:2/4 Spl001a_ome01:3/3
Spl001a_ome01:2/4 Spl001a_ome01:3/4
Spl001a_ome01:2/4 Spl001a_ome01:6/1
Spl001a_ome01:2/4 Spl001a_ome01:9/1
Spl001a_ome01:3/1 Spl001a_ome01:1/1
Spl001a_ome01:3/1 Spl001a_ome01:1/2
Spl001a_ome01:3/1 Spl001a_ome01:1/3
Spl001a_ome01:3/1 Spl001a_ome01:1/4
Spl001a_ome01:3/1 Spl001a_ome01:14/1
Spl001a_ome01:3/1 Spl001a_ome01:14/2
Spl001a_ome01:3/1 Spl001a_ome01:2/1
Spl001a_ome01:3/1 Spl001a_ome01:2/2
Spl001a_ome01:3/1 Spl001a_ome01:2/3
Spl001a_ome01:3/1 Spl001a_ome01:2/4
Spl001a_ome01:3/1 Spl001a_ome01:3/2
Spl001a_ome01:3/1 Spl001a_ome01:3/3
Spl001a_ome01:3/1 Spl001a_ome01:3/4
Spl001a_ome01:3/1 Spl001a_ome01:6/1
Spl001a_ome01:3/1 Spl001a_ome01:9/1
Spl001a_ome01:3/2 Spl001a_ome01:1/1
Spl001a_ome01:3/2 Spl001a_ome01:1/2
Spl001a_ome01:3/2 Spl001a_ome01:1/3
Spl001a_ome01:3/2 Spl001a_ome01:1/4
Spl001a_ome01:3/2 Spl001a_ome01:14/1
Spl001a_ome01:3/2 Spl001a_ome01:14/2
Spl001a_ome01:3/2 Spl001a_ome01:2/1
Spl001a_ome01:3/2 Spl001a_ome01:2/2
Spl001a_ome01:3/2 Spl001a_ome01:2/3
Spl001a_ome01:3/2 Spl001a_ome01:2/4
Spl001a_ome01:3/2 Spl001a_ome01:3/1
Spl001a_ome01:3/2 Spl001a_ome01:3/3
Spl001a_ome01:3/2 Spl001a_ome01:3/4
Spl001a_ome01:3/2 Spl001a_ome01:6/1
Spl001a_ome01:3/2 Spl001a_ome01:9/1
Spl001a_ome01:3/3 Spl001a_ome01:1/1
Spl001a_ome01:3/3 Spl001a_ome01:1/2
Spl001a_ome01:3/3 Spl001a_ome01:1/3
Spl001a_ome01:3/3 Spl001a_ome01:1/4
Spl001a_ome01:3/3 Spl001a_ome01:14/1
Spl001a_ome01:3/3 Spl001a_ome01:14/2
Spl001a_ome01:3/3 Spl001a_ome01:2/1
Spl001a_ome01:3/3 Spl001a_ome01:2/2
Spl001a_ome01:3/3 Spl001a_ome01:2/3
Spl001a_ome01:3/3 Spl001a_ome01:2/4
Spl001a_ome01:3/3 Spl001a_ome01:3/1
Spl001a_ome01:3/3 Spl001a_ome01:3/2
Spl001a_ome01:3/3 Spl001a_ome01:3/4
Spl001a_ome01:3/3 Spl001a_ome01:6/1
Spl001a_ome01:3/3 Spl001a_ome01:9/1
Spl001a_ome01:3/4 Spl001a_ome01:1/1
Spl001a_ome01:3/4 Spl001a_ome01:1/2
Spl001a_ome01:3/4 Spl001a_ome01:1/3
Spl001a_ome01:3/4 Spl001a_ome01:1/4
Spl001a_ome01:3/4 Spl001a_ome01:14/1
Spl001a_ome01:3/4 Spl001a_ome01:14/2
Spl001a_ome01:3/4 Spl001a_ome01:2/1
Spl001a_ome01:3/4 Spl001a_ome01:2/2
Spl001a_ome01:3/4 Spl001a_ome01:2/3
Spl001a_ome01:3/4 Spl001a_ome01:2/4
Spl001a_ome01:3/4 Spl001a_ome01:3/1
Spl001a_ome01:3/4 Spl001a_ome01:3/2
Spl001a_ome01:3/4 Spl001a_ome01:3/3
Spl001a_ome01:3/4 Spl001a_ome01:6/1
Spl001a_ome01:3/4 Spl001a_ome01:9/1
Spl001a_ome01:6/1 Asd001a_ome03:5/1
Spl001a_ome01:6/1 Spl001a_ome01:1/1
Spl001a_ome01:6/1 Spl001a_ome01:1/2
Spl001a_ome01:6/1 Spl001a_ome01:1/3
Spl001a_ome01:6/1 Spl001a_ome01:1/4
Spl001a_ome01:6/1 Spl001a_ome01:14/1
Spl001a_ome01:6/1 Spl001a_ome01:14/2
Spl001a_ome01:6/1 Spl001a_ome01:2/1
Spl001a_ome01:6/1 Spl001a_ome01:2/2
Spl001a_ome01:6/1 Spl001a_ome01:2/3
Spl001a_ome01:6/1 Spl001a_ome01:2/4
Spl001a_ome01:6/1 Spl001a_ome01:3/1
Spl001a_ome01:6/1 Spl001a_ome01:3/2
Spl001a_ome01:6/1 Spl001a_ome01:3/3
Spl001a_ome01:6/1 Spl001a_ome01:3/4
Spl001a_ome01:6/1 Spl001a_ome01:9/1
Spl001a_ome01:9/1 Ledn001a_ome01:6/1
Spl001a_ome01:9/1 Spl001a_ome01:1/1
Spl001a_ome01:9/1 Spl001a_ome01:1/2
Spl001a_ome01:9/1 Spl001a_ome01:1/3
Spl001a_ome01:9/1 Spl001a_ome01:1/4
Spl001a_ome01:9/1 Spl001a_ome01:14/1
Spl001a_ome01:9/1 Spl001a_ome01:14/2
Spl001a_ome01:9/1 Spl001a_ome01:2/1
Spl001a_ome01:9/1 Spl001a_ome01:2/2
Spl001a_ome01:9/1 Spl001a_ome01:2/3
Spl001a_ome01:9/1 Spl001a_ome01:2/4
Spl001a_ome01:9/1 Spl001a_ome01:3/1
Spl001a_ome01:9/1 Spl001a_ome01:3/2
Spl001a_ome01:9/1 Spl001a_ome01:3/3
Spl001a_ome01:9/1 Spl001a_ome01:3/4
Spl001a_ome01:9/1 Spl001a_ome01:6/1
Tb001a_ome01:1/1 Tb001a_ome01:1/2
Tb001a_ome01:1/1 Tb001a_ome01:1/3
Tb001a_ome01:1/1 Tb001a_ome01:1/4
Tb001a_ome01:1/1 Tb001a_ome01:6/1
Tb001a_ome01:1/1 Tb001a_ome01:9/1
Tb001a_ome01:1/2 Tb001a_ome01:1/1
Tb001a_ome01:1/2 Tb001a_ome01:1/3
Tb001a_ome01:1/2 Tb001a_ome01:1/4
Tb001a_ome01:1/2 Tb001a_ome01:6/1
Tb001a_ome01:1/2 Tb001a_ome01:9/1
Tb001a_ome01:1/3 Tb001a_ome01:1/1
Tb001a_ome01:1/3 Tb001a_ome01:1/2
Tb001a_ome01:1/3 Tb001a_ome01:1/4
Tb001a_ome01:1/3 Tb001a_ome01:6/1
Tb001a_ome01:1/3 Tb001a_ome01:9/1
Tb001a_ome01:1/4 Tb001a_ome01:1/1
Tb001a_ome01:1/4 Tb001a_ome01:1/2
Tb001a_ome01:1/4 Tb001a_ome01:1/3
Tb001a_ome01:1/4 Tb001a_ome01:6/1
Tb001a_ome01:1/4 Tb001a_ome01:9/1
Tb001a_ome01:6/1 Asd001a_ome05:6/1
Tb001a_ome01:6/1 Tb001a_ome01:1/1
Tb001a_ome01:6/1 Tb001a_ome01:1/2
Tb001a_ome01:6/1 Tb001a_ome01:1/3
Tb001a_ome01:6/1 Tb001a_ome01:1/4
Tb001a_ome01:6/1 Tb001a_ome01:9/1
Tb001a_ome01:9/1 Asd002a_ome05:6/1
Tb001a_ome01:9/1 Tb001a_ome01:1/1
Tb001a_ome01:9/1 Tb001a_ome01:1/2
Tb001a_ome01:9/1 Tb001a_ome01:1/3
Tb001a_ome01:9/1 Tb001a_ome01:1/4
Tb001a_ome01:9/1 Tb001a_ome01:6/1
Ut001a_ome01:1/1 Ut001a_ome01:1/2
Ut001a_ome01:1/1 Ut001a_ome01:1/3
Ut001a_ome01:1/1 Ut001a_ome01:1/4
Ut001a_ome01:1/1 Ut001a_ome01:6/1
Ut001a_ome01:1/1 Ut001a_ome01:9/1
Ut001a_ome01:1/2 Ut001a_ome01:1/1
Ut001a_ome01:1/2 Ut001a_ome01:1/3
Ut001a_ome01:1/2 Ut001a_ome01:1/4
Ut001a_ome01:1/2 Ut001a_ome01:6/1
Ut001a_ome01:1/2 Ut001a_ome01:9/1
Ut001a_ome01:1/3 Ut001a_ome01:1/1
Ut001a_ome01:1/3 Ut001a_ome01:1/2
Ut001a_ome01:1/3 Ut001a_ome01:1/4
Ut001a_ome01:1/3 Ut001a_ome01:6/1
Ut001a_ome01:1/3 Ut001a_ome01:9/1
Ut001a_ome01:1/4 Ut001a_ome01:1/1
Ut001a_ome01:1/4 Ut001a_ome01:1/2
Ut001a_ome01:1/4 Ut001a_ome01:1/3
Ut001a_ome01:1/4 Ut001a_ome01:6/1
Ut001a_ome01:1/4 Ut001a_ome01:9/1
Ut001a_ome01:6/1 Asd001a_ome01:3/1
Ut001a_ome01:6/1 Ut001a_ome01:1/1
Ut001a_ome01:6/1 Ut001a_ome01:1/2
Ut001a_ome01:6/1 Ut001a_ome01:1/3
Ut001a_ome01:6/1 Ut001a_ome01:1/4
Ut001a_ome01:6/1 Ut001a_ome01:9/1
Ut001a_ome01:9/1 Asd002a_ome04:5/1
Ut001a_ome01:9/1 Ut001a_ome01:1/1
Ut001a_ome01:9/1 Ut001a_ome01:1/2
Ut001a_ome01:9/1 Ut001a_ome01:1/3
Ut001a_ome01:9/1 Ut001a_ome01:1/4
Ut001a_ome01:9/1 Ut001a_ome01:6/1
Wg001a_ome01:1/1 Wg001a_ome01:1/2
Wg001a_ome01:1/1 Wg001a_ome01:1/3
Wg001a_ome01:1/1 Wg001a_ome01:1/4
Wg001a_ome01:1/1 Wg001a_ome01:2/1
Wg001a_ome01:1/1 Wg001a_ome01:2/2
Wg001a_ome01:1/1 Wg001a_ome01:2/3
Wg001a_ome01:1/1 Wg001a_ome01:2/4
Wg001a_ome01:1/1 Wg001a_ome01:4/1
Wg001a_ome01:1/1 Wg001a_ome01:6/1
Wg001a_ome01:1/1 Wg001a_ome01:9/1
Wg001a_ome01:1/2 Wg001a_ome01:1/1
Wg001a_ome01:1/2 Wg001a_ome01:1/3
Wg001a_ome01:1/2 Wg001a_ome01:1/4
Wg001a_ome01:1/2 Wg001a_ome01:2/1
Wg001a_ome01:1/2 Wg001a_ome01:2/2
Wg001a_ome01:1/2 Wg001a_ome01:2/3
Wg001a_ome01:1/2 Wg001a_ome01:2/4
Wg001a_ome01:1/2 Wg001a_ome01:4/1
Wg001a_ome01:1/2 Wg001a_ome01:6/1
Wg001a_ome01:1/2 Wg001a_ome01:9/1
Wg001a_ome01:1/3 Wg001a_ome01:1/1
Wg001a_ome01:1/3 Wg001a_ome01:1/2
Wg001a_ome01:1/3 Wg001a_ome01:1/4
Wg001a_ome01:1/3 Wg001a_ome01:2/1
Wg001a_ome01:1/3 Wg001a_ome01:2/2
Wg001a_ome01:1/3 Wg001a_ome01:2/3
Wg001a_ome01:1/3 Wg001a_ome01:2/4
Wg001a_ome01:1/3 Wg001a_ome01:4/1
Wg001a_ome01:1/3 Wg001a_ome01:6/1
Wg001a_ome01:1/3 Wg001a_ome01:9/1
Wg001a_ome01:1/4 Wg001a_ome01:1/1
Wg001a_ome01:1/4 Wg001a_ome01:1/2
Wg001a_ome01:1/4 Wg001a_ome01:1/3
Wg001a_ome01:1/4 Wg001a_ome01:2/1
Wg001a_ome01:1/4 Wg001a_ome01:2/2
Wg001a_ome01:1/4 Wg001a_ome01:2/3
Wg001a_ome01:1/4 Wg001a_ome01:2/4
Wg001a_ome01:1/4 Wg001a_ome01:4/1
Wg001a_ome01:1/4 Wg001a_ome01:6/1
Wg001a_ome01:1/4 Wg001a_ome01:9/1
Wg001a_ome01:2/1 Wg001a_ome01:1/1
Wg001a_ome01:2/1 Wg001a_ome01:1/2
Wg001a_ome01:2/1 Wg001a_ome01:1/3
Wg001a_ome01:2/1 Wg001a_ome01:1/4
Wg001a_ome01:2/1 Wg001a_ome01:2/2
Wg001a_ome01:2/1 Wg001a_ome01:2/3
Wg001a_ome01:2/1 Wg001a_ome01:2/4
Wg001a_ome01:2/1 Wg001a_ome01:4/1
Wg001a_ome01:2/1 Wg001a_ome01:6/1
Wg001a_ome01:2/1 Wg001a_ome01:9/1
Wg001a_ome01:2/2 Wg001a_ome01:1/1
Wg001a_ome01:2/2 Wg001a_ome01:1/2
Wg001a_ome01:2/2 Wg001a_ome01:1/3
Wg001a_ome01:2/2 Wg001a_ome01:1/4
Wg001a_ome01:2/2 Wg001a_ome01:2/1
Wg001a_ome01:2/2 Wg001a_ome01:2/3
Wg001a_ome01:2/2 Wg001a_ome01:2/4
Wg001a_ome01:2/2 Wg001a_ome01:4/1
Wg001a_ome01:2/2 Wg001a_ome01:6/1
Wg001a_ome01:2/2 Wg001a_ome01:9/1
Wg001a_ome01:2/3 Wg001a_ome01:1/1
Wg001a_ome01:2/3 Wg001a_ome01:1/2
Wg001a_ome01:2/3 Wg001a_ome01:1/3
Wg001a_ome01:2/3 Wg001a_ome01:1/4
Wg001a_ome01:2/3 Wg001a_ome01:2/1
Wg001a_ome01:2/3 Wg001a_ome01:2/2
Wg001a_ome01:2/3 Wg001a_ome01:2/4
Wg001a_ome01:2/3 Wg001a_ome01:4/1
Wg001a_ome01:2/3 Wg001a_ome01:6/1
Wg001a_ome01:2/3 Wg001a_ome01:9/1
Wg001a_ome01:2/4 Wg001a_ome01:1/1
Wg001a_ome01:2/4 Wg001a_ome01:1/2
Wg001a_ome01:2/4 Wg001a_ome01:1/3
Wg001a_ome01:2/4 Wg001a_ome01:1/4
Wg001a_ome01:2/4 Wg001a_ome01:2/1
Wg001a_ome01:2/4 Wg001a_ome01:2/2
Wg001a_ome01:2/4 Wg001a_ome01:2/3
Wg001a_ome01:2/4 Wg001a_ome01:4/1
Wg001a_ome01:2/4 Wg001a_ome01:6/1
Wg001a_ome01:2/4 Wg001a_ome01:9/1
Wg001a_ome01:4/1 Ed001a_ome01:6/1
Wg001a_ome01:4/1 Wg001a_ome01:1/1
Wg001a_ome01:4/1 Wg001a_ome01:1/2
Wg001a_ome01:4/1 Wg001a_ome01:1/3
Wg001a_ome01:4/1 Wg001a_ome01:1/4
Wg001a_ome01:4/1 Wg001a_ome01:2/1
Wg001a_ome01:4/1 Wg001a_ome01:2/2
Wg001a_ome01:4/1 Wg001a_ome01:2/3
Wg001a_ome01:4/1 Wg001a_ome01:2/4
Wg001a_ome01:4/1 Wg001a_ome01:6/1
Wg001a_ome01:4/1 Wg001a_ome01:9/1
Wg001a_ome01:6/1 Asd001a_ome06:5/1
Wg001a_ome01:6/1 Wg001a_ome01:1/1
Wg001a_ome01:6/1 Wg001a_ome01:1/2
Wg001a_ome01:6/1 Wg001a_ome01:1/3
Wg001a_ome01:6/1 Wg001a_ome01:1/4
Wg001a_ome01:6/1 Wg001a_ome01:2/1
Wg001a_ome01:6/1 Wg001a_ome01:2/2
Wg001a_ome01:6/1 Wg001a_ome01:2/3
Wg001a_ome01:6/1 Wg001a_ome01:2/4
Wg001a_ome01:6/1 Wg001a_ome01:4/1
Wg001a_ome01:6/1 Wg001a_ome01:9/1
Wg001a_ome01:9/1 Asd002a_ome06:5/1
Wg001a_ome01:9/1 Wg001a_ome01:1/1
Wg001a_ome01:9/1 Wg001a_ome01:1/2
Wg001a_ome01:9/1 Wg001a_ome01:1/3
Wg001a_ome01:9/1 Wg001a_ome01:1/4
Wg001a_ome01:9/1 Wg001a_ome01:2/1
Wg001a_ome01:9/1 Wg001a_ome01:2/2
Wg001a_ome01:9/1 Wg001a_ome01:2/3
Wg001a_ome01:9/1 Wg001a_ome01:2/4
Wg001a_ome01:9/1 Wg001a_ome01:4/1
Wg001a_ome01:9/1 Wg001a_ome01:6/1
Ws001a_ome01:14/1 Ws001a_ome01:14/2
Ws001a_ome01:14/1 Ws001a_ome01:9/1
Ws001a_ome01:14/1 Ws001a_ome01:9/2
Ws001a_ome01:14/2 Ws001a_ome01:14/1
Ws001a_ome01:14/2 Ws001a_ome01:9/1
Ws001a_ome01:14/2 Ws001a_ome01:9/2
Ws001a_ome01:9/1 Emn001a_ome01:6/1
Ws001a_ome01:9/1 Ws001a_ome01:14/1
Ws001a_ome01:9/1 Ws001a_ome01:14/2
Ws001a_ome01:9/1 Ws001a_ome01:9/2
Ws001a_ome01:9/2 Emn001a_ome01:6/2
Ws001a_ome01:9/2 Ws001a_ome01:14/1
Ws001a_ome01:9/2 Ws001a_ome01:14/2
Ws001a_ome01:9/2 Ws001a_ome01:9/1
Zl001a_ome01:1/1 Zl001a_ome01:1/2
Zl001a_ome01:1/1 Zl001a_ome01:1/3
Zl001a_ome01:1/1 Zl001a_ome01:1/4
Zl001a_ome01:1/1 Zl001a_ome01:14/1
Zl001a_ome01:1/1 Zl001a_ome01:2/1
Zl001a_ome01:1/1 Zl001a_ome01:2/2
Zl001a_ome01:1/1 Zl001a_ome01:2/3
Zl001a_ome01:1/1 Zl001a_ome01:2/4
Zl001a_ome01:1/1 Zl001a_ome01:3/1
Zl001a_ome01:1/1 Zl001a_ome01:3/2
Zl001a_ome01:1/1 Zl001a_ome01:4/1
Zl001a_ome01:1/1 Zl001a_ome01:4/2
Zl001a_ome01:1/1 Zl001a_ome01:6/1
Zl001a_ome01:1/1 Zl001a_ome01:9/1
Zl001a_ome01:1/2 Zl001a_ome01:1/1
Zl001a_ome01:1/2 Zl001a_ome01:1/3
Zl001a_ome01:1/2 Zl001a_ome01:1/4
Zl001a_ome01:1/2 Zl001a_ome01:14/1
Zl001a_ome01:1/2 Zl001a_ome01:2/1
Zl001a_ome01:1/2 Zl001a_ome01:2/2
Zl001a_ome01:1/2 Zl001a_ome01:2/3
Zl001a_ome01:1/2 Zl001a_ome01:2/4
Zl001a_ome01:1/2 Zl001a_ome01:3/1
Zl001a_ome01:1/2 Zl001a_ome01:3/2
Zl001a_ome01:1/2 Zl001a_ome01:4/1
Zl001a_ome01:1/2 Zl001a_ome01:4/2
Zl001a_ome01:1/2 Zl001a_ome01:6/1
Zl001a_ome01:1/2 Zl001a_ome01:9/1
Zl001a_ome01:1/3 Zl001a_ome01:1/1
Zl001a_ome01:1/3 Zl001a_ome01:1/2
Zl001a_ome01:1/3 Zl001a_ome01:1/4
Zl001a_ome01:1/3 Zl001a_ome01:14/1
Zl001a_ome01:1/3 Zl001a_ome01:2/1
Zl001a_ome01:1/3 Zl001a_ome01:2/2
Zl001a_ome01:1/3 Zl001a_ome01:2/3
Zl001a_ome01:1/3 Zl001a_ome01:2/4
Zl001a_ome01:1/3 Zl001a_ome01:3/1
Zl001a_ome01:1/3 Zl001a_ome01:3/2
Zl001a_ome01:1/3 Zl001a_ome01:4/1
Zl001a_ome01:1/3 Zl001a_ome01:4/2
Zl001a_ome01:1/3 Zl001a_ome01:6/1
Zl001a_ome01:1/3 Zl001a_ome01:9/1
Zl001a_ome01:1/4 Zl001a_ome01:1/1
Zl001a_ome01:1/4 Zl001a_ome01:1/2
Zl001a_ome01:1/4 Zl001a_ome01:1/3
Zl001a_ome01:1/4 Zl001a_ome01:14/1
Zl001a_ome01:1/4 Zl001a_ome01:2/1
Zl001a_ome01:1/4 Zl001a_ome01:2/2
Zl001a_ome01:1/4 Zl001a_ome01:2/3
Zl001a_ome01:1/4 Zl001a_ome01:2/4
Zl001a_ome01:1/4 Zl001a_ome01:3/1
Zl001a_ome01:1/4 Zl001a_ome01:3/2
Zl001a_ome01:1/4 Zl001a_ome01:4/1
Zl001a_ome01:1/4 Zl001a_ome01:4/2
Zl001a_ome01:1/4 Zl001a_ome01:6/1
Zl001a_ome01:1/4 Zl001a_ome01:9/1
Zl001a_ome01:14/1 Zl001a_ome01:1/1
Zl001a_ome01:14/1 Zl001a_ome01:1/2
Zl001a_ome01:14/1 Zl001a_ome01:1/3
Zl001a_ome01:14/1 Zl001a_ome01:1/4
Zl001a_ome01:14/1 Zl001a_ome01:2/1
Zl001a_ome01:14/1 Zl001a_ome01:2/2
Zl001a_ome01:14/1 Zl001a_ome01:2/3
Zl001a_ome01:14/1 Zl001a_ome01:2/4
Zl001a_ome01:14/1 Zl001a_ome01:3/1
Zl001a_ome01:14/1 Zl001a_ome01:3/2
Zl001a_ome01:14/1 Zl001a_ome01:4/1
Zl001a_ome01:14/1 Zl001a_ome01:4/2
Zl001a_ome01:14/1 Zl001a_ome01:6/1
Zl001a_ome01:14/1 Zl001a_ome01:9/1
Zl001a_ome01:2/1 Zl001a_ome01:1/1
Zl001a_ome01:2/1 Zl001a_ome01:1/2
Zl001a_ome01:2/1 Zl001a_ome01:1/3
Zl001a_ome01:2/1 Zl001a_ome01:1/4
Zl001a_ome01:2/1 Zl001a_ome01:14/1
Zl001a_ome01:2/1 Zl001a_ome01:2/2
Zl001a_ome01:2/1 Zl001a_ome01:2/3
Zl001a_ome01:2/1 Zl001a_ome01:2/4
Zl001a_ome01:2/1 Zl001a_ome01:3/1
Zl001a_ome01:2/1 Zl001a_ome01:3/2
Zl001a_ome01:2/1 Zl001a_ome01:4/1
Zl001a_ome01:2/1 Zl001a_ome01:4/2
Zl001a_ome01:2/1 Zl001a_ome01:6/1
Zl001a_ome01:2/1 Zl001a_ome01:9/1
Zl001a_ome01:2/2 Zl001a_ome01:1/1
Zl001a_ome01:2/2 Zl001a_ome01:1/2
Zl001a_ome01:2/2 Zl001a_ome01:1/3
Zl001a_ome01:2/2 Zl001a_ome01:1/4
Zl001a_ome01:2/2 Zl001a_ome01:14/1
Zl001a_ome01:2/2 Zl001a_ome01:2/1
Zl001a_ome01:2/2 Zl001a_ome01:2/3
Zl001a_ome01:2/2 Zl001a_ome01:2/4
Zl001a_ome01:2/2 Zl001a_ome01:3/1
Zl001a_ome01:2/2 Zl001a_ome01:3/2
Zl001a_ome01:2/2 Zl001a_ome01:4/1
Zl001a_ome01:2/2 Zl001a_ome01:4/2
Zl001a_ome01:2/2 Zl001a_ome01:6/1
Zl001a_ome01:2/2 Zl001a_ome01:9/1
Zl001a_ome01:2/3 Zl001a_ome01:1/1
Zl001a_ome01:2/3 Zl001a_ome01:1/2
Zl001a_ome01:2/3 Zl001a_ome01:1/3
Zl001a_ome01:2/3 Zl001a_ome01:1/4
Zl001a_ome01:2/3 Zl001a_ome01:14/1
Zl001a_ome01:2/3 Zl001a_ome01:2/1
Zl001a_ome01:2/3 Zl001a_ome01:2/2
Zl001a_ome01:2/3 Zl001a_ome01:2/4
Zl001a_ome01:2/3 Zl001a_ome01:3/1
Zl001a_ome01:2/3 Zl001a_ome01:3/2
Zl001a_ome01:2/3 Zl001a_ome01:4/1
Zl001a_ome01:2/3 Zl001a_ome01:4/2
Zl001a_ome01:2/3 Zl001a_ome01:6/1
Zl001a_ome01:2/3 Zl001a_ome01:9/1
Zl001a_ome01:2/4 Zl001a_ome01:1/1
Zl001a_ome01:2/4 Zl001a_ome01:1/2
Zl001a_ome01:2/4 Zl001a_ome01:1/3
Zl001a_ome01:2/4 Zl001a_ome01:1/4
Zl001a_ome01:2/4 Zl001a_ome01:14/1
Zl001a_ome01:2/4 Zl001a_ome01:2/1
Zl001a_ome01:2/4 Zl001a_ome01:2/2
Zl001a_ome01:2/4 Zl001a_ome01:2/3
Zl001a_ome01:2/4 Zl001a_ome01:3/1
Zl001a_ome01:2/4 Zl001a_ome01:3/2
Zl001a_ome01:2/4 Zl001a_ome01:4/1
Zl001a_ome01:2/4 Zl001a_ome01:4/2
Zl001a_ome01:2/4 Zl001a_ome01:6/1
Zl001a_ome01:2/4 Zl001a_ome01:9/1
Zl001a_ome01:3/1 Zl001a_ome01:1/1
Zl001a_ome01:3/1 Zl001a_ome01:1/2
Zl001a_ome01:3/1 Zl001a_ome01:1/3
Zl001a_ome01:3/1 Zl001a_ome01:1/4
Zl001a_ome01:3/1 Zl001a_ome01:14/1
Zl001a_ome01:3/1 Zl001a_ome01:2/1
Zl001a_ome01:3/1 Zl001a_ome01:2/2
Zl001a_ome01:3/1 Zl001a_ome01:2/3
Zl001a_ome01:3/1 Zl001a_ome01:2/4
Zl001a_ome01:3/1 Zl001a_ome01:3/2
Zl001a_ome01:3/1 Zl001a_ome01:4/1
Zl001a_ome01:3/1 Zl001a_ome01:4/2
Zl001a_ome01:3/1 Zl001a_ome01:6/1
Zl001a_ome01:3/1 Zl001a_ome01:9/1
Zl001a_ome01:3/2 Zl001a_ome01:1/1
Zl001a_ome01:3/2 Zl001a_ome01:1/2
Zl001a_ome01:3/2 Zl001a_ome01:1/3
Zl001a_ome01:3/2 Zl001a_ome01:1/4
Zl001a_ome01:3/2 Zl001a_ome01:14/1
Zl001a_ome01:3/2 Zl001a_ome01:2/1
Zl001a_ome01:3/2 Zl001a_ome01:2/2
Zl001a_ome01:3/2 Zl001a_ome01:2/3
Zl001a_ome01:3/2 Zl001a_ome01:2/4
Zl001a_ome01:3/2 Zl001a_ome01:3/1
Zl001a_ome01:3/2 Zl001a_ome01:4/1
Zl001a_ome01:3/2 Zl001a_ome01:4/2
Zl001a_ome01:3/2 Zl001a_ome01:6/1
Zl001a_ome01:3/2 Zl001a_ome01:9/1
Zl001a_ome01:4/1 Mp001a_ome01:9/1
Zl001a_ome01:4/1 Zl001a_ome01:1/1
Zl001a_ome01:4/1 Zl001a_ome01:1/2
Zl001a_ome01:4/1 Zl001a_ome01:1/3
Zl001a_ome01:4/1 Zl001a_ome01:1/4
Zl001a_ome01:4/1 Zl001a_ome01:14/1
Zl001a_ome01:4/1 Zl001a_ome01:2/1
Zl001a_ome01:4/1 Zl001a_ome01:2/2
Zl001a_ome01:4/1 Zl001a_ome01:2/3
Zl001a_ome01:4/1 Zl001a_ome01:2/4
Zl001a_ome01:4/1 Zl001a_ome01:3/1
Zl001a_ome01:4/1 Zl001a_ome01:3/2
Zl001a_ome01:4/1 Zl001a_ome01:4/2
Zl001a_ome01:4/1 Zl001a_ome01:6/1
Zl001a_ome01:4/1 Zl001a_ome01:9/1
Zl001a_ome01:4/2 Mp001a_ome01:9/2
Zl001a_ome01:4/2 Zl001a_ome01:1/1
Zl001a_ome01:4/2 Zl001a_ome01:1/2
Zl001a_ome01:4/2 Zl001a_ome01:1/3
Zl001a_ome01:4/2 Zl001a_ome01:1/4
Zl001a_ome01:4/2 Zl001a_ome01:14/1
Zl001a_ome01:4/2 Zl001a_ome01:2/1
Zl001a_ome01:4/2 Zl001a_ome01:2/2
Zl001a_ome01:4/2 Zl001a_ome01:2/3
Zl001a_ome01:4/2 Zl001a_ome01:2/4
Zl001a_ome01:4/2 Zl001a_ome01:3/1
Zl001a_ome01:4/2 Zl001a_ome01:3/2
Zl001a_ome01:4/2 Zl001a_ome01:4/1
Zl001a_ome01:4/2 Zl001a_ome01:6/1
Zl001a_ome01:4/2 Zl001a_ome01:9/1
Zl001a_ome01:6/1 Asd001a_ome06:6/1
Zl001a_ome01:6/1 Zl001a_ome01:1/1
Zl001a_ome01:6/1 Zl001a_ome01:1/2
Zl001a_ome01:6/1 Zl001a_ome01:1/3
Zl001a_ome01:6/1 Zl001a_ome01:1/4
Zl001a_ome01:6/1 Zl001a_ome01:14/1
Zl001a_ome01:6/1 Zl001a_ome01:2/1
Zl001a_ome01:6/1 Zl001a_ome01:2/2
Zl001a_ome01:6/1 Zl001a_ome01:2/3
Zl001a_ome01:6/1 Zl001a_ome01:2/4
Zl001a_ome01:6/1 Zl001a_ome01:3/1
Zl001a_ome01:6/1 Zl001a_ome01:3/2
Zl001a_ome01:6/1 Zl001a_ome01:4/1
Zl001a_ome01:6/1 Zl001a_ome01:4/2
Zl001a_ome01:6/1 Zl001a_ome01:9/1
Zl001a_ome01:9/1 Ap001a_ome01:6/1
Zl001a_ome01:9/1 Zl001a_ome01:1/1
Zl001a_ome01:9/1 Zl001a_ome01:1/2
Zl001a_ome01:9/1 Zl001a_ome01:1/3
Zl001a_ome01:9/1 Zl001a_ome01:1/4
Zl001a_ome01:9/1 Zl001a_ome01:14/1
Zl001a_ome01:9/1 Zl001a_ome01:2/1
Zl001a_ome01:9/1 Zl001a_ome01:2/2
Zl001a_ome01:9/1 Zl001a_ome01:2/3
Zl001a_ome01:9/1 Zl001a_ome01:2/4
Zl001a_ome01:9/1 Zl001a_ome01:3/1
Zl001a_ome01:9/1 Zl001a_ome01:3/2
Zl001a_ome01:9/1 Zl001a_ome01:4/1
Zl001a_ome01:9/1 Zl001a_ome01:4/2
Zl001a_ome01:9/1 Zl001a_ome01:6/1
