use v5.40;
use feature 'class';
no warnings 'experimental::class';

our $VERSION = '0.01';

class Daje::Generate::Database::SqlLite {
    use DBI;

    field $dbh ;
    field $data_dir :reader;
    field $path :param;

    method get_dbh() {
        unless (defined $dbh) {
            $self->_open_database();
        }
        return $dbh;
    }

    method _open_database() {
        my $new = $self->_datadir();
        $self->_open();
        $self->_add_table();
    }

    method _add_table(){
        my $script = $self->_table_script();
        my $sth = $dbh->prepare($script) or die "Couldn't create table: " . $dbh->errstr;;
        $sth->execute() or die "Couldn't create table: " . $dbh->errstr;;;
    }

    method _open(){
        my $dbfile = $data_dir .'/generate.db';
        $dbh = DBI->connect("dbi:SQLite:dbname=$dbfile","","",
            {
                PrintError => 1, AutoCommit => 1
            }
        ) or die $DBI::errstr;
    }

    method _datadir() {
        my $new = 0;
        try {
            $data_dir = $path->dirname . "/data";
            if (!(-d $data_dir)) {
                mkdir("$data_dir", 0700);
                $new = 1;
            }
        } catch ($e) {
            die "Failed creating datadir '$e";
        };

        return $new
    }

    method _table_script() {
        return qq{
            CREATE TABLE IF NOT EXISTS file_hashes (
                file text PRIMARY KEY,
                hash text NOT NULL,
                moddatetime text
            );
        };
    }
}


1;



#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

lib::Daje::Generate::Database::SqlLite - lib::Daje::Generate::Database::SqlLite


=head1 DESCRIPTION

pod generated by Pod::Autopod - keep this line to make pod updates possible ####################


=head1 REQUIRES

L<DBI> 

L<feature> 

L<v5.40> 


=head1 METHODS


=cut

