use v5.40;
use feature 'class';
no warnings 'experimental::class';

our $VERSION = '0.01';

class Daje::Generate::Perl::Generate::BaseClass {
    field $config :param;
    field $template :param;

    method generate() {
        my $tpl = $template->get_data_section('baseclass');

        my $base_name_space = $config->{CLASS}->{base_name_space};

        my $date = localtime();
        $tpl =~ s/<<date>>/$date/ig;
        $tpl =~ s/<<base_name_space>>/$base_name_space/ig;

        my $output = Daje::Generate::Output::Perl::Class->new(
            config         => $config,
            table_name     => "Base",
            perl           => $tpl,
            name_space_dir => "base_space_dir",
        );
        $output->save_file();
    }
}


1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

lib::Daje::Generate::Perl::Generate::BaseClass - lib::Daje::Generate::Perl::Generate::BaseClass


=head1 REQUIRES

L<feature> 

L<v5.40> 


=head1 METHODS


=cut

