use v5.40;
use feature 'class';
no warnings 'experimental::class';

our $VERSION = '0.01';

class Daje::Generate::Output::Perl::Class {
    use Mojo::File;
    use String::CamelCase qw(camelize);

    field $config :param ;
    field $table_name :param;
    field $perl :param;
    field $name_space_dir :param;

    method save_file() {

        my $filename = $self->_create_new_filename();
        try {
            open (my $fh, ">", $filename) or die "Could not open file '$filename";
            print $fh $perl;
            close $fh;
        } catch ($e) {
            die "Daje::Generate::Output::Perl::Class::save_file '$e'"
        };

        return;
    }

    method _create_new_filename() {
        my $filename;

        try {
            $filename = $config->{PATH}->{$name_space_dir} . camelize($table_name) . ".pm";
        } catch ($e) {
            die "Daje::Generate::Output::Perl::Class::create_new_filename failed '$e'";
        };

        return $filename;
    }
}


1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

lib::Daje::Generate::Output::Perl::Class - lib::Daje::Generate::Output::Perl::Class


=head1 REQUIRES

L<String::CamelCase> 

L<Mojo::File> 

L<feature> 

L<v5.40> 


=head1 METHODS


=cut

