use v5.40;
use feature 'class';
no warnings 'experimental::class';

our $VERSION = '0.01';

class Daje::Generate::Tools::FileChanged {
    use Daje::Generate::Tools::SqlLite;
    use Digest::SHA qw(sha256_hex);
    use Mojo::File;
    use DBI;

    field $database;
    method is_file_changed($file_path_name, $path) {
        my $result = 0;
        $path = Mojo::File->new($file_path_name);
        $self->open_database();
        my $new_hash = $self->load_new_hash($path);
        my $old_hash = $database->load_hash($file_path_name);
        if ($new_hash ne $old_hash) {
            $result = 1;
        }
        return $result;
    }

    method open_database() {
        if (!defined $database) {
            $database = Daje::Generate::Tools::SqlLite->new(
                path  => $path
            );
            $database->open_database();
        }
    }


    method load_new_hash() {

        my $file_content = $path->slurp;
        my $hash = sha256_hex($file_content);

        return $hash;
    }
}


1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

lib::Daje::Generate::Tools::FileChanged - lib::Daje::Generate::Tools::FileChanged


=head1 REQUIRES

L<DBI> 

L<Mojo::File> 

L<Digest::SHA> 

L<Daje::Generate::Tools::SqlLite> 

L<feature> 

L<v5.40> 


=head1 METHODS


=cut

