#!/usr/bin/perl

# Test if WSSE authentication not provided.
use strict;
use warnings;
use English qw( -no_match_vars );
use Test::More tests => 1;
use Test::WWW::Mechanize::CGIApp;
use lib 't/lib';
use Test::WSSE;

my $mech = Test::WWW::Mechanize::CGIApp->new;

$mech->app(
    sub {
            my $app = Test::WSSE->new(PARAMS => { });
            $app->run();
        }
);

$mech->get('http://localhost');
is($mech->status, 401, 'authentication required');

# cleanup
END {

    if (-f 'log') {
        unlink 'log';
    }
}
