use t::TestModuleCompile tests => 1;

use lib 't/lib';

BEGIN { unlink 't/lib/Foo.pmc' }

use Foo;

run_is module => 'pmc';

sub fixup {
    s/0\.\d\d/0.XX/;
    s/0x[0-9A-Fa-f]{4,8}/0xXXXXXXXX/;
}

__DATA__
=== Compile Foo.pm to Foo.pmc
--- module read_file fixup: t/lib/Foo.pmc
--- pmc -trim
# Generated by Indented 0 (Module::Compile 0.XX) - do not edit!
##################((( 32-bit Checksum Validator )))##################
BEGIN { use 5.006; local (*F, $/); ($F = __FILE__) =~ s!c$!!; open(F)
or die "Cannot open $F: $!"; binmode(F, ':crlf'); unpack('%32N*',<F>)
== 0xXXXXXXXX or die "Checksum failed for outdated .pmc file: ${F}c"}
#####################################################################
package Foo;


sub greetings {
    print "Hello " . shift;
}

sub farewell {
    print "Goodbye " . shift;
}

1;

__END__

