/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.KeyDownAction;
import org.openqa.selenium.interactions.KeyUpAction;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.internal.KeysRelatedAction;
import org.openqa.selenium.interactions.internal.MultiAction;
import org.openqa.selenium.internal.Locatable;

public class SendKeysAction
extends KeysRelatedAction
implements Action,
MultiAction {
    private final CharSequence[] keysToSend;

    public SendKeysAction(Keyboard keyboard, Mouse mouse, Locatable locationProvider, CharSequence ... keysToSend) {
        super(keyboard, mouse, locationProvider);
        this.keysToSend = keysToSend;
    }

    public SendKeysAction(Keyboard keyboard, Mouse mouse, CharSequence ... keysToSend) {
        this(keyboard, mouse, (Locatable)null, keysToSend);
    }

    @Override
    public void perform() {
        this.focusOnElement();
        this.keyboard.sendKeys(this.keysToSend);
    }

    @Override
    public List<Action> getActions() {
        ArrayList<Action> actions2 = new ArrayList<Action>();
        CharSequence[] charSequenceArray = this.keysToSend;
        int n = this.keysToSend.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence chars = charSequenceArray[n2];
            int i = 0;
            while (i < chars.length()) {
                Keys key = Keys.getKeyFromUnicode(chars.charAt(i));
                actions2.add(new KeyDownAction(this.keyboard, this.mouse, this.where, key));
                actions2.add(new KeyUpAction(this.keyboard, this.mouse, this.where, key));
                ++i;
            }
            ++n2;
        }
        return actions2;
    }
}

