/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.IO;
import org.openqa.jetty.util.LogSupport;

public class HttpTunnel {
    private static Log log = LogFactory.getLog(HttpTunnel.class);
    private Thread _thread;
    private int _timeoutMs;
    private Socket _socket;
    private InputStream _sIn;
    private OutputStream _sOut;
    private InputStream _in;
    private OutputStream _out;

    protected HttpTunnel() {
    }

    public HttpTunnel(Socket socket, InputStream in, OutputStream out) throws IOException {
        this._socket = socket;
        this._sIn = in;
        this._sOut = out;
        if (this._sIn == null) {
            this._sIn = this._socket.getInputStream();
        }
        if (this._sOut == null) {
            this._sOut = socket.getOutputStream();
        }
        this._timeoutMs = 30000;
    }

    public void handle(InputStream in, OutputStream out) {
        Copy copy = new Copy();
        this._in = in;
        this._out = out;
        try {
            try {
                this._thread = Thread.currentThread();
                copy.start();
                this.copydata(this._sIn, this._out);
            }
            catch (Exception e) {
                LogSupport.ignore(log, e);
                try {
                    this._in.close();
                    if (this._socket != null) {
                        this._socket.shutdownOutput();
                        this._socket.close();
                    } else {
                        this._sIn.close();
                        this._sOut.close();
                    }
                }
                catch (Exception e2) {
                    LogSupport.ignore(log, e2);
                }
                copy.interrupt();
            }
        }
        finally {
            try {
                this._in.close();
                if (this._socket != null) {
                    this._socket.shutdownOutput();
                    this._socket.close();
                } else {
                    this._sIn.close();
                    this._sOut.close();
                }
            }
            catch (Exception e) {
                LogSupport.ignore(log, e);
            }
            copy.interrupt();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copydata(InputStream in, OutputStream out) throws IOException {
        long timestamp = 0L;
        long byteCount = 0L;
        while (true) {
            try {
                do {
                    byteCount = HttpTunnel.copyBytes(in, out, -1L);
                    timestamp = 0L;
                } while (byteCount != -1L);
                return;
            }
            catch (InterruptedIOException e) {
                LogSupport.ignore(log, e);
                if (timestamp == 0L) {
                    timestamp = System.currentTimeMillis();
                    continue;
                }
                if (this._timeoutMs > 0 && System.currentTimeMillis() - timestamp > (long)this._timeoutMs) throw e;
                continue;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static int copyBytes(InputStream in, OutputStream out, long byteCount) throws IOException {
        block10: {
            buffer = new byte[IO.bufferSize];
            len = IO.bufferSize;
            totalCount = 0;
            if (byteCount < 0L) ** GOTO lbl36
            totalCount = (int)byteCount;
            while (byteCount > 0L) {
                try {
                    len = byteCount < (long)IO.bufferSize ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, IO.bufferSize);
                    if (len == -1 && (long)totalCount == byteCount) {
                        totalCount = (int)byteCount - 1;
                    }
                }
                catch (InterruptedIOException e) {
                    if ((long)totalCount == byteCount) {
                        throw e;
                    }
                    LogSupport.ignore(HttpTunnel.log, e);
                    len = 0;
                }
                if (len <= 0) break;
                byteCount -= (long)len;
                out.write(buffer, 0, len);
            }
            totalCount = (int)((long)totalCount - byteCount);
            break block10;
lbl-1000:
            // 1 sources

            {
                try {
                    len = in.read(buffer, 0, IO.bufferSize);
                    if (len == -1 && totalCount == 0) {
                        totalCount = -1;
                    }
                }
                catch (InterruptedIOException e) {
                    if (totalCount == 0) {
                        throw e;
                    }
                    LogSupport.ignore(HttpTunnel.log, e);
                    len = 0;
                }
                if (len <= 0) continue;
                out.write(buffer, 0, len);
                totalCount += len;
lbl36:
                // 3 sources

                ** while (len > 0)
            }
        }
        return totalCount;
    }

    public Socket getSocket() {
        return this._socket;
    }

    public int getTimeoutMs() {
        return this._timeoutMs;
    }

    public void setTimeoutMs(int timeoutMs) {
        this._timeoutMs = timeoutMs;
    }

    private class Copy
    extends Thread {
        private Copy() {
        }

        @Override
        public void run() {
            try {
                try {
                    HttpTunnel.this.copydata(HttpTunnel.this._in, HttpTunnel.this._sOut);
                }
                catch (Exception e) {
                    LogSupport.ignore(log, e);
                    try {
                        HttpTunnel.this._out.close();
                        if (HttpTunnel.this._socket != null) {
                            HttpTunnel.this._socket.shutdownInput();
                            HttpTunnel.this._socket.close();
                        } else {
                            HttpTunnel.this._sOut.close();
                            HttpTunnel.this._sIn.close();
                        }
                    }
                    catch (Exception e2) {
                        LogSupport.ignore(log, e2);
                    }
                    HttpTunnel.this._thread.interrupt();
                }
            }
            finally {
                try {
                    HttpTunnel.this._out.close();
                    if (HttpTunnel.this._socket != null) {
                        HttpTunnel.this._socket.shutdownInput();
                        HttpTunnel.this._socket.close();
                    } else {
                        HttpTunnel.this._sOut.close();
                        HttpTunnel.this._sIn.close();
                    }
                }
                catch (Exception e) {
                    LogSupport.ignore(log, e);
                }
                HttpTunnel.this._thread.interrupt();
            }
        }
    }
}

