/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.NamedNodeMap;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.ClientRect;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMTokenList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.EventNode;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClasses(value={@JsxClass(domClass=DomElement.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)}), @JsxClass(isJSObject=false, domClass=DomElement.class, browsers={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})})
public class Element
extends EventNode {
    private NamedNodeMap attributes_;
    private Map<String, HTMLCollection> elementsByTagName_;
    private CSSStyleDeclaration style_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public Element() {
    }

    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        this.style_ = new CSSStyleDeclaration(this);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public HTMLCollection selectNodes(final String expression) {
        final DomElement domNode = this.getDomNodeOrDie();
        boolean attributeChangeSensitive = expression.contains("@");
        String description = "Element.selectNodes('" + expression + "')";
        HTMLCollection collection = new HTMLCollection(domNode, attributeChangeSensitive, description){

            @Override
            protected List<Object> computeElements() {
                return new ArrayList<Object>(domNode.getByXPath(expression));
            }
        };
        return collection;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public Object selectSingleNode(String expression) {
        HTMLCollection collection = this.selectNodes(expression);
        if (collection.getLength() > 0) {
            return collection.get(0, (Scriptable)collection);
        }
        return null;
    }

    @JsxGetter
    public String getTagName() {
        return this.getNodeName();
    }

    @Override
    @JsxGetter
    public Object getAttributes() {
        if (this.attributes_ == null) {
            this.attributes_ = this.createAttributesObject();
        }
        return this.attributes_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public String getBaseURI() {
        return this.getDomNodeOrDie().getPage().getUrl().toExternalForm();
    }

    protected NamedNodeMap createAttributesObject() {
        return new NamedNodeMap(this.getDomNodeOrDie());
    }

    @JsxFunction
    public Object getAttribute(String attributeName, Integer flags) {
        attributeName = this.fixAttributeName(attributeName);
        HtmlPage htmlPage = this.getDomNodeOrDie().getHtmlPageOrNull();
        boolean supportsFlags = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_GET_ATTRIBUTE_SUPPORTS_FLAGS_IN_QUIRKS_MODE) && htmlPage != null && htmlPage.isQuirksMode();
        Object value = supportsFlags && flags != null && flags == 2 && "style".equalsIgnoreCase(attributeName) ? "" : this.getDomNodeOrDie().getAttribute(attributeName);
        if (value == DomElement.ATTRIBUTE_NOT_DEFINED) {
            value = null;
            if (supportsFlags) {
                for (Scriptable object = this; object != null; object = object.getPrototype()) {
                    Object property = object.get(attributeName, (Scriptable)this);
                    if (property == NOT_FOUND) continue;
                    value = property;
                    break;
                }
            }
        }
        return value;
    }

    protected String fixAttributeName(String attributeName) {
        return attributeName;
    }

    @JsxFunction
    public void setAttribute(String name, String value) {
        this.getDomNodeOrDie().setAttribute(name, value);
    }

    @JsxFunction
    public HTMLCollection getElementsByTagName(String tagName) {
        HTMLCollection collection;
        final String tagNameLC = tagName.toLowerCase(Locale.ENGLISH);
        if (this.elementsByTagName_ == null) {
            this.elementsByTagName_ = new HashMap<String, HTMLCollection>();
        }
        if ((collection = this.elementsByTagName_.get(tagNameLC)) != null) {
            return collection;
        }
        DomElement node = this.getDomNodeOrDie();
        String description = "Element.getElementsByTagName('" + tagNameLC + "')";
        collection = "*".equals(tagName) ? new HTMLCollection(node, false, description){

            @Override
            protected boolean isMatching(DomNode node) {
                return true;
            }
        } : new HTMLCollection(node, false, description){

            @Override
            protected boolean isMatching(DomNode node) {
                return tagNameLC.equalsIgnoreCase(node.getNodeName());
            }
        };
        this.elementsByTagName_.put(tagName, collection);
        return collection;
    }

    @JsxFunction
    public Object getAttributeNode(String name) {
        Map<String, DomAttr> attributes = this.getDomNodeOrDie().getAttributesMap();
        for (DomAttr attr : attributes.values()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getScriptObject();
        }
        return null;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public String getText() {
        StringBuilder buffer = new StringBuilder();
        this.toText(this.getDomNodeOrDie(), buffer);
        return buffer.toString();
    }

    private void toText(DomNode node, StringBuilder buffer) {
        switch (node.getNodeType()) {
            case 10: 
            case 12: {
                return;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                buffer.append(node.getNodeValue());
                break;
            }
        }
        for (DomNode child : node.getChildren()) {
            switch (child.getNodeType()) {
                case 1: {
                    this.toText(child, buffer);
                    break;
                }
                case 3: 
                case 4: {
                    buffer.append(child.getNodeValue());
                    break;
                }
            }
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public Object getElementsByTagNameNS(Object namespaceURI, final String localName) {
        String description = "Element.getElementsByTagNameNS('" + namespaceURI + "', '" + localName + "')";
        HTMLCollection collection = new HTMLCollection(this.getDomNodeOrDie(), false, description){

            @Override
            protected boolean isMatching(DomNode node) {
                return localName.equals(node.getLocalName());
            }
        };
        return collection;
    }

    @JsxFunction
    public boolean hasAttribute(String name) {
        return this.getDomNodeOrDie().hasAttribute(name);
    }

    public DomElement getDomNodeOrDie() {
        return (DomElement)super.getDomNodeOrDie();
    }

    @JsxFunction
    public void removeAttribute(String name) {
        this.getDomNodeOrDie().removeAttribute(name);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ELEMENT_REMOVE_ATTRIBUTE_REMOVES_PROPERTY)) {
            this.delete(name);
        }
    }

    @JsxFunction
    public ClientRect getBoundingClientRect() {
        return null;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public int getChildElementCount() {
        return this.getDomNodeOrDie().getChildElementCount();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public Element getFirstElementChild() {
        DomElement child = this.getDomNodeOrDie().getFirstElementChild();
        if (child != null) {
            return (Element)child.getScriptObject();
        }
        return null;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public Element getLastElementChild() {
        DomElement child = this.getDomNodeOrDie().getLastElementChild();
        if (child != null) {
            return (Element)child.getScriptObject();
        }
        return null;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public Element getNextElementSibling() {
        DomElement child = this.getDomNodeOrDie().getNextElementSibling();
        if (child != null) {
            return (Element)child.getScriptObject();
        }
        return null;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public Element getPreviousElementSibling() {
        DomElement child = this.getDomNodeOrDie().getPreviousElementSibling();
        if (child != null) {
            return (Element)child.getScriptObject();
        }
        return null;
    }

    @Override
    public Element getParentElement() {
        Node parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof Element); parent = parent.getParent()) {
        }
        return (Element)parent;
    }

    public void setDefaults(ComputedCSSStyleDeclaration style) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public HTMLCollection getChildren() {
        final DomElement node = this.getDomNodeOrDie();
        HTMLCollection collection = new HTMLCollection(node, false, "Element.children"){

            @Override
            protected List<Object> computeElements() {
                LinkedList<Object> children = new LinkedList<Object>();
                Iterator i$ = node.getChildNodes().iterator();
                while (i$.hasNext()) {
                    DomNode domNode = (DomNode)i$.next();
                    if (!(domNode instanceof DomElement)) continue;
                    children.add(domNode);
                }
                return children;
            }
        };
        return collection;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public DOMTokenList getClassList() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ELEMENT_CLASS_LIST_NULL)) {
            return null;
        }
        return new DOMTokenList(this, "class");
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public String getAttributeNS(String namespaceURI, String localName) {
        return this.getDomNodeOrDie().getAttributeNS(namespaceURI, localName);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getDomNodeOrDie().hasAttributeNS(namespaceURI, localName);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        this.getDomNodeOrDie().setAttributeNS(namespaceURI, qualifiedName, value);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void removeAttributeNS(String namespaceURI, String localName) {
        this.getDomNodeOrDie().removeAttributeNS(namespaceURI, localName);
    }

    @JsxGetter
    public CSSStyleDeclaration getStyle() {
        return this.style_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public CSSStyleDeclaration getRuntimeStyle() {
        return this.style_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public ComputedCSSStyleDeclaration getCurrentStyle() {
        if (!this.getDomNodeOrDie().isDirectlyAttachedToPage()) {
            return null;
        }
        return this.getWindow().getComputedStyle(this, null);
    }

    @JsxFunction
    public Attr setAttributeNode(Attr newAtt) {
        String name = newAtt.getName();
        NamedNodeMap nodes = (NamedNodeMap)this.getAttributes();
        Attr replacedAtt = (Attr)nodes.getNamedItemWithoutSytheticClassAttr(name);
        if (replacedAtt != null) {
            replacedAtt.detachFromParent();
        }
        DomAttr newDomAttr = newAtt.getDomNodeOrDie();
        this.getDomNodeOrDie().setAttributeNode(newDomAttr);
        return replacedAtt;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME)})
    public void blur() {
        DomElement domNode = this.getDomNodeOrDie();
        if (domNode instanceof HtmlElement) {
            ((HtmlElement)domNode).blur();
        }
    }
}

