/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.activex.javascript.msxml;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.MSXMLScriptable;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMDocument;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.auth.UsernamePasswordCredentials;

@JsxClass(browsers={@WebBrowser(value=BrowserName.IE)})
public class XMLHTTPRequest
extends MSXMLScriptable {
    private static final Log LOG = LogFactory.getLog(XMLHTTPRequest.class);
    public static final int STATE_UNSENT = 0;
    public static final int STATE_OPENED = 1;
    public static final int STATE_HEADERS_RECEIVED = 2;
    public static final int STATE_LOADING = 3;
    public static final int STATE_DONE = 4;
    private static final String HEADER_ORIGIN = "Origin";
    private static final char REQUEST_HEADERS_SEPARATOR = ',';
    private static final String HEADER_ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    private static final String HEADER_ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    private static final String HEADER_ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String HEADER_ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String ALLOW_ORIGIN_ALL = "*";
    private static final String[] ALL_PROPERTIES_ = new String[]{"onreadystatechange", "readyState", "responseText", "responseXML", "status", "statusText", "abort", "getAllResponseHeaders", "getResponseHeader", "open", "send", "setRequestHeader"};
    private static Collection<String> PROHIBITED_HEADERS_ = Arrays.asList("accept-charset", "accept-encoding", "connection", "content-length", "cookie", "cookie2", "content-transfer-encoding", "date", "expect", "host", "keep-alive", "referer", "te", "trailer", "transfer-encoding", "upgrade", "user-agent", "via");
    private int state_ = 0;
    private Function stateChangeHandler_;
    private WebRequest webRequest_;
    private boolean async_;
    private int jobID_;
    private WebResponse webResponse_;
    private HtmlPage containingPage_;
    private boolean openedMultipleTimes_;
    private boolean sent_;

    @JsxConstructor
    public XMLHTTPRequest() {
    }

    @JsxGetter
    public Object getOnreadystatechange() {
        if (this.stateChangeHandler_ == null) {
            return Undefined.instance;
        }
        return this.stateChangeHandler_;
    }

    @JsxSetter
    public void setOnreadystatechange(Function stateChangeHandler) {
        this.stateChangeHandler_ = stateChangeHandler;
        if (this.state_ == 1) {
            this.setState(this.state_, null);
        }
    }

    private void setState(int state, Context context) {
        this.state_ = state;
        if (this.stateChangeHandler_ != null && !this.openedMultipleTimes_) {
            Scriptable scope = this.stateChangeHandler_.getParentScope();
            JavaScriptEngine jsEngine = this.containingPage_.getWebClient().getJavaScriptEngine();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Calling onreadystatechange handler for state " + state);
            }
            Object[] params = ArrayUtils.EMPTY_OBJECT_ARRAY;
            jsEngine.callFunction(this.containingPage_, this.stateChangeHandler_, scope, this, params);
            if (LOG.isDebugEnabled()) {
                if (context == null) {
                    context = Context.getCurrentContext();
                }
                LOG.debug("onreadystatechange handler: " + context.decompileFunction(this.stateChangeHandler_, 4));
                LOG.debug("Calling onreadystatechange handler for state " + state + ". Done.");
            }
        }
    }

    @JsxGetter
    public int getReadyState() {
        return this.state_;
    }

    @JsxGetter
    public String getResponseText() {
        if (this.state_ == 0) {
            throw Context.reportRuntimeError("The data necessary to complete this operation is not yet available (request not opened).");
        }
        if (this.state_ != 4) {
            throw Context.reportRuntimeError("Unspecified error (request not sent).");
        }
        if (this.webResponse_ != null) {
            return this.webResponse_.getContentAsString();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("XMLHTTPRequest.responseText was retrieved before the response was available.");
        }
        return "";
    }

    @JsxGetter
    public Object getResponseXML() {
        String contentType;
        if (this.state_ == 0) {
            throw Context.reportRuntimeError("Unspecified error (request not opened).");
        }
        if (this.state_ == 4 && this.webResponse_ != null && !(this.webResponse_ instanceof NetworkErrorWebResponse) && (contentType = this.webResponse_.getContentType()).contains("xml")) {
            try {
                XmlPage page = new XmlPage(this.webResponse_, this.getWindow().getWebWindow(), true, false);
                XMLDOMDocument doc = new XMLDOMDocument();
                doc.setDomNode(page);
                doc.setPrototype(this.getPrototype(doc.getClass()));
                doc.setEnvironment(this.getEnvironment());
                doc.setParentScope(this.getWindow());
                return doc;
            }
            catch (IOException e) {
                LOG.warn("Failed parsing XML document " + this.webResponse_.getWebRequest().getUrl() + ": " + e.getMessage());
                return null;
            }
        }
        XMLDOMDocument doc = new XMLDOMDocument(this.getWindow().getWebWindow());
        doc.setPrototype(this.getPrototype(doc.getClass()));
        doc.setEnvironment(this.getEnvironment());
        return doc;
    }

    @JsxGetter
    public int getStatus() {
        if (this.state_ != 4) {
            throw Context.reportRuntimeError("Unspecified error (request not sent).");
        }
        if (this.webResponse_ != null) {
            return this.webResponse_.getStatusCode();
        }
        LOG.error("XMLHTTPRequest.status was retrieved without a response available (readyState: " + this.state_ + ").");
        return 0;
    }

    @JsxGetter
    public String getStatusText() {
        if (this.state_ != 4) {
            throw Context.reportRuntimeError("Unspecified error (request not sent).");
        }
        if (this.webResponse_ != null) {
            return this.webResponse_.getStatusMessage();
        }
        LOG.error("XMLHTTPRequest.statusText was retrieved without a response available (readyState: " + this.state_ + ").");
        return null;
    }

    @JsxFunction
    public void abort() {
        this.getWindow().getWebWindow().getJobManager().stopJob(this.jobID_);
        this.setState(0, Context.getCurrentContext());
    }

    @JsxFunction
    public String getAllResponseHeaders() {
        if (this.state_ == 0 || this.state_ == 1) {
            throw Context.reportRuntimeError("Unspecified error (request not sent).");
        }
        if (this.webResponse_ != null) {
            StringBuilder buffer = new StringBuilder();
            for (NameValuePair header : this.webResponse_.getResponseHeaders()) {
                buffer.append(header.getName()).append(": ").append(header.getValue()).append("\r\n");
            }
            return buffer.append("\r\n").toString();
        }
        LOG.error("XMLHTTPRequest.getAllResponseHeaders() was called without a response available (readyState: " + this.state_ + ").");
        return null;
    }

    @JsxFunction
    public String getResponseHeader(String header) {
        if (this.state_ == 0 || this.state_ == 1) {
            throw Context.reportRuntimeError("Unspecified error (request not sent).");
        }
        if (header == null || "null".equals(header)) {
            throw Context.reportRuntimeError("Type mismatch (header is null).");
        }
        if ("".equals(header)) {
            throw Context.reportRuntimeError("Invalid argument (header is empty).");
        }
        if (this.webResponse_ != null) {
            String value = this.webResponse_.getResponseHeaderValue(header);
            if (value == null) {
                return "";
            }
            return value;
        }
        LOG.error("XMLHTTPRequest.getResponseHeader(..) was called without a response available (readyState: " + this.state_ + ").");
        return null;
    }

    @JsxFunction
    public void open(String method, Object url, Object asyncParam, Object user, Object password) {
        if (method == null || "null".equals(method)) {
            throw Context.reportRuntimeError("Type mismatch (method is null).");
        }
        if (url == null || "null".equals(url)) {
            throw Context.reportRuntimeError("Type mismatch (url is null).");
        }
        this.state_ = 0;
        this.openedMultipleTimes_ = this.webRequest_ != null;
        this.sent_ = false;
        this.webRequest_ = null;
        this.webResponse_ = null;
        if ("".equals(method) || "TRACE".equalsIgnoreCase(method)) {
            throw Context.reportRuntimeError("Invalid procedure call or argument (method is invalid).");
        }
        if ("".equals(url)) {
            throw Context.reportRuntimeError("Invalid procedure call or argument (url is empty).");
        }
        boolean async = true;
        if (asyncParam != Undefined.instance) {
            async = ScriptRuntime.toBoolean(asyncParam);
        }
        String urlAsString = Context.toString(url);
        this.containingPage_ = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        try {
            boolean userIsNull;
            URL fullUrl = this.containingPage_.getFullyQualifiedUrl(urlAsString);
            WebRequest request = new WebRequest(fullUrl);
            request.setCharset("UTF-8");
            request.setAdditionalHeader("Referer", this.containingPage_.getUrl().toExternalForm());
            request.setHttpMethod(HttpMethod.valueOf(method.toUpperCase(Locale.ENGLISH)));
            boolean bl = userIsNull = null == user || Undefined.instance == user;
            if (!userIsNull) {
                String userCred = user.toString();
                boolean passwordIsNull = null == password || Undefined.instance == password;
                String passwordCred = "";
                if (!passwordIsNull) {
                    passwordCred = password.toString();
                }
                request.setCredentials(new UsernamePasswordCredentials(userCred, passwordCred));
            }
            this.webRequest_ = request;
        }
        catch (MalformedURLException e) {
            LOG.error("Unable to initialize XMLHTTPRequest using malformed URL '" + urlAsString + "'.");
            return;
        }
        catch (IllegalArgumentException e) {
            LOG.error("Unable to initialize XMLHTTPRequest using illegal argument '" + e.getMessage() + "'.");
            this.webRequest_ = null;
        }
        this.async_ = async;
        this.setState(1, null);
    }

    @JsxFunction
    public void send(Object body) {
        if (this.webRequest_ == null) {
            this.setState(4, Context.getCurrentContext());
            return;
        }
        if (this.sent_) {
            throw Context.reportRuntimeError("Unspecified error (request already sent).");
        }
        this.sent_ = true;
        this.prepareRequest(body);
        this.setState(1, Context.getCurrentContext());
        WebClient client = this.getWindow().getWebWindow().getWebClient();
        AjaxController ajaxController = client.getAjaxController();
        HtmlPage page = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        boolean synchron = ajaxController.processSynchron(page, this.webRequest_, this.async_);
        if (synchron) {
            this.doSend(Context.getCurrentContext());
        } else {
            final Window startingScope = this.getWindow();
            HtmlUnitContextFactory cf = client.getJavaScriptEngine().getContextFactory();
            ContextAction action = new ContextAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run(Context cx) {
                    Stack<Scriptable> stack = (Stack<Scriptable>)cx.getThreadLocal("startingScope");
                    if (null == stack) {
                        stack = new Stack<Scriptable>();
                        cx.putThreadLocal("startingScope", stack);
                    }
                    stack.push(startingScope);
                    try {
                        XMLHTTPRequest.this.doSend(cx);
                    }
                    finally {
                        stack.pop();
                    }
                    return null;
                }
            };
            JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createJavascriptXMLHttpRequestJob(cf, action);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting XMLHTTPRequest thread for asynchronous request");
            }
            this.jobID_ = this.getWindow().getWebWindow().getJobManager().addJob(job, page);
        }
    }

    private void prepareRequest(Object content) {
        if (content != null && !Context.getUndefinedValue().equals(content)) {
            String body;
            if (!"".equals(content) && HttpMethod.GET == this.webRequest_.getHttpMethod()) {
                this.webRequest_.setHttpMethod(HttpMethod.POST);
            }
            if ((HttpMethod.POST == this.webRequest_.getHttpMethod() || HttpMethod.PUT == this.webRequest_.getHttpMethod()) && (body = Context.toString(content)).length() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Setting request body to: " + body);
                }
                this.webRequest_.setRequestBody(body);
            }
        }
    }

    private void doSend(Context context) {
        block13: {
            WebClient wc = this.getWindow().getWebWindow().getWebClient();
            try {
                boolean crossOriginResourceSharing;
                String originHeaderValue = this.webRequest_.getAdditionalHeaders().get(HEADER_ORIGIN);
                boolean bl = crossOriginResourceSharing = originHeaderValue != null;
                if (crossOriginResourceSharing && this.isPreflight()) {
                    WebRequest preflightRequest = new WebRequest(this.webRequest_.getUrl(), HttpMethod.OPTIONS);
                    preflightRequest.setAdditionalHeader(HEADER_ORIGIN, originHeaderValue);
                    preflightRequest.setAdditionalHeader(HEADER_ACCESS_CONTROL_REQUEST_METHOD, this.webRequest_.getHttpMethod().name());
                    StringBuilder builder = new StringBuilder();
                    for (Map.Entry<String, String> header : this.webRequest_.getAdditionalHeaders().entrySet()) {
                        String name = header.getKey().toLowerCase(Locale.ENGLISH);
                        if (!this.isPreflightHeader(name, header.getValue())) continue;
                        if (builder.length() != 0) {
                            builder.append(',');
                        }
                        builder.append(name);
                    }
                    preflightRequest.setAdditionalHeader(HEADER_ACCESS_CONTROL_REQUEST_HEADERS, builder.toString());
                    WebResponse preflightResponse = wc.loadWebResponse(preflightRequest);
                    if (!this.isPreflightAuthorized(preflightResponse)) {
                        this.setState(2, context);
                        this.setState(3, context);
                        this.setState(4, context);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("No permitted request for URL " + this.webRequest_.getUrl());
                        }
                        Context.throwAsScriptRuntimeEx(new RuntimeException("No permitted \"Access-Control-Allow-Origin\" header."));
                        return;
                    }
                }
                WebResponse webResponse = wc.loadWebResponse(this.webRequest_);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Web response loaded successfully.");
                }
                boolean allowOriginResponse = true;
                if (crossOriginResourceSharing) {
                    String value = webResponse.getResponseHeaderValue(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN);
                    allowOriginResponse = originHeaderValue.equals(value);
                    boolean bl2 = allowOriginResponse = allowOriginResponse || ALLOW_ORIGIN_ALL.equals(value);
                }
                if (allowOriginResponse) {
                    this.webResponse_ = webResponse;
                }
                if (!allowOriginResponse) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No permitted \"Access-Control-Allow-Origin\" header for URL " + this.webRequest_.getUrl());
                    }
                    throw new IOException("No permitted \"Access-Control-Allow-Origin\" header.");
                }
                this.setState(2, context);
                this.setState(3, context);
                this.setState(4, context);
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("IOException: returning a network error response.", e);
                }
                this.webResponse_ = new NetworkErrorWebResponse(this.webRequest_);
                this.setState(2, context);
                this.setState(4, context);
                if (this.async_) break block13;
                throw Context.reportRuntimeError("Object not found.");
            }
        }
    }

    private boolean isPreflight() {
        HttpMethod method = this.webRequest_.getHttpMethod();
        if (method != HttpMethod.GET && method != HttpMethod.PUT && method != HttpMethod.HEAD) {
            return true;
        }
        for (Map.Entry<String, String> header : this.webRequest_.getAdditionalHeaders().entrySet()) {
            if (!this.isPreflightHeader(header.getKey().toLowerCase(Locale.ENGLISH), header.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean isPreflightAuthorized(WebResponse preflightResponse) {
        String originHeader = preflightResponse.getResponseHeaderValue(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN);
        if (!ALLOW_ORIGIN_ALL.equals(originHeader) && !this.webRequest_.getAdditionalHeaders().get(HEADER_ORIGIN).equals(originHeader)) {
            return false;
        }
        String headersHeader = preflightResponse.getResponseHeaderValue(HEADER_ACCESS_CONTROL_ALLOW_HEADERS);
        headersHeader = headersHeader == null ? "" : headersHeader.toLowerCase(Locale.ENGLISH);
        for (Map.Entry<String, String> header : this.webRequest_.getAdditionalHeaders().entrySet()) {
            String key = header.getKey().toLowerCase(Locale.ENGLISH);
            if (!this.isPreflightHeader(key, header.getValue()) || headersHeader.contains(key)) continue;
            return false;
        }
        return true;
    }

    private boolean isPreflightHeader(String name, String value) {
        if ("content-type".equals(name)) {
            String lcValue = value.toLowerCase(Locale.ENGLISH);
            return !FormEncodingType.URL_ENCODED.getName().equals(lcValue) && !FormEncodingType.MULTIPART.getName().equals(lcValue) && !"text/plain".equals(lcValue) && !lcValue.startsWith("text/plain;charset=");
        }
        return !"accept".equals(name) && !"accept-language".equals(name) && !"content-language".equals(name) && !"referer".equals(name) && !"accept-encoding".equals(name) && !"origin".equals(name);
    }

    @JsxFunction
    public void setRequestHeader(String name, String value) {
        if (name == null || "null".equals(name)) {
            throw Context.reportRuntimeError("Type mismatch (name is null).");
        }
        if ("".equals(name)) {
            throw Context.reportRuntimeError("Invalid argument (name is empty).");
        }
        if (value == null || "null".equals(value)) {
            throw Context.reportRuntimeError("Type mismatch (value is null).");
        }
        if (StringUtils.isBlank(value)) {
            return;
        }
        if (!XMLHTTPRequest.isAuthorizedHeader(name)) {
            LOG.warn("Ignoring XMLHTTPRequest.setRequestHeader for " + name + ": it is a restricted header");
            return;
        }
        if (this.webRequest_ == null) {
            throw Context.reportRuntimeError("Unspecified error (request not opened).");
        }
        this.webRequest_.setAdditionalHeader(name, value);
    }

    static boolean isAuthorizedHeader(String name) {
        String nameLowerCase = name.toLowerCase(Locale.ENGLISH);
        if (PROHIBITED_HEADERS_.contains(nameLowerCase)) {
            return false;
        }
        return !nameLowerCase.startsWith("proxy-") && !nameLowerCase.startsWith("sec-");
    }

    @Override
    public Object get(String name, Scriptable start) {
        for (String property : ALL_PROPERTIES_) {
            if (!property.equalsIgnoreCase(name)) continue;
            name = property;
            break;
        }
        return super.get(name, start);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        for (String property : ALL_PROPERTIES_) {
            if (!property.equalsIgnoreCase(name)) continue;
            name = property;
            break;
        }
        super.put(name, start, value);
    }

    private static final class NetworkErrorWebResponse
    extends WebResponse {
        private final WebRequest request_;

        private NetworkErrorWebResponse(WebRequest webRequest) {
            super(null, null, 0L);
            this.request_ = webRequest;
        }

        @Override
        public int getStatusCode() {
            return 0;
        }

        @Override
        public String getStatusMessage() {
            return "";
        }

        @Override
        public String getContentType() {
            return "";
        }

        @Override
        public String getContentAsString() {
            return "";
        }

        @Override
        public String getContentAsString(String encoding) {
            return "";
        }

        @Override
        public InputStream getContentAsStream() {
            return null;
        }

        @Override
        public List<NameValuePair> getResponseHeaders() {
            return Collections.emptyList();
        }

        @Override
        public String getResponseHeaderValue(String headerName) {
            return "";
        }

        @Override
        public long getLoadTime() {
            return 0L;
        }

        @Override
        public String getContentCharset() {
            return "";
        }

        @Override
        public String getContentCharsetOrNull() {
            return "";
        }

        @Override
        public WebRequest getWebRequest() {
            return this.request_;
        }
    }
}

