/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.util.concurrent.Executor;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.websocket.DefaultWebSocketFrame;
import org.jboss.netty.util.CharsetUtil;
import org.webbitserver.WebSocketConnection;
import org.webbitserver.netty.AbstractHttpConnection;
import org.webbitserver.netty.EncodingHybiFrame;
import org.webbitserver.netty.NettyHttpRequest;

public class NettyWebSocketConnection
extends AbstractHttpConnection
implements WebSocketConnection {
    private final byte[] outboundMaskingKey;
    private String version;
    private boolean hybi;

    public NettyWebSocketConnection(Executor executor, NettyHttpRequest nettyHttpRequest, ChannelHandlerContext ctx, byte[] outboundMaskingKey) {
        super(ctx, nettyHttpRequest, executor);
        this.outboundMaskingKey = outboundMaskingKey;
    }

    @Override
    public NettyWebSocketConnection send(String message) {
        if (this.hybi) {
            this.writeMessage(new EncodingHybiFrame(1, true, 0, this.outboundMaskingKey, ChannelBuffers.copiedBuffer((CharSequence)message, CharsetUtil.UTF_8)));
        } else {
            this.writeMessage(new DefaultWebSocketFrame(message));
        }
        return this;
    }

    @Override
    public NettyWebSocketConnection send(byte[] message) {
        return this.send(message, 0, message.length);
    }

    @Override
    public NettyWebSocketConnection send(byte[] message, int offset, int length) {
        this.writeMessage(new EncodingHybiFrame(2, true, 0, this.outboundMaskingKey, ChannelBuffers.copiedBuffer(message, offset, length)));
        return this;
    }

    @Override
    public NettyWebSocketConnection ping(byte[] message) {
        this.writeMessage(new EncodingHybiFrame(9, true, 0, this.outboundMaskingKey, ChannelBuffers.copiedBuffer(message)));
        return this;
    }

    @Override
    public NettyWebSocketConnection pong(byte[] message) {
        this.writeMessage(new EncodingHybiFrame(10, true, 0, this.outboundMaskingKey, ChannelBuffers.copiedBuffer(message)));
        return this;
    }

    @Override
    public NettyWebSocketConnection close() {
        this.closeChannel();
        return this;
    }

    @Override
    public NettyWebSocketConnection data(String key, Object value) {
        this.putData(key, value);
        return this;
    }

    @Override
    public String version() {
        return this.version;
    }

    void setVersion(String version) {
        this.version = version;
    }

    public void setHybiWebSocketVersion(int webSocketVersion) {
        this.setVersion("Sec-WebSocket-Version-" + webSocketVersion);
        this.hybi = true;
    }
}

