/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.client.webdav;

import java.io.IOException;
import org.seleniumhq.jetty7.client.HttpExchange;
import org.seleniumhq.jetty7.io.Buffer;
import org.seleniumhq.jetty7.util.log.Log;
import org.seleniumhq.jetty7.util.log.Logger;

public class WebdavSupportedExchange
extends HttpExchange {
    private static final Logger LOG = Log.getLogger(WebdavSupportedExchange.class);
    private boolean _webdavSupported = false;
    private boolean _isComplete = false;

    protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("WebdavSupportedExchange:Header:" + name.toString() + " / " + value.toString(), new Object[0]);
        }
        if ("DAV".equals(name.toString()) && (value.toString().indexOf("1") >= 0 || value.toString().indexOf("2") >= 0)) {
            this._webdavSupported = true;
        }
        super.onResponseHeader(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTilCompletion() throws InterruptedException {
        WebdavSupportedExchange webdavSupportedExchange = this;
        synchronized (webdavSupportedExchange) {
            while (!this._isComplete) {
                this.wait();
            }
        }
    }

    protected void onResponseComplete() throws IOException {
        this._isComplete = true;
        super.onResponseComplete();
    }

    public boolean isWebdavSupported() {
        return this._webdavSupported;
    }
}

