/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.common;

import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.grid.common.CommandLineOptionHelper;
import org.openqa.grid.common.GridRole;
import org.openqa.grid.common.JSONConfigurationUtils;
import org.openqa.grid.common.SeleniumProtocol;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.common.exception.GridException;
import org.openqa.selenium.Platform;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.cli.RemoteControlLauncher;

public class RegistrationRequest {
    private String id;
    private String name;
    private String description;
    private GridRole role;
    private List<DesiredCapabilities> capabilities = new ArrayList<DesiredCapabilities>();
    private Map<String, Object> configuration = new HashMap<String, Object>();
    private String[] args = new String[0];
    private static final Logger log = Logger.getLogger(RegistrationRequest.class.getName());
    public static final String APP = "applicationName";
    public static final String MAX_INSTANCES = "maxInstances";
    public static final String SELENIUM_PROTOCOL = "seleniumProtocol";
    public static final String PATH = "path";
    public static final String BROWSER = "browserName";
    public static final String PLATFORM = "platform";
    public static final String VERSION = "version";
    public static final String REGISTER_CYCLE = "registerCycle";
    public static final String PROXY_CLASS = "proxy";
    public static final String CLEAN_UP_CYCLE = "cleanUpCycle";
    public static final String TIME_OUT = "timeout";
    public static final String BROWSER_TIME_OUT = "browserTimeout";
    public static final String REMOTE_HOST = "remoteHost";
    public static final String MAX_SESSION = "maxSession";
    public static final String AUTO_REGISTER = "register";
    public static final String NODE_POLLING = "nodePolling";
    public static final String UNREGISTER_IF_STILL_DOWN_AFTER = "unregisterIfStillDownAfter";
    public static final String MAX_TESTS_BEFORE_CLEAN = "maxTestBeforeClean";
    public static final String CLEAN_SNAPSHOT = "cleanSnapshot";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String HUB_HOST = "hubHost";
    public static final String HUB_PORT = "hubPort";
    public static final String SERVLETS = "servlets";
    public static final String ID = "id";

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<DesiredCapabilities> getCapabilities() {
        return this.capabilities;
    }

    public void addDesiredCapability(DesiredCapabilities c) {
        this.capabilities.add(c);
    }

    public void addDesiredCapability(Map<String, Object> c) {
        this.capabilities.add(new DesiredCapabilities(c));
    }

    public void setCapabilities(List<DesiredCapabilities> capabilities) {
        this.capabilities = capabilities;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public String toJSON() {
        JSONObject res = this.getAssociatedJSON();
        return res.toString();
    }

    public JSONObject getAssociatedJSON() {
        JSONObject res = new JSONObject();
        try {
            res.put("class", this.getClass().getCanonicalName());
            res.put(ID, this.id);
            res.put("name", this.name);
            res.put("description", this.description);
            res.put("configuration", this.configuration);
            JSONArray caps = new JSONArray();
            for (DesiredCapabilities c : this.capabilities) {
                caps.put(c.asMap());
            }
            res.put("capabilities", caps);
        }
        catch (JSONException e) {
            throw new RuntimeException("Error encoding to JSON " + e.getMessage(), e);
        }
        return res;
    }

    public String getConfigAsString(String param) {
        Object res = this.configuration.get(param);
        return res == null ? null : res.toString();
    }

    public int getConfigAsInt(String param, int defaultValue) {
        Object o = this.configuration.get(param);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (Throwable throwable) {
            log.warning("Error." + this.name + " is supposed to be an int. Keeping default of " + defaultValue);
            return defaultValue;
        }
    }

    private void ensureBackwardCompatibility() {
        URL tmp;
        String url = (String)this.configuration.get(REMOTE_HOST);
        if (url != null) {
            return;
        }
        url = (String)this.configuration.get("url");
        if (url == null) {
            return;
        }
        if (url.contains("selenium-server/driver")) {
            for (DesiredCapabilities capability : this.capabilities) {
                capability.setCapability(SELENIUM_PROTOCOL, SeleniumProtocol.Selenium.toString());
            }
        }
        try {
            tmp = new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            throw new GridException("specified URL for the node isn't valid :" + url);
        }
        this.configuration.put(REMOTE_HOST, "http://" + tmp.getHost() + ":" + tmp.getPort());
    }

    public static RegistrationRequest getNewInstance(String json) {
        RegistrationRequest request = new RegistrationRequest();
        try {
            JSONObject o = new JSONObject(json);
            if (o.has(ID)) {
                request.setId(o.getString(ID));
            }
            if (o.has("name")) {
                request.setName(o.getString("name"));
            }
            if (o.has("description")) {
                request.setDescription(o.getString("description"));
            }
            JSONObject config = o.getJSONObject("configuration");
            HashMap<String, Object> configuration = Maps.newHashMap();
            Iterator iterator = config.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                configuration.put(key, config.get(key));
            }
            request.setConfiguration(configuration);
            JSONArray capabilities = o.getJSONArray("capabilities");
            int i = 0;
            while (i < capabilities.length()) {
                JSONObject capability = capabilities.getJSONObject(i);
                DesiredCapabilities cap = new DesiredCapabilities();
                Iterator iterator2 = capability.keys();
                while (iterator2.hasNext()) {
                    String key = (String)iterator2.next();
                    cap.setCapability(key, capability.get(key));
                }
                request.capabilities.add(cap);
                ++i;
            }
            request.ensureBackwardCompatibility();
            return request;
        }
        catch (JSONException jSONException) {
            return RegistrationRequest.parseGrid1Request(json);
        }
    }

    public String getRemoteProxyClass() {
        Object o = this.getConfiguration().get(PROXY_CLASS);
        return o == null ? null : o.toString();
    }

    private static RegistrationRequest parseGrid1Request(String clientRequest) {
        String[] parts;
        HashMap<String, String> registrationInfo = Maps.newHashMap();
        String[] stringArray = parts = clientRequest.split("&");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            String[] configItem = part.split("=");
            if (configItem.length != 2) {
                throw new InvalidParameterException();
            }
            try {
                registrationInfo.put(URLDecoder.decode(configItem[0], "UTF-8"), URLDecoder.decode(configItem[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                log.warning(String.format("Unable to decode registration request portion: %s", part));
            }
            ++n2;
        }
        if (registrationInfo.get(PORT) != null && registrationInfo.get("environment") != null) {
            RegistrationRequest request = new RegistrationRequest();
            HashMap<String, Object> configuration = Maps.newHashMap();
            configuration.put(SELENIUM_PROTOCOL, SeleniumProtocol.Selenium.toString());
            configuration.put(REMOTE_HOST, String.format("http://%s:%s", registrationInfo.get(HOST), registrationInfo.get(PORT)));
            request.setConfiguration(configuration);
            DesiredCapabilities cap = new DesiredCapabilities();
            cap.setCapability(BROWSER, (String)registrationInfo.get("environment"));
            cap.setCapability("environment", (String)registrationInfo.get("environment"));
            request.capabilities.add(cap);
            return request;
        }
        throw new InvalidParameterException();
    }

    public static RegistrationRequest localWebdriverNoCapabilities() {
        RegistrationRequest res = RegistrationRequest.build("-role", "webdriver", "-host", "localhost");
        res.capabilities.clear();
        return res;
    }

    public static RegistrationRequest build(String ... args) {
        RegistrationRequest res = new RegistrationRequest();
        res.args = args;
        CommandLineOptionHelper helper = new CommandLineOptionHelper(args);
        res.role = GridRole.find(args);
        String defaultConfig = "defaults/DefaultNode.json";
        String nodeType = helper.getParamValue("-role");
        if (GridRole.RCAliases().contains(nodeType)) {
            defaultConfig = "defaults/DefaultNodeSelenium.json";
        }
        if (GridRole.WDAliases().contains(nodeType)) {
            defaultConfig = "defaults/DefaultNodeWebDriver.json";
        }
        res.loadFromJSON(defaultConfig);
        if (helper.isParamPresent("-nodeConfig")) {
            String value = helper.getParamValue("-nodeConfig");
            res.loadFromJSON(value);
        }
        res.loadFromCommandLine(args);
        res.configuration.put(HOST, RegistrationRequest.guessHost((String)res.configuration.get(HOST)));
        res.configuration.put(HUB_HOST, RegistrationRequest.guessHost((String)res.configuration.get(HUB_HOST)));
        if (res.configuration.get(REMOTE_HOST) == null) {
            String url = "http://" + res.configuration.get(HOST) + ":" + res.configuration.get(PORT);
            res.configuration.put(REMOTE_HOST, url);
        }
        res.configuration.put("url", res.configuration.get(REMOTE_HOST));
        String u = (String)res.configuration.get("hub");
        if (u != null) {
            try {
                URL ur = new URL(u);
                res.configuration.put(HUB_HOST, ur.getHost());
                res.configuration.put(HUB_PORT, ur.getPort());
            }
            catch (MalformedURLException malformedURLException) {
                throw new GridConfigurationException("the specified hub is not valid : -hub " + u);
            }
        }
        return res;
    }

    private static String guessHost(String host) {
        if ("ip".equalsIgnoreCase(host)) {
            NetworkUtils util = new NetworkUtils();
            return util.getIp4NonLoopbackAddressOfThisMachine().getHostAddress();
        }
        if (HOST.equalsIgnoreCase(host)) {
            NetworkUtils util = new NetworkUtils();
            return util.getIp4NonLoopbackAddressOfThisMachine().getHostName();
        }
        return host;
    }

    private void loadFromCommandLine(String[] args) {
        List<String> l;
        CommandLineOptionHelper helper = new CommandLineOptionHelper(args);
        List<String> params = helper.getKeys();
        for (String param : params) {
            String value = helper.getParamValue(param);
            try {
                int i = Integer.parseInt(value);
                this.configuration.put(param.replaceFirst("-", ""), i);
            }
            catch (NumberFormatException numberFormatException) {
                this.configuration.put(param.replaceFirst("-", ""), value);
            }
        }
        if (helper.isParamPresent("-hubHost")) {
            this.configuration.put(HUB_HOST, helper.getParamValue("-hubHost"));
        }
        if (helper.isParamPresent("-hubPort")) {
            this.configuration.put(HUB_PORT, Integer.parseInt(helper.getParamValue("-hubPort")));
        }
        if (helper.isParamPresent("-host")) {
            this.configuration.put(HOST, helper.getParamValue("-host"));
        }
        if (helper.isParamPresent("-port")) {
            this.configuration.put(PORT, Integer.parseInt(helper.getParamValue("-port")));
        }
        if (helper.isParamPresent("-cleanUpCycle")) {
            this.configuration.put(CLEAN_UP_CYCLE, Integer.parseInt(helper.getParamValue("-cleanUpCycle")));
        }
        if (helper.isParamPresent("-timeout")) {
            this.configuration.put(TIME_OUT, Integer.parseInt(helper.getParamValue("-timeout")));
        }
        if (helper.isParamPresent("-browserTimeout")) {
            this.configuration.put(BROWSER_TIME_OUT, Integer.parseInt(helper.getParamValue("-browserTimeout")));
        }
        if (helper.isParamPresent("-maxSession")) {
            this.configuration.put(MAX_SESSION, Integer.parseInt(helper.getParamValue("-maxSession")));
        }
        if (helper.isParamPresent("-register")) {
            this.configuration.put(AUTO_REGISTER, Boolean.parseBoolean(helper.getParamValue("-register")));
        }
        if (helper.isParamPresent("-servlets")) {
            this.configuration.put(SERVLETS, helper.getParamValue("-servlets"));
        }
        if (!(l = helper.getAll("-browser")).isEmpty()) {
            this.capabilities.clear();
            for (String s : l) {
                DesiredCapabilities c = this.addCapabilityFromString(s);
                this.capabilities.add(c);
            }
        }
        this.addPlatformInfoToCapabilities();
    }

    private DesiredCapabilities addCapabilityFromString(String capability) {
        System.out.println("adding " + capability);
        String[] s = capability.split(",");
        if (s.length == 0) {
            throw new GridConfigurationException("-browser must be followed by a browser description");
        }
        DesiredCapabilities res = new DesiredCapabilities();
        String[] stringArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String capabilityPair = stringArray[n2];
            if (capabilityPair.split("=").length != 2) {
                throw new GridConfigurationException("-browser format is key1=value1,key2=value2 " + capabilityPair + " deosn't follow that format.");
            }
            String key = capabilityPair.split("=")[0];
            String value = capabilityPair.split("=")[1];
            res.setCapability(key, value);
            ++n2;
        }
        if (res.getBrowserName() == null) {
            throw new GridConfigurationException("You need to specify a browserName using browserName=XXX");
        }
        return res;
    }

    private void addPlatformInfoToCapabilities() {
        Platform current = Platform.getCurrent();
        for (DesiredCapabilities cap : this.capabilities) {
            if (cap.getPlatform() != null) continue;
            cap.setPlatform(current);
        }
    }

    public JSONObject getRegistrationRequest() {
        try {
            JSONObject res = new JSONObject();
            JSONArray a = new JSONArray();
            for (DesiredCapabilities cap : this.capabilities) {
                JSONObject capa = new JSONObject(cap.asMap());
                a.put(capa);
            }
            res.put("configuration", new JSONObject(this.configuration));
            return res;
        }
        catch (JSONException e) {
            throw new GridConfigurationException("error generating the node config : " + e.getMessage());
        }
    }

    public void loadFromJSON(String resource) {
        try {
            JSONObject base = JSONConfigurationUtils.loadJSON(resource);
            if (base.has("capabilities")) {
                this.capabilities = new ArrayList<DesiredCapabilities>();
                JSONArray a = base.getJSONArray("capabilities");
                int i = 0;
                while (i < a.length()) {
                    JSONObject cap = a.getJSONObject(i);
                    DesiredCapabilities c = new DesiredCapabilities();
                    Iterator iterator = cap.keys();
                    while (iterator.hasNext()) {
                        String name = (String)iterator.next();
                        Object value = cap.get(name);
                        c.setCapability(name, value);
                    }
                    this.capabilities.add(c);
                    ++i;
                }
                this.addPlatformInfoToCapabilities();
            }
            JSONObject o = base.getJSONObject("configuration");
            Iterator iterator = o.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = o.get(key);
                if (value instanceof JSONArray) {
                    JSONArray a = (JSONArray)value;
                    ArrayList<String> as = new ArrayList<String>();
                    int i = 0;
                    while (i < a.length()) {
                        as.add(a.getString(i));
                        ++i;
                    }
                    this.configuration.put(key, as);
                    continue;
                }
                this.configuration.put(key, o.get(key));
            }
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error with the JSON of the config : " + e.getMessage(), e);
        }
    }

    public GridRole getRole() {
        return this.role;
    }

    public void setRole(GridRole role) {
        this.role = role;
    }

    public RemoteControlConfiguration getRemoteControlConfiguration() {
        ArrayList<String> params = new ArrayList<String>();
        for (String key : this.configuration.keySet()) {
            params.add("-" + key);
            if (this.configuration.get(key).toString().trim().isEmpty()) continue;
            params.add("" + this.configuration.get(key));
        }
        return RemoteControlLauncher.parseLauncherOptions(params.toArray(new String[params.size()]));
    }

    public String[] getArgs() {
        return this.args;
    }

    public void validate() throws GridConfigurationException {
        String hub = (String)this.configuration.get(HUB_HOST);
        Integer port = (Integer)this.configuration.get(HUB_PORT);
        if (hub == null || port == null) {
            throw new GridConfigurationException("You need to specify a hub to register to using -hubHost X -hubPort 5555. The specified config was -hubHost " + hub + " -" + HUB_PORT + " " + port);
        }
    }
}

