/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.WebConnectionWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.ContextFactory;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebuggingWebConnection
extends WebConnectionWrapper {
    private static final Log LOG = LogFactory.getLog(DebuggingWebConnection.class);
    private static final Pattern ESCAPE_QUOTE_PATTERN = Pattern.compile("'");
    private int counter_;
    private final WebConnection wrappedWebConnection_;
    private final File javaScriptFile_;
    private final File reportFolder_;
    private boolean uncompressJavaScript_ = true;

    public DebuggingWebConnection(WebConnection webConnection, String dirName) throws IOException {
        super(webConnection);
        this.wrappedWebConnection_ = webConnection;
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        this.reportFolder_ = new File(tmpDir, dirName);
        if (this.reportFolder_.exists()) {
            FileUtils.forceDelete(this.reportFolder_);
        }
        FileUtils.forceMkdir(this.reportFolder_);
        this.javaScriptFile_ = new File(this.reportFolder_, "hu.js");
        this.createOverview();
    }

    @Override
    public WebResponse getResponse(WebRequest request) throws IOException {
        WebResponse response = this.wrappedWebConnection_.getResponse(request);
        if (this.isUncompressJavaScript() && DebuggingWebConnection.isJavaScript(response.getContentType())) {
            response = this.uncompressJavaScript(response);
        }
        this.saveResponse(response, request);
        return response;
    }

    protected WebResponse uncompressJavaScript(WebResponse response) {
        WebRequest request = response.getWebRequest();
        final String scriptName = request.getUrl().toString();
        final String scriptSource = response.getContentAsString();
        ContextFactory factory = new ContextFactory();
        ContextAction action = new ContextAction(){

            @Override
            public Object run(Context cx) {
                cx.setOptimizationLevel(-1);
                Script script = cx.compileString(scriptSource, scriptName, 0, null);
                return cx.decompileScript(script, 4);
            }
        };
        try {
            String decompileScript = (String)factory.call(action);
            ArrayList<NameValuePair> responseHeaders = new ArrayList<NameValuePair>(response.getResponseHeaders());
            for (int i = responseHeaders.size() - 1; i >= 0; --i) {
                if (!"content-encoding".equalsIgnoreCase(((NameValuePair)responseHeaders.get(i)).getName())) continue;
                responseHeaders.remove(i);
            }
            WebResponseData wrd = new WebResponseData(decompileScript.getBytes(), response.getStatusCode(), response.getStatusMessage(), responseHeaders);
            return new WebResponse(wrd, response.getWebRequest().getUrl(), response.getWebRequest().getHttpMethod(), response.getLoadTime());
        }
        catch (Exception e) {
            LOG.warn("Failed to decompress JavaScript response. Delivering as it.", e);
            return response;
        }
    }

    public void addMark(String mark) throws IOException {
        if (mark != null) {
            mark = mark.replace("\"", "\\\"");
        }
        this.appendToJSFile("tab[tab.length] = \"" + mark + "\";\n");
        LOG.info("--- " + mark + " ---");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveResponse(WebResponse response, WebRequest request) throws IOException {
        ++this.counter_;
        String extension = DebuggingWebConnection.chooseExtension(response.getContentType());
        File f = this.createFile(request.getUrl(), extension);
        InputStream input = response.getContentAsStream();
        FileOutputStream output = new FileOutputStream(f);
        try {
            IOUtils.copy(response.getContentAsStream(), (OutputStream)output);
        }
        finally {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(output);
        }
        URL url = response.getWebRequest().getUrl();
        LOG.info("Created file " + f.getAbsolutePath() + " for response " + this.counter_ + ": " + url);
        StringBuilder buffer = new StringBuilder();
        buffer.append("tab[tab.length] = {code: " + response.getStatusCode() + ", ");
        buffer.append("fileName: '" + f.getName() + "', ");
        buffer.append("contentType: '" + response.getContentType() + "', ");
        buffer.append("method: '" + request.getHttpMethod().name() + "', ");
        if (request.getHttpMethod() == HttpMethod.POST && request.getEncodingType() == FormEncodingType.URL_ENCODED) {
            buffer.append("postParameters: " + DebuggingWebConnection.nameValueListToJsMap(request.getRequestParameters()) + ", ");
        }
        buffer.append("url: '" + DebuggingWebConnection.escapeJSString(url.toString()) + "', ");
        buffer.append("loadTime: " + response.getLoadTime() + ", ");
        byte[] bytes = IOUtils.toByteArray(response.getContentAsStream());
        buffer.append("responseSize: " + (bytes == null ? 0 : bytes.length) + ", ");
        buffer.append("responseHeaders: " + DebuggingWebConnection.nameValueListToJsMap(response.getResponseHeaders()));
        buffer.append("};\n");
        this.appendToJSFile(buffer.toString());
    }

    static String escapeJSString(String string) {
        return ESCAPE_QUOTE_PATTERN.matcher(string).replaceAll("\\\\'");
    }

    static String chooseExtension(String contentType) {
        if (DebuggingWebConnection.isJavaScript(contentType)) {
            return ".js";
        }
        if ("text/html".equals(contentType)) {
            return ".html";
        }
        if ("text/css".equals(contentType)) {
            return ".css";
        }
        if ("text/xml".equals(contentType)) {
            return ".xml";
        }
        if ("image/gif".equals(contentType)) {
            return ".gif";
        }
        return ".txt";
    }

    static boolean isJavaScript(String contentType) {
        return contentType.contains("javascript") || contentType.contains("ecmascript") || contentType.startsWith("text/") && contentType.endsWith("js");
    }

    public boolean isUncompressJavaScript() {
        return this.uncompressJavaScript_;
    }

    public void setUncompressJavaScript(boolean decompress) {
        this.uncompressJavaScript_ = decompress;
    }

    private void appendToJSFile(String str) throws IOException {
        FileWriter jsFileWriter = new FileWriter(this.javaScriptFile_, true);
        jsFileWriter.write(str);
        jsFileWriter.flush();
        jsFileWriter.close();
    }

    private File createFile(URL url, String extension) throws IOException {
        String name = url.getPath().replaceFirst("/$", "").replaceAll(".*/", "");
        name = StringUtils.substringBefore(name, "?");
        name = StringUtils.substringBefore(name, ";");
        if (!(name = StringUtils.substring(name, 0, 30)).endsWith(extension)) {
            name = name + extension;
        }
        int counter = 0;
        String fileName;
        File f;
        while (!(f = new File(this.reportFolder_, fileName = counter != 0 ? StringUtils.substringBeforeLast(name, ".") + "_" + counter + "." + StringUtils.substringAfterLast(name, ".") : name)).createNewFile()) {
            ++counter;
        }
        return f;
    }

    static String nameValueListToJsMap(List<NameValuePair> headers) {
        if (headers == null || headers.isEmpty()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder("{");
        for (NameValuePair header : headers) {
            buffer.append("'" + header.getName() + "': '" + DebuggingWebConnection.escapeJSString(header.getValue()) + "', ");
        }
        buffer.delete(buffer.length() - 2, buffer.length());
        buffer.append("}");
        return buffer.toString();
    }

    private void createOverview() throws IOException {
        FileUtils.writeStringToFile(this.javaScriptFile_, "var tab = [];\n", "ISO-8859-1");
        URL indexResource = DebuggingWebConnection.class.getResource("DebuggingWebConnection.index.html");
        if (indexResource == null) {
            throw new RuntimeException("Missing dependency DebuggingWebConnection.index.html");
        }
        File summary = new File(this.reportFolder_, "index.html");
        FileUtils.copyURLToFile(indexResource, summary);
        LOG.info("Summary will be in " + summary.getAbsolutePath());
    }

    File getReportFolder() {
        return this.reportFolder_;
    }
}

