#!/usr/bin/perl

use 5.006;
use strict;
use warnings FATAL => 'all';
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME               => 'Map::Tube::Plugin::FuzzyFind',
    AUTHOR             => q{Gisbert W. Selke <gws@cpan.org>},
    VERSION_FROM       => 'lib/Map/Tube/Plugin/FuzzyFind.pm',
    ABSTRACT_FROM      => 'lib/Map/Tube/Plugin/FuzzyFind.pm',
    LICENSE            => 'artistic_2',
    PL_FILES           => {},
    MIN_PERL_VERSION   => 5.006,
    CONFIGURE_REQUIRES => { 'ExtUtils::MakeMaker' => 6.64, },
    TEST_REQUIRES      => {
                            'Test::More'        => 0.82,
                            'Map::Tube::London' => 0.51,
                          },
    PREREQ_PM          => {
                            'Map::Tube'         => 2.72,
                            'Moo::Role'         => 0,
                            'Moo'               => 0,
                            'namespace::clean'  => 0,
                            'Try::Tiny'         => 0,
                          },
    dist               => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean              => { FILES => 'Map-Tube-Plugin-FuzzyFind-*', },
    META_MERGE         => {
                            'meta-spec' => { version => 2 },
                            'provides'  => {
                                             'Map::Tube::Plugin::FuzzyFind' => {
                                                                                 file => 'lib/Map/Tube/Plugin/FuzzyFind.pm',
                                                                                 version => '0.02',
                                                                               },
                                           },
                            'prereqs'   => {
                                             runtime => {
                                                          suggests => { 'Text::Levenshtein' => 0.12,     },
                                                          suggests => { 'Text::Soundex'     => 3,        },
                                                          suggests => { 'Text::Metaphone'   => 20081017, },
                                                        },
                                           },
                          },
);
