#!/usr/bin/perl
use strict;
use warnings;
use Test::Simple tests => 10;
use Graph::SocialMap;
use Graph::Writer::GraphViz;
use IO::All;
use YAML;

my $relation = {
    1357 => [qw/Marry Rose Autrijus/],
    3579 => [qw/Marry Peacock/],
    2468 => [qw/Joan/],
    4680 => [qw/Rose Joan/],
    OSSF => [qw/Gugod Autrijus/],
    GGYY => [qw/Gugod Autrijus Joan Peacock/],
    1234 => [qw/Tifa Dora Charlee Angie/],
    5555 => [qw/A B C D E F G H I J K/],
};

my $gsm = sm(-relation => $relation);
my $writer = Graph::Writer::GraphViz->new(-format=>'dot');
$writer->write_graph($gsm->type3,'t/graphtest2.dot');

my $tmp = io('t/graphtest2.dot');
my $d2 = $tmp->slurp;
my $d1;
{
    local $/ = undef;
    $d1 = <DATA>;
}
ok($d1 eq $d2);
$tmp->unlink;

my $adjm = $gsm->type3_adj_matrix;
ok($adjm->{Rose}->{Marry} == 1);

ok(cmp_hashes($adjm->{Angie},{Tifa=>1,Dora=>1,Charlee=>1}));
ok(cmp_hashes($adjm->{Charlee},{Tifa=>1,Dora=>1}));
ok(cmp_hashes($adjm->{Dora},{Tifa=>1}));
ok(cmp_hashes($adjm->{Marry},{}));
ok(cmp_hashes($adjm->{Gugod},{}));
ok(cmp_hashes($adjm->{Joan},{Rose => 1, Gugod => 1, Autrijus => 1}));
ok(cmp_hashes($adjm->{Autrijus},{Marry=>1,Rose=>1,Gugod=>1}));
ok(cmp_hashes($adjm->{Peacock} ,{Marry=>1,Gugod=>1,Autrijus=>1,Joan=>1}));

sub cmp_hashes {
    my ($h1,$h2) = @_;
    return 0 unless (keys %$h1 == keys %$h2);
    for (keys %$h1) {
	return 0 if($h1->{$_} ne $h2->{$_});
    }
    return 1;
}

__DATA__
digraph test {
	node [label="\N", color=black];
	edge [color=black];
	graph [bb="0,0,1516,781"];
	A [label=A, pos="399,26", width="0.75", height="0.50"];
	Angie [label=Angie, pos="1182,746", width="0.94", height="0.50"];
	Autrijus [label=Autrijus, pos="1433,602", width="1.17", height="0.50"];
	B [label=B, pos="333,98", width="0.75", height="0.50"];
	C [label=C, pos="543,170", width="0.75", height="0.50"];
	Charlee [label=Charlee, pos="1182,674", width="1.08", height="0.50"];
	D [label=D, pos="650,242", width="0.75", height="0.50"];
	Dora [label=Dora, pos="1134,602", width="0.83", height="0.50"];
	E [label=E, pos="373,314", width="0.75", height="0.50"];
	F [label=F, pos="597,386", width="0.75", height="0.50"];
	G [label=G, pos="483,458", width="0.75", height="0.50"];
	Gugod [label=Gugod, pos="1363,530", width="1.00", height="0.50"];
	H [label=H, pos="369,530", width="0.75", height="0.50"];
	I [label=I, pos="575,602", width="0.75", height="0.50"];
	J [label=J, pos="519,674", width="0.75", height="0.50"];
	Joan [label=Joan, pos="1382,674", width="0.81", height="0.50"];
	K [label=K, pos="490,746", width="0.75", height="0.50"];
	Marry [label=Marry, pos="1430,458", width="0.97", height="0.50"];
	Peacock [label=Peacock, pos="1353,746", width="1.11", height="0.50"];
	Rose [label=Rose, pos="1487,530", width="0.81", height="0.50"];
	Tifa [label=Tifa, pos="1192,530", width="0.75", height="0.50"];
	Angie -> Charlee [pos="e,1182,692 1182,728 1182,720 1182,711 1182,702"];
	Angie -> Dora [pos="e,1130,620 1163,731 1152,721 1140,707 1134,692 1126,672 1127,648 1129,630"];
	Angie -> Tifa [pos="e,1202,547 1201,731 1212,721 1224,707 1230,692 1247,645 1224,588 1207,556"];
	Autrijus -> Gugod [pos="e,1379,547 1417,585 1408,576 1396,564 1386,554"];
	Autrijus -> Marry [pos="e,1430,476 1433,584 1432,559 1431,515 1430,486"];
	Autrijus -> Rose [pos="e,1474,547 1446,585 1453,576 1461,565 1468,555"];
	B -> A [pos="e,385,41 347,82 356,72 368,59 378,49"];
	C -> A [pos="e,420,37 533,153 522,134 502,102 480,80 466,65 446,52 429,42"];
	C -> B [pos="e,357,106 519,162 482,149 409,124 366,109"];
	Charlee -> Dora [pos="e,1145,619 1170,657 1165,648 1157,637 1151,627"];
	Charlee -> Tifa [pos="e,1191,548 1183,656 1185,631 1188,587 1190,558"];
	D -> A [pos="e,426,27 645,224 640,205 628,173 611,152 551,79 523,59 436,30"];
	D -> B [pos="e,360,99 641,225 629,204 607,170 579,152 500,101 464,113 370,100"];
	D -> C [pos="e,562,183 631,229 615,218 590,201 570,189"];
	Dora -> Tifa [pos="e,1179,546 1147,586 1154,576 1164,564 1173,554"];
	E -> A [pos="e,373,30 359,298 313,234 313,201 297,116 295,100 290,94 297,80 315,47 332,42 363,33"];
	E -> B [pos="e,336,116 370,296 363,258 347,171 338,126"];
	E -> C [pos="e,526,184 390,300 421,274 484,221 518,191"];
	E -> D [pos="e,624,249 399,307 448,295 558,266 614,251"];
	F -> A [pos="e,412,42 578,373 537,342 466,279 466,242 466,242 466,242 466,170 466,124 438,77 418,50"];
	F -> B [pos="e,350,112 576,375 571,371 566,368 558,364 547,359 544,359 534,356 522,352 519,351 507,348 494,344 461,340 452,332 373,264 414,19\
1 357,120"];
	F -> C [pos="e,548,188 592,368 584,330 562,242 550,198"];
	F -> D [pos="e,643,260 603,368 613,344 629,299 640,270"];
	F -> E [pos="e,396,324 575,375 569,373 562,370 556,368 494,346 475,353 414,332 411,331 408,330 405,328"];
	G -> A [pos="e,372,27 456,454 410,441 392,440 356,404 332,378 333,365 322,332 290,223 248,184 290,80 304,46 322,38 362,29"];
	G -> B [pos="e,329,116 462,446 402,411 370,401 337,332 305,263 318,171 327,126"];
	G -> C [pos="e,539,188 487,440 497,391 525,257 537,198"];
	G -> D [pos="e,654,260 510,454 565,442 596,451 633,404 662,365 660,305 655,270"];
	G -> E [pos="e,393,326 478,440 471,421 459,390 442,368 431,354 415,341 402,332"];
	G -> F [pos="e,577,399 503,445 521,434 548,417 568,404"];
	H -> A [pos="e,372,27 342,525 206,470 86,462 86,314 86,314 86,314 86,170 86,49 215,89 324,40 340,33 343,30 359,28 360,28 361,28 362,27"];
	H -> B [pos="e,319,113 349,518 339,506 338,495 331,476 321,445 324,436 320,404 310,292 303,263 316,152 317,140 316,131 317,123"];
	H -> C [pos="e,516,173 360,513 341,472 301,370 337,296 379,212 422,202 506,176"];
	H -> D [pos="e,664,257 396,528 397,528 398,528 399,528 404,527 440,518 440,518 544,491 592,492 653,404 680,363 676,344 670,296 668,284 668,27\
5 667,267"];
	H -> E [pos="e,373,332 369,512 370,474 372,387 373,342"];
	H -> F [pos="e,586,403 396,526 451,513 470,511 519,476 544,458 566,431 580,411"];
	H -> G [pos="e,463,471 389,517 407,506 434,489 454,476"];
	I -> A [pos="e,426,27 602,599 639,586 645,571 679,548 813,458 956,475 956,314 956,314 956,314 956,170 956,62 561,34 436,27"];
	I -> B [pos="e,330,116 548,600 491,595 362,580 333,548 279,485 315,214 328,126"];
	I -> C [pos="e,570,172 600,596 622,582 624,569 646,548 717,476 804,486 804,386 804,386 804,386 804,314 804,195 694,201 580,174"];
	I -> D [pos="e,674,251 593,589 651,531 646,489 673,404 687,357 693,343 685,296 682,280 683,269 679,260"];
	I -> E [pos="e,399,318 571,584 562,541 532,431 467,368 447,348 437,349 414,332 410,329 409,327 407,324"];
	I -> F [pos="e,598,404 581,584 584,574 588,560 590,548 597,501 598,447 598,414"];
	I -> G [pos="e,494,475 564,585 548,560 518,512 499,484"];
	I -> H [pos="e,393,538 551,594 515,581 445,556 403,541"];
	J -> A [pos="e,426,26 546,673 551,673 555,672 557,672 559,671 677,629 695,620 889,507 1032,467 1032,242 1032,242 1032,242 1032,170 1032,46 61\
7,35 494,28 483,27 458,26 436,26"];
	J -> B [pos="e,307,104 492,672 443,658 428,650 385,620 290,552 124,330 124,314 124,314 124,314 124,242 124,143 207,139 297,107"];
	J -> C [pos="e,570,171 546,673 548,672 551,672 552,672 567,668 569,663 584,656 600,647 644,630 659,620 774,535 880,529 880,386 880,386 880,38\
6 880,314 880,209 784,207 682,188 639,179 628,176 585,172 583,172 582,172 580,172"];
	J -> D [pos="e,677,243 546,671 564,666 570,663 588,652 640,619 657,605 679,548 718,442 721,406 700,296 696,275 698,262 685,249"];
	J -> E [pos="e,379,332 506,658 463,590 403,410 382,342"];
	J -> F [pos="e,603,404 544,667 575,656 593,653 611,620 617,608 630,634 609,440 608,428 607,421 605,414"];
	J -> G [pos="e,486,476 516,656 510,618 495,531 488,486"];
	J -> H [pos="e,373,548 494,667 470,659 434,644 410,620 394,602 383,577 376,558"];
	J -> I [pos="e,562,618 532,658 539,649 548,637 556,626"];
	Joan -> Autrijus [pos="e,1421,620 1394,657 1400,648 1408,638 1415,628"];
	Joan -> Gugod [pos="e,1365,548 1380,656 1376,631 1370,587 1366,558"];
	Joan -> Rose [pos="e,1491,548 1409,667 1443,656 1463,654 1484,620 1495,602 1495,577 1492,558"];
	K -> A [pos="e,372,26 463,745 457,745 452,744 447,744 422,742 416,741 390,738 213,713 10,781 10,602 10,602 10,602 10,170 10,114 49,108 96,80 \
196,20 237,39 352,28 354,27 358,27 362,27"];
	K -> B [pos="e,306,99 463,744 410,740 293,727 200,692 127,664 48,680 48,602 48,602 48,602 48,242 48,132 219,106 296,100"];
	K -> C [pos="e,570,170 517,744 518,744 518,744 519,744 521,743 522,742 525,742 581,722 596,718 650,692 822,608 907,584 970,404 1000,316 939,2\
76 863,224 768,159 725,183 612,172 606,171 593,170 580,170"];
	K -> D [pos="e,677,243 517,744 519,743 519,742 522,742 564,723 575,718 613,692 737,604 812,613 878,476 935,354 867,326 686,247"];
	K -> E [pos="e,352,326 464,741 332,705 191,739 191,602 191,602 191,602 191,530 191,437 292,363 343,331"];
	K -> F [pos="e,615,400 516,742 582,713 602,688 627,620 653,544 641,518 624,440 621,426 621,418 619,410"];
	K -> G [pos="e,482,476 487,728 485,718 484,704 483,692 478,618 481,531 482,486"];
	K -> H [pos="e,370,548 473,732 450,710 407,666 385,620 376,601 372,577 371,558"];
	K -> I [pos="e,574,620 512,735 531,724 540,716 555,692 566,673 570,649 573,630"];
	K -> J [pos="e,512,691 497,729 501,720 505,710 509,701"];
	Peacock -> Autrijus [pos="e,1434,620 1380,733 1397,723 1407,714 1420,692 1430,673 1433,649 1434,630"];
	Peacock -> Gugod [pos="e,1358,548 1349,728 1347,718 1345,704 1344,692 1340,644 1350,590 1356,558"];
	Peacock -> Joan [pos="e,1375,692 1360,728 1364,720 1368,710 1371,702"];
	Peacock -> Marry [pos="e,1397,464 1341,729 1337,718 1340,708 1337,692 1322,612 1275,580 1318,512 1333,488 1362,474 1387,467"];
	Rose -> Marry [pos="e,1443,475 1474,514 1467,505 1458,493 1450,483"];
}
