# NOTE: Derived from blib/lib/Class/MethodMaker.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Class::MethodMaker;

#line 994 "blib/lib/Class/MethodMaker.pm (autosplit into blib/lib/auto/Class/MethodMaker/object_tie_list.al)"
# ----------------------------------------------------------------------


# no support for forwarded methods (may not make sense)

sub object_tie_list {
  my ($class, @args) = @_;
  my %methods;

  while (@args) {
    my $obj_tie_ref = shift @args;
    my $obj_class_ref = $obj_tie_ref->{class}
      or croak "No class passed to object_tie_list";
    my $tie_array_ref = $obj_tie_ref->{tie_array}
      or croak "No tied array name passed to object_tie_list";

    my $list = $obj_tie_ref->{slot}
      or croak "No slot names passef to object_tie_list";

    my @slot_list = ( ref($list) eq 'ARRAY' ) ? @$list : ($list);

    #    my $composites = $obj_tie_ref->{'comp_mthds'};
    #    my @composites = ref($composites) eq 'ARRAY' ? @$composites
    #      : defined $composites ? ($composites) : ();

    my $obj_class = shift @$obj_class_ref;

    foreach my $obj_def (@slot_list) {
      my $new_meth = 'new';
      my $name = $obj_def; # kept for closures

      $methods{$name} = sub {
        my ($self, @list) = @_;

        if ( ! defined $self->{$name} )
          {
            my ($tie_class, @c_args) = @$tie_array_ref ;
            # second args of tie is forced into a scalar context.
            tie my (@array), $tie_class, @c_args;
            $self->{$name} = \@array;
          }

        @{$self->{$name}} =
          map {
            (ref $_ and UNIVERSAL::isa($_, $obj_class)) ? $_ :
              ref $_ eq 'ARRAY' ? $obj_class->$new_meth(@$_) :
                $obj_class->$new_meth(@$obj_class_ref)
            } @list if scalar @list;

        # Use wantarray for consistency with list, which uses it for
        # consistency with its own doco., and the hash impl.

        return wantarray ? @{$self->{$name}} : $self->{$name};
      };

      $class->_add_list_methods(\%methods, $name);

      #      my $meth;
      #      foreach $meth (@composites) {
      #        $methods{$meth} = sub {
      #          my ($self, @args) = @_;
      #          map { $_->$meth(@args) } $self->$name()
      #        };
      #      }
    }
  }

  $class->install_methods(%methods);
}

# end of Class::MethodMaker::object_tie_list
1;
