# NOTE: Derived from blib/lib/IPC/Shareable.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package IPC::Shareable;

#line 1528 "blib/lib/IPC/Shareable.pm (autosplit into blib/lib/auto/IPC/Shareable/shlock.al)"
sub shlock {
    # --- Locks a shared variable
    my($variable) = @_;
    my($semid, $opstring, $arg);
    $arg = 0;
    debug "called on $variable" if ($Debug);

    # --- Don't lock it again if we already have done so
    return 1 if $Shm_Info{$$variable}{'lock'};

    # --- Get the semaphore ID
    $semid = $Shm_Info{$$variable}{'sem_id'};
    debug "$Package\:\:shlock: got sem_id $semid" if ($Debug);

    # --- Debugging
    _show_sems($semid) if ($Debug);

    # --- Define the operation
    $opstring = pack('sss sss sss sss',
		     SHM_RLOCKSEM, 0, 0,
		     SHM_WLOCKSEM, 0, 0,
                     SHM_RLOCKSEM, 1, SEM_UNDO,
                     SHM_WLOCKSEM, 1, SEM_UNDO 
		     );
    # --- Do it
    semop($semid, $opstring) or
	croak "$Package\:\:shlock: semop returned false: $!";

    # --- Set the flag so that this process can still use the variable
    $Shm_Info{$$variable}{'lock'} = 'true';

    # --- More debugging
    _show_sems($semid) if ($Debug);

    1;
}

# end of IPC::Shareable::shlock
1;
