#!perl -w
use strict;
use Test::More;

use Text::Xslate::Compiler;

#use Data::Dumper; $Data::Dumper::Indent = 1;

my $tx = Text::Xslate::Compiler->new();

my @data = (
    ['<:= $value10 == 10 ? 3 : 5 :>', 3],
    ['<:= $value10 == 20 ? 3 : 5 :>', 5],
    ['<:= $value20 == 10 ? 3 : 5 :>', 5],
    ['<:= $value20 == 20 ? 3 : 5 :>', 3],

    ['<:= $value10 == 10 && $value20 == 20 ? 3 : 5 :>', 3],
    ['<:= $value10 == 10 || $value20 == 20 ? 3 : 5 :>', 3],

    ['<:= ($value10 == 10 && $value20 == 20) ? 3 : 5 :>', 3],
    ['<:= ($value10 == 10 || $value20 == 20) ? 3 : 5 :>', 3],

    ['<:= ($value10 == 10 && $value20 == 20) && 5 :>',  5],
    ['<:= ($value10 == 10 && $value20 != 20) && 5 :>',  ''],
    ['<:= ($value10 == 10 && $value20 == 20) || 5 :>',  1],
    ['<:= ($value10 == 10 && $value20 != 20) || 5 :>',  5],
    ['<:= ($value10 != 10 && $value20 != 20) && 5 :>',  ''],
    ['<:= ($value10 != 10 && $value20 != 20) || 5 :>',  5],

    ['<:= ($value10 == 10 || $value20 == 20) && 5 :>',  5],
    ['<:= ($value10 == 10 || $value20 != 20) && 5 :>',  5],
    ['<:= ($value10 == 10 || $value20 == 20) || 5 :>',  1],
    ['<:= ($value10 == 10 || $value20 != 20) || 5 :>',  1],
    ['<:= ($value10 != 10 || $value20 != 20) && 5 :>',  ''],
    ['<:= ($value10 != 10 || $value20 != 20) || 5 :>',  5],

    ['<:= $value10 <   9 :>', ''],
    ['<:= $value10 <  10 :>', ''],
    ['<:= $value10 <  11 :>',  1],
    ['<:= $value10 <=  9 :>', ''],
    ['<:= $value10 <= 10 :>',  1],
    ['<:= $value10 <= 11 :>',  1],


    ['<:= $value10 >   9 :>',  1],
    ['<:= $value10 >  10 :>', ''],
    ['<:= $value10 >  11 :>', ''],
    ['<:= $value10 >=  9 :>',  1],
    ['<:= $value10 >= 10 :>',  1],
    ['<:= $value10 >= 11 :>', ''],


    ['<:= "foo" == "foo" ? 1 : 0 :>', 1],
    ['<:= "foo" == "bar" ? 1 : 0 :>', 0],
    ['<:= "foo" != "foo" ? 1 : 0 :>', 0],
    ['<:= "foo" != "bar" ? 1 : 0 :>', 1],


    ['<:= 3.14 == 3.14   ? 1 : 0 :>', 1],
    ['<:= 3.14 == 3.13   ? 1 : 0 :>', 0],
    ['<:= 3    == 3      ? 1 : 0 :>', 1],
    ['<:= 3    == 2      ? 1 : 0 :>', 0],

    ['<:= "0" == "0E0"   ? 1 : 0 :>', 0],
    ['<:= "0" == ""      ? 1 : 0 :>', 0],


    ['<:= "foo" == nil ? 1 : 0 :>', 0],
    ['<:= ""    == nil ? 1 : 0 :>', 0],
    ['<:= nil   == nil ? 1 : 0 :>', 1],

    ['<:= "foo" != nil ? 1 : 0 :>', 1],
    ['<:= ""    != nil ? 1 : 0 :>', 1],
    ['<:= nil   != nil ? 1 : 0 :>', 0],

    ['<:= 0 == nil     ? 1 : 0 :>', 0],
    ['<:= 0 != nil     ? 1 : 0 :>', 1],

    ['<:= $value0  && 20 :>',  0 ],
    ['<:= $value10 && 20 :>', 20 ],
    ['<:= ""       && 20 :>', "" ],
    ['<:= (nil && 20) == nil :>', 1 ], # cannot print nil (undef)

    ['<:= $value0  || 20 :>', 20 ],
    ['<:= $value10 || 20 :>', 10 ],
    ['<:= ""       || 20 :>', 20 ],
    ['<:= nil      || 20 :>', 20 ],

    ['<:= $value0  // 20 :>',  0 ],
    ['<:= $value10 // 20 :>', 10 ],
    ['<:= ""       // 20 :>', "" ],
    ['<:= nil      // 20 :>', 20 ],
);

foreach my $pair(@data) {
    my($in, $out) = @$pair;
    my $x = $tx->compile_str($in);

    my %vars = (
        value0  =>  0,
        value10 => 10,
        value20 => 20,
    );
    is $x->render(\%vars), $out, $in;
}

done_testing;
