package Encode::Detect::CJK;
use strict;
use warnings( FATAL => 'all' );
use Encode;

our $VERSION = '2.0.0';

#===================================
#===Author  : qian.yu            ===
#===Email   : foolfish@cpan.org  ===
#===MSN     : qian.yu@adways.net ===
#===QQ      : 9097939            ===
#===Homepage: www.fishlib.cn     ===
#===================================

#===2.0.0(2008-12-02): modify the name from CharsetDetector to Encode::Detect::CJK
#===1.0.0(2005-08-28): first release

#ascii      : ascii
#iso-8859-1 : iso-8859-1
#utf8       : utf8 utf-8-strict
#utf16      : utf16
#cp936      : euc-cn cp936 
#big5-eten  : big5-eten
#euc-jp     : euc-jp
#shiftjis   : shiftjis
#iso-2022-jp: iso-2022-jp
#euc-kr     : euc-kr
#iso-2022-kr:iso-2022-kr

my $GBFreq;
my $Big5Freq;
my $Big5PFreq;
my $EUC_TWFreq;
my $GBKFreq;
my $KRFreq;
my $JPFreq;

my $_encoding = {
	'ascii'       => 1,
	'utf8'        => 2,
	'utf16'       => 3,
	'cp936'       => 4,
	'big5-eten'   => 5,
	'euc-jp'      => 6,
	'shiftjis'    => 7,
	'iso-2022-jp' => 8,
	'euc-kr'      => 9,
	'iso-2022-kr' => 10,
	'iso-8859-1'  => 99
};

my $_encoding_reverse = {
	1  => 'ascii',
	2  => 'utf8',
	3  => 'utf16',
	4  => 'cp936',
	5  => 'big5-eten',
	6  => 'euc-jp',
	7  => 'shiftjis',
	8  => 'iso-2022-jp',
	9  => 'euc-kr',
	10 => 'iso-2022-kr',
	99 => 'iso-8859-1'
};

our $log_txt = "";

BEGIN {
	$GBFreq = [
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0,   0,   0,   0,   0, 0,   0,   0, 0,   0, 0, 0,
			0,   301, 0,   0,   0, 371, 0,   0, 0,   0, 0, 0,
			0,   0,   0,   0,   0, 0,   0,   0, 0,   0, 0, 0,
			0,   0,   0,   0,   0, 0,   318, 0, 0,   0, 0, 0,
			485, 0,   0,   0,   0, 0,   367, 0, 296, 0, 0, 0,
			0,   0,   0,   0,   0, 0,   0,   0, 0,   0, 0, 0,
			0,   0,   247, 250, 0, 0,   0,   0, 0,   0, 0, 0,
			0,   0,   0,   0,   0, 0,   0,   0, 0,   0,
		],
		[
			0, 0, 252, 0,   0,   0,   0,   381, 0, 0, 0, 0,
			0, 0, 0,   0,   419, 0,   0,   0,   0, 0, 0, 0,
			0, 0, 441, 0,   0,   513, 0,   0,   0, 0, 0, 0,
			0, 0, 0,   390, 0,   0,   0,   0,   0, 0, 0, 0,
			0, 0, 0,   0,   0,   0,   0,   244, 0, 0, 0, 0,
			0, 0, 326, 0,   0,   0,   445, 267, 0, 0, 0, 0,
			0, 0, 0,   0,   370, 0,   0,   397, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0,   0,   0,   0, 0,
		],
		[
			0,   416, 0,   0, 0,   0,   0,   0, 0, 0, 0, 0,
			0,   0,   0,   0, 0,   0,   0,   0, 0, 0, 0, 0,
			0,   0,   596, 0, 240, 0,   463, 0, 0, 0, 0, 0,
			394, 0,   0,   0, 0,   0,   0,   0, 0, 0, 0, 0,
			0,   0,   0,   0, 0,   0,   0,   0, 0, 0, 0, 0,
			0,   0,   0,   0, 0,   0,   0,   0, 0, 0, 0, 0,
			0,   0,   0,   0, 0,   0,   0,   0, 0, 0, 0, 0,
			0,   0,   0,   0, 0,   408, 0,   0, 0, 0,
		],
		[
			393, 0,   361, 500, 0,   0,   0, 0,   0,   0, 0, 0,
			0,   0,   0,   0,   0,   0,   0, 0,   368, 0, 0, 0,
			0,   0,   0,   0,   0,   0,   0, 0,   0,   0, 0, 0,
			0,   0,   243, 0,   533, 0,   0, 224, 0,   0, 0, 0,
			0,   0,   0,   295, 0,   200, 0, 0,   0,   0, 0, 0,
			0,   0,   0,   0,   0,   0,   0, 0,   0,   0, 0, 0,
			0,   0,   0,   0,   0,   0,   0, 0,   0,   0, 0, 0,
			0,   574, 0,   0,   0,   0,   0, 0,   0,   0,
		],
		[
			0, 0, 0,   0,   0, 396, 0,   0, 0, 0,   259, 0,
			0, 0, 0,   0,   0, 0,   0,   0, 0, 0,   0,   0,
			0, 0, 0,   0,   0, 0,   0,   0, 0, 0,   0,   0,
			0, 0, 0,   0,   0, 0,   483, 0, 0, 434, 0,   0,
			0, 0, 503, 0,   0, 0,   0,   0, 0, 0,   0,   0,
			0, 0, 0,   0,   0, 0,   0,   0, 0, 0,   0,   0,
			0, 0, 0,   0,   0, 0,   251, 0, 0, 446, 587, 0,
			0, 0, 0,   272, 0, 410, 0,   0, 0, 0,
		],
		[
			0,   0, 0, 0,   0,   0, 0,   0,   0, 0,   492, 0,
			0,   0, 0, 0,   529, 0, 203, 0,   0, 0,   0,   0,
			202, 0, 0, 0,   582, 0, 0,   573, 0, 207, 569, 599,
			0,   0, 0, 454, 0,   0, 0,   0,   0, 0,   0,   0,
			0,   0, 0, 0,   0,   0, 0,   575, 0, 437, 0,   0,
			0,   0, 0, 0,   0,   0, 477, 0,   0, 0,   439, 0,
			0,   0, 0, 0,   0,   0, 0,   0,   0, 0,   0,   0,
			0,   0, 0, 0,   0,   0, 0,   0,   0, 0,
		],
		[
			0, 0, 0,   0,   0,   0, 0, 460, 0, 0, 433, 0,
			0, 0, 502, 0,   0,   0, 0, 0,   0, 0, 0,   0,
			0, 0, 0,   541, 0,   0, 0, 0,   0, 0, 0,   0,
			0, 0, 0,   307, 0,   0, 0, 0,   0, 0, 0,   0,
			0, 0, 274, 554, 0,   0, 0, 0,   0, 0, 0,   0,
			0, 0, 0,   546, 0,   0, 0, 0,   0, 0, 0,   0,
			0, 0, 0,   0,   0,   0, 0, 0,   0, 0, 0,   0,
			0, 0, 0,   544, 467, 0, 0, 0,   0, 480,
		],
		[
			0,   534, 0,   0, 0,   0,   0, 484, 0, 0,   0,   0,
			0,   0,   0,   0, 0,   0,   0, 355, 0, 0,   0,   0,
			0,   0,   0,   0, 518, 0,   0, 0,   0, 0,   0,   0,
			353, 0,   283, 0, 0,   0,   0, 0,   0, 0,   0,   0,
			0,   0,   0,   0, 0,   495, 0, 0,   0, 0,   0,   0,
			0,   0,   0,   0, 0,   0,   0, 0,   0, 0,   324, 0,
			0,   0,   0,   0, 0,   0,   0, 0,   0, 278, 0,   0,
			0,   0,   0,   0, 0,   0,   0, 0,   0, 313,
		],
		[
			0, 0,   0,   0,   0,   0,   0,   0,   0, 0,   0,   0,
			0, 0,   0,   0,   0,   0,   0,   0,   0, 0,   0,   242,
			0, 0,   0,   0,   0,   0,   0,   0,   0, 0,   261, 0,
			0, 0,   0,   0,   322, 0,   0,   0,   0, 0,   0,   359,
			0, 0,   0,   0,   0,   0,   0,   0,   0, 0,   0,   0,
			0, 0,   488, 0,   0,   0,   0,   0,   0, 223, 0,   0,
			0, 0,   0,   0,   0,   0,   238, 0,   0, 0,   0,   0,
			0, 583, 334, 455, 0,   273, 0,   356, 0, 0,
		],
		[
			0, 0, 0, 470, 0, 286, 0,   0,   0,   0, 508, 0,
			0, 0, 0, 0,   0, 325, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0,   0, 0,   0,   0,   0,   0, 0,   0,
			0, 0, 0, 0,   0, 0,   0,   0,   0,   0, 0,   0,
			0, 0, 0, 0,   0, 0,   0,   417, 0,   0, 0,   279,
			0, 0, 0, 0,   0, 345, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0,   0, 0,   0,   0,   0,   0, 0,   0,
			0, 0, 0, 0,   0, 584, 343, 0,   557, 0,
		],
		[
			0, 0, 431, 0,   0, 0, 0, 0, 0,   0,   0,   0,
			0, 0, 0,   0,   0, 0, 0, 0, 0,   0,   0,   0,
			0, 0, 0,   0,   0, 0, 0, 0, 0,   0,   542, 0,
			0, 0, 0,   0,   0, 0, 0, 0, 577, 357, 354, 0,
			0, 0, 0,   0,   0, 0, 0, 0, 0,   0,   0,   452,
			0, 0, 0,   0,   0, 0, 0, 0, 0,   0,   0,   0,
			0, 0, 0,   256, 0, 0, 0, 0, 0,   246, 550, 0,
			0, 0, 0,   0,   0, 0, 0, 0, 0,   0,
		],
		[
			0,   0,   0,   0,   0,   0,   0, 271, 0, 382, 0, 0,
			0,   0,   413, 468, 0,   0,   0, 0,   0, 0,   0, 0,
			535, 0,   0,   0,   0,   0,   0, 0,   0, 0,   0, 0,
			0,   208, 0,   0,   0,   0,   0, 0,   0, 0,   0, 0,
			0,   0,   0,   0,   0,   0,   0, 481, 0, 0,   0, 0,
			0,   0,   0,   0,   562, 0,   0, 0,   0, 0,   0, 0,
			0,   0,   0,   0,   0,   376, 0, 0,   0, 349, 0, 0,
			0,   0,   0,   0,   219, 456, 0, 0,   0, 0,
		],
		[
			0, 0,   0,   0,   0, 0, 0,   0,   0, 0, 210, 0,
			0, 0,   0,   340, 0, 0, 0,   235, 0, 0, 0,   453,
			0, 469, 0,   226, 0, 0, 0,   0,   0, 0, 0,   0,
			0, 350, 327, 0,   0, 0, 0,   0,   0, 0, 0,   0,
			0, 556, 414, 0,   0, 0, 0,   0,   0, 0, 0,   0,
			0, 0,   0,   0,   0, 0, 0,   449, 0, 0, 0,   0,
			0, 0,   0,   0,   0, 0, 0,   0,   0, 0, 0,   0,
			0, 0,   0,   0,   0, 0, 512, 0,   0, 372,
		],
		[
			0,   0, 0,   0,   0,   0,   0, 309, 0,   0, 494, 0,
			222, 0, 0,   0,   0,   0,   0, 0,   0,   0, 0,   0,
			0,   0, 302, 0,   0,   0,   0, 0,   0,   0, 0,   0,
			0,   0, 0,   0,   0,   0,   0, 428, 0,   0, 0,   363,
			0,   0, 321, 0,   0,   0,   0, 0,   0,   0, 0,   0,
			0,   0, 0,   0,   288, 335, 0, 0,   0,   0, 341, 0,
			0,   0, 0,   0,   0,   0,   0, 358, 339, 0, 0,   0,
			0,   0, 0,   486, 0,   0,   0, 258, 0,   0,
		],
		[
			0,   0,   0, 0, 0, 0, 0, 0,   338, 0, 0, 0,
			511, 0,   0, 0, 0, 0, 0, 0,   0,   0, 0, 0,
			0,   0,   0, 0, 0, 0, 0, 0,   0,   0, 0, 0,
			387, 0,   0, 0, 0, 0, 0, 0,   568, 0, 0, 0,
			0,   0,   0, 0, 0, 0, 0, 0,   0,   0, 0, 0,
			0,   0,   0, 0, 0, 0, 0, 0,   0,   0, 0, 0,
			0,   0,   0, 0, 0, 0, 0, 0,   0,   0, 0, 0,
			316, 254, 0, 0, 0, 0, 0, 409, 0,   0,
		],
		[
			0, 0,   0, 0,   0,   0, 0, 0,   0, 524, 0, 0,
			0, 0,   0, 0,   0,   0, 0, 527, 0, 0,   0, 0,
			0, 0,   0, 0,   0,   0, 0, 0,   0, 0,   0, 0,
			0, 293, 0, 0,   553, 0, 0, 0,   0, 0,   0, 0,
			0, 0,   0, 0,   229, 0, 0, 0,   0, 430, 0, 0,
			0, 0,   0, 0,   0,   0, 0, 0,   0, 0,   0, 0,
			0, 0,   0, 270, 0,   0, 0, 0,   0, 0,   0, 0,
			0, 0,   0, 0,   0,   0, 0, 0,   0, 0,
		],
		[
			0, 0, 0, 0, 0,   0,   0,   0,   0, 0, 0,   0,
			0, 0, 0, 0, 0,   0,   0,   586, 0, 0, 0,   0,
			0, 0, 0, 0, 0,   0,   0,   0,   0, 0, 0,   0,
			0, 0, 0, 0, 0,   0,   0,   0,   0, 0, 504, 0,
			0, 0, 0, 0, 0,   0,   0,   0,   0, 0, 0,   0,
			0, 0, 0, 0, 0,   0,   0,   0,   0, 0, 0,   0,
			0, 0, 0, 0, 479, 215, 551, 0,   0, 0, 0,   0,
			0, 0, 0, 0, 0,   0,   347, 0,   0, 0,
		],
		[
			0, 380, 0,   0,   0,   457, 0,   0, 0, 266, 0, 277,
			0, 0,   0,   0,   0,   0,   205, 0, 0, 0,   0, 0,
			0, 0,   0,   0,   501, 0,   230, 0, 0, 0,   0, 0,
			0, 0,   0,   0,   0,   0,   595, 0, 0, 0,   0, 0,
			0, 0,   0,   0,   0,   311, 0,   0, 0, 0,   0, 0,
			0, 0,   0,   0,   0,   0,   0,   0, 0, 0,   0, 0,
			0, 0,   0,   260, 0,   209, 0,   0, 0, 0,   0, 257,
			0, 0,   282, 0,   287, 0,   0,   0, 0, 0,
		],
		[
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 365, 0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 297, 0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 379, 0,   0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0,   217, 0, 0, 0, 0,
		],
		[
			0,   0, 0,   0, 0, 0, 0,   0,   0,   0,   312, 0,
			0,   0, 0,   0, 0, 0, 0,   548, 0,   0,   0,   0,
			0,   0, 539, 0, 0, 0, 281, 478, 0,   0,   0,   0,
			436, 0, 580, 0, 0, 0, 0,   0,   0,   0,   0,   0,
			0,   0, 0,   0, 0, 0, 0,   0,   0,   0,   0,   0,
			0,   0, 0,   0, 0, 0, 0,   0,   0,   509, 0,   0,
			0,   0, 0,   0, 0, 0, 0,   0,   498, 0,   0,   0,
			0,   0, 475, 0, 0, 0, 461, 378, 0,   0,
		],
		[
			0,   0,   0,   0, 0, 0, 0,   0,   0, 0,   0,   0,
			0,   0,   0,   0, 0, 0, 0,   0,   0, 0,   0,   0,
			0,   0,   0,   0, 0, 0, 383, 0,   0, 0,   0,   0,
			0,   0,   567, 0, 0, 0, 0,   0,   0, 0,   308, 0,
			375, 0,   0,   0, 0, 0, 0,   212, 0, 415, 0,   543,
			0,   0,   0,   0, 0, 0, 576, 0,   0, 0,   0,   0,
			0,   570, 0,   0, 0, 0, 0,   0,   0, 0,   0,   0,
			0,   0,   0,   0, 0, 0, 0,   0,   0, 0,
		],
		[
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 459, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 218, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0,
		],
		[
			0, 0, 0,   0,   0,   0, 0, 0,   0, 0,   0,   0,
			0, 0, 0,   0,   0,   0, 0, 0,   0, 0,   233, 0,
			0, 0, 0,   0,   425, 0, 0, 0,   0, 0,   0,   0,
			0, 0, 0,   0,   0,   0, 0, 0,   0, 0,   0,   0,
			0, 0, 0,   0,   0,   0, 0, 0,   0, 364, 0,   0,
			0, 0, 245, 0,   0,   0, 0, 474, 0, 0,   0,   0,
			0, 0, 0,   0,   0,   0, 0, 536, 0, 0,   0,   0,
			0, 0, 0,   421, 0,   0, 0, 0,   0, 0,
		],
		[
			0,   0,   0,   0,   0,   0, 0,   0, 0,   0, 0,   0,
			0,   204, 0,   515, 0,   0, 0,   0, 0,   0, 0,   0,
			0,   0,   0,   0,   0,   0, 241, 0, 0,   0, 0,   0,
			0,   0,   0,   0,   0,   0, 0,   0, 0,   0, 0,   0,
			0,   0,   0,   0,   0,   0, 342, 0, 0,   0, 0,   0,
			0,   0,   0,   280, 225, 0, 0,   0, 331, 0, 0,   0,
			464, 0,   303, 0,   0,   0, 0,   0, 0,   0, 234, 0,
			0,   0,   0,   236, 0,   0, 0,   0, 0,   0,
		],
		[
			0, 0, 0,   0, 559, 0, 0,   264, 0,   0,   471, 0,
			0, 0, 0,   0, 0,   0, 0,   411, 0,   0,   0,   0,
			0, 0, 540, 0, 0,   0, 0,   0,   0,   0,   300, 0,
			0, 0, 0,   0, 0,   0, 594, 0,   0,   333, 299, 0,
			0, 0, 0,   0, 538, 0, 0,   0,   0,   0,   0,   0,
			0, 0, 0,   0, 0,   0, 0,   0,   0,   0,   516, 0,
			0, 0, 407, 0, 0,   0, 0,   0,   0,   0,   0,   0,
			0, 0, 0,   0, 0,   0, 0,   0,   506, 0,
		],
		[
			0,   0, 0, 0, 0,   0,   0, 0, 0,   0, 305, 0,
			0,   0, 0, 0, 0,   0,   0, 0, 0,   0, 0,   0,
			0,   0, 0, 0, 405, 0,   0, 0, 0,   0, 0,   0,
			0,   0, 0, 0, 0,   0,   0, 0, 0,   0, 585, 0,
			0,   0, 0, 0, 0,   0,   0, 0, 418, 0, 0,   0,
			0,   0, 0, 0, 0,   0,   0, 0, 0,   0, 290, 0,
			0,   0, 0, 0, 491, 237, 0, 0, 374, 0, 0,   0,
			228, 0, 0, 0, 472, 563, 0, 0, 0,   0,
		],
		[
			0,   0,   0,   0, 0,   392, 0,   0,   0,   0,   0, 0,
			0,   522, 0,   0, 571, 447, 0,   0,   482, 211, 0, 0,
			429, 0,   0,   0, 216, 0,   232, 422, 0,   532, 0, 0,
			0,   0,   597, 0, 0,   0,   0,   0,   0,   0,   0, 400,
			0,   0,   0,   0, 206, 523, 0,   0,   0,   0,   0, 346,
			0,   0,   0,   0, 0,   0,   0,   0,   0,   0,   0, 0,
			391, 0,   0,   0, 0,   0,   0,   0,   0,   0,   0, 0,
			289, 0,   0,   0, 0,   0,   0,   0,   373, 0,
		],
		[
			0, 0,   0, 0,   0,   0,   0,   0,   0,   0, 0, 0,
			0, 402, 0, 0,   0,   0,   0,   0,   581, 0, 0, 0,
			0, 0,   0, 284, 0,   348, 0,   362, 0,   0, 0, 438,
			0, 0,   0, 0,   0,   0,   0,   0,   0,   0, 0, 0,
			0, 0,   0, 0,   0,   0,   0,   0,   0,   0, 0, 0,
			0, 0,   0, 0,   0,   0,   298, 0,   0,   0, 0, 0,
			0, 0,   0, 0,   0,   0,   0,   0,   0,   0, 0, 0,
			0, 0,   0, 0,   514, 0,   590, 320, 552, 0,
		],
		[
			0,   0, 0, 0,   0,   0,   0, 329, 0,   0, 403, 0,
			0,   0, 0, 0,   0,   0,   0, 0,   0,   0, 0,   0,
			0,   0, 0, 0,   0,   0,   0, 0,   0,   0, 0,   0,
			0,   0, 0, 0,   0,   0,   0, 0,   0,   0, 0,   0,
			0,   0, 0, 0,   0,   0,   0, 317, 0,   0, 0,   0,
			0,   0, 0, 0,   360, 310, 0, 0,   398, 0, 0,   0,
			0,   0, 0, 545, 0,   0,   0, 0,   0,   0, 0,   0,
			269, 0, 0, 0,   0,   0,   0, 0,   423, 0,
		],
		[
			0,   0,   0, 0, 0,   0,   0,   384, 0, 0,   0,   507,
			0,   0,   0, 0, 0,   0,   306, 0,   0, 0,   510, 0,
			0,   0,   0, 0, 0,   0,   0,   0,   0, 0,   0,   0,
			0,   0,   0, 0, 0,   0,   0,   0,   0, 0,   0,   0,
			0,   0,   0, 0, 0,   0,   0,   0,   0, 0,   0,   0,
			0,   0,   0, 0, 0,   493, 0,   0,   0, 0,   0,   0,
			0,   239, 0, 0, 0,   0,   0,   0,   0, 401, 0,   0,
			344, 0,   0, 0, 263, 0,   315, 0,   0, 0,
		],
		[
			0, 0,   0,   0, 0, 0,   0,   0,   0,   579, 0, 0,
			0, 0,   0,   0, 0, 0,   0,   201, 0,   0,   0, 0,
			0, 0,   444, 0, 0, 0,   0,   0,   0,   0,   0, 526,
			0, 0,   0,   0, 0, 458, 0,   0,   0,   0,   0, 0,
			0, 593, 0,   0, 0, 0,   0,   0,   0,   0,   0, 0,
			0, 525, 0,   0, 0, 0,   0,   248, 404, 0,   0, 0,
			0, 0,   0,   0, 0, 0,   330, 0,   337, 0,   0, 0,
			0, 0,   427, 0, 0, 0,   0,   0,   0,   0,
		],
		[
			0, 214, 0,   0,   0, 0,   0, 0, 0,   0,   0,   0,
			0, 0,   0,   0,   0, 0,   0, 0, 351, 0,   0,   0,
			0, 0,   0,   0,   0, 0,   0, 0, 0,   565, 0,   0,
			0, 0,   0,   406, 0, 0,   0, 0, 0,   0,   0,   0,
			0, 0,   0,   0,   0, 496, 0, 0, 0,   0,   0,   0,
			0, 0,   0,   435, 0, 0,   0, 0, 0,   0,   0,   0,
			0, 0,   528, 0,   0, 0,   0, 0, 0,   465, 328, 0,
			0, 0,   0,   0,   0, 0,   0, 0, 0,   0,
		],
		[
			549, 0, 0, 0,   0,   386, 0, 0,   490, 0,   0, 0,
			0,   0, 0, 0,   0,   0,   0, 213, 0,   0,   0, 0,
			0,   0, 0, 0,   0,   0,   0, 0,   0,   448, 0, 547,
			420, 0, 0, 0,   0,   0,   0, 0,   0,   0,   0, 519,
			0,   0, 0, 385, 0,   0,   0, 0,   0,   0,   0, 0,
			0,   0, 0, 0,   0,   0,   0, 0,   0,   0,   0, 0,
			0,   0, 0, 0,   319, 0,   0, 0,   0,   0,   0, 0,
			0,   0, 0, 0,   0,   0,   0, 0,   0,   0,
		],
		[
			0, 0, 0, 0,   0,   0, 555, 0, 0, 0, 0,   0,
			0, 0, 0, 0,   0,   0, 0,   0, 0, 0, 0,   0,
			0, 0, 0, 0,   0,   0, 0,   0, 0, 0, 0,   0,
			0, 0, 0, 0,   0,   0, 0,   0, 0, 0, 0,   0,
			0, 0, 0, 265, 0,   0, 0,   0, 0, 0, 399, 0,
			0, 0, 0, 0,   0,   0, 0,   0, 0, 0, 0,   0,
			0, 0, 0, 0,   0,   0, 0,   0, 0, 0, 0,   0,
			0, 0, 0, 0,   497, 0, 0,   0, 0, 0,
		],
		[
			0,   0, 0,   0,   0, 0,   0, 0, 0,   566, 0, 0,
			0,   0, 0,   0,   0, 572, 0, 0, 451, 0,   0, 0,
			0,   0, 598, 0,   0, 0,   0, 0, 0,   0,   0, 0,
			0,   0, 0,   0,   0, 0,   0, 0, 0,   0,   0, 0,
			505, 0, 0,   564, 0, 0,   0, 0, 0,   0,   0, 0,
			0,   0, 0,   0,   0, 487, 0, 0, 294, 0,   0, 0,
			0,   0, 0,   0,   0, 0,   0, 0, 0,   443, 0, 0,
			0,   0, 0,   0,   0, 0,   0, 0, 0,   0,
		],
		[
			0, 220, 0,   0, 0,   366, 0,   0, 0, 0,   0,   0,
			0, 0,   0,   0, 0,   0,   0,   0, 0, 0,   0,   0,
			0, 0,   0,   0, 0,   0,   0,   0, 0, 0,   521, 0,
			0, 0,   0,   0, 412, 0,   0,   0, 0, 0,   0,   591,
			0, 0,   0,   0, 0,   517, 0,   0, 0, 537, 0,   0,
			0, 0,   0,   0, 0,   0,   0,   0, 0, 0,   0,   0,
			0, 0,   489, 0, 0,   0,   221, 0, 0, 0,   0,   0,
			0, 0,   0,   0, 0,   0,   0,   0, 0, 0,
		],
		[
			0,   0,   0, 0, 0,   0, 0,   0, 0,   291, 0, 0,
			369, 0,   0, 0, 388, 0, 0,   0, 0,   276, 0, 0,
			0,   268, 0, 0, 0,   0, 0,   0, 0,   476, 0, 0,
			0,   0,   0, 0, 0,   0, 249, 0, 0,   0,   0, 0,
			0,   0,   0, 0, 0,   0, 0,   0, 426, 592, 0, 0,
			0,   0,   0, 0, 0,   0, 0,   0, 0,   0,   0, 0,
			0,   0,   0, 0, 0,   0, 0,   0, 0,   0,   0, 0,
			292, 0,   0, 0, 0,   0, 0,   0, 0,   0,
		],
		[
			0,   0, 0,   0, 0,   0,   0, 0, 0,   0,   0, 0,
			0,   0, 0,   0, 0,   0,   0, 0, 0,   0,   0, 0,
			262, 0, 0,   0, 323, 0,   0, 0, 0,   0,   0, 0,
			377, 0, 0,   0, 0,   0,   0, 0, 0,   0,   0, 0,
			0,   0, 0,   0, 0,   0,   0, 0, 0,   0,   0, 0,
			0,   0, 466, 0, 0,   589, 0, 0, 0,   424, 0, 0,
			0,   0, 0,   0, 0,   0,   0, 0, 0,   0,   0, 0,
			0,   0, 0,   0, 0,   0,   0, 0, 462, 432,
		],
		[
			0, 0,   0,   0, 0,   0,   0, 0,   0,   499, 0, 0,
			0, 558, 0,   0, 314, 0,   0, 0,   0,   0,   0, 285,
			0, 0,   531, 0, 0,   0,   0, 0,   332, 0,   0, 0,
			0, 336, 0,   0, 0,   0,   0, 0,   0,   255, 0, 588,
			0, 0,   0,   0, 0,   473, 0, 442, 0,   227, 0, 253,
			0, 0,   0,   0, 0,   0,   0, 0,   0,   0,   0, 0,
			0, 0,   0,   0, 0,   0,   0, 0,   0,   0,   0, 0,
			0, 0,   520, 0, 0,   0,   0, 0,   0,   0,
		],
		[
			389, 0,   0,   0,   0, 0,   0, 0, 0, 231, 0, 0,
			0,   0,   0,   0,   0, 0,   0, 0, 0, 0,   0, 0,
			0,   0,   0,   0,   0, 0,   0, 0, 0, 0,   0, 0,
			560, 0,   0,   0,   0, 275, 0, 0, 0, 0,   0, 0,
			0,   0,   578, 561, 0, 304, 0, 0, 0, 0,   0, 395,
			0,   0,   440, 0,   0, 0,   0, 0, 0, 0,   0, 0,
			0,   0,   0,   0,   0, 450, 0, 0, 0, 0,   0, 0,
			0,   352, 530, 0,   0, 0,   0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
	];
	$Big5Freq = [
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			596, 0,   0,   0,   0,   0,   591, 468, 592, 0,   371, 0,
			0,   0,   0,   460, 0,   438, 0,   462, 490, 559, 0,   578,
			0,   0,   0,   0,   0,   573, 0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   271, 0,   594, 458, 538, 0,   0,   0,
			551, 0,   0,   312, 0,   547, 442, 448, 0,   0,   0,   0,
			0,   0,   429, 0,   0,   0,   598, 590, 0,   0,   550, 0,
			0,   0,   0,   0,   292, 0,   0,   479, 0,   0,   0,   0,
			335, 0,   0,   231, 0,   360, 0,   0,   407, 0,   0,   454,
			0,   0,   0,   0,   0,   284, 0,   0,   0,   0,   0,   0,
			430, 405, 272, 0,   555, 0,   445, 0,   0,   420, 0,   0,
			0,   0,   0,   0,   0,   0,   533, 0,   0,   450, 0,   207,
			568, 0,   0,   493, 477, 0,   387, 0,   0,   0,   0,   0,
			465, 0,   0,   397, 0,   0,   0,   0,   249, 0,   0,   0,
			282, 0,
		],
		[
			278, 0,   309, 0,   440, 0,   0,   0,   586, 0,   0,   0,
			565, 0,   327, 0,   0,   0,   0,   202, 0,   0,   0,   0,
			546, 0,   0,   418, 262, 0,   0,   265, 0,   0,   0,   0,
			204, 0,   0,   0,   531, 585, 0,   0,   0,   0,   0,   0,
			0,   0,   0,   230, 0,   532, 0,   0,   527, 0,   0,   0,
			367, 0,   435, 0,   240, 0,   0,   0,   0,   358, 0,   0,
			0,   0,   246, 0,   258, 0,   0,   0,   0,   264, 0,   446,
			0,   0,   0,   0,   0,   0,   511, 223, 0,   0,   476, 0,
			425, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			561, 572, 0,   0,   365, 0,   0,   0,   243, 0,   0,   352,
			0,   0,   0,   0,   0,   0,   353, 0,   0,   0,   0,   0,
			0,   574, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   224, 281, 0,   0,   228, 0,   0,   336, 0,   0,
			381, 422,
		],
		[
			0,   470, 0,   0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,   0,   0,   0,   524, 0,   0,   0,   0, 423, 248, 480,
			350, 0,   0,   0,   0,   503, 417, 0,   0, 519, 593, 0,
			0,   0,   0,   0,   553, 0,   0,   0,   0, 0,   580, 426,
			570, 0,   320, 0,   0,   0,   0,   241, 0, 0,   0,   0,
			0,   0,   510, 0,   415, 0,   0,   0,   0, 0,   0,   526,
			0,   0,   0,   0,   0,   0,   0,   0,   0, 0,   595, 0,
			0,   0,   0,   449, 488, 274, 0,   0,   0, 0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0, 0,   219, 0,
			0,   0,   0,   0,   411, 343, 539, 0,   0, 0,   0,   0,
			0,   0,   540, 354, 0,   0,   0,   0,   0, 253, 0,   0,
			0,   483, 0,   289, 0,   0,   0,   486, 0, 0,   0,   0,
			0,   0,   523, 0,   0,   0,   0,   0,   0, 0,   0,   0,
			515, 0,
		],
		[
			485, 582, 0,   0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,   0,   0,   402, 0,   245, 0,   0,   0, 0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   373, 0, 487, 0,   0,
			0,   0,   0,   0,   0,   346, 0,   0,   0, 0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,   0,   0,   0,   324, 0,   0,   0,   0, 0,   0,   0,
			0,   0,   0,   0,   0,   287, 0,   0,   0, 0,   0,   332,
			0,   0,   0,   0,   0,   0,   0,   0,   0, 356, 0,   0,
			0,   597, 0,   0,   0,   0,   0,   0,   0, 409, 0,   370,
			0,   0,   0,   0,   0,   0,   215, 0,   0, 0,   305, 0,
			0,   0,   345, 0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,   0,
		],
		[
			0, 0,   0,   311, 227, 0,   0,   0,   0,   0,   0, 0,
			0, 222, 0,   0,   0,   0,   0,   566, 0,   0,   0, 0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
			0, 0,   0,   0,   0,   0,   0,   314, 0,   0,   0, 0,
			0, 0,   0,   226, 452, 0,   0,   0,   0,   0,   0, 0,
			0, 0,   0,   0,   0,   0,   393, 0,   321, 0,   0, 0,
			0, 0,   211, 0,   329, 455, 0,   0,   0,   0,   0, 0,
			0, 0,   0,   0,   0,   563, 0,   0,   0,   0,   0, 0,
			0, 0,   318, 0,   0,   495, 492, 0,   0,   0,   0, 0,
			0, 0,   432, 0,   0,   0,   577, 0,   0,   0,   0, 0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   419, 0, 497,
			0, 0,   0,   0,   0,   0,   0,   589, 0,   0,   0, 0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   285, 0, 277,
			0, 225,
		],
		[
			0,   0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0,
			0,   504, 0,   434, 0, 0,   0, 0,   0, 0,   0, 0,
			0,   0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0,
			0,   0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0,
			247, 0,   0,   0,   0, 0,   0, 500, 0, 0,   0, 0,
			0,   0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0,
			0,   0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0,
			0,   0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0,
			0,   0,   0,   0,   0, 0,   0, 0,   0, 412, 0, 0,
			0,   461, 0,   0,   0, 554, 0, 0,   0, 0,   0, 0,
			0,   0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0,
			0,   0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0,
			303, 0,   513, 0,   0, 0,   0, 0,   0, 447, 0, 0,
			0,   0,
		],
		[
			0,   0, 0,   0, 0,   0,   391, 502, 0,   0,   0, 0,
			280, 0, 0,   0, 0,   0,   0,   0,   0,   0,   0, 0,
			0,   0, 0,   0, 0,   0,   0,   0,   0,   0,   0, 0,
			0,   0, 0,   0, 0,   0,   0,   518, 0,   0,   0, 0,
			0,   0, 0,   0, 0,   0,   0,   0,   0,   0,   0, 0,
			0,   0, 0,   0, 0,   0,   0,   0,   0,   0,   0, 0,
			340, 0, 283, 0, 0,   0,   0,   0,   316, 0,   0, 0,
			0,   0, 0,   0, 0,   600, 0,   0,   299, 530, 0, 351,
			0,   0, 0,   0, 269, 0,   0,   0,   0,   0,   0, 482,
			0,   0, 0,   0, 0,   0,   0,   0,   0,   0,   0, 0,
			0,   0, 0,   0, 0,   0,   0,   0,   232, 0,   0, 0,
			0,   0, 0,   0, 0,   0,   0,   0,   361, 0,   0, 0,
			276, 0, 0,   0, 0,   0,   255, 451, 201, 0,   0, 0,
			0,   0,
		],
		[
			0, 0,   0,   0,   307, 0,   0,   0,   525, 0, 0,   273,
			0, 0,   0,   229, 0,   0,   0,   0,   0,   0, 0,   0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0, 0,   0,
			0, 508, 0,   0,   252, 0,   0,   0,   0,   0, 0,   266,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0, 0,   0,
			0, 0,   0,   0,   0,   302, 0,   0,   0,   0, 0,   0,
			0, 0,   0,   0,   0,   0,   0,   467, 0,   0, 0,   0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0, 0,   0,
			0, 0,   0,   0,   0,   0,   213, 0,   0,   0, 0,   0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0, 342, 306,
			0, 0,   0,   528, 0,   0,   0,   0,   537, 0, 0,   233,
			0, 0,   348, 0,   0,   0,   0,   0,   0,   0, 0,   0,
			0, 0,   0,   0,   0,   0,   0,   0,   217, 0, 0,   293,
			0, 0,
		],
		[
			0, 0, 0,   0,   0,   0, 317, 0,   0, 0,   0,   0,
			0, 0, 0,   599, 308, 0, 0,   0,   0, 0,   0,   0,
			0, 0, 0,   0,   0,   0, 0,   0,   0, 0,   0,   0,
			0, 0, 0,   0,   0,   0, 0,   0,   0, 0,   0,   0,
			0, 0, 0,   0,   0,   0, 0,   0,   0, 208, 0,   0,
			0, 0, 0,   0,   301, 0, 0,   0,   0, 0,   0,   0,
			0, 0, 0,   0,   0,   0, 0,   579, 0, 0,   0,   0,
			0, 0, 0,   0,   0,   0, 0,   0,   0, 0,   0,   0,
			0, 0, 0,   0,   0,   0, 0,   0,   0, 0,   0,   0,
			0, 0, 0,   0,   0,   0, 0,   0,   0, 0,   0,   0,
			0, 0, 441, 0,   564, 0, 0,   0,   0, 0,   300, 0,
			0, 0, 0,   0,   0,   0, 0,   494, 0, 0,   0,   0,
			0, 0, 0,   0,   0,   0, 0,   0,   0, 0,   0,   382,
			0, 0,
		],
		[
			0,   0,   0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0,   0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   331, 0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0,   0,   0, 0, 0, 0,   0,   0,   0, 587, 0,
			322, 0,   0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0,   0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0,   400, 0, 0, 0, 0,   0,   464, 0, 0,   0,
			380, 0,   390, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0,   0,   0, 0, 0, 0,   0,   0,   0, 0,   556,
			0,   0,   0,   0, 0, 0, 583, 0,   0,   0, 0,   0,
			0,   0,   0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0,   0,   0, 0, 0, 0,   383, 0,   0, 0,   0,
			0,   0,   0,   0, 0, 0, 0,   0,   0,   0, 256, 0,
			0,   214,
		],
		[
			0, 0,   0, 0, 0,   0, 0,   0, 0,   0,   0, 0,
			0, 0,   0, 0, 0,   0, 0,   0, 0,   0,   0, 0,
			0, 0,   0, 0, 0,   0, 0,   0, 0,   535, 0, 0,
			0, 251, 0, 0, 0,   0, 0,   0, 0,   0,   0, 0,
			0, 0,   0, 0, 0,   0, 319, 0, 0,   0,   0, 0,
			0, 0,   0, 0, 0,   0, 0,   0, 0,   0,   0, 0,
			0, 0,   0, 0, 0,   0, 0,   0, 0,   0,   0, 0,
			0, 0,   0, 0, 0,   0, 0,   0, 0,   0,   0, 0,
			0, 0,   0, 0, 0,   0, 0,   0, 569, 0,   0, 0,
			0, 0,   0, 0, 369, 0, 0,   0, 403, 0,   0, 0,
			0, 0,   0, 0, 0,   0, 0,   0, 0,   0,   0, 0,
			0, 0,   0, 0, 0,   0, 0,   0, 0,   0,   0, 290,
			0, 0,   0, 0, 0,   0, 0,   0, 0,   0,   0, 0,
			0, 0,
		],
		[
			0, 0, 0,   0,   0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 0,   0,   0,   0,   0, 239, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 0,   0,   0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 0,   0,   0,   506, 0, 0,   0, 0, 0, 0,
			0, 0, 0,   0,   0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 286, 0,   0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 0,   534, 0,   216, 0, 0,   0, 0, 0, 0,
			0, 0, 0,   0,   218, 0,   0, 0,   0, 0, 0, 0,
			0, 0, 0,   0,   0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 0,   0,   0,   0,   0, 571, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 0,   0,   0,   0,   0, 0,   0, 0, 0, 0,
			0, 0,
		],
		[
			0,   0,   0,   0,   0,   0,   0, 0,   0,   0,   0, 0,
			0,   0,   0,   328, 0,   254, 0, 0,   536, 0,   0, 0,
			0,   0,   0,   0,   0,   0,   0, 443, 0,   0,   0, 0,
			0,   0,   0,   0,   0,   0,   0, 0,   0,   0,   0, 0,
			0,   0,   0,   0,   0,   0,   0, 0,   0,   0,   0, 0,
			0,   0,   0,   0,   0,   0,   0, 0,   0,   0,   0, 0,
			0,   463, 0,   0,   0,   0,   0, 0,   0,   0,   0, 0,
			396, 0,   0,   0,   0,   0,   0, 0,   0,   0,   0, 0,
			0,   0,   0,   427, 0,   0,   0, 0,   0,   466, 0, 0,
			0,   0,   376, 0,   0,   0,   0, 0,   385, 0,   0, 0,
			0,   366, 0,   0,   562, 0,   0, 0,   0,   0,   0, 0,
			0,   0,   0,   0,   0,   529, 0, 0,   0,   0,   0, 0,
			0,   0,   0,   0,   0,   0,   0, 0,   0,   0,   0, 0,
			0,   0,
		],
		[
			0,   0,   0,   0,   0,   0,   0,   0, 0,   0, 0,   0,
			0,   0,   421, 0,   0,   0,   0,   0, 0,   0, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   0, 395, 0, 0,   0,
			0,   0,   0,   0,   0,   315, 242, 0, 0,   0, 0,   548,
			0,   357, 0,   0,   0,   0,   0,   0, 0,   0, 394, 0,
			0,   0,   0,   0,   498, 0,   0,   0, 0,   0, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   0, 0,   0, 0,   0,
			323, 0,   0,   0,   0,   0,   0,   0, 0,   0, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   0, 0,   0, 0,   0,
			0,   0,   0,   456, 0,   0,   0,   0, 0,   0, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   0, 0,   0, 0,   0,
			0,   349, 0,   0,   0,   0,   0,   0, 0,   0, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   0, 0,   0, 0,   0,
			0,   0,
		],
		[
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0,   0,   0,
			0, 491, 0, 0,   0, 0, 0, 0, 0,   0,   0,   0,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0,   0,   0,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0,   0,   0,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   413, 484, 509,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0,   0,   0,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0,   0,   0,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0,   0,   0,
			0, 0,   0, 414, 0, 0, 0, 0, 0,   0,   0,   0,
			0, 330, 0, 0,   0, 0, 0, 0, 221, 0,   0,   0,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0,   0,   0,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0,   0,   0,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0,   0,   0,
			0, 0,
		],
		[
			0, 0,   325, 0,   0,   0,   0,   0,   0,   0, 0, 0,
			0, 0,   0,   0,   0,   408, 0,   0,   0,   0, 0, 0,
			0, 0,   0,   0,   337, 298, 0,   0,   0,   0, 0, 0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0, 0, 584,
			0, 379, 0,   304, 0,   0,   0,   0,   0,   0, 0, 0,
			0, 0,   0,   0,   384, 0,   542, 0,   0,   0, 0, 0,
			0, 0,   0,   0,   0,   0,   297, 0,   0,   0, 0, 0,
			0, 0,   0,   0,   522, 0,   0,   0,   0,   0, 0, 0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0, 0, 507,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0, 0, 0,
			0, 0,   0,   0,   0,   0,   338, 0,   210, 0, 0, 0,
			0, 279, 0,   0,   0,   0,   0,   0,   0,   0, 0, 0,
			0, 0,   0,   0,   359, 0,   0,   296, 0,   0, 0, 0,
			0, 0,
		],
		[
			0,   0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 575, 0,
			0,   0, 0,   0, 0, 0, 0, 0, 344, 0, 0, 0, 0, 0, 0,   0,
			0,   0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,
			0,   0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,
			0,   0, 560, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,
			0,   0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 212, 0,
			375, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,
			0,   0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,
			0,   0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,
			0,   0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
		],
		[
			0,   0,   0,   0, 0,   0, 0, 0, 0,   0,   0, 0,
			517, 516, 0,   0, 0,   0, 0, 0, 0,   0,   0, 0,
			0,   0,   0,   0, 0,   0, 0, 0, 0,   0,   0, 0,
			0,   0,   0,   0, 0,   0, 0, 0, 0,   0,   0, 520,
			0,   0,   0,   0, 0,   0, 0, 0, 0,   0,   0, 410,
			0,   0,   0,   0, 0,   0, 0, 0, 386, 0,   0, 0,
			0,   0,   0,   0, 0,   0, 0, 0, 0,   310, 0, 0,
			0,   0,   0,   0, 399, 0, 0, 0, 0,   0,   0, 0,
			0,   0,   0,   0, 0,   0, 0, 0, 0,   0,   0, 0,
			0,   0,   0,   0, 0,   0, 0, 0, 0,   0,   0, 469,
			0,   0,   424, 0, 0,   0, 0, 0, 0,   0,   0, 0,
			0,   0,   0,   0, 0,   0, 0, 0, 0,   0,   0, 0,
			0,   0,   0,   0, 0,   0, 0, 0, 0,   0,   0, 0,
			0,   0,
		],
		[
			0, 0,   0, 0,   0,   0,   0,   0,   0, 0, 0, 0,
			0, 0,   0, 0,   0,   0,   334, 0,   0, 0, 0, 0,
			0, 0,   0, 0,   0,   0,   0,   0,   0, 0, 0, 0,
			0, 0,   0, 0,   0,   428, 0,   0,   0, 0, 0, 0,
			0, 0,   0, 0,   0,   0,   0,   0,   0, 0, 0, 0,
			0, 475, 0, 0,   437, 0,   0,   268, 0, 0, 0, 0,
			0, 0,   0, 0,   0,   0,   0,   0,   0, 0, 0, 0,
			0, 0,   0, 0,   0,   0,   0,   0,   0, 0, 0, 0,
			0, 0,   0, 0,   0,   0,   234, 0,   0, 0, 0, 0,
			0, 0,   0, 0,   0,   0,   0,   0,   0, 0, 0, 0,
			0, 0,   0, 512, 0,   0,   0,   0,   0, 0, 0, 0,
			0, 0,   0, 0,   0,   0,   0,   0,   0, 0, 0, 0,
			0, 0,   0, 0,   0,   0,   0,   0,   0, 0, 0, 0,
			0, 0,
		],
		[
			0,   0, 0,   0,   0,   0,   0,   0, 0,   0, 0, 0,
			0,   0, 501, 0,   416, 549, 471, 0, 0,   0, 0, 0,
			0,   0, 0,   0,   0,   0,   0,   0, 0,   0, 0, 0,
			0,   0, 0,   0,   0,   0,   0,   0, 0,   0, 0, 0,
			0,   0, 0,   505, 0,   0,   0,   0, 0,   0, 0, 0,
			581, 0, 263, 0,   0,   0,   0,   0, 0,   0, 0, 0,
			0,   0, 0,   0,   0,   0,   0,   0, 0,   0, 0, 0,
			0,   0, 0,   0,   0,   0,   0,   0, 0,   0, 0, 0,
			0,   0, 0,   0,   0,   0,   0,   0, 0,   0, 0, 0,
			0,   0, 0,   0,   0,   0,   0,   0, 0,   0, 0, 0,
			0,   0, 0,   0,   0,   0,   0,   0, 0,   0, 0, 0,
			0,   0, 0,   0,   0,   0,   0,   0, 514, 0, 0, 0,
			0,   0, 0,   0,   0,   0,   0,   0, 0,   0, 0, 0,
			0,   0,
		],
		[
			0, 0,   0, 0,   0,   0,   0,   0, 0,   0,   0,   0,
			0, 0,   0, 0,   0,   0,   0,   0, 0,   220, 0,   0,
			0, 0,   0, 0,   0,   0,   0,   0, 0,   0,   0,   0,
			0, 0,   0, 481, 0,   0,   0,   0, 0,   0,   0,   0,
			0, 275, 0, 0,   0,   0,   0,   0, 0,   0,   0,   0,
			0, 0,   0, 0,   0,   0,   0,   0, 0,   0,   0,   0,
			0, 0,   0, 0,   0,   0,   0,   0, 0,   0,   0,   0,
			0, 0,   0, 0,   326, 0,   0,   0, 0,   0,   0,   0,
			0, 0,   0, 0,   0,   0,   0,   0, 0,   0,   0,   392,
			0, 0,   0, 0,   389, 0,   431, 0, 288, 0,   0,   0,
			0, 0,   0, 474, 0,   0,   0,   0, 0,   0,   0,   0,
			0, 0,   0, 0,   0,   588, 0,   0, 0,   0,   0,   0,
			0, 267, 0, 444, 0,   0,   0,   0, 0,   0,   363, 0,
			0, 0,
		],
		[
			0,   0,   0, 0, 521, 0,   0, 0, 0, 0, 0,   0,
			558, 0,   0, 0, 0,   0,   0, 0, 0, 0, 0,   0,
			0,   0,   0, 0, 0,   0,   0, 0, 0, 0, 0,   0,
			0,   0,   0, 0, 0,   0,   0, 0, 0, 0, 0,   0,
			0,   544, 0, 0, 0,   0,   0, 0, 0, 0, 0,   0,
			0,   0,   0, 0, 0,   0,   0, 0, 0, 0, 0,   0,
			0,   0,   0, 0, 0,   0,   0, 0, 0, 0, 453, 0,
			0,   0,   0, 0, 0,   0,   0, 0, 0, 0, 0,   0,
			0,   0,   0, 0, 0,   0,   0, 0, 0, 0, 0,   0,
			0,   0,   0, 0, 0,   0,   0, 0, 0, 0, 0,   0,
			0,   0,   0, 0, 0,   0,   0, 0, 0, 0, 0,   0,
			0,   0,   0, 0, 0,   472, 0, 0, 0, 0, 543, 0,
			0,   0,   0, 0, 0,   0,   0, 0, 0, 0, 0,   0,
			0,   0,
		],
		[
			0, 0,   0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0, 0,   0, 0, 0, 457, 0, 0, 0, 0, 0, 378, 0, 0,
			0, 333, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0, 377, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
		],
		[
			0,   0,   0, 0,   0,   0, 0, 0, 0,   0, 0, 0,
			0,   0,   0, 257, 473, 0, 0, 0, 0,   0, 0, 0,
			0,   0,   0, 0,   0,   0, 0, 0, 0,   0, 0, 0,
			0,   0,   0, 0,   0,   0, 0, 0, 0,   0, 0, 0,
			0,   0,   0, 0,   0,   0, 0, 0, 0,   0, 0, 347,
			0,   0,   0, 0,   567, 0, 0, 0, 0,   0, 0, 0,
			0,   0,   0, 0,   0,   0, 0, 0, 0,   0, 0, 0,
			0,   0,   0, 0,   0,   0, 0, 0, 0,   0, 0, 0,
			0,   0,   0, 0,   0,   0, 0, 0, 0,   0, 0, 0,
			0,   0,   0, 0,   0,   0, 0, 0, 0,   0, 0, 0,
			0,   0,   0, 0,   203, 0, 0, 0, 0,   0, 0, 0,
			0,   0,   0, 0,   0,   0, 0, 0, 0,   0, 0, 0,
			436, 552, 0, 0,   0,   0, 0, 0, 236, 0, 0, 0,
			0,   0,
		],
		[
			0, 0, 0, 0,   0, 0,   0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0,   0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0,   0,   0, 0, 0,   0,   0,
			0, 0, 0, 261, 0, 0,   0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0,   260, 0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0,   0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0,   0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0,   0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 362, 0,   0, 0, 0,   489, 0,
			0, 0, 0, 209, 0, 0,   0,   0, 0, 372, 0,   0,
			0, 0, 0, 0,   0, 0,   0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0,   0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0,   0,   0, 0, 0,   0,   0,
			0, 0,
		],
		[
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,   0,
			0, 0, 0, 557, 0, 0, 0, 0, 0, 313, 406, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,   0,
			0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 576, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   270, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 541, 0,   0, 0, 0, 0,
			0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   206,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 244, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 205, 0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   237, 0,   0, 364, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   374, 0, 0,   0,
			0, 0,
		],
		[
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0, 339, 0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 404, 0, 0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0, 459, 0,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0,   0, 0, 0, 0, 250, 0, 0,   0,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0, 0,
		],
		[
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 235, 0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 259, 0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   478, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			545, 0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 499, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 295,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 496, 0,   0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   439, 0, 341, 0, 0, 0, 0,
			0, 0,
		],
		[
			0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0, 0, 0, 0,   0, 0, 433, 0, 238, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0, 0, 0, 294, 0, 0, 0,   0, 0,   0,
			0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0,
		],
		[
			0,   0, 0, 0,   0,   0, 0, 0,   0,   0, 0, 0,
			0,   0, 0, 0,   0,   0, 0, 0,   0,   0, 0, 0,
			0,   0, 0, 0,   0,   0, 0, 0,   0,   0, 0, 0,
			0,   0, 0, 0,   0,   0, 0, 0,   0,   0, 0, 0,
			0,   0, 0, 0,   0,   0, 0, 355, 0,   0, 0, 0,
			0,   0, 0, 0,   0,   0, 0, 0,   398, 0, 0, 0,
			0,   0, 0, 0,   0,   0, 0, 0,   0,   0, 0, 0,
			0,   0, 0, 0,   0,   0, 0, 0,   0,   0, 0, 0,
			0,   0, 0, 0,   0,   0, 0, 0,   0,   0, 0, 0,
			0,   0, 0, 0,   0,   0, 0, 0,   0,   0, 0, 0,
			0,   0, 0, 291, 0,   0, 0, 0,   0,   0, 0, 0,
			0,   0, 0, 0,   401, 0, 0, 0,   0,   0, 0, 0,
			0,   0, 0, 0,   0,   0, 0, 0,   0,   0, 0, 0,
			368, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 388, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
	];
	$Big5PFreq = [
		[
			0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0,   0, 0, 584, 0, 295, 0,   0,
			0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,   0,
			0, 416, 0, 0, 504, 0, 0, 0,   0, 0,   251, 0,
			0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,
		],
		[
			0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0,   0, 0, 237, 0, 0, 195, 0, 196, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 214, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0,
		],
		[
			0, 0, 0,   0, 0,   0,   0,  0, 0, 0, 0,   0,
			0, 0, 0,   0, 0,   0,   0,  0, 0, 0, 0,   0,
			0, 0, 0,   0, 0,   0,   0,  0, 0, 0, 0,   0,
			0, 0, 0,   0, 0,   0,   0,  0, 0, 0, 0,   0,
			0, 0, 0,   0, 0,   0,   0,  0, 0, 0, 0,   0,
			0, 0, 0,   0, 0,   0,   71, 0, 0, 0, 397, 0,
			0, 0, 511, 0, 0,   555, 91, 0, 0, 0, 0,   0,
			0, 0, 0,   0, 290, 0,   0,  0, 0, 0, 0,   0,
			0, 0, 0,   0, 0,   0,   0,  0, 0, 0, 0,   0,
			0, 0, 0,   0, 0,   0,   0,  0, 0, 0, 0,   0,
			0, 0, 0,   0, 0,   0,   0,  0, 0, 0, 0,   0,
			0, 0, 0,   0, 0,   0,   0,  0, 0, 0, 0,   0,
			0, 0, 0,   0, 0,   0,   0,  0, 0, 0, 0,   0,
			0, 0, 0,   0, 0,   0,   0,  0, 0, 0, 0,   0,
			0, 0, 0,   0, 0,   0,   0,  0, 0, 0, 0,   0,
			0, 0, 0,   0, 0,   0,   0,  0, 0, 0, 0,
		],
		[
			0, 0, 0, 0,   0,   0, 0, 0, 0,   0,   0,   0,
			0, 0, 0, 0,   0,   0, 0, 0, 0,   0,   0,   0,
			0, 0, 0, 0,   0,   0, 0, 0, 0,   0,   0,   0,
			0, 0, 0, 0,   0,   0, 0, 0, 0,   0,   0,   0,
			0, 0, 0, 0,   0,   0, 0, 0, 0,   0,   0,   0,
			0, 0, 0, 0,   0,   0, 0, 0, 149, 0,   0,   0,
			0, 0, 0, 0,   0,   0, 0, 0, 0,   563, 0,   228,
			0, 0, 0, 255, 103, 0, 0, 0, 0,   0,   503, 0,
			0, 0, 0, 0,   0,   0, 0, 0, 0,   0,   0,   0,
			0, 0, 0, 0,   0,   0, 0, 0, 0,   0,   0,   0,
			0, 0, 0, 0,   0,   0, 0, 0, 0,   0,   0,   0,
			0, 0, 0, 0,   0,   0, 0, 0, 0,   0,   0,   0,
			0, 0, 0, 0,   0,   0, 0, 0, 0,   0,   0,   0,
			0, 0, 0, 0,   0,   0, 0, 0, 0,   0,   0,   0,
			0, 0, 0, 0,   0,   0, 0, 0, 0,   0,   0,   0,
			0, 0, 0, 0,   0,   0, 0, 0, 0,   0,   0,
		],
		[
			0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 530, 0, 127, 0, 0, 393, 0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 327,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
		],
		[
			0,   0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 502, 0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0,   398, 0, 0, 0, 0, 0,
			412, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 473, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
		],
		[
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 382, 0, 0, 0, 0, 0, 0, 0,
			572, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   270,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 540, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0,   0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 252,
			558, 0, 0, 0, 0, 0, 0, 0, 80, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,  0, 0,
		],
		[
			0, 0,  0,   0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0,
			0, 0,  0,   0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0,
			0, 0,  0,   0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0,
			0, 0,  0,   0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0,
			0, 0,  0,   0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0,
			0, 0,  0,   0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0,
			0, 57, 170, 0, 0, 0, 0, 67, 0, 0, 0, 0, 0, 0,
			0, 0,  0,   0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0,
			0, 0,  0,   0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0,
			0, 0,  0,   0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0,
			0, 0,  0,   0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0,
			0, 0,  0,   0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0,
			0, 0,  0,   0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0,
			0, 0,  0,   0, 0, 0, 0, 0,  0,
		],
		[
			0,   0, 0,   0, 0,  0, 0, 0,   0, 0, 0, 0,
			0,   0, 0,   0, 0,  0, 0, 0,   0, 0, 0, 0,
			0,   0, 0,   0, 0,  0, 0, 0,   0, 0, 0, 0,
			0,   0, 0,   0, 73, 0, 0, 383, 7, 0, 0, 0,
			123, 0, 0,   0, 0,  0, 0, 0,   0, 0, 0, 0,
			0,   0, 0,   0, 0,  0, 0, 0,   0, 0, 0, 0,
			585, 0, 0,   0, 0,  0, 0, 0,   0, 0, 0, 0,
			0,   0, 0,   0, 0,  0, 0, 0,   0, 0, 0, 0,
			0,   0, 0,   0, 0,  0, 0, 0,   0, 0, 0, 0,
			0,   0, 277, 0, 0,  0, 0, 0,   0, 0, 0, 0,
			0,   0, 0,   0, 0,  0, 0, 0,   0, 0, 0, 376,
			0,   0, 0,   0, 0,  0, 0, 0,   0, 0, 0, 0,
			0,   0, 0,   0, 0,  0, 0, 0,   0, 0, 0, 0,
			0,   0, 0,   0, 0,  0, 0, 0,   0, 0, 0, 0,
			0,   0, 0,   0, 0,  0, 0, 0,   0, 0, 0, 0,
			0,   0, 0,   0, 0,  0, 0, 0,   0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 483, 0, 0, 135, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0,
		],
		[
			0,   0,   0, 0,   0, 0, 0,   0,   0, 0,   0,  0,
			0,   0,   0, 0,   0, 0, 0,   0,   0, 0,   0,  0,
			0,   0,   0, 0,   0, 0, 0,   0,   0, 0,   0,  0,
			0,   0,   0, 0,   0, 0, 0,   0,   0, 0,   0,  0,
			0,   0,   0, 0,   0, 0, 0,   0,   0, 0,   0,  0,
			0,   0,   0, 0,   0, 0, 0,   0,   0, 0,   0,  0,
			0,   0,   0, 0,   0, 0, 0,   0,   0, 0,   0,  0,
			0,   0,   0, 0,   0, 0, 0,   0,   0, 0,   0,  0,
			0,   0,   0, 0,   0, 0, 0,   0,   0, 0,   0,  0,
			0,   0,   0, 0,   0, 0, 0,   0,   0, 0,   0,  0,
			0,   0,   0, 0,   0, 0, 0,   0,   0, 0,   0,  0,
			0,   0,   0, 0,   0, 0, 0,   0,   0, 0,   0,  0,
			0,   0,   0, 0,   0, 0, 0,   0,   0, 0,   0,  0,
			160, 452, 0, 434, 0, 1, 0,   0,   0, 580, 99, 0,
			111, 0,   0, 392, 0, 0, 65,  409, 0, 0,   0,  0,
			0,   0,   0, 0,   0, 0, 581, 0,   0, 260, 0,
		],
		[
			0,   63,  0, 0, 0, 0,   0,   0,  0,  0,   0, 0,
			0,   0,   0, 0, 0, 0,   0,   0,  0,  0,   0, 0,
			0,   0,   0, 0, 0, 0,   0,   83, 0,  0,   0, 0,
			410, 51,  0, 0, 0, 0,   0,   0,  0,  0,   0, 0,
			172, 40,  0, 0, 0, 0,   0,   0,  0,  126, 0, 338,
			0,   0,   0, 0, 0, 0,   0,   0,  0,  0,   0, 0,
			0,   0,   0, 0, 0, 0,   0,   0,  0,  0,   0, 0,
			0,   0,   0, 0, 0, 0,   0,   0,  0,  0,   0, 0,
			0,   0,   0, 0, 0, 0,   0,   0,  0,  0,   0, 0,
			0,   0,   0, 0, 0, 535, 268, 0,  77, 0,   0, 0,
			0,   389, 0, 0, 0, 0,   0,   0,  0,  0,   0, 0,
			0,   0,   0, 0, 0, 0,   0,   0,  0,  0,   0, 0,
			0,   0,   0, 0, 0, 0,   0,   0,  0,  0,   0, 0,
			0,   0,   0, 0, 0, 0,   0,   0,  0,  0,   0, 0,
			0,   0,   0, 0, 0, 114, 0,   0,  0,  0,   0, 0,
			394, 0,   0, 0, 0, 0,   0,   0,  0,  0,   0,
		],
		[
			0, 0,  0, 0, 0, 0,   0, 0, 0,   0,   0, 0,
			0, 61, 0, 0, 0, 0,   0, 0, 41,  0,   0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 168, 0,   0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0,   273, 0, 0,
			0, 0,  0, 0, 0, 367, 0, 0, 0,   378, 0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0,   396, 0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0,   0,   0,
		],
		[
			0, 0, 0,  0, 0, 0,   0, 0,   0,   0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0,   0,   0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0,   0,   0,   0, 0,
			0, 0, 38, 0, 0, 0,   0, 0,   0,   265, 0, 18,
			0, 0, 0,  0, 0, 0,   0, 0,   0,   0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0,   0,   0,   0, 0,
			0, 0, 0,  0, 0, 590, 0, 536, 0,   0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 343, 0,   0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0,   0,   0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0,   0,   0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0,   0,   0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0,   0,   0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0,   0,   0,   0, 27,
			0, 0, 0,  0, 0, 0,   0, 0,   142, 0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0,   0,   0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0,   0,   0,   0,
		],
		[
			0, 0,   0, 0, 218, 0, 0, 0, 0, 0, 0,  0,
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,  0,
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 88, 0,
			0, 0,   0, 0, 302, 0, 0, 0, 0, 0, 0,  0,
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,  0,
			0, 497, 0, 0, 0,   0, 0, 0, 0, 0, 0,  0,
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,  0,
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,  0,
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,  0,
			0, 440, 0, 0, 0,   0, 0, 0, 0, 0, 0,  0,
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,  0,
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,  0,
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,  0,
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,  0,
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,  0,
			0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
		],
		[
			0,   0,  0, 0,   0,   0, 0, 0,  0,  0,   0,  0,
			0,   0,  0, 0,   0,   0, 0, 0,  0,  0,   0,  0,
			0,   0,  0, 0,   0,   0, 0, 0,  0,  26,  0,  0,
			0,   0,  0, 0,   257, 0, 0, 0,  81, 109, 0,  0,
			0,   0,  0, 0,   0,   0, 0, 0,  0,  0,   0,  0,
			0,   0,  0, 0,   0,   0, 0, 0,  0,  0,   85, 0,
			0,   0,  0, 0,   0,   0, 0, 0,  0,  0,   0,  0,
			0,   0,  0, 0,   0,   0, 0, 0,  0,  0,   0,  0,
			0,   0,  0, 0,   0,   0, 0, 24, 0,  0,   0,  0,
			146, 0,  0, 0,   112, 0, 0, 0,  0,  0,   0,  512,
			0,   0,  0, 289, 0,   0, 0, 0,  0,  456, 0,  0,
			0,   70, 0, 307, 0,   0, 0, 0,  0,  0,   0,  0,
			0,   0,  0, 0,   0,   0, 0, 0,  0,  0,   0,  0,
			0,   0,  0, 0,   0,   0, 0, 0,  0,  0,   0,  0,
			0,   0,  0, 0,   0,   0, 0, 0,  0,  0,   0,  0,
			0,   0,  0, 0,   0,   0, 0, 0,  0,  0,   136,
		],
		[
			0, 0, 0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,  0, 0, 267, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,  0, 0, 46,  0, 0, 0, 0, 0, 206, 0, 0,
			0, 0, 0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 15, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,  0, 0, 0,   0, 0, 0,
		],
		[
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0, 0,   0,   0,   0,   513, 150, 0,   45,  0,   143, 0,
			0, 317, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0, 0,   0,   0,   0,   0,   324, 0,   0,   0,   0,   0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0, 0,   0,   351, 0,   0,   300, 0,   0,   0,   0,   301,
			0, 0,   0,   0,   180, 0,   328, 0,   125, 0,   0,   0,
			0, 0,   320, 0,   298, 0,   0,   0,   199, 0,   0,   97,
			0, 0,   0,   0,   212, 0,   0,   0,   0,   0,   0,   0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0, 0,   0,   469, 0,   0,   0,   0,   0,   0,   0,   262,
			0, 0,   0,   0,   0,   0,   0,   222, 0,   0,   0,   0,
			0, 0,   582, 0,   0,   304, 0,   0,   0,   153, 0,
		],
		[
			0,   0,  0, 0, 155, 0, 119, 0,   0, 0, 0, 134,
			0,   0,  0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0,  0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0,  0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0,  0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0,  0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0,  0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0,  0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0,  0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0,  0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   93, 0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			276, 0,  0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0,  0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0,  0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0,  0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0,  0, 0, 0,   0, 0,   369, 0, 0, 0,
		],
		[
			0, 0, 232, 0, 0,   0,   0,   0, 0, 0,   0, 0,
			0, 0, 0,   0, 0,   226, 0,   0, 0, 0,   0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0, 0,   0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0, 0,   0, 0,
			0, 0, 0,   0, 487, 0,   278, 0, 0, 0,   0, 0,
			0, 0, 0,   0, 0,   0,   478, 0, 0, 0,   0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0, 0,   0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0, 0,   0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0, 0,   0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0, 0,   0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0, 0,   0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0, 0,   0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0, 0,   0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0, 205, 0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0, 0,   0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0, 0,   0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0,  0, 0, 0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,  0, 0, 501, 437, 0,   0,   0,   0, 0,   459, 0,
			0,  0, 0, 0,   450, 0,   0,   0,   0, 0,   0,   0,
			0,  0, 0, 0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,  0, 0, 0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,  0, 0, 0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,  0, 0, 0,   0,   0,   0,   139, 0, 0,   0,   0,
			0,  0, 0, 0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,  0, 0, 0,   0,   0,   275, 0,   0, 173, 35,  0,
			53, 0, 0, 0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,  0, 0, 0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,  0, 0, 0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,  0, 0, 0,   0,   261, 0,   0,   0, 0,   0,   0,
			0,  0, 0, 0,   0,   0,   0,   0,   0, 0,   0,   311,
			0,  0, 0, 0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,  0, 0, 325, 0,   0,   0,   0,   0, 0,   0,
		],
		[
			0, 0, 0,   0, 0, 151, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 380, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0,  0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,  0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,  0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,  0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,  0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,  0, 0, 495, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 25, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,  0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,  0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,  0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,  0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,  0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,  0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,  0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 498, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,   0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			599, 0,   0,   246, 0,   388, 596, 481, 595, 468, 408, 319,
			454, 0,   0,   458, 0,   523, 0,   518, 507, 566, 0,   586,
			0,   0,   0,   9,   549, 573, 0,   538, 0,   0,   0,   0,
			191, 0,   431, 0,   233, 0,   588, 460, 579, 0,   0,   0,
			550, 0,   0,   406, 0,   471, 470, 506, 0,   0,   323, 0,
			0,   0,   395, 0,   0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   597, 589, 0,   0,   559, 0,   0,   0,   0,
			0,   405, 0,   0,   448, 0,   0,   0,   0,   340, 0,   0,
			292, 0,   0,   288, 0,   509, 0,   0,   496, 110, 0,   0,
			0,   0,   414, 0,   0,   0,   0,   0,   0,   185, 341, 356,
			0,   546, 279, 404, 0,   0,   419, 0,   0,   0,   0,   0,
			0,   0,   0,   548, 0,   0,   524, 0,   75,  527, 0,   0,
			519, 539, 0,   477, 0,   0,   0,   0,   0,   391, 313, 0,
			403, 174, 0,   243, 0,   190, 0,   0,   0,   345, 0,
		],
		[
			423, 0,   130, 0,   521, 0,   0,   101, 565, 0,   0,   0,
			591, 0,   411, 210, 0,   0,   0,   0,   0,   0,   0,   0,
			575, 0,   66,  415, 287, 147, 0,   420, 0,   0,   248, 0,
			0,   0,   0,   0,   560, 554, 74,  0,   0,   0,   0,   0,
			0,   349, 0,   364, 59,  532, 193, 0,   330, 39,  0,   0,
			439, 0,   494, 0,   0,   69,  0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   166, 0,   0,   0,   321, 0,   0,   0,   14,  401,
			124, 426, 0,   0,   0,   0,   245, 0,   447, 0,   0,   0,
			0,   0,   0,   514, 202, 0,   0,   463, 120, 499, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   564, 522, 0,
			0,   413, 0,   0,   0,   368, 0,   0,   384, 0,   0,   159,
			104, 0,   0,   381, 0,   0,   0,   0,   0,   0,   303, 0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   373,
			334, 0,   0,   0,   0,   0,   346, 0,   0,   407, 472,
		],
		[
			326, 427, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   508, 0,   0,   0,   0,   335, 466, 462,
			355, 296, 551, 0,   0,   444, 482, 0,   0,   576, 593, 0,
			0,   0,   0,   0,   547, 0,   0,   0,   0,   0,   543, 553,
			517, 0,   305, 23,  0,   0,   0,   372, 0,   0,   0,   16,
			0,   417, 571, 0,   0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0,   217, 0,   0,   0,   0,   0,   0,   534, 0,   0,   0,
			207, 177, 0,   0,   0,   0,   0,   592, 0,   0,   0,   0,
			435, 484, 363, 0,   0,   0,   0,   223, 0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   297, 0,   0,   0,   0,   0,
			0,   505, 0,   545, 0,   0,   0,   0,   0,   0,   0,   562,
			333, 0,   0,   0,   0,   0,   306, 0,   0,   0,   520, 36,
			428, 0,   0,   0,   445, 390, 0,   0,   0,   0,   0,   358,
			0,   0,   0,   0,   0,   0,   0,   0,   162, 493, 0,
		],
		[
			531, 577, 0,   8,   0,   0,   0,   0,   0,   0,  108, 0,
			157, 0,   0,   0,   0,   348, 0,   0,   0,   0,  0,   0,
			0,   236, 0,   0,   0,   0,   0,   0,   0,   68, 0,   0,
			0,   0,   0,   0,   0,   224, 0,   0,   0,   0,  0,   0,
			0,   0,   0,   0,   0,   0,   424, 0,   0,   0,  0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  0,   0,
			0,   0,   0,   0,   138, 0,   0,   0,   0,   0,  0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  0,   0,
			0,   240, 0,   0,   0,   118, 0,   0,   0,   0,  0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   156, 0,  179, 0,
			0,   0,   0,   152, 0,   0,   271, 0,   0,   0,  594, 0,
			0,   0,   227, 0,   0,   0,   486, 0,   186, 29, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   181, 0,   0,  0,   357,
			0,   216, 0,   0,   0,   0,   0,   0,   0,   0,  0,
		],
		[
			0,  0,   241, 282, 235, 0,   0,   0,   0,   0, 0, 0,
			0,  0,   0,   0,   0,   0,   0,   0,   0,   0, 0, 0,
			0,  0,   0,   0,   0,   0,   0,   0,   0,   0, 0, 0,
			0,  0,   0,   0,   0,   0,   0,   100, 0,   0, 0, 0,
			0,  0,   0,   148, 352, 0,   0,   0,   0,   0, 0, 0,
			0,  0,   0,   0,   0,   0,   0,   0,   0,   0, 0, 0,
			0,  0,   0,   0,   0,   0,   0,   0,   0,   0, 0, 0,
			0,  0,   0,   0,   0,   0,   0,   0,   0,   0, 0, 0,
			0,  0,   0,   0,   0,   266, 0,   0,   0,   0, 0, 441,
			92, 492, 0,   0,   0,   0,   0,   0,   0,   0, 0, 0,
			0,  0,   568, 0,   0,   552, 0,   0,   0,   0, 0, 0,
			0,  0,   533, 491, 0,   0,   339, 0,   0,   0, 0, 430,
			0,  0,   0,   0,   0,   0,   0,   0,   0,   0, 0, 0,
			0,  0,   0,   0,   0,   0,   0,   31,  475, 0, 0, 0,
			56, 0,   0,   0,   583, 0,   337, 0,   0,   0, 0, 0,
			0,  0,   0,   0,   0,   0,   200, 0,   347, 0, 0,
		],
		[
			0,   0,   0,   0,   0,   0,  0,   0,   0,   0,   0,   0,
			0,   578, 0,   213, 254, 0,  379, 0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   50, 0,   21,  0,   0,   0,   0,
			0,   178, 0,   0,   0,   0,  0,   0,   198, 0,   0,   0,
			0,   0,   0,   0,   0,   0,  0,   461, 105, 0,   0,   0,
			0,   0,   30,  0,   0,   0,  0,   0,   0,   54,  0,   0,
			0,   0,   0,   0,   0,   0,  0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,  0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,  0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,  133, 44,  0,   0,   0,   0,
			0,   264, 0,   0,   0,   0,  0,   0,   48,  0,   0,   0,
			0,   0,   0,   0,   121, 0,  386, 0,   0,   0,   350, 0,
			176, 0,   515, 0,   132, 0,  0,   0,   0,   0,   0,   90,
			0,   0,   0,   0,   0,   0,  0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,  0,   0,   0,   354, 0,   0,
			0,   0,   12,  0,   0,   0,  476, 0,   0,   0,   0,
		],
		[
			0,   314, 0,   0,   0, 0,   0,   344, 0,   0,   0, 0,
			312, 0,   0,   0,   0, 0,   0,   0,   0,   0,   0, 0,
			0,   0,   249, 0,   0, 0,   0,   0,   94,  0,   0, 0,
			0,   4,   0,   0,   0, 0,   0,   485, 0,   0,   0, 0,
			0,   0,   0,   0,   0, 0,   256, 0,   0,   0,   0, 0,
			0,   0,   0,   0,   0, 0,   0,   0,   0,   0,   0, 0,
			0,   0,   0,   0,   0, 0,   0,   0,   0,   0,   0, 0,
			0,   0,   0,   0,   0, 0,   0,   0,   0,   0,   0, 0,
			0,   0,   0,   0,   0, 0,   0,   0,   0,   197, 0, 331,
			0,   0,   0,   0,   0, 0,   0,   0,   0,   0,   0, 0,
			0,   0,   600, 0,   0, 315, 500, 0,   291, 0,   0, 0,
			0,   230, 0,   0,   0, 0,   0,   0,   467, 0,   0, 0,
			0,   0,   0,   0,   0, 0,   0,   0,   0,   0,   0, 0,
			0,   0,   0,   0,   0, 272, 0,   0,   0,   0,   0, 0,
			0,   0,   0,   0,   3, 371, 0,   0,   0,   259, 0, 0,
			0,   0,   0,   359, 0, 0,   0,   0,   0,   0,   0,
		],
		[
			0,   0,   0,   281, 284, 0,   0, 0,   421, 0, 0,   446,
			0,   0,   0,   253, 0,   0,   0, 0,   0,   0, 0,   0,
			0,   0,   0,   0,   0,   0,   0, 0,   0,   0, 0,   0,
			0,   516, 0,   0,   0,   0,   0, 0,   0,   0, 309, 0,
			0,   0,   0,   0,   0,   0,   0, 0,   0,   0, 0,   0,
			0,   0,   234, 0,   0,   0,   0, 0,   0,   0, 0,   0,
			0,   0,   0,   0,   0,   0,   0, 0,   0,   0, 0,   0,
			561, 0,   0,   0,   0,   0,   0, 0,   0,   0, 0,   0,
			0,   0,   0,   0,   0,   0,   0, 0,   0,   0, 0,   0,
			0,   0,   0,   0,   244, 0,   0, 0,   0,   0, 0,   0,
			0,   0,   0,   0,   0,   0,   0, 0,   0,   0, 0,   0,
			184, 0,   0,   0,   98,  0,   0, 0,   0,   0, 0,   0,
			0,   0,   0,   0,   0,   0,   0, 308, 310, 0, 0,   0,
			453, 82,  0,   0,   0,   0,   0, 0,   285, 0, 10,  293,
			0,   0,   0,   0,   0,   0,   0, 0,   0,   0, 0,   0,
			0,   0,   0,   0,   0,   201, 0, 0,   286, 0, 0,
		],
		[
			0, 0,   0,   0,   0,   0,   433, 43,  0,   0,   0, 0,
			0, 0,   0,   598, 55,  0,   0,   0,   0,   0,   0, 0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
			0, 113, 0,   0,   0,   0,   0,   0,   0,   283, 0, 0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
			0, 377, 0,   219, 0,   0,   0,   0,   0,   0,   0, 0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
			0, 0,   229, 0,   0,   342, 0,   0,   0,   0,   0, 0,
			0, 0,   0,   0,   0,   0,   0,   0,   0,   42,  0, 436,
			0, 528, 0,   0,   0,   0,   0,   188, 0,   0,   0, 0,
			0, 0,   0,   0,   294, 0,   0,   0,   72,  0,   0, 0,
			0, 0,   0,   0,   0,   0,   0,   0,   479, 0,   0,
		],
		[
			0,  0,   0,   0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,  0,   0,   0,   0,   0,   0,   0,   0, 0,   0,   96,
			0,  158, 0,   0,   0,   0,   221, 0,   0, 0,   0,   0,
			0,  0,   0,   0,   0,   0,   0,   0,   0, 0,   567, 0,
			0,  0,   0,   0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,  0,   0,   0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,  0,   0,   0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,  0,   0,   0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,  0,   0,   0,   0,   0,   0,   0,   0, 0,   0,   443,
			0,  0,   0,   0,   0,   510, 239, 0,   0, 175, 0,   0,
			0,  0,   171, 163, 0,   0,   0,   0,   0, 0,   0,   0,
			0,  0,   0,   0,   0,   0,   0,   203, 0, 0,   0,   0,
			0,  0,   0,   0,   247, 0,   0,   0,   0, 0,   0,   0,
			0,  0,   0,   0,   0,   0,   0,   115, 0, 0,   0,   0,
			0,  0,   0,   0,   370, 0,   0,   0,   0, 0,   0,   0,
			79, 0,   0,   0,   0,   0,   0,   0,   0, 0,   106,
		],
		[
			0, 0,   0,  0, 0,  0,   0, 0,   0,   0,   0,   0,
			0, 0,   0,  0, 0,  0,   0, 0,   0,   0,   0,   0,
			0, 0,   0,  0, 0,  0,   0, 0,   20,  557, 0,   0,
			0, 189, 0,  0, 0,  263, 0, 0,   0,   0,   0,   0,
			0, 0,   0,  0, 0,  0,   0, 0,   0,   0,   0,   0,
			0, 0,   0,  0, 0,  0,   0, 0,   0,   0,   0,   0,
			0, 0,   0,  0, 0,  0,   0, 0,   0,   0,   0,   0,
			0, 0,   0,  0, 0,  0,   0, 0,   0,   0,   0,   0,
			0, 0,   0,  0, 0,  0,   0, 215, 0,   0,   0,   0,
			0, 0,   0,  0, 0,  0,   0, 165, 0,   0,   0,   0,
			0, 0,   0,  0, 0,  0,   0, 0,   0,   0,   0,   0,
			0, 0,   17, 0, 0,  0,   0, 0,   0,   0,   0,   0,
			0, 0,   0,  0, 0,  154, 0, 0,   0,   0,   117, 0,
			0, 0,   0,  0, 0,  0,   0, 0,   0,   0,   128, 0,
			0, 0,   0,  0, 0,  0,   0, 0,   0,   0,   0,   0,
			0, 0,   0,  0, 37, 0,   0, 0,   432, 0,   0,
		],
		[
			0,   0,  0,   0,  0,   0,   0, 0,   0,   0, 0, 0,
			0,   0,  0,   0,  0,   0,   0, 318, 0,   0, 0, 0,
			0,   0,  0,   0,  0,   0,   0, 0,   0,   0, 0, 0,
			258, 0,  0,   0,  0,   0,   0, 0,   0,   0, 0, 0,
			0,   0,  0,   0,  0,   425, 0, 0,   0,   0, 0, 0,
			0,   32, 0,   0,  0,   0,   0, 0,   0,   0, 0, 0,
			0,   0,  0,   0,  0,   0,   0, 0,   209, 0, 0, 0,
			0,   0,  0,   0,  0,   0,   0, 0,   0,   0, 0, 0,
			0,   0,  0,   0,  0,   0,   0, 0,   0,   0, 0, 375,
			0,   0,  0,   0,  0,   0,   0, 0,   0,   0, 0, 0,
			183, 0,  387, 0,  0,   0,   0, 0,   0,   0, 0, 0,
			0,   0,  0,   0,  0,   0,   0, 0,   0,   0, 0, 0,
			0,   0,  0,   0,  0,   0,   0, 0,   0,   0, 0, 0,
			0,   0,  0,   0,  544, 0,   0, 0,   0,   0, 0, 0,
			0,   0,  0,   49, 0,   0,   0, 0,   0,   0, 0, 0,
			0,   0,  0,   0,  0,   0,   0, 0,   0,   0, 0,
		],
		[
			0,   0,  0, 0,   0, 0, 0, 0,   0, 0,   0,   0,
			0,   0,  0, 0,   0, 0, 0, 0,   0, 0,   0,   0,
			0,   0,  0, 0,   0, 0, 0, 537, 0, 0,   0,   0,
			0,   28, 0, 0,   0, 0, 0, 0,   0, 0,   0,   0,
			0,   0,  0, 5,   0, 0, 0, 0,   0, 0,   0,   0,
			269, 0,  0, 0,   0, 0, 0, 0,   0, 0,   0,   0,
			0,   0,  0, 0,   0, 0, 0, 0,   0, 0,   0,   0,
			0,   0,  0, 0,   0, 0, 0, 0,   0, 0,   0,   0,
			0,   0,  0, 0,   0, 0, 0, 0,   0, 0,   489, 0,
			0,   0,  0, 0,   0, 0, 0, 0,   0, 353, 0,   0,
			0,   0,  0, 0,   0, 0, 0, 0,   0, 0,   0,   0,
			0,   0,  0, 0,   0, 0, 0, 0,   0, 0,   0,   0,
			0,   0,  0, 192, 0, 0, 0, 0,   0, 0,   0,   0,
			0,   0,  0, 0,   0, 0, 0, 0,   0, 0,   0,   0,
			0,   0,  0, 0,   0, 0, 0, 0,   0, 0,   220, 0,
			0,   0,  0, 0,   0, 0, 0, 0,   0, 0,   0,
		],
		[
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0,   0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0,   0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 362, 0,   0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0,   0,   570,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0,   0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0,   0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0,   0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0,   0,   0,
			0,   465, 0, 0,  0, 0, 0, 0, 0,   0,   0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   322, 0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 87,  0,   0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0,   0,   0,
			429, 0,   0, 0,  0, 0, 0, 0, 0,   0,   0,   0,
			0,   0,   0, 86, 0, 0, 0, 0, 0,   0,   316, 0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0,   0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0,   0,
		],
		[
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   332, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 238, 0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 480, 0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   242, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 400, 0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			438, 0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0, 0, 0, 0, 0, 0,   0, 0,
		],
		[
			0, 0,   0,   0,   0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 442, 0, 0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   0, 0, 0,   0,   0, 0,
			0, 385, 0,   0,   0, 0,   0, 0, 0,   145, 0, 0,
			0, 0,   0,   0,   0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   0, 0, 0,   0,   0, 0,
			0, 464, 0,   542, 0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,   102, 0,   0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   0, 0, 451, 0,   0, 0,
			0, 0,   0,   0,   0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,   0,   141, 0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   0, 0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   0, 0, 0,   0,   0,
		],
		[
			0, 0, 0,   0,   0, 0, 0, 0,   0,  0,   0, 0,
			0, 0, 569, 0,   0, 0, 0, 0,   0,  0,   0, 0,
			0, 0, 0,   0,   0, 0, 0, 0,   0,  0,   0, 0,
			0, 0, 0,   0,   0, 0, 0, 0,   0,  0,   0, 0,
			0, 0, 0,   0,   0, 0, 0, 0,   52, 0,   0, 0,
			0, 0, 0,   0,   0, 0, 0, 0,   0,  0,   0, 0,
			0, 0, 0,   0,   0, 0, 0, 0,   0,  0,   0, 0,
			0, 0, 0,   0,   0, 0, 0, 0,   0,  0,   0, 0,
			0, 0, 0,   361, 0, 0, 0, 0,   0,  0,   0, 0,
			0, 0, 0,   0,   0, 0, 0, 0,   0,  161, 0, 0,
			0, 0, 0,   0,   0, 0, 0, 116, 0,  365, 0, 0,
			0, 0, 0,   0,   0, 0, 0, 0,   0,  0,   0, 0,
			0, 0, 0,   0,   0, 0, 0, 0,   0,  0,   0, 0,
			0, 0, 0,   0,   0, 0, 0, 0,   58, 2,   0, 0,
			0, 0, 0,   0,   0, 0, 0, 0,   0,  0,   0, 0,
			0, 0, 0,   0,   0, 0, 0, 0,   0,  0,   0,
		],
		[
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 541, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 225, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0, 0, 0, 0, 455, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 11,  0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,
		],
		[
			0, 0,   0, 0, 0,   0, 0, 0, 329, 0, 0,   0,
			0, 0,   0, 0, 0,   0, 0, 0, 0,   0, 194, 0,
			0, 0,   0, 0, 0,   0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0,   0, 0, 0, 0,   0, 0,   0,
			0, 231, 0, 0, 0,   0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0,   0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0,   0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0,   0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0,   0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 137, 0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0,   0, 0, 0, 0,   0, 131, 0,
			0, 0,   0, 0, 0,   0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0,   0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0,   0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0,   0, 0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0,   0, 0, 0, 0,   0, 0,
		],
		[
			0,   0, 0,   0,   0,   0,   0, 0, 0, 0, 0, 0,
			122, 0, 488, 0,   360, 529, 0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0,   0,   0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0,   0,   0, 0, 0, 0, 0, 0,
			0,   0, 0,   449, 0,   0,   0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0,   0,   0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0,   0,   0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0,   0,   0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0,   0,   0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0,   0,   0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0,   0,   0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0,   0,   0, 0, 0, 0, 0, 0,
			0,   0, 0,   95,  0,   0,   0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0,   0,   0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0,   0,   0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0,   0,   0, 0, 0, 0, 0,
		],
		[
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 89, 0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 144, 0, 0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0, 0,   0,
			0,   336, 0, 0,  0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0, 0,   0,
			0,   0,   0, 0,  0, 0, 0, 0, 0,   0, 274, 0,
			366, 0,   0, 0,  0, 0, 0, 0, 0,   0, 0,
		],
		[
			0, 0, 0, 0, 574, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 187, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0,
		],
		[
			22, 0, 0,   0,   0, 0, 0,   0, 0, 0, 0, 0,
			0,  0, 0,   0,   0, 0, 0,   0, 0, 0, 0, 0,
			0,  0, 0,   0,   0, 0, 0,   0, 0, 0, 0, 0,
			0,  0, 0,   0,   0, 0, 0,   0, 0, 0, 0, 0,
			0,  0, 0,   0,   0, 0, 0,   0, 0, 0, 0, 0,
			0,  0, 0,   0,   0, 0, 0,   0, 0, 0, 0, 0,
			0,  0, 0,   0,   0, 0, 0,   0, 0, 0, 0, 0,
			0,  0, 0,   0,   0, 0, 0,   0, 0, 0, 0, 0,
			0,  0, 0,   0,   0, 0, 0,   0, 0, 0, 0, 0,
			0,  0, 0,   0,   0, 0, 0,   0, 0, 0, 0, 0,
			0,  0, 0,   0,   0, 0, 0,   0, 0, 0, 0, 0,
			0,  0, 0,   0,   0, 0, 0,   0, 0, 0, 0, 0,
			0,  0, 0,   0,   0, 0, 0,   0, 0, 0, 0, 0,
			0,  0, 280, 0,   0, 0, 299, 0, 0, 0, 0, 0,
			0,  0, 0,   107, 0, 0, 0,   0, 0, 0, 0, 0,
			0,  0, 0,   0,   0, 0, 0,   0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 19,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 167, 208, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,
		],
		[
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			374, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 34, 0, 0, 0, 0,
			0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 76, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,
			0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 182, 0,
			0, 0, 0, 526, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0,   0,  0, 0, 402, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 490, 0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0,  0, 0, 422, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   47, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0,  0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0,   0,  0, 0, 0,   0, 0, 0, 0, 0, 457, 0, 0,
			0, 0,   0,  0, 0, 0,   0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0,   0, 0, 164, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 399, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0,   0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 474, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 204, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0,  0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 78, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,  0, 0, 0, 169, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,  0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 140, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 525,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 418, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 587, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 556,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
	];
	$EUC_TWFreq = [
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			596, 0, 0,   0,   0,   0,   591, 468, 592, 0,   371, 0,
			0,   0, 0,   460, 0,   438, 0,   462, 490, 559, 0,   578,
			0,   0, 0,   0,   0,   573, 0,   0,   0,   0,   0,   0,
			0,   0, 0,   0,   271, 0,   594, 458, 538, 0,   0,   0,
			551, 0, 0,   312, 0,   547, 442, 448, 0,   0,   0,   0,
			0,   0, 429, 0,   0,   598, 590, 0,   0,   550, 0,   0,
			0,   0, 0,   292, 0,   0,   479, 0,   0,   0,   0,   335,
			0,   0, 231, 0,   360, 0,   0,   407, 0,   0,
		],
		[
			454, 0,   0,   0,   0,   0,   284, 0,   0, 0,   0,   0,
			0,   430, 405, 272, 0,   555, 0,   445, 0, 0,   420, 0,
			0,   0,   0,   0,   0,   0,   0,   533, 0, 0,   450, 0,
			207, 568, 0,   0,   493, 477, 0,   387, 0, 0,   0,   0,
			0,   465, 0,   0,   397, 0,   0,   0,   0, 249, 0,   0,
			0,   282, 0,   278, 0,   309, 0,   440, 0, 0,   0,   586,
			0,   0,   0,   565, 0,   327, 0,   0,   0, 0,   202, 0,
			0,   0,   0,   546, 0,   0,   418, 262, 0, 0,
		],
		[
			265, 0,   0,   0,   0,   204, 0,   0,   0,   531, 585, 0,
			0,   0,   0,   0,   0,   0,   0,   0,   230, 0,   532, 0,
			0,   527, 0,   0,   0,   367, 0,   435, 240, 0,   0,   0,
			0,   358, 0,   0,   0,   0,   246, 0,   258, 0,   0,   0,
			0,   264, 0,   446, 0,   0,   0,   0,   0,   0,   511, 223,
			0,   0,   476, 0,   425, 0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   561, 572, 0,   0,   365, 0,   0,   0,
			243, 0,   0,   352, 0,   0,   0,   0,   0,   0,
		],
		[
			353, 0,   0,   0,   0, 0,   0,   574, 0,   0,   0,   0,
			0,   0,   0,   0,   0, 0,   0,   0,   224, 281, 0,   0,
			228, 0,   0,   336, 0, 0,   381, 422, 0,   470, 0,   0,
			0,   0,   0,   0,   0, 0,   0,   0,   0,   0,   0,   0,
			524, 0,   0,   0,   0, 423, 248, 480, 350, 0,   0,   0,
			0,   503, 417, 0,   0, 519, 593, 0,   0,   0,   0,   0,
			553, 0,   0,   0,   0, 0,   580, 426, 570, 0,   320, 0,
			0,   0,   0,   241, 0, 0,   0,   0,   0,   0,
		],
		[
			510, 415, 0,   0,   0,   0, 0,   0,   526, 0, 0,   0,
			0,   0,   0,   0,   0,   0, 0,   595, 0,   0, 0,   0,
			449, 488, 274, 0,   0,   0, 0,   0,   0,   0, 0,   0,
			0,   0,   0,   0,   0,   0, 0,   219, 0,   0, 0,   0,
			0,   411, 343, 539, 0,   0, 0,   0,   0,   0, 0,   540,
			354, 0,   0,   0,   0,   0, 253, 0,   0,   0, 483, 0,
			289, 0,   0,   0,   486, 0, 0,   0,   0,   0, 0,   523,
			0,   0,   0,   0,   0,   0, 0,   0,   0,   515,
		],
		[
			0, 485, 582, 0, 0,   0, 0,   0, 0,   0, 0,   0,
			0, 0,   0,   0, 402, 0, 245, 0, 0,   0, 0,   0,
			0, 0,   0,   0, 0,   0, 0,   0, 373, 0, 487, 0,
			0, 0,   0,   0, 0,   0, 346, 0, 0,   0, 0,   0,
			0, 0,   0,   0, 0,   0, 0,   0, 0,   0, 0,   0,
			0, 0,   0,   0, 0,   0, 0,   0, 0,   0, 0,   0,
			0, 0,   0,   0, 0,   0, 0,   0, 0,   0, 0,   0,
			0, 0,   0,   0, 324, 0, 0,   0, 0,   0,
		],
		[
			0,   0,   0, 0,   0,   0,   0, 287, 0,   0, 0, 0,
			0,   332, 0, 0,   0,   0,   0, 0,   0,   0, 0, 356,
			0,   0,   0, 597, 0,   0,   0, 0,   0,   0, 0, 409,
			0,   370, 0, 0,   0,   0,   0, 0,   215, 0, 0, 0,
			305, 0,   0, 0,   345, 0,   0, 0,   0,   0, 0, 0,
			0,   0,   0, 0,   0,   0,   0, 311, 227, 0, 0, 0,
			0,   0,   0, 0,   0,   222, 0, 0,   0,   0, 0, 566,
			0,   0,   0, 0,   0,   0,   0, 0,   0,   0,
		],
		[
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,   0,
			0, 314, 0, 0, 0, 0, 0, 0,   0, 226, 452, 0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,   393,
			0, 321, 0, 0, 0, 0, 0, 211, 0, 329, 455, 0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   563, 0,
			0, 0,   0, 0, 0, 0, 0, 318, 0, 0,   495, 492,
			0, 0,   0, 0, 0, 0, 0, 432, 0, 0,   0,   577,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
		],
		[
			0,   0, 0,   0, 419, 0, 497, 0, 0,   0,   0,   0,
			0,   0, 589, 0, 0,   0, 0,   0, 0,   0,   0,   0,
			0,   0, 0,   0, 285, 0, 277, 0, 225, 0,   0,   0,
			0,   0, 0,   0, 0,   0, 0,   0, 0,   0,   504, 0,
			434, 0, 0,   0, 0,   0, 0,   0, 0,   0,   0,   0,
			0,   0, 0,   0, 0,   0, 0,   0, 0,   0,   0,   0,
			0,   0, 0,   0, 0,   0, 0,   0, 0,   247, 0,   0,
			0,   0, 0,   0, 500, 0, 0,   0, 0,   0,
		],
		[
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 0,   0,
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 0,   0,
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 0,   0,
			0,   0, 0, 0,   0, 0, 0, 412, 0, 0, 0,   461,
			0,   0, 0, 554, 0, 0, 0, 0,   0, 0, 0,   0,
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 0,   0,
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 303, 0,
			513, 0, 0, 0,   0, 0, 0, 447, 0, 0,
		],
		[
			0, 0,   0,   0,   0, 0, 0, 0, 391, 502, 0, 0,
			0, 0,   280, 0,   0, 0, 0, 0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0, 0, 0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0, 0, 0, 0,   518, 0, 0,
			0, 0,   0,   0,   0, 0, 0, 0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0, 0, 0, 0,   0,   0, 0,
			0, 340, 0,   283, 0, 0, 0, 0, 0,   316, 0, 0,
			0, 0,   0,   0,   0, 0, 0, 0, 0,   299,
		],
		[
			530, 0,   351, 0,   0,   0, 0, 269, 0,   0,   0,   0,
			0,   0,   482, 0,   0,   0, 0, 0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0, 0, 0,   0,   0,   0,   232,
			0,   0,   0,   0,   0,   0, 0, 0,   0,   0,   0,   361,
			0,   0,   0,   276, 0,   0, 0, 0,   0,   255, 451, 201,
			0,   0,   0,   0,   0,   0, 0, 0,   0,   307, 0,   0,
			0,   525, 0,   0,   273, 0, 0, 0,   229, 0,   0,   0,
			0,   0,   0,   0,   0,   0, 0, 0,   0,   0,
		],
		[
			0,   0,   0, 0, 0,   0,   0,   0, 508, 0, 0, 252,
			0,   0,   0, 0, 0,   0,   266, 0, 0,   0, 0, 0,
			0,   0,   0, 0, 0,   0,   0,   0, 0,   0, 0, 302,
			0,   0,   0, 0, 0,   0,   0,   0, 0,   0, 0, 0,
			0,   467, 0, 0, 0,   0,   0,   0, 0,   0, 0, 0,
			0,   0,   0, 0, 0,   0,   0,   0, 0,   0, 0, 0,
			213, 0,   0, 0, 0,   0,   0,   0, 0,   0, 0, 0,
			0,   0,   0, 0, 342, 306, 0,   0, 0,   528,
		],
		[
			0, 0,   0,   0, 537, 0, 0, 233, 0, 0, 348, 0,
			0, 0,   0,   0, 0,   0, 0, 0,   0, 0, 0,   0,
			0, 0,   0,   0, 217, 0, 0, 293, 0, 0, 0,   0,
			0, 0,   0,   0, 317, 0, 0, 0,   0, 0, 0,   0,
			0, 599, 308, 0, 0,   0, 0, 0,   0, 0, 0,   0,
			0, 0,   0,   0, 0,   0, 0, 0,   0, 0, 0,   0,
			0, 0,   0,   0, 0,   0, 0, 0,   0, 0, 0,   0,
			0, 0,   0,   0, 0,   0, 0, 208, 0, 0,
		],
		[
			0, 0,   0, 301, 0, 0, 0,   0, 0, 0,   0, 0,
			0, 0,   0, 0,   0, 0, 579, 0, 0, 0,   0, 0,
			0, 0,   0, 0,   0, 0, 0,   0, 0, 0,   0, 0,
			0, 0,   0, 0,   0, 0, 0,   0, 0, 0,   0, 0,
			0, 0,   0, 0,   0, 0, 0,   0, 0, 0,   0, 0,
			0, 441, 0, 564, 0, 0, 0,   0, 0, 300, 0, 0,
			0, 0,   0, 0,   0, 0, 494, 0, 0, 0,   0, 0,
			0, 0,   0, 0,   0, 0, 0,   0, 0, 0,
		],
		[
			382, 0,   0,   0,   0, 0, 0, 0, 0, 0,   0, 0,
			0,   0,   0,   0,   0, 0, 0, 0, 0, 0,   0, 0,
			0,   0,   0,   331, 0, 0, 0, 0, 0, 0,   0, 0,
			0,   0,   0,   0,   0, 0, 0, 0, 0, 0,   0, 0,
			587, 0,   322, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0,   0,   0,   0,   0, 0, 0, 0, 0, 0,   0, 0,
			0,   0,   0,   400, 0, 0, 0, 0, 0, 464, 0, 0,
			0,   380, 0,   390, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,   0,   0,
			0, 0,   556, 0, 0,   0, 0, 0, 0, 583, 0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,   0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,   383, 0,
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,   0,   0,
			0, 256, 0,   0, 214, 0, 0, 0, 0, 0,   0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,   0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,
		],
		[
			0, 0,   0,   0, 535, 0, 0, 0, 251, 0, 0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0,   0, 0,   0,
			0, 319, 0,   0, 0,   0, 0, 0, 0,   0, 0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0,   0, 0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0,   0, 0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0,   0, 0,   0,
			0, 0,   569, 0, 0,   0, 0, 0, 0,   0, 369, 0,
			0, 0,   403, 0, 0,   0, 0, 0, 0,   0,
		],
		[
			0, 0, 0, 0,   0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 290, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 239, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 506, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0,   0,   0,   0,   0, 0, 0,   0, 0, 0, 0,
			0, 286, 0,   0,   0,   0, 0, 0,   0, 0, 0, 0,
			0, 0,   534, 0,   216, 0, 0, 0,   0, 0, 0, 0,
			0, 0,   0,   218, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0,   0,   0,   0,   0, 0, 0,   0, 0, 0, 0,
			0, 0,   0,   0,   0,   0, 0, 571, 0, 0, 0, 0,
			0, 0,   0,   0,   0,   0, 0, 0,   0, 0, 0, 0,
			0, 0,   0,   0,   0,   0, 0, 0,   0, 0,
		],
		[
			0,   0, 0, 0,   0,   0, 0, 0,   0, 0,   0, 0,
			0,   0, 0, 0,   0,   0, 0, 328, 0, 254, 0, 0,
			536, 0, 0, 0,   0,   0, 0, 0,   0, 0,   0, 443,
			0,   0, 0, 0,   0,   0, 0, 0,   0, 0,   0, 0,
			0,   0, 0, 0,   0,   0, 0, 0,   0, 0,   0, 0,
			0,   0, 0, 0,   0,   0, 0, 0,   0, 0,   0, 0,
			0,   0, 0, 0,   463, 0, 0, 0,   0, 0,   0, 0,
			0,   0, 0, 396, 0,   0, 0, 0,   0, 0,
		],
		[
			0, 0,   0,   0, 0, 0, 0,   0,   427, 0,   0,   0,
			0, 0,   466, 0, 0, 0, 0,   376, 0,   0,   0,   0,
			0, 385, 0,   0, 0, 0, 366, 0,   0,   562, 0,   0,
			0, 0,   0,   0, 0, 0, 0,   0,   0,   0,   529, 0,
			0, 0,   0,   0, 0, 0, 0,   0,   0,   0,   0,   0,
			0, 0,   0,   0, 0, 0, 0,   0,   0,   0,   0,   0,
			0, 0,   0,   0, 0, 0, 0,   0,   0,   421, 0,   0,
			0, 0,   0,   0, 0, 0, 0,   0,   0,   0,
		],
		[
			0,   0, 0,   0,   0, 395, 0, 0,   0,   0, 0,   0,
			0,   0, 315, 242, 0, 0,   0, 0,   548, 0, 357, 0,
			0,   0, 0,   0,   0, 0,   0, 394, 0,   0, 0,   0,
			498, 0, 0,   0,   0, 0,   0, 0,   0,   0, 0,   0,
			0,   0, 0,   0,   0, 0,   0, 0,   323, 0, 0,   0,
			0,   0, 0,   0,   0, 0,   0, 0,   0,   0, 0,   0,
			0,   0, 0,   0,   0, 0,   0, 0,   0,   0, 0,   456,
			0,   0, 0,   0,   0, 0,   0, 0,   0,   0,
		],
		[
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 349, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 491, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 413,
		],
		[
			484, 509, 0,   0, 0,   0, 0, 0, 0, 0,   0, 0,
			0,   0,   0,   0, 0,   0, 0, 0, 0, 0,   0, 0,
			0,   0,   0,   0, 0,   0, 0, 0, 0, 0,   0, 0,
			0,   0,   0,   0, 414, 0, 0, 0, 0, 0,   0, 0,
			0,   0,   330, 0, 0,   0, 0, 0, 0, 221, 0, 0,
			0,   0,   0,   0, 0,   0, 0, 0, 0, 0,   0, 0,
			0,   0,   0,   0, 0,   0, 0, 0, 0, 0,   0, 0,
			0,   0,   0,   0, 0,   0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0,   0, 0,   325, 0,   0,   0,   0,
			0, 0, 0, 0, 0,   0, 0,   0,   0,   0,   408, 0,
			0, 0, 0, 0, 0,   0, 0,   0,   0,   337, 298, 0,
			0, 0, 0, 0, 0,   0, 0,   0,   0,   0,   0,   0,
			0, 0, 0, 0, 584, 0, 379, 0,   304, 0,   0,   0,
			0, 0, 0, 0, 0,   0, 0,   0,   384, 0,   542, 0,
			0, 0, 0, 0, 0,   0, 0,   0,   0,   0,   297, 0,
			0, 0, 0, 0, 0,   0, 0,   0,   522, 0,
		],
		[
			0,   0,   0,   0, 0, 0,   0, 0,   0,   0, 0,   0,
			0,   0,   0,   0, 0, 507, 0, 0,   0,   0, 0,   0,
			0,   0,   0,   0, 0, 0,   0, 0,   0,   0, 0,   0,
			338, 0,   210, 0, 0, 0,   0, 279, 0,   0, 0,   0,
			0,   0,   0,   0, 0, 0,   0, 0,   0,   0, 359, 0,
			0,   296, 0,   0, 0, 0,   0, 0,   0,   0, 0,   0,
			0,   0,   0,   0, 0, 0,   0, 0,   0,   0, 575, 0,
			0,   0,   0,   0, 0, 0,   0, 0,   344, 0,
		],
		[
			0, 0, 0, 0,   0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 560, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 212, 0, 375, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0,   0, 0, 0, 0, 0, 0,
		],
		[
			0,   0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   517, 516, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			520, 0,   0,   0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0,   410, 0, 0,   0, 0,   0, 0, 0, 386, 0,
			0, 0,   0,   0, 0,   0, 0,   0, 0, 0, 0,   310,
			0, 0,   0,   0, 0,   0, 399, 0, 0, 0, 0,   0,
			0, 0,   0,   0, 0,   0, 0,   0, 0, 0, 0,   0,
			0, 0,   0,   0, 0,   0, 0,   0, 0, 0, 0,   0,
			0, 469, 0,   0, 424, 0, 0,   0, 0, 0, 0,   0,
			0, 0,   0,   0, 0,   0, 0,   0, 0, 0, 0,   0,
			0, 0,   0,   0, 0,   0, 0,   0, 0, 0,
		],
		[
			0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			334, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 428,
			0,   0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0,   0, 0, 0, 0, 0, 0, 475, 0, 437, 0, 0,
			268, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0,   0, 0, 0, 0, 0, 0, 0,   0, 0,
		],
		[
			0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 234, 0,   0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 512, 0,
			0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 0,   0,
			0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 0,   501,
			0, 416, 549, 471, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   505, 0, 0, 0, 0, 0, 0, 0, 0, 581,
			0, 263, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0,   0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0, 514, 0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 220,
			0, 0, 0, 0,   0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0, 0,   0, 481, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 275, 0, 0,   0, 0, 0,   0,
		],
		[
			0, 0, 0,   0, 0,   0, 0,   0,   0,   0,   0, 0,
			0, 0, 0,   0, 0,   0, 0,   0,   0,   0,   0, 0,
			0, 0, 0,   0, 0,   0, 0,   326, 0,   0,   0, 0,
			0, 0, 0,   0, 0,   0, 0,   0,   0,   0,   0, 0,
			0, 0, 392, 0, 0,   0, 0,   389, 0,   431, 0, 288,
			0, 0, 0,   0, 0,   0, 474, 0,   0,   0,   0, 0,
			0, 0, 0,   0, 0,   0, 0,   0,   588, 0,   0, 0,
			0, 0, 0,   0, 267, 0, 444, 0,   0,   0,
		],
		[
			0, 0, 0, 363, 0,   0, 0, 0,   0,   0, 0, 521,
			0, 0, 0, 0,   0,   0, 0, 558, 0,   0, 0, 0,
			0, 0, 0, 0,   0,   0, 0, 0,   0,   0, 0, 0,
			0, 0, 0, 0,   0,   0, 0, 0,   0,   0, 0, 0,
			0, 0, 0, 0,   0,   0, 0, 0,   544, 0, 0, 0,
			0, 0, 0, 0,   0,   0, 0, 0,   0,   0, 0, 0,
			0, 0, 0, 0,   0,   0, 0, 0,   0,   0, 0, 0,
			0, 0, 0, 0,   453, 0, 0, 0,   0,   0,
		],
		[
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 472, 0, 0, 0, 0, 543, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			457, 0, 0, 0, 0,   0, 378, 0,   0, 0, 333, 0,
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0, 0,   0,
			0,   0, 0, 0, 377, 0, 0,   0,   0, 0, 0,   0,
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0, 0,   0,
			0,   0, 0, 0, 0,   0, 257, 473, 0, 0, 0,   0,
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0, 0,   0,
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0, 0,   0,
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0,
		],
		[
			0, 0, 0, 0, 347, 0,   0,   0, 567, 0,   0, 0,
			0, 0, 0, 0, 0,   0,   0,   0, 0,   0,   0, 0,
			0, 0, 0, 0, 0,   0,   0,   0, 0,   0,   0, 0,
			0, 0, 0, 0, 0,   0,   0,   0, 0,   0,   0, 0,
			0, 0, 0, 0, 0,   0,   0,   0, 0,   0,   0, 0,
			0, 0, 0, 0, 0,   0,   0,   0, 0,   203, 0, 0,
			0, 0, 0, 0, 0,   0,   0,   0, 0,   0,   0, 0,
			0, 0, 0, 0, 0,   436, 552, 0, 0,   0,
		],
		[
			0,   0, 0, 236, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			261, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 260, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
		],
		[
			0, 0,   0, 0,   0, 0, 0, 0,   0,   0, 0, 0,
			0, 0,   0, 362, 0, 0, 0, 0,   489, 0, 0, 0,
			0, 209, 0, 0,   0, 0, 0, 372, 0,   0, 0, 0,
			0, 0,   0, 0,   0, 0, 0, 0,   0,   0, 0, 0,
			0, 0,   0, 0,   0, 0, 0, 0,   0,   0, 0, 0,
			0, 0,   0, 0,   0, 0, 0, 0,   0,   0, 0, 0,
			0, 0,   0, 0,   0, 0, 0, 0,   0,   0, 0, 0,
			0, 0,   0, 0,   0, 0, 0, 0,   0,   0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 557, 0, 0, 0, 0, 0,
		],
		[
			313, 406, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 576,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			270, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 541, 0, 0, 0, 0, 0,   0, 0,   0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0,   0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 206, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0,   0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0,   0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0,   0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0,   0, 0, 0,
			0, 0,   0, 0, 0, 0, 244, 0, 0,   0,
		],
		[
			0, 0, 0, 0, 0,   0,   0,   0, 0,   0, 0, 0,
			0, 0, 0, 0, 0,   0,   0,   0, 0,   0, 0, 0,
			0, 0, 0, 0, 0,   0,   0,   0, 0,   0, 0, 0,
			0, 0, 0, 0, 205, 0,   0,   0, 0,   0, 0, 0,
			0, 0, 0, 0, 0,   237, 0,   0, 364, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   374, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0,   0,   0,   0, 0,   0, 0, 0,
			0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
		],
		[
			0, 0,   0, 339, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 404, 0, 0,
			0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 459, 0, 0,   0, 0,
			0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 250, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 235, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 259, 0, 0,   0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   478, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 545, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0,   0,
		],
		[
			0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 499, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   295, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 496, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 439, 0, 341, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0,   0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0,
			0,   0, 0, 433, 0, 238, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0,
			294, 0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0, 0,   0, 0, 0, 0,
		],
		[
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 355, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 398, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0,   0, 0, 0,   0,   0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0,   0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0,   0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 291, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   401, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0,   0, 0, 0, 0, 0, 0, 0,
			368, 0, 0, 0,   0,   0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0,   0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 388, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
	];
	$GBKFreq = [
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 318, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 577, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,   0,
		],
		[
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 583, 0, 0, 556, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0,   0, 0, 0,
		],
		[
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 360, 419, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 402, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 466, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 376, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 562, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 512, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 529, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 359, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0,   0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0,   0, 0, 0, 0, 576,
			0, 0, 0,   0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 472, 0,   0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 421, 0, 0, 0,   543, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0,   0,   0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 319,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 344, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 315, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 357, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 471, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 459, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 362, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 569, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 369, 0, 0, 0, 0, 0, 581,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 391, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 372, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 489, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 541, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 355, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 566, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 388, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 579, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 517,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 509, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 514, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0,   0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0, 0,   0, 0, 520, 0, 0,   0,
			0, 0,   0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 366, 0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0, 487, 0, 0, 0,   0, 0,   0,
			0, 409, 0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0, 0,   0, 0, 0,   0, 340, 0,
			0, 0,   0, 0, 0, 0,   0, 0, 0,   0, 0,   0,
			0, 0,   0, 0, 0, 0,   0, 0, 0,   0, 0,
		],
		[
			0, 0, 0, 0,   0,   0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0,   0,   0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0,   0,   0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0,   0,   0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0,   0,   0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0,   0,   0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0,   0,   0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0,   0,   0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0,   0,   0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0,   0,   0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 408, 0,   0,   511, 0, 0, 0, 0, 0,
			0, 0, 0, 0,   465, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0,   0,   0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0,   0,   0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0,   0,   361, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0,   0,   0,   0,   0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 598, 0, 0, 0, 384,
			0, 0, 0, 0, 0, 429, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0,
		],
		[
			0, 0, 0,   0,   0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0,   0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0,   0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0,   0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0,   0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0,   0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0,   0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0,   0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   395, 0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0,   0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0,   0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   467, 0, 526, 0, 0, 410, 0, 0, 0,
			0, 0, 0,   0,   0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0,   0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0,   0, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 546, 0,   0, 0,   0, 0, 0,   0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   488, 0, 0, 449, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0, 0, 446, 594,
			0, 0, 0, 0, 0, 0, 327, 0,   0, 0, 0,
		],
		[
			0,   0, 0, 0, 0,   0,   0, 0, 0,   0, 0,   0,
			0,   0, 0, 0, 0,   0,   0, 0, 0,   0, 0,   0,
			0,   0, 0, 0, 0,   0,   0, 0, 0,   0, 0,   0,
			0,   0, 0, 0, 0,   0,   0, 0, 0,   0, 0,   0,
			0,   0, 0, 0, 0,   0,   0, 0, 0,   0, 0,   0,
			0,   0, 0, 0, 0,   0,   0, 0, 0,   0, 0,   0,
			0,   0, 0, 0, 0,   0,   0, 0, 0,   0, 0,   0,
			0,   0, 0, 0, 0,   0,   0, 0, 0,   0, 0,   0,
			0,   0, 0, 0, 0,   0,   0, 0, 0,   0, 0,   515,
			0,   0, 0, 0, 0,   0,   0, 0, 0,   0, 0,   0,
			0,   0, 0, 0, 0,   589, 0, 0, 521, 0, 0,   548,
			600, 0, 0, 0, 386, 0,   0, 0, 0,   0, 0,   0,
			0,   0, 0, 0, 0,   0,   0, 0, 519, 0, 414, 0,
			332, 0, 0, 0, 0,   0,   0, 0, 0,   0, 0,   0,
			0,   0, 0, 0, 0,   0,   0, 0, 0,   0, 0,   0,
			0,   0, 0, 0, 0,   0,   0, 0, 0,   0, 0,
		],
		[
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 500, 0, 0, 0, 0,   0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 542, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 342, 0, 0, 0, 0,   0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0,
			553, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 539, 0, 0, 0, 0,   0, 468,
		],
		[
			0, 0,   0,   0,   0, 0,   0,   0, 0,   0,   0, 0,
			0, 0,   457, 0,   0, 0,   0,   0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   0,   0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   0,   0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   0,   0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   0,   0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   0,   0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   0,   0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   0,   0, 518, 0,   0, 0,
			0, 0,   0,   0,   0, 0,   0,   0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 493, 0,   0, 0,   0,   0, 0,
			0, 303, 0,   307, 0, 0,   0,   0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   454, 0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   0,   0, 0,   0,   0, 0,
			0, 0,   0,   0,   0, 0,   0,   0, 0,   373, 0, 0,
			0, 0,   0,   0,   0, 0,   0,   0, 0,   0,   0,
		],
		[
			0,   0, 0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0,   0, 0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0,   0, 0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0,   0, 0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0,   0, 0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0,   0, 0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0,   0, 0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0,   0, 0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0,   0, 0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0,   0, 0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0,   0, 0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			305, 0, 0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			416, 0, 0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0,   0, 0, 463, 0, 0, 0, 0, 0,   0, 346, 0,
			0,   0, 0, 0,   0, 0, 0, 0, 0,   0, 0,   0,
			0,   0, 0, 423, 0, 0, 0, 0, 345, 0, 0,
		],
		[
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0, 0, 0, 547, 0, 0,   0,   0, 0, 0, 407,
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			378, 0, 0, 0, 0,   0, 336, 0,   0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0,   0,   0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0,   502, 0, 0, 302,
		],
		[
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0,   0,   0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0,   0,   0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0,   0,   0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0,   0,   0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0,   0,   0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0,   0,   0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0,   0,   0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0,   0,   0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0,   0,   0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0,   0,   0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0,   0,   580,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 504, 523, 350,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0,   0,   0,
			528, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,   0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0,   0,   0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
		],
		[
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   427, 0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   417, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0, 0, 0, 0, 0, 0, 301, 0,   0,   0, 461, 0,
			0, 0, 0, 0, 0, 0, 0,   0,   0,   0, 0,
		],
		[
			0, 0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0,   405, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 442, 0,   0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 535, 418, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0, 0, 0, 0, 0,
		],
		[
			0, 0,   0, 0,   0, 0, 0,   0,   0,   0,   0, 0,
			0, 0,   0, 0,   0, 0, 0,   0,   0,   0,   0, 0,
			0, 310, 0, 0,   0, 0, 0,   0,   0,   0,   0, 0,
			0, 0,   0, 0,   0, 0, 0,   0,   0,   0,   0, 399,
			0, 0,   0, 0,   0, 0, 0,   0,   0,   330, 0, 0,
			0, 0,   0, 0,   0, 0, 0,   0,   0,   0,   0, 0,
			0, 0,   0, 0,   0, 0, 0,   0,   0,   0,   0, 0,
			0, 0,   0, 0,   0, 0, 0,   481, 0,   0,   0, 0,
			0, 0,   0, 0,   0, 0, 0,   0,   306, 0,   0, 0,
			0, 0,   0, 0,   0, 0, 0,   0,   0,   0,   0, 0,
			0, 0,   0, 574, 0, 0, 0,   0,   0,   0,   0, 0,
			0, 0,   0, 0,   0, 0, 0,   0,   456, 0,   0, 0,
			0, 0,   0, 323, 0, 0, 0,   0,   0,   0,   0, 0,
			0, 0,   0, 0,   0, 0, 389, 0,   0,   0,   0, 0,
			0, 0,   0, 0,   0, 0, 0,   0,   0,   335, 0, 0,
			0, 0,   0, 0,   0, 0, 0,   0,   0,   0,   0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 377, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 575, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0,
		],
		[
			0, 0, 0,   0, 0,   0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0, 0, 564, 0, 0, 0,
			0, 0, 0,   0, 343, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 494, 0, 0,   585, 0, 0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0, 356, 0,   0, 0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0, 0, 0,   0, 0,
		],
		[
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   385, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 411,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 484, 0,   0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0, 0,
		],
		[
			0, 0, 0,   0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 353, 0, 0, 0, 460, 0,   0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0,   591, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0,   0,   0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0,   0,   0, 0, 0,
		],
		[
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			398, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 444,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0,   0, 0, 0, 0,   0,   0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0,   0,   0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0,   0,   0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0,   0,   0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0,   0,   0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0,   0,   0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0,   0,   0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0,   0,   0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0,   0,   0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0,   0,   0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 311, 382, 0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0,   0,   0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0,   0,   0,   0,   0,
			0, 0, 0, 0,   0, 0, 0, 0,   0,   0,   464, 0,
			0, 0, 0, 0,   0, 0, 0, 0,   0,   425, 0,   0,
			0, 0, 0, 447, 0, 0, 0, 480, 0,   0,   0,
		],
		[
			0,   0, 0,   0,   0, 0, 0,   0,   0,   0, 0, 0,
			0,   0, 0,   0,   0, 0, 0,   0,   0,   0, 0, 0,
			0,   0, 0,   0,   0, 0, 0,   0,   0,   0, 0, 0,
			0,   0, 0,   0,   0, 0, 0,   0,   0,   0, 0, 0,
			0,   0, 0,   0,   0, 0, 0,   0,   0,   0, 0, 0,
			0,   0, 0,   0,   0, 0, 0,   0,   0,   0, 0, 0,
			0,   0, 0,   0,   0, 0, 0,   0,   0,   0, 0, 0,
			0,   0, 0,   0,   0, 0, 0,   0,   0,   0, 0, 0,
			0,   0, 0,   0,   0, 0, 0,   0,   0,   0, 0, 0,
			0,   0, 0,   0,   0, 0, 0,   0,   0,   0, 0, 0,
			0,   0, 0,   0,   0, 0, 0,   352, 0,   0, 0, 0,
			0,   0, 0,   563, 0, 0, 0,   0,   0,   0, 0, 0,
			314, 0, 0,   0,   0, 0, 0,   0,   434, 0, 0, 0,
			571, 0, 0,   0,   0, 0, 0,   582, 0,   0, 0, 0,
			0,   0, 510, 0,   0, 0, 0,   0,   0,   0, 0, 0,
			0,   0, 0,   0,   0, 0, 394, 0,   0,   0, 0,
		],
		[
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 473,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 458, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0,   0, 0, 0, 0,   0, 0, 0, 0, 0, 375, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 497, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			443, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,   0, 0, 0, 0,
		],
		[
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,   0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,   0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,   0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,   0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,   0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,   0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,   0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,   0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,   0,   0,
			0, 0,   0,   0, 508, 0, 0, 0, 0, 0,   0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,   0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,   0,   0,
			0, 0,   309, 0, 0,   0, 0, 0, 0, 0,   0,   0,
			0, 0,   0,   0, 0,   0, 0, 0, 0, 491, 0,   0,
			0, 498, 0,   0, 0,   0, 0, 0, 0, 0,   413, 0,
			0, 0,   0,   0, 0,   0, 0, 0, 0, 0,   0,
		],
		[
			0,   469, 0, 0,   0, 0,   0, 0,   0, 0,   0, 0,
			0,   0,   0, 0,   0, 0,   0, 0,   0, 0,   0, 0,
			0,   0,   0, 0,   0, 0,   0, 0,   0, 0,   0, 0,
			0,   0,   0, 0,   0, 0,   0, 0,   0, 0,   0, 0,
			0,   0,   0, 0,   0, 0,   0, 0,   0, 0,   0, 0,
			0,   0,   0, 0,   0, 0,   0, 0,   0, 0,   0, 0,
			0,   0,   0, 0,   0, 0,   0, 0,   0, 0,   0, 0,
			0,   0,   0, 0,   0, 0,   0, 0,   0, 0,   0, 0,
			0,   0,   0, 0,   0, 531, 0, 0,   0, 0,   0, 422,
			0,   0,   0, 0,   0, 0,   0, 0,   0, 0,   0, 0,
			0,   0,   0, 516, 0, 0,   0, 0,   0, 0,   0, 0,
			0,   0,   0, 0,   0, 0,   0, 592, 0, 0,   0, 0,
			0,   0,   0, 0,   0, 477, 0, 0,   0, 0,   0, 0,
			0,   0,   0, 0,   0, 0,   0, 0,   0, 0,   0, 570,
			0,   0,   0, 371, 0, 0,   0, 0,   0, 0,   0, 0,
			331, 0,   0, 0,   0, 0,   0, 0,   0, 490, 0,
		],
		[
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 312, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0, 578,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 420, 0, 0,
			0, 0, 0, 0, 0, 0,   0,   0, 0, 0,   0, 351,
			0, 0, 0, 0, 0, 329, 0,   0, 0, 0,   0, 0,
			0, 0, 0, 0, 0, 0,   561, 0, 0, 0,   0,
		],
		[
			0, 0,   0,   0,   0, 0,   0,   0, 0, 0, 0,   0,
			0, 0,   0,   0,   0, 0,   0,   0, 0, 0, 0,   0,
			0, 0,   0,   0,   0, 0,   0,   0, 0, 0, 0,   0,
			0, 0,   0,   0,   0, 0,   0,   0, 0, 0, 0,   0,
			0, 0,   0,   0,   0, 0,   0,   0, 0, 0, 0,   0,
			0, 0,   0,   0,   0, 0,   0,   0, 0, 0, 0,   0,
			0, 0,   0,   0,   0, 0,   0,   0, 0, 0, 0,   0,
			0, 0,   0,   0,   0, 0,   0,   0, 0, 0, 0,   0,
			0, 0,   0,   0,   0, 0,   0,   0, 0, 0, 0,   0,
			0, 0,   438, 0,   0, 0,   479, 0, 0, 0, 0,   0,
			0, 432, 0,   0,   0, 415, 0,   0, 0, 0, 495, 0,
			0, 0,   0,   599, 0, 0,   0,   0, 0, 0, 0,   0,
			0, 0,   0,   0,   0, 0,   450, 0, 0, 0, 0,   0,
			0, 0,   0,   0,   0, 0,   0,   0, 0, 0, 0,   0,
			0, 0,   0,   0,   0, 0,   0,   0, 0, 0, 0,   0,
			0, 0,   0,   0,   0, 0,   0,   0, 0, 0, 0,
		],
		[
			0,   0, 0,   0, 0, 0,   0, 0,   0,   0,   0, 0,
			0,   0, 0,   0, 0, 0,   0, 0,   0,   0,   0, 0,
			0,   0, 0,   0, 0, 0,   0, 0,   0,   0,   0, 0,
			0,   0, 0,   0, 0, 0,   0, 0,   0,   0,   0, 0,
			0,   0, 0,   0, 0, 0,   0, 0,   0,   0,   0, 0,
			0,   0, 0,   0, 0, 0,   0, 0,   0,   0,   0, 0,
			0,   0, 0,   0, 0, 0,   0, 0,   0,   0,   0, 0,
			0,   0, 0,   0, 0, 0,   0, 0,   0,   0,   0, 0,
			0,   0, 0,   0, 0, 0,   0, 0,   0,   0,   0, 0,
			0,   0, 397, 0, 0, 0,   0, 0,   0,   0,   0, 0,
			0,   0, 0,   0, 0, 0,   0, 0,   0,   0,   0, 0,
			367, 0, 0,   0, 0, 0,   0, 0,   0,   0,   0, 0,
			0,   0, 0,   0, 0, 0,   0, 0,   0,   0,   0, 0,
			0,   0, 0,   0, 0, 0,   0, 333, 0,   0,   0, 0,
			0,   0, 0,   0, 0, 0,   0, 0,   0,   0,   0, 0,
			0,   0, 0,   0, 0, 554, 0, 565, 358, 426, 0,
		],
		[
			0, 0, 0,   0, 0,   0,   0,   0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   325, 0, 0,   0, 0, 0,
			0, 0, 326, 0, 0,   0,   0,   0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 527, 0, 0, 445,
			0, 0, 0,   0, 0,   0,   0,   0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   560, 0,   0, 0,   0, 0, 0,
			0, 0, 0,   0, 555, 0,   0,   0, 0,   0, 0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0,   0, 0,
		],
		[
			0,   0, 0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0, 0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0, 0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0, 0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0, 0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0, 0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0, 0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0, 0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0, 0,   0, 0, 0, 0,   0,   379, 0, 0,   0,
			524, 0, 0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0, 0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0, 0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0, 0,   0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0, 0,   0, 0, 0, 435, 0,   0,   0, 316, 0,
			0,   0, 324, 0, 0, 0, 0,   0,   0,   0, 0,   0,
			0,   0, 0,   0, 0, 0, 0,   349, 0,   0, 0,
		],
		[
			0,   0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0,   486, 0, 0, 0, 0, 0, 0, 0, 0,
			568, 0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 597, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0,   0,   0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0,   0,   0, 0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0,   0, 0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0,   0, 0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0,   0, 0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0,   0, 0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0,   0, 0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0,   0, 0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0,   0, 0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0,   0, 0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0,   0, 338, 0, 0, 452, 0,   0,
			0, 0, 0, 0,   0,   0, 0,   0, 0, 0,   559, 0,
			0, 0, 0, 0,   381, 0, 0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   0,   0, 0,   0, 0, 0,   0,   0,
			0, 0, 0, 0,   441, 0, 0,   0, 0, 0,   0,   0,
			0, 0, 0, 549, 0,   0, 0,   0, 0, 453, 0,   0,
			0, 0, 0, 0,   0,   0, 0,   0, 0, 0,   0,
		],
		[
			0,   0,   0, 0,   0,   0, 0, 0, 0, 0,   0,   0,
			0,   0,   0, 0,   0,   0, 0, 0, 0, 0,   0,   0,
			0,   0,   0, 0,   0,   0, 0, 0, 0, 0,   0,   0,
			0,   0,   0, 0,   0,   0, 0, 0, 0, 0,   0,   0,
			0,   0,   0, 0,   0,   0, 0, 0, 0, 0,   0,   0,
			0,   0,   0, 0,   0,   0, 0, 0, 0, 0,   0,   0,
			0,   0,   0, 0,   0,   0, 0, 0, 0, 0,   0,   0,
			0,   0,   0, 0,   0,   0, 0, 0, 0, 0,   0,   0,
			0,   551, 0, 403, 0,   0, 0, 0, 0, 492, 0,   0,
			0,   0,   0, 0,   0,   0, 0, 0, 0, 0,   0,   0,
			0,   0,   0, 0,   0,   0, 0, 0, 0, 0,   505, 0,
			533, 525, 0, 308, 0,   0, 0, 0, 0, 0,   0,   0,
			483, 0,   0, 0,   412, 0, 0, 0, 0, 0,   0,   0,
			0,   0,   0, 0,   0,   0, 0, 0, 0, 0,   0,   0,
			0,   0,   0, 0,   0,   0, 0, 0, 0, 0,   0,   0,
			0,   0,   0, 0,   0,   0, 0, 0, 0, 0,   0,
		],
		[
			0,   0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   392, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			300, 0,   0, 0, 321, 0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0,   0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
		],
		[
			0,   0,   0,   0,   0,   0, 0,   0, 0, 0, 0,   0,
			0,   0,   0,   0,   0,   0, 0,   0, 0, 0, 0,   0,
			0,   0,   0,   0,   0,   0, 0,   0, 0, 0, 0,   0,
			0,   0,   0,   0,   0,   0, 0,   0, 0, 0, 0,   0,
			0,   0,   0,   0,   0,   0, 0,   0, 0, 0, 0,   0,
			0,   0,   0,   0,   0,   0, 0,   0, 0, 0, 0,   0,
			0,   0,   393, 0,   0,   0, 0,   0, 0, 0, 0,   0,
			0,   0,   0,   0,   0,   0, 0,   0, 0, 0, 0,   0,
			0,   0,   0,   0,   0,   0, 0,   0, 0, 0, 587, 0,
			0,   0,   0,   0,   0,   0, 573, 0, 0, 0, 0,   0,
			0,   0,   0,   596, 0,   0, 0,   0, 0, 0, 0,   0,
			0,   0,   0,   0,   0,   0, 0,   0, 0, 0, 0,   0,
			0,   448, 0,   0,   586, 0, 0,   0, 0, 0, 0,   0,
			0,   0,   0,   0,   0,   0, 501, 0, 0, 0, 0,   0,
			0,   0,   0,   0,   0,   0, 0,   0, 0, 0, 503, 0,
			380, 0,   0,   0,   0,   0, 0,   0, 0, 0, 0,
		],
		[
			0,   0,   0, 0,   0, 0,   0,   0,   0, 0, 0, 0,
			0,   0,   0, 0,   0, 0,   0,   0,   0, 0, 0, 0,
			433, 0,   0, 0,   0, 0,   0,   0,   0, 0, 0, 0,
			0,   0,   0, 0,   0, 0,   0,   0,   0, 0, 0, 0,
			0,   0,   0, 0,   0, 0,   0,   0,   0, 0, 0, 0,
			0,   0,   0, 0,   0, 0,   0,   0,   0, 0, 0, 0,
			0,   0,   0, 322, 0, 536, 0,   0,   0, 0, 0, 0,
			0,   0,   0, 0,   0, 0,   0,   328, 0, 0, 0, 0,
			0,   0,   0, 0,   0, 0,   0,   0,   0, 0, 0, 0,
			0,   0,   0, 0,   0, 0,   0,   0,   0, 0, 0, 0,
			0,   0,   0, 0,   0, 0,   0,   0,   0, 0, 0, 572,
			0,   0,   0, 0,   0, 365, 0,   0,   0, 0, 0, 0,
			595, 430, 0, 0,   0, 0,   462, 0,   0, 0, 0, 0,
			0,   0,   0, 0,   0, 0,   0,   0,   0, 0, 0, 0,
			0,   0,   0, 0,   0, 0,   0,   0,   0, 0, 0, 0,
			0,   0,   0, 0,   0, 0,   0,   0,   0, 0, 0,
		],
		[
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0, 0, 0, 337, 0, 0,   0,   0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   474, 431,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,   0,
			0, 383, 0, 0, 0, 0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   387, 0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 470, 593, 0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,   0,
			0, 348, 0, 0, 0, 0, 0, 0,   0, 0,   0,
		],
		[
			0,   0, 0,   0,   0, 0, 0,   0, 0,   0,   347, 0,
			0,   0, 0,   0,   0, 0, 0,   0, 0,   0,   0,   0,
			0,   0, 0,   0,   0, 0, 0,   0, 0,   0,   0,   0,
			0,   0, 567, 0,   0, 0, 0,   0, 313, 0,   0,   0,
			0,   0, 0,   0,   0, 0, 0,   0, 0,   0,   0,   0,
			0,   0, 0,   0,   0, 0, 0,   0, 0,   0,   0,   0,
			557, 0, 0,   0,   0, 0, 0,   0, 0,   0,   0,   406,
			0,   0, 0,   0,   0, 0, 0,   0, 0,   0,   0,   0,
			0,   0, 0,   0,   0, 0, 0,   0, 0,   0,   0,   0,
			0,   0, 0,   0,   0, 0, 0,   0, 0,   0,   0,   0,
			0,   0, 0,   0,   0, 0, 534, 0, 0,   0,   522, 0,
			0,   0, 0,   0,   0, 0, 0,   0, 0,   0,   0,   0,
			0,   0, 370, 0,   0, 0, 0,   0, 0,   0,   0,   0,
			0,   0, 0,   482, 0, 0, 0,   0, 0,   0,   506, 0,
			0,   0, 0,   0,   0, 0, 0,   0, 0,   0,   0,   0,
			0,   0, 0,   0,   0, 0, 0,   0, 0,   476, 317,
		],
		[
			0,   0, 0,   0,   0,   0,   0, 0, 0,   0,   0,   0,
			0,   0, 0,   0,   0,   0,   0, 0, 0,   0,   0,   0,
			0,   0, 0,   0,   0,   0,   0, 0, 0,   0,   0,   0,
			0,   0, 0,   0,   0,   0,   0, 0, 0,   0,   0,   0,
			0,   0, 0,   0,   0,   0,   0, 0, 478, 0,   0,   0,
			0,   0, 0,   0,   0,   0,   0, 0, 0,   0,   0,   0,
			0,   0, 0,   0,   0,   0,   0, 0, 0,   0,   0,   0,
			0,   0, 0,   0,   0,   0,   0, 0, 0,   0,   0,   0,
			0,   0, 0,   0,   0,   0,   0, 0, 0,   0,   530, 0,
			0,   0, 550, 0,   0,   299, 0, 0, 0,   0,   0,   0,
			0,   0, 0,   532, 0,   0,   0, 0, 0,   354, 0,   0,
			0,   0, 0,   0,   0,   0,   0, 0, 0,   0,   0,   0,
			590, 0, 0,   0,   0,   0,   0, 0, 400, 0,   0,   0,
			0,   0, 0,   0,   0,   0,   0, 0, 0,   0,   0,   0,
			0,   0, 0,   0,   0,   0,   0, 0, 0,   0,   0,   0,
			0,   0, 0,   440, 424, 0,   0, 0, 0,   0,   0,
		],
		[
			0, 0, 0,   0,   0,   0, 0,   0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0,   0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0,   0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0,   0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0,   0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0,   0, 0, 0, 0, 0,
			0, 0, 0,   0,   368, 0, 0,   0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0,   0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0,   0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0,   0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0,   0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0,   0, 0, 0, 0, 0,
			0, 0, 0,   538, 540, 0, 320, 0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 0,   0, 0, 0, 0, 0,
			0, 0, 0,   0,   0,   0, 507, 0, 0, 0, 0, 0,
			0, 0, 396, 485, 0,   0, 0,   0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 334, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 588, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 455, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 363, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			584, 0,   304, 0, 0,   0, 0,   0, 0,   0, 0, 0,
			0,   428, 0,   0, 0,   0, 0,   0, 0,   0, 0, 0,
			0,   0,   0,   0, 0,   0, 558, 0, 0,   0, 0, 0,
			0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0, 0,
			0,   0,   0,   0, 0,   0, 0,   0, 364, 0, 0, 0,
			0,   0,   0,   0, 545, 0, 0,   0, 0,   0, 0, 0,
			0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0, 0,
			0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0, 0,
			0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0, 0,
			0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0, 0,
			0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0, 0,
			0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0, 0,
			0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0, 0,
			0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0, 0,
			0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0, 0,
			0,   0,   0,   0, 0,   0, 0,   0, 0,   0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 537, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 374, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0,
			451, 0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 475, 0, 0, 0, 0,
			0,   0, 0, 437, 0, 0, 0, 0,   0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0,   0, 0, 0,
		],
		[
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			439, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 341, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 544, 0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0,   0,
		],
		[
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 513, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 339, 0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 496, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0, 0,
			0, 0,   0, 0, 0, 0, 0,   0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 390, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 401, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			436, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 552, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 499,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 404, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
	];
	$KRFreq = [
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 597, 0,   0,   0, 0, 568, 0, 0, 0,
			0, 0, 0, 0,   355, 553, 0, 0, 0,   0, 0, 0,
			0, 0, 0, 0,   0,   0,   0, 0, 0,   0, 0, 0,
			0, 0, 0, 0,   0,   0,   0, 0, 0,   0, 0, 0,
			0, 0, 0, 0,   0,   0,   0, 0, 0,   0, 0, 0,
			0, 0, 0, 0,   0,   0,   0, 0, 0,   0, 0, 0,
			0, 0, 0, 0,   0,   0,   0, 0, 0,   0, 0, 0,
			0, 0, 0, 0,   0,   0,   0, 0, 0,   0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			589, 432, 460, 0,   0,   0,   0,   422, 361, 77,  0, 0,
			319, 243, 0,   426, 0,   57,  499, 300, 0,   0,   0, 0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 0,
			492, 75,  419, 0,   363, 0,   368, 234, 564, 0,   0, 0,
			0,   0,   0,   569, 0,   0,   0,   0,   0,   494, 0, 152,
			250, 0,   120, 0,   439, 0,   0,   0,   0,   477, 0, 495,
			0,   0,   0,   0,   587, 168, 54,  208, 183, 0,   0, 0,
			0,   109, 386, 510, 0,   542, 0,   470, 0,   0,
		],
		[
			0,   0,   0,   382, 0,   9,   0,   0,   0,   0,   156, 0,
			0,   0,   0,   0,   0,   0,   435, 0,   0,   0,   0,   539,
			497, 353, 0,   415, 0,   0,   0,   0,   0,   0,   91,  0,
			0,   0,   371, 0,   0,   0,   0,   0,   195, 0,   0,   0,
			0,   0,   0,   133, 0,   0,   588, 159, 264, 0,   189, 0,
			491, 286, 0,   0,   0,   579, 0,   63,  0,   360, 0,   367,
			0,   0,   0,   0,   131, 538, 0,   0,   235, 0,   0,   102,
			17,  0,   0,   0,   0,   203, 0,   0,   0,   0,
		],
		[
			0, 0,   0,  0,   0,   0,   0,   153, 0,   0, 0, 0,
			0, 0,   0,  0,   0,   366, 0,   0,   0,   0, 0, 0,
			0, 0,   0,  0,   0,   0,   124, 144, 0,   0, 0, 12,
			0, 0,   0,  0,   295, 0,   0,   0,   0,   0, 0, 0,
			0, 0,   0,  0,   0,   0,   0,   0,   289, 0, 0, 0,
			0, 147, 0,  0,   0,   0,   0,   0,   0,   0, 0, 0,
			0, 0,   0,  0,   0,   13,  0,   0,   0,   0, 0, 128,
			0, 0,   78, 119, 0,   0,   15,  0,   0,   0,
		],
		[
			272, 293, 0,   0,   0,   0,   0,   0,   0, 583, 0,   0,
			258, 0,   462, 0,   0,   529, 27,  0,   0, 0,   0,   0,
			0,   0,   545, 0,   0,   0,   0,   0,   0, 0,   0,   0,
			0,   0,   0,   0,   14,  420, 0,   0,   0, 0,   0,   0,
			202, 0,   0,   0,   0,   88,  448, 0,   0, 0,   0,   0,
			58,  0,   0,   431, 141, 375, 0,   0,   0, 0,   150, 0,
			0,   0,   395, 0,   110, 223, 0,   194, 0, 0,   0,   146,
			364, 0,   0,   0,   0,   35,  0,   0,   0, 0,
		],
		[
			0,   0,   0,   0,   0,   0,  0,   0,   344, 0,   430, 0,
			0,   0,   0,   0,   0,   0,  0,   0,   0,   0,   0,   0,
			0,   96,  0,   0,   0,   0,  0,   333, 0,   595, 383, 0,
			0,   0,   0,   0,   291, 52, 0,   0,   0,   0,   580, 0,
			0,   0,   0,   417, 0,   0,  0,   0,   599, 107, 0,   450,
			7,   476, 0,   0,   0,   0,  267, 380, 0,   0,   484, 0,
			0,   0,   555, 0,   0,   0,  0,   0,   0,   0,   0,   0,
			537, 137, 0,   89,  0,   0,  0,   0,   0,   0,
		],
		[
			0,   0,  0,   83, 507, 0,   0,   45,  0,   0,   0,   0,
			0,   0,  0,   0,  0,   0,   0,   0,   572, 240, 427, 0,
			436, 0,  0,   0,  228, 0,   520, 0,   0,   0,   0,   0,
			0,   0,  552, 0,  0,   0,   0,   0,   0,   487, 283, 0,
			125, 55, 0,   0,  47,  0,   0,   0,   0,   216, 0,   0,
			0,   41, 0,   0,  0,   0,   0,   0,   465, 276, 414, 190,
			570, 0,  0,   0,  306, 356, 0,   411, 0,   0,   0,   0,
			0,   0,  0,   0,  0,   0,   345, 0,   0,   39,
		],
		[
			0,   0, 0,   0,   113, 0,   472, 0, 0,   0,   0,   0,
			0,   0, 0,   197, 0,   229, 246, 0, 0,   0,   0,   0,
			0,   0, 370, 0,   0,   0,   0,   0, 0,   0,   0,   0,
			0,   0, 334, 50,  0,   0,   0,   0, 0,   0,   0,   0,
			0,   0, 0,   0,   0,   0,   0,   0, 199, 0,   0,   0,
			0,   0, 205, 34,  0,   0,   0,   0, 0,   179, 0,   0,
			0,   0, 0,   0,   0,   0,   0,   0, 0,   0,   551, 280,
			230, 0, 456, 21,  0,   0,   437, 0, 0,   257,
		],
		[
			463, 0,   84,  0, 130, 0,  0,   0,   0,   0,   0,   0,
			0,   0,   518, 0, 326, 0,  372, 311, 0,   0,   0,   434,
			253, 0,   0,   0, 0,   0,  0,   0,   451, 413, 173, 42,
			0,   215, 0,   0, 180, 86, 0,   0,   0,   581, 325, 312,
			0,   0,   273, 0, 33,  0,  0,   0,   0,   0,   0,   0,
			0,   0,   0,   0, 271, 0,  0,   0,   0,   0,   269, 0,
			0,   0,   158, 0, 0,   0,  0,   0,   0,   0,   0,   0,
			0,   0,   0,   0, 231, 0,  0,   0,   0,   0,
		],
		[
			0,   3,   534, 0,   4,   578, 410, 0,   0,   0,   0,   0,
			0,   585, 0,   297, 0,   303, 70,  0,   0,   530, 346, 558,
			377, 0,   511, 0,   0,   0,   165, 0,   392, 302, 56,  10,
			391, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   393, 217, 11,  95,  0,   106, 0,   0,   8,   0,
			0,   161, 0,   0,   0,   0,   0,   0,   0,   0,   479, 0,
			536, 0,   0,   0,   459, 394, 0,   515, 329, 0,   0,   143,
			0,   249, 145, 403, 0,   0,   0,   0,   0,   0,
		],
		[
			0,   0,   0,   0,   0, 0,   0,   0,   0,   0,   544, 0,
			0,   504, 53,  483, 0, 0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0, 0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0, 0,   0,   522, 0,   490, 127, 290,
			0,   0,   0,   0,   0, 0,   0,   60,  514, 474, 268, 0,
			424, 396, 455, 164, 0, 32,  256, 0,   0,   508, 0,   365,
			379, 0,   0,   0,   0, 0,   0,   0,   0,   0,   0,   0,
			0,   409, 0,   488, 0, 323, 0,   171, 337, 0,
		],
		[
			0,   0,   174, 0,   0,   0, 0,   0,   0,   0,   0, 0,
			0,   193, 348, 282, 0,   0, 0,   376, 0,   0,   0, 565,
			328, 0,   236, 0,   0,   0, 0,   16,  0,   0,   0, 0,
			0,   0,   0,   0,   0,   0, 0,   0,   0,   547, 0, 464,
			0,   429, 26,  0,   0,   0, 0,   0,   0,   0,   0, 0,
			0,   0,   0,   0,   0,   0, 0,   0,   0,   0,   0, 0,
			0,   18,  0,   0,   138, 0, 0,   0,   501, 0,   0, 0,
			0,   0,   0,   0,   0,   0, 254, 281, 0,   0,
		],
		[
			310, 0,   0,   0,   0, 0, 0,   0, 67,  0,   0,   0,
			0,   0,   0,   0,   0, 0, 0,   0, 0,   0,   0,   0,
			0,   0,   0,   0,   0, 0, 0,   0, 0,   0,   0,   0,
			0,   0,   0,   0,   0, 0, 0,   0, 0,   0,   0,   0,
			0,   0,   157, 0,   0, 0, 0,   0, 0,   284, 0,   0,
			0,   0,   0,   0,   0, 0, 0,   0, 0,   0,   577, 0,
			0,   412, 0,   349, 0, 0, 285, 0, 0,   0,   543, 22,
			438, 178, 0,   0,   0, 0, 0,   0, 482, 381,
		],
		[
			0,   0,   0,   0,   0,   0,   0,   0,   0,  0,   0,   0,
			575, 442, 0,   0,   469, 0,   404, 0,   0,  0,   132, 151,
			0,   478, 0,   554, 0,   105, 0,   0,   0,  219, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   140, 0,  0,   0,   0,
			0,   559, 506, 0,   373, 0,   0,   0,   0,  2,   318, 0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,  0,   0,   20,
			0,   0,   0,   0,   0,   0,   0,   0,   0,  0,   0,   0,
			0,   566, 72,  354, 0,   340, 255, 0,   38, 0,
		],
		[
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   122,
			0,   0,   0,   0,   37,  0,   0,   80,  0,   0,   0,   0,
			0,   550, 0,   209, 172, 0,   121, 540, 0,   244, 584, 443,
			541, 0,   516, 0,   421, 339, 0,   94,  338, 299, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   176, 0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		],
		[
			0,  0,   0,   0,   0,   0,   0,   0,   0,  0, 0,   0,
			0,  0,   0,   0,   0,   378, 0,   0,   25, 0, 0,   186,
			0,  0,   0,   0,   0,   440, 187, 0,   0,  0, 0,   0,
			0,  582, 321, 517, 169, 466, 468, 0,   0,  0, 104, 192,
			0,  560, 0,   0,   317, 313, 87,  0,   0,  0, 0,   0,
			0,  0,   527, 513, 0,   0,   0,   0,   0,  0, 274, 0,
			44, 0,   0,   0,   0,   596, 298, 359, 0,  0, 457, 0,
			0,  263, 389, 526, 407, 593, 79,  0,   0,  0,
		],
		[
			594, 0,   0,   0,   0,   0,   0,   0,   503, 305, 0,   493,
			350, 0,   0,   48,  0,   0,   0,   0,   533, 0,   116, 0,
			561, 0,   0,   0,   0,   81,  0,   571, 6,   304, 277, 0,
			0,   0,   0,   0,   0,   166, 0,   0,   471, 0,   287, 0,
			0,   0,   0,   0,   322, 163, 0,   0,   0,   0,   0,   266,
			0,   0,   0,   0,   0,   0,   0,   574, 59,  0,   0,   0,
			0,   0,   509, 505, 241, 279, 374, 0,   0,   292, 0,   294,
			0,   184, 0,   528, 399, 0,   0,   0,   0,   123,
		],
		[
			0,  0,   0,   0,   0,   0,   502, 0,   31,  0,   0,   0,
			0,  0,   433, 262, 0,   112, 0,   0,   0,   0,   0,   548,
			0,  586, 592, 0,   461, 0,   0,   177, 0,   0,   0,   0,
			0,  0,   591, 0,   0,   0,   0,   600, 93,  512, 556, 108,
			0,  30,  387, 425, 0,   576, 0,   51,  0,   573, 475, 441,
			40, 0,   362, 0,   454, 314, 0,   0,   562, 0,   423, 0,
			0,  0,   0,   0,   0,   0,   62,  0,   0,   0,   0,   0,
			0,  0,   0,   0,   0,   496, 486, 557, 357, 0,
		],
		[
			418, 227, 0,   563, 0, 549, 0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0, 0,   0,   0,   0,   485, 242, 61,
			0,   0,   347, 0,   0, 524, 0,   0,   405, 0,   0,   0,
			0,   0,   0,   0,   0, 0,   139, 0,   0,   0,   0,   0,
			0,   397, 0,   0,   0, 567, 220, 238, 149, 0,   0,   0,
			0,   0,   444, 0,   0, 0,   115, 0,   0,   0,   0,   0,
			0,   0,   0,   0,   0, 100, 182, 0,   167, 118, 0,   0,
			211, 590, 452, 546, 0, 237, 0,   19,  398, 218,
		],
		[
			103, 0, 0,   0,   212, 296, 0,   0,   0, 0, 0, 0,
			0,   0, 0,   126, 0,   0,   0,   0,   0, 0, 0, 0,
			0,   0, 0,   0,   64,  0,   29,  0,   0, 0, 0, 0,
			0,   0, 0,   0,   0,   331, 0,   0,   0, 0, 0, 0,
			66,  0, 0,   0,   0,   0,   0,   0,   0, 0, 0, 0,
			0,   0, 0,   0,   0,   0,   0,   0,   0, 0, 0, 0,
			0,   0, 170, 0,   0,   73,  114, 0,   0, 0, 0, 0,
			0,   0, 467, 226, 0,   0,   251, 324, 0, 0,
		],
		[
			0,   248, 342, 210, 245, 0,   0,   0,  0,   0,   0, 0,
			0,   0,   0,   0,   0,   0,   449, 98, 369, 207, 0, 0,
			0,   0,   384, 401, 0,   0,   0,   0,  0,   0,   0, 0,
			0,   0,   0,   0,   0,   315, 0,   0,  0,   0,   0, 0,
			198, 0,   0,   0,   0,   525, 0,   0,  0,   0,   0, 0,
			0,   0,   416, 155, 0,   336, 0,   0,  0,   206, 0, 0,
			0,   0,   221, 0,   0,   0,   0,   0,  0,   0,   0, 0,
			0,   0,   0,   69,  0,   0,   0,   0,  0,   185,
		],
		[
			523, 90, 142, 0, 308, 0, 402, 134, 0, 49,  275, 0,
			0,   0,  154, 0, 0,   0, 0,   0,   0, 0,   0,   0,
			0,   0,  0,   0, 0,   0, 278, 0,   0, 0,   0,   445,
			0,   0,  0,   0, 74,  0, 0,   0,   0, 0,   0,   0,
			24,  0,  0,   0, 0,   0, 0,   0,   0, 188, 0,   0,
			0,   0,  0,   0, 0,   0, 0,   0,   0, 0,   0,   46,
			0,   0,  0,   0, 0,   0, 0,   0,   0, 0,   0,   0,
			0,   0,  0,   0, 0,   0, 0,   0,   0, 0,
		],
		[
			0,   0,  0,   0,   0, 0, 0,   0,   500, 0,   0,   0,
			0,   0,  0,   388, 0, 0, 0,   0,   0,   0,   0,   446,
			204, 99, 36,  0,   0, 0, 0,   0,   0,   352, 92,  0,
			0,   0,  0,   0,   0, 0, 0,   0,   521, 0,   0,   0,
			0,   0,  0,   0,   0, 0, 307, 0,   0,   428, 200, 0,
			0,   0,  0,   0,   0, 0, 0,   252, 0,   0,   0,   0,
			0,   0,  473, 0,   0, 0, 0,   71,  0,   0,   0,   0,
			261, 0,  0,   0,   0, 0, 0,   0,   0,   0,
		],
		[
			0, 0,   0,   0,   0,   0,   0, 0, 0, 0,   0,   0,
			0, 481, 265, 28,  0,   327, 0, 0, 0, 0,   0,   0,
			0, 0,   0,   160, 0,   0,   0, 0, 0, 0,   0,   489,
			0, 0,   316, 332, 0,   0,   0, 0, 0, 0,   0,   224,
			0, 0,   0,   0,   0,   0,   0, 0, 0, 0,   222, 0,
			0, 0,   0,   0,   0,   0,   0, 0, 0, 0,   0,   0,
			0, 0,   0,   0,   351, 43,  0, 0, 0, 136, 181, 0,
			0, 0,   309, 148, 0,   0,   0, 0, 0, 0,
		],
		[
			0,   0,   0,   0,   330, 0,   0,   0,   0,   0, 0,   0,
			0,   175, 0,   201, 0,   0,   85,  0,   0,   0, 0,   0,
			0,   0,   453, 0,   0,   0,   0,   0,   458, 0, 5,   0,
			0,   0,   390, 0,   0,   343, 0,   0,   0,   0, 598, 532,
			535, 97,  0,   408, 301, 0,   233, 406, 0,   0, 0,   0,
			0,   0,   0,   447, 0,   270, 239, 0,   0,   0, 0,   225,
			0,   0,   0,   23,  0,   0,   0,   0,   0,   0, 0,   135,
			129, 320, 0,   0,   191, 0,   0,   358, 0,   0,
		],
		[
			0,   0,   480, 196, 341, 0,   0,   0, 0,   0,  214, 0,
			531, 385, 335, 260, 0,   213, 0,   0, 0,   0,  0,   498,
			68,  0,   0,   0,   0,   0,   65,  0, 0,   0,  0,   400,
			0,   247, 1,   0,   0,   0,   0,   0, 0,   0,  0,   0,
			0,   0,   0,   0,   0,   0,   0,   0, 0,   0,  0,   0,
			0,   111, 0,   0,   0,   0,   0,   0, 232, 82, 162, 0,
			0,   76,  0,   0,   0,   0,   101, 0, 288, 0,  0,   0,
			0,   0,   519, 0,   0,   0,   259, 0, 0,   0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
	];
	$JPFreq = [
		[
			0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			231, 0, 0, 581, 0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,
			0,   0, 0, 0,   0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0,   568, 0,   598, 0,   587, 0,   561, 0,   483, 586, 592,
			559, 144, 577, 245, 567, 434, 580, 249, 557, 0,   579, 462,
			597, 353, 494, 0,   554, 0,   596, 589, 528, 0,   503, 566,
			62,  591, 590, 593, 565, 588, 595, 328, 243, 599, 594, 487,
			0,   136, 324, 0,   0,   412, 0,   439, 458, 0,   416, 0,
			0,   578, 508, 521, 571, 584, 21,  550, 0,   0,   0,   560,
			583, 572, 600, 585, 446, 0,   519, 0,   0,   0,   552, 0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		],
		[
			0,   547, 148, 544, 0,   345, 86,  292, 0,   293, 502, 96,
			358, 0,   525, 370, 120, 0,   413, 49,  366, 0,   492, 463,
			563, 10,  308, 0,   320, 0,   478, 258, 406, 0,   512, 145,
			0,   409, 297, 556, 491, 331, 340, 0,   179, 0,   80,  414,
			287, 0,   404, 147, 432, 333, 454, 0,   204, 6,   67,  180,
			186, 424, 274, 408, 443, 151, 257, 0,   318, 0,   137, 0,
			543, 523, 564, 445, 485, 0,   193, 0,   0,   0,   575, 0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0,   0,   0,   0,   0,   0,   0,   0,   0,  0,   0, 0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,  0,   0, 0,
			0,   0,   0,   0,   0,   0,   0,   0,   0,  378, 0, 0,
			0,   295, 0,   0,   0,   400, 0,   210, 0,  0,   0, 0,
			352, 0,   0,   0,   441, 0,   0,   0,   0,  0,   0, 12,
			0,   0,   0,   0,   0,   0,   157, 0,   63, 187, 0, 79,
			118, 0,   0,   558, 0,   0,   0,   0,   0,  0,   0, 0,
			0,   0,   511, 0,   0,   303, 0,   0,   0,  0,
		],
		[
			388, 0,   0,   0, 0, 0, 0,   0, 0, 0, 0,   0,
			0,   0,   0,   0, 0, 0, 0,   0, 0, 0, 0,   0,
			0,   0,   0,   0, 0, 0, 254, 0, 0, 0, 0,   183,
			0,   0,   71,  0, 0, 0, 0,   0, 0, 0, 0,   0,
			36,  119, 0,   0, 0, 0, 0,   0, 0, 0, 0,   0,
			0,   0,   476, 0, 0, 0, 0,   0, 0, 0, 173, 0,
			228, 0,   0,   0, 0, 0, 0,   0, 0, 0, 0,   0,
			0,   0,   0,   0, 0, 0, 0,   0, 0, 227,
		],
		[
			0, 0, 0, 44,  0,   0, 0,  0,   0,   0,   0,   58,
			0, 0, 0, 39,  0,   0, 0,  0,   0,   0,   0,   0,
			0, 0, 0, 459, 467, 0, 99, 0,   256, 0,   396, 171,
			0, 0, 0, 429, 0,   0, 0,  237, 0,   0,   0,   0,
			0, 0, 0, 0,   0,   0, 0,  0,   0,   0,   0,   0,
			5, 0, 0, 0,   203, 0, 0,  0,   0,   0,   0,   317,
			0, 0, 0, 0,   0,   0, 0,  0,   574, 337, 499, 0,
			0, 0, 0, 0,   0,   0, 0,  0,   0,   371,
		],
		[
			0, 0,   0, 322, 0,  376, 0,   0,   0, 0,   490, 0,
			0, 0,   0, 464, 0,  130, 0,   0,   0, 0,   0,   0,
			0, 0,   0, 0,   0,  0,   0,   0,   0, 0,   0,   0,
			0, 250, 0, 0,   0,  220, 0,   0,   0, 241, 0,   0,
			0, 0,   0, 0,   31, 0,   244, 496, 0, 128, 78,  0,
			0, 0,   0, 0,   0,  0,   0,   167, 0, 0,   0,   344,
			0, 0,   0, 0,   0,  0,   0,   0,   0, 0,   0,   40,
			0, 0,   0, 0,   0,  0,   0,   0,   0, 0,
		],
		[
			0,  0,  0,   0, 0,   0,   0,  0,   0, 0,   0,  0,
			0,  0,  0,   0, 363, 0,   0,  111, 0, 280, 0,  0,
			0,  0,  0,   0, 0,   0,   0,  0,   0, 0,   0,  64,
			0,  74, 0,   0, 0,   0,   0,  0,   0, 0,   0,  0,
			28, 0,  0,   0, 0,   527, 0,  479, 0, 13,  81, 0,
			0,  0,  0,   0, 0,   0,   0,  0,   0, 0,   0,  0,
			0,  0,  230, 0, 0,   0,   57, 259, 0, 0,   0,  0,
			0,  0,  0,   0, 0,   0,   0,  423, 0, 0,
		],
		[
			420, 0,   0,   436, 0,   0,  0,   0, 0,   0,   0,   140,
			377, 0,   132, 0,   0,   0,  0,   0, 0,   0,   0,   0,
			0,   0,   69,  0,   0,   0,  198, 0, 214, 0,   0,   536,
			0,   0,   0,   0,   0,   0,  0,   0, 0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,  0,   0, 0,   0,   0,   135,
			0,   185, 0,   0,   278, 0,  0,   0, 189, 122, 0,   0,
			0,   0,   0,   0,   0,   41, 0,   0, 0,   0,   312, 0,
			0,   0,   0,   0,   0,   0,  0,   0, 0,   465,
		],
		[
			172, 0, 0,   0,   0,   364, 0, 410, 0,   0, 0, 0,
			134, 0, 418, 0,   0,   0,   0, 0,   369, 0, 0, 0,
			0,   0, 0,   0,   0,   0,   0, 0,   0,   0, 0, 0,
			0,   0, 0,   517, 285, 0,   9, 0,   0,   0, 0, 0,
			0,   0, 0,   0,   0,   0,   0, 0,   0,   0, 0, 0,
			0,   0, 0,   0,   319, 506, 0, 170, 0,   0, 0, 399,
			0,   0, 0,   0,   0,   0,   0, 0,   0,   0, 0, 0,
			197, 0, 0,   0,   0,   0,   0, 0,   0,   0,
		],
		[
			0, 0, 0,   0, 0, 0,   0,   0, 0,   0, 0, 0,
			0, 0, 0,   0, 0, 0,   323, 0, 0,   0, 0, 276,
			0, 0, 0,   0, 0, 0,   0,   0, 90,  0, 0, 0,
			0, 0, 0,   0, 0, 50,  0,   0, 0,   0, 0, 452,
			0, 0, 0,   0, 0, 0,   282, 0, 108, 0, 0, 0,
			0, 0, 0,   0, 0, 3,   0,   0, 0,   0, 0, 472,
			0, 0, 354, 0, 0, 539, 296, 0, 0,   0, 0, 0,
			0, 0, 0,   0, 0, 209, 0,   0, 0,   0,
		],
		[
			202, 402, 0, 0,   0,   164, 0,  0,   389, 0,   522, 0,
			0,   0,   0, 0,   0,   0,   88, 0,   329, 368, 0,   0,
			0,   235, 0, 0,   450, 0,   0,  456, 0,   112, 0,   8,
			0,   0,   0, 0,   0,   0,   0,  0,   0,   0,   0,   0,
			0,   0,   0, 0,   0,   0,   0,  0,   0,   0,   0,   0,
			0,   38,  0, 0,   362, 0,   0,  0,   530, 0,   0,   0,
			0,   0,   0, 233, 0,   146, 0,  0,   0,   341, 0,   0,
			0,   0,   0, 419, 0,   0,   0,  0,   232, 338,
		],
		[
			0,   0, 0,   0,   47,  0,   0, 0,   225, 0, 0,   0,
			239, 0, 0,   0,   0,   0,   0, 0,   0,   0, 0,   0,
			0,   0, 252, 0,   166, 0,   0, 0,   0,   0, 0,   0,
			0,   0, 0,   0,   0,   0,   0, 0,   307, 0, 0,   0,
			0,   0, 0,   542, 0,   0,   0, 0,   0,   0, 0,   0,
			0,   0, 0,   0,   0,   486, 0, 0,   0,   0, 534, 0,
			0,   0, 0,   0,   0,   0,   0, 327, 576, 0, 0,   0,
			0,   0, 0,   0,   0,   0,   0, 0,   0,   302,
		],
		[
			0,   0,   495, 0, 0, 0,   0, 0, 0, 0,   0,   0,
			0,   0,   0,   0, 0, 0,   0, 4, 0, 0,   0,   0,
			20,  336, 0,   0, 0, 0,   0, 0, 0, 0,   0,   0,
			0,   200, 457, 0, 0, 0,   0, 0, 0, 0,   0,   224,
			349, 0,   0,   0, 0, 0,   0, 0, 0, 0,   206, 0,
			330, 0,   288, 0, 0, 0,   0, 0, 0, 0,   0,   0,
			0,   0,   0,   0, 0, 442, 0, 0, 0, 275, 0,   0,
			0,   294, 0,   0, 0, 0,   0, 0, 0, 0,
		],
		[
			0,  0,   0,   0,   0,   0,   0,   0,   0,   0,  0,   0,
			0,  0,   0,   395, 0,   298, 415, 0,   0,   0,  0,   0,
			0,  394, 143, 0,   0,   0,   0,   0,   0,   0,  0,   117,
			27, 0,   0,   283, 0,   0,   0,   0,   0,   77, 253, 0,
			23, 488, 0,   504, 0,   0,   386, 365, 359, 0,  0,   162,
			0,  0,   219, 277, 461, 0,   0,   255, 0,   0,  0,   0,
			0,  0,   127, 0,   0,   91,  0,   0,   346, 0,  0,   0,
			0,  546, 0,   0,   0,   0,   0,   0,   411, 548,
		],
		[
			316, 0,   430, 0,   0, 0,   0,  266, 0,   0,   538, 0,
			0,   0,   0,   262, 0, 0,   0,  0,   0,   0,   0,   0,
			0,   26,  0,   0,   0, 0,   0,  0,   105, 477, 0,   0,
			0,   0,   0,   0,   0, 0,   0,  19,  0,   0,   0,   0,
			0,   540, 0,   541, 0, 291, 0,  0,   0,   0,   0,   0,
			0,   0,   0,   0,   0, 0,   1,  0,   0,   0,   473, 433,
			16,  497, 0,   0,   0, 0,   18, 0,   0,   0,   437, 0,
			390, 0,   0,   0,   0, 0,   0,  0,   149, 0,
		],
		[
			0,   0,   161, 0,  0,   0, 0, 0, 0,   236, 0, 0,
			0,   0,   0,   22, 0,   0, 0, 0, 0,   0,   0, 299,
			0,   0,   223, 0,  286, 0, 0, 0, 0,   0,   0, 0,
			332, 0,   0,   0,  0,   0, 0, 0, 0,   0,   0, 551,
			155, 93,  0,   0,  0,   0, 0, 0, 0,   0,   0, 0,
			0,   0,   0,   55, 0,   0, 0, 0, 0,   0,   0, 0,
			367, 405, 0,   0,  0,   0, 0, 0, 387, 0,   0, 0,
			92,  0,   375, 0,  0,   0, 0, 0, 0,   0,
		],
		[
			343, 0,   0,   0,   0, 83,  0,   0,   0,   0,   0,   0,
			0,   417, 196, 0,   0, 0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0, 11,  0,   0,   0,   0,   153, 0,
			0,   0,   0,   0,   0, 326, 0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0, 0,   0,   0,   0,   211, 0,   0,
			97,  54,  0,   0,   0, 0,   0,   0,   537, 0,   0,   102,
			0,   0,   0,   505, 0, 0,   192, 271, 0,   123, 0,   0,
			191, 0,   0,   0,   0, 0,   0,   0,   0,   0,
		],
		[
			0, 0,   0, 0,   0, 195, 0,   0,   177, 0, 0,   0,
			0, 314, 0, 0,   0, 0,   65,  374, 0,   0, 501, 0,
			0, 0,   0, 0,   0, 0,   205, 150, 0,   0, 0,   0,
			0, 68,  0, 188, 0, 382, 0,   0,   573, 0, 0,   0,
			0, 0,   0, 0,   0, 0,   0,   0,   0,   0, 0,   0,
			0, 0,   0, 0,   0, 0,   0,   0,   304, 0, 0,   0,
			0, 0,   0, 0,   0, 0,   0,   0,   0,   0, 0,   325,
			0, 0,   0, 0,   0, 0,   0,   0,   0,   0,
		],
		[
			0,   0,   0,   392, 0,  0,   0,   0, 428, 247, 0, 0,
			447, 422, 545, 0,   0,  0,   0,   0, 384, 0,   0, 532,
			0,   0,   0,   107, 46, 242, 0,   0, 0,   0,   0, 0,
			0,   0,   260, 0,   0,  110, 0,   0, 0,   0,   0, 174,
			0,   0,   0,   0,   0,  0,   0,   0, 0,   269, 0, 0,
			0,   0,   383, 0,   0,  163, 0,   0, 0,   0,   0, 348,
			0,   0,   0,   0,   0,  393, 470, 0, 0,   0,   0, 0,
			0,   0,   0,   0,   0,  0,   0,   0, 0,   175,
		],
		[
			0, 0,   0,   0,   0,   0,  0,   0,   0,   489, 0,   0,
			0, 0,   116, 529, 0,   0,  106, 468, 0,   0,   0,   0,
			0, 0,   0,   0,   0,   0,  0,   0,   0,   0,   0,   0,
			0, 0,   0,   356, 0,   48, 0,   0,   0,   0,   0,   0,
			0, 0,   0,   0,   0,   0,  0,   0,   0,   0,   101, 0,
			0, 0,   0,   0,   87,  0,  0,   0,   0,   0,   0,   221,
			0, 507, 0,   0,   397, 0,  0,   0,   0,   0,   0,   0,
			0, 0,   190, 0,   0,   0,  0,   0,   268, 0,
		],
		[
			0,   7,   0,   53,  0, 281, 0,   0,   0,   0,   0,   0,
			152, 0,   0,   0,   0, 89,  385, 0,   0,   0,   0,   0,
			0,   0,   0,   261, 0, 0,   381, 0,   0,   0,   0,   0,
			0,   0,   311, 0,   0, 0,   0,   0,   0,   471, 0,   518,
			0,   0,   0,   85,  0, 133, 0,   0,   0,   0,   0,   0,
			0,   0,   0,   51,  0, 73,  0,   0,   481, 248, 569, 357,
			0,   440, 0,   0,   0, 0,   0,   114, 0,   0,   0,   208,
			0,   0,   0,   0,   0, 0,   0,   0,   0,   0,
		],
		[
			0, 0, 0,   0, 0, 0,   0,   0,   0,   0,   75,  0,
			0, 0, 0,   0, 0, 0,   0,   42,  0,   0,   0,   0,
			0, 0, 0,   0, 0, 0,   0,   0,   0,   0,   0,   334,
			0, 0, 156, 0, 0, 0,   263, 213, 0,   309, 516, 0,
			0, 0, 0,   0, 0, 215, 0,   0,   0,   0,   0,   0,
			0, 0, 0,   0, 0, 0,   0,   0,   124, 555, 0,   0,
			0, 0, 0,   0, 0, 0,   0,   0,   0,   0,   0,   0,
			0, 0, 0,   0, 0, 0,   0,   0,   0,   0,
		],
		[
			0,   0,   126, 0, 113, 0,   0,  0,   0, 0, 251, 0,
			0,   199, 0,   0, 0,   0,   0,  453, 0, 0, 0,   0,
			553, 0,   0,   0, 0,   265, 0,  0,   0, 0, 0,   0,
			0,   0,   0,   0, 61,  0,   0,  455, 0, 0, 0,   0,
			0,   0,   0,   0, 0,   0,   0,  0,   0, 0, 0,   0,
			0,   0,   0,   0, 0,   0,   30, 0,   0, 0, 0,   0,
			0,   500, 0,   0, 0,   0,   0,  0,   0, 0, 238, 0,
			0,   0,   0,   0, 0,   0,   0,  0,   0, 0,
		],
		[
			0,   0,   0, 0,   0, 0,   0, 0,   0,   524, 0,   0,
			0,   0,   0, 0,   0, 0,   0, 0,   0,   0,   0,   129,
			165, 0,   0, 0,   0, 168, 0, 372, 60,  0,   0,   475,
			267, 0,   0, 0,   0, 0,   0, 0,   0,   0,   70,  0,
			0,   0,   0, 407, 0, 0,   0, 0,   444, 182, 0,   0,
			0,   533, 0, 0,   0, 0,   0, 0,   0,   0,   313, 0,
			0,   284, 0, 515, 0, 0,   0, 0,   0,   0,   0,   0,
			0,   448, 0, 0,   0, 0,   0, 0,   401, 0,
		],
		[
			0, 0, 194, 0,   0,   0,   0,   0,   0,   0, 0,   56,
			0, 0, 59,  474, 549, 0,   131, 0,   0,   0, 0,   0,
			0, 0, 360, 0,   0,   0,   0,   273, 0,   0, 264, 0,
			0, 0, 0,   104, 0,   0,   0,   0,   0,   0, 0,   0,
			0, 0, 0,   0,   0,   0,   0,   0,   0,   0, 0,   0,
			0, 0, 0,   0,   0,   509, 0,   0,   0,   0, 0,   0,
			0, 0, 0,   0,   0,   154, 0,   0,   158, 0, 379, 0,
			0, 0, 0,   0,   0,   0,   0,   582, 0,   513,
		],
		[
			0, 0, 0,   300, 0,   0, 305, 0,   0, 0, 0,   0,
			0, 0, 570, 98,  0,   0, 0,   0,   0, 0, 0,   0,
			0, 0, 0,   0,   240, 0, 0,   95,  0, 0, 0,   0,
			0, 0, 0,   0,   355, 0, 0,   0,   0, 0, 0,   0,
			0, 0, 0,   0,   0,   0, 0,   0,   0, 0, 125, 0,
			0, 0, 0,   0,   0,   0, 0,   306, 0, 0, 0,   0,
			0, 0, 0,   0,   0,   0, 0,   0,   0, 0, 0,   0,
			0, 0, 0,   0,   0,   0, 0,   0,   0, 0,
		],
		[
			0, 0, 0,   0, 0,   0,   0,   0, 0,   0,   0, 0,
			0, 0, 520, 0, 0,   0,   0,   0, 0,   0,   0, 0,
			0, 0, 0,   0, 315, 290, 321, 0, 0,   0,   0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0,   0,   0, 0,
			0, 0, 0,   0, 0,   141, 0,   0, 0,   0,   0, 0,
			0, 0, 0,   0, 0,   0,   0,   0, 0,   160, 0, 0,
			0, 0, 0,   0, 0,   0,   35,  0, 181, 0,   0, 0,
			0, 0, 121, 0, 0,   0,   0,   0, 0,   29,
		],
		[
			0,  0, 0, 0,   0,   0,   0,   0,  0, 0,   0, 217,
			0,  0, 0, 0,   0,   0,   0,   0,  0, 0,   0, 0,
			0,  0, 0, 37,  466, 15,  0,   0,  0, 139, 0, 0,
			0,  0, 0, 0,   0,   301, 0,   0,  0, 0,   0, 0,
			0,  0, 0, 435, 272, 0,   178, 0,  0, 0,   0, 361,
			0,  0, 0, 0,   0,   0,   0,   0,  0, 0,   0, 0,
			32, 0, 0, 0,   0,   0,   0,   94, 0, 0,   0, 526,
			0,  0, 0, 0,   0,   0,   115, 33, 0, 0,
		],
		[
			14,  0,   0, 0, 0,  0,  0,   0,   0,   350, 0,   535,
			0,   0,   0, 0, 0,  0,  0,   0,   0,   0,   0,   335,
			218, 0,   0, 0, 0,  0,  398, 0,   0,   0,   0,   0,
			0,   482, 0, 0, 0,  0,  0,   289, 0,   0,   0,   0,
			270, 0,   0, 0, 52, 34, 0,   0,   0,   0,   0,   0,
			403, 0,   0, 0, 0,  0,  0,   184, 0,   0,   0,   0,
			0,   0,   0, 0, 0,  0,  0,   0,   0,   0,   351, 0,
			0,   0,   0, 0, 0,  0,  0,   212, 514, 0,
		],
		[
			451, 0,  0, 0, 0,   0, 0, 0,   0, 0, 0, 103,
			0,   0,  0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0,   0,  0, 0, 0,   2, 0, 0,   0, 0, 0, 0,
			0,   0,  0, 0, 159, 0, 0, 373, 0, 0, 0, 0,
			0,   0,  0, 0, 0,   0, 0, 0,   0, 0, 0, 562,
			0,   0,  0, 0, 0,   0, 0, 0,   0, 0, 0, 25,
			0,   0,  0, 0, 0,   0, 0, 0,   0, 0, 0, 0,
			0,   24, 0, 0, 0,   0, 0, 0,   0, 0,
		],
		[
			0, 0, 66, 0, 0,   0,   0,   0,   0,   0,   0,   0,
			0, 0, 0,  0, 531, 0,   426, 0,   207, 0,   0,   0,
			0, 0, 0,  0, 0,   347, 45,  480, 0,   0,   0,   0,
			0, 0, 0,  0, 0,   0,   0,   342, 0,   0,   0,   0,
			0, 0, 0,  0, 0,   0,   0,   0,   0,   216, 0,   469,
			0, 0, 0,  0, 0,   0,   0,   484, 0,   0,   43,  0,
			0, 0, 0,  0, 0,   425, 0,   0,   0,   222, 438, 0,
			0, 0, 0,  0, 0,   0,   0,   0,   0,   0,
		],
		[
			0,   109, 0, 0,   142, 0,  0,   0, 0,   0, 0, 0,
			201, 0,   0, 0,   0,   0,  169, 0, 0,   0, 0, 0,
			0,   0,   0, 0,   339, 0,  176, 0, 0,   0, 0, 0,
			0,   234, 0, 0,   0,   0,  0,   0, 0,   0, 0, 0,
			431, 0,   0, 0,   72,  0,  427, 0, 0,   0, 0, 0,
			0,   0,   0, 0,   0,   0,  0,   0, 0,   0, 0, 421,
			0,   0,   0, 0,   0,   84, 0,   0, 0,   0, 0, 0,
			0,   0,   0, 310, 0,   0,  0,   0, 460, 0,
		],
		[
			0, 0,   0, 0, 0, 0,   0,  138, 498, 0,   0,   0,
			0, 226, 0, 0, 0, 0,   0,  0,   0,   0,   0,   0,
			0, 0,   0, 0, 0, 246, 0,  0,   229, 0,   0,   0,
			0, 0,   0, 0, 0, 0,   0,  17,  0,   380, 493, 0,
			0, 0,   0, 0, 0, 0,   0,  0,   0,   0,   0,   0,
			0, 0,   0, 0, 0, 0,   76, 0,   0,   0,   0,   0,
			0, 0,   0, 0, 0, 0,   0,  0,   0,   0,   0,   0,
			0, 0,   0, 0, 0, 0,   0,  0,   0,   0,
		],
		[
			0, 510, 0, 0, 0, 0, 0, 0,   0, 0,   100, 0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,   0,
			0, 82,  0, 0, 0, 0, 0, 279, 0, 449, 391, 0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,   0,   0,
			0, 0,   0, 0, 0, 0, 0, 0,   0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
		[
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		],
	];
}

#===release
#===detect($bin,$max_len,$is_consider_web_charset)
sub detect {
	if ( !defined( $_[0] ) ) {
		return '';
	}
	my $len     = length $_[0];
	my $bin_ful = \$_[0];
	my $bin     = ( defined( $_[1] ) and $len > $_[1] )? \substr( $_[0], 0, $_[1] ):\$_[0];
	my $use_det2 = (defined( $_[2] ) and !$_[2])?'':1;
	
	my $det1 = get_det1($bin);
	
	if(!$use_det2){
		return filter_ascii( $_encoding_reverse->{$det1} );
	}
	
	if ( in_safe_list($det1) ) {
		return filter_ascii( $_encoding_reverse->{$det1} );
	}
	else {
		my $det2 = get_det2($bin_ful);
		if ( defined($det2) ) {
			return filter_ascii($det2);
		}
		else {
			return filter_ascii( $_encoding_reverse->{$det1} );
		}
	}
}

sub get_det1 {
	my $j  = 0;
	my $k  = 99;
	my $ai = [ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ];    #11, pos 0 for useless
	if ( ${ $_[0] } eq '' ) {
		return 99;
	}
	my @bytes = unpack( 'c*', ${ $_[0] } );
	my $bytes = \@bytes;

	#put that maybe 100 before than other
	if ( ( $ai->[ $_encoding->{'utf8'} ] = utf8_probability($bytes) ) == 100 ) {
		return $_encoding->{'utf8'};
	}
	if (
		(
			$ai->[ $_encoding->{'iso-2022-jp'} ] =
			iso_2022_jp_probability($bytes)
		) == 100
	  )
	{
		return $_encoding->{'iso-2022-jp'};
	}
	if (
		(
			$ai->[ $_encoding->{'iso-2022-kr'} ] =
			iso_2022_kr_probability($bytes)
		) == 100
	  )
	{
		return $_encoding->{'iso-2022-kr'};
	}
	if ( ( $ai->[ $_encoding->{'utf16'} ] = utf16_probability($bytes) ) == 100 )
	{
		return $_encoding->{'utf16'};
	}
	if ( ( $ai->[ $_encoding->{'ascii'} ] = ascii_probability($bytes) ) == 100 )
	{
		return $_encoding->{'ascii'};
	}
	if ( ( $ai->[ $_encoding->{'cp936'} ] = gbk_probability($bytes) ) == 100 ) {
		return $_encoding->{'cp936'};
	}
	if ( ( $ai->[ $_encoding->{'big5-eten'} ] = big5_probability($bytes) ) ==
		100 )
	{
		return $_encoding->{'big5-eten'};
	}
	if ( ( $ai->[ $_encoding->{'euc-jp'} ] = euc_jp_probability($bytes) ) ==
		100 )
	{
		return $_encoding->{'euc-jp'};
	}
	if ( ( $ai->[ $_encoding->{'shiftjis'} ] = sjis_probability($bytes) ) ==
		100 )
	{
		return $_encoding->{'shiftjis'};
	}
	if ( ( $ai->[ $_encoding->{'euc-kr'} ] = euc_kr_probability($bytes) ) ==
		100 )
	{
		return $_encoding->{'euc-kr'};
	}

	for ( my $i = 0 ; $i < scalar(@$ai) ; $i++ ) {
		if ( $ai->[$i] > $j ) {
			$k = $i;
			$j = $ai->[$i];
		}
	}
	if ( $j <= 50 ) { $k = 99; }
	return $k;
}

sub get_det2 {
	if ( ${ $_[0] } =~ /charset\s*=\s*([A-Za-z0-9\-\_]+)/i ) {
		my $charset = resolve_alias($1);
		if ( ( $charset eq '' ) || ( $charset eq 'iso-8859-1' ) ) {
			return undef;
		}
		else {
			return filter_charset($charset);
		}
	}
	else {
		return undef;
	}
}

#=========================================================

#===debug
sub detect_debug {
	$log_txt = "=============================================\n";
	if ( !defined( $_[0] ) ) {
		$log_txt .= "input binary is not defined, so exit and return ''\n";
		return '';
	}
	my $len = length $_[0];
	$log_txt .= "input binary length is $len\n";
	my $bin_ful = \$_[0];
	my $bin     =
	  ( defined( $_[1] ) and $len > $_[1] )
	  ? \substr( $_[0], 0, $_[1] )
	  : \$_[0];
	$log_txt .= "input binary length was trim to size " . length($$bin) . "\n";
	$log_txt .= "=============================================\n";
	my $det1 = get_det1_debug($bin);

	if ( in_safe_list($det1) ) {
		$log_txt .= "DET1 in safe list, so skip DET2\n";
		$log_txt .= "=============================================\n";
		get_det2_debug( $bin_ful, "skiped" );
		$log_txt .= "=============================================\n";
		$log_txt .= "DET :use det1\n";
		$log_txt .=
		  "DET :final " . filter_ascii( $_encoding_reverse->{$det1} ) . "\n";
		return filter_ascii( $_encoding_reverse->{$det1} );
	}
	else {
		$log_txt .= "=============================================\n";
		my $det2 = get_det2_debug( $bin_ful, "start" );
		if ( defined($det2) ) {
			$log_txt .= "=============================================\n";
			$log_txt .= "DET :use det2\n";
			$log_txt .= "DET :final " . filter_ascii($det2) . "\n";
			return filter_ascii($det2);
		}
		else {
			$log_txt .= "=============================================\n";
			$log_txt .= "DET :use det1\n";
			$log_txt .=
			  "DET :final" . filter_ascii( $_encoding_reverse->{$det1} ) . "\n";
			return filter_ascii( $_encoding_reverse->{$det1} );
		}
	}
}

sub get_det1_debug {
	my $j  = 0;
	my $k  = 99;
	my $ai = [ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ];    #11, pos 0 for useless

	my @bytes = unpack( 'c*', ${ $_[0] } );
	my $bytes = \@bytes;

	my $skip = "";
	my $num;
	$log_txt .= "DET1: start\n";

	$num = ( $ai->[ $_encoding->{'utf8'} ] = utf8_probability($bytes) );
	$log_txt .= "    utf8" . ( $skip ? "(skiped)" : "" ) . ": $num\n";
	if ( $num == 100 ) { $skip = 1; }

	$num =
	  ( $ai->[ $_encoding->{'iso-2022-jp'} ] =
		  iso_2022_jp_probability($bytes) );
	$log_txt .= "    iso-2022-jp" . ( $skip ? "(skiped)" : "" ) . ": $num\n";
	if ( $num == 100 ) { $skip = 1; }

	if ( $num == 100 ) { $skip = 1; }
	$num =
	  ( $ai->[ $_encoding->{'iso-2022-kr'} ] =
		  iso_2022_kr_probability($bytes) );
	$log_txt .= "    iso-2022-kr" . ( $skip ? "(skiped)" : "" ) . ": $num\n";
	if ( $num == 100 ) { $skip = 1; }

	$num = ( $ai->[ $_encoding->{'utf16'} ] = utf16_probability($bytes) );
	$log_txt .= "    utf16" . ( $skip ? "(skiped)" : "" ) . ": $num\n";
	if ( $num == 100 ) { $skip = 1; }

	$num = ( $ai->[ $_encoding->{'ascii'} ] = ascii_probability($bytes) );
	$log_txt .= "    ascii" . ( $skip ? "(skiped)" : "" ) . ": $num\n";
	if ( $num == 100 ) { $skip = 1; }

	$num = ( $ai->[ $_encoding->{'cp936'} ] = gbk_probability($bytes) );
	$log_txt .= "    cp936" . ( $skip ? "(skiped)" : "" ) . ": $num\n";
	if ( $num == 100 ) { $skip = 1; }

	$num = ( $ai->[ $_encoding->{'big5-eten'} ] = big5_probability($bytes) );
	$log_txt .= "    big5-eten" . ( $skip ? "(skiped)" : "" ) . ": $num\n";
	if ( $num == 100 ) { $skip = 1; }

	$num = ( $ai->[ $_encoding->{'euc-jp'} ] = euc_jp_probability($bytes) );
	$log_txt .= "    euc-jp" . ( $skip ? "(skiped)" : "" ) . ": $num\n";
	if ( $num == 100 ) { $skip = 1; }

	$num = ( $ai->[ $_encoding->{'shiftjis'} ] = sjis_probability($bytes) );
	$log_txt .= "    shiftjis" . ( $skip ? "(skiped)" : "" ) . ": $num\n";
	if ( $num == 100 ) { $skip = 1; }

	$num = ( $ai->[ $_encoding->{'euc-kr'} ] = euc_kr_probability($bytes) );
	$log_txt .= "    euc-kr" . ( $skip ? "(skiped)" : "" ) . ": $num\n";

	for ( my $i = 0 ; $i < scalar(@$ai) ; $i++ ) {
		if ( $ai->[$i] > $j ) {
			$k = $i;
			$j = $ai->[$i];
		}
	}
	if ( $j <= 50 ) { $k = 99; }
	$log_txt .= "DET1: result " . $_encoding_reverse->{$k} . "\n";
	return $k;
}

sub get_det2_debug {
	$log_txt .= "DET2: $_[1]\n";
	if ( ${ $_[0] } =~ /charset\s*=\s*([A-Za-z0-9\-\_]+)/i ) {
		$log_txt .= "DET2: html encode found $1\n";
		my $charset = resolve_alias($1);
		if ( ( $charset eq '' ) || ( $charset eq 'iso-8859-1' ) ) {
			$log_txt .=
"DET2: cannot resove encode name or encode name is iso-8859-1, so return undef\n";
			return undef;
		}
		else {
			$log_txt .= "DET2: use alias $charset\n";
			$log_txt .= "DET2: result " . filter_charset($charset) . "\n";
			return filter_charset($charset);
		}
	}
	else {
		$log_txt .= "DET2: html encode not found so return undef \n";
		return undef;
	}
}

#=========================================================

#if in safe list,  is trustable
sub in_safe_list {
	if (   $_[0] == $_encoding->{'utf8'}
		|| $_[0] == $_encoding->{'cp936'}
		|| $_[0] == $_encoding->{'shiftjis'}
		|| $_[0] == $_encoding->{'euc-jp'}
		|| $_[0] == $_encoding->{'utf16'} )
	{
		return 1;
	}
	else {
		return '';
	}
}

#cheat gb2312 gbk gb18030 as gbk
sub filter_charset {
	if ( 'euc-cn' eq $_[0] ) {
		return 'cp936';
	}
	elsif ( 'gb18030' eq $_[0] ) {
		return 'cp936';
	}
	elsif ( 'utf-8-strict' eq $_[0] ) {
		return 'utf8';
	}
	else {
		return $_[0];
	}
}

#because encode cannot resolve gb18030 by default, so do this
sub resolve_alias {
	if ( $_[0] =~ /gb18030/i ) {
		return 'gb18030';
	}
	else {
		my $rtn = Encode::resolve_alias( $_[0] );
		return $rtn ? $rtn : "";
	}
}

#upgrade charset
sub filter_ascii {
	if ( 'ascii' eq $_[0] ) {
		return 'iso-8859-1';
	}
	else {
		return $_[0];
	}
}

sub ascii_probability {
	my $bytes = shift;
	my $i     = 75;
	my $k     = scalar(@$bytes);
	for ( my $j = 0 ; $j < $k ; $j++ ) {
		if ( $bytes->[$j] < 0 ) {
			$i -= 5;
		}
		elsif ( $bytes->[$j] == 27 ) {
			$i -= 5;
		}
		else {

		}
		if ( $i <= 0 ) {
			return 0;
		}
	}
	return $i;
}

sub utf8_probability {
	my $bytes = shift;
	my $i     = 0;
	my $k     = 0;
	my $l     = 0;
	my $i1    = 0;
	$k = scalar(@$bytes);
	for ( my $j = 0 ; $j < $k ; $j++ ) {
		if ( $bytes->[$j] >= 0 && $bytes->[$j] < 128 ) {
			$i1++;
			next;
		}
		if (   -64 <= $bytes->[$j]
			&& $bytes->[$j] <= -33
			&& $j + 1 < $k
			&& -128 <= $bytes->[ $j + 1 ]
			&& $bytes->[ $j + 1 ] <= -65 )
		{
			$l += 2;
			$j++;
			next;
		}
		if (   -32 <= $bytes->[$j]
			&& $bytes->[$j] <= -17
			&& $j + 2 < $k
			&& -128 <= $bytes->[ $j + 1 ]
			&& $bytes->[ $j + 1 ] <= -65
			&& -128 <= $bytes->[ $j + 2 ]
			&& $bytes->[ $j + 2 ] <= -65 )
		{
			$l += 3;
			$j += 2;
		}
	}

	if ( $i1 == $k ) {
		return 0;
	}

	$i = int( 100 * $l / ( $k - $i1 ) );
	if ( $i > 98 ) {
		return $i;
	}

	if ( $i > 95 && $l > 30 ) {
		return $i;
	}
	else {
		return 0;
	}
}

sub utf16_probability {
	my $bytes = shift;
	return ( scalar(@$bytes) <= 1 || -2 != $bytes->[0] || -1 != $bytes->[1] )
	  && ( -1 != $bytes->[0] || -2 != $bytes->[1] ) ? 0 : 100;
}

sub gbk_probability {
	my $bytes = shift;
	my $j     = 0;
	my $k     = 1;
	my $l     = 1;
	my $l1    = 0;
	my $l2    = 1;
	my $f     = 0.0;
	my $f1    = 0.0;
	$j = scalar(@$bytes);

	for ( my $i = 0 ; $i < $j - 1 ; $i++ ) {
		if ( $bytes->[$i] >= 0 ) {
			next;
		}
		$k++;
		if (   -95 <= $bytes->[$i]
			&& $bytes->[$i] <= -9
			&& -95 <= $bytes->[ $i + 1 ]
			&& $bytes->[ $i + 1 ] <= -2 )
		{
			$l++;
			$l2 += 500;
			my $i1 = ( $bytes->[$i] + 256 ) - 161;
			my $k1 = ( $bytes->[ $i + 1 ] + 256 ) - 161;

			if ( $GBFreq->[$i1]->[$k1] != 0 ) {
				$l1 += $GBFreq->[$i1]->[$k1];
			}
			elsif ( 15 <= $i1 && $i1 < 55 ) {
				$l1 += 200;
			}
			else {
			}
		}
		elsif (
			   -127 <= $bytes->[$i]
			&& $bytes->[$i] <= -2
			&& (   -128 <= $bytes->[ $i + 1 ] && $bytes->[ $i + 1 ] <= -2
				|| 64 <= $bytes->[ $i + 1 ] && $bytes->[ $i + 1 ] <= 126 )
		  )
		{
			$l++;
			$l2 += 500;
			my $j1 = ( $bytes->[$i] + 256 ) - 129;
			my $i2;
			if ( 64 <= $bytes->[ $i + 1 ] && $bytes->[ $i + 1 ] <= 126 ) {
				$i2 = $bytes->[ $i + 1 ] - 64;
			}
			else {
				$i2 = ( $bytes->[ $i + 1 ] + 256 ) - 64;
			}
			if ( $GBKFreq->[$j1]->[$i2] != 0 ) {
				$l1 += $GBKFreq->[$j1]->[$i2];
			}
		}
		else {

		}
		$i++;
	}

	$f  = 50 * ( $l / $k );
	$f1 = 50 * ( $l1 / $l2 );
	return int( ( $f + $f1 ) - 1 );
}

sub big5_probability {
	my $bytes = shift;
	my $j     = 0;
	my $k     = 1;
	my $l     = 1;
	my $f     = 0;
	my $f1    = 0;
	my $l1    = 0;
	my $l2    = 1;
	$j = scalar(@$bytes);

	for ( my $i = 0 ; $i < $j - 1 ; $i++ ) {
		if ( $bytes->[$i] >= 0 ) {
			next;
		}
		$k++;
		if (
			   -95 <= $bytes->[$i]
			&& $bytes->[$i] <= -7
			&& (   64 <= $bytes->[ $i + 1 ] && $bytes->[ $i + 1 ] <= 126
				|| -95 <= $bytes->[ $i + 1 ] && $bytes->[ $i + 1 ] <= -2 )
		  )
		{
			$l++;
			$l2 += 500;
			my $i1 = ( $bytes->[$i] + 256 ) - 161;
			my $j1;
			if ( 64 <= $bytes->[ $i + 1 ] && $bytes->[ $i + 1 ] <= 126 ) {
				$j1 = $bytes->[ $i + 1 ] - 64;
			}
			else {
				$j1 = ( $bytes->[ $i + 1 ] + 256 ) - 97;
			}

			if ( $Big5Freq->[$i1]->[$j1] != 0 ) {

				$l1 += $Big5Freq->[$i1]->[$j1];
			}
			elsif ( 3 <= $i1 && $i1 <= 37 ) {
				$l1 += 200;
			}
		}
		$i++;
	}

	$f  = 50 * ( $l / $k );
	$f1 = 50 * ( $l1 / $l2 );
	return int( $f + $f1 );
}

sub euc_jp_probability {
	my $bytes = shift;
	my $j     = 0;
	my $k     = 1;
	my $l     = 1;
	my $l1    = 0;
	my $l2    = 1;
	my $f     = 0;
	my $f1    = 0;
	$j = scalar(@$bytes);

	for ( my $i = 0 ; $i < $j - 1 ; $i++ ) {
		if ( $bytes->[$i] >= 0 ) {
			next;
		}
		$k++;
		if (   -95 <= $bytes->[$i]
			&& $bytes->[$i] <= -2
			&& -95 <= $bytes->[ $i + 1 ]
			&& $bytes->[ $i + 1 ] <= -2 )
		{
			$l++;
			$l2 += 500;
			my $i1 = ( $bytes->[$i] + 256 ) - 161;
			my $j1 = ( $bytes->[ $i + 1 ] + 256 ) - 161;
			if ( $JPFreq->[$i1]->[$j1] != 0 ) {

				$l1 += $JPFreq->[$i1]->[$j1];
			}
			elsif ( 15 <= $i1 && $i1 < 55 ) {
				$l1 += 0;
			}
			else {

			}
		}
		$i++;
	}

	$f  = 50 * ( $l / $k );
	$f1 = 50 * ( $l1 / $l2 );
	return int( $f + $f1 );
}

sub iso_2022_kr_probability {
	my $bytes = shift;
	my $len   = scalar(@$bytes);
	for ( my $i = 0 ; $i < $len ; $i++ ) {
		if (   $i + 3 < $len
			&& $bytes->[$i] == 27
			&& $bytes->[ $i + 1 ] == 36
			&& $bytes->[ $i + 2 ] == 41
			&& $bytes->[ $i + 3 ] == 67 )
		{
			return 100;
		}
	}
	return 0;
}

sub iso_2022_jp_probability {
	my $bytes = shift;
	my $len   = scalar(@$bytes);
	for ( my $i = 0 ; $i < $len ; $i++ ) {
		if (   $i + 2 < $len
			&& $bytes->[$i] == 27
			&& $bytes->[ $i + 1 ] == 36
			&& $bytes->[ $i + 2 ] == 66 )
		{
			return 100;
		}
	}
	return 0;
}

sub sjis_probability {
	my $bytes = shift;
	my $j     = 0;
	my $k     = 1;
	my $l     = 1;
	my $l1    = 0;
	my $l2    = 1;
	my $f     = 0;
	my $f1    = 0;
	$j = scalar(@$bytes);

	for ( my $i = 0 ; $i < $j - 1 ; $i++ ) {
		if ( $bytes->[$i] >= 0 ) {
			next;
		}
		$k++;
		if (
			$i + 1 < $j
			&& (   -127 <= $bytes->[$i] && $bytes->[$i] <= -97
				|| -32 <= $bytes->[$i] && $bytes->[$i] <= -17 )
			&& (   64 <= $bytes->[ $i + 1 ] && $bytes->[ $i + 1 ] <= 126
				|| -128 <= $bytes->[ $i + 1 ] && $bytes->[ $i + 1 ] <= -4 )
		  )
		{
			$l++;
			$l2 += 500;
			my $i1 = $bytes->[$i] + 256;
			my $j1 = $bytes->[ $i + 1 ] + 256;
			my $k1;
			if ( $j1 < 159 ) {
				$k1 = 1;
				if ( $j1 > 127 ) {
					$j1 -= 32;
				}
				else {
					$j1 -= 25;
				}
			}
			else {
				$k1 = 0;
				$j1 -= 126;
			}
			if ( $i1 < 160 ) {
				$i1 = ( $i1 - 112 << 1 ) - $k1;
			}
			else {
				$i1 = ( $i1 - 176 << 1 ) - $k1;
			}
			$i1 -= 32;
			$j1 = 32;
			if ( $i1 < 94 && $j1 < 94 && $JPFreq->[$i1]->[$j1] != 0 ) {
				$l1 += $JPFreq->[$i1]->[$j1];
			}
			$i++;
			next;
		}

		#it seems useless, but ... source is
		#            if(-95 <= $bytes->[$i]){
		#                if($bytes->[$i] > -33){};
		#            }
	}

	$f  = 50 * ( $l / $k );
	$f1 = 50 * ( $l1 / $l2 );
	return int( $f + $f1 ) - 1;
}

sub euc_kr_probability {
	my $bytes = shift;
	my $j     = 0;
	my $k     = 1;
	my $l     = 1;
	my $l1    = 0;
	my $l2    = 1;
	my $f     = 0;
	my $f1    = 0;
	$j = scalar(@$bytes);

	for ( my $i = 0 ; $i < $j - 1 ; $i++ ) {
		if ( $bytes->[$i] >= 0 ) {
			next;
		}
		$k++;
		if (   -95 <= $bytes->[$i]
			&& $bytes->[$i] <= -2
			&& -95 <= $bytes->[ $i + 1 ]
			&& $bytes->[ $i + 1 ] <= -2 )
		{
			$l++;
			$l2 += 500;
			my $i1 = ( $bytes->[$i] + 256 ) - 161;
			my $j1 = ( $bytes->[ $i + 1 ] + 256 ) - 161;
			if ( $KRFreq->[$i1]->[$j1] != 0 ) {
				$l1 += $KRFreq->[$i1]->[$j1];
			}
			elsif ( 15 <= $i1 && $i1 < 55 ) {
				$l1 += 0;
			}
			else {
			}
		}
		$i++;
	}

	$f  = 50 * ( $l / $k );
	$f1 = 50 * ( $l1 / $l2 );
	return int( $f + $f1 );
}
1;

__END__

=head1 NAME

Encode::Detect::CJK - A Charset Detector, optimized for EastAsia charset and website content

=head1 SYNOPSIS

	use Encode::Detect::CJK; #just use
	
	use Encode::Detect::CJK qw(detect); #use and export function 
	
	#simple use it
	my $charset=CharsetDetector::detect($octets);
	
	#use it with advanced option
	my $charset = CharsetDetector::detect($octets,$max_len,$is_consider_html_head_charset);
	#return the charset of binary string $octets
	#$max_len if $octets 's size is big, will make detect slow, sometimes you need specify $max_len for detect,null is for DEFAULT(unlimit max_len)
	#$is_consider_html_header_charset, by DEFAULT, detetor will consider 
	#	html header (e.g. <meta http-equiv="Content-Type" content="text/html; charset=utf-8" /> ) as a factor to detect charset, 
	#	if you don't want detetor to consider html header as a factor, set $is_consider_html_header_charset to "" or 0

=head1 Basic Function

=head2 detect - detect the charset of string

	$charset=CharsetDetector::detect($octets,$max_len,$is_consider_html_head_charset);
	$charset=CharsetDetector::detect($octets,$max_len);#CharsetDetector::detect($octets,$max_len,1);
	$charset=CharsetDetector::detect($octets);#same as CharsetDetector::detect($octets,undef);

=head3 Param $octets - input binary string

input binary string

=head3 Param $max_len - max length for charset detector

if $octets 's size is big, will make detect slow, sometimes you need specify $max_len for detect,null is for DEFAULT(unlimit max_len)
DEFAULT is unlimit

=head3 Param $is_consider_html_head_charset 

by DEFAULT, detetor will consider 
html header (e.g. <meta http-equiv="Content-Type" content="text/html; charset=utf-8" /> ) as a factor to detect charset, 
if you don't want detetor to consider html header as a factor, set $is_consider_html_header_charset to "" or 0

=head3 Return Value $charset 

if $octets is null return ''
if $octets is '' return 'iso-8859-1'

=head1 supported charset list

	return value: alias
	
	ascii       : ascii
	iso-8859-1  : iso-8859-1
	utf8        : utf8 utf-8-strict
	utf16       : utf16
	cp936       : euc-cn(gb2312) cp936(gbk) gb18030
	big5-eten   : big5-eten
	euc-jp      : euc-jp
	shiftjis    : shiftjis
	iso-2022-jp : iso-2022-jp
	euc-kr      : euc-kr
	iso-2022-kr : iso-2022-kr

=head1 COPYRIGHT

The CharsetDetector module is Copyright (c) 2003-2008 QIAN YU.
All rights reserved.

You may distribute under the terms of either the GNU General Public
License or the Artistic License, as specified in the Perl README file.

