package Task::Padre::Plugins;

use warnings;
use strict;

our $VERSION = '0.22';

1;
__END__

=head1 NAME

Task::Padre::Plugins - Get many Plugins of Padre at once

=head1 SYNOPSIS

Most plugins will just run with the text you selected if there is any selection.

If not, they run with the whole text from selected document.

=head1 MODULES

=head2 L<Padre::Plugin::AcmePlayCode>

L<Acme::PlayCode> Plugin for L<Padre>

See L<Padre::Plugin::AcmePlayCode>

=head2 L<Padre::Plugin::Alarm>

Alarm Clock in Padre

See L<Padre::Plugin::Alarm>

=head2 L<Padre::Plugin::Autoformat>

reformat your text within Padre

See L<Padre::Plugin::Autoformat>

=head2 L<Padre::Plugin::CSS>

L<Padre> and CSS

See L<Padre::Plugin::CSS>

=head2 L<Padre::Plugin::Catalyst>

Simple Catalyst helper interface for Padre

See L<Padre::Plugin::Catalyst>

=head2 L<Padre::Plugin::CommandLine>

vi and emacs in Padre ?

See L<Padre::Plugin::CommandLine>

=head2 L<Padre::Plugin::DataWalker>

Simple Perl data structure browser Padre

See L<Padre::Plugin::DataWalker>

=head2 L<Padre::Plugin::Debugger>

Debug Perl code from Padre editor

See L<Padre::Plugin::Debugger>

=head2 L<Padre::Plugin::Ecliptic>

Padre plugin that provides Eclipse-like useful features

See L<Padre::Plugin::Ecliptic>

=head2 L<Padre::Plugin::Encode>

convert file to different encoding in Padre

See L<Padre::Plugin::Encode>

=head2 L<Padre::Plugin::Encrypt>

encrypt/decrypt file in Padre

See L<Padre::Plugin::Encrypt>

=head2 L<Padre::Plugin::Git>

Simple Git interface for Padre

See L<Padre::Plugin::Git>

=head2 L<Padre::Plugin::HTML>

L<Padre> and HTML

See L<Padre::Plugin::HTML>

=head2 L<Padre::Plugin::HTMLExport>

export highlighted HTML in Padre

See L<Padre::Plugin::HTMLExport>

=head2 L<Padre::Plugin::InstallPARDist>

Installation of .par archives into the system

See L<Padre::Plugin::InstallPARDist>

=head2 L<Padre::Plugin::JavaScript>

L<Padre> and JavaScript

See L<Padre::Plugin::JavaScript>

=head2 L<Padre::Plugin::Mojolicious>

Simple Mojolicious helper interface for Padre

See L<Padre::Plugin::Mojolicious>

=head2 L<Padre::Plugin::Nopaste>

send code on a nopaste website from padre

See L<Padre::Plugin::Nopaste>

=head2 L<Padre::Plugin::PAR>

PAR generation from Padre

See L<Padre::Plugin::PAR>

=head2 L<Padre::Plugin::PSI>

Experimental Padre plugin written in Perl 6

See L<Padre::Plugin::PSI>

=head2 L<Padre::Plugin::Parrot>

Experimental Padre plugin that runs on Parrot

See L<Padre::Plugin::Parrot>

=head2 L<Padre::Plugin::Perl6>

Padre plugin for Perl6

See L<Padre::Plugin::Perl6>

=head2 L<Padre::Plugin::PerlCritic>

Analyze perl files with Perl::Critic

See L<Padre::Plugin::PerlCritic>

=head2 L<Padre::Plugin::PerlTidy>

Format perl files using Perl::Tidy

See L<Padre::Plugin::PerlTidy>

=head2 L<Padre::Plugin::SVK>

Simple SVK interface for Padre

See L<Padre::Plugin::SVK>

=head2 L<Padre::Plugin::SVN>

Simple SVN interface for Padre

See L<Padre::Plugin::SVN>

=head2 L<Padre::Plugin::SpellCheck>

check spelling in Padre

See L<Padre::Plugin::SpellCheck>

=head2 L<Padre::Plugin::Vi>

vi keyboard for Padre

See L<Padre::Plugin::Vi>

=head2 L<Padre::Plugin::ViewInBrowser>

view selected doc in browser for L<Padre>

See L<Padre::Plugin::ViewInBrowser>

=head2 L<Padre::Plugin::XML>

L<Padre> and XML

See L<Padre::Plugin::XML>

=head1 AUTHOR

Gabor Szabo, C<< <szabgab at gmail.com> >>

=head1 BUGS

Please report any bugs or feature requests to L<http://padre.perlide.org/>

=head1 SUPPORT

You can find documentation for Padre on L<http://padre.perlide.org/>

=head1 COPYRIGHT & LICENSE

Copyright 2008-2009 Gabor Szabo, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

